# TLDR

**Process a BibLaTeX bibliography**

```biber [document]```

**Process with a specific output directory**

```biber -O [output_dir] [document]```

**Validate data** against the data model

```biber --validate-datamodel [document]```

**Process with quiet output**

```biber -q [document]```

**Enable tracing** for debugging

```biber --trace [document]```

**Specify output format**

```biber --output_format [bbl] [document]```

**Process all .bib files** in a directory

```biber --glob [*.bib]```

# SYNOPSIS

**biber** [_options_] _file_[.bcf]

# DESCRIPTION

**biber** is a modern bibliography processor designed as a replacement for BibTeX, serving as the backend for the biblatex package in LaTeX documents. It provides advanced sorting, filtering, and Unicode support.

Biber reads a **.bcf** (biblatex control file) generated by LaTeX and produces a **.bbl** file containing the formatted bibliography. It supports multiple bibliography databases and offers extensive configuration options.

# PARAMETERS

**-O, --output_directory** _dir_
> Directory where output files will be written

**--output** _file_
> Output to specific file instead of basename.bbl

**--output_format** _format_
> Output format: bbl (default), bibtex, xml, json

**--input_encoding** _encoding_
> Character encoding for input files (default: UTF-8)

**--output_encoding** _encoding_
> Character encoding for output files (default: UTF-8)

**-V, --validate-datamodel**
> Validate data against the data model

**--validate-control**
> Schema validate the .bcf control file

**-q, --quiet**
> Log only errors; use twice to suppress all output

**--trace**
> Enable low-level tracing for debugging

**-l, --logfile** _file_
> Write log messages to specified file

**--nolog**
> Do not write any logfile

**-v, --version**
> Display version number

# CAVEATS

Biber requires a **.bcf** file generated by running LaTeX with biblatex first. The typical workflow is: pdflatex -> biber -> pdflatex -> pdflatex. Biber is not a drop-in replacement for BibTeX; it requires the biblatex package.

# HISTORY

Biber was created by **Philip Kime** and **Fran├ºois Charette** starting in **2009** to address limitations in BibTeX, particularly around Unicode support and advanced sorting. It became the recommended backend for biblatex and is now the standard for modern LaTeX bibliography processing.

# SEE ALSO

[bibtex](/man/bibtex)(1), [pdflatex](/man/pdflatex)(1), [latex](/man/latex)(1)
