# TLDR

**Initialize Alembic** in a project

```alembic init [alembic]```

**Create a new migration** revision

```alembic revision -m "[Add users table]"```

**Auto-generate a migration** from model changes

```alembic revision --autogenerate -m "[Add email column]"```

**Upgrade to the latest** migration

```alembic upgrade head```

**Upgrade to a specific revision**

```alembic upgrade [revision_id]```

**Downgrade by one revision**

```alembic downgrade -1```

**Show current revision**

```alembic current```

**Display migration history**

```alembic history```

# SYNOPSIS

**alembic** [_options_] _command_ [_command_options_]

# PARAMETERS

**init** _directory_
> Initialize a new Alembic environment in the specified directory.

**revision** [_-m message_] [_--autogenerate_]
> Create a new migration revision file.

**upgrade** _revision_
> Upgrade database to a target revision (use 'head' for latest).

**downgrade** _revision_
> Downgrade database to a target revision (use '-1' for one step back).

**current**
> Show the current revision of the database.

**history**
> List revision history.

**heads**
> Show all current head revisions.

**branches**
> Show all branch points.

**stamp** _revision_
> Set the revision table to a specific version without running migrations.

**show** _revision_
> Display details of a specific revision.

**merge** _revisions_ [_-m message_]
> Merge multiple branch heads into one.

**-c**, **--config** _file_
> Path to alembic.ini configuration file.

**-n**, **--name** _name_
> Name of config section to use.

**-x** _key=value_
> Pass additional arguments to env.py.

**--autogenerate**
> Auto-generate migration by comparing models to database.

**--sql**
> Output SQL instead of applying migrations.

# DESCRIPTION

**Alembic** is a database migration tool for SQLAlchemy, Python's popular ORM. It manages incremental, reversible changes to database schemas through version-controlled migration scripts.

Migrations are Python files stored in a versions directory. Each migration has an upgrade() function to apply changes and a downgrade() function to reverse them. Alembic tracks the current database state in a special table, allowing it to determine which migrations need to run.

The **--autogenerate** feature compares SQLAlchemy model definitions against the current database schema to automatically generate migration scripts. While convenient, generated migrations should be reviewed as autogenerate cannot detect all types of changes.

Configuration is stored in **alembic.ini**, which specifies the database URL, migration script location, and other settings. The **env.py** script in the alembic directory handles migration environment setup and can be customized for complex scenarios.

# CAVEATS

Autogenerate cannot detect all changes (table renames, column type changes on some databases, constraint name changes). Always review generated migrations. Downgrade functions must be manually written or verified for autogenerated migrations. Database URL in alembic.ini may contain credentials that should not be committed.

# HISTORY

**Alembic** was created by Mike Bayer, the author of SQLAlchemy, with the first release in **2011**. It was designed to provide a migration solution that integrates naturally with SQLAlchemy's metadata and model system. The name comes from the alchemical vessel used for distillation, fitting the SQLAlchemy naming theme.

# SEE ALSO

[flask-migrate](/man/flask-migrate)(1), [django-admin](/man/django-admin)(1), [sqlalchemy](/man/sqlalchemy)(1), [psql](/man/psql)(1)
