@file:OptIn(ExperimentalVoiceApi::class)

package com.inspiredandroid.kai.screenshots

import androidx.compose.material3.ColorScheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.ui.platform.LocalInspectionMode
import app.cash.paparazzi.DeviceConfig
import app.cash.paparazzi.Paparazzi
import com.inspiredandroid.kai.ui.DarkColorScheme
import com.inspiredandroid.kai.ui.LightColorScheme
import com.inspiredandroid.kai.ui.Theme
import com.inspiredandroid.kai.ui.chat.ChatScreenContent
import com.inspiredandroid.kai.ui.explore.ExploreScreenContent
import com.inspiredandroid.kai.ui.settings.SettingsScreenContent
import nl.marc_apps.tts.TextToSpeechInstance
import nl.marc_apps.tts.experimental.ExperimentalVoiceApi
import nl.marc_apps.tts.rememberTextToSpeechOrNull
import org.jetbrains.compose.resources.ExperimentalResourceApi
import org.jetbrains.compose.resources.setResourceReaderAndroidContext
import org.junit.Before
import org.junit.Rule
import org.junit.Test

@OptIn(ExperimentalResourceApi::class)
class ScreenshotTest {

    @get:Rule
    val paparazzi = Paparazzi(
        deviceConfig = DeviceConfig.PIXEL_9A.copy(softButtons = false),
        showSystemUi = true,
        maxPercentDifference = 0.1,
    )

    @Before
    fun setup() {
        setResourceReaderAndroidContext(paparazzi.context)
    }

    fun Paparazzi.snap(
        colorScheme: ColorScheme,
        content: @Composable () -> Unit,
    ) {
        val theme = if (colorScheme == DarkColorScheme) {
            "android:Theme.Material.NoActionBar"
        } else {
            "android:Theme.Material.Light.NoActionBar"
        }
        unsafeUpdateConfig(theme = theme)

        snapshot {
            CompositionLocalProvider(LocalInspectionMode provides true) {
                Theme(colorScheme = colorScheme) {
                    content()
                }
            }
        }
    }

    @Test
    fun chatEmptyState_light() {
        paparazzi.snap(LightColorScheme) {
            ChatScreenContent(
                uiState = ScreenshotTestData.chatEmptyState,
                FakeTextToSpeechInstance(),
            )
        }
    }

    @Test
    fun chatWithMessages_dark() {
        paparazzi.snap(DarkColorScheme) {
            ChatScreenContent(
                uiState = ScreenshotTestData.chatWithMessages,
                FakeTextToSpeechInstance(),
            )
        }
    }

    @Test
    fun chatWithCodeExample_light() {
        paparazzi.snap(LightColorScheme) {
            ChatScreenContent(
                uiState = ScreenshotTestData.chatWithCodeExample,
                FakeTextToSpeechInstance(),
            )
        }
    }

    @Test
    fun settingsFree_dark() {
        paparazzi.snap(DarkColorScheme) {
            SettingsScreenContent(uiState = ScreenshotTestData.freeConnected)
        }
    }

    @Test
    fun settingsTools_light() {
        paparazzi.snap(LightColorScheme) {
            SettingsScreenContent(uiState = ScreenshotTestData.settingsTools)
        }
    }

    @Test
    fun exploreSpace_dark() {
        paparazzi.snap(DarkColorScheme) {
            ExploreScreenContent(
                uiState = ScreenshotTestData.exploreSpace,
                topic = "Space Exploration",
            )
        }
    }
}
