package com.hardcodecoder.pulsemusic.tag;

import android.content.Context;
import android.database.Cursor;
import android.os.Build;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.hardcodecoder.pulsemusic.loaders.MediaStoreHelper;
import com.hardcodecoder.pulsemusic.model.AudioFileModel;
import com.hardcodecoder.pulsemusic.model.MusicModel;

import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;

public class UpdatedMusicFetcher implements Callable<MusicModel> {

    private final WeakReference<Context> mContextReference;
    private final AudioFileModel mAudioFile;

    public UpdatedMusicFetcher(@NonNull Context context, @NonNull AudioFileModel audioFile) {
        mContextReference = new WeakReference<>(context);
        mAudioFile = audioFile;
    }

    @Override
    @Nullable
    public MusicModel call() {
        Context context = mContextReference.get();
        if (null == context) return null;

        final int skdInt = Build.VERSION.SDK_INT;

        final Cursor cursor = context.getContentResolver()
                .query(mAudioFile.getAudioUri(),
                        MediaStoreHelper.getMediaAudioColumns(skdInt),
                        null,
                        null,
                        null);

        if (null == cursor || !cursor.moveToFirst()) {
            if (null != cursor) cursor.close();
            return null;
        }
        return MediaStoreHelper.getModelFromCursor(cursor, cursor.getInt(0), skdInt);
    }
}