package com.hardcodecoder.pulsemusic.tag;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.hardcodecoder.pulsemusic.utils.LogUtils;

import java.io.File;

import static com.hardcodecoder.pulsemusic.utils.LogUtils.Type.IO;

public final class TagUtils {

    private static final String TAG = TagUtils.class.getSimpleName();
    private static final String WORKING_DIRECTORY = "working";

    private TagUtils() {
    }

    @Nullable
    public static String getOrCreateWorkingDirectoryPath(@NonNull Context context) {
        String externalFilesDir = context.getExternalFilesDir(null).getAbsolutePath();
        File workingDir = new File(externalFilesDir + File.separator + WORKING_DIRECTORY);

        if (workingDir.exists()) return workingDir.getAbsolutePath();
        if (workingDir.mkdir()) return workingDir.getAbsolutePath();

        LogUtils.logInfo(TAG, "at: getOrCreateWorkingDirectoryPath(): Failed to create temp directory: " + workingDir.getAbsolutePath());
        return null;
    }

    @Nullable
    public static String getWorkingDirectoryPath(@NonNull Context context) {
        String externalFilesDir = context.getExternalFilesDir(null).getAbsolutePath();
        File workingDir = new File(externalFilesDir + File.separator + WORKING_DIRECTORY);
        if (workingDir.exists()) return workingDir.getAbsolutePath();
        return null;
    }

    @NonNull
    public static File getArtworkFile(@NonNull String workingDirPath) {
        return new File(workingDirPath + File.separator + "artwork.jpg");
    }

    public static int parseIntOrDefault(@Nullable String str) {
        if (null == str || str.isEmpty()) return 0;
        if (str.matches("[0-9]+")) return Integer.parseInt(str);
        return 0;
    }

    @NonNull
    public static int[] parseAudioTrackRepresentation(@Nullable String str) {
        int[] values = new int[]{0, 0};
        if (null == str || str.trim().isEmpty()) return values;
        try {
            if (str.contains("/")) {
                // We have a string representation like 1/8
                int indexOfSep = str.indexOf("/");
                values[0] = Integer.parseInt(str.substring(0, indexOfSep));
                values[1] = Integer.parseInt(str.substring(indexOfSep));
            } else if (str.matches("[0-9]+")) {
                values[0] = Integer.parseInt(str);
            }
        } catch (Exception e) {
            LogUtils.logException(IO, AudioTagReader.class.getSimpleName(),
                    "at getNumber() with input:" + str, e);
        }
        return values;
    }
}