package com.hardcodecoder.pulsemusic.tag;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;

import androidx.annotation.NonNull;

import com.hardcodecoder.pulsemusic.utils.LogUtils;
import com.hardcodecoder.pulsemusic.utils.PulseIOUtils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;

public class AudioArtworkReader implements Callable<Boolean> {

    private static final String TAG = AudioArtworkReader.class.getSimpleName();
    private final WeakReference<Context> mContextReference;
    private final Uri mUri;

    public AudioArtworkReader(@NonNull Context context, @NonNull Uri uri) {
        mContextReference = new WeakReference<>(context);
        mUri = uri;
    }

    @Override
    public Boolean call() {
        Context context = mContextReference.get();
        return saveAndReadArtwork(context);
    }

    private boolean saveAndReadArtwork(@NonNull Context context) {
        String workingDirPath = TagUtils.getOrCreateWorkingDirectoryPath(context);
        if (null == workingDirPath) return false;

        File artworkFile = TagUtils.getArtworkFile(workingDirPath);

        BufferedOutputStream outputStream = null;
        boolean success = false;

        try (InputStream inputStream = context.getContentResolver().openInputStream(mUri)) {

            outputStream = new BufferedOutputStream(new FileOutputStream(artworkFile));

            Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);

            success = true;
        } catch (IOException e) {
            LogUtils.logException(LogUtils.Type.IO, TAG, "at: saveAndReadArtwork()", e);
        } finally {
            PulseIOUtils.closeBufferedOutputStream(outputStream);
        }
        return success;
    }
}