package com.hardcodecoder.pulsemusic.model;

import androidx.annotation.NonNull;

public class TagModel {

    private final String mTitle;
    private final String mAlbum;
    private final String mAlbumArtist;
    private final String mArtist;
    private final int mTrackNumber;
    private final int mTrackCount;
    private final int mDiscNumber;
    private final int mDiscCount;
    private final String mYear;
    private final String mGenre;
    private final String mLyrics;

    public TagModel(@NonNull String title,
                    @NonNull String album,
                    @NonNull String albumArtist,
                    @NonNull String artist,
                    int trackNumber,
                    int trackCount,
                    int discNumber,
                    int discCount,
                    @NonNull String year,
                    @NonNull String genre,
                    @NonNull String lyrics) {
        mTitle = title;
        mAlbum = album;
        mAlbumArtist = albumArtist;
        mArtist = artist;
        mTrackNumber = trackNumber;
        mTrackCount = trackCount;
        mDiscNumber = discNumber;
        mDiscCount = discCount;
        mYear = year;
        mGenre = genre;
        mLyrics = lyrics;
    }

    @NonNull
    public String getTitle() {
        return mTitle;
    }

    @NonNull
    public String getAlbum() {
        return mAlbum;
    }

    @NonNull
    public String getAlbumArtist() {
        return mAlbumArtist;
    }

    @NonNull
    public String getArtist() {
        return mArtist;
    }

    public int getTrackNumber() {
        return mTrackNumber;
    }

    public int getTrackCount() {
        return mTrackCount;
    }

    public int getDiscNumber() {
        return mDiscNumber;
    }

    public int getDiscCount() {
        return mDiscCount;
    }

    @NonNull
    public String getYear() {
        // In sme cases empty string is treated as null by jAudiotagger bug?
        return mYear.isEmpty() ? "1970-01-01" : mYear;
    }

    @NonNull
    public String getGenre() {
        return mGenre;
    }

    @NonNull
    public String getLyrics() {
        return mLyrics;
    }

    @NonNull
    @Override
    public String toString() {
        return "Title: " + mTitle + "\n" +
                "Album: " + mAlbum + "\n" +
                "AlbumArtist: " + mAlbumArtist + "\n" +
                "Artist: " + mArtist + "\n" +
                "Track count: " + mTrackCount + "\n" +
                "Track number: " + mTrackNumber + "\n" +
                "Disc number: " + mDiscNumber + "\n" +
                "Disc count: " + mDiscCount + "\n" +
                "Year: " + mYear + "\n" +
                "Genre: " + mGenre + "\n" +
                "Lyrics: " + mLyrics;
    }
}