package com.hardcodecoder.pulsemusic.glide;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class MediaArtwork {

    private final String mArtworkUri;
    private final String mMediaUri;
    private final long mLastModified;

    public MediaArtwork(@NonNull String artworkUri, @NonNull String mediaContentUri, long lastModified) {
        mArtworkUri = artworkUri;
        mMediaUri = mediaContentUri;
        mLastModified = lastModified;
    }

    @NonNull
    public String getArtworkUri() {
        return mArtworkUri;
    }

    @NonNull
    public String getMediaUri() {
        return mMediaUri;
    }

    public long getLastModified() {
        return mLastModified;
    }

    @NonNull
    @Override
    public String toString() {
        return mArtworkUri + mMediaUri + mLastModified;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof MediaArtwork)) return false;
        MediaArtwork artwork = (MediaArtwork) obj;
        return mArtworkUri.equals(artwork.getArtworkUri()) &&
                mMediaUri.equals(artwork.getMediaUri());
    }
}