package com.grappim.hateitorrateit.feature.details.ui

import com.grappim.hateitorrateit.data.repoapi.ProductsRepository
import com.grappim.hateitorrateit.feature.details.ui.mappers.UiModelsMapper
import com.grappim.hateitorrateit.feature.details.ui.navigation.ProductImageNavDestination
import com.grappim.hateitorrateit.feature.details.ui.productimage.ProductImageViewModel
import com.grappim.hateitorrateit.testing.core.SavedStateHandleRule
import com.grappim.hateitorrateit.testing.domain.PRODUCT_ID
import com.grappim.hateitorrateit.testing.domain.createEditProduct
import com.grappim.hateitorrateit.testing.domain.editProductImages
import io.mockk.coEvery
import io.mockk.coVerify
import io.mockk.mockk
import kotlinx.coroutines.test.runTest
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith
import org.robolectric.RobolectricTestRunner
import kotlin.test.assertEquals

@RunWith(RobolectricTestRunner::class)
class ProductImageViewModelTest {

    private val index = 0
    private val route = ProductImageNavDestination(PRODUCT_ID, index)

    @get:Rule
    val savedStateHandleRule = SavedStateHandleRule(route)

    private val productsRepository: ProductsRepository = mockk()
    private val uiModelsMapper: UiModelsMapper = mockk()

    private lateinit var vm: ProductImageViewModel

    @Test
    fun `on init should update state with correct data`() = runTest {
        val product = createEditProduct(editProductImages)
        val productUi = createProductDetailsImageUi()

        coEvery { productsRepository.getProductById(any()) } returns product
        coEvery { uiModelsMapper.toProductDetailsImageUI(any()) } returns productUi

        vm = ProductImageViewModel(
            productsRepository = productsRepository,
            uiModelsMapper = uiModelsMapper,
            savedStateHandle = savedStateHandleRule.savedStateHandleMock
        )

        coVerify { productsRepository.getProductById(PRODUCT_ID) }
        coVerify { uiModelsMapper.toProductDetailsImageUI(product) }

        assertEquals(vm.viewState.value.uri, productUi.images[index].uriString)
    }
}
