package com.grappim.hateitorrateit.utils.filesimpl.file.pathmanager

import android.content.Context
import android.os.Environment
import com.grappim.hateitorrateit.utils.filesapi.pathmanager.FolderPathManager
import dagger.hilt.android.qualifiers.ApplicationContext
import timber.log.Timber
import java.io.File
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class FolderPathManagerImpl @Inject constructor(@ApplicationContext private val context: Context) :
    FolderPathManager {

    /**
     * /data/data/com.grappim.hateitorrateit/files/products/1_2024-01-23_20-04-41/
     */
    override fun getMainFolder(productFolder: String): File {
        val folder = File(context.filesDir, "products/$productFolder")
        if (folder.exists().not()) {
            folder.mkdirs()
        }
        Timber.d("getMainFolder: $folder")
        return folder
    }

    /**
     * /data/data/com.grappim.hateitorrateit/files/products/1_2024-01-23_20-04-41_temp/
     */
    override fun getTempFolderName(folder: String): String = "${folder}_temp"

    /**
     * /data/data/com.grappim.hateitorrateit/files/products/1_2024-01-23_20-04-41_backup/
     */
    override fun getBackupFolderName(folder: String): String = "${folder}_backup"

    override fun getBackupParentFolder(): File =
        Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS)

    override fun getBackupChildFolderName(): String = "hior"
}
