import type IntWrapper from "./intWrapper";
import type BitVector from "../vector/flat/bitVector";
import { type StreamMetadata } from "../mltMetadata";
import { type RleEncodedStreamMetadata } from "../metadata/tile/streamMetadataDecoder";
export declare function decodeVarintInt32(buf: Uint8Array, bufferOffset: IntWrapper, numValues: number): Int32Array;
export declare function decodeVarintInt64(src: Uint8Array, offset: IntWrapper, numValues: number): BigInt64Array;
export declare function decodeVarintFloat64(src: Uint8Array, numValues: number, offset: IntWrapper): Float64Array;
export declare function decodeFastPfor(data: Uint8Array, numValues: number, byteLength: number, offset: IntWrapper): Int32Array;
export declare function decodeZigZag(encodedData: Int32Array): void;
export declare function decodeZigZagInt64(encodedData: BigInt64Array): void;
export declare function decodeZigZagFloat64(encodedData: Float64Array): void;
export declare function decodeZigZagValue(encoded: number): number;
export declare function decodeZigZagValueInt64(encoded: bigint): bigint;
export declare function decodeRle(data: Int32Array, streamMetadata: RleEncodedStreamMetadata, isSigned: boolean): Int32Array;
export declare function decodeRleInt64(data: BigInt64Array, streamMetadata: RleEncodedStreamMetadata, isSigned: boolean): BigInt64Array;
export declare function decodeRleFloat64(data: Float64Array, streamMetadata: RleEncodedStreamMetadata, isSigned: boolean): Float64Array;
export declare function decodeUnsignedRle(encodedData: Int32Array, numRuns: number, numTotalValues: number): Int32Array;
export declare function decodeUnsignedRleInt64(encodedData: BigInt64Array, numRuns: number, numTotalValues: number): BigInt64Array;
export declare function decodeUnsignedRleFloat64(encodedData: Float64Array, numRuns: number, numTotalValues: number): Float64Array;
export declare function decodeZigZagDelta(data: Int32Array): void;
export declare function decodeZigZagDeltaInt64(data: BigInt64Array): void;
export declare function decodeZigZagDeltaFloat64(data: Float64Array): void;
export declare function decodeZigZagRle(data: Int32Array, numRuns: number, numTotalValues: number): Int32Array;
export declare function decodeZigZagRleInt64(data: BigInt64Array, numRuns: number, numTotalValues: number): BigInt64Array;
export declare function decodeZigZagRleFloat64(data: Float64Array, numRuns: number, numTotalValues: number): Float64Array;
export declare function fastInverseDelta(data: Int32Array): void;
export declare function inverseDelta(data: Int32Array): void;
export declare function decodeComponentwiseDeltaVec2(data: Int32Array): void;
export declare function decodeComponentwiseDeltaVec2Scaled(data: Int32Array, scale: number, min: number, max: number): void;
export declare function decodeNullableZigZagDelta(bitVector: BitVector, data: Int32Array): Int32Array;
export declare function decodeNullableZigZagDeltaInt64(bitVector: BitVector, data: BigInt64Array): BigInt64Array;
export declare function zigZagDeltaOfDeltaDecoding(data: Int32Array): Int32Array;
export declare function zigZagRleDeltaDecoding(data: Int32Array, numRuns: number, numTotalValues: number): Int32Array;
export declare function rleDeltaDecoding(data: Int32Array, numRuns: number, numTotalValues: number): Int32Array;
export declare function padWithZeros(bitVector: BitVector, data: Int32Array): Int32Array;
export declare function padZigZagWithZeros(bitVector: BitVector, data: Int32Array): Int32Array;
export declare function padWithZerosInt64(bitVector: BitVector, data: BigInt64Array): BigInt64Array;
export declare function padZigZagWithZerosInt64(bitVector: BitVector, data: BigInt64Array): BigInt64Array;
export declare function decodeNullableRle(data: Int32Array, streamMetadata: StreamMetadata, isSigned: boolean, bitVector: BitVector): Int32Array;
export declare function decodeNullableRleInt64(data: BigInt64Array, streamMetadata: StreamMetadata, isSigned: boolean, bitVector: BitVector): BigInt64Array;
/**
 * Decode Delta-RLE with multiple runs by fully reconstructing values.
 *
 * @param data RLE encoded data: [run1, run2, ..., value1, value2, ...]
 * @param numRuns Number of runs in the RLE encoding
 * @param numValues Total number of values to reconstruct
 * @returns Reconstructed values with deltas applied
 */
export declare function decodeDeltaRle(data: Int32Array, numRuns: number, numValues: number): Int32Array;
/**
 * Decode Delta-RLE with multiple runs for 64-bit integers.
 */
export declare function decodeDeltaRleInt64(data: BigInt64Array, numRuns: number, numValues: number): BigInt64Array;
export declare function decodeUnsignedConstRle(data: Int32Array): number;
export declare function decodeZigZagConstRle(data: Int32Array): number;
export declare function decodeZigZagSequenceRle(data: Int32Array): [baseValue: number, delta: number];
export declare function decodeUnsignedConstRleInt64(data: BigInt64Array): bigint;
export declare function decodeZigZagConstRleInt64(data: BigInt64Array): bigint;
export declare function decodeZigZagSequenceRleInt64(data: BigInt64Array): [baseValue: bigint, delta: bigint];
