import * as msg from './messages';
import * as structs from './structs';
import { Nfsv4LockType } from './constants';
export declare const nfs: {
    PUTROOTFH(): msg.Nfsv4PutrootfhRequest;
    PUTFH(fh: structs.Nfsv4Fh): msg.Nfsv4PutfhRequest;
    PUTPUBFH(): msg.Nfsv4PutpubfhRequest;
    GETFH(): msg.Nfsv4GetfhRequest;
    LOOKUP(name: string): msg.Nfsv4LookupRequest;
    LOOKUPP(): msg.Nfsv4LookuppRequest;
    GETATTR(attrBitmap: number[]): msg.Nfsv4GetattrRequest;
    READDIR(attrBitmap: number | number[], cookieverf?: Uint8Array, cookie?: bigint, dircount?: number, maxcount?: number): msg.Nfsv4ReaddirRequest;
    ACCESS(accessMask?: number): msg.Nfsv4AccessRequest;
    READ(offset: bigint, count: number, stateid?: structs.Nfsv4Stateid): msg.Nfsv4ReadRequest;
    WRITE(stateid: structs.Nfsv4Stateid, offset: bigint, stable: number, data: Uint8Array): msg.Nfsv4WriteRequest;
    COMMIT(offset: bigint, count: number): msg.Nfsv4CommitRequest;
    CREATE(objtype: structs.Nfsv4CreateType, objname: string, createattrs: structs.Nfsv4Fattr): msg.Nfsv4CreateRequest;
    LINK(newname: string): msg.Nfsv4LinkRequest;
    READLINK(): msg.Nfsv4ReadlinkRequest;
    SAVEFH(): msg.Nfsv4SavefhRequest;
    RESTOREFH(): msg.Nfsv4RestorefhRequest;
    SETATTR(stateid: structs.Nfsv4Stateid, attrs: structs.Nfsv4Fattr): msg.Nfsv4SetattrRequest;
    VERIFY(attrs: structs.Nfsv4Fattr): msg.Nfsv4VerifyRequest;
    NVERIFY(attrs: structs.Nfsv4Fattr): msg.Nfsv4NverifyRequest;
    REMOVE(name: string): msg.Nfsv4RemoveRequest;
    RENAME(oldname: string, newname: string): msg.Nfsv4RenameRequest;
    RENEW(clientid: bigint): msg.Nfsv4RenewRequest;
    SETCLIENTID(client: structs.Nfsv4ClientId, callback: structs.Nfsv4CbClient, callbackIdent: number): msg.Nfsv4SetclientidRequest;
    SETCLIENTID_CONFIRM(clientid: bigint, verifier: structs.Nfsv4Verifier): msg.Nfsv4SetclientidConfirmRequest;
    OPEN(seqid: number, shareAccess: number, shareDeny: number, owner: structs.Nfsv4OpenOwner, openhow: structs.Nfsv4OpenHow, claim: structs.Nfsv4OpenClaim): msg.Nfsv4OpenRequest;
    CLOSE(seqid: number, openStateid: structs.Nfsv4Stateid): msg.Nfsv4CloseRequest;
    OPEN_CONFIRM(openStateid: structs.Nfsv4Stateid, seqid: number): msg.Nfsv4OpenConfirmRequest;
    OPEN_DOWNGRADE(openStateid: structs.Nfsv4Stateid, seqid: number, shareAccess: number, shareDeny: number): msg.Nfsv4OpenDowngradeRequest;
    OPENATTR(createdir?: boolean): msg.Nfsv4OpenattrRequest;
    SECINFO(name: string): msg.Nfsv4SecinfoRequest;
    DELEGPURGE(clientid: bigint): msg.Nfsv4DelegpurgeRequest;
    DELEGRETURN(stateid: structs.Nfsv4Stateid): msg.Nfsv4DelegreturnRequest;
    LOCK(locktype: Nfsv4LockType, reclaim: boolean, offset: bigint, length: bigint, locker: structs.Nfsv4LockOwnerInfo): msg.Nfsv4LockRequest;
    LOCKT(locktype: number, offset: bigint, length: bigint, owner: structs.Nfsv4LockOwner): msg.Nfsv4LocktRequest;
    LOCKU(locktype: number, seqid: number, lockStateid: structs.Nfsv4Stateid, offset: bigint, length: bigint): msg.Nfsv4LockuRequest;
    RELEASE_LOCKOWNER(lockOwner: structs.Nfsv4LockOwner): msg.Nfsv4ReleaseLockOwnerRequest;
    Verifier(data?: Uint8Array): structs.Nfsv4Verifier;
    Stateid(seqid?: number, other?: Uint8Array): structs.Nfsv4Stateid;
    Fattr(attrNums: number[], attrVals: Uint8Array): structs.Nfsv4Fattr;
    ClientId(verifier: structs.Nfsv4Verifier, id: Uint8Array): structs.Nfsv4ClientId;
    CbClient(cbProgram: number, rNetid: string, rAddr: string): structs.Nfsv4CbClient;
    Bitmap(attrNums: number[]): structs.Nfsv4Bitmap;
    CreateTypeFile(): structs.Nfsv4CreateType;
    CreateTypeDir(): structs.Nfsv4CreateType;
    OpenOwner(clientid: bigint, owner: Uint8Array): structs.Nfsv4OpenOwner;
    OpenClaimNull(filename: string): structs.Nfsv4OpenClaim;
    OpenHowNoCreate(): structs.Nfsv4OpenHow;
    OpenHowCreateUnchecked(createattrs?: structs.Nfsv4Fattr): structs.Nfsv4OpenHow;
    OpenHowCreateGuarded(createattrs?: structs.Nfsv4Fattr): structs.Nfsv4OpenHow;
    OpenHowCreateExclusive(verifier: structs.Nfsv4Verifier): structs.Nfsv4OpenHow;
    LockOwner(clientid: bigint, owner: Uint8Array): structs.Nfsv4LockOwner;
    NewLockOwner(openSeqid: number, openStateid: structs.Nfsv4Stateid, lockSeqid: number, lockOwner: structs.Nfsv4LockOwner): structs.Nfsv4LockOwnerInfo;
    ExistingLockOwner(lockStateid: structs.Nfsv4Stateid, lockSeqid: number): structs.Nfsv4LockOwnerInfo;
    ILLEGAL(): msg.Nfsv4IllegalRequest;
};
