import type * as msg from '../../messages';
import type * as struct from '../../structs';
/** Client state record for NFS v4 client registration. */
export declare class ClientRecord {
    /**
     * Principal associated with this client (from RPC credentials).
     */
    readonly principal: string;
    /**
     * Client verifier - used to detect client reboots.
     * If client sends SETCLIENTID with same clientIdString but different verifier,
     * it indicates the client rebooted and old state should be discarded.
     * Size 8 bytes (NFS4_VERIFIER_SIZE) buffer.
     */
    readonly verifier: Uint8Array;
    /**
     * Client identifier string - globally unique client identity.
     * Typically contains hostname or other unique data.
     * Used to find existing client records across SETCLIENTID calls.
     */
    readonly clientIdString: Uint8Array;
    /**
     * Callback information - RPC program number and network address.
     * Used by server to initiate callbacks to client (e.g., for delegation recalls).
     * Server opens new TCP connection to client using this address when needed.
     */
    readonly callback: struct.Nfsv4CbClient;
    /**
     * Callback identifier - client-provided value.
     * Sent by server in callback RPCs to help client distinguish which
     * server is calling back (useful if client talks to multiple servers).
     */
    readonly callbackIdent: number;
    /**
     * SETCLIENTID confirmation verifier - random 8-byte token.
     * Generated by server, returned to client, must be echoed back in
     * SETCLIENTID_CONFIRM to prove client received the SETCLIENTID response.
     * Prevents race conditions and stale client ID reuse.
     *
     *     const NFS4_VERIFIER_SIZE        = 8;
     *     typedef opaque  verifier4[NFS4_VERIFIER_SIZE];
     */
    readonly setclientidConfirm: Uint8Array;
    /**
     * Cached SETCLIENTID response for duplicate request handling.
     * If a client repeats a SETCLIENTID request (same clientIdString and verifier),
     * server can return this cached response instead of creating a new record.
     * This helps handle network retries and duplicate requests gracefully.
     */
    cache: msg.Nfsv4SetclientidResponse | undefined;
    /**
     * Last time this client renewed its lease (in milliseconds since epoch).
     * Per RFC 7530 §9.5, any stateful operation from the client renews the lease.
     * The server must track this to detect expired leases and revoke client state.
     */
    lastRenew: number;
    constructor(
    /**
     * Principal associated with this client (from RPC credentials).
     */
    principal: string, 
    /**
     * Client verifier - used to detect client reboots.
     * If client sends SETCLIENTID with same clientIdString but different verifier,
     * it indicates the client rebooted and old state should be discarded.
     * Size 8 bytes (NFS4_VERIFIER_SIZE) buffer.
     */
    verifier: Uint8Array, 
    /**
     * Client identifier string - globally unique client identity.
     * Typically contains hostname or other unique data.
     * Used to find existing client records across SETCLIENTID calls.
     */
    clientIdString: Uint8Array, 
    /**
     * Callback information - RPC program number and network address.
     * Used by server to initiate callbacks to client (e.g., for delegation recalls).
     * Server opens new TCP connection to client using this address when needed.
     */
    callback: struct.Nfsv4CbClient, 
    /**
     * Callback identifier - client-provided value.
     * Sent by server in callback RPCs to help client distinguish which
     * server is calling back (useful if client talks to multiple servers).
     */
    callbackIdent: number, 
    /**
     * SETCLIENTID confirmation verifier - random 8-byte token.
     * Generated by server, returned to client, must be echoed back in
     * SETCLIENTID_CONFIRM to prove client received the SETCLIENTID response.
     * Prevents race conditions and stale client ID reuse.
     *
     *     const NFS4_VERIFIER_SIZE        = 8;
     *     typedef opaque  verifier4[NFS4_VERIFIER_SIZE];
     */
    setclientidConfirm: Uint8Array, 
    /**
     * Cached SETCLIENTID response for duplicate request handling.
     * If a client repeats a SETCLIENTID request (same clientIdString and verifier),
     * server can return this cached response instead of creating a new record.
     * This helps handle network retries and duplicate requests gracefully.
     */
    cache?: msg.Nfsv4SetclientidResponse | undefined, 
    /**
     * Last time this client renewed its lease (in milliseconds since epoch).
     * Per RFC 7530 §9.5, any stateful operation from the client renews the lease.
     * The server must track this to detect expired leases and revoke client state.
     */
    lastRenew?: number);
}
