import type IntWrapper from "./intWrapper";
import { VectorType } from "../vector/vectorType";
import BitVector from "../vector/flat/bitVector";
export declare function skipColumn(numStreams: number, tile: Uint8Array, offset: IntWrapper): void;
export declare function decodeBooleanRle(buffer: Uint8Array, numBooleans: number, pos: IntWrapper): Uint8Array;
export declare function decodeNullableBooleanRle(buffer: Uint8Array, numBooleans: number, pos: IntWrapper, nullabilityBuffer: BitVector): Uint8Array;
export declare function decodeByteRle(buffer: Uint8Array, numBytes: number, pos: IntWrapper): Uint8Array;
export declare function decodeFloatsLE(encodedValues: Uint8Array, pos: IntWrapper, numValues: number): Float32Array;
export declare function decodeDoublesLE(encodedValues: Uint8Array, pos: IntWrapper, numValues: number): Float64Array;
export declare function decodeNullableFloatsLE(encodedValues: Uint8Array, pos: IntWrapper, nullabilityBuffer: BitVector, numValues: number): Float32Array;
export declare function decodeNullableDoublesLE(encodedValues: Uint8Array, pos: IntWrapper, nullabilityBuffer: BitVector, numValues: number): Float64Array;
export declare function decodeString(buf: Uint8Array, pos: number, end: number): string;
export declare function getVectorTypeBooleanStream(numFeatures: number, byteLength: number, data: Uint8Array, offset: IntWrapper): VectorType;
