/**
 * MOUNT protocol constants (Appendix I)
 */
export declare const enum MountConst {
    PROGRAM = 100005,
    VERSION = 3,
    MNTPATHLEN = 1024,
    MNTNAMLEN = 255,
    FHSIZE3 = 64
}
/**
 * MOUNT protocol procedure numbers
 */
export declare const enum MountProc {
    NULL = 0,
    MNT = 1,
    DUMP = 2,
    UMNT = 3,
    UMNTALL = 4,
    EXPORT = 5
}
/**
 * MOUNT protocol status codes
 */
export declare const enum MountStat {
    MNT3_OK = 0,
    MNT3ERR_PERM = 1,
    MNT3ERR_NOENT = 2,
    MNT3ERR_IO = 5,
    MNT3ERR_ACCES = 13,
    MNT3ERR_NOTDIR = 20,
    MNT3ERR_INVAL = 22,
    MNT3ERR_NAMETOOLONG = 63,
    MNT3ERR_NOTSUPP = 10004,
    MNT3ERR_SERVERFAULT = 10006
}
