function formatDependency(params, idx) {
    if (params === null) {
        return `at position #${idx}`;
    }
    const argName = params.split(",")[idx].trim();
    return `"${argName}" at position #${idx}`;
}
function composeErrorMessage(msg, e, indent = "    ") {
    return [msg, ...e.message.split("\n").map(l => indent + l)].join("\n");
}
export function formatErrorCtor(ctor, paramIdx, error) {
    const [, params = null] = ctor.toString().match(/constructor\(([\w, ]+)\)/) || [];
    const dep = formatDependency(params, paramIdx);
    return composeErrorMessage(`Cannot inject the dependency ${dep} of "${ctor.name}" constructor. Reason:`, error);
}
