<h1 align="center">
  PKIjs
</h1>

<div align="center">

![NPM License](https://img.shields.io/npm/l/pkijs)
![GitHub Actions Workflow Status](https://img.shields.io/github/actions/workflow/status/PeculiarVentures/PKI.js/library.yml?label=test)
[![npm version](https://img.shields.io/npm/v/pkijs.svg)](https://www.npmjs.com/package/pkijs)
![Coveralls](https://img.shields.io/coverallsCoverage/github/PeculiarVentures/PKI.js)
[![npm downloads](https://img.shields.io/npm/dm/pkijs.svg)](https://www.npmjs.com/package/pkijs)

</div>

PKIjs provides a Typescript implementation of the most common formats and algorithms needed to build PKI-enabled applications

## Capabilities

- The creation and validation of X.509 certificates (RFC 5280) is used by all certificate-enabled applications.
- PKCS#10 (RFC 2986) is the most commonly used enrollment data structure used by X.509 applications. It enables the requestor to prove control of a given public key.
- Cryptographic Message Syntax (RFC 5652) is the most commonly used data structure for signing data in X.509 applications. CMS makes it easy to both sign and represent all of the data needed to verify a signature.
- Cryptographic Message Syntax (RFC 5652) is also the most commonly used data structure for encrypting data in X.509 applications. CMS makes it easy to provide interoperable data encryption.
- Time-Stamp Protocol (RFC 3161) is the most commonly used protocol for proving that data
existed before a particular time. It is commonly used in signing applications to ensure signatures are verifiable long into the future.

## Objectives
- Typescript and object-oriented implementation
- Contains no cryptographic implementations and instead leverages Web Crypto API
- Work uniformly both in browser and in [Node](https://nodejs.org/)/[Deno](https://deno.com/)

## Installation

To install the stable version:

```bash
npm install --save pkijs
```

This assumes you are using [npm](https://www.npmjs.com/) as your package manager.


## Examples

### Certificates and Revocation

- [Create and validate an X.509 certificate](https://pkijs.org/docs/examples/certificates-and-revocation/create-and-validate-certificate)
- [Working with certificate requests](https://pkijs.org/docs/examples/certificates-and-revocation/working-with-certificate-requests)
- [Creating and parsing CRLs](https://pkijs.org/docs/examples/certificates-and-revocation/creating-and-parsing-CRLs)
- [Working with OCSP requests](https://pkijs.org/docs/examples/certificates-and-revocation/working-with-OCSP-requests)
- [Working with OCSP responses](https://pkijs.org/docs/examples/certificates-and-revocation/working-with-OCSP-responses)

### Signing and Encryption with CMS

- [Working with CMS Signing](https://pkijs.org/docs/examples/signing-and-encryption-with-CMS/working-with-CMS-signing)
- [Working with CMS Certificate-based Encryption](https://pkijs.org/docs/examples/signing-and-encryption-with-CMS/working-with-CMS-certificate-based-encryption)
- [Working with CMS password-based Encryption](https://pkijs.org/docs/examples/signing-and-encryption-with-CMS/working-with-CMS-password-based-encryption)
- [Working with PKCS#7 Certificate bags (P7B)](https://pkijs.org/docs/examples/signing-and-encryption-with-CMS/working-with-PKCS-7-certificate-bags-P7B)

### Timestamping
- [Creating a Timestamp request](https://pkijs.org/docs/examples/timestamping/creating-a-timestamp-request)
- [Creating a Timestamp response](https://pkijs.org/docs/examples/timestamping/creating-a-timestamp-response)

### Other
- [How to verify a signature in a PDF file](https://pkijs.org/docs/examples/other/how-to-verify-a-signature-in-a-PDF-file)
- [S/MIME signature verification](https://pkijs.org/docs/examples/other/S-MIME-signature-verification)
- [S/MIME signature encryption](https://pkijs.org/docs/examples/other/S-MIME-signature-encryption)
- [Working with PKCS#12 files](https://pkijs.org/docs/examples/other/working-with-PKCS-12-files)

## Documentation
You can find the PKI.js documentation [on the website](https://pkijs.org/docs/installation).

## Want to help?
Want to file a bug, contribute some code, or improve documentation? Excellent! Read up on our guidelines for [contribution](https://github.com/PeculiarVentures/PKI.js/blob/master/CONTRIBUTING.md).

## Core Contributors
[Stepan Miroshin](https://github.com/microshine)
