import { type Geometry, type GeometryVector } from "./geometry/geometryVector";
import type Vector from "./vector";
import { type IntVector } from "./intVector";
import { type GpuVector } from "./geometry/gpuVector";
export interface Feature {
    id: number | bigint;
    geometry: Geometry;
    properties: {
        [key: string]: unknown;
    };
}
export default class FeatureTable implements Iterable<Feature> {
    private readonly _name;
    private readonly _geometryVector;
    private readonly _idVector?;
    private readonly _propertyVectors?;
    private readonly _extent;
    private propertyVectorsMap;
    constructor(_name: string, _geometryVector: GeometryVector | GpuVector, _idVector?: IntVector, _propertyVectors?: Vector[], _extent?: number);
    get name(): string;
    get idVector(): IntVector;
    get geometryVector(): GeometryVector | GpuVector;
    get propertyVectors(): Vector[];
    getPropertyVector(name: string): Vector;
    [Symbol.iterator](): Iterator<Feature>;
    get numFeatures(): number;
    get extent(): number;
    /**
     * Returns all features as an array
     */
    getFeatures(): Feature[];
    private containsMaxSaveIntegerValues;
}
