import { Buffer } from '@jsonjoy.com/fs-node-builtins/lib/internal/buffer';
import { TDataOut, TEncodingExtended } from './encoding';
import type * as misc from '@jsonjoy.com/fs-node-utils/lib/types/misc';
import type { StatError } from './types';
export declare const isWin: boolean;
type TData = TDataOut | ArrayBufferView | DataView;
export declare const unixify: (filepath: string, stripTrailing?: boolean) => string;
type TResolve = (filename: string, base?: string) => string;
declare let resolve: TResolve;
export { resolve };
export declare const filenameToSteps: (filename: string, base?: string) => string[];
export declare function isFd(path: any): boolean;
export declare function validateFd(fd: any): void;
export declare function dataToBuffer(data: TData, encoding?: TEncodingExtended): Buffer;
export declare function nullCheck(path: any, callback?: any): boolean;
export declare function pathToFilename(path: misc.PathLike): string;
export declare function createError(errorCode: string, func?: string, path?: string, path2?: string, Constructor?: ErrorConstructor): Error;
export declare function createStatError(errorCode: string, func?: string, path?: string, path2?: string): StatError;
