require 'json'

package = JSON.parse(File.read(File.join(__dir__, 'package.json')))

Pod::Spec.new do |s|
  s.name = 'CapacitorFilesystem'
  s.version = package['version']
  s.summary = package['description']
  s.license = package['license']
  s.homepage = package['repository']['url']
  s.author = package['author']
  s.source = { :git => package['repository']['url'], :tag => "v#{s.version}" }
  s.source_files = [
    'ios/Sources/**/*.{swift,h,m,c,cc,mm,cpp}',
    'packages/capacitor-plugin/ios/Sources/**/*.{swift,h,m,c,cc,mm,cpp}'
  ]
  s.ios.deployment_target = '15.0'
  s.dependency 'Capacitor'
  s.dependency 'IONFilesystemLib', spec='~> 1.1.0'
  s.swift_version = '5.1'
end
