/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.16.0/LICENSE.txt
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).maplibregl={})}(this,(function(e){"use strict";var t,i,r="5.16.0";function n(e,t,i,r){return new(i||(i=Promise))((function(n,s){function a(e){try{l(r.next(e))}catch(e){s(e)}}function o(e){try{l(r.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?n(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(a,o)}l((r=r.apply(e,t||[])).next())}))}function s(e,t){this.x=e,this.y=t}function a(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}"function"==typeof SuppressedError&&SuppressedError,s.prototype={clone(){return new s(this.x,this.y)},add(e){return this.clone()._add(e)},sub(e){return this.clone()._sub(e)},multByPoint(e){return this.clone()._multByPoint(e)},divByPoint(e){return this.clone()._divByPoint(e)},mult(e){return this.clone()._mult(e)},div(e){return this.clone()._div(e)},rotate(e){return this.clone()._rotate(e)},rotateAround(e,t){return this.clone()._rotateAround(e,t)},matMult(e){return this.clone()._matMult(e)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(e){return this.x===e.x&&this.y===e.y},dist(e){return Math.sqrt(this.distSqr(e))},distSqr(e){const t=e.x-this.x,i=e.y-this.y;return t*t+i*i},angle(){return Math.atan2(this.y,this.x)},angleTo(e){return Math.atan2(this.y-e.y,this.x-e.x)},angleWith(e){return this.angleWithSep(e.x,e.y)},angleWithSep(e,t){return Math.atan2(this.x*t-this.y*e,this.x*e+this.y*t)},_matMult(e){const t=e[2]*this.x+e[3]*this.y;return this.x=e[0]*this.x+e[1]*this.y,this.y=t,this},_add(e){return this.x+=e.x,this.y+=e.y,this},_sub(e){return this.x-=e.x,this.y-=e.y,this},_mult(e){return this.x*=e,this.y*=e,this},_div(e){return this.x/=e,this.y/=e,this},_multByPoint(e){return this.x*=e.x,this.y*=e.y,this},_divByPoint(e){return this.x/=e.x,this.y/=e.y,this},_unit(){return this._div(this.mag()),this},_perp(){const e=this.y;return this.y=this.x,this.x=-e,this},_rotate(e){const t=Math.cos(e),i=Math.sin(e),r=i*this.x+t*this.y;return this.x=t*this.x-i*this.y,this.y=r,this},_rotateAround(e,t){const i=Math.cos(e),r=Math.sin(e),n=t.y+r*(this.x-t.x)+i*(this.y-t.y);return this.x=t.x+i*(this.x-t.x)-r*(this.y-t.y),this.y=n,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:s},s.convert=function(e){if(e instanceof s)return e;if(Array.isArray(e))return new s(+e[0],+e[1]);if(void 0!==e.x&&void 0!==e.y)return new s(+e.x,+e.y);throw new Error("Expected [x, y] or {x, y} point format")};var o=function(){if(i)return t;function e(e,t,i,r){this.cx=3*e,this.bx=3*(i-e)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*t,this.by=3*(r-t)-this.cy,this.ay=1-this.cy-this.by,this.p1x=e,this.p1y=t,this.p2x=i,this.p2y=r}return i=1,t=e,e.prototype={sampleCurveX:function(e){return((this.ax*e+this.bx)*e+this.cx)*e},sampleCurveY:function(e){return((this.ay*e+this.by)*e+this.cy)*e},sampleCurveDerivativeX:function(e){return(3*this.ax*e+2*this.bx)*e+this.cx},solveCurveX:function(e,t){if(void 0===t&&(t=1e-6),e<0)return 0;if(e>1)return 1;for(var i=e,r=0;r<8;r++){var n=this.sampleCurveX(i)-e;if(Math.abs(n)<t)return i;var s=this.sampleCurveDerivativeX(i);if(Math.abs(s)<1e-6)break;i-=n/s}var a=0,o=1;for(i=e,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-e)<t));r++)e>n?a=i:o=i,i=.5*(o-a)+a;return i},solve:function(e,t){return this.sampleCurveY(this.solveCurveX(e,t))}},t}(),l=a(o);let c,h;function u(){return null==c&&(c="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),c}var d=1e-6,p="undefined"!=typeof Float32Array?Float32Array:Array;function f(){var e=new p(4);return p!=Float32Array&&(e[1]=0,e[2]=0),e[0]=1,e[3]=1,e}function m(){var e=new p(9);return p!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[5]=0,e[6]=0,e[7]=0),e[0]=1,e[4]=1,e[8]=1,e}function _(){var e=new p(16);return p!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0),e[0]=1,e[5]=1,e[10]=1,e[15]=1,e}function g(e){var t=new p(16);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function y(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e}function x(e,t){var i=t[0],r=t[1],n=t[2],s=t[3],a=t[4],o=t[5],l=t[6],c=t[7],h=t[8],u=t[9],d=t[10],p=t[11],f=t[12],m=t[13],_=t[14],g=t[15],y=i*o-r*a,x=i*l-n*a,v=i*c-s*a,b=r*l-n*o,w=r*c-s*o,T=n*c-s*l,S=h*m-u*f,P=h*_-d*f,I=h*g-p*f,M=u*_-d*m,E=u*g-p*m,C=d*g-p*_,A=y*C-x*E+v*M+b*I-w*P+T*S;return A?(e[0]=(o*C-l*E+c*M)*(A=1/A),e[1]=(n*E-r*C-s*M)*A,e[2]=(m*T-_*w+g*b)*A,e[3]=(d*w-u*T-p*b)*A,e[4]=(l*I-a*C-c*P)*A,e[5]=(i*C-n*I+s*P)*A,e[6]=(_*v-f*T-g*x)*A,e[7]=(h*T-d*v+p*x)*A,e[8]=(a*E-o*I+c*S)*A,e[9]=(r*I-i*E-s*S)*A,e[10]=(f*w-m*v+g*y)*A,e[11]=(u*v-h*w-p*y)*A,e[12]=(o*P-a*M-l*S)*A,e[13]=(i*M-r*P+n*S)*A,e[14]=(m*x-f*b-_*y)*A,e[15]=(h*b-u*x+d*y)*A,e):null}function v(e,t,i){var r=t[0],n=t[1],s=t[2],a=t[3],o=t[4],l=t[5],c=t[6],h=t[7],u=t[8],d=t[9],p=t[10],f=t[11],m=t[12],_=t[13],g=t[14],y=t[15],x=i[0],v=i[1],b=i[2],w=i[3];return e[0]=x*r+v*o+b*u+w*m,e[1]=x*n+v*l+b*d+w*_,e[2]=x*s+v*c+b*p+w*g,e[3]=x*a+v*h+b*f+w*y,e[4]=(x=i[4])*r+(v=i[5])*o+(b=i[6])*u+(w=i[7])*m,e[5]=x*n+v*l+b*d+w*_,e[6]=x*s+v*c+b*p+w*g,e[7]=x*a+v*h+b*f+w*y,e[8]=(x=i[8])*r+(v=i[9])*o+(b=i[10])*u+(w=i[11])*m,e[9]=x*n+v*l+b*d+w*_,e[10]=x*s+v*c+b*p+w*g,e[11]=x*a+v*h+b*f+w*y,e[12]=(x=i[12])*r+(v=i[13])*o+(b=i[14])*u+(w=i[15])*m,e[13]=x*n+v*l+b*d+w*_,e[14]=x*s+v*c+b*p+w*g,e[15]=x*a+v*h+b*f+w*y,e}function b(e,t,i){var r,n,s,a,o,l,c,h,u,d,p,f,m=i[0],_=i[1],g=i[2];return t===e?(e[12]=t[0]*m+t[4]*_+t[8]*g+t[12],e[13]=t[1]*m+t[5]*_+t[9]*g+t[13],e[14]=t[2]*m+t[6]*_+t[10]*g+t[14],e[15]=t[3]*m+t[7]*_+t[11]*g+t[15]):(n=t[1],s=t[2],a=t[3],o=t[4],l=t[5],c=t[6],h=t[7],u=t[8],d=t[9],p=t[10],f=t[11],e[0]=r=t[0],e[1]=n,e[2]=s,e[3]=a,e[4]=o,e[5]=l,e[6]=c,e[7]=h,e[8]=u,e[9]=d,e[10]=p,e[11]=f,e[12]=r*m+o*_+u*g+t[12],e[13]=n*m+l*_+d*g+t[13],e[14]=s*m+c*_+p*g+t[14],e[15]=a*m+h*_+f*g+t[15]),e}function w(e,t,i){var r=i[0],n=i[1],s=i[2];return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e[3]=t[3]*r,e[4]=t[4]*n,e[5]=t[5]*n,e[6]=t[6]*n,e[7]=t[7]*n,e[8]=t[8]*s,e[9]=t[9]*s,e[10]=t[10]*s,e[11]=t[11]*s,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}function T(e,t,i){var r=Math.sin(i),n=Math.cos(i),s=t[4],a=t[5],o=t[6],l=t[7],c=t[8],h=t[9],u=t[10],d=t[11];return t!==e&&(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[4]=s*n+c*r,e[5]=a*n+h*r,e[6]=o*n+u*r,e[7]=l*n+d*r,e[8]=c*n-s*r,e[9]=h*n-a*r,e[10]=u*n-o*r,e[11]=d*n-l*r,e}function S(e,t,i){var r=Math.sin(i),n=Math.cos(i),s=t[0],a=t[1],o=t[2],l=t[3],c=t[8],h=t[9],u=t[10],d=t[11];return t!==e&&(e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[0]=s*n-c*r,e[1]=a*n-h*r,e[2]=o*n-u*r,e[3]=l*n-d*r,e[8]=s*r+c*n,e[9]=a*r+h*n,e[10]=o*r+u*n,e[11]=l*r+d*n,e}function P(e,t,i){var r=Math.sin(i),n=Math.cos(i),s=t[0],a=t[1],o=t[2],l=t[3],c=t[4],h=t[5],u=t[6],d=t[7];return t!==e&&(e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[0]=s*n+c*r,e[1]=a*n+h*r,e[2]=o*n+u*r,e[3]=l*n+d*r,e[4]=c*n-s*r,e[5]=h*n-a*r,e[6]=u*n-o*r,e[7]=d*n-l*r,e}var I=function(e,t,i,r,n){var s=1/Math.tan(t/2);if(e[0]=s/i,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=s,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=-1,e[12]=0,e[13]=0,e[15]=0,null!=n&&n!==1/0){var a=1/(r-n);e[10]=(n+r)*a,e[14]=2*n*r*a}else e[10]=-1,e[14]=-2*r;return e},M=function(e,t,i,r,n,s,a){var o=1/(t-i),l=1/(r-n),c=1/(s-a);return e[0]=-2*o,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=-2*l,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=2*c,e[11]=0,e[12]=(t+i)*o,e[13]=(n+r)*l,e[14]=(a+s)*c,e[15]=1,e};function E(){var e=new p(3);return p!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0),e}function C(e){var t=new p(3);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t}function A(e){var t=e[0],i=e[1],r=e[2];return Math.sqrt(t*t+i*i+r*r)}function z(e,t,i){var r=new p(3);return r[0]=e,r[1]=t,r[2]=i,r}function D(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e}function R(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e}function k(e,t){var i=t[0],r=t[1],n=t[2],s=i*i+r*r+n*n;return s>0&&(s=1/Math.sqrt(s)),e[0]=t[0]*s,e[1]=t[1]*s,e[2]=t[2]*s,e}function L(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]}function F(e,t,i){var r=t[0],n=t[1],s=t[2],a=i[0],o=i[1],l=i[2];return e[0]=n*l-s*o,e[1]=s*a-r*l,e[2]=r*o-n*a,e}function B(e,t,i){var r=i[0],n=i[1],s=i[2],a=i[3],o=t[0],l=t[1],c=t[2],h=n*c-s*l,u=s*o-r*c,d=r*l-n*o;return e[0]=o+a*(h+=h)+n*(d+=d)-s*(u+=u),e[1]=l+a*u+s*h-r*d,e[2]=c+a*d+r*u-n*h,e}function O(e,t,i,r){var n=[],s=[];return n[0]=t[0]-i[0],n[1]=t[1]-i[1],n[2]=t[2]-i[2],s[0]=n[0],s[1]=n[1]*Math.cos(r)-n[2]*Math.sin(r),s[2]=n[1]*Math.sin(r)+n[2]*Math.cos(r),e[0]=s[0]+i[0],e[1]=s[1]+i[1],e[2]=s[2]+i[2],e}function V(e,t,i,r){var n=[],s=[];return n[0]=t[0]-i[0],n[1]=t[1]-i[1],n[2]=t[2]-i[2],s[0]=n[2]*Math.sin(r)+n[0]*Math.cos(r),s[1]=n[1],s[2]=n[2]*Math.cos(r)-n[0]*Math.sin(r),e[0]=s[0]+i[0],e[1]=s[1]+i[1],e[2]=s[2]+i[2],e}function j(e,t,i,r){var n=[],s=[];return n[0]=t[0]-i[0],n[1]=t[1]-i[1],n[2]=t[2]-i[2],s[0]=n[0]*Math.cos(r)-n[1]*Math.sin(r),s[1]=n[0]*Math.sin(r)+n[1]*Math.cos(r),s[2]=n[2],e[0]=s[0]+i[0],e[1]=s[1]+i[1],e[2]=s[2]+i[2],e}var N,U=function(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e[2]=t[2]-i[2],e},G=A;function Z(e,t,i){var r=t[0],n=t[1],s=t[2],a=t[3];return e[0]=i[0]*r+i[4]*n+i[8]*s+i[12]*a,e[1]=i[1]*r+i[5]*n+i[9]*s+i[13]*a,e[2]=i[2]*r+i[6]*n+i[10]*s+i[14]*a,e[3]=i[3]*r+i[7]*n+i[11]*s+i[15]*a,e}function $(){var e=new p(4);return p!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0),e[3]=1,e}function q(e,t,i,r){var n=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"zyx",s=Math.PI/360;t*=s,r*=s,i*=s;var a=Math.sin(t),o=Math.cos(t),l=Math.sin(i),c=Math.cos(i),h=Math.sin(r),u=Math.cos(r);switch(n){case"xyz":e[0]=a*c*u+o*l*h,e[1]=o*l*u-a*c*h,e[2]=o*c*h+a*l*u,e[3]=o*c*u-a*l*h;break;case"xzy":e[0]=a*c*u-o*l*h,e[1]=o*l*u-a*c*h,e[2]=o*c*h+a*l*u,e[3]=o*c*u+a*l*h;break;case"yxz":e[0]=a*c*u+o*l*h,e[1]=o*l*u-a*c*h,e[2]=o*c*h-a*l*u,e[3]=o*c*u+a*l*h;break;case"yzx":e[0]=a*c*u+o*l*h,e[1]=o*l*u+a*c*h,e[2]=o*c*h-a*l*u,e[3]=o*c*u-a*l*h;break;case"zxy":e[0]=a*c*u-o*l*h,e[1]=o*l*u+a*c*h,e[2]=o*c*h+a*l*u,e[3]=o*c*u-a*l*h;break;case"zyx":e[0]=a*c*u-o*l*h,e[1]=o*l*u+a*c*h,e[2]=o*c*h-a*l*u,e[3]=o*c*u+a*l*h;break;default:throw new Error("Unknown angle order "+n)}return e}function W(){var e=new p(2);return p!=Float32Array&&(e[0]=0,e[1]=0),e}function H(e,t){var i=new p(2);return i[0]=e,i[1]=t,i}function X(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e}function Y(e){var t=e[0],i=e[1];return Math.sqrt(t*t+i*i)}function K(e){return e[0]=0,e[1]=0,e}E(),N=new p(4),p!=Float32Array&&(N[0]=0,N[1]=0,N[2]=0,N[3]=0),E(),z(1,0,0),z(0,1,0),$(),$(),m();var J=function(e){var t=e[0],i=e[1];return t*t+i*i};W();const Q=8192;function ee(e,t,i){return t*(Q/(e.tileSize*Math.pow(2,i-e.tileID.overscaledZ)))}function te(){return new Float64Array(4)}function ie(){return new Float64Array(3)}function re(){return new Float64Array(16)}function ne(){const e=new Float64Array(16);return y(e),e}function se(){const e=new Float32Array(16);return y(e),e}function ae(e,t,i,r,n=!1){if(!i[0]&&!i[1])return[0,0];const s=n?"map"===r?-e.bearingInRadians:0:"viewport"===r?e.bearingInRadians:0;if(s){const e=Math.sin(s),t=Math.cos(s);i=[i[0]*t-i[1]*e,i[0]*e+i[1]*t]}return[n?i[0]:ee(t,i[0],e.zoom),n?i[1]:ee(t,i[1],e.zoom)]}function oe(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]}function le(e,t,i){const r=(n=[e[0],e[1],e[2],t[0],t[1],t[2],i[0],i[1],i[2]])[0]*((h=n[8])*(a=n[4])-(o=n[5])*(c=n[7]))+n[1]*(-h*(s=n[3])+o*(l=n[6]))+n[2]*(c*s-a*l);var n,s,a,o,l,c,h;if(0===r)return null;const u=F([],[t[0],t[1],t[2]],[i[0],i[1],i[2]]),d=F([],[i[0],i[1],i[2]],[e[0],e[1],e[2]]),p=F([],[e[0],e[1],e[2]],[t[0],t[1],t[2]]),f=R([],u,-e[3]);return D(f,f,R([],d,-t[3])),D(f,f,R([],p,-i[3])),R(f,f,1/r),f}function ce(e,t,i){const r=t[0]*i[0]+t[1]*i[1]+t[2]*i[2];return 0===r?null:(-(e[0]*i[0]+e[1]*i[1]+e[2]*i[2])-i[3])/r}function he(e,t,i,r){const n=Math.sqrt(e*e+t*t),s=Math.sqrt(i*i+r*r);e/=n,t/=n,i/=s,r/=s;const a=Math.acos(e*i+t*r);return-t*i+e*r>0?a:-a}function ue(e,t){const i=pe(e,360),r=pe(t,360),n=r-i,s=r>i?n-360:n+360;return Math.abs(n)<Math.abs(s)?n:s}function de(e,t){const i=pe(e,2*Math.PI),r=pe(t,2*Math.PI);return Math.min(Math.abs(i-r),Math.abs(i-r+2*Math.PI),Math.abs(i-r-2*Math.PI))}function pe(e,t){return(e%t+t)%t}function fe(e,t,i,r,n){return me(r,n,ve((e-t)/(i-t),0,1))}function me(e,t,i){return e*(1-i)+t*i}function _e(e){let t=1/0,i=1/0,r=-1/0,n=-1/0;for(const s of e)t=Math.min(t,s.x),i=Math.min(i,s.y),r=Math.max(r,s.x),n=Math.max(n,s.y);return[t,i,r,n]}function ge(e){if(e<=0)return 0;if(e>=1)return 1;const t=e*e,i=t*e;return 4*(e<.5?i:3*(e-t)+i-.75)}function ye(e,t,i,r){const n=new l(e,t,i,r);return e=>n.solve(e)}const xe=ye(.25,.1,.25,1);function ve(e,t,i){return Math.min(i,Math.max(t,e))}function be(e,t,i){const r=i-t,n=((e-t)%r+r)%r+t;return n===t?i:n}function we(e,...t){for(const i of t)for(const t in i)e[t]=i[t];return e}function Te(e,t){const i={};for(let r=0;r<t.length;r++){const n=t[r];n in e&&(i[n]=e[n])}return i}let Se=1;function Pe(){return Se++}function Ie(e){return Math.pow(2,e)}function Me(e){return Math.log(e)/Math.LN2}function Ee(e,t,i){const r={};for(const i in e)r[i]=t.call(this,e[i],i,e);return r}function Ce(e,t,i){const r={};for(const i in e)t.call(this,e[i],i,e)&&(r[i]=e[i]);return r}function Ae(e,t){if(Array.isArray(e)){if(!Array.isArray(t)||e.length!==t.length)return!1;for(let i=0;i<e.length;i++)if(!Ae(e[i],t[i]))return!1;return!0}if("object"==typeof e&&null!==e&&null!==t){if("object"!=typeof t)return!1;if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const i in e)if(!Ae(e[i],t[i]))return!1;return!0}return e===t}function ze(e){return Array.isArray(e)?e.map(ze):"object"==typeof e&&e?Ee(e,ze):e}const De={};function Re(e){De[e]||("undefined"!=typeof console&&console.warn(e),De[e]=!0)}function ke(e,t,i){return(i.y-e.y)*(t.x-e.x)>(t.y-e.y)*(i.x-e.x)}function Le(e){return"undefined"!=typeof WorkerGlobalScope&&void 0!==e&&e instanceof WorkerGlobalScope}let Fe=null;function Be(e){return"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap}const Oe="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function Ve(e,t,i,r){return e.addEventListener(t,i,r),{unsubscribe:()=>{e.removeEventListener(t,i,r)}}}function je(e){return e*Math.PI/180}function Ne(e){return e/Math.PI*180}function Ue(e,t){return e.roll==t.roll&&e.pitch==t.pitch&&e.bearing==t.bearing}function Ge(e,t,i){const r=H(t.x-i.x,t.y-i.y),n=H(e.x-i.x,e.y-i.y);var s,a;return Ne(Math.atan2(r[0]*n[1]-r[1]*n[0],(s=r)[0]*(a=n)[0]+s[1]*a[1]))}function Ze(e,t,i){const r=new Float64Array(4);return q(r,e,t-90,i),r}const $e=85.051129,qe={touchstart:!0,touchmove:!0,touchmoveWindow:!0,touchend:!0,touchcancel:!0},We={dblclick:!0,click:!0,mouseover:!0,mouseout:!0,mousedown:!0,mousemove:!0,mousemoveWindow:!0,mouseup:!0,mouseupWindow:!0,contextmenu:!0,wheel:!0};function He(e,t){return qe[t]&&"touches"in e}const Xe="AbortError";class Ye extends Error{constructor(e=Xe){super(e instanceof Error?e.message:e),this.name=Xe,e instanceof Error&&e.stack&&(this.stack=e.stack)}}function Ke(e){return e.name===Xe}let Je,Qe,et;const tt={frame(e,t,i){const r=requestAnimationFrame((e=>{n(),t(e)})),{unsubscribe:n}=Ve(e.signal,"abort",(()=>{n(),cancelAnimationFrame(r),i(new Ye(e.signal.reason))}),!1)},frameAsync(e){return new Promise(((t,i)=>{this.frame(e,t,i)}))},getImageData(e,t=0){return this.getImageCanvasContext(e).getImageData(-t,-t,e.width+2*t,e.height+2*t)},getImageCanvasContext(e){const t=window.document.createElement("canvas"),i=t.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return t.width=e.width,t.height=e.height,i.drawImage(e,0,0,e.width,e.height),i},resolveURL:e=>(Je||(Je=document.createElement("a")),Je.href=e,Je.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return void 0!==et?et:!!matchMedia&&(null==Qe&&(Qe=matchMedia("(prefers-reduced-motion: reduce)")),Qe.matches)},set prefersReducedMotion(e){et=e}},it=new class{constructor(){this._realTime="undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),this._frozenAt=null}getCurrentTime(){return null!==this._frozenAt?this._frozenAt:this._realTime()}setNow(e){this._frozenAt=e}restoreNow(){this._frozenAt=null}isFrozen(){return null!==this._frozenAt}};function rt(){return it.getCurrentTime()}class nt{static testProp(e){if(!nt.docStyle)return e[0];for(let t=0;t<e.length;t++)if(e[t]in nt.docStyle)return e[t];return e[0]}static create(e,t,i){const r=window.document.createElement(e);return void 0!==t&&(r.className=t),i&&i.appendChild(r),r}static createNS(e,t){return window.document.createElementNS(e,t)}static disableDrag(){nt.docStyle&&nt.selectProp&&(nt.userSelect=nt.docStyle[nt.selectProp],nt.docStyle[nt.selectProp]="none")}static enableDrag(){nt.docStyle&&nt.selectProp&&(nt.docStyle[nt.selectProp]=nt.userSelect)}static setTransform(e,t){e.style[nt.transformProp]=t}static addEventListener(e,t,i,r={}){e.addEventListener(t,i,"passive"in r?r:r.capture)}static removeEventListener(e,t,i,r={}){e.removeEventListener(t,i,"passive"in r?r:r.capture)}static suppressClickInternal(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",nt.suppressClickInternal,!0)}static suppressClick(){window.addEventListener("click",nt.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",nt.suppressClickInternal,!0)}),0)}static getScale(e){const t=e.getBoundingClientRect();return{x:t.width/e.offsetWidth||1,y:t.height/e.offsetHeight||1,boundingClientRect:t}}static getPoint(e,t,i){const r=t.boundingClientRect;return new s((i.clientX-r.left)/t.x-e.clientLeft,(i.clientY-r.top)/t.y-e.clientTop)}static mousePos(e,t){const i=nt.getScale(e);return nt.getPoint(e,i,t)}static touchPos(e,t){const i=[],r=nt.getScale(e);for(let n=0;n<t.length;n++)i.push(nt.getPoint(e,r,t[n]));return i}static mouseButton(e){return e.button}static remove(e){e.parentNode&&e.parentNode.removeChild(e)}static sanitize(e){const t=(new DOMParser).parseFromString(e,"text/html").body||document.createElement("body"),i=t.querySelectorAll("script");for(const e of i)e.remove();return nt.clean(t),t.innerHTML}static isPossiblyDangerous(e,t){const i=t.replace(/\s+/g,"").toLowerCase();return!(!["src","href","xlink:href"].includes(e)||!i.includes("javascript:")&&!i.includes("data:"))||!!e.startsWith("on")||void 0}static clean(e){const t=e.children;for(const e of t)nt.removeAttributes(e),nt.clean(e)}static removeAttributes(e){for(const{name:t,value:i}of e.attributes)nt.isPossiblyDangerous(t,i)&&e.removeAttribute(t)}}nt.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,nt.selectProp=nt.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),nt.transformProp=nt.testProp(["transform","WebkitTransform"]);const st={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function at(e){return st.REGISTERED_PROTOCOLS[e.substring(0,e.indexOf("://"))]}const ot="global-dispatcher";class lt extends Error{constructor(e,t,i,r){super(`AJAXError: ${t} (${e}): ${i}`),this.status=e,this.statusText=t,this.url=i,this.body=r}}const ct=()=>Le(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,ht=function(e,t){if(/:\/\//.test(e.url)&&!/^https?:|^file:/.test(e.url)){const i=at(e.url);if(i)return i(e,t);if(Le(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,targetMapId:ot},t)}if(!(/^file:/.test(i=e.url)||/^file:/.test(ct())&&!/^\w+:/.test(i))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(e,t){return n(this,void 0,void 0,(function*(){const i=new Request(e.url,{method:e.method||"GET",body:e.body,credentials:e.credentials,headers:e.headers,cache:e.cache,referrer:ct(),signal:t.signal});let r,n;"json"!==e.type||i.headers.has("Accept")||i.headers.set("Accept","application/json");try{r=yield fetch(i)}catch(t){if(Ke(t))throw t;throw new lt(0,t.message,e.url,new Blob)}if(!r.ok){const t=yield r.blob();throw new lt(r.status,r.statusText,e.url,t)}n="arrayBuffer"===e.type||"image"===e.type?r.arrayBuffer():"json"===e.type?r.json():r.text();const s=yield n;return t.signal.throwIfAborted(),{data:s,cacheControl:r.headers.get("Cache-Control"),expires:r.headers.get("Expires")}}))}(e,t);if(Le(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,mustQueue:!0,targetMapId:ot},t)}var i;return function(e,t){return new Promise(((i,r)=>{var n;const s=new XMLHttpRequest;s.open(e.method||"GET",e.url,!0),"arrayBuffer"!==e.type&&"image"!==e.type||(s.responseType="arraybuffer");for(const t in e.headers)s.setRequestHeader(t,e.headers[t]);"json"===e.type&&(s.responseType="text",(null===(n=e.headers)||void 0===n?void 0:n.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===e.credentials,s.onerror=()=>{r(new Error(s.statusText))},s.onload=()=>{if(!t.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let t=s.response;if("json"===e.type)try{t=JSON.parse(s.response)}catch(e){return void r(e)}i({data:t,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")})}else{const t=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});r(new lt(s.status,s.statusText,e.url,t))}},t.signal.addEventListener("abort",(()=>{s.abort(),r(new Ye(t.signal.reason))})),s.send(e.body)}))}(e,t)},ut=(e,t)=>ht(we(e,{type:"json"}),t);function dt(e){if(!e||e.indexOf("://")<=0||0===e.indexOf("data:image/")||0===e.indexOf("blob:"))return!0;const t=new URL(e),i=window.location;return t.protocol===i.protocol&&t.host===i.host}const pt={supported:!1,testSupport:function(e){!_t&&mt&&(gt?yt(e):ft=e)}};let ft,mt,_t=!1,gt=!1;function yt(e){const t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);try{if(e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,mt),e.isContextLost())return;pt.supported=!0}catch(e){}e.deleteTexture(t),_t=!0}var xt;"undefined"!=typeof document&&(mt=document.createElement("img"),mt.onload=()=>{ft&&yt(ft),ft=null,gt=!0},mt.onerror=()=>{_t=!0,ft=null},mt.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(e){let t,i,r,s;e.resetRequestQueue=()=>{t=[],i=0,r=0,s={}},e.addThrottleControl=e=>{const t=r++;return s[t]=e,t},e.removeThrottleControl=e=>{delete s[e],o()},e.getImage=(e,i,r=!0)=>new Promise(((n,s)=>{pt.supported&&(e.headers||(e.headers={}),e.headers.accept="image/webp,*/*"),we(e,{type:"image"});const a={abortController:i,requestParameters:e,supportImageRefresh:r,state:"queued",onError:e=>{s(e)},onSuccess:e=>{n(e)}};t.push(a),o()}));const a=e=>n(this,void 0,void 0,(function*(){e.state="running";const{requestParameters:t,supportImageRefresh:r,onError:s,onSuccess:a,abortController:c}=e,h=!1===r&&!Le(self)&&!at(t.url)&&(!t.headers||Object.keys(t.headers).reduce(((e,t)=>e&&"accept"===t),!0));i++;const u=h?l(t,c):ht(t,c);try{const t=yield u;delete e.abortController,e.state="completed",t.data instanceof HTMLImageElement||Be(t.data)?a(t):t.data&&a({data:yield(d=t.data,"function"==typeof createImageBitmap?(e=>n(void 0,void 0,void 0,(function*(){if(0===e.byteLength)return createImageBitmap(new ImageData(1,1));const t=new Blob([new Uint8Array(e)],{type:"image/png"});try{return createImageBitmap(t)}catch(e){throw new Error(`Could not load image because of ${e.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})))(d):(e=>new Promise(((t,i)=>{const r=new Image;r.onload=()=>{t(r),URL.revokeObjectURL(r.src),r.onload=null,window.requestAnimationFrame((()=>{r.src=Oe}))},r.onerror=()=>i(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(e)],{type:"image/png"});r.src=e.byteLength?URL.createObjectURL(n):Oe})))(d)),cacheControl:t.cacheControl,expires:t.expires})}catch(t){delete e.abortController,s(t)}finally{i--,o()}var d})),o=()=>{const e=(()=>{for(const e of Object.keys(s))if(s[e]())return!0;return!1})()?st.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:st.MAX_PARALLEL_IMAGE_REQUESTS;for(let r=i;r<e&&t.length>0;r++){const e=t.shift();e.abortController.signal.aborted?r--:a(e)}},l=(e,t)=>new Promise(((i,r)=>{const n=new Image,s=e.url,a=e.credentials;a&&"include"===a?n.crossOrigin="use-credentials":(a&&"same-origin"===a||!dt(s))&&(n.crossOrigin="anonymous"),t.signal.addEventListener("abort",(()=>{n.src="",r(new Ye(t.signal.reason))})),n.fetchPriority="high",n.onload=()=>{n.onerror=n.onload=null,i({data:n})},n.onerror=()=>{n.onerror=n.onload=null,t.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."))},n.src=s}))}(xt||(xt={})),xt.resetRequestQueue();class vt{constructor(e){this._transformRequestFn=null!=e?e:null}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}setTransformRequest(e){this._transformRequestFn=e}}function bt(e,t,i){i[e]&&-1!==i[e].indexOf(t)||(i[e]=i[e]||[],i[e].push(t))}function wt(e,t,i){if(i&&i[e]){const r=i[e].indexOf(t);-1!==r&&i[e].splice(r,1)}}class Tt{constructor(e,t={}){we(this,t),this.type=e}}class St extends Tt{constructor(e,t={}){super("error",we({error:e},t))}}class Pt{on(e,t){return this._listeners=this._listeners||{},bt(e,t,this._listeners),{unsubscribe:()=>{this.off(e,t)}}}off(e,t){return wt(e,t,this._listeners),wt(e,t,this._oneTimeListeners),this}once(e,t){return t?(this._oneTimeListeners=this._oneTimeListeners||{},bt(e,t,this._oneTimeListeners),this):new Promise((t=>this.once(e,t)))}fire(e,t){"string"==typeof e&&(e=new Tt(e,t||{}));const i=e.type;if(this.listens(i)){e.target=this;const t=this._listeners&&this._listeners[i]?this._listeners[i].slice():[];for(const i of t)i.call(this,e);const r=this._oneTimeListeners&&this._oneTimeListeners[i]?this._oneTimeListeners[i].slice():[];for(const t of r)wt(i,t,this._oneTimeListeners),t.call(this,e);const n=this._eventedParent;n&&(we(e,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(e))}else e instanceof St&&console.error(e.error);return this}listens(e){return this._listeners&&this._listeners[e]&&this._listeners[e].length>0||this._oneTimeListeners&&this._oneTimeListeners[e]&&this._oneTimeListeners[e].length>0||this._eventedParent&&this._eventedParent.listens(e)}setEventedParent(e,t){return this._eventedParent=e,this._eventedParentData=t,this}}var It={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number",length:2},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},"font-faces":{type:"fontFaces"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},encoding:{type:"enum",values:{mvt:{},mlt:{}},default:"mvt"},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"filter"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},filter:{type:"boolean",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"expression_name",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}},interpolation:{type:"array",value:"interpolation_name",minimum:1},interpolation_name:{type:"enum",values:{linear:{syntax:{overloads:[{parameters:[],"output-type":"interpolation"}],parameters:[]}},exponential:{syntax:{overloads:[{parameters:["base"],"output-type":"interpolation"}],parameters:[{name:"base",type:"number literal"}]}},"cubic-bezier":{syntax:{overloads:[{parameters:["x1","y1","x2","y2"],"output-type":"interpolation"}],parameters:[{name:"x1",type:"number literal"},{name:"y1",type:"number literal"},{name:"x2",type:"number literal"},{name:"y2",type:"number literal"}]}}}}};const Mt=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function Et(e,t){const i={};for(const t in e)"ref"!==t&&(i[t]=e[t]);return Mt.forEach((e=>{e in t&&(i[e]=t[e])})),i}function Ct(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=Et(e[i],t[e[i].ref]));return e}function At(e,t){if(Array.isArray(e)){if(!Array.isArray(t)||e.length!==t.length)return!1;for(let i=0;i<e.length;i++)if(!At(e[i],t[i]))return!1;return!0}if("object"==typeof e&&null!==e&&null!==t){if("object"!=typeof t)return!1;if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const i in e)if(!At(e[i],t[i]))return!1;return!0}return e===t}function zt(e,t){e.push(t)}function Dt(e,t,i){zt(i,{command:"addSource",args:[e,t[e]]})}function Rt(e,t,i){zt(t,{command:"removeSource",args:[e]}),i[e]=!0}function kt(e,t,i,r){Rt(e,i,r),Dt(e,t,i)}function Lt(e,t,i){let r;for(r in e[i])if(Object.prototype.hasOwnProperty.call(e[i],r)&&"data"!==r&&!At(e[i][r],t[i][r]))return!1;for(r in t[i])if(Object.prototype.hasOwnProperty.call(t[i],r)&&"data"!==r&&!At(e[i][r],t[i][r]))return!1;return!0}function Ft(e,t,i,r,n,s){e=e||{},t=t||{};for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&(At(e[a],t[a])||i.push({command:s,args:[r,a,t[a],n]}));for(const a in t)Object.prototype.hasOwnProperty.call(t,a)&&!Object.prototype.hasOwnProperty.call(e,a)&&(At(e[a],t[a])||i.push({command:s,args:[r,a,t[a],n]}))}function Bt(e){return e.id}function Ot(e,t){return e[t.id]=t,e}class Vt{constructor(e,t,i,r){this.message=(e?`${e}: `:"")+i,r&&(this.identifier=r),null!=t&&t.__line__&&(this.line=t.__line__)}}function jt(e,...t){for(const i of t)for(const t in i)e[t]=i[t];return e}class Nt extends Error{constructor(e,t){super(t),this.message=t,this.key=e}}class Ut{constructor(e,t=[]){this.parent=e,this.bindings={};for(const[e,i]of t)this.bindings[e]=i}concat(e){return new Ut(this,e)}get(e){if(this.bindings[e])return this.bindings[e];if(this.parent)return this.parent.get(e);throw new Error(`${e} not found in scope.`)}has(e){return!!this.bindings[e]||!!this.parent&&this.parent.has(e)}}const Gt={kind:"null"},Zt={kind:"number"},$t={kind:"string"},qt={kind:"boolean"},Wt={kind:"color"},Ht={kind:"projectionDefinition"},Xt={kind:"object"},Yt={kind:"value"},Kt={kind:"collator"},Jt={kind:"formatted"},Qt={kind:"padding"},ei={kind:"colorArray"},ti={kind:"numberArray"},ii={kind:"resolvedImage"},ri={kind:"variableAnchorOffsetCollection"};function ni(e,t){return{kind:"array",itemType:e,N:t}}function si(e){if("array"===e.kind){const t=si(e.itemType);return"number"==typeof e.N?`array<${t}, ${e.N}>`:"value"===e.itemType.kind?"array":`array<${t}>`}return e.kind}const ai=[Gt,Zt,$t,qt,Wt,Ht,Jt,Xt,ni(Yt),Qt,ti,ei,ii,ri];function oi(e,t){if("error"===t.kind)return null;if("array"===e.kind){if("array"===t.kind&&(0===t.N&&"value"===t.itemType.kind||!oi(e.itemType,t.itemType))&&("number"!=typeof e.N||e.N===t.N))return null}else{if(e.kind===t.kind)return null;if("value"===e.kind)for(const e of ai)if(!oi(e,t))return null}return`Expected ${si(e)} but found ${si(t)} instead.`}function li(e,t){return t.some((t=>t.kind===e.kind))}function ci(e,t){return t.some((t=>"null"===t?null===e:"array"===t?Array.isArray(e):"object"===t?e&&!Array.isArray(e)&&"object"==typeof e:t===typeof e))}function hi(e,t){return"array"===e.kind&&"array"===t.kind?e.itemType.kind===t.itemType.kind&&"number"==typeof e.N:e.kind===t.kind}const ui=.96422,di=.82521,pi=4/29,fi=6/29,mi=3*fi*fi,_i=fi*fi*fi,gi=Math.PI/180,yi=180/Math.PI;function xi(e){return(e%=360)<0&&(e+=360),e}function vi([e,t,i,r]){let n,s;const a=wi((.2225045*(e=bi(e))+.7168786*(t=bi(t))+.0606169*(i=bi(i)))/1);e===t&&t===i?n=s=a:(n=wi((.4360747*e+.3850649*t+.1430804*i)/ui),s=wi((.0139322*e+.0971045*t+.7141733*i)/di));const o=116*a-16;return[o<0?0:o,500*(n-a),200*(a-s),r]}function bi(e){return e<=.04045?e/12.92:Math.pow((e+.055)/1.055,2.4)}function wi(e){return e>_i?Math.pow(e,1/3):e/mi+pi}function Ti([e,t,i,r]){let n=(e+16)/116,s=isNaN(t)?n:n+t/500,a=isNaN(i)?n:n-i/200;return n=1*Pi(n),s=ui*Pi(s),a=di*Pi(a),[Si(3.1338561*s-1.6168667*n-.4906146*a),Si(-.9787684*s+1.9161415*n+.033454*a),Si(.0719453*s-.2289914*n+1.4052427*a),r]}function Si(e){return(e=e<=.00304?12.92*e:1.055*Math.pow(e,1/2.4)-.055)<0?0:e>1?1:e}function Pi(e){return e>fi?e*e*e:mi*(e-pi)}const Ii=Object.hasOwn||function(e,t){return Object.prototype.hasOwnProperty.call(e,t)};function Mi(e,t){return Ii(e,t)?e[t]:void 0}function Ei(e){return parseInt(e.padEnd(2,e),16)/255}function Ci(e,t){return Ai(t?e/100:e,0,1)}function Ai(e,t,i){return Math.min(Math.max(t,e),i)}function zi(e){return!e.some(Number.isNaN)}const Di={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function Ri(e,t,i){return e+i*(t-e)}function ki(e,t,i){return e.map(((e,r)=>Ri(e,t[r],i)))}class Li{constructor(e,t,i,r=1,n=!0){this.r=e,this.g=t,this.b=i,this.a=r,n||(this.r*=r,this.g*=r,this.b*=r,r||this.overwriteGetter("rgb",[e,t,i,r]))}static parse(e){if(e instanceof Li)return e;if("string"!=typeof e)return;const t=function(e){if("transparent"===(e=e.toLowerCase().trim()))return[0,0,0,0];const t=Mi(Di,e);if(t){const[e,i,r]=t;return[e/255,i/255,r/255,1]}if(e.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(e)){const t=e.length<6?1:2;let i=1;return[Ei(e.slice(i,i+=t)),Ei(e.slice(i,i+=t)),Ei(e.slice(i,i+=t)),Ei(e.slice(i,i+t)||"ff")]}if(e.startsWith("rgb")){const t=e.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(t){const[e,i,r,n,s,a,o,l,c,h,u,d]=t,p=[n||" ",o||" ",h].join("");if("  "===p||"  /"===p||",,"===p||",,,"===p){const e=[r,a,c].join(""),t="%%%"===e?100:""===e?255:0;if(t){const e=[Ai(+i/t,0,1),Ai(+s/t,0,1),Ai(+l/t,0,1),u?Ci(+u,d):1];if(zi(e))return e}}return}}const i=e.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(i){const[e,t,r,n,s,a,o,l,c]=i,h=[r||" ",s||" ",o].join("");if("  "===h||"  /"===h||",,"===h||",,,"===h){const e=[+t,Ai(+n,0,100),Ai(+a,0,100),l?Ci(+l,c):1];if(zi(e))return function([e,t,i,r]){function n(r){const n=(r+e/30)%12,s=t*Math.min(i,1-i);return i-s*Math.max(-1,Math.min(n-3,9-n,1))}return e=xi(e),t/=100,i/=100,[n(0),n(8),n(4),r]}(e)}}}(e);return t?new Li(...t,!1):void 0}get rgb(){const{r:e,g:t,b:i,a:r}=this,n=r||1/0;return this.overwriteGetter("rgb",[e/n,t/n,i/n,r])}get hcl(){return this.overwriteGetter("hcl",function(e){const[t,i,r,n]=vi(e),s=Math.sqrt(i*i+r*r);return[Math.round(1e4*s)?xi(Math.atan2(r,i)*yi):NaN,s,t,n]}(this.rgb))}get lab(){return this.overwriteGetter("lab",vi(this.rgb))}overwriteGetter(e,t){return Object.defineProperty(this,e,{value:t}),t}toString(){const[e,t,i,r]=this.rgb;return`rgba(${[e,t,i].map((e=>Math.round(255*e))).join(",")},${r})`}static interpolate(e,t,i,r="rgb"){switch(r){case"rgb":{const[r,n,s,a]=ki(e.rgb,t.rgb,i);return new Li(r,n,s,a,!1)}case"hcl":{const[r,n,s,a]=e.hcl,[o,l,c,h]=t.hcl;let u,d;if(isNaN(r)||isNaN(o))isNaN(r)?isNaN(o)?u=NaN:(u=o,1!==s&&0!==s||(d=l)):(u=r,1!==c&&0!==c||(d=n));else{let e=o-r;o>r&&e>180?e-=360:o<r&&r-o>180&&(e+=360),u=r+i*e}const[p,f,m,_]=function([e,t,i,r]){return e=isNaN(e)?0:e*gi,Ti([i,Math.cos(e)*t,Math.sin(e)*t,r])}([u,null!=d?d:Ri(n,l,i),Ri(s,c,i),Ri(a,h,i)]);return new Li(p,f,m,_,!1)}case"lab":{const[r,n,s,a]=Ti(ki(e.lab,t.lab,i));return new Li(r,n,s,a,!1)}}}}Li.black=new Li(0,0,0,1),Li.white=new Li(1,1,1,1),Li.transparent=new Li(0,0,0,0),Li.red=new Li(1,0,0,1);class Fi{constructor(e,t,i){this.sensitivity=e?t?"variant":"case":t?"accent":"base",this.locale=i,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(e,t){return this.collator.compare(e,t)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Bi=["bottom","center","top"];class Oi{constructor(e,t,i,r,n,s){this.text=e,this.image=t,this.scale=i,this.fontStack=r,this.textColor=n,this.verticalAlign=s}}class Vi{constructor(e){this.sections=e}static fromString(e){return new Vi([new Oi(e,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((e=>0!==e.text.length||e.image&&0!==e.image.name.length))}static factory(e){return e instanceof Vi?e:Vi.fromString(e)}toString(){return 0===this.sections.length?"":this.sections.map((e=>e.text)).join("")}}class ji{constructor(e){this.values=e.slice()}static parse(e){if(e instanceof ji)return e;if("number"==typeof e)return new ji([e,e,e,e]);if(Array.isArray(e)&&!(e.length<1||e.length>4)){for(const t of e)if("number"!=typeof t)return;switch(e.length){case 1:e=[e[0],e[0],e[0],e[0]];break;case 2:e=[e[0],e[1],e[0],e[1]];break;case 3:e=[e[0],e[1],e[2],e[1]]}return new ji(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,i){return new ji(ki(e.values,t.values,i))}}class Ni{constructor(e){this.values=e.slice()}static parse(e){if(e instanceof Ni)return e;if("number"==typeof e)return new Ni([e]);if(Array.isArray(e)){for(const t of e)if("number"!=typeof t)return;return new Ni(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,i){return new Ni(ki(e.values,t.values,i))}}class Ui{constructor(e){this.values=e.slice()}static parse(e){if(e instanceof Ui)return e;if("string"==typeof e){const t=Li.parse(e);if(!t)return;return new Ui([t])}if(!Array.isArray(e))return;const t=[];for(const i of e){if("string"!=typeof i)return;const e=Li.parse(i);if(!e)return;t.push(e)}return new Ui(t)}toString(){return JSON.stringify(this.values)}static interpolate(e,t,i,r="rgb"){const n=[];if(e.values.length!=t.values.length)throw new Error(`colorArray: Arrays have mismatched length (${e.values.length} vs. ${t.values.length}), cannot interpolate.`);for(let s=0;s<e.values.length;s++)n.push(Li.interpolate(e.values[s],t.values[s],i,r));return new Ui(n)}}class Gi extends Error{constructor(e){super(e),this.name="RuntimeError"}toJSON(){return this.message}}const Zi=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class $i{constructor(e){this.values=e.slice()}static parse(e){if(e instanceof $i)return e;if(Array.isArray(e)&&!(e.length<1)&&e.length%2==0){for(let t=0;t<e.length;t+=2){const i=e[t],r=e[t+1];if("string"!=typeof i||!Zi.has(i))return;if(!Array.isArray(r)||2!==r.length||"number"!=typeof r[0]||"number"!=typeof r[1])return}return new $i(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,i){const r=e.values,n=t.values;if(r.length!==n.length)throw new Gi(`Cannot interpolate values of different length. from: ${e.toString()}, to: ${t.toString()}`);const s=[];for(let e=0;e<r.length;e+=2){if(r[e]!==n[e])throw new Gi(`Cannot interpolate values containing mismatched anchors. from[${e}]: ${r[e]}, to[${e}]: ${n[e]}`);s.push(r[e]);const[t,a]=r[e+1],[o,l]=n[e+1];s.push([Ri(t,o,i),Ri(a,l,i)])}return new $i(s)}}class qi{constructor(e){this.name=e.name,this.available=e.available}toString(){return this.name}static fromString(e){return e?new qi({name:e,available:!1}):null}}class Wi{constructor(e,t,i){this.from=e,this.to=t,this.transition=i}static interpolate(e,t,i){return new Wi(e,t,i)}static parse(e){return e instanceof Wi?e:Array.isArray(e)&&3===e.length&&"string"==typeof e[0]&&"string"==typeof e[1]&&"number"==typeof e[2]?new Wi(e[0],e[1],e[2]):"object"==typeof e&&"string"==typeof e.from&&"string"==typeof e.to&&"number"==typeof e.transition?new Wi(e.from,e.to,e.transition):"string"==typeof e?new Wi(e,e,1):void 0}}function Hi(e,t,i,r){return"number"==typeof e&&e>=0&&e<=255&&"number"==typeof t&&t>=0&&t<=255&&"number"==typeof i&&i>=0&&i<=255?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid rgba value [${[e,t,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof r?[e,t,i,r]:[e,t,i]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Xi(e){if(null===e||"string"==typeof e||"boolean"==typeof e||"number"==typeof e||e instanceof Wi||e instanceof Li||e instanceof Fi||e instanceof Vi||e instanceof ji||e instanceof Ni||e instanceof Ui||e instanceof $i||e instanceof qi)return!0;if(Array.isArray(e)){for(const t of e)if(!Xi(t))return!1;return!0}if("object"==typeof e){for(const t in e)if(!Xi(e[t]))return!1;return!0}return!1}function Yi(e){if(null===e)return Gt;if("string"==typeof e)return $t;if("boolean"==typeof e)return qt;if("number"==typeof e)return Zt;if(e instanceof Li)return Wt;if(e instanceof Wi)return Ht;if(e instanceof Fi)return Kt;if(e instanceof Vi)return Jt;if(e instanceof ji)return Qt;if(e instanceof Ni)return ti;if(e instanceof Ui)return ei;if(e instanceof $i)return ri;if(e instanceof qi)return ii;if(Array.isArray(e)){const t=e.length;let i;for(const t of e){const e=Yi(t);if(i){if(i===e)continue;i=Yt;break}i=e}return ni(i||Yt,t)}return Xt}function Ki(e){const t=typeof e;return null===e?"":"string"===t||"number"===t||"boolean"===t?String(e):e instanceof Li||e instanceof Wi||e instanceof Vi||e instanceof ji||e instanceof Ni||e instanceof Ui||e instanceof $i||e instanceof qi?e.toString():JSON.stringify(e)}class Ji{constructor(e,t){this.type=e,this.value=t}static parse(e,t){if(2!==e.length)return t.error(`'literal' expression requires exactly one argument, but found ${e.length-1} instead.`);if(!Xi(e[1]))return t.error("invalid value");const i=e[1];let r=Yi(i);const n=t.expectedType;return"array"!==r.kind||0!==r.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(r=n),new Ji(r,i)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const Qi={string:$t,number:Zt,boolean:qt,object:Xt};class er{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");let i,r=1;const n=e[0];if("array"===n){let n,s;if(e.length>2){const i=e[1];if("string"!=typeof i||!(i in Qi)||"object"===i)return t.error('The item type argument of "array" must be one of string, number, boolean',1);n=Qi[i],r++}else n=Yt;if(e.length>3){if(null!==e[2]&&("number"!=typeof e[2]||e[2]<0||e[2]!==Math.floor(e[2])))return t.error('The length argument to "array" must be a positive integer literal',2);s=e[2],r++}i=ni(n,s)}else{if(!Qi[n])throw new Error(`Types doesn't contain name = ${n}`);i=Qi[n]}const s=[];for(;r<e.length;r++){const i=t.parse(e[r],r,Yt);if(!i)return null;s.push(i)}return new er(i,s)}evaluate(e){for(let t=0;t<this.args.length;t++){const i=this.args[t].evaluate(e);if(!oi(this.type,Yi(i)))return i;if(t===this.args.length-1)throw new Gi(`Expected value to be of type ${si(this.type)}, but found ${si(Yi(i))} instead.`)}throw new Error}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}}const tr={"to-boolean":qt,"to-color":Wt,"to-number":Zt,"to-string":$t};class ir{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const i=e[0];if(!tr[i])throw new Error(`Can't parse ${i} as it is not part of the known types`);if(("to-boolean"===i||"to-string"===i)&&2!==e.length)return t.error("Expected one argument.");const r=tr[i],n=[];for(let i=1;i<e.length;i++){const r=t.parse(e[i],i,Yt);if(!r)return null;n.push(r)}return new ir(r,n)}evaluate(e){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(e));case"color":{let t,i;for(const r of this.args){if(t=r.evaluate(e),i=null,t instanceof Li)return t;if("string"==typeof t){const i=e.parseColor(t);if(i)return i}else if(Array.isArray(t)&&(i=t.length<3||t.length>4?`Invalid rgba value ${JSON.stringify(t)}: expected an array containing either three or four numeric values.`:Hi(t[0],t[1],t[2],t[3]),!i))return new Li(t[0]/255,t[1]/255,t[2]/255,t[3])}throw new Gi(i||`Could not parse color from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"padding":{let t;for(const i of this.args){t=i.evaluate(e);const r=ji.parse(t);if(r)return r}throw new Gi(`Could not parse padding from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"numberArray":{let t;for(const i of this.args){t=i.evaluate(e);const r=Ni.parse(t);if(r)return r}throw new Gi(`Could not parse numberArray from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"colorArray":{let t;for(const i of this.args){t=i.evaluate(e);const r=Ui.parse(t);if(r)return r}throw new Gi(`Could not parse colorArray from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"variableAnchorOffsetCollection":{let t;for(const i of this.args){t=i.evaluate(e);const r=$i.parse(t);if(r)return r}throw new Gi(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case"number":{let t=null;for(const i of this.args){if(t=i.evaluate(e),null===t)return 0;const r=Number(t);if(!isNaN(r))return r}throw new Gi(`Could not convert ${JSON.stringify(t)} to number.`)}case"formatted":return Vi.fromString(Ki(this.args[0].evaluate(e)));case"resolvedImage":return qi.fromString(Ki(this.args[0].evaluate(e)));case"projectionDefinition":return this.args[0].evaluate(e);default:return Ki(this.args[0].evaluate(e))}}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}}const rr=["Unknown","Point","LineString","Polygon"];class nr{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?rr[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(e){let t=this._parseColorCache.get(e);return t||(t=Li.parse(e),this._parseColorCache.set(e,t)),t}}class sr{constructor(e,t,i=[],r,n=new Ut,s=[]){this.registry=e,this.path=i,this.key=i.map((e=>`[${e}]`)).join(""),this.scope=n,this.errors=s,this.expectedType=r,this._isConstant=t}parse(e,t,i,r,n={}){return t?this.concat(t,i,r)._parse(e,n):this._parse(e,n)}_parse(e,t){function i(e,t,i){return"assert"===i?new er(t,[e]):"coerce"===i?new ir(t,[e]):e}if(null!==e&&"string"!=typeof e&&"boolean"!=typeof e&&"number"!=typeof e||(e=["literal",e]),Array.isArray(e)){if(0===e.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const r=e[0];if("string"!=typeof r)return this.error(`Expression name must be a string, but found ${typeof r} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const n=this.registry[r];if(n){let r=n.parse(e,this);if(!r)return null;if(this.expectedType){const e=this.expectedType,n=r.type;if("string"!==e.kind&&"number"!==e.kind&&"boolean"!==e.kind&&"object"!==e.kind&&"array"!==e.kind||"value"!==n.kind){if("projectionDefinition"===e.kind&&["string","array"].includes(n.kind)||["color","formatted","resolvedImage"].includes(e.kind)&&["value","string"].includes(n.kind)||["padding","numberArray"].includes(e.kind)&&["value","number","array"].includes(n.kind)||"colorArray"===e.kind&&["value","string","array"].includes(n.kind)||"variableAnchorOffsetCollection"===e.kind&&["value","array"].includes(n.kind))r=i(r,e,t.typeAnnotation||"coerce");else if(this.checkSubtype(e,n))return null}else r=i(r,e,t.typeAnnotation||"assert")}if(!(r instanceof Ji)&&"resolvedImage"!==r.type.kind&&this._isConstant(r)){const e=new nr;try{r=new Ji(r.type,r.evaluate(e))}catch(e){return this.error(e.message),null}}return r}return this.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===e?"'undefined' value invalid. Use null instead.":"object"==typeof e?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof e} instead.`)}concat(e,t,i){const r="number"==typeof e?this.path.concat(e):this.path,n=i?this.scope.concat(i):this.scope;return new sr(this.registry,this._isConstant,r,t||null,n,this.errors)}error(e,...t){const i=`${this.key}${t.map((e=>`[${e}]`)).join("")}`;this.errors.push(new Nt(i,e))}checkSubtype(e,t){const i=oi(e,t);return i&&this.error(i),i}}class ar{constructor(e,t){this.type=t.type,this.bindings=[].concat(e),this.result=t}evaluate(e){return this.result.evaluate(e)}eachChild(e){for(const t of this.bindings)e(t[1]);e(this.result)}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found ${e.length-1} instead.`);const i=[];for(let r=1;r<e.length-1;r+=2){const n=e[r];if("string"!=typeof n)return t.error(`Expected string, but found ${typeof n} instead.`,r);if(/[^a-zA-Z0-9_]/.test(n))return t.error("Variable names must contain only alphanumeric characters or '_'.",r);const s=t.parse(e[r+1],r+1);if(!s)return null;i.push([n,s])}const r=t.parse(e[e.length-1],e.length-1,t.expectedType,i);return r?new ar(i,r):null}outputDefined(){return this.result.outputDefined()}}class or{constructor(e,t){this.type=t.type,this.name=e,this.boundExpression=t}static parse(e,t){if(2!==e.length||"string"!=typeof e[1])return t.error("'var' expression requires exactly one string literal argument.");const i=e[1];return t.scope.has(i)?new or(i,t.scope.get(i)):t.error(`Unknown variable "${i}". Make sure "${i}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(e){return this.boundExpression.evaluate(e)}eachChild(){}outputDefined(){return!1}}class lr{constructor(e,t,i){this.type=e,this.index=t,this.input=i}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Zt),r=t.parse(e[2],2,ni(t.expectedType||Yt));return i&&r?new lr(r.type.itemType,i,r):null}evaluate(e){const t=this.index.evaluate(e),i=this.input.evaluate(e);if(t<0)throw new Gi(`Array index out of bounds: ${t} < 0.`);if(t>=i.length)throw new Gi(`Array index out of bounds: ${t} > ${i.length-1}.`);if(t!==Math.floor(t))throw new Gi(`Array index must be an integer, but found ${t} instead.`);return i[t]}eachChild(e){e(this.index),e(this.input)}outputDefined(){return!1}}class cr{constructor(e,t){this.type=qt,this.needle=e,this.haystack=t}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Yt),r=t.parse(e[2],2,Yt);return i&&r?li(i.type,[qt,$t,Zt,Gt,Yt])?new cr(i,r):t.error(`Expected first argument to be of type boolean, string, number or null, but found ${si(i.type)} instead`):null}evaluate(e){const t=this.needle.evaluate(e),i=this.haystack.evaluate(e);if(!i)return!1;if(!ci(t,["boolean","string","number","null"]))throw new Gi(`Expected first argument to be of type boolean, string, number or null, but found ${si(Yi(t))} instead.`);if(!ci(i,["string","array"]))throw new Gi(`Expected second argument to be of type array or string, but found ${si(Yi(i))} instead.`);return i.indexOf(t)>=0}eachChild(e){e(this.needle),e(this.haystack)}outputDefined(){return!0}}class hr{constructor(e,t,i){this.type=Zt,this.needle=e,this.haystack=t,this.fromIndex=i}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 2 or 3 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Yt),r=t.parse(e[2],2,Yt);if(!i||!r)return null;if(!li(i.type,[qt,$t,Zt,Gt,Yt]))return t.error(`Expected first argument to be of type boolean, string, number or null, but found ${si(i.type)} instead`);if(4===e.length){const n=t.parse(e[3],3,Zt);return n?new hr(i,r,n):null}return new hr(i,r)}evaluate(e){const t=this.needle.evaluate(e),i=this.haystack.evaluate(e);if(!ci(t,["boolean","string","number","null"]))throw new Gi(`Expected first argument to be of type boolean, string, number or null, but found ${si(Yi(t))} instead.`);let r;if(this.fromIndex&&(r=this.fromIndex.evaluate(e)),ci(i,["string"])){const e=i.indexOf(t,r);return-1===e?-1:[...i.slice(0,e)].length}if(ci(i,["array"]))return i.indexOf(t,r);throw new Gi(`Expected second argument to be of type array or string, but found ${si(Yi(i))} instead.`)}eachChild(e){e(this.needle),e(this.haystack),this.fromIndex&&e(this.fromIndex)}outputDefined(){return!1}}class ur{constructor(e,t,i,r,n,s){this.inputType=e,this.type=t,this.input=i,this.cases=r,this.outputs=n,this.otherwise=s}static parse(e,t){if(e.length<5)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if(e.length%2!=1)return t.error("Expected an even number of arguments.");let i,r;t.expectedType&&"value"!==t.expectedType.kind&&(r=t.expectedType);const n={},s=[];for(let a=2;a<e.length-1;a+=2){let o=e[a];const l=e[a+1];Array.isArray(o)||(o=[o]);const c=t.concat(a);if(0===o.length)return c.error("Expected at least one branch label.");for(const e of o){if("number"!=typeof e&&"string"!=typeof e)return c.error("Branch labels must be numbers or strings.");if("number"==typeof e&&Math.abs(e)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof e&&Math.floor(e)!==e)return c.error("Numeric branch labels must be integer values.");if(i){if(c.checkSubtype(i,Yi(e)))return null}else i=Yi(e);if(void 0!==n[String(e)])return c.error("Branch labels must be unique.");n[String(e)]=s.length}const h=t.parse(l,a,r);if(!h)return null;r=r||h.type,s.push(h)}const a=t.parse(e[1],1,Yt);if(!a)return null;const o=t.parse(e[e.length-1],e.length-1,r);return o?"value"!==a.type.kind&&t.concat(1).checkSubtype(i,a.type)?null:new ur(i,r,a,n,s,o):null}evaluate(e){const t=this.input.evaluate(e);return(Yi(t)===this.inputType&&this.outputs[this.cases[t]]||this.otherwise).evaluate(e)}eachChild(e){e(this.input),this.outputs.forEach(e),e(this.otherwise)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))&&this.otherwise.outputDefined()}}class dr{constructor(e,t,i){this.type=e,this.branches=t,this.otherwise=i}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found only ${e.length-1}.`);if(e.length%2!=0)return t.error("Expected an odd number of arguments.");let i;t.expectedType&&"value"!==t.expectedType.kind&&(i=t.expectedType);const r=[];for(let n=1;n<e.length-1;n+=2){const s=t.parse(e[n],n,qt);if(!s)return null;const a=t.parse(e[n+1],n+1,i);if(!a)return null;r.push([s,a]),i=i||a.type}const n=t.parse(e[e.length-1],e.length-1,i);if(!n)return null;if(!i)throw new Error("Can't infer output type");return new dr(i,r,n)}evaluate(e){for(const[t,i]of this.branches)if(t.evaluate(e))return i.evaluate(e);return this.otherwise.evaluate(e)}eachChild(e){for(const[t,i]of this.branches)e(t),e(i);e(this.otherwise)}outputDefined(){return this.branches.every((([e,t])=>t.outputDefined()))&&this.otherwise.outputDefined()}}class pr{constructor(e,t,i,r){this.type=e,this.input=t,this.beginIndex=i,this.endIndex=r}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 2 or 3 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Yt),r=t.parse(e[2],2,Zt);if(!i||!r)return null;if(!li(i.type,[ni(Yt),$t,Yt]))return t.error(`Expected first argument to be of type array or string, but found ${si(i.type)} instead`);if(4===e.length){const n=t.parse(e[3],3,Zt);return n?new pr(i.type,i,r,n):null}return new pr(i.type,i,r)}evaluate(e){const t=this.input.evaluate(e),i=this.beginIndex.evaluate(e);let r;if(this.endIndex&&(r=this.endIndex.evaluate(e)),ci(t,["string"]))return[...t].slice(i,r).join("");if(ci(t,["array"]))return t.slice(i,r);throw new Gi(`Expected first argument to be of type array or string, but found ${si(Yi(t))} instead.`)}eachChild(e){e(this.input),e(this.beginIndex),this.endIndex&&e(this.endIndex)}outputDefined(){return!1}}function fr(e,t){const i=e.length-1;let r,n,s=0,a=i,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),r=e[o],n=e[o+1],r<=t){if(o===i||t<n)return o;s=o+1}else{if(!(r>t))throw new Gi("Input is not a number.");a=o-1}return 0}class mr{constructor(e,t,i){this.type=e,this.input=t,this.labels=[],this.outputs=[];for(const[e,t]of i)this.labels.push(e),this.outputs.push(t)}static parse(e,t){if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");const i=t.parse(e[1],1,Zt);if(!i)return null;const r=[];let n=null;t.expectedType&&"value"!==t.expectedType.kind&&(n=t.expectedType);for(let i=1;i<e.length;i+=2){const s=1===i?-1/0:e[i],a=e[i+1],o=i,l=i+1;if("number"!=typeof s)return t.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(r.length&&r[r.length-1][0]>=s)return t.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const c=t.parse(a,l,n);if(!c)return null;n=n||c.type,r.push([s,c])}return new mr(n,i,r)}evaluate(e){const t=this.labels,i=this.outputs;if(1===t.length)return i[0].evaluate(e);const r=this.input.evaluate(e);if(r<=t[0])return i[0].evaluate(e);const n=t.length;return r>=t[n-1]?i[n-1].evaluate(e):i[fr(t,r)].evaluate(e)}eachChild(e){e(this.input);for(const t of this.outputs)e(t)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}}function _r(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var gr,yr,xr=function(){if(yr)return gr;function e(e,t,i,r){this.cx=3*e,this.bx=3*(i-e)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*t,this.by=3*(r-t)-this.cy,this.ay=1-this.cy-this.by,this.p1x=e,this.p1y=t,this.p2x=i,this.p2y=r}return yr=1,gr=e,e.prototype={sampleCurveX:function(e){return((this.ax*e+this.bx)*e+this.cx)*e},sampleCurveY:function(e){return((this.ay*e+this.by)*e+this.cy)*e},sampleCurveDerivativeX:function(e){return(3*this.ax*e+2*this.bx)*e+this.cx},solveCurveX:function(e,t){if(void 0===t&&(t=1e-6),e<0)return 0;if(e>1)return 1;for(var i=e,r=0;r<8;r++){var n=this.sampleCurveX(i)-e;if(Math.abs(n)<t)return i;var s=this.sampleCurveDerivativeX(i);if(Math.abs(s)<1e-6)break;i-=n/s}var a=0,o=1;for(i=e,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-e)<t));r++)e>n?a=i:o=i,i=.5*(o-a)+a;return i},solve:function(e,t){return this.sampleCurveY(this.solveCurveX(e,t))}},gr}(),vr=_r(xr);class br{constructor(e,t,i,r,n){this.type=e,this.operator=t,this.interpolation=i,this.input=r,this.labels=[],this.outputs=[];for(const[e,t]of n)this.labels.push(e),this.outputs.push(t)}static interpolationFactor(e,t,i,r){let n=0;if("exponential"===e.name)n=wr(t,e.base,i,r);else if("linear"===e.name)n=wr(t,1,i,r);else if("cubic-bezier"===e.name){const s=e.controlPoints;n=new vr(s[0],s[1],s[2],s[3]).solve(wr(t,1,i,r))}return n}static parse(e,t){let[i,r,n,...s]=e;if(!Array.isArray(r)||0===r.length)return t.error("Expected an interpolation type expression.",1);if("linear"===r[0])r={name:"linear"};else if("exponential"===r[0]){const e=r[1];if("number"!=typeof e)return t.error("Exponential interpolation requires a numeric base.",1,1);r={name:"exponential",base:e}}else{if("cubic-bezier"!==r[0])return t.error(`Unknown interpolation type ${String(r[0])}`,1,0);{const e=r.slice(1);if(4!==e.length||e.some((e=>"number"!=typeof e||e<0||e>1)))return t.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);r={name:"cubic-bezier",controlPoints:e}}}if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");if(n=t.parse(n,2,Zt),!n)return null;const a=[];let o=null;"interpolate-hcl"!==i&&"interpolate-lab"!==i||t.expectedType==ei?t.expectedType&&"value"!==t.expectedType.kind&&(o=t.expectedType):o=Wt;for(let e=0;e<s.length;e+=2){const i=s[e],r=s[e+1],n=e+3,l=e+4;if("number"!=typeof i)return t.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(a.length&&a[a.length-1][0]>=i)return t.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const c=t.parse(r,l,o);if(!c)return null;o=o||c.type,a.push([i,c])}return hi(o,Zt)||hi(o,Ht)||hi(o,Wt)||hi(o,Qt)||hi(o,ti)||hi(o,ei)||hi(o,ri)||hi(o,ni(Zt))?new br(o,i,r,n,a):t.error(`Type ${si(o)} is not interpolatable.`)}evaluate(e){const t=this.labels,i=this.outputs;if(1===t.length)return i[0].evaluate(e);const r=this.input.evaluate(e);if(r<=t[0])return i[0].evaluate(e);const n=t.length;if(r>=t[n-1])return i[n-1].evaluate(e);const s=fr(t,r),a=br.interpolationFactor(this.interpolation,r,t[s],t[s+1]),o=i[s].evaluate(e),l=i[s+1].evaluate(e);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return Ri(o,l,a);case"color":return Li.interpolate(o,l,a);case"padding":return ji.interpolate(o,l,a);case"colorArray":return Ui.interpolate(o,l,a);case"numberArray":return Ni.interpolate(o,l,a);case"variableAnchorOffsetCollection":return $i.interpolate(o,l,a);case"array":return ki(o,l,a);case"projectionDefinition":return Wi.interpolate(o,l,a)}case"interpolate-hcl":switch(this.type.kind){case"color":return Li.interpolate(o,l,a,"hcl");case"colorArray":return Ui.interpolate(o,l,a,"hcl")}case"interpolate-lab":switch(this.type.kind){case"color":return Li.interpolate(o,l,a,"lab");case"colorArray":return Ui.interpolate(o,l,a,"lab")}}}eachChild(e){e(this.input);for(const t of this.outputs)e(t)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}}function wr(e,t,i,r){const n=r-i,s=e-i;return 0===n?0:1===t?s/n:(Math.pow(t,s)-1)/(Math.pow(t,n)-1)}const Tr={color:Li.interpolate,number:Ri,padding:ji.interpolate,numberArray:Ni.interpolate,colorArray:Ui.interpolate,variableAnchorOffsetCollection:$i.interpolate,array:ki};class Sr{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");let i=null;const r=t.expectedType;r&&"value"!==r.kind&&(i=r);const n=[];for(const r of e.slice(1)){const e=t.parse(r,1+n.length,i,void 0,{typeAnnotation:"omit"});if(!e)return null;i=i||e.type,n.push(e)}if(!i)throw new Error("No output type");const s=r&&n.some((e=>oi(r,e.type)));return new Sr(s?Yt:i,n)}evaluate(e){let t,i=null,r=0;for(const n of this.args)if(r++,i=n.evaluate(e),i&&i instanceof qi&&!i.available&&(t||(t=i.name),i=null,r===this.args.length&&(i=t)),null!==i)break;return i}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}}function Pr(e,t){return"=="===e||"!="===e?"boolean"===t.kind||"string"===t.kind||"number"===t.kind||"null"===t.kind||"value"===t.kind:"string"===t.kind||"number"===t.kind||"value"===t.kind}function Ir(e,t,i,r){return 0===r.compare(t,i)}function Mr(e,t,i){const r="=="!==e&&"!="!==e;return class n{constructor(e,t,i){this.type=qt,this.lhs=e,this.rhs=t,this.collator=i,this.hasUntypedArgument="value"===e.type.kind||"value"===t.type.kind}static parse(e,t){if(3!==e.length&&4!==e.length)return t.error("Expected two or three arguments.");const i=e[0];let s=t.parse(e[1],1,Yt);if(!s)return null;if(!Pr(i,s.type))return t.concat(1).error(`"${i}" comparisons are not supported for type '${si(s.type)}'.`);let a=t.parse(e[2],2,Yt);if(!a)return null;if(!Pr(i,a.type))return t.concat(2).error(`"${i}" comparisons are not supported for type '${si(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return t.error(`Cannot compare types '${si(s.type)}' and '${si(a.type)}'.`);r&&("value"===s.type.kind&&"value"!==a.type.kind?s=new er(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new er(s.type,[a])));let o=null;if(4===e.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return t.error("Cannot use collator to compare non-string types.");if(o=t.parse(e[3],3,Kt),!o)return null}return new n(s,a,o)}evaluate(n){const s=this.lhs.evaluate(n),a=this.rhs.evaluate(n);if(r&&this.hasUntypedArgument){const t=Yi(s),i=Yi(a);if(t.kind!==i.kind||"string"!==t.kind&&"number"!==t.kind)throw new Gi(`Expected arguments for "${e}" to be (string, string) or (number, number), but found (${t.kind}, ${i.kind}) instead.`)}if(this.collator&&!r&&this.hasUntypedArgument){const e=Yi(s),i=Yi(a);if("string"!==e.kind||"string"!==i.kind)return t(n,s,a)}return this.collator?i(n,s,a,this.collator.evaluate(n)):t(n,s,a)}eachChild(e){e(this.lhs),e(this.rhs),this.collator&&e(this.collator)}outputDefined(){return!0}}}const Er=Mr("==",(function(e,t,i){return t===i}),Ir),Cr=Mr("!=",(function(e,t,i){return t!==i}),(function(e,t,i,r){return!Ir(0,t,i,r)})),Ar=Mr("<",(function(e,t,i){return t<i}),(function(e,t,i,r){return r.compare(t,i)<0})),zr=Mr(">",(function(e,t,i){return t>i}),(function(e,t,i,r){return r.compare(t,i)>0})),Dr=Mr("<=",(function(e,t,i){return t<=i}),(function(e,t,i,r){return r.compare(t,i)<=0})),Rr=Mr(">=",(function(e,t,i){return t>=i}),(function(e,t,i,r){return r.compare(t,i)>=0}));class kr{constructor(e,t,i){this.type=Kt,this.locale=i,this.caseSensitive=e,this.diacriticSensitive=t}static parse(e,t){if(2!==e.length)return t.error("Expected one argument.");const i=e[1];if("object"!=typeof i||Array.isArray(i))return t.error("Collator options argument must be an object.");const r=t.parse(void 0!==i["case-sensitive"]&&i["case-sensitive"],1,qt);if(!r)return null;const n=t.parse(void 0!==i["diacritic-sensitive"]&&i["diacritic-sensitive"],1,qt);if(!n)return null;let s=null;return i.locale&&(s=t.parse(i.locale,1,$t),!s)?null:new kr(r,n,s)}evaluate(e){return new Fi(this.caseSensitive.evaluate(e),this.diacriticSensitive.evaluate(e),this.locale?this.locale.evaluate(e):null)}eachChild(e){e(this.caseSensitive),e(this.diacriticSensitive),this.locale&&e(this.locale)}outputDefined(){return!1}}class Lr{constructor(e,t,i,r,n){this.type=$t,this.number=e,this.locale=t,this.currency=i,this.minFractionDigits=r,this.maxFractionDigits=n}static parse(e,t){if(3!==e.length)return t.error("Expected two arguments.");const i=t.parse(e[1],1,Zt);if(!i)return null;const r=e[2];if("object"!=typeof r||Array.isArray(r))return t.error("NumberFormat options argument must be an object.");let n=null;if(r.locale&&(n=t.parse(r.locale,1,$t),!n))return null;let s=null;if(r.currency&&(s=t.parse(r.currency,1,$t),!s))return null;let a=null;if(r["min-fraction-digits"]&&(a=t.parse(r["min-fraction-digits"],1,Zt),!a))return null;let o=null;return r["max-fraction-digits"]&&(o=t.parse(r["max-fraction-digits"],1,Zt),!o)?null:new Lr(i,n,s,a,o)}evaluate(e){return new Intl.NumberFormat(this.locale?this.locale.evaluate(e):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(e):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(e):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(e):void 0}).format(this.number.evaluate(e))}eachChild(e){e(this.number),this.locale&&e(this.locale),this.currency&&e(this.currency),this.minFractionDigits&&e(this.minFractionDigits),this.maxFractionDigits&&e(this.maxFractionDigits)}outputDefined(){return!1}}class Fr{constructor(e){this.type=Jt,this.sections=e}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const i=e[1];if(!Array.isArray(i)&&"object"==typeof i)return t.error("First argument must be an image or text section.");const r=[];let n=!1;for(let i=1;i<=e.length-1;++i){const s=e[i];if(n&&"object"==typeof s&&!Array.isArray(s)){n=!1;let e=null;if(s["font-scale"]&&(e=t.parse(s["font-scale"],1,Zt),!e))return null;let i=null;if(s["text-font"]&&(i=t.parse(s["text-font"],1,ni($t)),!i))return null;let a=null;if(s["text-color"]&&(a=t.parse(s["text-color"],1,Wt),!a))return null;let o=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Bi.includes(s["vertical-align"]))return t.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(o=t.parse(s["vertical-align"],1,$t),!o)return null}const l=r[r.length-1];l.scale=e,l.font=i,l.textColor=a,l.verticalAlign=o}else{const s=t.parse(e[i],1,Yt);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return t.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,r.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null})}}return new Fr(r)}evaluate(e){return new Vi(this.sections.map((t=>{const i=t.content.evaluate(e);return Yi(i)===ii?new Oi("",i,null,null,null,t.verticalAlign?t.verticalAlign.evaluate(e):null):new Oi(Ki(i),null,t.scale?t.scale.evaluate(e):null,t.font?t.font.evaluate(e).join(","):null,t.textColor?t.textColor.evaluate(e):null,t.verticalAlign?t.verticalAlign.evaluate(e):null)})))}eachChild(e){for(const t of this.sections)e(t.content),t.scale&&e(t.scale),t.font&&e(t.font),t.textColor&&e(t.textColor),t.verticalAlign&&e(t.verticalAlign)}outputDefined(){return!1}}class Br{constructor(e){this.type=ii,this.input=e}static parse(e,t){if(2!==e.length)return t.error("Expected two arguments.");const i=t.parse(e[1],1,$t);return i?new Br(i):t.error("No image name provided.")}evaluate(e){const t=this.input.evaluate(e),i=qi.fromString(t);return i&&e.availableImages&&(i.available=e.availableImages.indexOf(t)>-1),i}eachChild(e){e(this.input)}outputDefined(){return!1}}class Or{constructor(e){this.type=Zt,this.input=e}static parse(e,t){if(2!==e.length)return t.error(`Expected 1 argument, but found ${e.length-1} instead.`);const i=t.parse(e[1],1);return i?"array"!==i.type.kind&&"string"!==i.type.kind&&"value"!==i.type.kind?t.error(`Expected argument of type string or array, but found ${si(i.type)} instead.`):new Or(i):null}evaluate(e){const t=this.input.evaluate(e);if("string"==typeof t)return[...t].length;if(Array.isArray(t))return t.length;throw new Gi(`Expected value to be of type string or array, but found ${si(Yi(t))} instead.`)}eachChild(e){e(this.input)}outputDefined(){return!1}}const Vr=8192;function jr(e,t){const i=(180+e[0])/360,r=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e[1]*Math.PI/360)))/360,n=Math.pow(2,t.z);return[Math.round(i*n*Vr),Math.round(r*n*Vr)]}function Nr(e,t){const i=Math.pow(2,t.z);return[(n=(e[0]/Vr+t.x)/i,360*n-180),(r=(e[1]/Vr+t.y)/i,360/Math.PI*Math.atan(Math.exp((180-360*r)*Math.PI/180))-90)];var r,n}function Ur(e,t){e[0]=Math.min(e[0],t[0]),e[1]=Math.min(e[1],t[1]),e[2]=Math.max(e[2],t[0]),e[3]=Math.max(e[3],t[1])}function Gr(e,t){return!(e[0]<=t[0]||e[2]>=t[2]||e[1]<=t[1]||e[3]>=t[3])}function Zr(e,t,i){const r=e[0]-t[0],n=e[1]-t[1],s=e[0]-i[0],a=e[1]-i[1];return r*a-s*n==0&&r*s<=0&&n*a<=0}function $r(e,t,i,r){return 0!=(n=[r[0]-i[0],r[1]-i[1]])[0]*(s=[t[0]-e[0],t[1]-e[1]])[1]-n[1]*s[0]&&!(!Kr(e,t,i,r)||!Kr(i,r,e,t));var n,s}function qr(e,t,i){for(const r of i)for(let i=0;i<r.length-1;++i)if($r(e,t,r[i],r[i+1]))return!0;return!1}function Wr(e,t,i=!1){let r=!1;for(const o of t)for(let t=0;t<o.length-1;t++){if(Zr(e,o[t],o[t+1]))return i;(s=o[t])[1]>(n=e)[1]!=(a=o[t+1])[1]>n[1]&&n[0]<(a[0]-s[0])*(n[1]-s[1])/(a[1]-s[1])+s[0]&&(r=!r)}var n,s,a;return r}function Hr(e,t){for(const i of t)if(Wr(e,i))return!0;return!1}function Xr(e,t){for(const i of e)if(!Wr(i,t))return!1;for(let i=0;i<e.length-1;++i)if(qr(e[i],e[i+1],t))return!1;return!0}function Yr(e,t){for(const i of t)if(Xr(e,i))return!0;return!1}function Kr(e,t,i,r){const n=r[0]-i[0],s=r[1]-i[1],a=(e[0]-i[0])*s-n*(e[1]-i[1]),o=(t[0]-i[0])*s-n*(t[1]-i[1]);return a>0&&o<0||a<0&&o>0}function Jr(e,t,i){const r=[];for(let n=0;n<e.length;n++){const s=[];for(let r=0;r<e[n].length;r++){const a=jr(e[n][r],i);Ur(t,a),s.push(a)}r.push(s)}return r}function Qr(e,t,i){const r=[];for(let n=0;n<e.length;n++){const s=Jr(e[n],t,i);r.push(s)}return r}function en(e,t,i,r){if(e[0]<i[0]||e[0]>i[2]){const t=.5*r;let n=e[0]-i[0]>t?-r:i[0]-e[0]>t?r:0;0===n&&(n=e[0]-i[2]>t?-r:i[2]-e[0]>t?r:0),e[0]+=n}Ur(t,e)}function tn(e,t,i,r){const n=Math.pow(2,r.z)*Vr,s=[r.x*Vr,r.y*Vr],a=[];for(const r of e)for(const e of r){const r=[e.x+s[0],e.y+s[1]];en(r,t,i,n),a.push(r)}return a}function rn(e,t,i,r){const n=Math.pow(2,r.z)*Vr,s=[r.x*Vr,r.y*Vr],a=[];for(const i of e){const e=[];for(const r of i){const i=[r.x+s[0],r.y+s[1]];Ur(t,i),e.push(i)}a.push(e)}if(t[2]-t[0]<=n/2){(o=t)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const e of a)for(const r of e)en(r,t,i,n)}var o;return a}class nn{constructor(e,t){this.type=qt,this.geojson=e,this.geometries=t}static parse(e,t){if(2!==e.length)return t.error(`'within' expression requires exactly one argument, but found ${e.length-1} instead.`);if(Xi(e[1])){const t=e[1];if("FeatureCollection"===t.type){const e=[];for(const i of t.features){const{type:t,coordinates:r}=i.geometry;"Polygon"===t&&e.push(r),"MultiPolygon"===t&&e.push(...r)}if(e.length)return new nn(t,{type:"MultiPolygon",coordinates:e})}else if("Feature"===t.type){const e=t.geometry.type;if("Polygon"===e||"MultiPolygon"===e)return new nn(t,t.geometry)}else if("Polygon"===t.type||"MultiPolygon"===t.type)return new nn(t,t)}return t.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(e){if(null!=e.geometry()&&null!=e.canonicalID()){if("Point"===e.geometryType())return function(e,t){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=e.canonicalID();if("Polygon"===t.type){const s=Jr(t.coordinates,r,n),a=tn(e.geometry(),i,r,n);if(!Gr(i,r))return!1;for(const e of a)if(!Wr(e,s))return!1}if("MultiPolygon"===t.type){const s=Qr(t.coordinates,r,n),a=tn(e.geometry(),i,r,n);if(!Gr(i,r))return!1;for(const e of a)if(!Hr(e,s))return!1}return!0}(e,this.geometries);if("LineString"===e.geometryType())return function(e,t){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=e.canonicalID();if("Polygon"===t.type){const s=Jr(t.coordinates,r,n),a=rn(e.geometry(),i,r,n);if(!Gr(i,r))return!1;for(const e of a)if(!Xr(e,s))return!1}if("MultiPolygon"===t.type){const s=Qr(t.coordinates,r,n),a=rn(e.geometry(),i,r,n);if(!Gr(i,r))return!1;for(const e of a)if(!Yr(e,s))return!1}return!0}(e,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}class sn{constructor(e=[],t=(e,t)=>e<t?-1:e>t?1:0){if(this.data=e,this.length=this.data.length,this.compare=t,this.length>0)for(let e=(this.length>>1)-1;e>=0;e--)this._down(e)}push(e){this.data.push(e),this._up(this.length++)}pop(){if(0===this.length)return;const e=this.data[0],t=this.data.pop();return--this.length>0&&(this.data[0]=t,this._down(0)),e}peek(){return this.data[0]}_up(e){const{data:t,compare:i}=this,r=t[e];for(;e>0;){const n=e-1>>1,s=t[n];if(i(r,s)>=0)break;t[e]=s,e=n}t[e]=r}_down(e){const{data:t,compare:i}=this,r=this.length>>1,n=t[e];for(;e<r;){let r=1+(e<<1);const s=r+1;if(s<this.length&&i(t[s],t[r])<0&&(r=s),i(t[r],n)>=0)break;t[e]=t[r],e=r}t[e]=n}}function an(e,t,i=0,r=e.length-1,n=ln){for(;r>i;){if(r-i>600){const s=r-i+1,a=t-i+1,o=Math.log(s),l=.5*Math.exp(2*o/3),c=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);an(e,t,Math.max(i,Math.floor(t-a*l/s+c)),Math.min(r,Math.floor(t+(s-a)*l/s+c)),n)}const s=e[t];let a=i,o=r;for(on(e,i,t),n(e[r],s)>0&&on(e,i,r);a<o;){for(on(e,a,o),a++,o--;n(e[a],s)<0;)a++;for(;n(e[o],s)>0;)o--}0===n(e[i],s)?on(e,i,o):(o++,on(e,o,r)),o<=t&&(i=o+1),t<=o&&(r=o-1)}}function on(e,t,i){const r=e[t];e[t]=e[i],e[i]=r}function ln(e,t){return e<t?-1:e>t?1:0}function cn(e,t){if(e.length<=1)return[e];const i=[];let r,n;for(const t of e){const e=un(t);0!==e&&(t.area=Math.abs(e),void 0===n&&(n=e<0),n===e<0?(r&&i.push(r),r=[t]):r.push(t))}if(r&&i.push(r),t>1)for(let e=0;e<i.length;e++)i[e].length<=t||(an(i[e],t,1,i[e].length-1,hn),i[e]=i[e].slice(0,t));return i}function hn(e,t){return t.area-e.area}function un(e){let t=0;for(let i,r,n=0,s=e.length,a=s-1;n<s;a=n++)i=e[n],r=e[a],t+=(r.x-i.x)*(i.y+r.y);return t}const dn=1/298.257223563,pn=dn*(2-dn),fn=Math.PI/180;class mn{constructor(e){const t=6378.137*fn*1e3,i=Math.cos(e*fn),r=1/(1-pn*(1-i*i)),n=Math.sqrt(r);this.kx=t*n*i,this.ky=t*n*r*(1-pn)}distance(e,t){const i=this.wrap(e[0]-t[0])*this.kx,r=(e[1]-t[1])*this.ky;return Math.sqrt(i*i+r*r)}pointOnLine(e,t){let i,r,n,s,a=1/0;for(let o=0;o<e.length-1;o++){let l=e[o][0],c=e[o][1],h=this.wrap(e[o+1][0]-l)*this.kx,u=(e[o+1][1]-c)*this.ky,d=0;0===h&&0===u||(d=(this.wrap(t[0]-l)*this.kx*h+(t[1]-c)*this.ky*u)/(h*h+u*u),d>1?(l=e[o+1][0],c=e[o+1][1]):d>0&&(l+=h/this.kx*d,c+=u/this.ky*d)),h=this.wrap(t[0]-l)*this.kx,u=(t[1]-c)*this.ky;const p=h*h+u*u;p<a&&(a=p,i=l,r=c,n=o,s=d)}return{point:[i,r],index:n,t:Math.max(0,Math.min(1,s))}}wrap(e){for(;e<-180;)e+=360;for(;e>180;)e-=360;return e}}function _n(e,t){return t[0]-e[0]}function gn(e){return e[1]-e[0]+1}function yn(e,t){return e[1]>=e[0]&&e[1]<t}function xn(e,t){if(e[0]>e[1])return[null,null];const i=gn(e);if(t){if(2===i)return[e,null];const t=Math.floor(i/2);return[[e[0],e[0]+t],[e[0]+t,e[1]]]}if(1===i)return[e,null];const r=Math.floor(i/2)-1;return[[e[0],e[0]+r],[e[0]+r+1,e[1]]]}function vn(e,t){if(!yn(t,e.length))return[1/0,1/0,-1/0,-1/0];const i=[1/0,1/0,-1/0,-1/0];for(let r=t[0];r<=t[1];++r)Ur(i,e[r]);return i}function bn(e){const t=[1/0,1/0,-1/0,-1/0];for(const i of e)for(const e of i)Ur(t,e);return t}function wn(e){return e[0]!==-1/0&&e[1]!==-1/0&&e[2]!==1/0&&e[3]!==1/0}function Tn(e,t,i){if(!wn(e)||!wn(t))return NaN;let r=0,n=0;return e[2]<t[0]&&(r=t[0]-e[2]),e[0]>t[2]&&(r=e[0]-t[2]),e[1]>t[3]&&(n=e[1]-t[3]),e[3]<t[1]&&(n=t[1]-e[3]),i.distance([0,0],[r,n])}function Sn(e,t,i){const r=i.pointOnLine(t,e);return i.distance(e,r.point)}function Pn(e,t,i,r,n){const s=Math.min(Sn(e,[i,r],n),Sn(t,[i,r],n)),a=Math.min(Sn(i,[e,t],n),Sn(r,[e,t],n));return Math.min(s,a)}function In(e,t,i,r,n){if(!yn(t,e.length)||!yn(r,i.length))return 1/0;let s=1/0;for(let a=t[0];a<t[1];++a){const t=e[a],o=e[a+1];for(let e=r[0];e<r[1];++e){const r=i[e],a=i[e+1];if($r(t,o,r,a))return 0;s=Math.min(s,Pn(t,o,r,a,n))}}return s}function Mn(e,t,i,r,n){if(!yn(t,e.length)||!yn(r,i.length))return NaN;let s=1/0;for(let a=t[0];a<=t[1];++a)for(let t=r[0];t<=r[1];++t)if(s=Math.min(s,n.distance(e[a],i[t])),0===s)return s;return s}function En(e,t,i){if(Wr(e,t,!0))return 0;let r=1/0;for(const n of t){const t=n[0],s=n[n.length-1];if(t!==s&&(r=Math.min(r,Sn(e,[s,t],i)),0===r))return r;const a=i.pointOnLine(n,e);if(r=Math.min(r,i.distance(e,a.point)),0===r)return r}return r}function Cn(e,t,i,r){if(!yn(t,e.length))return NaN;for(let r=t[0];r<=t[1];++r)if(Wr(e[r],i,!0))return 0;let n=1/0;for(let s=t[0];s<t[1];++s){const t=e[s],a=e[s+1];for(const e of i)for(let i=0,s=e.length,o=s-1;i<s;o=i++){const s=e[o],l=e[i];if($r(t,a,s,l))return 0;n=Math.min(n,Pn(t,a,s,l,r))}}return n}function An(e,t){for(const i of e)for(const e of i)if(Wr(e,t,!0))return!0;return!1}function zn(e,t,i,r=1/0){const n=bn(e),s=bn(t);if(r!==1/0&&Tn(n,s,i)>=r)return r;if(Gr(n,s)){if(An(e,t))return 0}else if(An(t,e))return 0;let a=1/0;for(const r of e)for(let e=0,n=r.length,s=n-1;e<n;s=e++){const n=r[s],o=r[e];for(const e of t)for(let t=0,r=e.length,s=r-1;t<r;s=t++){const r=e[s],l=e[t];if($r(n,o,r,l))return 0;a=Math.min(a,Pn(n,o,r,l,i))}}return a}function Dn(e,t,i,r,n,s){if(!s)return;const a=Tn(vn(r,s),n,i);a<t&&e.push([a,s,[0,0]])}function Rn(e,t,i,r,n,s,a){if(!s||!a)return;const o=Tn(vn(r,s),vn(n,a),i);o<t&&e.push([o,s,a])}function kn(e,t,i,r,n=1/0){let s=Math.min(r.distance(e[0],i[0][0]),n);if(0===s)return s;const a=new sn([[0,[0,e.length-1],[0,0]]],_n),o=bn(i);for(;a.length>0;){const n=a.pop();if(n[0]>=s)continue;const l=n[1],c=t?50:100;if(gn(l)<=c){if(!yn(l,e.length))return NaN;if(t){const t=Cn(e,l,i,r);if(isNaN(t)||0===t)return t;s=Math.min(s,t)}else for(let t=l[0];t<=l[1];++t){const n=En(e[t],i,r);if(s=Math.min(s,n),0===s)return 0}}else{const i=xn(l,t);Dn(a,s,r,e,o,i[0]),Dn(a,s,r,e,o,i[1])}}return s}function Ln(e,t,i,r,n,s=1/0){let a=Math.min(s,n.distance(e[0],i[0]));if(0===a)return a;const o=new sn([[0,[0,e.length-1],[0,i.length-1]]],_n);for(;o.length>0;){const s=o.pop();if(s[0]>=a)continue;const l=s[1],c=s[2],h=t?50:100,u=r?50:100;if(gn(l)<=h&&gn(c)<=u){if(!yn(l,e.length)&&yn(c,i.length))return NaN;let s;if(t&&r)s=In(e,l,i,c,n),a=Math.min(a,s);else if(t&&!r){const t=e.slice(l[0],l[1]+1);for(let e=c[0];e<=c[1];++e)if(s=Sn(i[e],t,n),a=Math.min(a,s),0===a)return a}else if(!t&&r){const t=i.slice(c[0],c[1]+1);for(let i=l[0];i<=l[1];++i)if(s=Sn(e[i],t,n),a=Math.min(a,s),0===a)return a}else s=Mn(e,l,i,c,n),a=Math.min(a,s)}else{const s=xn(l,t),h=xn(c,r);Rn(o,a,n,e,i,s[0],h[0]),Rn(o,a,n,e,i,s[0],h[1]),Rn(o,a,n,e,i,s[1],h[0]),Rn(o,a,n,e,i,s[1],h[1])}}return a}function Fn(e){return"MultiPolygon"===e.type?e.coordinates.map((e=>({type:"Polygon",coordinates:e}))):"MultiLineString"===e.type?e.coordinates.map((e=>({type:"LineString",coordinates:e}))):"MultiPoint"===e.type?e.coordinates.map((e=>({type:"Point",coordinates:e}))):[e]}class Bn{constructor(e,t){this.type=Zt,this.geojson=e,this.geometries=t}static parse(e,t){if(2!==e.length)return t.error(`'distance' expression requires exactly one argument, but found ${e.length-1} instead.`);if(Xi(e[1])){const t=e[1];if("FeatureCollection"===t.type)return new Bn(t,t.features.map((e=>Fn(e.geometry))).flat());if("Feature"===t.type)return new Bn(t,Fn(t.geometry));if("type"in t&&"coordinates"in t)return new Bn(t,Fn(t))}return t.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(e){if(null!=e.geometry()&&null!=e.canonicalID()){if("Point"===e.geometryType())return function(e,t){const i=e.geometry(),r=i.flat().map((t=>Nr([t.x,t.y],e.canonical)));if(0===i.length)return NaN;const n=new mn(r[0][1]);let s=1/0;for(const e of t){switch(e.type){case"Point":s=Math.min(s,Ln(r,!1,[e.coordinates],!1,n,s));break;case"LineString":s=Math.min(s,Ln(r,!1,e.coordinates,!0,n,s));break;case"Polygon":s=Math.min(s,kn(r,!1,e.coordinates,n,s))}if(0===s)return s}return s}(e,this.geometries);if("LineString"===e.geometryType())return function(e,t){const i=e.geometry(),r=i.flat().map((t=>Nr([t.x,t.y],e.canonical)));if(0===i.length)return NaN;const n=new mn(r[0][1]);let s=1/0;for(const e of t){switch(e.type){case"Point":s=Math.min(s,Ln(r,!0,[e.coordinates],!1,n,s));break;case"LineString":s=Math.min(s,Ln(r,!0,e.coordinates,!0,n,s));break;case"Polygon":s=Math.min(s,kn(r,!0,e.coordinates,n,s))}if(0===s)return s}return s}(e,this.geometries);if("Polygon"===e.geometryType())return function(e,t){const i=e.geometry();if(0===i.length||0===i[0].length)return NaN;const r=cn(i,0).map((t=>t.map((t=>t.map((t=>Nr([t.x,t.y],e.canonical))))))),n=new mn(r[0][0][0][1]);let s=1/0;for(const e of t)for(const t of r){switch(e.type){case"Point":s=Math.min(s,kn([e.coordinates],!1,t,n,s));break;case"LineString":s=Math.min(s,kn(e.coordinates,!0,t,n,s));break;case"Polygon":s=Math.min(s,zn(t,e.coordinates,n,s))}if(0===s)return s}return s}(e,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}class On{constructor(e){this.type=Yt,this.key=e}static parse(e,t){if(2!==e.length)return t.error(`Expected 1 argument, but found ${e.length-1} instead.`);const i=e[1];return null==i?t.error("Global state property must be defined."):"string"!=typeof i?t.error(`Global state property must be string, but found ${typeof e[1]} instead.`):new On(i)}evaluate(e){var t;const i=null===(t=e.globals)||void 0===t?void 0:t.globalState;return i&&0!==Object.keys(i).length?Mi(i,this.key):null}eachChild(){}outputDefined(){return!1}}const Vn={"==":Er,"!=":Cr,">":zr,"<":Ar,">=":Rr,"<=":Dr,array:er,at:lr,boolean:er,case:dr,coalesce:Sr,collator:kr,format:Fr,image:Br,in:cr,"index-of":hr,interpolate:br,"interpolate-hcl":br,"interpolate-lab":br,length:Or,let:ar,literal:Ji,match:ur,number:er,"number-format":Lr,object:er,slice:pr,step:mr,string:er,"to-boolean":ir,"to-color":ir,"to-number":ir,"to-string":ir,var:or,within:nn,distance:Bn,"global-state":On};class jn{constructor(e,t,i,r){this.name=e,this.type=t,this._evaluate=i,this.args=r}evaluate(e){return this._evaluate(e,this.args)}eachChild(e){this.args.forEach(e)}outputDefined(){return!1}static parse(e,t){const i=e[0],r=jn.definitions[i];if(!r)return t.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(r)?r[0]:r.type,s=Array.isArray(r)?[[r[1],r[2]]]:r.overloads,a=s.filter((([t])=>!Array.isArray(t)||t.length===e.length-1));let o=null;for(const[r,s]of a){o=new sr(t.registry,$n,t.path,null,t.scope);const a=[];let l=!1;for(let t=1;t<e.length;t++){const i=e[t],n=Array.isArray(r)?r[t-1]:r.type,s=o.parse(i,1+a.length,n);if(!s){l=!0;break}a.push(s)}if(!l)if(Array.isArray(r)&&r.length!==a.length)o.error(`Expected ${r.length} arguments, but found ${a.length} instead.`);else{for(let e=0;e<a.length;e++){const t=Array.isArray(r)?r[e]:r.type,i=a[e];o.concat(e+1).checkSubtype(t,i.type)}if(0===o.errors.length)return new jn(i,n,s,a)}}if(1===a.length)t.errors.push(...o.errors);else{const i=(a.length?a:s).map((([e])=>{return t=e,Array.isArray(t)?`(${t.map(si).join(", ")})`:`(${si(t.type)}...)`;var t})).join(" | "),r=[];for(let i=1;i<e.length;i++){const n=t.parse(e[i],1+r.length);if(!n)return null;r.push(si(n.type))}t.error(`Expected arguments of type ${i}, but found (${r.join(", ")}) instead.`)}return null}static register(e,t){jn.definitions=t;for(const i in t)e[i]=jn}}function Nn(e,[t,i,r,n]){t=t.evaluate(e),i=i.evaluate(e),r=r.evaluate(e);const s=n?n.evaluate(e):1,a=Hi(t,i,r,s);if(a)throw new Gi(a);return new Li(t/255,i/255,r/255,s,!1)}function Un(e,t){return e in t}function Gn(e,t){const i=t[e];return void 0===i?null:i}function Zn(e){return{type:e}}function $n(e){if(e instanceof or)return $n(e.boundExpression);if(e instanceof jn&&"error"===e.name)return!1;if(e instanceof kr)return!1;if(e instanceof nn)return!1;if(e instanceof Bn)return!1;if(e instanceof On)return!1;const t=e instanceof ir||e instanceof er;let i=!0;return e.eachChild((e=>{i=t?i&&$n(e):i&&e instanceof Ji})),!!i&&qn(e)&&Hn(e,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function qn(e){if(e instanceof jn){if("get"===e.name&&1===e.args.length)return!1;if("feature-state"===e.name)return!1;if("has"===e.name&&1===e.args.length)return!1;if("properties"===e.name||"geometry-type"===e.name||"id"===e.name)return!1;if(/^filter-/.test(e.name))return!1}if(e instanceof nn)return!1;if(e instanceof Bn)return!1;let t=!0;return e.eachChild((e=>{t&&!qn(e)&&(t=!1)})),t}function Wn(e){if(e instanceof jn&&"feature-state"===e.name)return!1;let t=!0;return e.eachChild((e=>{t&&!Wn(e)&&(t=!1)})),t}function Hn(e,t){if(e instanceof jn&&t.indexOf(e.name)>=0)return!1;let i=!0;return e.eachChild((e=>{i&&!Hn(e,t)&&(i=!1)})),i}function Xn(e){return{result:"success",value:e}}function Yn(e){return{result:"error",value:e}}function Kn(e){return"data-driven"===e["property-type"]||"cross-faded-data-driven"===e["property-type"]}function Jn(e){return!!e.expression&&e.expression.parameters.indexOf("zoom")>-1}function Qn(e){return!!e.expression&&e.expression.interpolated}function es(e){return e instanceof Number?"number":e instanceof String?"string":e instanceof Boolean?"boolean":Array.isArray(e)?"array":null===e?"null":typeof e}function ts(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)&&Yi(e)===Xt}function is(e){return e}function rs(e,t){const i=e.stops&&"object"==typeof e.stops[0][0],r=i||!(i||void 0!==e.property),n=e.type||(Qn(t)?"exponential":"interval"),s=function(e){switch(e.type){case"color":return Li.parse;case"padding":return ji.parse;case"numberArray":return Ni.parse;case"colorArray":return Ui.parse;default:return null}}(t);if(s&&((e=jt({},e)).stops&&(e.stops=e.stops.map((e=>[e[0],s(e[1])]))),e.default=s(e.default?e.default:t.default)),e.colorSpace&&"rgb"!==(a=e.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${e.colorSpace}"`);var a;const o=function(e){switch(e){case"exponential":return os;case"interval":return as;case"categorical":return ss;case"identity":return ls;default:throw new Error(`Unknown function type "${e}"`)}}(n);let l,c;if("categorical"===n){l=Object.create(null);for(const t of e.stops)l[t[0]]=t[1];c=typeof e.stops[0][0]}if(i){const i={},r=[];for(let t=0;t<e.stops.length;t++){const n=e.stops[t],s=n[0].zoom;void 0===i[s]&&(i[s]={zoom:s,type:e.type,property:e.property,default:e.default,stops:[]},r.push(s)),i[s].stops.push([n[0].value,n[1]])}const n=[];for(const e of r)n.push([i[e].zoom,rs(i[e],t)]);const s={name:"linear"};return{kind:"composite",interpolationType:s,interpolationFactor:br.interpolationFactor.bind(void 0,s),zoomStops:n.map((e=>e[0])),evaluate:({zoom:i},r)=>os({stops:n,base:e.base},t,i).evaluate(i,r)}}if(r){const i="exponential"===n?{name:"exponential",base:void 0!==e.base?e.base:1}:null;return{kind:"camera",interpolationType:i,interpolationFactor:br.interpolationFactor.bind(void 0,i),zoomStops:e.stops.map((e=>e[0])),evaluate:({zoom:i})=>o(e,t,i,l,c)}}return{kind:"source",evaluate(i,r){const n=r&&r.properties?r.properties[e.property]:void 0;return void 0===n?ns(e.default,t.default):o(e,t,n,l,c)}}}function ns(e,t,i){return void 0!==e?e:void 0!==t?t:void 0!==i?i:void 0}function ss(e,t,i,r,n){return ns(typeof i===n?r[i]:void 0,e.default,t.default)}function as(e,t,i){if("number"!==es(i))return ns(e.default,t.default);const r=e.stops.length;if(1===r)return e.stops[0][1];if(i<=e.stops[0][0])return e.stops[0][1];if(i>=e.stops[r-1][0])return e.stops[r-1][1];const n=fr(e.stops.map((e=>e[0])),i);return e.stops[n][1]}function os(e,t,i){const r=void 0!==e.base?e.base:1;if("number"!==es(i))return ns(e.default,t.default);const n=e.stops.length;if(1===n)return e.stops[0][1];if(i<=e.stops[0][0])return e.stops[0][1];if(i>=e.stops[n-1][0])return e.stops[n-1][1];const s=fr(e.stops.map((e=>e[0])),i),a=function(e,t,i,r){const n=r-i,s=e-i;return 0===n?0:1===t?s/n:(Math.pow(t,s)-1)/(Math.pow(t,n)-1)}(i,r,e.stops[s][0],e.stops[s+1][0]),o=e.stops[s][1],l=e.stops[s+1][1],c=Tr[t.type]||is;return"function"==typeof o.evaluate?{evaluate(...t){const i=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==i&&void 0!==r)return c(i,r,a,e.colorSpace)}}:c(o,l,a,e.colorSpace)}function ls(e,t,i){switch(t.type){case"color":i=Li.parse(i);break;case"formatted":i=Vi.fromString(i.toString());break;case"resolvedImage":i=qi.fromString(i.toString());break;case"padding":i=ji.parse(i);break;case"colorArray":i=Ui.parse(i);break;case"numberArray":i=Ni.parse(i);break;default:es(i)===t.type||"enum"===t.type&&t.values[i]||(i=void 0)}return ns(i,e.default,t.default)}jn.register(Vn,{error:[{kind:"error"},[$t],(e,[t])=>{throw new Gi(t.evaluate(e))}],typeof:[$t,[Yt],(e,[t])=>si(Yi(t.evaluate(e)))],"to-rgba":[ni(Zt,4),[Wt],(e,[t])=>{const[i,r,n,s]=t.evaluate(e).rgb;return[255*i,255*r,255*n,s]}],rgb:[Wt,[Zt,Zt,Zt],Nn],rgba:[Wt,[Zt,Zt,Zt,Zt],Nn],has:{type:qt,overloads:[[[$t],(e,[t])=>Un(t.evaluate(e),e.properties())],[[$t,Xt],(e,[t,i])=>Un(t.evaluate(e),i.evaluate(e))]]},get:{type:Yt,overloads:[[[$t],(e,[t])=>Gn(t.evaluate(e),e.properties())],[[$t,Xt],(e,[t,i])=>Gn(t.evaluate(e),i.evaluate(e))]]},"feature-state":[Yt,[$t],(e,[t])=>Gn(t.evaluate(e),e.featureState||{})],properties:[Xt,[],e=>e.properties()],"geometry-type":[$t,[],e=>e.geometryType()],id:[Yt,[],e=>e.id()],zoom:[Zt,[],e=>e.globals.zoom],"heatmap-density":[Zt,[],e=>e.globals.heatmapDensity||0],elevation:[Zt,[],e=>e.globals.elevation||0],"line-progress":[Zt,[],e=>e.globals.lineProgress||0],accumulated:[Yt,[],e=>void 0===e.globals.accumulated?null:e.globals.accumulated],"+":[Zt,Zn(Zt),(e,t)=>{let i=0;for(const r of t)i+=r.evaluate(e);return i}],"*":[Zt,Zn(Zt),(e,t)=>{let i=1;for(const r of t)i*=r.evaluate(e);return i}],"-":{type:Zt,overloads:[[[Zt,Zt],(e,[t,i])=>t.evaluate(e)-i.evaluate(e)],[[Zt],(e,[t])=>-t.evaluate(e)]]},"/":[Zt,[Zt,Zt],(e,[t,i])=>t.evaluate(e)/i.evaluate(e)],"%":[Zt,[Zt,Zt],(e,[t,i])=>t.evaluate(e)%i.evaluate(e)],ln2:[Zt,[],()=>Math.LN2],pi:[Zt,[],()=>Math.PI],e:[Zt,[],()=>Math.E],"^":[Zt,[Zt,Zt],(e,[t,i])=>Math.pow(t.evaluate(e),i.evaluate(e))],sqrt:[Zt,[Zt],(e,[t])=>Math.sqrt(t.evaluate(e))],log10:[Zt,[Zt],(e,[t])=>Math.log(t.evaluate(e))/Math.LN10],ln:[Zt,[Zt],(e,[t])=>Math.log(t.evaluate(e))],log2:[Zt,[Zt],(e,[t])=>Math.log(t.evaluate(e))/Math.LN2],sin:[Zt,[Zt],(e,[t])=>Math.sin(t.evaluate(e))],cos:[Zt,[Zt],(e,[t])=>Math.cos(t.evaluate(e))],tan:[Zt,[Zt],(e,[t])=>Math.tan(t.evaluate(e))],asin:[Zt,[Zt],(e,[t])=>Math.asin(t.evaluate(e))],acos:[Zt,[Zt],(e,[t])=>Math.acos(t.evaluate(e))],atan:[Zt,[Zt],(e,[t])=>Math.atan(t.evaluate(e))],min:[Zt,Zn(Zt),(e,t)=>Math.min(...t.map((t=>t.evaluate(e))))],max:[Zt,Zn(Zt),(e,t)=>Math.max(...t.map((t=>t.evaluate(e))))],abs:[Zt,[Zt],(e,[t])=>Math.abs(t.evaluate(e))],round:[Zt,[Zt],(e,[t])=>{const i=t.evaluate(e);return i<0?-Math.round(-i):Math.round(i)}],floor:[Zt,[Zt],(e,[t])=>Math.floor(t.evaluate(e))],ceil:[Zt,[Zt],(e,[t])=>Math.ceil(t.evaluate(e))],"filter-==":[qt,[$t,Yt],(e,[t,i])=>e.properties()[t.value]===i.value],"filter-id-==":[qt,[Yt],(e,[t])=>e.id()===t.value],"filter-type-==":[qt,[$t],(e,[t])=>e.geometryType()===t.value],"filter-<":[qt,[$t,Yt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r<n}],"filter-id-<":[qt,[Yt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i<r}],"filter->":[qt,[$t,Yt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r>n}],"filter-id->":[qt,[Yt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i>r}],"filter-<=":[qt,[$t,Yt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r<=n}],"filter-id-<=":[qt,[Yt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i<=r}],"filter->=":[qt,[$t,Yt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r>=n}],"filter-id->=":[qt,[Yt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i>=r}],"filter-has":[qt,[Yt],(e,[t])=>t.value in e.properties()],"filter-has-id":[qt,[],e=>null!==e.id()&&void 0!==e.id()],"filter-type-in":[qt,[ni($t)],(e,[t])=>t.value.indexOf(e.geometryType())>=0],"filter-id-in":[qt,[ni(Yt)],(e,[t])=>t.value.indexOf(e.id())>=0],"filter-in-small":[qt,[$t,ni(Yt)],(e,[t,i])=>i.value.indexOf(e.properties()[t.value])>=0],"filter-in-large":[qt,[$t,ni(Yt)],(e,[t,i])=>function(e,t,i,r){for(;i<=r;){const n=i+r>>1;if(t[n]===e)return!0;t[n]>e?r=n-1:i=n+1}return!1}(e.properties()[t.value],i.value,0,i.value.length-1)],all:{type:qt,overloads:[[[qt,qt],(e,[t,i])=>t.evaluate(e)&&i.evaluate(e)],[Zn(qt),(e,t)=>{for(const i of t)if(!i.evaluate(e))return!1;return!0}]]},any:{type:qt,overloads:[[[qt,qt],(e,[t,i])=>t.evaluate(e)||i.evaluate(e)],[Zn(qt),(e,t)=>{for(const i of t)if(i.evaluate(e))return!0;return!1}]]},"!":[qt,[qt],(e,[t])=>!t.evaluate(e)],"is-supported-script":[qt,[$t],(e,[t])=>{const i=e.globals&&e.globals.isSupportedScript;return!i||i(t.evaluate(e))}],upcase:[$t,[$t],(e,[t])=>t.evaluate(e).toUpperCase()],downcase:[$t,[$t],(e,[t])=>t.evaluate(e).toLowerCase()],concat:[$t,Zn(Yt),(e,t)=>t.map((t=>Ki(t.evaluate(e)))).join("")],"resolved-locale":[$t,[Kt],(e,[t])=>t.evaluate(e).resolvedLocale()]});class cs{constructor(e,t,i){this.expression=e,this._warningHistory={},this._evaluator=new nr,this._defaultValue=t?function(e){if("color"===e.type&&ts(e.default))return new Li(0,0,0,0);switch(e.type){case"color":return Li.parse(e.default)||null;case"padding":return ji.parse(e.default)||null;case"numberArray":return Ni.parse(e.default)||null;case"colorArray":return Ui.parse(e.default)||null;case"variableAnchorOffsetCollection":return $i.parse(e.default)||null;case"projectionDefinition":return Wi.parse(e.default)||null;default:return void 0===e.default?null:e.default}}(t):null,this._enumValues=t&&"enum"===t.type?t.values:null,this._globalState=i}evaluateWithoutErrorHandling(e,t,i,r,n,s){return this._globalState&&(e=ys(e,this._globalState)),this._evaluator.globals=e,this._evaluator.feature=t,this._evaluator.featureState=i,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(e,t,i,r,n,s){this._globalState&&(e=ys(e,this._globalState)),this._evaluator.globals=e,this._evaluator.feature=t||null,this._evaluator.featureState=i||null,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s||null;try{const e=this.expression.evaluate(this._evaluator);if(null==e||"number"==typeof e&&e!=e)return this._defaultValue;if(this._enumValues&&!(e in this._enumValues))throw new Gi(`Expected value to be one of ${Object.keys(this._enumValues).map((e=>JSON.stringify(e))).join(", ")}, but found ${JSON.stringify(e)} instead.`);return e}catch(e){return this._warningHistory[e.message]||(this._warningHistory[e.message]=!0,"undefined"!=typeof console&&console.warn(e.message)),this._defaultValue}}}function hs(e){return Array.isArray(e)&&e.length>0&&"string"==typeof e[0]&&e[0]in Vn}function us(e,t,i){const r=new sr(Vn,$n,[],t?function(e){const t={color:Wt,string:$t,number:Zt,enum:$t,boolean:qt,formatted:Jt,padding:Qt,numberArray:ti,colorArray:ei,projectionDefinition:Ht,resolvedImage:ii,variableAnchorOffsetCollection:ri};return"array"===e.type?ni(t[e.value]||Yt,e.length):t[e.type]}(t):void 0),n=r.parse(e,void 0,void 0,void 0,t&&"string"===t.type?{typeAnnotation:"coerce"}:void 0);return n?Xn(new cs(n,t,i)):Yn(r.errors)}class ds{constructor(e,t,i){this.kind=e,this._styleExpression=t,this.isStateDependent="constant"!==e&&!Wn(t.expression),this.globalStateRefs=gs(t.expression),this._globalState=i}evaluateWithoutErrorHandling(e,t,i,r,n,s){return this._globalState&&(e=ys(e,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(e,t,i,r,n,s)}evaluate(e,t,i,r,n,s){return this._globalState&&(e=ys(e,this._globalState)),this._styleExpression.evaluate(e,t,i,r,n,s)}}class ps{constructor(e,t,i,r,n){this.kind=e,this.zoomStops=i,this._styleExpression=t,this.isStateDependent="camera"!==e&&!Wn(t.expression),this.globalStateRefs=gs(t.expression),this.interpolationType=r,this._globalState=n}evaluateWithoutErrorHandling(e,t,i,r,n,s){return this._globalState&&(e=ys(e,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(e,t,i,r,n,s)}evaluate(e,t,i,r,n,s){return this._globalState&&(e=ys(e,this._globalState)),this._styleExpression.evaluate(e,t,i,r,n,s)}interpolationFactor(e,t,i){return this.interpolationType?br.interpolationFactor(this.interpolationType,e,t,i):0}}function fs(e,t,i){const r=us(e,t,i);if("error"===r.result)return r;const n=r.value.expression,s=qn(n);if(!s&&!Kn(t))return Yn([new Nt("","data expressions not supported")]);const a=Hn(n,["zoom"]);if(!a&&!Jn(t))return Yn([new Nt("","zoom expressions not supported")]);const o=_s(n);return o||a?o instanceof Nt?Yn([o]):o instanceof br&&!Qn(t)?Yn([new Nt("",'"interpolate" expressions cannot be used with this property')]):Xn(o?new ps(s?"camera":"composite",r.value,o.labels,o instanceof br?o.interpolation:void 0,i):new ds(s?"constant":"source",r.value,i)):Yn([new Nt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class ms{constructor(e,t){this._parameters=e,this._specification=t,jt(this,rs(this._parameters,this._specification))}static deserialize(e){return new ms(e._parameters,e._specification)}static serialize(e){return{_parameters:e._parameters,_specification:e._specification}}}function _s(e){let t=null;if(e instanceof ar)t=_s(e.result);else if(e instanceof Sr){for(const i of e.args)if(t=_s(i),t)break}else(e instanceof mr||e instanceof br)&&e.input instanceof jn&&"zoom"===e.input.name&&(t=e);return t instanceof Nt||e.eachChild((e=>{const i=_s(e);i instanceof Nt?t=i:!t&&i?t=new Nt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):t&&i&&t!==i&&(t=new Nt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),t}function gs(e,t=new Set){return e instanceof On&&t.add(e.key),e.eachChild((e=>{gs(e,t)})),t}function ys(e,t){const{zoom:i,heatmapDensity:r,elevation:n,lineProgress:s,isSupportedScript:a,accumulated:o}=null!=e?e:{};return{zoom:i,heatmapDensity:r,elevation:n,lineProgress:s,isSupportedScript:a,accumulated:o,globalState:t}}function xs(e){if(!0===e||!1===e)return!0;if(!Array.isArray(e)||0===e.length)return!1;switch(e[0]){case"has":return e.length>=2&&"$id"!==e[1]&&"$type"!==e[1];case"in":return e.length>=3&&("string"!=typeof e[1]||Array.isArray(e[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==e.length||Array.isArray(e[1])||Array.isArray(e[2]);case"any":case"all":for(const t of e.slice(1))if(!xs(t)&&"boolean"!=typeof t)return!1;return!0;default:return!0}}const vs={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function bs(e,t){if(null==e)return{filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};xs(e)||(e=Ss(e));const i=us(e,vs,t);if("error"===i.result)throw new Error(i.value.map((e=>`${e.key}: ${e.message}`)).join(", "));return{filter:(e,t,r)=>i.value.evaluate(e,t,{},r),needGeometry:Ts(e),getGlobalStateRefs:()=>gs(i.value.expression)}}function ws(e,t){return e<t?-1:e>t?1:0}function Ts(e){if(!Array.isArray(e))return!1;if("within"===e[0]||"distance"===e[0])return!0;for(let t=1;t<e.length;t++)if(Ts(e[t]))return!0;return!1}function Ss(e){if(!e)return!0;const t=e[0];return e.length<=1?"any"!==t:"=="===t?Ps(e[1],e[2],"=="):"!="===t?Es(Ps(e[1],e[2],"==")):"<"===t||">"===t||"<="===t||">="===t?Ps(e[1],e[2],t):"any"===t?(i=e.slice(1),["any"].concat(i.map(Ss))):"all"===t?["all"].concat(e.slice(1).map(Ss)):"none"===t?["all"].concat(e.slice(1).map(Ss).map(Es)):"in"===t?Is(e[1],e.slice(2)):"!in"===t?Es(Is(e[1],e.slice(2))):"has"===t?Ms(e[1]):"!has"!==t||Es(Ms(e[1]));var i}function Ps(e,t,i){switch(e){case"$type":return[`filter-type-${i}`,t];case"$id":return[`filter-id-${i}`,t];default:return[`filter-${i}`,e,t]}}function Is(e,t){if(0===t.length)return!1;switch(e){case"$type":return["filter-type-in",["literal",t]];case"$id":return["filter-id-in",["literal",t]];default:return t.length>200&&!t.some((e=>typeof e!=typeof t[0]))?["filter-in-large",e,["literal",t.sort(ws)]]:["filter-in-small",e,["literal",t]]}}function Ms(e){switch(e){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",e]}}function Es(e){return["!",e]}function Cs(e){const t=e.value;return t?[new Vt(e.key,t,"constants have been deprecated as of v8")]:[]}function As(e){return e instanceof Number||e instanceof String||e instanceof Boolean?e.valueOf():e}function zs(e){if(Array.isArray(e))return e.map(zs);if(e instanceof Object&&!(e instanceof Number||e instanceof String||e instanceof Boolean)){const t={};for(const i in e)t[i]=zs(e[i]);return t}return As(e)}function Ds(e){const t=e.key,i=e.value,r=e.valueSpec||{},n=e.objectElementValidators||{},s=e.style,a=e.styleSpec,o=e.validateSpec;let l=[];const c=es(i);if("object"!==c)return[new Vt(t,i,`object expected, ${c} found`)];for(const e in i){const c=e.split(".")[0],h=Mi(r,c)||r["*"];let u;if(Mi(n,c))u=n[c];else if(Mi(r,c)){if(void 0===i[e])continue;u=o}else if(n["*"])u=n["*"];else{if(!r["*"]){l.push(new Vt(t,i[e],`unknown property "${e}"`));continue}u=o}l=l.concat(u({key:(t?`${t}.`:t)+e,value:i[e],valueSpec:h,style:s,styleSpec:a,object:i,objectKey:e,validateSpec:o},i))}for(const e in r)n[e]||r[e].required&&void 0===r[e].default&&void 0===i[e]&&l.push(new Vt(t,i,`missing required property "${e}"`));return l}function Rs(e){const t=e.value,i=e.valueSpec,r=e.style,n=e.styleSpec,s=e.key,a=e.arrayElementValidator||e.validateSpec;if("array"!==es(t))return[new Vt(s,t,`array expected, ${es(t)} found`)];if(i.length&&t.length!==i.length)return[new Vt(s,t,`array length ${i.length} expected, length ${t.length} found`)];let o={type:i.value,values:i.values};n.$version<7&&(o.function=i.function),"object"===es(i.value)&&(o=i.value);let l=[];for(let i=0;i<t.length;i++)l=l.concat(a({array:t,arrayIndex:i,value:t[i],valueSpec:o,validateSpec:e.validateSpec,style:r,styleSpec:n,key:`${s}[${i}]`}));return l}function ks(e){const t=e.key,i=e.value,r=e.valueSpec;let n=es(i);return"number"===n&&i!=i&&(n="NaN"),"number"!==n?[new Vt(t,i,`number expected, ${n} found`)]:"minimum"in r&&i<r.minimum?[new Vt(t,i,`${i} is less than the minimum value ${r.minimum}`)]:"maximum"in r&&i>r.maximum?[new Vt(t,i,`${i} is greater than the maximum value ${r.maximum}`)]:[]}function Ls(e){const t=e.valueSpec,i=As(e.value.type);let r,n,s,a={};const o="categorical"!==i&&void 0===e.value.property,l=!o,c="array"===es(e.value.stops)&&"array"===es(e.value.stops[0])&&"object"===es(e.value.stops[0][0]),h=Ds({key:e.key,value:e.value,valueSpec:e.styleSpec.function,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{stops:function(e){if("identity"===i)return[new Vt(e.key,e.value,'identity function may not have a "stops" property')];let t=[];const r=e.value;return t=t.concat(Rs({key:e.key,value:r,valueSpec:e.valueSpec,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,arrayElementValidator:u})),"array"===es(r)&&0===r.length&&t.push(new Vt(e.key,r,"array must have at least one stop")),t},default:function(e){return e.validateSpec({key:e.key,value:e.value,valueSpec:t,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec})}}});return"identity"===i&&o&&h.push(new Vt(e.key,e.value,'missing required property "property"')),"identity"===i||e.value.stops||h.push(new Vt(e.key,e.value,'missing required property "stops"')),"exponential"===i&&e.valueSpec.expression&&!Qn(e.valueSpec)&&h.push(new Vt(e.key,e.value,"exponential functions not supported")),e.styleSpec.$version>=8&&(l&&!Kn(e.valueSpec)?h.push(new Vt(e.key,e.value,"property functions not supported")):o&&!Jn(e.valueSpec)&&h.push(new Vt(e.key,e.value,"zoom functions not supported"))),"categorical"!==i&&!c||void 0!==e.value.property||h.push(new Vt(e.key,e.value,'"property" property is required')),h;function u(e){let i=[];const r=e.value,o=e.key;if("array"!==es(r))return[new Vt(o,r,`array expected, ${es(r)} found`)];if(2!==r.length)return[new Vt(o,r,`array length 2 expected, length ${r.length} found`)];if(c){if("object"!==es(r[0]))return[new Vt(o,r,`object expected, ${es(r[0])} found`)];if(void 0===r[0].zoom)return[new Vt(o,r,"object stop key must have zoom")];if(void 0===r[0].value)return[new Vt(o,r,"object stop key must have value")];if(s&&s>As(r[0].zoom))return[new Vt(o,r[0].zoom,"stop zoom values must appear in ascending order")];As(r[0].zoom)!==s&&(s=As(r[0].zoom),n=void 0,a={}),i=i.concat(Ds({key:`${o}[0]`,value:r[0],valueSpec:{zoom:{}},validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{zoom:ks,value:d}}))}else i=i.concat(d({key:`${o}[0]`,value:r[0],validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec},r));return hs(zs(r[1]))?i.concat([new Vt(`${o}[1]`,r[1],"expressions are not allowed in function stops.")]):i.concat(e.validateSpec({key:`${o}[1]`,value:r[1],valueSpec:t,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec}))}function d(e,s){const o=es(e.value),l=As(e.value),c=null!==e.value?e.value:s;if(r){if(o!==r)return[new Vt(e.key,c,`${o} stop domain type must match previous stop domain type ${r}`)]}else r=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return[new Vt(e.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==i){let r=`number expected, ${o} found`;return Kn(t)&&void 0===i&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Vt(e.key,c,r)]}return"categorical"!==i||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==i&&"number"===o&&void 0!==n&&l<n?[new Vt(e.key,c,"stop domain values must appear in ascending order")]:(n=l,"categorical"===i&&l in a?[new Vt(e.key,c,"stop domain values must be unique")]:(a[l]=!0,[])):[new Vt(e.key,c,`integer expected, found ${l}`)]}}function Fs(e){const t=("property"===e.expressionContext?fs:us)(zs(e.value),e.valueSpec);if("error"===t.result)return t.value.map((t=>new Vt(`${e.key}${t.key}`,e.value,t.message)));const i=t.value.expression||t.value._styleExpression.expression;if("property"===e.expressionContext&&"text-font"===e.propertyKey&&!i.outputDefined())return[new Vt(e.key,e.value,`Invalid data expression for "${e.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===e.expressionContext&&"layout"===e.propertyType&&!Wn(i))return[new Vt(e.key,e.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===e.expressionContext&&!Wn(i))return[new Vt(e.key,e.value,'"feature-state" data expressions are not supported with filters.')];if(e.expressionContext&&0===e.expressionContext.indexOf("cluster")){if(!Hn(i,["zoom","feature-state"]))return[new Vt(e.key,e.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===e.expressionContext&&!qn(i))return[new Vt(e.key,e.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function Bs(e){const t=e.key,i=e.value,r=es(i);return"string"!==r?[new Vt(t,i,`color expected, ${r} found`)]:Li.parse(String(i))?[]:[new Vt(t,i,`color expected, "${i}" found`)]}function Os(e){const t=e.key,i=e.value,r=e.valueSpec,n=[];return Array.isArray(r.values)?-1===r.values.indexOf(As(i))&&n.push(new Vt(t,i,`expected one of [${r.values.join(", ")}], ${JSON.stringify(i)} found`)):-1===Object.keys(r.values).indexOf(As(i))&&n.push(new Vt(t,i,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(i)} found`)),n}function Vs(e){return xs(zs(e.value))?Fs(jt({},e,{expressionContext:"filter",valueSpec:{value:"boolean"}})):js(e)}function js(e){const t=e.value,i=e.key;if("array"!==es(t))return[new Vt(i,t,`array expected, ${es(t)} found`)];const r=e.styleSpec;let n,s=[];if(t.length<1)return[new Vt(i,t,"filter array must have at least 1 element")];switch(s=s.concat(Os({key:`${i}[0]`,value:t[0],valueSpec:r.filter_operator,style:e.style,styleSpec:e.styleSpec})),As(t[0])){case"<":case"<=":case">":case">=":t.length>=2&&"$type"===As(t[1])&&s.push(new Vt(i,t,`"$type" cannot be use with operator "${t[0]}"`));case"==":case"!=":3!==t.length&&s.push(new Vt(i,t,`filter array for operator "${t[0]}" must have 3 elements`));case"in":case"!in":t.length>=2&&(n=es(t[1]),"string"!==n&&s.push(new Vt(`${i}[1]`,t[1],`string expected, ${n} found`)));for(let a=2;a<t.length;a++)n=es(t[a]),"$type"===As(t[1])?s=s.concat(Os({key:`${i}[${a}]`,value:t[a],valueSpec:r.geometry_type,style:e.style,styleSpec:e.styleSpec})):"string"!==n&&"number"!==n&&"boolean"!==n&&s.push(new Vt(`${i}[${a}]`,t[a],`string, number, or boolean expected, ${n} found`));break;case"any":case"all":case"none":for(let r=1;r<t.length;r++)s=s.concat(js({key:`${i}[${r}]`,value:t[r],style:e.style,styleSpec:e.styleSpec}));break;case"has":case"!has":n=es(t[1]),2!==t.length?s.push(new Vt(i,t,`filter array for "${t[0]}" operator must have 2 elements`)):"string"!==n&&s.push(new Vt(`${i}[1]`,t[1],`string expected, ${n} found`))}return s}function Ns(e,t){const i=e.key,r=e.validateSpec,n=e.style,s=e.styleSpec,a=e.value,o=e.objectKey,l=s[`${t}_${e.layerType}`];if(!l)return[];const c=o.match(/^(.*)-transition$/);if("paint"===t&&c&&l[c[1]]&&l[c[1]].transition)return r({key:i,value:a,valueSpec:s.transition,style:n,styleSpec:s});const h=e.valueSpec||l[o];if(!h)return[new Vt(i,a,`unknown property "${o}"`)];let u;if("string"===es(a)&&Kn(h)&&!h.tokens&&(u=/^{([^}]+)}$/.exec(a)))return[new Vt(i,a,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(u[1])} }\`.`)];const d=[];return"symbol"===e.layerType&&"text-font"===o&&ts(zs(a))&&"identity"===As(a.type)&&d.push(new Vt(i,a,'"text-font" does not support identity functions')),d.concat(r({key:e.key,value:a,valueSpec:h,style:n,styleSpec:s,expressionContext:"property",propertyType:t,propertyKey:o}))}function Us(e){return Ns(e,"paint")}function Gs(e){return Ns(e,"layout")}function Zs(e){let t=[];const i=e.value,r=e.key,n=e.style,s=e.styleSpec;if("object"!==es(i))return[new Vt(r,i,`object expected, ${es(i)} found`)];i.type||i.ref||t.push(new Vt(r,i,'either "type" or "ref" is required'));let a=As(i.type);const o=As(i.ref);if(i.id){const s=As(i.id);for(let a=0;a<e.arrayIndex;a++){const e=n.layers[a];As(e.id)===s&&t.push(new Vt(r,i.id,`duplicate layer id "${i.id}", previously used at line ${e.id.__line__}`))}}if("ref"in i){let e;["type","source","source-layer","filter","layout"].forEach((e=>{e in i&&t.push(new Vt(r,i[e],`"${e}" is prohibited for ref layers`))})),n.layers.forEach((t=>{As(t.id)===o&&(e=t)})),e?e.ref?t.push(new Vt(r,i.ref,"ref cannot reference another ref layer")):a=As(e.type):t.push(new Vt(r,i.ref,`ref layer "${o}" not found`))}else if("background"!==a)if(i.source){const e=n.sources&&n.sources[i.source],s=e&&As(e.type);e?"vector"===s&&"raster"===a?t.push(new Vt(r,i.source,`layer "${i.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===a||"raster-dem"!==s&&"color-relief"===a?t.push(new Vt(r,i.source,`layer "${i.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==a?t.push(new Vt(r,i.source,`layer "${i.id}" requires a vector source`)):"vector"!==s||i["source-layer"]?"raster-dem"===s&&"hillshade"!==a&&"color-relief"!==a?t.push(new Vt(r,i.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==a||!i.paint||!i.paint["line-gradient"]||"geojson"===s&&e.lineMetrics||t.push(new Vt(r,i,`layer "${i.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):t.push(new Vt(r,i,`layer "${i.id}" must specify a "source-layer"`)):t.push(new Vt(r,i.source,`source "${i.source}" not found`))}else t.push(new Vt(r,i,'missing required property "source"'));return t=t.concat(Ds({key:r,value:i,valueSpec:s.layer,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":()=>[],type:()=>e.validateSpec({key:`${r}.type`,value:i.type,valueSpec:s.layer.type,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,object:i,objectKey:"type"}),filter:Vs,layout:e=>Ds({layer:i,key:e.key,value:e.value,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":e=>Gs(jt({layerType:a},e))}}),paint:e=>Ds({layer:i,key:e.key,value:e.value,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":e=>Us(jt({layerType:a},e))}})}})),t}function $s(e){const t=e.value,i=e.key,r=es(t);return"string"!==r?[new Vt(i,t,`string expected, ${r} found`)]:[]}const qs={promoteId:function({key:e,value:t}){if("string"===es(t))return $s({key:e,value:t});{const i=[];for(const r in t)i.push(...$s({key:`${e}.${r}`,value:t[r]}));return i}}};function Ws(e){const t=e.value,i=e.key,r=e.styleSpec,n=e.style,s=e.validateSpec;if(!t.type)return[new Vt(i,t,'"type" is required')];const a=As(t.type);let o;switch(a){case"vector":case"raster":return o=Ds({key:i,value:t,valueSpec:r[`source_${a.replace("-","_")}`],style:e.style,styleSpec:r,objectElementValidators:qs,validateSpec:s}),o;case"raster-dem":return o=function(e){var t;const i=null!==(t=e.sourceName)&&void 0!==t?t:"",r=e.value,n=e.styleSpec,s=n.source_raster_dem,a=e.style;let o=[];const l=es(r);if(void 0===r)return o;if("object"!==l)return o.push(new Vt("source_raster_dem",r,`object expected, ${l} found`)),o;const c="custom"===As(r.encoding),h=["redFactor","greenFactor","blueFactor","baseShift"],u=e.value.encoding?`"${e.value.encoding}"`:"Default";for(const t in r)!c&&h.includes(t)?o.push(new Vt(t,r[t],`In "${i}": "${t}" is only valid when "encoding" is set to "custom". ${u} encoding found`)):s[t]?o=o.concat(e.validateSpec({key:t,value:r[t],valueSpec:s[t],validateSpec:e.validateSpec,style:a,styleSpec:n})):o.push(new Vt(t,r[t],`unknown property "${t}"`));return o}({sourceName:i,value:t,style:e.style,styleSpec:r,validateSpec:s}),o;case"geojson":if(o=Ds({key:i,value:t,valueSpec:r.source_geojson,style:n,styleSpec:r,validateSpec:s,objectElementValidators:qs}),t.cluster)for(const e in t.clusterProperties){const[r,n]=t.clusterProperties[e],s="string"==typeof r?[r,["accumulated"],["get",e]]:r;o.push(...Fs({key:`${i}.${e}.map`,value:n,expressionContext:"cluster-map"})),o.push(...Fs({key:`${i}.${e}.reduce`,value:s,expressionContext:"cluster-reduce"}))}return o;case"video":return Ds({key:i,value:t,valueSpec:r.source_video,style:n,validateSpec:s,styleSpec:r});case"image":return Ds({key:i,value:t,valueSpec:r.source_image,style:n,validateSpec:s,styleSpec:r});case"canvas":return[new Vt(i,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Os({key:`${i}.type`,value:t.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Hs(e){const t=e.value,i=e.styleSpec,r=i.light,n=e.style;let s=[];const a=es(t);if(void 0===t)return s;if("object"!==a)return s=s.concat([new Vt("light",t,`object expected, ${a} found`)]),s;for(const a in t){const o=a.match(/^(.*)-transition$/);s=s.concat(o&&r[o[1]]&&r[o[1]].transition?e.validateSpec({key:a,value:t[a],valueSpec:i.transition,validateSpec:e.validateSpec,style:n,styleSpec:i}):r[a]?e.validateSpec({key:a,value:t[a],valueSpec:r[a],validateSpec:e.validateSpec,style:n,styleSpec:i}):[new Vt(a,t[a],`unknown property "${a}"`)])}return s}function Xs(e){const t=e.value,i=e.styleSpec,r=i.sky,n=e.style,s=es(t);if(void 0===t)return[];if("object"!==s)return[new Vt("sky",t,`object expected, ${s} found`)];let a=[];for(const s in t)a=a.concat(r[s]?e.validateSpec({key:s,value:t[s],valueSpec:r[s],style:n,styleSpec:i}):[new Vt(s,t[s],`unknown property "${s}"`)]);return a}function Ys(e){const t=e.value,i=e.styleSpec,r=i.terrain,n=e.style;let s=[];const a=es(t);if(void 0===t)return s;if("object"!==a)return s=s.concat([new Vt("terrain",t,`object expected, ${a} found`)]),s;for(const a in t)s=s.concat(r[a]?e.validateSpec({key:a,value:t[a],valueSpec:r[a],validateSpec:e.validateSpec,style:n,styleSpec:i}):[new Vt(a,t[a],`unknown property "${a}"`)]);return s}function Ks(e){let t=[];const i=e.value,r=e.key;if(Array.isArray(i)){const n=[],s=[];for(const a in i)i[a].id&&n.includes(i[a].id)&&t.push(new Vt(r,i,`all the sprites' ids must be unique, but ${i[a].id} is duplicated`)),n.push(i[a].id),i[a].url&&s.includes(i[a].url)&&t.push(new Vt(r,i,`all the sprites' URLs must be unique, but ${i[a].url} is duplicated`)),s.push(i[a].url),t=t.concat(Ds({key:`${r}[${a}]`,value:i[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:e.validateSpec}));return t}return $s({key:r,value:i})}function Js(e){return Boolean(e)&&e.constructor===Object}function Qs(e){return Js(e.value)?[]:[new Vt(e.key,e.value,`object expected, ${es(e.value)} found`)]}const ea={"*":()=>[],array:Rs,boolean:function(e){const t=e.value,i=e.key,r=es(t);return"boolean"!==r?[new Vt(i,t,`boolean expected, ${r} found`)]:[]},number:ks,color:Bs,constants:Cs,enum:Os,filter:Vs,function:Ls,layer:Zs,object:Ds,source:Ws,light:Hs,sky:Xs,terrain:Ys,projection:function(e){const t=e.value,i=e.styleSpec,r=i.projection,n=e.style,s=es(t);if(void 0===t)return[];if("object"!==s)return[new Vt("projection",t,`object expected, ${s} found`)];let a=[];for(const s in t)a=a.concat(r[s]?e.validateSpec({key:s,value:t[s],valueSpec:r[s],style:n,styleSpec:i}):[new Vt(s,t[s],`unknown property "${s}"`)]);return a},projectionDefinition:function(e){const t=e.key;let i=e.value;i=i instanceof String?i.valueOf():i;const r=es(i);return"array"!==r||function(e){return Array.isArray(e)&&3===e.length&&"string"==typeof e[0]&&"string"==typeof e[1]&&"number"==typeof e[2]}(i)||function(e){return!!["interpolate","step","literal"].includes(e[0])}(i)?["array","string"].includes(r)?[]:[new Vt(t,i,`projection expected, invalid type "${r}" found`)]:[new Vt(t,i,`projection expected, invalid array ${JSON.stringify(i)} found`)]},string:$s,formatted:function(e){return 0===$s(e).length?[]:Fs(e)},resolvedImage:function(e){return 0===$s(e).length?[]:Fs(e)},padding:function(e){const t=e.key,i=e.value;if("array"===es(i)){if(i.length<1||i.length>4)return[new Vt(t,i,`padding requires 1 to 4 values; ${i.length} values found`)];const r={type:"number"};let n=[];for(let s=0;s<i.length;s++)n=n.concat(e.validateSpec({key:`${t}[${s}]`,value:i[s],validateSpec:e.validateSpec,valueSpec:r}));return n}return ks({key:t,value:i,valueSpec:{}})},numberArray:function(e){const t=e.key,i=e.value;if("array"===es(i)){const r={type:"number"};if(i.length<1)return[new Vt(t,i,"array length at least 1 expected, length 0 found")];let n=[];for(let s=0;s<i.length;s++)n=n.concat(e.validateSpec({key:`${t}[${s}]`,value:i[s],validateSpec:e.validateSpec,valueSpec:r}));return n}return ks({key:t,value:i,valueSpec:{}})},colorArray:function(e){const t=e.key,i=e.value;if("array"===es(i)){if(i.length<1)return[new Vt(t,i,"array length at least 1 expected, length 0 found")];let e=[];for(let r=0;r<i.length;r++)e=e.concat(Bs({key:`${t}[${r}]`,value:i[r]}));return e}return Bs({key:t,value:i})},variableAnchorOffsetCollection:function(e){const t=e.key,i=e.value,r=es(i),n=e.styleSpec;if("array"!==r||i.length<1||i.length%2!=0)return[new Vt(t,i,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let r=0;r<i.length;r+=2)s=s.concat(Os({key:`${t}[${r}]`,value:i[r],valueSpec:n.layout_symbol["text-anchor"]})),s=s.concat(Rs({key:`${t}[${r+1}]`,value:i[r+1],valueSpec:{length:2,value:"number"},validateSpec:e.validateSpec,style:e.style,styleSpec:n}));return s},sprite:Ks,state:Qs,fontFaces:function(e){const t=e.key,i=e.value,r=e.validateSpec,n=e.styleSpec,s=e.style;if(!Js(i))return[new Vt(t,i,`object expected, ${es(i)} found`)];const a=[];for(const e in i){const o=i[e],l=es(o);if("string"===l)a.push(...$s({key:`${t}.${e}`,value:o}));else if("array"===l){const i={url:{type:"string",required:!0},"unicode-range":{type:"array",value:"string"}};for(const[l,c]of o.entries())a.push(...Ds({key:`${t}.${e}[${l}]`,value:c,valueSpec:i,styleSpec:n,style:s,validateSpec:r}))}else a.push(new Vt(`${t}.${e}`,o,`string or array expected, ${l} found`))}return a}};function ta(e){const t=e.value,i=e.valueSpec,r=e.styleSpec;return e.validateSpec=ta,i.expression&&ts(As(t))?Ls(e):i.expression&&hs(zs(t))?Fs(e):i.type&&ea[i.type]?ea[i.type](e):Ds(jt({},e,{valueSpec:i.type?r[i.type]:i}))}function ia(e){const t=e.value,i=e.key,r=$s(e);return r.length||(-1===t.indexOf("{fontstack}")&&r.push(new Vt(i,t,'"glyphs" url must include a "{fontstack}" token')),-1===t.indexOf("{range}")&&r.push(new Vt(i,t,'"glyphs" url must include a "{range}" token'))),r}function ra(e,t=It){let i=[];return i=i.concat(ta({key:"",value:e,valueSpec:t.$root,styleSpec:t,style:e,validateSpec:ta,objectElementValidators:{glyphs:ia,"*":()=>[]}})),e.constants&&(i=i.concat(Cs({key:"constants",value:e.constants}))),sa(i)}function na(e){return function(t){return e(Object.assign({},t,{validateSpec:ta}))}}function sa(e){return[].concat(e).sort(((e,t)=>e.line-t.line))}function aa(e){return function(...t){return sa(e.apply(this,t))}}ra.source=aa(na(Ws)),ra.sprite=aa(na(Ks)),ra.glyphs=aa(na(ia)),ra.light=aa(na(Hs)),ra.sky=aa(na(Xs)),ra.terrain=aa(na(Ys)),ra.state=aa(na(Qs)),ra.layer=aa(na(Zs)),ra.filter=aa(na(Vs)),ra.paintProperty=aa(na(Us)),ra.layoutProperty=aa(na(Gs));const oa={type:"enum","property-type":"data-constant",expression:{interpolated:!1,parameters:["global-state"]},values:{visible:{},none:{}},transition:!1,default:"visible"};class la{constructor(e,t){this._globalState=t,this.setValue(e)}evaluate(){var e;return null!==(e=this._literalValue)&&void 0!==e?e:this._compiledValue.evaluate({})}setValue(e){if(null==e||"visible"===e||"none"===e)return this._literalValue="none"===e?"none":"visible",this._compiledValue=void 0,void(this._globalStateRefs=new Set);const t=us(e,oa,this._globalState);if("error"===t.result)throw this._literalValue="visible",this._compiledValue=void 0,new Error(t.value.map((e=>`${e.key}: ${e.message}`)).join(", "));this._literalValue=void 0,this._compiledValue=t.value,this._globalStateRefs=gs(t.value.expression)}getGlobalStateRefs(){return this._globalStateRefs}}const ca=It,ha=ra,ua=ha.light,da=ha.sky,pa=ha.paintProperty,fa=ha.layoutProperty;function ma(e,t){let i=!1;if(t&&t.length)for(const r of t)e.fire(new St(new Error(r.message))),i=!0;return i}class _a{constructor(e,t,i){const r=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;const n=new Int32Array(this.arrayBuffer);e=n[0],this.d=(t=n[1])+2*(i=n[2]);for(let e=0;e<this.d*this.d;e++){const t=n[3+e],i=n[3+e+1];r.push(t===i?null:n.subarray(t,i))}const s=n[3+r.length+1];this.keys=n.subarray(n[3+r.length],s),this.bboxes=n.subarray(s),this.insert=this._insertReadonly}else{this.d=t+2*i;for(let e=0;e<this.d*this.d;e++)r.push([]);this.keys=[],this.bboxes=[]}this.n=t,this.extent=e,this.padding=i,this.scale=t/e,this.uid=0;const n=i/t*e;this.min=-n,this.max=e+n}insert(e,t,i,r,n){this._forEachCell(t,i,r,n,this._insertCell,this.uid++,void 0,void 0),this.keys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(e,t,i,r,n,s){this.cells[n].push(s)}query(e,t,i,r,n){const s=this.min,a=this.max;if(e<=s&&t<=s&&a<=i&&a<=r&&!n)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(e,t,i,r,this._queryCell,s,{},n),s}}_queryCell(e,t,i,r,n,s,a,o){const l=this.cells[n];if(null!==l){const n=this.keys,c=this.bboxes;for(let h=0;h<l.length;h++){const u=l[h];if(void 0===a[u]){const l=4*u;(o?o(c[l+0],c[l+1],c[l+2],c[l+3]):e<=c[l+2]&&t<=c[l+3]&&i>=c[l+0]&&r>=c[l+1])?(a[u]=!0,s.push(n[u])):a[u]=!1}}}}_forEachCell(e,t,i,r,n,s,a,o){const l=this._convertToCellCoord(e),c=this._convertToCellCoord(t),h=this._convertToCellCoord(i),u=this._convertToCellCoord(r);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++){const c=this.d*l+d;if((!o||o(this._convertFromCellCoord(d),this._convertFromCellCoord(l),this._convertFromCellCoord(d+1),this._convertFromCellCoord(l+1)))&&n.call(this,e,t,i,r,c,s,a,o))return}}_convertFromCellCoord(e){return(e-this.padding)/this.scale}_convertToCellCoord(e){return Math.max(0,Math.min(this.d-1,Math.floor(e*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const e=this.cells,t=3+this.cells.length+1+1;let i=0;for(let e=0;e<this.cells.length;e++)i+=this.cells[e].length;const r=new Int32Array(t+i+this.keys.length+this.bboxes.length);r[0]=this.extent,r[1]=this.n,r[2]=this.padding;let n=t;for(let t=0;t<e.length;t++){const i=e[t];r[3+t]=n,r.set(i,n),n+=i.length}return r[3+e.length]=n,r.set(this.keys,n),n+=this.keys.length,r[3+e.length+1]=n,r.set(this.bboxes,n),n+=this.bboxes.length,r.buffer}static serialize(e,t){const i=e.toArrayBuffer();return t&&t.push(i),{buffer:i}}static deserialize(e){return new _a(e.buffer)}}const ga={};function ya(e,t,i={}){if(ga[e])throw new Error(`${e} is already registered.`);Object.defineProperty(t,"_classRegistryKey",{value:e,writeable:!1}),ga[e]={klass:t,omit:i.omit||[],shallow:i.shallow||[]}}ya("Object",Object),ya("Set",Set),ya("TransferableGridIndex",_a),ya("Color",Li),ya("Error",Error),ya("AJAXError",lt),ya("ResolvedImage",qi),ya("StylePropertyFunction",ms),ya("StyleExpression",cs,{omit:["_evaluator"]}),ya("ZoomDependentExpression",ps),ya("ZoomConstantExpression",ds),ya("CompoundExpression",jn,{omit:["_evaluate"]});for(const e in Vn)Vn[e]._classRegistryKey||ya(`Expression_${e}`,Vn[e]);function xa(e){return e&&"undefined"!=typeof ArrayBuffer&&(e instanceof ArrayBuffer||e.constructor&&"ArrayBuffer"===e.constructor.name)}function va(e){return e.$name||e.constructor._classRegistryKey}function ba(e){return!function(e){if(null===e||"object"!=typeof e)return!1;const t=va(e);return!(!t||"Object"===t)}(e)&&(null==e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e||e instanceof Boolean||e instanceof Number||e instanceof String||e instanceof Date||e instanceof RegExp||e instanceof Blob||e instanceof Error||xa(e)||Be(e)||ArrayBuffer.isView(e)||e instanceof ImageData)}function wa(e,t){if(ba(e))return(xa(e)||Be(e))&&t&&t.push(e),ArrayBuffer.isView(e)&&t&&t.push(e.buffer),e instanceof ImageData&&t&&t.push(e.data.buffer),e;if(Array.isArray(e)){const i=[];for(const r of e)i.push(wa(r,t));return i}if("object"!=typeof e)throw new Error("can't serialize object of type "+typeof e);const i=va(e);if(!i)throw new Error(`can't serialize object of unregistered class ${e.constructor.name}`);if(!ga[i])throw new Error(`${i} is not registered.`);const{klass:r}=ga[i],n=r.serialize?r.serialize(e,t):{};if(r.serialize){if(t&&n===t[t.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const r in e){if(!e.hasOwnProperty(r))continue;if(ga[i].omit.indexOf(r)>=0)continue;const s=e[r];n[r]=ga[i].shallow.indexOf(r)>=0?s:wa(s,t)}e instanceof Error&&(n.message=e.message)}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==i&&(n.$name=i),n}function Ta(e){if(ba(e))return e;if(Array.isArray(e))return e.map(Ta);if("object"!=typeof e)throw new Error("can't deserialize object of type "+typeof e);const t=va(e)||"Object";if(!ga[t])throw new Error(`can't deserialize unregistered class ${t}`);const{klass:i}=ga[t];if(!i)throw new Error(`can't deserialize unregistered class ${t}`);if(i.deserialize)return i.deserialize(e);const r=Object.create(i.prototype);for(const i of Object.keys(e)){if("$name"===i)continue;const n=e[i];r[i]=ga[t].shallow.indexOf(i)>=0?n:Ta(n)}return r}class Sa{constructor(){this.first=!0}update(e,t){const i=Math.floor(e);return this.first?(this.first=!1,this.lastIntegerZoom=i,this.lastIntegerZoomTime=0,this.lastZoom=e,this.lastFloorZoom=i,!0):(this.lastFloorZoom>i?(this.lastIntegerZoom=i+1,this.lastIntegerZoomTime=t):this.lastFloorZoom<i&&(this.lastIntegerZoom=i,this.lastIntegerZoomTime=t),e!==this.lastZoom&&(this.lastZoom=e,this.lastFloorZoom=i,!0))}}function Pa(e){for(const i of e)if(t=i.codePointAt(0),/[\u02EA\u02EB\u1100-\u11FF\u1400-\u167F\u18B0-\u18F5\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u3007\u3012\u3013\u3020-\u302F\u3031-\u303F\u3041-\u3096\u309D-\u30FB\u30FD-\u30FF\u3105-\u312F\u3131-\u318E\u3190-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE48\uFE50-\uFE57\uFE5F-\uFE62\uFE67-\uFE6F\uFF00-\uFF07\uFF0A-\uFF0C\uFF0E-\uFF19\uFF1F-\uFF3A\uFF3C\uFF3E\uFF40-\uFF5A\uFFE0-\uFFE2\uFFE4-\uFFE7]|\uD802[\uDD80-\uDD9F]|\uD805[\uDD80-\uDDFF]|\uD806[\uDE00-\uDEBF]|\uD811[\uDC00-\uDE7F]|\uD81B[\uDFE0-\uDFE4\uDFF0-\uDFF6]|[\uD81C-\uD822\uD83D\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD30-\uDEFB]|\uD833[\uDEC0-\uDFCF]|\uD834[\uDC00-\uDDFF\uDEE0-\uDF7F]|\uD836[\uDC00-\uDEAF]|\uD83C[\uDC00-\uDE00\uDF00-\uDFFF]|\uD83E[\uDD00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(t)))return!0;var t;return!1}function Ia(e){const t=e.map((e=>{try{return new RegExp(`\\p{sc=${e}}`,"u").source}catch(e){return null}})).filter((e=>e));return new RegExp(t.join("|"),"u")}Ia(["Arab","Dupl","Mong","Ougr","Syrc"]);const Ma=Ia(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Ea(e){return Ma.test(String.fromCodePoint(e))}function Ca(e,t){return!(!t&&Ea(e)||/[\u0900-\u0DFF\u0F00-\u109F\u1780-\u17FF]/gim.test(String.fromCodePoint(e)))}function Aa(e){for(const t of e)if(Ea(t.codePointAt(0)))return!0;return!1}const za=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(e){this.pluginStatus=e.pluginStatus,this.pluginURL=e.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(e){if(za.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=e.applyArabicShaping,this.processBidirectionalText=e.processBidirectionalText,this.processStyledBidirectionalText=e.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(e,t){return n(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==e.pluginStatus)return this.setState(e),e;const i=e.pluginURL,r=new Promise((e=>{this.loadScriptResolve=e}));t(i);const n=new Promise((e=>setTimeout((()=>e()),this.TIMEOUT)));if(yield Promise.race([r,n]),this.isParsed()){const e={pluginStatus:"loaded",pluginURL:i};return this.setState(e),e}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${i}`)}))}};class Da{constructor(e,t){this.isSupportedScript=Ra,this.zoom=e,t?(this.now=t.now||0,this.fadeDuration=t.fadeDuration||0,this.zoomHistory=t.zoomHistory||new Sa,this.transition=t.transition||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Sa,this.transition={})}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const e=this.zoom,t=e-Math.floor(e),i=this.crossFadingFactor();return e>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:t+(1-t)*i}:{fromScale:.5,toScale:1,t:1-(1-i)*t}}}function Ra(e){return function(e,t){for(const i of e)if(!Ca(i.codePointAt(0),t))return!1;return!0}(e,"loaded"===za.getRTLTextPluginStatus())}const ka="-transition";class La{constructor(e,t,i){this.property=e,this.value=t,this.expression=function(e,t,i){if(ts(e))return new ms(e,t);if(hs(e)){const r=fs(e,t,i);if("error"===r.result)throw new Error(r.value.map((e=>`${e.key}: ${e.message}`)).join(", "));return r.value}{let i=e;return"color"===t.type&&"string"==typeof e?i=Li.parse(e):"padding"!==t.type||"number"!=typeof e&&!Array.isArray(e)?"numberArray"!==t.type||"number"!=typeof e&&!Array.isArray(e)?"colorArray"!==t.type||"string"!=typeof e&&!Array.isArray(e)?"variableAnchorOffsetCollection"===t.type&&Array.isArray(e)?i=$i.parse(e):"projectionDefinition"===t.type&&"string"==typeof e&&(i=Wi.parse(e)):i=Ui.parse(e):i=Ni.parse(e):i=ji.parse(e),{globalStateRefs:new Set,_globalState:null,kind:"constant",evaluate:()=>i}}}(void 0===t?e.specification.default:t,e.specification,i)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(e,t,i){return this.property.possiblyEvaluate(this,e,t,i)}}class Fa{constructor(e,t){this.property=e,this.value=new La(e,void 0,t)}transitioned(e,t){return new Oa(this.property,this.value,t,we({},e.transition,this.transition),e.now)}untransitioned(){return new Oa(this.property,this.value,null,{},0)}}class Ba{constructor(e,t){this._properties=e,this._values=Object.create(e.defaultTransitionablePropertyValues),this._globalState=t}getValue(e){return ze(this._values[e].value.value)}setValue(e,t){Object.prototype.hasOwnProperty.call(this._values,e)||(this._values[e]=new Fa(this._values[e].property,this._globalState)),this._values[e].value=new La(this._values[e].property,null===t?void 0:ze(t),this._globalState)}getTransition(e){return ze(this._values[e].transition)}setTransition(e,t){Object.prototype.hasOwnProperty.call(this._values,e)||(this._values[e]=new Fa(this._values[e].property,this._globalState)),this._values[e].transition=ze(t)||void 0}serialize(){const e={};for(const t of Object.keys(this._values)){const i=this.getValue(t);void 0!==i&&(e[t]=i);const r=this.getTransition(t);void 0!==r&&(e[`${t}${ka}`]=r)}return e}transitioned(e,t){const i=new Va(this._properties);for(const r of Object.keys(this._values))i._values[r]=this._values[r].transitioned(e,t._values[r]);return i}untransitioned(){const e=new Va(this._properties);for(const t of Object.keys(this._values))e._values[t]=this._values[t].untransitioned();return e}}class Oa{constructor(e,t,i,r,n){this.property=e,this.value=t,this.begin=n+r.delay||0,this.end=this.begin+r.duration||0,e.specification.transition&&(r.delay||r.duration)&&(this.prior=i)}possiblyEvaluate(e,t,i){const r=e.now||0,n=this.value.possiblyEvaluate(e,t,i),s=this.prior;if(s){if(r>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(r<this.begin)return s.possiblyEvaluate(e,t,i);{const a=(r-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(e,t,i),n,ge(a))}}return n}}class Va{constructor(e){this._properties=e,this._values=Object.create(e.defaultTransitioningPropertyValues)}possiblyEvaluate(e,t,i){const r=new Ua(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(e,t,i);return r}hasTransition(){for(const e of Object.keys(this._values))if(this._values[e].prior)return!0;return!1}}class ja{constructor(e,t){this._properties=e,this._values=Object.create(e.defaultPropertyValues),this._globalState=t}hasValue(e){return void 0!==this._values[e].value}getValue(e){return ze(this._values[e].value)}setValue(e,t){this._values[e]=new La(this._values[e].property,null===t?void 0:ze(t),this._globalState)}serialize(){const e={};for(const t of Object.keys(this._values)){const i=this.getValue(t);void 0!==i&&(e[t]=i)}return e}possiblyEvaluate(e,t,i){const r=new Ua(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(e,t,i);return r}}class Na{constructor(e,t,i){this.property=e,this.value=t,this.parameters=i}isConstant(){return"constant"===this.value.kind}constantOr(e){return"constant"===this.value.kind?this.value.value:e}evaluate(e,t,i,r){return this.property.evaluate(this.value,this.parameters,e,t,i,r)}}class Ua{constructor(e){this._properties=e,this._values=Object.create(e.defaultPossiblyEvaluatedValues)}get(e){return this._values[e]}}class Ga{constructor(e){this.specification=e}possiblyEvaluate(e,t){if(e.isDataDriven())throw new Error("Value should not be data driven");return e.expression.evaluate(t)}interpolate(e,t,i){const r=Tr[this.specification.type];return r?r(e,t,i):e}}class Za{constructor(e,t){this.specification=e,this.overrides=t}possiblyEvaluate(e,t,i,r){return new Na(this,"constant"===e.expression.kind||"camera"===e.expression.kind?{kind:"constant",value:e.expression.evaluate(t,null,{},i,r)}:e.expression,t)}interpolate(e,t,i){if("constant"!==e.value.kind||"constant"!==t.value.kind)return e;if(void 0===e.value.value||void 0===t.value.value)return new Na(this,{kind:"constant",value:void 0},e.parameters);const r=Tr[this.specification.type];if(r){const n=r(e.value.value,t.value.value,i);return new Na(this,{kind:"constant",value:n},e.parameters)}return e}evaluate(e,t,i,r,n,s){return"constant"===e.kind?e.value:e.evaluate(t,i,r,n,s)}}class $a extends Za{possiblyEvaluate(e,t,i,r){if(void 0===e.value)return new Na(this,{kind:"constant",value:void 0},t);if("constant"===e.expression.kind){const n=e.expression.evaluate(t,null,{},i,r),s="resolvedImage"===e.property.specification.type&&"string"!=typeof n?n.name:n,a=this._calculate(s,s,s,t);return new Na(this,{kind:"constant",value:a},t)}if("camera"===e.expression.kind){const i=this._calculate(e.expression.evaluate({zoom:t.zoom-1}),e.expression.evaluate({zoom:t.zoom}),e.expression.evaluate({zoom:t.zoom+1}),t);return new Na(this,{kind:"constant",value:i},t)}return new Na(this,e.expression,t)}evaluate(e,t,i,r,n,s){if("source"===e.kind){const a=e.evaluate(t,i,r,n,s);return this._calculate(a,a,a,t)}return"composite"===e.kind?this._calculate(e.evaluate({zoom:Math.floor(t.zoom)-1},i,r),e.evaluate({zoom:Math.floor(t.zoom)},i,r),e.evaluate({zoom:Math.floor(t.zoom)+1},i,r),t):e.value}_calculate(e,t,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:e,to:t}:{from:i,to:t}}interpolate(e){return e}}class qa{constructor(e){this.specification=e}possiblyEvaluate(e,t,i,r){if(void 0!==e.value){if("constant"===e.expression.kind){const n=e.expression.evaluate(t,null,{},i,r);return this._calculate(n,n,n,t)}return this._calculate(e.expression.evaluate(new Da(Math.floor(t.zoom-1),t)),e.expression.evaluate(new Da(Math.floor(t.zoom),t)),e.expression.evaluate(new Da(Math.floor(t.zoom+1),t)),t)}}_calculate(e,t,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:e,to:t}:{from:i,to:t}}interpolate(e){return e}}class Wa{constructor(e){this.specification=e}possiblyEvaluate(e,t,i,r){return!!e.expression.evaluate(t,null,{},i,r)}interpolate(){return!1}}class Ha{constructor(e){this.properties=e,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const t in e){const i=e[t];i.specification.overridable&&this.overridableProperties.push(t);const r=this.defaultPropertyValues[t]=new La(i,void 0,void 0),n=this.defaultTransitionablePropertyValues[t]=new Fa(i,void 0);this.defaultTransitioningPropertyValues[t]=n.untransitioned(),this.defaultPossiblyEvaluatedValues[t]=r.possiblyEvaluate({})}}}ya("DataDrivenProperty",Za),ya("DataConstantProperty",Ga),ya("CrossFadedDataDrivenProperty",$a),ya("CrossFadedProperty",qa),ya("ColorRampProperty",Wa);class Xa extends Pt{constructor(e,t,i){if(super(),this.id=e.id,this.type=e.type,this._globalState=i,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},this._visibilityExpression=function(e,t){return new la(e,t)}(this.visibility,i),"custom"!==e.type&&(this.metadata=e.metadata,this.minzoom=e.minzoom,this.maxzoom=e.maxzoom,"background"!==e.type&&(this.source=e.source,this.sourceLayer=e["source-layer"],this.filter=e.filter,this._featureFilter=bs(e.filter,i)),t.layout&&(this._unevaluatedLayout=new ja(t.layout,i)),t.paint)){this._transitionablePaint=new Ba(t.paint,i);for(const t in e.paint)this.setPaintProperty(t,e.paint[t],{validate:!1});for(const t in e.layout)this.setLayoutProperty(t,e.layout[t],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Ua(t.paint)}}setFilter(e){this.filter=e,this._featureFilter=bs(e,this._globalState)}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(e){return"visibility"===e?this.visibility:this._unevaluatedLayout.getValue(e)}getLayoutAffectingGlobalStateRefs(){const e=new Set;for(const t of this._visibilityExpression.getGlobalStateRefs())e.add(t);if(this._unevaluatedLayout)for(const t in this._unevaluatedLayout._values){const i=this._unevaluatedLayout._values[t];for(const t of i.getGlobalStateRefs())e.add(t)}for(const t of this._featureFilter.getGlobalStateRefs())e.add(t);return e}getPaintAffectingGlobalStateRefs(){var e;const t=new globalThis.Map;if(this._transitionablePaint)for(const i in this._transitionablePaint._values){const r=this._transitionablePaint._values[i].value;for(const n of r.getGlobalStateRefs()){const s=null!==(e=t.get(n))&&void 0!==e?e:[];s.push({name:i,value:r.value}),t.set(n,s)}}return t}getVisibilityAffectingGlobalStateRefs(){return this._visibilityExpression.getGlobalStateRefs()}setLayoutProperty(e,t,i={}){if(null==t||!this._validate(fa,`layers.${this.id}.layout.${e}`,e,t,i))return"visibility"===e?(this.visibility=t,this._visibilityExpression.setValue(t),void this.recalculateVisibility()):void this._unevaluatedLayout.setValue(e,t)}getPaintProperty(e){return e.endsWith(ka)?this._transitionablePaint.getTransition(e.slice(0,-11)):this._transitionablePaint.getValue(e)}setPaintProperty(e,t,i={}){if(null!=t&&this._validate(pa,`layers.${this.id}.paint.${e}`,e,t,i))return!1;if(e.endsWith(ka))return this._transitionablePaint.setTransition(e.slice(0,-11),t||void 0),!1;{const i=this._transitionablePaint._values[e],r="cross-faded-data-driven"===i.property.specification["property-type"],n=i.value.isDataDriven(),s=i.value;this._transitionablePaint.setValue(e,t),this._handleSpecialPaintPropertyUpdate(e);const a=this._transitionablePaint._values[e].value;return a.isDataDriven()||n||r||this._handleOverridablePaintPropertyUpdate(e,s,a)}}_handleSpecialPaintPropertyUpdate(e){}_handleOverridablePaintPropertyUpdate(e,t,i){return!1}isHidden(e=this.minzoom,t=!1){return!!(this.minzoom&&e<(t?Math.floor(this.minzoom):this.minzoom))||!!(this.maxzoom&&e>=this.maxzoom)||"none"===this._evaluatedVisibility}updateTransitions(e){this._transitioningPaint=this._transitionablePaint.transitioned(e,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculateVisibility(){this._evaluatedVisibility=this._visibilityExpression.evaluate()}recalculate(e,t){e.getCrossfadeParameters&&(this._crossfadeParameters=e.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(e,void 0,t)),this.paint=this._transitioningPaint.possiblyEvaluate(e,void 0,t)}serialize(){const e={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(e.layout=e.layout||{},e.layout.visibility=this.visibility),Ce(e,((e,t)=>!(void 0===e||"layout"===t&&!Object.keys(e).length||"paint"===t&&!Object.keys(e).length)))}_validate(e,t,i,r,n={}){return(!n||!1!==n.validate)&&ma(this,e.call(ha,{key:t,layerType:this.type,objectKey:i,value:r,styleSpec:It,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const e in this.paint._values){const t=this.paint.get(e);if(t instanceof Na&&Kn(t.property.specification)&&("source"===t.value.kind||"composite"===t.value.kind)&&t.value.isStateDependent)return!0}return!1}}let Ya;var Ka={get paint(){return Ya=Ya||new Ha({"raster-opacity":new Ga(It.paint_raster["raster-opacity"]),"raster-hue-rotate":new Ga(It.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Ga(It.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Ga(It.paint_raster["raster-brightness-max"]),"raster-saturation":new Ga(It.paint_raster["raster-saturation"]),"raster-contrast":new Ga(It.paint_raster["raster-contrast"]),"raster-resampling":new Ga(It.paint_raster["raster-resampling"]),"raster-fade-duration":new Ga(It.paint_raster["raster-fade-duration"])})}};const Ja=e=>"raster"===e.type;class Qa extends Xa{constructor(e,t){super(e,Ka,t)}}const eo={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class to{constructor(e,t){this._structArray=e,this._pos1=t*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class io{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(e,t){return e._trim(),t&&(e.isTransferred=!0,t.push(e.arrayBuffer)),{length:e.length,arrayBuffer:e.arrayBuffer}}static deserialize(e){const t=Object.create(this.prototype);return t.arrayBuffer=e.arrayBuffer,t.length=e.length,t.capacity=e.arrayBuffer.byteLength/t.bytesPerElement,t._refreshViews(),t}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(e){this.reserve(e),this.length=e}reserve(e){if(e>this.capacity){this.capacity=Math.max(e,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const t=this.uint8;this._refreshViews(),t&&this.uint8.set(t)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function ro(e,t=1){let i=0,r=0;return{members:e.map((e=>{const n=eo[e.type].BYTES_PER_ELEMENT,s=i=no(i,Math.max(t,n)),a=e.components||1;return r=Math.max(r,n),i+=n*a,{name:e.name,type:e.type,components:a,offset:s}})),size:no(i,Math.max(r,t)),alignment:t}}function no(e,t){return Math.ceil(e/t)*t}class so extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.int16[r+0]=t,this.int16[r+1]=i,e}}so.prototype.bytesPerElement=4,ya("StructArrayLayout2i4",so);class ao extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.int16[n+0]=t,this.int16[n+1]=i,this.int16[n+2]=r,e}}ao.prototype.bytesPerElement=6,ya("StructArrayLayout3i6",ao);class oo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const s=4*e;return this.int16[s+0]=t,this.int16[s+1]=i,this.int16[s+2]=r,this.int16[s+3]=n,e}}oo.prototype.bytesPerElement=8,ya("StructArrayLayout4i8",oo);class lo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s){const a=this.length;return this.resize(a+1),this.emplace(a,e,t,i,r,n,s)}emplace(e,t,i,r,n,s,a){const o=6*e;return this.int16[o+0]=t,this.int16[o+1]=i,this.int16[o+2]=r,this.int16[o+3]=n,this.int16[o+4]=s,this.int16[o+5]=a,e}}lo.prototype.bytesPerElement=12,ya("StructArrayLayout2i4i12",lo);class co extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s){const a=this.length;return this.resize(a+1),this.emplace(a,e,t,i,r,n,s)}emplace(e,t,i,r,n,s,a){const o=4*e,l=8*e;return this.int16[o+0]=t,this.int16[o+1]=i,this.uint8[l+4]=r,this.uint8[l+5]=n,this.uint8[l+6]=s,this.uint8[l+7]=a,e}}co.prototype.bytesPerElement=8,ya("StructArrayLayout2i4ub8",co);class ho extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.float32[r+0]=t,this.float32[r+1]=i,e}}ho.prototype.bytesPerElement=8,ya("StructArrayLayout2f8",ho);class uo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s,a,o,l,c){const h=this.length;return this.resize(h+1),this.emplace(h,e,t,i,r,n,s,a,o,l,c)}emplace(e,t,i,r,n,s,a,o,l,c,h){const u=10*e;return this.uint16[u+0]=t,this.uint16[u+1]=i,this.uint16[u+2]=r,this.uint16[u+3]=n,this.uint16[u+4]=s,this.uint16[u+5]=a,this.uint16[u+6]=o,this.uint16[u+7]=l,this.uint16[u+8]=c,this.uint16[u+9]=h,e}}uo.prototype.bytesPerElement=20,ya("StructArrayLayout10ui20",uo);class po extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s,a,o){const l=this.length;return this.resize(l+1),this.emplace(l,e,t,i,r,n,s,a,o)}emplace(e,t,i,r,n,s,a,o,l){const c=8*e;return this.uint16[c+0]=t,this.uint16[c+1]=i,this.uint16[c+2]=r,this.uint16[c+3]=n,this.uint16[c+4]=s,this.uint16[c+5]=a,this.uint16[c+6]=o,this.uint16[c+7]=l,e}}po.prototype.bytesPerElement=16,ya("StructArrayLayout8ui16",po);class fo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s,a,o,l,c,h,u){const d=this.length;return this.resize(d+1),this.emplace(d,e,t,i,r,n,s,a,o,l,c,h,u)}emplace(e,t,i,r,n,s,a,o,l,c,h,u,d){const p=12*e;return this.int16[p+0]=t,this.int16[p+1]=i,this.int16[p+2]=r,this.int16[p+3]=n,this.uint16[p+4]=s,this.uint16[p+5]=a,this.uint16[p+6]=o,this.uint16[p+7]=l,this.int16[p+8]=c,this.int16[p+9]=h,this.int16[p+10]=u,this.int16[p+11]=d,e}}fo.prototype.bytesPerElement=24,ya("StructArrayLayout4i4ui4i24",fo);class mo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.float32[n+0]=t,this.float32[n+1]=i,this.float32[n+2]=r,e}}mo.prototype.bytesPerElement=12,ya("StructArrayLayout3f12",mo);class _o extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint32[1*e+0]=t,e}}_o.prototype.bytesPerElement=4,ya("StructArrayLayout1ul4",_o);class go extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s,a,o,l){const c=this.length;return this.resize(c+1),this.emplace(c,e,t,i,r,n,s,a,o,l)}emplace(e,t,i,r,n,s,a,o,l,c){const h=10*e,u=5*e;return this.int16[h+0]=t,this.int16[h+1]=i,this.int16[h+2]=r,this.int16[h+3]=n,this.int16[h+4]=s,this.int16[h+5]=a,this.uint32[u+3]=o,this.uint16[h+8]=l,this.uint16[h+9]=c,e}}go.prototype.bytesPerElement=20,ya("StructArrayLayout6i1ul2ui20",go);class yo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s){const a=this.length;return this.resize(a+1),this.emplace(a,e,t,i,r,n,s)}emplace(e,t,i,r,n,s,a){const o=6*e;return this.int16[o+0]=t,this.int16[o+1]=i,this.int16[o+2]=r,this.int16[o+3]=n,this.int16[o+4]=s,this.int16[o+5]=a,e}}yo.prototype.bytesPerElement=12,ya("StructArrayLayout2i2i2i12",yo);class xo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,i,r,n)}emplace(e,t,i,r,n,s){const a=4*e,o=8*e;return this.float32[a+0]=t,this.float32[a+1]=i,this.float32[a+2]=r,this.int16[o+6]=n,this.int16[o+7]=s,e}}xo.prototype.bytesPerElement=16,ya("StructArrayLayout2f1f2i16",xo);class vo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s){const a=this.length;return this.resize(a+1),this.emplace(a,e,t,i,r,n,s)}emplace(e,t,i,r,n,s,a){const o=16*e,l=4*e,c=8*e;return this.uint8[o+0]=t,this.uint8[o+1]=i,this.float32[l+1]=r,this.float32[l+2]=n,this.int16[c+6]=s,this.int16[c+7]=a,e}}vo.prototype.bytesPerElement=16,ya("StructArrayLayout2ub2f2i16",vo);class bo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.uint16[n+0]=t,this.uint16[n+1]=i,this.uint16[n+2]=r,e}}bo.prototype.bytesPerElement=6,ya("StructArrayLayout3ui6",bo);class wo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s,a,o,l,c,h,u,d,p,f,m,_){const g=this.length;return this.resize(g+1),this.emplace(g,e,t,i,r,n,s,a,o,l,c,h,u,d,p,f,m,_)}emplace(e,t,i,r,n,s,a,o,l,c,h,u,d,p,f,m,_,g){const y=24*e,x=12*e,v=48*e;return this.int16[y+0]=t,this.int16[y+1]=i,this.uint16[y+2]=r,this.uint16[y+3]=n,this.uint32[x+2]=s,this.uint32[x+3]=a,this.uint32[x+4]=o,this.uint16[y+10]=l,this.uint16[y+11]=c,this.uint16[y+12]=h,this.float32[x+7]=u,this.float32[x+8]=d,this.uint8[v+36]=p,this.uint8[v+37]=f,this.uint8[v+38]=m,this.uint32[x+10]=_,this.int16[y+22]=g,e}}wo.prototype.bytesPerElement=48,ya("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",wo);class To extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,s,a,o,l,c,h,u,d,p,f,m,_,g,y,x,v,b,w,T,S,P,I,M){const E=this.length;return this.resize(E+1),this.emplace(E,e,t,i,r,n,s,a,o,l,c,h,u,d,p,f,m,_,g,y,x,v,b,w,T,S,P,I,M)}emplace(e,t,i,r,n,s,a,o,l,c,h,u,d,p,f,m,_,g,y,x,v,b,w,T,S,P,I,M,E){const C=32*e,A=16*e;return this.int16[C+0]=t,this.int16[C+1]=i,this.int16[C+2]=r,this.int16[C+3]=n,this.int16[C+4]=s,this.int16[C+5]=a,this.int16[C+6]=o,this.int16[C+7]=l,this.uint16[C+8]=c,this.uint16[C+9]=h,this.uint16[C+10]=u,this.uint16[C+11]=d,this.uint16[C+12]=p,this.uint16[C+13]=f,this.uint16[C+14]=m,this.uint16[C+15]=_,this.uint16[C+16]=g,this.uint16[C+17]=y,this.uint16[C+18]=x,this.uint16[C+19]=v,this.uint16[C+20]=b,this.uint16[C+21]=w,this.uint16[C+22]=T,this.uint32[A+12]=S,this.float32[A+13]=P,this.float32[A+14]=I,this.uint16[C+30]=M,this.uint16[C+31]=E,e}}To.prototype.bytesPerElement=64,ya("StructArrayLayout8i15ui1ul2f2ui64",To);class So extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.float32[1*e+0]=t,e}}So.prototype.bytesPerElement=4,ya("StructArrayLayout1f4",So);class Po extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.uint16[6*e+0]=t,this.float32[n+1]=i,this.float32[n+2]=r,e}}Po.prototype.bytesPerElement=12,ya("StructArrayLayout1ui2f12",Po);class Io extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=4*e;return this.uint32[2*e+0]=t,this.uint16[n+2]=i,this.uint16[n+3]=r,e}}Io.prototype.bytesPerElement=8,ya("StructArrayLayout1ul2ui8",Io);class Mo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.uint16[r+0]=t,this.uint16[r+1]=i,e}}Mo.prototype.bytesPerElement=4,ya("StructArrayLayout2ui4",Mo);class Eo extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint16[1*e+0]=t,e}}Eo.prototype.bytesPerElement=2,ya("StructArrayLayout1ui2",Eo);class Co extends io{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const s=4*e;return this.float32[s+0]=t,this.float32[s+1]=i,this.float32[s+2]=r,this.float32[s+3]=n,e}}Co.prototype.bytesPerElement=16,ya("StructArrayLayout4f16",Co);class Ao extends to{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new s(this.anchorPointX,this.anchorPointY)}}Ao.prototype.size=20;class zo extends go{get(e){return new Ao(this,e)}}ya("CollisionBoxArray",zo);class Do extends to{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(e){this._structArray.uint8[this._pos1+37]=e}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(e){this._structArray.uint8[this._pos1+38]=e}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(e){this._structArray.uint32[this._pos4+10]=e}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Do.prototype.size=48;class Ro extends wo{get(e){return new Do(this,e)}}ya("PlacedSymbolArray",Ro);class ko extends to{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(e){this._structArray.uint32[this._pos4+12]=e}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}ko.prototype.size=64;class Lo extends To{get(e){return new ko(this,e)}}ya("SymbolInstanceArray",Lo);class Fo extends So{getoffsetX(e){return this.float32[1*e+0]}}ya("GlyphOffsetArray",Fo);class Bo extends ao{getx(e){return this.int16[3*e+0]}gety(e){return this.int16[3*e+1]}gettileUnitDistanceFromAnchor(e){return this.int16[3*e+2]}}ya("SymbolLineVertexArray",Bo);class Oo extends to{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Oo.prototype.size=12;class Vo extends Po{get(e){return new Oo(this,e)}}ya("TextAnchorOffsetArray",Vo);class jo extends to{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}jo.prototype.size=8;class No extends Io{get(e){return new jo(this,e)}}ya("FeatureIndexArray",No);class Uo extends so{}class Go extends ao{}class Zo extends oo{}class $o extends so{}class qo extends so{}class Wo extends lo{}class Ho extends co{}class Xo extends ho{}class Yo extends uo{}class Ko extends po{}class Jo extends fo{}class Qo extends mo{}class el extends _o{}class tl extends yo{}class il extends xo{}class rl extends vo{}class nl extends bo{}class sl extends bo{}class al extends Mo{}class ol extends Eo{}const ll=ro([{name:"a_pos",components:2,type:"Int16"}],4),{members:cl}=ll;class hl{constructor(e=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=e}prepareSegment(e,t,i,r){const n=this.segments[this.segments.length-1];return e>hl.MAX_VERTEX_ARRAY_LENGTH&&Re(`Max vertices per segment is ${hl.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${e}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${hl.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!n||n.vertexLength+e>hl.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==r?this.createNewSegment(t,i,r):n}createNewSegment(e,t,i){const r={vertexOffset:e.length,primitiveOffset:t.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==i&&(r.sortKey=i),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(r),r}getOrCreateLatestSegment(e,t,i){return this.prepareSegment(0,e,t,i)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const e of this.segments)for(const t in e.vaos)e.vaos[t].destroy()}static simpleSegment(e,t,i,r){return new hl([{vertexOffset:e,primitiveOffset:t,vertexLength:i,primitiveLength:r,vaos:{},sortKey:0}])}}function ul(e,t){return 256*(e=ve(Math.floor(e),0,255))+ve(Math.floor(t),0,255)}hl.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,ya("SegmentVector",hl);const dl=ro([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]),pl=ro([{name:"a_dasharray_from",components:4,type:"Uint16"},{name:"a_dasharray_to",components:4,type:"Uint16"}]);var fl,ml,_l,gl={exports:{}},yl={exports:{}},xl={exports:{}},vl=function(){if(_l)return gl.exports;_l=1;var e=(fl||(fl=1,function(e){e.exports=function(e,t){var i,r,n,s,a,o,l,c;for(r=e.length-(i=3&e.length),n=t,a=3432918353,o=461845907,c=0;c<r;)l=255&e.charCodeAt(c)|(255&e.charCodeAt(++c))<<8|(255&e.charCodeAt(++c))<<16|(255&e.charCodeAt(++c))<<24,++c,n=27492+(65535&(s=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,i){case 3:l^=(255&e.charCodeAt(c+2))<<16;case 2:l^=(255&e.charCodeAt(c+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&e.charCodeAt(c)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295}return n^=e.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0}}(yl)),yl.exports),t=(ml||(ml=1,function(e){e.exports=function(e,t){for(var i,r=e.length,n=t^r,s=0;r>=4;)i=1540483477*(65535&(i=255&e.charCodeAt(s)|(255&e.charCodeAt(++s))<<8|(255&e.charCodeAt(++s))<<16|(255&e.charCodeAt(++s))<<24))+((1540483477*(i>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(i=1540483477*(65535&(i^=i>>>24))+((1540483477*(i>>>16)&65535)<<16)),r-=4,++s;switch(r){case 3:n^=(255&e.charCodeAt(s+2))<<16;case 2:n^=(255&e.charCodeAt(s+1))<<8;case 1:n=1540483477*(65535&(n^=255&e.charCodeAt(s)))+((1540483477*(n>>>16)&65535)<<16)}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0}}(xl)),xl.exports);return gl.exports=e,gl.exports.murmur3=e,gl.exports.murmur2=t,gl.exports}(),bl=a(vl);class wl{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(e,t,i,r){this.ids.push(Tl(e)),this.positions.push(t,i,r)}getPositions(e){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const t=Tl(e);let i=0,r=this.ids.length-1;for(;i<r;){const e=i+r>>1;this.ids[e]>=t?r=e:i=e+1}const n=[];for(;this.ids[i]===t;)n.push({index:this.positions[3*i],start:this.positions[3*i+1],end:this.positions[3*i+2]}),i++;return n}static serialize(e,t){const i=new Float64Array(e.ids),r=new Uint32Array(e.positions);return Sl(i,r,0,i.length-1),t&&t.push(i.buffer,r.buffer),{ids:i,positions:r}}static deserialize(e){const t=new wl;return t.ids=e.ids,t.positions=e.positions,t.indexed=!0,t}}function Tl(e){const t=+e;return!isNaN(t)&&t<=Number.MAX_SAFE_INTEGER?t:bl(String(e))}function Sl(e,t,i,r){for(;i<r;){const n=e[i+r>>1];let s=i-1,a=r+1;for(;;){do{s++}while(e[s]<n);do{a--}while(e[a]>n);if(s>=a)break;Pl(e,s,a),Pl(t,3*s,3*a),Pl(t,3*s+1,3*a+1),Pl(t,3*s+2,3*a+2)}a-i<r-a?(Sl(e,t,i,a),i=a+1):(Sl(e,t,a+1,r),r=a)}}function Pl(e,t,i){const r=e[t];e[t]=e[i],e[i]=r}ya("FeaturePositionMap",wl);class Il{constructor(e,t){this.gl=e.gl,this.location=t}}class Ml extends Il{constructor(e,t){super(e,t),this.current=0}set(e){this.current!==e&&(this.current=e,this.gl.uniform1i(this.location,e))}}class El extends Il{constructor(e,t){super(e,t),this.current=0}set(e){this.current!==e&&(this.current=e,this.gl.uniform1f(this.location,e))}}class Cl extends Il{constructor(e,t){super(e,t),this.current=[0,0]}set(e){e[0]===this.current[0]&&e[1]===this.current[1]||(this.current=e,this.gl.uniform2f(this.location,e[0],e[1]))}}class Al extends Il{constructor(e,t){super(e,t),this.current=[0,0,0]}set(e){e[0]===this.current[0]&&e[1]===this.current[1]&&e[2]===this.current[2]||(this.current=e,this.gl.uniform3f(this.location,e[0],e[1],e[2]))}}class zl extends Il{constructor(e,t){super(e,t),this.current=[0,0,0,0]}set(e){e[0]===this.current[0]&&e[1]===this.current[1]&&e[2]===this.current[2]&&e[3]===this.current[3]||(this.current=e,this.gl.uniform4f(this.location,e[0],e[1],e[2],e[3]))}}class Dl extends Il{constructor(e,t){super(e,t),this.current=Li.transparent}set(e){e.r===this.current.r&&e.g===this.current.g&&e.b===this.current.b&&e.a===this.current.a||(this.current=e,this.gl.uniform4f(this.location,e.r,e.g,e.b,e.a))}}class Rl extends Il{constructor(e,t){super(e,t),this.current=new Array}set(e){if(e!=this.current){this.current=e;const t=new Float32Array(4*e.length);for(let i=0;i<e.length;i++)t[4*i]=e[i].r,t[4*i+1]=e[i].g,t[4*i+2]=e[i].b,t[4*i+3]=e[i].a;this.gl.uniform4fv(this.location,t)}}}class kl extends Il{constructor(e,t){super(e,t),this.current=new Array}set(e){if(e!=this.current){this.current=e;const t=new Float32Array(e);this.gl.uniform1fv(this.location,t)}}}const Ll=new Float32Array(16);class Fl extends Il{constructor(e,t){super(e,t),this.current=Ll}set(e){if(e[12]!==this.current[12]||e[0]!==this.current[0])return this.current=e,void this.gl.uniformMatrix4fv(this.location,!1,e);for(let t=1;t<16;t++)if(e[t]!==this.current[t]){this.current=e,this.gl.uniformMatrix4fv(this.location,!1,e);break}}}function Bl(e){return[ul(255*e.r,255*e.g),ul(255*e.b,255*e.a)]}class Ol{constructor(e,t,i){this.value=e,this.uniformNames=t.map((e=>`u_${e}`)),this.type=i}setUniform(e,t,i){e.set(i.constantOr(this.value))}getBinding(e,t,i){return"color"===this.type?new Dl(e,t):new El(e,t)}}class Vl{constructor(e,t){this.uniformNames=t.map((e=>`u_${e}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(e,t){this.pixelRatioFrom=t.pixelRatio,this.pixelRatioTo=e.pixelRatio,this.patternFrom=t.tlbr,this.patternTo=e.tlbr}setConstantDashPositions(e,t){this.dashTo=[0,e.y,e.height,e.width],this.dashFrom=[0,t.y,t.height,t.width]}setUniform(e,t,i,r){let n=null;"u_pattern_to"===r?n=this.patternTo:"u_pattern_from"===r?n=this.patternFrom:"u_dasharray_to"===r?n=this.dashTo:"u_dasharray_from"===r?n=this.dashFrom:"u_pixel_ratio_to"===r?n=this.pixelRatioTo:"u_pixel_ratio_from"===r&&(n=this.pixelRatioFrom),null!==n&&e.set(n)}getBinding(e,t,i){return"u_pattern"===i.substr(0,9)||"u_dasharray_"===i.substr(0,12)?new zl(e,t):new El(e,t)}}class jl{constructor(e,t,i,r){this.expression=e,this.type=i,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===i?2:1,offset:0}))),this.paintVertexArray=new r}populatePaintArray(e,t,i){const r=this.paintVertexArray.length,n=this.expression.evaluate(new Da(0,i),t,{},i.canonical,[],i.formattedSection);this.paintVertexArray.resize(e),this._setPaintValue(r,e,n)}updatePaintArray(e,t,i,r,n){const s=this.expression.evaluate(new Da(0,n),i,r);this._setPaintValue(e,t,s)}_setPaintValue(e,t,i){if("color"===this.type){const r=Bl(i);for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,r[0],r[1])}else{for(let r=e;r<t;r++)this.paintVertexArray.emplace(r,i);this.maxValue=Math.max(this.maxValue,Math.abs(i))}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class Nl{constructor(e,t,i,r,n,s){this.expression=e,this.uniformNames=t.map((e=>`u_${e}_t`)),this.type=i,this.useIntegerZoom=r,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===i?4:2,offset:0}))),this.paintVertexArray=new s}populatePaintArray(e,t,i){const r=this.expression.evaluate(new Da(this.zoom,i),t,{},i.canonical,[],i.formattedSection),n=this.expression.evaluate(new Da(this.zoom+1,i),t,{},i.canonical,[],i.formattedSection),s=this.paintVertexArray.length;this.paintVertexArray.resize(e),this._setPaintValue(s,e,r,n)}updatePaintArray(e,t,i,r,n){const s=this.expression.evaluate(new Da(this.zoom,n),i,r),a=this.expression.evaluate(new Da(this.zoom+1,n),i,r);this._setPaintValue(e,t,s,a)}_setPaintValue(e,t,i,r){if("color"===this.type){const n=Bl(i),s=Bl(r);for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,n[0],n[1],s[0],s[1])}else{for(let n=e;n<t;n++)this.paintVertexArray.emplace(n,i,r);this.maxValue=Math.max(this.maxValue,Math.abs(i),Math.abs(r))}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(e,t){const i=this.useIntegerZoom?Math.floor(t.zoom):t.zoom,r=ve(this.expression.interpolationFactor(i,this.zoom,this.zoom+1),0,1);e.set(r)}getBinding(e,t,i){return new El(e,t)}}class Ul{constructor(e,t,i,r,n,s){this.expression=e,this.type=t,this.useIntegerZoom=i,this.zoom=r,this.layerId=s,this.zoomInPaintVertexArray=new n,this.zoomOutPaintVertexArray=new n}populatePaintArray(e,t,i){const r=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(e),this.zoomOutPaintVertexArray.resize(e),this._setPaintValues(r,e,this.getPositionIds(t),i)}updatePaintArray(e,t,i,r,n){this._setPaintValues(e,t,this.getPositionIds(i),n)}_setPaintValues(e,t,i,r){const n=this.getPositions(r);if(!n||!i)return;const s=n[i.min],a=n[i.mid],o=n[i.max];if(s&&a&&o)for(let i=e;i<t;i++)this.emplace(this.zoomInPaintVertexArray,i,a,s),this.emplace(this.zoomOutPaintVertexArray,i,a,o)}upload(e){if(this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer){const t=this.getVertexAttributes();this.zoomInPaintVertexBuffer=e.createVertexBuffer(this.zoomInPaintVertexArray,t,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=e.createVertexBuffer(this.zoomOutPaintVertexArray,t,this.expression.isStateDependent)}}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class Gl extends Ul{getPositions(e){return e.imagePositions}getPositionIds(e){return e.patterns&&e.patterns[this.layerId]}getVertexAttributes(){return dl.members}emplace(e,t,i,r){e.emplace(t,i.tlbr[0],i.tlbr[1],i.tlbr[2],i.tlbr[3],r.tlbr[0],r.tlbr[1],r.tlbr[2],r.tlbr[3],i.pixelRatio,r.pixelRatio)}}class Zl extends Ul{getPositions(e){return e.dashPositions}getPositionIds(e){return e.dashes&&e.dashes[this.layerId]}getVertexAttributes(){return pl.members}emplace(e,t,i,r){e.emplace(t,0,i.y,i.height,i.width,0,r.y,r.height,r.width)}}class $l{constructor(e,t,i){this.binders={},this._buffers=[];const r=[];for(const n in e.paint._values){if(!i(n))continue;const s=e.paint.get(n);if(!(s instanceof Na&&Kn(s.property.specification)))continue;const a=Wl(n,e.type),o=s.value,l=s.property.specification.type,c=s.property.useIntegerZoom,h=s.property.specification["property-type"],u="cross-faded"===h||"cross-faded-data-driven"===h;if("constant"===o.kind)this.binders[n]=u?new Vl(o.value,a):new Ol(o.value,a,l),r.push(`/u_${n}`);else if("source"===o.kind||u){const i=Hl(n,l,"source");this.binders[n]=u?"line-dasharray"===n?new Zl(o,l,c,t,i,e.id):new Gl(o,l,c,t,i,e.id):new jl(o,a,l,i),r.push(`/a_${n}`)}else{const e=Hl(n,l,"composite");this.binders[n]=new Nl(o,a,l,c,t,e),r.push(`/z_${n}`)}}this.cacheKey=r.sort().join("")}getMaxValue(e){const t=this.binders[e];return t instanceof jl||t instanceof Nl?t.maxValue:0}populatePaintArrays(e,t,i){for(const r in this.binders){const n=this.binders[r];(n instanceof jl||n instanceof Nl||n instanceof Ul)&&n.populatePaintArray(e,t,i)}}setConstantPatternPositions(e,t){for(const i in this.binders){const r=this.binders[i];r instanceof Vl&&r.setConstantPatternPositions(e,t)}}setConstantDashPositions(e,t){for(const i in this.binders){const r=this.binders[i];r instanceof Vl&&r.setConstantDashPositions(e,t)}}updatePaintArrays(e,t,i,r,n){let s=!1;for(const a in e){const o=t.getPositions(a);for(const t of o){const o=i.feature(t.index);for(const i in this.binders){const l=this.binders[i];if((l instanceof jl||l instanceof Nl||l instanceof Ul)&&!0===l.expression.isStateDependent){const c=r.paint.get(i);l.expression=c.value,l.updatePaintArray(t.start,t.end,o,e[a],n),s=!0}}}}return s}defines(){const e=[];for(const t in this.binders){const i=this.binders[t];(i instanceof Ol||i instanceof Vl)&&e.push(...i.uniformNames.map((e=>`#define HAS_UNIFORM_${e}`)))}return e}getBinderAttributes(){const e=[];for(const t in this.binders){const i=this.binders[t];if(i instanceof jl||i instanceof Nl)for(let t=0;t<i.paintVertexAttributes.length;t++)e.push(i.paintVertexAttributes[t].name);else if(i instanceof Ul){const t=i.getVertexAttributes();for(const i of t)e.push(i.name)}}return e}getBinderUniforms(){const e=[];for(const t in this.binders){const i=this.binders[t];if(i instanceof Ol||i instanceof Vl||i instanceof Nl)for(const t of i.uniformNames)e.push(t)}return e}getPaintVertexBuffers(){return this._buffers}getUniforms(e,t){const i=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof Ol||n instanceof Vl||n instanceof Nl)for(const s of n.uniformNames)if(t[s]){const a=n.getBinding(e,t[s],s);i.push({name:s,property:r,binding:a})}}return i}setUniforms(e,t,i,r){for(const{name:e,property:n,binding:s}of t)this.binders[n].setUniform(s,r,i.get(n),e)}updatePaintBuffers(e){this._buffers=[];for(const t in this.binders){const i=this.binders[t];if(e&&i instanceof Ul){const t=2===e.fromScale?i.zoomInPaintVertexBuffer:i.zoomOutPaintVertexBuffer;t&&this._buffers.push(t)}else(i instanceof jl||i instanceof Nl)&&i.paintVertexBuffer&&this._buffers.push(i.paintVertexBuffer)}}upload(e){for(const t in this.binders){const i=this.binders[t];(i instanceof jl||i instanceof Nl||i instanceof Ul)&&i.upload(e)}this.updatePaintBuffers()}destroy(){for(const e in this.binders){const t=this.binders[e];(t instanceof jl||t instanceof Nl||t instanceof Ul)&&t.destroy()}}}class ql{constructor(e,t,i=()=>!0){this.programConfigurations={};for(const r of e)this.programConfigurations[r.id]=new $l(r,t,i);this.needsUpload=!1,this._featureMap=new wl,this._bufferOffset=0}populatePaintArrays(e,t,i,r){for(const i in this.programConfigurations)this.programConfigurations[i].populatePaintArrays(e,t,r);void 0!==t.id&&this._featureMap.add(t.id,i,this._bufferOffset,e),this._bufferOffset=e,this.needsUpload=!0}updatePaintArrays(e,t,i,r){for(const n of i)this.needsUpload=this.programConfigurations[n.id].updatePaintArrays(e,this._featureMap,t,n,r)||this.needsUpload}get(e){return this.programConfigurations[e]}upload(e){if(this.needsUpload){for(const t in this.programConfigurations)this.programConfigurations[t].upload(e);this.needsUpload=!1}}destroy(){for(const e in this.programConfigurations)this.programConfigurations[e].destroy()}}function Wl(e,t){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-dasharray":["dasharray_to","dasharray_from"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[e]||[e.replace(`${t}-`,"").replace(/-/g,"_")]}function Hl(e,t,i){const r={color:{source:ho,composite:Co},number:{source:So,composite:ho}},n=function(e){return{"line-pattern":{source:Yo,composite:Yo},"fill-pattern":{source:Yo,composite:Yo},"fill-extrusion-pattern":{source:Yo,composite:Yo},"line-dasharray":{source:Ko,composite:Ko}}[e]}(e);return n&&n[i]||r[t][i]}ya("ConstantBinder",Ol),ya("CrossFadedConstantBinder",Vl),ya("SourceExpressionBinder",jl),ya("CrossFadedPatternBinder",Gl),ya("CrossFadedDasharrayBinder",Zl),ya("CompositeExpressionBinder",Nl),ya("ProgramConfiguration",$l,{omit:["_buffers"]}),ya("ProgramConfigurationSet",ql);const Xl=Math.pow(2,14)-1,Yl=-Xl-1;function Kl(e){const t=Q/e.extent,i=e.loadGeometry();for(let e=0;e<i.length;e++){const r=i[e];for(let e=0;e<r.length;e++){const i=r[e],n=Math.round(i.x*t),s=Math.round(i.y*t);i.x=ve(n,Yl,Xl),i.y=ve(s,Yl,Xl),(n<i.x||n>i.x+1||s<i.y||s>i.y+1)&&Re("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return i}function Jl(e,t){return{type:e.type,id:e.id,properties:e.properties,geometry:t?Kl(e):[]}}const Ql=-32768;function ec(e,t,i,r,n){e.emplaceBack(Ql+8*t+r,Ql+8*i+n)}class tc{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.layoutVertexArray=new $o,this.indexArray=new sl,this.segments=new hl,this.programConfigurations=new ql(e.layers,e.zoom),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,i){const r=this.layers[0],n=[];let s=null,a=!1,o="heatmap"===r.type;if("circle"===r.type){const e=r;s=e.layout.get("circle-sort-key"),a=!s.isConstant(),o=o||"map"===e.paint.get("circle-pitch-alignment")}const l=o?t.subdivisionGranularity.circle:1;for(const{feature:t,id:r,index:o,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,c=Jl(t,e);if(!this.layers[0]._featureFilter.filter(new Da(this.zoom),c,i))continue;const h=a?s.evaluate(c,{},i):void 0,u={id:r,properties:t.properties,type:t.type,sourceLayerIndex:l,index:o,geometry:e?c.geometry:Kl(t),patterns:{},sortKey:h};n.push(u)}a&&n.sort(((e,t)=>e.sortKey-t.sortKey));for(const r of n){const{geometry:n,index:s,sourceLayerIndex:a}=r,o=e[s].feature;this.addFeature(r,n,s,i,l),t.featureIndex.insert(o,n,s,a,this.index)}}update(e,t,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:i})}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,cl),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(e,t,i,r,n=1){let s;switch(n){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${n}; valid values are 1, 3, 5, 7.`)}const a=s.length;for(const i of t)for(const t of i){const i=t.x,r=t.y;if(i<0||i>=Q||r<0||r>=Q)continue;const n=this.segments.prepareSegment(a*a,this.layoutVertexArray,this.indexArray,e.sortKey),o=n.vertexLength;for(let e=0;e<a;e++)for(let t=0;t<a;t++)ec(this.layoutVertexArray,i,r,s[t],s[e]);for(let e=0;e<a-1;e++)for(let t=0;t<a-1;t++){const i=o+e*a+t,r=o+(e+1)*a+t;this.indexArray.emplaceBack(i,r+1,i+1),this.indexArray.emplaceBack(i,r,r+1)}n.vertexLength+=a*a,n.primitiveLength+=(a-1)*(a-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,{imagePositions:{},canonical:r})}}function ic(e,t){for(let i=0;i<e.length;i++)if(uc(t,e[i]))return!0;for(let i=0;i<t.length;i++)if(uc(e,t[i]))return!0;return!!ac(e,t)}function rc(e,t,i){return!!uc(e,t)||!!lc(t,e,i)}function nc(e,t){if(1===e.length)return hc(t,e[0]);for(let i=0;i<t.length;i++){const r=t[i];for(let t=0;t<r.length;t++)if(uc(e,r[t]))return!0}for(let i=0;i<e.length;i++)if(hc(t,e[i]))return!0;for(let i=0;i<t.length;i++)if(ac(e,t[i]))return!0;return!1}function sc(e,t,i){if(e.length>1){if(ac(e,t))return!0;for(let r=0;r<t.length;r++)if(lc(t[r],e,i))return!0}for(let r=0;r<e.length;r++)if(lc(e[r],t,i))return!0;return!1}function ac(e,t){if(0===e.length||0===t.length)return!1;for(let i=0;i<e.length-1;i++){const r=e[i],n=e[i+1];for(let e=0;e<t.length-1;e++)if(oc(r,n,t[e],t[e+1]))return!0}return!1}function oc(e,t,i,r){return ke(e,i,r)!==ke(t,i,r)&&ke(e,t,i)!==ke(e,t,r)}function lc(e,t,i){const r=i*i;if(1===t.length)return e.distSqr(t[0])<r;for(let i=1;i<t.length;i++)if(cc(e,t[i-1],t[i])<r)return!0;return!1}function cc(e,t,i){const r=t.distSqr(i);if(0===r)return e.distSqr(t);const n=((e.x-t.x)*(i.x-t.x)+(e.y-t.y)*(i.y-t.y))/r;return e.distSqr(n<0?t:n>1?i:i.sub(t)._mult(n)._add(t))}function hc(e,t){let i,r,n,s=!1;for(let a=0;a<e.length;a++){i=e[a];for(let e=0,a=i.length-1;e<i.length;a=e++)r=i[e],n=i[a],r.y>t.y!=n.y>t.y&&t.x<(n.x-r.x)*(t.y-r.y)/(n.y-r.y)+r.x&&(s=!s)}return s}function uc(e,t){let i=!1;for(let r=0,n=e.length-1;r<e.length;n=r++){const s=e[r],a=e[n];s.y>t.y!=a.y>t.y&&t.x<(a.x-s.x)*(t.y-s.y)/(a.y-s.y)+s.x&&(i=!i)}return i}function dc(e,t,i){const r=i[0],n=i[2];if(e.x<r.x&&t.x<r.x||e.x>n.x&&t.x>n.x||e.y<r.y&&t.y<r.y||e.y>n.y&&t.y>n.y)return!1;const s=ke(e,t,i[0]);return s!==ke(e,t,i[1])||s!==ke(e,t,i[2])||s!==ke(e,t,i[3])}function pc(e,t,i){const r=t.paint.get(e).value;return"constant"===r.kind?r.value:i.programConfigurations.get(t.id).getMaxValue(e)}function fc(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])}function mc(e,t,i,r,n){if(!t[0]&&!t[1])return e;const a=s.convert(t)._mult(n);"viewport"===i&&a._rotate(-r);const o=[];for(let t=0;t<e.length;t++)o.push(e[t].sub(a));return o}function _c(e){const t=[];for(let i=0;i<e.length;i++){const r=e[i],n=t.at(-1);(0===i||n&&!r.equals(n))&&t.push(r)}return t}function gc({queryGeometry:e,size:t},i){return rc(e,i,t)}function yc({queryGeometry:e,size:t,transform:i,unwrappedTileID:r,getElevation:n},s){return rc(e,s,t*(i.projectTileCoordinates(s.x,s.y,r,n).signedDistanceFromCamera/i.cameraToCenterDistance))}function xc({queryGeometry:e,size:t,transform:i,unwrappedTileID:r,getElevation:n},s){const a=i.projectTileCoordinates(s.x,s.y,r,n).signedDistanceFromCamera,o=t*(i.cameraToCenterDistance/a);return rc(e,wc(s,i,r,n),o)}function vc({queryGeometry:e,size:t,transform:i,unwrappedTileID:r,getElevation:n},s){return rc(e,wc(s,i,r,n),t)}function bc({queryGeometry:e,size:t,transform:i,unwrappedTileID:r,getElevation:n,pitchAlignment:s="map",pitchScale:a="map"},o){const l="map"===s?"map"===a?gc:yc:"map"===a?xc:vc,c={queryGeometry:e,size:t,transform:i,unwrappedTileID:r,getElevation:n};for(const e of o)for(const t of e)if(l(c,t))return!0;return!1}function wc(e,t,i,r){const n=t.projectTileCoordinates(e.x,e.y,i,r).point;return new s((.5*n.x+.5)*t.width,(.5*-n.y+.5)*t.height)}let Tc,Sc;ya("CircleBucket",tc,{omit:["layers"]});var Pc={get paint(){return Sc=Sc||new Ha({"circle-radius":new Za(It.paint_circle["circle-radius"]),"circle-color":new Za(It.paint_circle["circle-color"]),"circle-blur":new Za(It.paint_circle["circle-blur"]),"circle-opacity":new Za(It.paint_circle["circle-opacity"]),"circle-translate":new Ga(It.paint_circle["circle-translate"]),"circle-translate-anchor":new Ga(It.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Ga(It.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Ga(It.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Za(It.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Za(It.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Za(It.paint_circle["circle-stroke-opacity"])})},get layout(){return Tc=Tc||new Ha({"circle-sort-key":new Za(It.layout_circle["circle-sort-key"])})}};class Ic extends Xa{constructor(e,t){super(e,Pc,t)}createBucket(e){return new tc(e)}queryRadius(e){const t=e;return pc("circle-radius",this,t)+pc("circle-stroke-width",this,t)+fc(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,unwrappedTileID:a,getElevation:o}){const l=mc(e,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-n.bearingInRadians,s),c=this.paint.get("circle-radius").evaluate(t,i)+this.paint.get("circle-stroke-width").evaluate(t,i),h=this.paint.get("circle-pitch-scale"),u=this.paint.get("circle-pitch-alignment");let d,p;return"map"===u?(d=l,p=c*s):(d=function(e,t,i,r){return e.map((e=>wc(e,t,i,r)))}(l,n,a,o),p=c),bc({queryGeometry:d,size:p,transform:n,unwrappedTileID:a,getElevation:o,pitchAlignment:u,pitchScale:h},r)}}class Mc extends tc{}let Ec;ya("HeatmapBucket",Mc,{omit:["layers"]});var Cc={get paint(){return Ec=Ec||new Ha({"heatmap-radius":new Za(It.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Za(It.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Ga(It.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Wa(It.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Ga(It.paint_heatmap["heatmap-opacity"])})}};function Ac(e,{width:t,height:i},r,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==t*i*r)throw new RangeError(`mismatched image size. expected: ${n.length} but got: ${t*i*r}`)}else n=new Uint8Array(t*i*r);return e.width=t,e.height=i,e.data=n,e}function zc(e,{width:t,height:i},r){if(t===e.width&&i===e.height)return;const n=Ac({},{width:t,height:i},r);Dc(e,n,{x:0,y:0},{x:0,y:0},{width:Math.min(e.width,t),height:Math.min(e.height,i)},r),e.width=t,e.height=i,e.data=n.data}function Dc(e,t,i,r,n,s){if(0===n.width||0===n.height)return t;if(n.width>e.width||n.height>e.height||i.x>e.width-n.width||i.y>e.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>t.width||n.height>t.height||r.x>t.width-n.width||r.y>t.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const a=e.data,o=t.data;if(a===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<n.height;l++){const c=((i.y+l)*e.width+i.x)*s,h=((r.y+l)*t.width+r.x)*s;for(let e=0;e<n.width*s;e++)o[h+e]=a[c+e]}return t}class Rc{constructor(e,t){Ac(this,e,1,t)}resize(e){zc(this,e,1)}clone(){return new Rc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,i,r,n){Dc(e,t,i,r,n,1)}}class kc{constructor(e,t){Ac(this,e,4,t)}resize(e){zc(this,e,4)}replace(e,t){t?this.data.set(e):this.data=e instanceof Uint8ClampedArray?new Uint8Array(e.buffer):e}clone(){return new kc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,i,r,n){Dc(e,t,i,r,n,4)}setPixel(e,t,i){const r=4*(e*this.width+t);this.data[r+0]=Math.round(255*i.r/i.a),this.data[r+1]=Math.round(255*i.g/i.a),this.data[r+2]=Math.round(255*i.b/i.a),this.data[r+3]=Math.round(255*i.a)}}function Lc(e){const t={},i=e.resolution||256,r=e.clips?e.clips.length:1,n=e.image||new kc({width:i,height:r});if(Math.log(i)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${i}`);const s=(r,s,a)=>{t[e.evaluationKey]=a;const o=e.expression.evaluate(t);n.setPixel(r/4/i,s/4,o)};if(e.clips)for(let t=0,n=0;t<r;++t,n+=4*i)for(let r=0,a=0;r<i;r++,a+=4){const o=r/(i-1),{start:l,end:c}=e.clips[t];s(n,a,l*(1-o)+c*o)}else for(let e=0,t=0;e<i;e++,t+=4)s(0,t,e/(i-1));return n}ya("AlphaImage",Rc),ya("RGBAImage",kc);const Fc="big-fb";class Bc extends Xa{createBucket(e){return new Mc(e)}constructor(e,t){super(e,Cc,t),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(e){"heatmap-color"===e&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=Lc({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(Fc)&&this.heatmapFbos.delete(Fc)}queryRadius(e){return pc("heatmap-radius",this,e)}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,unwrappedTileID:a,getElevation:o}){return bc({queryGeometry:e,size:this.paint.get("heatmap-radius").evaluate(t,i)*s,transform:n,unwrappedTileID:a,getElevation:o},r)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&!this.isHidden()}}let Oc;var Vc={get paint(){return Oc=Oc||new Ha({"hillshade-illumination-direction":new Ga(It.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new Ga(It.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new Ga(It.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Ga(It.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Ga(It.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Ga(It.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Ga(It.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new Ga(It.paint_hillshade["hillshade-method"])})}};class jc extends Xa{constructor(e,t){super(e,Vc,t),this.recalculate({zoom:0,zoomHistory:{}},void 0)}getIlluminationProperties(){let e=this.paint.get("hillshade-illumination-direction").values,t=this.paint.get("hillshade-illumination-altitude").values,i=this.paint.get("hillshade-highlight-color").values,r=this.paint.get("hillshade-shadow-color").values;const n=Math.max(e.length,t.length,i.length,r.length);e=e.concat(Array(n-e.length).fill(e.at(-1))),t=t.concat(Array(n-t.length).fill(t.at(-1))),i=i.concat(Array(n-i.length).fill(i.at(-1))),r=r.concat(Array(n-r.length).fill(r.at(-1)));const s=t.map(je);return{directionRadians:e.map(je),altitudeRadians:s,shadowColor:r,highlightColor:i}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&!this.isHidden()}}let Nc;var Uc={get paint(){return Nc=Nc||new Ha({"color-relief-opacity":new Ga(It["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new Wa(It["paint_color-relief"]["color-relief-color"])})}};class Gc{constructor(e,t,i,r){this.context=e,this.format=i,this.texture=e.gl.createTexture(),this.update(t,r)}update(e,t,i){const{width:r,height:n}=e,s=!(this.size&&this.size[0]===r&&this.size[1]===n||i),{context:a}=this,{gl:o}=a;if(this.useMipmap=Boolean(t&&t.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!t||!1!==t.premultiply)),s)this.size=[r,n],e instanceof HTMLImageElement||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof ImageData||Be(e)?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,e):o.texImage2D(o.TEXTURE_2D,0,this.format,r,n,0,this.format,o.UNSIGNED_BYTE,e.data);else{const{x:t,y:s}=i||{x:0,y:0};e instanceof HTMLImageElement||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof ImageData||Be(e)?o.texSubImage2D(o.TEXTURE_2D,0,t,s,o.RGBA,o.UNSIGNED_BYTE,e):o.texSubImage2D(o.TEXTURE_2D,0,t,s,r,n,o.RGBA,o.UNSIGNED_BYTE,e.data)}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D),a.pixelStoreUnpackFlipY.setDefault(),a.pixelStoreUnpack.setDefault(),a.pixelStoreUnpackPremultiplyAlpha.setDefault()}bind(e,t,i){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),i!==n.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=n.LINEAR),e!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,i||e),this.filter=e),t!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,t),this.wrap=t)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:e}=this.context;e.deleteTexture(this.texture),this.texture=null}}function Zc(e,t){const i=t[0],r=t[1],n=t[2],s=t[3],a=Math.min(i,r,n),o=Math.round((e+s)/a);return{r:Math.floor(o*a/i)%256,g:Math.floor(o*a/r)%256,b:Math.floor(o*a/n)%256}}ya("DEMData",class{constructor(e,t,i,r=1,n=1,s=1,a=0){if(this.uid=e,t.height!==t.width)throw new RangeError("DEM tiles must be square");if(i&&!["mapbox","terrarium","custom"].includes(i))return void Re(`"${i}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=t.height;const o=this.dim=t.height-2;switch(this.data=new Uint32Array(t.data.buffer),i){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=r,this.greenFactor=n,this.blueFactor=s,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let e=0;e<o;e++)this.data[this._idx(-1,e)]=this.data[this._idx(0,e)],this.data[this._idx(o,e)]=this.data[this._idx(o-1,e)],this.data[this._idx(e,-1)]=this.data[this._idx(e,0)],this.data[this._idx(e,o)]=this.data[this._idx(e,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let e=0;e<o;e++)for(let t=0;t<o;t++){const i=this.get(e,t);i>this.max&&(this.max=i),i<this.min&&(this.min=i)}}get(e,t){const i=new Uint8Array(this.data.buffer),r=4*this._idx(e,t);return this.unpack(i[r],i[r+1],i[r+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(e,t){if(e<-1||e>=this.dim+1||t<-1||t>=this.dim+1)throw new RangeError(`Out of range source coordinates for DEM data. x: ${e}, y: ${t}, dim: ${this.dim}`);return(t+1)*this.stride+(e+1)}unpack(e,t,i){return e*this.redFactor+t*this.greenFactor+i*this.blueFactor-this.baseShift}pack(e){return Zc(e,this.getUnpackVector())}getPixels(){return new kc({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(e,t,i){if(this.dim!==e.dim)throw new Error("dem dimension mismatch");let r=t*this.dim,n=t*this.dim+this.dim,s=i*this.dim,a=i*this.dim+this.dim;switch(t){case-1:r=n-1;break;case 1:n=r+1}switch(i){case-1:s=a-1;break;case 1:a=s+1}const o=-t*this.dim,l=-i*this.dim;for(let t=s;t<a;t++)for(let i=r;i<n;i++)this.data[this._idx(i,t)]=e.data[this._idx(i+o,t+l)]}});class $c extends Xa{constructor(e,t){super(e,Uc,t)}_createColorRamp(e){const t={elevationStops:[],colorStops:[]},i=this._transitionablePaint._values["color-relief-color"].value.expression;if(i instanceof ds&&i._styleExpression.expression instanceof br){this.colorRampExpression=i;const e=i._styleExpression.expression;t.elevationStops=e.labels,t.colorStops=[];for(const i of t.elevationStops)t.colorStops.push(e.evaluate({globals:{elevation:i}}))}if(t.elevationStops.length<1&&(t.elevationStops=[0],t.colorStops=[Li.transparent]),t.elevationStops.length<2&&(t.elevationStops.push(t.elevationStops[0]+1),t.colorStops.push(t.colorStops[0])),t.elevationStops.length<=e)return t;const r={elevationStops:[],colorStops:[]},n=(t.elevationStops.length-1)/(e-1);for(let e=0;e<t.elevationStops.length-.5;e+=n)r.elevationStops.push(t.elevationStops[Math.round(e)]),r.colorStops.push(t.colorStops[Math.round(e)]);return Re(`Too many colors in specification of ${this.id} color-relief layer, may not render properly. Max possible colors: ${e}, provided: ${t.elevationStops.length}`),r}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(e,t,i){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const r=this._createColorRamp(t),n=new kc({width:r.colorStops.length,height:1}),s=new kc({width:r.colorStops.length,height:1});for(let e=0;e<r.elevationStops.length;e++){const t=Zc(r.elevationStops[e],i);s.setPixel(0,e,new Li(t.r/255,t.g/255,t.b/255,1)),n.setPixel(0,e,r.colorStops[e])}return this.colorRampTextures={elevationTexture:new Gc(e,s,e.gl.RGBA),colorTexture:new Gc(e,n,e.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return!this.isHidden()&&!!this.colorRampTextures}}const qc=ro([{name:"a_pos",components:2,type:"Int16"}],4),{members:Wc}=qc;function Hc(e,t,i){const r=i.patternDependencies;let n=!1;for(const i of t){const t=i.paint.get(`${e}-pattern`);t.isConstant()||(n=!0);const s=t.constantOr(null);s&&(n=!0,r[s.to]=!0,r[s.from]=!0)}return n}function Xc(e,t,i,r,n){const{zoom:s}=r,a=n.patternDependencies;for(const r of t){const t=r.paint.get(`${e}-pattern`).value;if("constant"!==t.kind){let e=t.evaluate({zoom:s-1},i,{},n.availableImages),o=t.evaluate({zoom:s},i,{},n.availableImages),l=t.evaluate({zoom:s+1},i,{},n.availableImages);e=e&&e.name?e.name:e,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,a[e]=!0,a[o]=!0,a[l]=!0,i.patterns[r.id]={min:e,mid:o,max:l}}}return i}function Yc(e,t,i,r,n){let s;if(n===function(e,t,i,r){let n=0;for(let s=t,a=i-r;s<i;s+=r)n+=(e[a]-e[s])*(e[s+1]+e[a+1]),a=s;return n}(e,t,i,r)>0)for(let n=t;n<i;n+=r)s=yh(n/r|0,e[n],e[n+1],s);else for(let n=i-r;n>=t;n-=r)s=yh(n/r|0,e[n],e[n+1],s);return s&&dh(s,s.next)&&(xh(s),s=s.next),s}function Kc(e,t){if(!e)return e;t||(t=e);let i,r=e;do{if(i=!1,r.steiner||!dh(r,r.next)&&0!==uh(r.prev,r,r.next))r=r.next;else{if(xh(r),r=t=r.prev,r===r.next)break;i=!0}}while(i||r!==t);return t}function Jc(e,t,i,r,n,s,a){if(!e)return;!a&&s&&function(e,t,i,r){let n=e;do{0===n.z&&(n.z=ah(n.x,n.y,t,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==e);n.prevZ.nextZ=null,n.prevZ=null,function(e){let t,i=1;do{let r,n=e;e=null;let s=null;for(t=0;n;){t++;let a=n,o=0;for(let e=0;e<i&&(o++,a=a.nextZ,a);e++);let l=i;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||n.z<=a.z)?(r=n,n=n.nextZ,o--):(r=a,a=a.nextZ,l--),s?s.nextZ=r:e=r,r.prevZ=s,s=r;n=a}s.nextZ=null,i*=2}while(t>1)}(n)}(e,r,n,s);let o=e;for(;e.prev!==e.next;){const l=e.prev,c=e.next;if(s?eh(e,r,n,s):Qc(e))t.push(l.i,e.i,c.i),xh(e),e=c.next,o=c.next;else if((e=c)===o){a?1===a?Jc(e=th(Kc(e),t),t,i,r,n,s,2):2===a&&ih(e,t,i,r,n,s):Jc(Kc(e),t,i,r,n,s,1);break}}}function Qc(e){const t=e.prev,i=e,r=e.next;if(uh(t,i,r)>=0)return!1;const n=t.x,s=i.x,a=r.x,o=t.y,l=i.y,c=r.y,h=Math.min(n,s,a),u=Math.min(o,l,c),d=Math.max(n,s,a),p=Math.max(o,l,c);let f=r.next;for(;f!==t;){if(f.x>=h&&f.x<=d&&f.y>=u&&f.y<=p&&ch(n,o,s,l,a,c,f.x,f.y)&&uh(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function eh(e,t,i,r){const n=e.prev,s=e,a=e.next;if(uh(n,s,a)>=0)return!1;const o=n.x,l=s.x,c=a.x,h=n.y,u=s.y,d=a.y,p=Math.min(o,l,c),f=Math.min(h,u,d),m=Math.max(o,l,c),_=Math.max(h,u,d),g=ah(p,f,t,i,r),y=ah(m,_,t,i,r);let x=e.prevZ,v=e.nextZ;for(;x&&x.z>=g&&v&&v.z<=y;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==a&&ch(o,h,l,u,c,d,x.x,x.y)&&uh(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,v.x>=p&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==a&&ch(o,h,l,u,c,d,v.x,v.y)&&uh(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;x&&x.z>=g;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==a&&ch(o,h,l,u,c,d,x.x,x.y)&&uh(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;v&&v.z<=y;){if(v.x>=p&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==a&&ch(o,h,l,u,c,d,v.x,v.y)&&uh(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function th(e,t){let i=e;do{const r=i.prev,n=i.next.next;!dh(r,n)&&ph(r,i,i.next,n)&&_h(r,n)&&_h(n,r)&&(t.push(r.i,i.i,n.i),xh(i),xh(i.next),i=e=n),i=i.next}while(i!==e);return Kc(i)}function ih(e,t,i,r,n,s){let a=e;do{let e=a.next.next;for(;e!==a.prev;){if(a.i!==e.i&&hh(a,e)){let o=gh(a,e);return a=Kc(a,a.next),o=Kc(o,o.next),Jc(a,t,i,r,n,s,0),void Jc(o,t,i,r,n,s,0)}e=e.next}a=a.next}while(a!==e)}function rh(e,t){let i=e.x-t.x;return 0===i&&(i=e.y-t.y,0===i)&&(i=(e.next.y-e.y)/(e.next.x-e.x)-(t.next.y-t.y)/(t.next.x-t.x)),i}function nh(e,t){const i=function(e,t){let i=t;const r=e.x,n=e.y;let s,a=-1/0;if(dh(e,i))return i;do{if(dh(e,i.next))return i.next;if(n<=i.y&&n>=i.next.y&&i.next.y!==i.y){const e=i.x+(n-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(e<=r&&e>a&&(a=e,s=i.x<i.next.x?i:i.next,e===r))return s}i=i.next}while(i!==t);if(!s)return null;const o=s,l=s.x,c=s.y;let h=1/0;i=s;do{if(r>=i.x&&i.x>=l&&r!==i.x&&lh(n<c?r:a,n,l,c,n<c?a:r,n,i.x,i.y)){const t=Math.abs(n-i.y)/(r-i.x);_h(i,e)&&(t<h||t===h&&(i.x>s.x||i.x===s.x&&sh(s,i)))&&(s=i,h=t)}i=i.next}while(i!==o);return s}(e,t);if(!i)return t;const r=gh(i,e);return Kc(r,r.next),Kc(i,i.next)}function sh(e,t){return uh(e.prev,e,t.prev)<0&&uh(t.next,e,e.next)<0}function ah(e,t,i,r,n){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-i)*n|0)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*n|0)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function oh(e){let t=e,i=e;do{(t.x<i.x||t.x===i.x&&t.y<i.y)&&(i=t),t=t.next}while(t!==e);return i}function lh(e,t,i,r,n,s,a,o){return(n-a)*(t-o)>=(e-a)*(s-o)&&(e-a)*(r-o)>=(i-a)*(t-o)&&(i-a)*(s-o)>=(n-a)*(r-o)}function ch(e,t,i,r,n,s,a,o){return!(e===a&&t===o)&&lh(e,t,i,r,n,s,a,o)}function hh(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!function(e,t){let i=e;do{if(i.i!==e.i&&i.next.i!==e.i&&i.i!==t.i&&i.next.i!==t.i&&ph(i,i.next,e,t))return!0;i=i.next}while(i!==e);return!1}(e,t)&&(_h(e,t)&&_h(t,e)&&function(e,t){let i=e,r=!1;const n=(e.x+t.x)/2,s=(e.y+t.y)/2;do{i.y>s!=i.next.y>s&&i.next.y!==i.y&&n<(i.next.x-i.x)*(s-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==e);return r}(e,t)&&(uh(e.prev,e,t.prev)||uh(e,t.prev,t))||dh(e,t)&&uh(e.prev,e,e.next)>0&&uh(t.prev,t,t.next)>0)}function uh(e,t,i){return(t.y-e.y)*(i.x-t.x)-(t.x-e.x)*(i.y-t.y)}function dh(e,t){return e.x===t.x&&e.y===t.y}function ph(e,t,i,r){const n=mh(uh(e,t,i)),s=mh(uh(e,t,r)),a=mh(uh(i,r,e)),o=mh(uh(i,r,t));return n!==s&&a!==o||!(0!==n||!fh(e,i,t))||!(0!==s||!fh(e,r,t))||!(0!==a||!fh(i,e,r))||!(0!==o||!fh(i,t,r))}function fh(e,t,i){return t.x<=Math.max(e.x,i.x)&&t.x>=Math.min(e.x,i.x)&&t.y<=Math.max(e.y,i.y)&&t.y>=Math.min(e.y,i.y)}function mh(e){return e>0?1:e<0?-1:0}function _h(e,t){return uh(e.prev,e,e.next)<0?uh(e,t,e.next)>=0&&uh(e,e.prev,t)>=0:uh(e,t,e.prev)<0||uh(e,e.next,t)<0}function gh(e,t){const i=vh(e.i,e.x,e.y),r=vh(t.i,t.x,t.y),n=e.next,s=t.prev;return e.next=t,t.prev=e,i.next=n,n.prev=i,r.next=i,i.prev=r,s.next=r,r.prev=s,r}function yh(e,t,i,r){const n=vh(e,t,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function xh(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function vh(e,t,i){return{i:e,x:t,y:i,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class bh{constructor(e,t){if(t>e)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=e,this._minGranularity=t}getGranularityForZoomLevel(e){return Math.max(Math.floor(this._baseZoomGranularity/(1<<e)),this._minGranularity,1)}}class wh{constructor(e){this.fill=e.fill,this.line=e.line,this.tile=e.tile,this.stencil=e.stencil,this.circle=e.circle}}wh.noSubdivision=new wh({fill:new bh(0,0),line:new bh(0,0),tile:new bh(0,0),stencil:new bh(0,0),circle:1}),ya("SubdivisionGranularityExpression",bh),ya("SubdivisionGranularitySetting",wh);const Th=-32768,Sh=32767;class Ph{constructor(e,t){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=e,this._granularityCellSize=Q/e,this._canonical=t}_getKey(e,t){return(e+=32768)<<16|t+32768}_vertexToIndex(e,t){if(e<-32768||t<-32768||e>32767||t>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const i=0|Math.round(e),r=0|Math.round(t),n=this._getKey(i,r);if(this._vertexDictionary.has(n))return this._vertexDictionary.get(n);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(n,s),this._vertexBuffer.push(i,r),s}_subdivideTrianglesScanline(e){if(this._granularity<2)return function(e,t){const i=[];for(let r=0;r<t.length;r+=3){const n=t[r],s=t[r+1],a=t[r+2],o=e[2*n],l=e[2*n+1];(e[2*s]-o)*(e[2*a+1]-l)-(e[2*s+1]-l)*(e[2*a]-o)>0?(i.push(n),i.push(a),i.push(s)):(i.push(n),i.push(s),i.push(a))}return i}(this._vertexBuffer,e);const t=[],i=e.length;for(let r=0;r<i;r+=3){const i=[e[r+0],e[r+1],e[r+2]],n=[this._vertexBuffer[2*e[r+0]+0],this._vertexBuffer[2*e[r+0]+1],this._vertexBuffer[2*e[r+1]+0],this._vertexBuffer[2*e[r+1]+1],this._vertexBuffer[2*e[r+2]+0],this._vertexBuffer[2*e[r+2]+1]];let s=1/0,a=1/0,o=-1/0,l=-1/0;for(let e=0;e<3;e++){const t=n[2*e],i=n[2*e+1];s=Math.min(s,t),o=Math.max(o,t),a=Math.min(a,i),l=Math.max(l,i)}if(s===o||a===l)continue;const c=Math.floor(s/this._granularityCellSize),h=Math.ceil(o/this._granularityCellSize),u=Math.floor(a/this._granularityCellSize),d=Math.ceil(l/this._granularityCellSize);if(c!==h||u!==d)for(let e=u;e<d;e++){const r=this._scanlineGenerateVertexRingForCellRow(e,n,i);Eh(this._vertexBuffer,r,t)}else t.push(...i)}return t}_scanlineGenerateVertexRingForCellRow(e,t,i){const r=e*this._granularityCellSize,n=r+this._granularityCellSize,s=[];for(let e=0;e<3;e++){const a=t[2*e],o=t[2*e+1],l=t[2*(e+1)%6],c=t[(2*(e+1)+1)%6],h=t[2*(e+2)%6],u=t[(2*(e+2)+1)%6],d=l-a,p=c-o,f=0===d,m=0===p,_=(r-o)/p,g=(n-o)/p,y=Math.min(_,g),x=Math.max(_,g);if(!m&&(y>=1||x<=0)||m&&(o<r||o>n)){c>=r&&c<=n&&s.push(i[(e+1)%3]);continue}!m&&y>0&&s.push(this._vertexToIndex(a+d*y,o+p*y));const v=a+d*Math.max(y,0),b=a+d*Math.min(x,1);f||this._generateIntraEdgeVertices(s,a,o,l,c,v,b),!m&&x<1&&s.push(this._vertexToIndex(a+d*x,o+p*x)),(m||c>=r&&c<=n)&&s.push(i[(e+1)%3]),!m&&(c<=r||c>=n)&&this._generateInterEdgeVertices(s,a,o,l,c,h,u,b,r,n)}return s}_generateIntraEdgeVertices(e,t,i,r,n,s,a){const o=r-t,l=n-i,c=0===l,h=c?Math.min(t,r):Math.min(s,a),u=c?Math.max(t,r):Math.max(s,a),d=Math.floor(h/this._granularityCellSize)+1,p=Math.ceil(u/this._granularityCellSize)-1;if(c?t<r:s<a)for(let r=d;r<=p;r++){const n=r*this._granularityCellSize;e.push(this._vertexToIndex(n,i+l*(n-t)/o))}else for(let r=p;r>=d;r--){const n=r*this._granularityCellSize;e.push(this._vertexToIndex(n,i+l*(n-t)/o))}}_generateInterEdgeVertices(e,t,i,r,n,s,a,o,l,c){const h=n-i,u=s-r,d=a-n,p=(l-n)/d,f=(c-n)/d,m=Math.min(p,f),_=Math.max(p,f),g=r+u*m;let y=Math.floor(Math.min(g,o)/this._granularityCellSize)+1,x=Math.ceil(Math.max(g,o)/this._granularityCellSize)-1,v=o<g;const b=0===d;if(b&&(a===l||a===c))return;if(b||m>=1||_<=0){const e=i-a,r=s+(t-s)*Math.min((l-a)/e,(c-a)/e);y=Math.floor(Math.min(r,o)/this._granularityCellSize)+1,x=Math.ceil(Math.max(r,o)/this._granularityCellSize)-1,v=o<r}const w=h>0?c:l;if(v)for(let t=y;t<=x;t++)e.push(this._vertexToIndex(t*this._granularityCellSize,w));else for(let t=x;t>=y;t--)e.push(this._vertexToIndex(t*this._granularityCellSize,w))}_generateOutline(e){const t=[];for(const i of e){const e=Mh(i,this._granularity,!0),r=this._pointArrayToIndices(e),n=[];for(let e=1;e<r.length;e++)n.push(r[e-1]),n.push(r[e]);t.push(n)}return t}_handlePoles(e){let t=!1,i=!1;this._canonical&&(0===this._canonical.y&&(t=!0),this._canonical.y===(1<<this._canonical.z)-1&&(i=!0)),(t||i)&&this._fillPoles(e,t,i)}_ensureNoPoleVertices(){const e=this._vertexBuffer;for(let t=0;t<e.length;t+=2){const i=e[t+1];i===Th&&(e[t+1]=-32767),i===Sh&&(e[t+1]=32766)}}_generatePoleQuad(e,t,i,r,n,s){r>n!=(s===Th)?(e.push(t),e.push(i),e.push(this._vertexToIndex(r,s)),e.push(i),e.push(this._vertexToIndex(n,s)),e.push(this._vertexToIndex(r,s))):(e.push(i),e.push(t),e.push(this._vertexToIndex(r,s)),e.push(this._vertexToIndex(n,s)),e.push(i),e.push(this._vertexToIndex(r,s)))}_fillPoles(e,t,i){const r=this._vertexBuffer,n=Q,s=e.length;for(let a=2;a<s;a+=3){const s=e[a-2],o=e[a-1],l=e[a],c=r[2*s],h=r[2*s+1],u=r[2*o],d=r[2*o+1],p=r[2*l],f=r[2*l+1];t&&(0===h&&0===d&&this._generatePoleQuad(e,s,o,c,u,Th),0===d&&0===f&&this._generatePoleQuad(e,o,l,u,p,Th),0===f&&0===h&&this._generatePoleQuad(e,l,s,p,c,Th)),i&&(h===n&&d===n&&this._generatePoleQuad(e,s,o,c,u,Sh),d===n&&f===n&&this._generatePoleQuad(e,o,l,u,p,Sh),f===n&&h===n&&this._generatePoleQuad(e,l,s,p,c,Sh))}}_initializeVertices(e){for(let t=0;t<e.length;t+=2)this._vertexToIndex(e[t],e[t+1])}subdividePolygonInternal(e,t){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:i,holeIndices:r}=function(e){const t=[],i=[];for(const r of e)if(0!==r.length){r!==e[0]&&t.push(i.length/2);for(let e=0;e<r.length;e++)i.push(r[e].x),i.push(r[e].y)}return{flattened:i,holeIndices:t}}(e);let n;this._initializeVertices(i);try{const e=function(e,t,i=2){const r=t&&t.length,n=r?t[0]*i:e.length;let s=Yc(e,0,n,i,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,c;if(r&&(s=function(e,t,i,r){const n=[];for(let i=0,s=t.length;i<s;i++){const a=Yc(e,t[i]*r,i<s-1?t[i+1]*r:e.length,r,!1);a===a.next&&(a.steiner=!0),n.push(oh(a))}n.sort(rh);for(let e=0;e<n.length;e++)i=nh(n[e],i);return i}(e,t,s,i)),e.length>80*i){o=e[0],l=e[1];let t=o,r=l;for(let s=i;s<n;s+=i){const i=e[s],n=e[s+1];i<o&&(o=i),n<l&&(l=n),i>t&&(t=i),n>r&&(r=n)}c=Math.max(t-o,r-l),c=0!==c?32767/c:0}return Jc(s,a,i,o,l,c,0),a}(i,r),t=this._convertIndices(i,e);n=this._subdivideTrianglesScanline(t)}catch(e){console.error(e)}let s=[];return t&&(s=this._generateOutline(e)),this._ensureNoPoleVertices(),this._handlePoles(n),{verticesFlattened:this._vertexBuffer,indicesTriangles:n,indicesLineList:s}}_convertIndices(e,t){const i=[];for(let r=0;r<t.length;r++)i.push(this._vertexToIndex(e[2*t[r]],e[2*t[r]+1]));return i}_pointArrayToIndices(e){const t=[];for(let i=0;i<e.length;i++){const r=e[i];t.push(this._vertexToIndex(r.x,r.y))}return t}}function Ih(e,t,i,r=!0){return new Ph(i,t).subdividePolygonInternal(e,r)}function Mh(e,t,i=!1){if(!e||e.length<1)return[];if(e.length<2)return[];const r=e[0],n=e[e.length-1],a=i&&(r.x!==n.x||r.y!==n.y);if(t<2)return a?[...e,e[0]]:[...e];const o=Math.floor(Q/t),l=[];l.push(new s(e[0].x,e[0].y));const c=e.length,h=a?c:c-1;for(let t=0;t<h;t++){const i=e[t],r=t<c-1?e[t+1]:e[0],n=i.x,a=i.y,h=r.x,u=r.y,d=n!==h,p=a!==u;if(!d&&!p)continue;const f=h-n,m=u-a,_=Math.abs(f),g=Math.abs(m);let y=n,x=a;for(;;){const e=f>0?(Math.floor(y/o)+1)*o:(Math.ceil(y/o)-1)*o,t=m>0?(Math.floor(x/o)+1)*o:(Math.ceil(x/o)-1)*o,i=Math.abs(y-e),r=Math.abs(x-t),n=Math.abs(y-h),a=Math.abs(x-u),c=d?i/_:Number.POSITIVE_INFINITY,v=p?r/g:Number.POSITIVE_INFINITY;if((n<=i||!d)&&(a<=r||!p))break;if(c<v&&d||!p){y=e,x+=m*c;const t=new s(y,Math.round(x));l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t)}else{y+=f*v,x=t;const e=new s(Math.round(y),x);l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e)}}const v=new s(h,u);l[l.length-1].x===v.x&&l[l.length-1].y===v.y||l.push(v)}return l}function Eh(e,t,i){if(0===t.length)throw new Error("Subdivision vertex ring is empty.");let r=0,n=e[2*t[0]];for(let i=1;i<t.length;i++){const s=e[2*t[i]];s<n&&(n=s,r=i)}const s=t.length;let a=r,o=(a+1)%s;for(;;){const r=a-1>=0?a-1:s-1,n=(o+1)%s,l=e[2*t[r]],c=e[2*t[n]],h=e[2*t[a]],u=e[2*t[a]+1],d=e[2*t[o]+1];let p=!1;if(l<c)p=!0;else if(l>c)p=!1;else{const i=d-u,s=-(e[2*t[o]]-h),a=u<d?1:-1;((l-h)*i+(e[2*t[r]+1]-u)*s)*a>((c-h)*i+(e[2*t[n]+1]-u)*s)*a&&(p=!0)}if(p){const e=t[r],n=t[a],l=t[o];e!==n&&e!==l&&n!==l&&i.push(l,n,e),a--,a<0&&(a=s-1)}else{const e=t[n],r=t[a],l=t[o];e!==r&&e!==l&&r!==l&&i.push(l,r,e),o++,o>=s&&(o=0)}if(r===n)break}}function Ch(e,t,i,r,n,s,a,o,l){const c=n.length/2,h=a&&o&&l;if(c<hl.MAX_VERTEX_ARRAY_LENGTH){const u=t.prepareSegment(c,i,r),d=u.vertexLength;for(let e=0;e<s.length;e+=3)r.emplaceBack(d+s[e],d+s[e+1],d+s[e+2]);let p,f;u.vertexLength+=c,u.primitiveLength+=s.length/3,h&&(f=a.prepareSegment(c,i,o),p=f.vertexLength,f.vertexLength+=c);for(let t=0;t<n.length;t+=2)e(n[t],n[t+1]);if(h)for(let e=0;e<l.length;e++){const t=l[e];for(let e=1;e<t.length;e+=2)o.emplaceBack(p+t[e-1],p+t[e]);f.primitiveLength+=t.length/2}}else!function(e,t,i,r,n,s){const a=[];for(let e=0;e<r.length/2;e++)a.push(-1);const o={count:0};let l=0,c=e.getOrCreateLatestSegment(t,i),h=c.vertexLength;for(let u=2;u<n.length;u+=3){const d=n[u-2],p=n[u-1],f=n[u];let m=a[d]<l,_=a[p]<l,g=a[f]<l;c.vertexLength+((m?1:0)+(_?1:0)+(g?1:0))>hl.MAX_VERTEX_ARRAY_LENGTH&&(c=e.createNewSegment(t,i),l=o.count,m=!0,_=!0,g=!0,h=0);const y=Ah(a,r,s,o,d,m,c),x=Ah(a,r,s,o,p,_,c),v=Ah(a,r,s,o,f,g,c);i.emplaceBack(h+y-l,h+x-l,h+v-l),c.primitiveLength++}}(t,i,r,n,s,e),h&&function(e,t,i,r,n,s){const a=[];for(let e=0;e<r.length/2;e++)a.push(-1);const o={count:0};let l=0,c=e.getOrCreateLatestSegment(t,i),h=c.vertexLength;for(let u=0;u<n.length;u++){const d=n[u];for(let p=1;p<n[u].length;p+=2){const n=d[p-1],u=d[p];let f=a[n]<l,m=a[u]<l;c.vertexLength+((f?1:0)+(m?1:0))>hl.MAX_VERTEX_ARRAY_LENGTH&&(c=e.createNewSegment(t,i),l=o.count,f=!0,m=!0,h=0);const _=Ah(a,r,s,o,n,f,c),g=Ah(a,r,s,o,u,m,c);i.emplaceBack(h+_-l,h+g-l),c.primitiveLength++}}}(a,i,o,n,l,e),t.forceNewSegmentOnNextPrepare(),null==a||a.forceNewSegmentOnNextPrepare()}function Ah(e,t,i,r,n,s,a){if(s){const s=r.count;return i(t[2*n],t[2*n+1]),e[n]=r.count,r.count++,a.vertexLength++,s}return e[n]}class zh{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.patternFeatures=[],this.layoutVertexArray=new qo,this.indexArray=new sl,this.indexArray2=new al,this.programConfigurations=new ql(e.layers,e.zoom),this.segments=new hl,this.segments2=new hl,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,i){this.hasDependencies=Hc("fill",this.layers,t);const r=this.layers[0].layout.get("fill-sort-key"),n=!r.isConstant(),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:c}of e){const e=this.layers[0]._featureFilter.needGeometry,h=Jl(a,e);if(!this.layers[0]._featureFilter.filter(new Da(this.zoom),h,i))continue;const u=n?r.evaluate(h,{},i,t.availableImages):void 0,d={id:o,properties:a.properties,type:a.type,sourceLayerIndex:c,index:l,geometry:e?h.geometry:Kl(a),patterns:{},sortKey:u};s.push(d)}n&&s.sort(((e,t)=>e.sortKey-t.sortKey));for(const r of s){const{geometry:n,index:s,sourceLayerIndex:a}=r;if(this.hasDependencies){const e=Xc("fill",this.layers,r,{zoom:this.zoom},t);this.patternFeatures.push(e)}else this.addFeature(r,n,s,i,{},t.subdivisionGranularity);t.featureIndex.insert(e[s].feature,n,s,a,this.index)}}update(e,t,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:i})}addFeatures(e,t,i){for(const r of this.patternFeatures)this.addFeature(r,r.geometry,r.index,t,i,e.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,Wc),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.indexBuffer2=e.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(e,t,i,r,n,s){for(const e of cn(t,500)){const t=Ih(e,r,s.fill.getGranularityForZoomLevel(r.z)),i=this.layoutVertexArray;Ch(((e,t)=>{i.emplaceBack(e,t)}),this.segments,this.layoutVertexArray,this.indexArray,t.verticesFlattened,t.indicesTriangles,this.segments2,this.indexArray2,t.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,{imagePositions:n,canonical:r})}}let Dh,Rh;ya("FillBucket",zh,{omit:["layers","patternFeatures"]});var kh={get paint(){return Rh=Rh||new Ha({"fill-antialias":new Ga(It.paint_fill["fill-antialias"]),"fill-opacity":new Za(It.paint_fill["fill-opacity"]),"fill-color":new Za(It.paint_fill["fill-color"]),"fill-outline-color":new Za(It.paint_fill["fill-outline-color"]),"fill-translate":new Ga(It.paint_fill["fill-translate"]),"fill-translate-anchor":new Ga(It.paint_fill["fill-translate-anchor"]),"fill-pattern":new $a(It.paint_fill["fill-pattern"])})},get layout(){return Dh=Dh||new Ha({"fill-sort-key":new Za(It.layout_fill["fill-sort-key"])})}};class Lh extends Xa{constructor(e,t){super(e,kh,t)}recalculate(e,t){super.recalculate(e,t);const i=this.paint._values["fill-outline-color"];"constant"===i.value.kind&&void 0===i.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(e){return new zh(e)}queryRadius(){return fc(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:e,geometry:t,transform:i,pixelsToTileUnits:r}){return nc(mc(e,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-i.bearingInRadians,r),t)}isTileClipped(){return!0}}const Fh=ro([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Bh=ro([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Oh}=Fh;class Vh{constructor(e,t,i,r,n){this.properties={},this.extent=i,this.type=0,this.id=void 0,this._pbf=e,this._geometry=-1,this._keys=r,this._values=n,e.readFields(jh,this,t)}loadGeometry(){const e=this._pbf;e.pos=this._geometry;const t=e.readVarint()+e.pos,i=[];let r,n=1,a=0,o=0,l=0;for(;e.pos<t;){if(a<=0){const t=e.readVarint();n=7&t,a=t>>3}if(a--,1===n||2===n)o+=e.readSVarint(),l+=e.readSVarint(),1===n&&(r&&i.push(r),r=[]),r&&r.push(new s(o,l));else{if(7!==n)throw new Error(`unknown command ${n}`);r&&r.push(r[0].clone())}}return r&&i.push(r),i}bbox(){const e=this._pbf;e.pos=this._geometry;const t=e.readVarint()+e.pos;let i=1,r=0,n=0,s=0,a=1/0,o=-1/0,l=1/0,c=-1/0;for(;e.pos<t;){if(r<=0){const t=e.readVarint();i=7&t,r=t>>3}if(r--,1===i||2===i)n+=e.readSVarint(),s+=e.readSVarint(),n<a&&(a=n),n>o&&(o=n),s<l&&(l=s),s>c&&(c=s);else if(7!==i)throw new Error(`unknown command ${i}`)}return[a,l,o,c]}toGeoJSON(e,t,i){const r=this.extent*Math.pow(2,i),n=this.extent*e,s=this.extent*t,a=this.loadGeometry();function o(e){return[360*(e.x+n)/r-180,360/Math.PI*Math.atan(Math.exp((1-2*(e.y+s)/r)*Math.PI))-90]}function l(e){return e.map(o)}let c;if(1===this.type){const e=[];for(const t of a)e.push(t[0]);const t=l(e);c=1===e.length?{type:"Point",coordinates:t[0]}:{type:"MultiPoint",coordinates:t}}else if(2===this.type){const e=a.map(l);c=1===e.length?{type:"LineString",coordinates:e[0]}:{type:"MultiLineString",coordinates:e}}else{if(3!==this.type)throw new Error("unknown feature type");{const e=Nh(a),t=[];for(const i of e)t.push(i.map(l));c=1===t.length?{type:"Polygon",coordinates:t[0]}:{type:"MultiPolygon",coordinates:t}}}const h={type:"Feature",geometry:c,properties:this.properties};return null!=this.id&&(h.id=this.id),h}}function jh(e,t,i){1===e?t.id=i.readVarint():2===e?function(e,t){const i=e.readVarint()+e.pos;for(;e.pos<i;){const i=t._keys[e.readVarint()],r=t._values[e.readVarint()];t.properties[i]=r}}(i,t):3===e?t.type=i.readVarint():4===e&&(t._geometry=i.pos)}function Nh(e){const t=e.length;if(t<=1)return[e];const i=[];let r,n;for(let s=0;s<t;s++){const t=Uh(e[s]);0!==t&&(void 0===n&&(n=t<0),n===t<0?(r&&i.push(r),r=[e[s]]):r&&r.push(e[s]))}return r&&i.push(r),i}function Uh(e){let t=0;for(let i,r,n=0,s=e.length,a=s-1;n<s;a=n++)i=e[n],r=e[a],t+=(r.x-i.x)*(i.y+r.y);return t}Vh.types=["Unknown","Point","LineString","Polygon"];class Gh{constructor(e,t){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=e,this._keys=[],this._values=[],this._features=[],e.readFields(Zh,this,t),this.length=this._features.length}feature(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];const t=this._pbf.readVarint()+this._pbf.pos;return new Vh(this._pbf,t,this.extent,this._keys,this._values)}}function Zh(e,t,i){15===e?t.version=i.readVarint():1===e?t.name=i.readString():5===e?t.extent=i.readVarint():2===e?t._features.push(i.pos):3===e?t._keys.push(i.readString()):4===e&&t._values.push(function(e){let t=null;const i=e.readVarint()+e.pos;for(;e.pos<i;){const i=e.readVarint()>>3;t=1===i?e.readString():2===i?e.readFloat():3===i?e.readDouble():4===i?e.readVarint64():5===i?e.readVarint():6===i?e.readSVarint():7===i?e.readBoolean():null}if(null==t)throw new Error("unknown feature value");return t}(i))}class $h{constructor(e,t){this.layers=e.readFields(qh,{},t)}}function qh(e,t,i){if(3===e){const e=new Gh(i,i.readVarint()+i.pos);e.length&&(t[e.name]=e)}}const Wh=Math.pow(2,13);function Hh(e,t,i,r,n,s,a,o){e.emplaceBack(t,i,2*Math.floor(r*Wh)+a,n*Wh*2,s*Wh*2,Math.round(o))}class Xh{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.layoutVertexArray=new Wo,this.centroidVertexArray=new Uo,this.indexArray=new sl,this.programConfigurations=new ql(e.layers,e.zoom),this.segments=new hl,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,i){this.features=[],this.hasDependencies=Hc("fill-extrusion",this.layers,t);for(const{feature:r,id:n,index:s,sourceLayerIndex:a}of e){const e=this.layers[0]._featureFilter.needGeometry,o=Jl(r,e);if(!this.layers[0]._featureFilter.filter(new Da(this.zoom),o,i))continue;const l={id:n,sourceLayerIndex:a,index:s,geometry:e?o.geometry:Kl(r),properties:r.properties,type:r.type,patterns:{}};this.hasDependencies?this.features.push(Xc("fill-extrusion",this.layers,l,{zoom:this.zoom},t)):this.addFeature(l,l.geometry,s,i,{},t.subdivisionGranularity),t.featureIndex.insert(r,l.geometry,s,a,this.index,!0)}}addFeatures(e,t,i){for(const r of this.features){const{geometry:n}=r;this.addFeature(r,n,r.index,t,i,e.subdivisionGranularity)}}update(e,t,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:i})}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,Oh),this.centroidVertexBuffer=e.createVertexBuffer(this.centroidVertexArray,Bh.members,!0),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(e,t,i,r,n,s){for(const i of cn(t,500)){const t={x:0,y:0,sampleCount:0},n=this.layoutVertexArray.length;this.processPolygon(t,r,e,i,s);const a=this.layoutVertexArray.length-n,o=Math.floor(t.x/t.sampleCount),l=Math.floor(t.y/t.sampleCount);for(let e=0;e<a;e++)this.centroidVertexArray.emplaceBack(o,l)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,{imagePositions:n,canonical:r})}processPolygon(e,t,i,r,n){if(r.length<1)return;if(Jh(r[0]))return;for(const t of r)0!==t.length&&Yh(e,t);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},a=n.fill.getGranularityForZoomLevel(t.z),o="Polygon"===Vh.types[i.type];for(const e of r){if(0===e.length)continue;if(Jh(e))continue;const t=Mh(e,a,o);this._generateSideFaces(t,s)}if(!o)return;const l=Ih(r,t,a,!1),c=this.layoutVertexArray;Ch(((e,t)=>{Hh(c,e,t,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles)}_generateSideFaces(e,t){let i=0;for(let r=1;r<e.length;r++){const n=e[r],s=e[r-1];if(Kh(n,s))continue;t.segment.vertexLength+4>hl.MAX_VERTEX_ARRAY_LENGTH&&(t.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const a=n.sub(s)._perp()._unit(),o=s.dist(n);i+o>32768&&(i=0),Hh(this.layoutVertexArray,n.x,n.y,a.x,a.y,0,0,i),Hh(this.layoutVertexArray,n.x,n.y,a.x,a.y,0,1,i),i+=o,Hh(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,0,i),Hh(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,1,i);const l=t.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),t.segment.vertexLength+=4,t.segment.primitiveLength+=2}}}function Yh(e,t){for(let i=0;i<t.length;i++){const r=t[i];i===t.length-1&&t[0].x===r.x&&t[0].y===r.y||(e.x+=r.x,e.y+=r.y,e.sampleCount++)}}function Kh(e,t){return e.x===t.x&&(e.x<0||e.x>Q)||e.y===t.y&&(e.y<0||e.y>Q)}function Jh(e){return e.every((e=>e.x<0))||e.every((e=>e.x>Q))||e.every((e=>e.y<0))||e.every((e=>e.y>Q))}let Qh;ya("FillExtrusionBucket",Xh,{omit:["layers","features"]});var eu={get paint(){return Qh=Qh||new Ha({"fill-extrusion-opacity":new Ga(It["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Za(It["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Ga(It["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Ga(It["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new $a(It["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Za(It["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Za(It["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Ga(It["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class tu extends Xa{constructor(e,t){super(e,eu,t)}createBucket(e){return new Xh(e)}queryRadius(){return fc(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:i,geometry:r,transform:n,pixelsToTileUnits:a,pixelPosMatrix:o}){const l=mc(e,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-n.bearingInRadians,a),c=this.paint.get("fill-extrusion-height").evaluate(t,i),h=this.paint.get("fill-extrusion-base").evaluate(t,i),u=function(e,t){const i=[];for(const r of e){const e=[r.x,r.y,0,1];Z(e,e,t),i.push(new s(e[0]/e[3],e[1]/e[3]))}return i}(l,o),d=function(e,t,i,r){const n=[],a=[],o=r[8]*t,l=r[9]*t,c=r[10]*t,h=r[11]*t,u=r[8]*i,d=r[9]*i,p=r[10]*i,f=r[11]*i;for(const t of e){const e=[],i=[];for(const n of t){const t=n.x,a=n.y,m=r[0]*t+r[4]*a+r[12],_=r[1]*t+r[5]*a+r[13],g=r[2]*t+r[6]*a+r[14],y=r[3]*t+r[7]*a+r[15],x=g+c,v=y+h,b=m+u,w=_+d,T=g+p,S=y+f,P=new s((m+o)/v,(_+l)/v);P.z=x/v,e.push(P);const I=new s(b/S,w/S);I.z=T/S,i.push(I)}n.push(e),a.push(i)}return[n,a]}(r,h,c,o);return function(e,t,i){let r=1/0;nc(i,t)&&(r=ru(i,t[0]));for(let n=0;n<t.length;n++){const s=t[n],a=e[n];for(let e=0;e<s.length-1;e++){const t=s[e],n=[t,s[e+1],a[e+1],a[e],t];ic(i,n)&&(r=Math.min(r,ru(i,n)))}}return r!==1/0&&r}(d[0],d[1],u)}}function iu(e,t){return e.x*t.x+e.y*t.y}function ru(e,t){if(1===e.length){let i=0;const r=t[i++];let n;for(;!n||r.equals(n);)if(n=t[i++],!n)return 1/0;for(;i<t.length;i++){const s=t[i],a=e[0],o=n.sub(r),l=s.sub(r),c=a.sub(r),h=iu(o,o),u=iu(o,l),d=iu(l,l),p=iu(c,o),f=iu(c,l),m=h*d-u*u,_=(d*p-u*f)/m,g=(h*f-u*p)/m,y=r.z*(1-_-g)+n.z*_+s.z*g;if(isFinite(y))return y}return 1/0}{let e=1/0;for(const i of t)e=Math.min(e,i.z);return e}}const nu=ro([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:su}=nu,au=ro([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:ou}=au,lu=Math.cos(Math.PI/180*37.5),cu=Math.pow(2,14)/.5;class hu{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((e=>{this.gradients[e.id]={}})),this.layoutVertexArray=new Ho,this.layoutVertexArray2=new Xo,this.indexArray=new sl,this.programConfigurations=new ql(e.layers,e.zoom),this.segments=new hl,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,i){this.hasDependencies=Hc("line",this.layers,t)||this.hasLineDasharray(this.layers);const r=this.layers[0].layout.get("line-sort-key"),n=!r.isConstant(),s=[];for(const{feature:t,id:a,index:o,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,c=Jl(t,e);if(!this.layers[0]._featureFilter.filter(new Da(this.zoom),c,i))continue;const h=n?r.evaluate(c,{},i):void 0,u={id:a,properties:t.properties,type:t.type,sourceLayerIndex:l,index:o,geometry:e?c.geometry:Kl(t),patterns:{},dashes:{},sortKey:h};s.push(u)}n&&s.sort(((e,t)=>e.sortKey-t.sortKey));for(const r of s){const{geometry:n,index:s,sourceLayerIndex:a}=r;this.hasDependencies?(Hc("line",this.layers,t)?Xc("line",this.layers,r,{zoom:this.zoom},t):this.hasLineDasharray(this.layers)&&this.addLineDashDependencies(this.layers,r,this.zoom,t),this.patternFeatures.push(r)):this.addFeature(r,n,s,i,{},{},t.subdivisionGranularity),t.featureIndex.insert(e[s].feature,n,s,a,this.index)}}update(e,t,i,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:i,dashPositions:r})}addFeatures(e,t,i,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,t,i,r,e.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=e.createVertexBuffer(this.layoutVertexArray2,ou)),this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,su),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(e){if(e.properties&&Object.prototype.hasOwnProperty.call(e.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(e.properties,"mapbox_clip_end"))return{start:+e.properties.mapbox_clip_start,end:+e.properties.mapbox_clip_end}}addFeature(e,t,i,r,n,s,a){const o=this.layers[0].layout,l=o.get("line-join").evaluate(e,{}),c=o.get("line-cap"),h=o.get("line-miter-limit"),u=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(e);for(const i of t)this.addLine(i,e,l,c,h,u,r,a);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,{imagePositions:n,dashPositions:s,canonical:r})}addLine(e,t,i,r,n,s,a,o){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,e=Mh(e,a?o.line.getGranularityForZoomLevel(a.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let t=0;t<e.length-1;t++)this.totalDistance+=e[t].dist(e[t+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const l="Polygon"===Vh.types[t.type];let c=e.length;for(;c>=2&&e[c-1].equals(e[c-2]);)c--;let h=0;for(;h<c-1&&e[h].equals(e[h+1]);)h++;if(c<(l?3:2))return;"bevel"===i&&(n=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,d=this.segments.prepareSegment(10*c,this.layoutVertexArray,this.indexArray);let p,f,m,_,g;this.e1=this.e2=-1,l&&(p=e[c-2],g=e[h].sub(p)._unit()._perp());for(let t=h;t<c;t++){if(m=t===c-1?l?e[h+1]:void 0:e[t+1],m&&e[t].equals(m))continue;g&&(_=g),p&&(f=p),p=e[t],g=m?m.sub(p)._unit()._perp():_,_=_||g;let a=_.add(g);0===a.x&&0===a.y||a._unit();const o=_.x*g.x+_.y*g.y,y=a.x*g.x+a.y*g.y,x=0!==y?1/y:1/0,v=2*Math.sqrt(2-2*y),b=y<lu&&f&&m,w=_.x*g.y-_.y*g.x>0;if(b&&t>h){const e=p.dist(f);if(e>2*u){const t=p.sub(p.sub(f)._mult(u/e)._round());this.updateDistance(f,t),this.addCurrentVertex(t,_,0,0,d),f=t}}const T=f&&m;let S=T?i:l?"butt":r;if(T&&"round"===S&&(x<s?S="miter":x<=2&&(S="fakeround")),"miter"===S&&x>n&&(S="bevel"),"bevel"===S&&(x>2&&(S="flipbevel"),x<n&&(S="miter")),f&&this.updateDistance(f,p),"miter"===S)a._mult(x),this.addCurrentVertex(p,a,0,0,d);else if("flipbevel"===S){if(x>100)a=g.mult(-1);else{const e=x*_.add(g).mag()/_.sub(g).mag();a._perp()._mult(e*(w?-1:1))}this.addCurrentVertex(p,a,0,0,d),this.addCurrentVertex(p,a.mult(-1),0,0,d)}else if("bevel"===S||"fakeround"===S){const e=-Math.sqrt(x*x-1),t=w?e:0,i=w?0:e;if(f&&this.addCurrentVertex(p,_,t,i,d),"fakeround"===S){const e=Math.round(180*v/Math.PI/20);for(let t=1;t<e;t++){let i=t/e;if(.5!==i){const e=i-.5;i+=i*e*(i-1)*((1.0904+o*(o*(3.55645-1.43519*o)-3.2452))*e*e+(.848013+o*(.215638*o-1.06021)))}const r=g.sub(_)._mult(i)._add(_)._unit()._mult(w?-1:1);this.addHalfVertex(p,r.x,r.y,!1,w,0,d)}}m&&this.addCurrentVertex(p,g,-t,-i,d)}else if("butt"===S)this.addCurrentVertex(p,a,0,0,d);else if("square"===S){const e=f?1:-1;this.addCurrentVertex(p,a,e,e,d)}else"round"===S&&(f&&(this.addCurrentVertex(p,_,0,0,d),this.addCurrentVertex(p,_,1,1,d,!0)),m&&(this.addCurrentVertex(p,g,-1,-1,d,!0),this.addCurrentVertex(p,g,0,0,d)));if(b&&t<c-1){const e=p.dist(m);if(e>2*u){const t=p.add(m.sub(p)._mult(u/e)._round());this.updateDistance(p,t),this.addCurrentVertex(t,g,0,0,d),p=t}}}}addCurrentVertex(e,t,i,r,n,s=!1){const a=t.y*r-t.x,o=-t.y-t.x*r;this.addHalfVertex(e,t.x+t.y*i,t.y-t.x*i,s,!1,i,n),this.addHalfVertex(e,a,o,s,!0,-r,n),this.distance>cu/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(e,t,i,r,n,s))}addHalfVertex({x:e,y:t},i,r,n,s,a,o){const l=.5*(this.lineClips?this.scaledDistance*(cu-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((e<<1)+(n?1:0),(t<<1)+(s?1:0),Math.round(63*i)+128,Math.round(63*r)+128,1+(0===a?0:a<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const c=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,c,this.e2),o.primitiveLength++),s?this.e2=c:this.e1=c}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(e,t){this.distance+=e.dist(t),this.updateScaledDistance()}hasLineDasharray(e){for(const t of e){const e=t.paint.get("line-dasharray");if(e&&!e.isConstant())return!0}return!1}addLineDashDependencies(e,t,i,r){for(const n of e){const e=n.paint.get("line-dasharray");if(!e||"constant"===e.value.kind)continue;const s="round"===n.layout.get("line-cap"),a={dasharray:e.value.evaluate({zoom:i-1},t,{}),round:s},o={dasharray:e.value.evaluate({zoom:i},t,{}),round:s},l={dasharray:e.value.evaluate({zoom:i+1},t,{}),round:s},c=`${a.dasharray.join(",")},${a.round}`,h=`${o.dasharray.join(",")},${o.round}`,u=`${l.dasharray.join(",")},${l.round}`;r.dashDependencies[c]=a,r.dashDependencies[h]=o,r.dashDependencies[u]=l,t.dashes[n.id]={min:c,mid:h,max:u}}}}let uu,du;ya("LineBucket",hu,{omit:["layers","patternFeatures"]});var pu={get paint(){return du=du||new Ha({"line-opacity":new Za(It.paint_line["line-opacity"]),"line-color":new Za(It.paint_line["line-color"]),"line-translate":new Ga(It.paint_line["line-translate"]),"line-translate-anchor":new Ga(It.paint_line["line-translate-anchor"]),"line-width":new Za(It.paint_line["line-width"]),"line-gap-width":new Za(It.paint_line["line-gap-width"]),"line-offset":new Za(It.paint_line["line-offset"]),"line-blur":new Za(It.paint_line["line-blur"]),"line-dasharray":new $a(It.paint_line["line-dasharray"]),"line-pattern":new $a(It.paint_line["line-pattern"]),"line-gradient":new Wa(It.paint_line["line-gradient"])})},get layout(){return uu=uu||new Ha({"line-cap":new Ga(It.layout_line["line-cap"]),"line-join":new Za(It.layout_line["line-join"]),"line-miter-limit":new Ga(It.layout_line["line-miter-limit"]),"line-round-limit":new Ga(It.layout_line["line-round-limit"]),"line-sort-key":new Za(It.layout_line["line-sort-key"])})}};class fu extends Za{possiblyEvaluate(e,t){return t=new Da(Math.floor(t.zoom),{now:t.now,fadeDuration:t.fadeDuration,zoomHistory:t.zoomHistory,transition:t.transition}),super.possiblyEvaluate(e,t)}evaluate(e,t,i,r){return t=we({},t,{zoom:Math.floor(t.zoom)}),super.evaluate(e,t,i,r)}}let mu;class _u extends Xa{constructor(e,t){super(e,pu,t),this.gradientVersion=0,mu||(mu=new fu(pu.paint.properties["line-width"].specification),mu.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(e){if("line-gradient"===e){const e=this.gradientExpression();this.stepInterpolant=!!function(e){return void 0!==e._styleExpression}(e)&&e._styleExpression.expression instanceof mr,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(e,t){super.recalculate(e,t),this.paint._values["line-floorwidth"]=mu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,e)}createBucket(e){return new hu(e)}queryRadius(e){const t=e,i=gu(pc("line-width",this,t),pc("line-gap-width",this,t)),r=pc("line-offset",this,t);return i/2+Math.abs(r)+fc(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:i,geometry:r,transform:n,pixelsToTileUnits:a}){const o=mc(e,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-n.bearingInRadians,a),l=a/2*gu(this.paint.get("line-width").evaluate(t,i),this.paint.get("line-gap-width").evaluate(t,i)),c=this.paint.get("line-offset").evaluate(t,i);return c&&(r=function(e,t){const i=[];for(let r=0;r<e.length;r++){const n=_c(e[r]),a=[];for(let e=0;e<n.length;e++){const i=n[e],r=n[e-1],o=n[e+1],l=0===e?new s(0,0):i.sub(r)._unit()._perp(),c=e===n.length-1?new s(0,0):o.sub(i)._unit()._perp(),h=l._add(c)._unit(),u=h.x*c.x+h.y*c.y;0!==u&&h._mult(1/u),a.push(h._mult(t)._add(i))}i.push(a)}return i}(r,c*a)),function(e,t,i){for(let r=0;r<t.length;r++){const n=t[r];if(e.length>=3)for(let t=0;t<n.length;t++)if(uc(e,n[t]))return!0;if(sc(e,n,i))return!0}return!1}(o,r,l)}isTileClipped(){return!0}}function gu(e,t){return t>0?t+2*e:e}const yu=ro([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),xu=ro([{name:"a_projected_pos",components:3,type:"Float32"}],4);ro([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const vu=ro([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);ro([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const bu=ro([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),wu=ro([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function Tu(e,t,i){return e.sections.forEach((e=>{e.text=function(e,t,i){const r=t.layout.get("text-transform").evaluate(i,{});return"uppercase"===r?e=e.toLocaleUpperCase():"lowercase"===r&&(e=e.toLocaleLowerCase()),za.applyArabicShaping&&(e=za.applyArabicShaping(e)),e}(e.text,t,i)})),e}ro([{name:"triangle",components:3,type:"Uint16"}]),ro([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),ro([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),ro([{type:"Float32",name:"offsetX"}]),ro([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),ro([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const Su={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","⋯":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"},Pu=4294967296,Iu=1/Pu,Mu="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class Eu{constructor(e=new Uint8Array(16)){this.buf=ArrayBuffer.isView(e)?e:new Uint8Array(e),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length}readFields(e,t,i=this.length){for(;this.pos<i;){const i=this.readVarint(),r=i>>3,n=this.pos;this.type=7&i,e(r,t,this),this.pos===n&&this.skip(i)}return t}readMessage(e,t){return this.readFields(e,t,this.readVarint()+this.pos)}readFixed32(){const e=this.dataView.getUint32(this.pos,!0);return this.pos+=4,e}readSFixed32(){const e=this.dataView.getInt32(this.pos,!0);return this.pos+=4,e}readFixed64(){const e=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*Pu;return this.pos+=8,e}readSFixed64(){const e=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*Pu;return this.pos+=8,e}readFloat(){const e=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,e}readDouble(){const e=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,e}readVarint(e){const t=this.buf;let i,r;return r=t[this.pos++],i=127&r,r<128?i:(r=t[this.pos++],i|=(127&r)<<7,r<128?i:(r=t[this.pos++],i|=(127&r)<<14,r<128?i:(r=t[this.pos++],i|=(127&r)<<21,r<128?i:(r=t[this.pos],i|=(15&r)<<28,function(e,t,i){const r=i.buf;let n,s;if(s=r[i.pos++],n=(112&s)>>4,s<128)return Cu(e,n,t);if(s=r[i.pos++],n|=(127&s)<<3,s<128)return Cu(e,n,t);if(s=r[i.pos++],n|=(127&s)<<10,s<128)return Cu(e,n,t);if(s=r[i.pos++],n|=(127&s)<<17,s<128)return Cu(e,n,t);if(s=r[i.pos++],n|=(127&s)<<24,s<128)return Cu(e,n,t);if(s=r[i.pos++],n|=(1&s)<<31,s<128)return Cu(e,n,t);throw new Error("Expected varint not more than 10 bytes")}(i,e,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const e=this.readVarint();return e%2==1?(e+1)/-2:e/2}readBoolean(){return Boolean(this.readVarint())}readString(){const e=this.readVarint()+this.pos,t=this.pos;return this.pos=e,e-t>=12&&Mu?Mu.decode(this.buf.subarray(t,e)):function(e,t,i){let r="",n=t;for(;n<i;){const t=e[n];let s,a,o,l=null,c=t>239?4:t>223?3:t>191?2:1;if(n+c>i)break;1===c?t<128&&(l=t):2===c?(s=e[n+1],128==(192&s)&&(l=(31&t)<<6|63&s,l<=127&&(l=null))):3===c?(s=e[n+1],a=e[n+2],128==(192&s)&&128==(192&a)&&(l=(15&t)<<12|(63&s)<<6|63&a,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===c&&(s=e[n+1],a=e[n+2],o=e[n+3],128==(192&s)&&128==(192&a)&&128==(192&o)&&(l=(15&t)<<18|(63&s)<<12|(63&a)<<6|63&o,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,c=1):l>65535&&(l-=65536,r+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),r+=String.fromCharCode(l),n+=c}return r}(this.buf,t,e)}readBytes(){const e=this.readVarint()+this.pos,t=this.buf.subarray(this.pos,e);return this.pos=e,t}readPackedVarint(e=[],t){const i=this.readPackedEnd();for(;this.pos<i;)e.push(this.readVarint(t));return e}readPackedSVarint(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSVarint());return e}readPackedBoolean(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readBoolean());return e}readPackedFloat(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFloat());return e}readPackedDouble(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readDouble());return e}readPackedFixed32(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFixed32());return e}readPackedSFixed32(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSFixed32());return e}readPackedFixed64(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFixed64());return e}readPackedSFixed64(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSFixed64());return e}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(e){const t=7&e;if(0===t)for(;this.buf[this.pos++]>127;);else if(2===t)this.pos=this.readVarint()+this.pos;else if(5===t)this.pos+=4;else{if(1!==t)throw new Error(`Unimplemented type: ${t}`);this.pos+=8}}writeTag(e,t){this.writeVarint(e<<3|t)}realloc(e){let t=this.length||16;for(;t<this.pos+e;)t*=2;if(t!==this.length){const e=new Uint8Array(t);e.set(this.buf),this.buf=e,this.dataView=new DataView(e.buffer),this.length=t}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(e){this.realloc(4),this.dataView.setInt32(this.pos,e,!0),this.pos+=4}writeSFixed32(e){this.realloc(4),this.dataView.setInt32(this.pos,e,!0),this.pos+=4}writeFixed64(e){this.realloc(8),this.dataView.setInt32(this.pos,-1&e,!0),this.dataView.setInt32(this.pos+4,Math.floor(e*Iu),!0),this.pos+=8}writeSFixed64(e){this.realloc(8),this.dataView.setInt32(this.pos,-1&e,!0),this.dataView.setInt32(this.pos+4,Math.floor(e*Iu),!0),this.pos+=8}writeVarint(e){(e=+e||0)>268435455||e<0?function(e,t){let i,r;if(e>=0?(i=e%4294967296|0,r=e/4294967296|0):(i=~(-e%4294967296),r=~(-e/4294967296),4294967295^i?i=i+1|0:(i=0,r=r+1|0)),e>=0x10000000000000000||e<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");t.realloc(10),function(e,t,i){i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,i.buf[i.pos]=127&(e>>>=7)}(i,0,t),function(e,t){const i=(7&e)<<4;t.buf[t.pos++]|=i|((e>>>=3)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e)))))}(r,t)}(e,this):(this.realloc(4),this.buf[this.pos++]=127&e|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=e>>>7&127))))}writeSVarint(e){this.writeVarint(e<0?2*-e-1:2*e)}writeBoolean(e){this.writeVarint(+e)}writeString(e){e=String(e),this.realloc(4*e.length),this.pos++;const t=this.pos;this.pos=function(e,t,i){for(let r,n,s=0;s<t.length;s++){if(r=t.charCodeAt(s),r>55295&&r<57344){if(!n){r>56319||s+1===t.length?(e[i++]=239,e[i++]=191,e[i++]=189):n=r;continue}if(r<56320){e[i++]=239,e[i++]=191,e[i++]=189,n=r;continue}r=n-55296<<10|r-56320|65536,n=null}else n&&(e[i++]=239,e[i++]=191,e[i++]=189,n=null);r<128?e[i++]=r:(r<2048?e[i++]=r>>6|192:(r<65536?e[i++]=r>>12|224:(e[i++]=r>>18|240,e[i++]=r>>12&63|128),e[i++]=r>>6&63|128),e[i++]=63&r|128)}return i}(this.buf,e,this.pos);const i=this.pos-t;i>=128&&Au(t,i,this),this.pos=t-1,this.writeVarint(i),this.pos+=i}writeFloat(e){this.realloc(4),this.dataView.setFloat32(this.pos,e,!0),this.pos+=4}writeDouble(e){this.realloc(8),this.dataView.setFloat64(this.pos,e,!0),this.pos+=8}writeBytes(e){const t=e.length;this.writeVarint(t),this.realloc(t);for(let i=0;i<t;i++)this.buf[this.pos++]=e[i]}writeRawMessage(e,t){this.pos++;const i=this.pos;e(t,this);const r=this.pos-i;r>=128&&Au(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r}writeMessage(e,t,i){this.writeTag(e,2),this.writeRawMessage(t,i)}writePackedVarint(e,t){t.length&&this.writeMessage(e,zu,t)}writePackedSVarint(e,t){t.length&&this.writeMessage(e,Du,t)}writePackedBoolean(e,t){t.length&&this.writeMessage(e,Lu,t)}writePackedFloat(e,t){t.length&&this.writeMessage(e,Ru,t)}writePackedDouble(e,t){t.length&&this.writeMessage(e,ku,t)}writePackedFixed32(e,t){t.length&&this.writeMessage(e,Fu,t)}writePackedSFixed32(e,t){t.length&&this.writeMessage(e,Bu,t)}writePackedFixed64(e,t){t.length&&this.writeMessage(e,Ou,t)}writePackedSFixed64(e,t){t.length&&this.writeMessage(e,Vu,t)}writeBytesField(e,t){this.writeTag(e,2),this.writeBytes(t)}writeFixed32Field(e,t){this.writeTag(e,5),this.writeFixed32(t)}writeSFixed32Field(e,t){this.writeTag(e,5),this.writeSFixed32(t)}writeFixed64Field(e,t){this.writeTag(e,1),this.writeFixed64(t)}writeSFixed64Field(e,t){this.writeTag(e,1),this.writeSFixed64(t)}writeVarintField(e,t){this.writeTag(e,0),this.writeVarint(t)}writeSVarintField(e,t){this.writeTag(e,0),this.writeSVarint(t)}writeStringField(e,t){this.writeTag(e,2),this.writeString(t)}writeFloatField(e,t){this.writeTag(e,5),this.writeFloat(t)}writeDoubleField(e,t){this.writeTag(e,1),this.writeDouble(t)}writeBooleanField(e,t){this.writeVarintField(e,+t)}}function Cu(e,t,i){return i?4294967296*t+(e>>>0):4294967296*(t>>>0)+(e>>>0)}function Au(e,t,i){const r=t<=16383?1:t<=2097151?2:t<=268435455?3:Math.floor(Math.log(t)/(7*Math.LN2));i.realloc(r);for(let t=i.pos-1;t>=e;t--)i.buf[t+r]=i.buf[t]}function zu(e,t){for(let i=0;i<e.length;i++)t.writeVarint(e[i])}function Du(e,t){for(let i=0;i<e.length;i++)t.writeSVarint(e[i])}function Ru(e,t){for(let i=0;i<e.length;i++)t.writeFloat(e[i])}function ku(e,t){for(let i=0;i<e.length;i++)t.writeDouble(e[i])}function Lu(e,t){for(let i=0;i<e.length;i++)t.writeBoolean(e[i])}function Fu(e,t){for(let i=0;i<e.length;i++)t.writeFixed32(e[i])}function Bu(e,t){for(let i=0;i<e.length;i++)t.writeSFixed32(e[i])}function Ou(e,t){for(let i=0;i<e.length;i++)t.writeFixed64(e[i])}function Vu(e,t){for(let i=0;i<e.length;i++)t.writeSFixed64(e[i])}function ju(e,t,i){1===e&&i.readMessage(Nu,t)}function Nu(e,t,i){if(3===e){const{id:e,bitmap:r,width:n,height:s,left:a,top:o,advance:l}=i.readMessage(Uu,{});t.push({id:e,bitmap:new Rc({width:n+6,height:s+6},r),metrics:{width:n,height:s,left:a,top:o,advance:l}})}}function Uu(e,t,i){1===e?t.id=i.readVarint():2===e?t.bitmap=i.readBytes():3===e?t.width=i.readVarint():4===e?t.height=i.readVarint():5===e?t.left=i.readSVarint():6===e?t.top=i.readSVarint():7===e&&(t.advance=i.readVarint())}function Gu(e){let t=0,i=0;for(const r of e)t+=r.w*r.h,i=Math.max(i,r.w);e.sort(((e,t)=>t.h-e.h));const r=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(t/.95)),i),h:1/0}];let n=0,s=0;for(const t of e)for(let e=r.length-1;e>=0;e--){const i=r[e];if(!(t.w>i.w||t.h>i.h)){if(t.x=i.x,t.y=i.y,s=Math.max(s,t.y+t.h),n=Math.max(n,t.x+t.w),t.w===i.w&&t.h===i.h){const t=r.pop();t&&e<r.length&&(r[e]=t)}else t.h===i.h?(i.x+=t.w,i.w-=t.w):t.w===i.w?(i.y+=t.h,i.h-=t.h):(r.push({x:i.x+t.w,y:i.y,w:i.w-t.w,h:t.h}),i.y+=t.h,i.h-=t.h);break}}return{w:n,h:s,fill:t/(n*s)||0}}class Zu{constructor(e,{pixelRatio:t,version:i,stretchX:r,stretchY:n,content:s,textFitWidth:a,textFitHeight:o}){this.paddedRect=e,this.pixelRatio=t,this.stretchX=r,this.stretchY=n,this.content=s,this.version=i,this.textFitWidth=a,this.textFitHeight=o}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}var $u;function qu(e){let t=.5,i=.5;switch(e){case"right":case"top-right":case"bottom-right":t=1;break;case"left":case"top-left":case"bottom-left":t=0}switch(e){case"bottom":case"bottom-right":case"bottom-left":i=1;break;case"top":case"top-right":case"top-left":i=0}return{horizontalAlign:t,verticalAlign:i}}function Wu(e,t){const{expression:i}=t;if("constant"===i.kind)return{kind:"constant",layoutSize:i.evaluate(new Da(e+1))};if("source"===i.kind)return{kind:"source"};{const{zoomStops:t,interpolationType:r}=i;let n=0;for(;n<t.length&&t[n]<=e;)n++;n=Math.max(0,n-1);let s=n;for(;s<t.length&&t[s]<e+1;)s++;s=Math.min(t.length-1,s);const a=t[n],o=t[s];return"composite"===i.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:r}:{kind:"camera",minZoom:a,maxZoom:o,minSize:i.evaluate(new Da(a)),maxSize:i.evaluate(new Da(o)),interpolationType:r}}}function Hu(e,{uSize:t,uSizeT:i},{lowerSize:r,upperSize:n}){return"source"===e.kind?r/128:"composite"===e.kind?Tr.number(r/128,n/128,i):t}function Xu(e,t){let i=0,r=0;if("constant"===e.kind)r=e.layoutSize;else if("source"!==e.kind){const{interpolationType:n,minZoom:s,maxZoom:a}=e,o=n?ve(br.interpolationFactor(n,t,s,a),0,1):0;"camera"===e.kind?r=Tr.number(e.minSize,e.maxSize,o):i=o}return{uSizeT:i,uSize:r}}function Yu(e,t,i){let r="never";const n=e.get(t);return n?r=n:e.get(i)&&(r="always"),r}ya("ImagePosition",Zu),ya("ImageAtlas",class{constructor(e,t){const i={},r={};this.haveRenderCallbacks=[];const n=[];this.addImages(e,i,n),this.addImages(t,r,n);const{w:s,h:a}=Gu(n),o=new kc({width:s||1,height:a||1});for(const t in e){const r=e[t],n=i[t].paddedRect;kc.copy(r.data,o,{x:0,y:0},{x:n.x+1,y:n.y+1},r.data)}for(const e in t){const i=t[e],n=r[e].paddedRect,s=n.x+1,a=n.y+1,l=i.data.width,c=i.data.height;kc.copy(i.data,o,{x:0,y:0},{x:s,y:a},i.data),kc.copy(i.data,o,{x:0,y:c-1},{x:s,y:a-1},{width:l,height:1}),kc.copy(i.data,o,{x:0,y:0},{x:s,y:a+c},{width:l,height:1}),kc.copy(i.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:c}),kc.copy(i.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:c})}this.image=o,this.iconPositions=i,this.patternPositions=r}addImages(e,t,i){for(const r in e){const n=e[r],s={x:0,y:0,w:n.data.width+2,h:n.data.height+2};i.push(s),t[r]=new Zu(s,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(r)}}patchUpdatedImages(e,t){e.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const i in e.updatedImages)this.patchUpdatedImage(this.iconPositions[i],e.getImage(i),t),this.patchUpdatedImage(this.patternPositions[i],e.getImage(i),t)}patchUpdatedImage(e,t,i){if(!e||!t)return;if(e.version===t.version)return;e.version=t.version;const[r,n]=e.tl;i.update(t.data,void 0,{x:r,y:n})}}),function(e){e[e.none=0]="none",e[e.horizontal=1]="horizontal",e[e.vertical=2]="vertical",e[e.horizontalOnly=3]="horizontalOnly"}($u||($u={}));const Ku=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Ju(e,t,i,r,n,s,a,o,l,c,h,u,d){const p=o?Math.min(32640,Math.round(o[0])):0,f=o?Math.min(32640,Math.round(o[1])):0;e.emplaceBack(t,i,Math.round(32*r),Math.round(32*n),s,a,(p<<1)+(l?1:0),f,16*c,16*h,256*u,256*d)}function Qu(e,t,i){e.emplaceBack(t.x,t.y,i),e.emplaceBack(t.x,t.y,i),e.emplaceBack(t.x,t.y,i),e.emplaceBack(t.x,t.y,i)}function ed(e){for(const t of e.sections)if(Aa(t.text))return!0;return!1}class td{constructor(e){this.layoutVertexArray=new Jo,this.indexArray=new sl,this.programConfigurations=e,this.segments=new hl,this.dynamicLayoutVertexArray=new Qo,this.opacityVertexArray=new el,this.hasVisibleVertices=!1,this.placedSymbolArray=new Ro}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(e,t,i,r){this.isEmpty()||(i&&(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,yu.members),this.indexBuffer=e.createIndexBuffer(this.indexArray,t),this.dynamicLayoutVertexBuffer=e.createVertexBuffer(this.dynamicLayoutVertexArray,xu.members,!0),this.opacityVertexBuffer=e.createVertexBuffer(this.opacityVertexArray,Ku,!0),this.opacityVertexBuffer.itemSize=1),(i||r)&&this.programConfigurations.upload(e))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}ya("SymbolBuffers",td);class id{constructor(e,t,i){this.layoutVertexArray=new e,this.layoutAttributes=t,this.indexArray=new i,this.segments=new hl,this.collisionVertexArray=new rl}upload(e){this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=e.createVertexBuffer(this.collisionVertexArray,vu.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}ya("CollisionBuffers",id);class rd{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasDependencies=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const t=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Wu(this.zoom,t["text-size"]),this.iconSizeData=Wu(this.zoom,t["icon-size"]);const i=this.layers[0].layout,r=i.get("symbol-sort-key"),n=i.get("symbol-z-order");this.canOverlap="never"!==Yu(i,"text-overlap","text-allow-overlap")||"never"!==Yu(i,"icon-overlap","icon-allow-overlap")||i.get("text-ignore-placement")||i.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&!r.isConstant(),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===i.get("symbol-placement")&&(this.writingModes=i.get("text-writing-mode").map((e=>$u[e]))),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.sourceID=e.sourceID}createArrays(){this.text=new td(new ql(this.layers,this.zoom,(e=>/^text/.test(e)))),this.icon=new td(new ql(this.layers,this.zoom,(e=>/^icon/.test(e)))),this.glyphOffsetArray=new Fo,this.lineVertexArray=new Bo,this.symbolInstances=new Lo,this.textAnchorOffsets=new Vo}calculateGlyphDependencies(e,t,i,r,n){for(const s of e)if(t[s.codePointAt(0)]=!0,(i||r)&&n){const e=Su[s];e&&(t[e.codePointAt(0)]=!0)}}populate(e,t,i){const r=this.layers[0],n=r.layout,s=n.get("text-font"),a=n.get("text-field"),o=n.get("icon-image"),l=("constant"!==a.value.kind||a.value.value instanceof Vi&&!a.value.value.isEmpty()||a.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),c="constant"!==o.value.kind||!!o.value.value||Object.keys(o.parameters).length>0,h=n.get("symbol-sort-key");if(this.features=[],!l&&!c)return;const u=t.iconDependencies,d=t.glyphDependencies,p=t.availableImages,f=new Da(this.zoom);for(const{feature:t,id:a,index:o,sourceLayerIndex:m}of e){const e=r._featureFilter.needGeometry,_=Jl(t,e);if(!r._featureFilter.filter(f,_,i))continue;let g,y;if(e||(_.geometry=Kl(t)),l){const e=r.getValueAndResolveTokens("text-field",_,i,p),t=Vi.factory(e),n=this.hasRTLText=this.hasRTLText||ed(t);(!n||"unavailable"===za.getRTLTextPluginStatus()||n&&za.isParsed())&&(g=Tu(t,r,_))}if(c){const e=r.getValueAndResolveTokens("icon-image",_,i,p);y=e instanceof qi?e:qi.fromString(e)}if(!g&&!y)continue;const x=this.sortFeaturesByKey?h.evaluate(_,{},i):void 0;if(this.features.push({id:a,text:g,icon:y,index:o,sourceLayerIndex:m,geometry:_.geometry,properties:t.properties,type:Vh.types[t.type],sortKey:x}),y&&(u[y.name]=!0),g){const e=s.evaluate(_,{},i).join(","),t="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf($u.vertical)>=0;for(const i of g.sections)if(i.image)u[i.image.name]=!0;else{const r=Pa(g.toString()),n=i.fontStack||e,s=d[n]=d[n]||{};this.calculateGlyphDependencies(i.text,s,t,this.allowVerticalPlacement,r)}}}"line"===n.get("symbol-placement")&&(this.features=function(e){const t={},i={},r=[];let n=0;function s(t){r.push(e[t]),n++}function a(e,t,n){const s=i[e];return delete i[e],i[t]=s,r[s].geometry[0].pop(),r[s].geometry[0]=r[s].geometry[0].concat(n[0]),s}function o(e,i,n){const s=t[i];return delete t[i],t[e]=s,r[s].geometry[0].shift(),r[s].geometry[0]=n[0].concat(r[s].geometry[0]),s}function l(e,t,i){const r=i?t[0][t[0].length-1]:t[0][0];return`${e}:${r.x}:${r.y}`}for(let c=0;c<e.length;c++){const h=e[c],u=h.geometry,d=h.text?h.text.toString():null;if(!d){s(c);continue}const p=l(d,u),f=l(d,u,!0);if(p in i&&f in t&&i[p]!==t[f]){const e=o(p,f,u),n=a(p,f,r[e].geometry);delete t[p],delete i[f],i[l(d,r[n].geometry,!0)]=n,r[e].geometry=null}else p in i?a(p,f,u):f in t?o(p,f,u):(s(c),t[p]=n-1,i[f]=n-1)}return r.filter((e=>e.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((e,t)=>e.sortKey-t.sortKey))}update(e,t,i){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(e,t,this.layers,{imagePositions:i}),this.icon.programConfigurations.updatePaintArrays(e,t,this.layers,{imagePositions:i}))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(e){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(e),this.iconCollisionBox.upload(e)),this.text.upload(e,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(e,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(e,t){const i=this.lineVertexArray.length;if(void 0!==e.segment){let i=e.dist(t[e.segment+1]),r=e.dist(t[e.segment]);const n={};for(let r=e.segment+1;r<t.length;r++)n[r]={x:t[r].x,y:t[r].y,tileUnitDistanceFromAnchor:i},r<t.length-1&&(i+=t[r+1].dist(t[r]));for(let i=e.segment||0;i>=0;i--)n[i]={x:t[i].x,y:t[i].y,tileUnitDistanceFromAnchor:r},i>0&&(r+=t[i-1].dist(t[i]));for(let e=0;e<t.length;e++){const t=n[e];this.lineVertexArray.emplaceBack(t.x,t.y,t.tileUnitDistanceFromAnchor)}}return{lineStartIndex:i,lineLength:this.lineVertexArray.length-i}}addSymbols(e,t,i,r,n,s,a,o,l,c,h,u){const d=e.indexArray,p=e.layoutVertexArray,f=e.segments.prepareSegment(4*t.length,p,d,this.canOverlap?s.sortKey:void 0),m=this.glyphOffsetArray.length,_=f.vertexLength,g=this.allowVerticalPlacement&&a===$u.vertical?Math.PI/2:0,y=s.text&&s.text.sections;for(let r=0;r<t.length;r++){const{tl:n,tr:a,bl:l,br:c,tex:h,pixelOffsetTL:m,pixelOffsetBR:_,minFontScaleX:x,minFontScaleY:v,glyphOffset:b,isSDF:w,sectionIndex:T}=t[r],S=f.vertexLength,P=b[1];Ju(p,o.x,o.y,n.x,P+n.y,h.x,h.y,i,w,m.x,m.y,x,v),Ju(p,o.x,o.y,a.x,P+a.y,h.x+h.w,h.y,i,w,_.x,m.y,x,v),Ju(p,o.x,o.y,l.x,P+l.y,h.x,h.y+h.h,i,w,m.x,_.y,x,v),Ju(p,o.x,o.y,c.x,P+c.y,h.x+h.w,h.y+h.h,i,w,_.x,_.y,x,v),Qu(e.dynamicLayoutVertexArray,o,g),d.emplaceBack(S,S+2,S+1),d.emplaceBack(S+1,S+2,S+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(b[0]),r!==t.length-1&&T===t[r+1].sectionIndex||e.programConfigurations.populatePaintArrays(p.length,s,s.index,{imagePositions:{},canonical:u,formattedSection:y&&y[T]})}e.placedSymbolArray.emplaceBack(o.x,o.y,m,this.glyphOffsetArray.length-m,_,l,c,o.segment,i?i[0]:0,i?i[1]:0,r[0],r[1],a,0,!1,0,h)}_addCollisionDebugVertex(e,t,i,r,n,s){return t.emplaceBack(0,0),e.emplaceBack(i.x,i.y,r,n,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(e,t,i,r,n,a,o){const l=n.segments.prepareSegment(4,n.layoutVertexArray,n.indexArray),c=l.vertexLength,h=n.layoutVertexArray,u=n.collisionVertexArray,d=o.anchorX,p=o.anchorY;this._addCollisionDebugVertex(h,u,a,d,p,new s(e,t)),this._addCollisionDebugVertex(h,u,a,d,p,new s(i,t)),this._addCollisionDebugVertex(h,u,a,d,p,new s(i,r)),this._addCollisionDebugVertex(h,u,a,d,p,new s(e,r)),l.vertexLength+=4;const f=n.indexArray;f.emplaceBack(c,c+1),f.emplaceBack(c+1,c+2),f.emplaceBack(c+2,c+3),f.emplaceBack(c+3,c),l.primitiveLength+=4}addDebugCollisionBoxes(e,t,i,r){for(let n=e;n<t;n++){const e=this.collisionBoxArray.get(n);this.addCollisionDebugVertices(e.x1,e.y1,e.x2,e.y2,r?this.textCollisionBox:this.iconCollisionBox,e.anchorPoint,i)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new id(tl,bu.members,al),this.iconCollisionBox=new id(tl,bu.members,al);for(let e=0;e<this.symbolInstances.length;e++){const t=this.symbolInstances.get(e);this.addDebugCollisionBoxes(t.textBoxStartIndex,t.textBoxEndIndex,t,!0),this.addDebugCollisionBoxes(t.verticalTextBoxStartIndex,t.verticalTextBoxEndIndex,t,!0),this.addDebugCollisionBoxes(t.iconBoxStartIndex,t.iconBoxEndIndex,t,!1),this.addDebugCollisionBoxes(t.verticalIconBoxStartIndex,t.verticalIconBoxEndIndex,t,!1)}}_deserializeCollisionBoxesForSymbol(e,t,i,r,n,s,a,o,l){const c={};for(let r=t;r<i;r++){const t=e.get(r);c.textBox={x1:t.x1,y1:t.y1,x2:t.x2,y2:t.y2,anchorPointX:t.anchorPointX,anchorPointY:t.anchorPointY},c.textFeatureIndex=t.featureIndex;break}for(let t=r;t<n;t++){const i=e.get(t);c.verticalTextBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalTextFeatureIndex=i.featureIndex;break}for(let t=s;t<a;t++){const i=e.get(t);c.iconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.iconFeatureIndex=i.featureIndex;break}for(let t=o;t<l;t++){const i=e.get(t);c.verticalIconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalIconFeatureIndex=i.featureIndex;break}return c}deserializeCollisionBoxes(e){this.collisionArrays=[];for(let t=0;t<this.symbolInstances.length;t++){const i=this.symbolInstances.get(t);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(e,i.textBoxStartIndex,i.textBoxEndIndex,i.verticalTextBoxStartIndex,i.verticalTextBoxEndIndex,i.iconBoxStartIndex,i.iconBoxEndIndex,i.verticalIconBoxStartIndex,i.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(e,t){const i=e.placedSymbolArray.get(t),r=i.vertexStartIndex+4*i.numGlyphs;for(let t=i.vertexStartIndex;t<r;t+=4)e.indexArray.emplaceBack(t,t+2,t+1),e.indexArray.emplaceBack(t+1,t+2,t+3)}getSortedSymbolIndexes(e){if(this.sortedAngle===e&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const t=Math.sin(e),i=Math.cos(e),r=[],n=[],s=[];for(let e=0;e<this.symbolInstances.length;++e){s.push(e);const a=this.symbolInstances.get(e);r.push(0|Math.round(t*a.anchorX+i*a.anchorY)),n.push(a.featureIndex)}return s.sort(((e,t)=>r[e]-r[t]||n[t]-n[e])),s}addToSortKeyRanges(e,t){const i=this.sortKeyRanges[this.sortKeyRanges.length-1];i&&i.sortKey===t?i.symbolInstanceEnd=e+1:this.sortKeyRanges.push({sortKey:t,symbolInstanceStart:e,symbolInstanceEnd:e+1})}sortFeatures(e){if(this.sortFeaturesByY&&this.sortedAngle!==e&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(e),this.sortedAngle=e,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const e of this.symbolInstanceIndexes){const t=this.symbolInstances.get(e);this.featureSortOrder.push(t.featureIndex),[t.rightJustifiedTextSymbolIndex,t.centerJustifiedTextSymbolIndex,t.leftJustifiedTextSymbolIndex].forEach(((e,t,i)=>{e>=0&&i.indexOf(e)===t&&this.addIndicesForPlacedSymbol(this.text,e)})),t.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,t.verticalPlacedTextSymbolIndex),t.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,t.placedIconSymbolIndex),t.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,t.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let nd,sd;ya("SymbolBucket",rd,{omit:["layers","collisionBoxArray","features","compareText"]}),rd.MAX_GLYPHS=65535,rd.addDynamicAttributes=Qu;var ad={get paint(){return sd=sd||new Ha({"icon-opacity":new Za(It.paint_symbol["icon-opacity"]),"icon-color":new Za(It.paint_symbol["icon-color"]),"icon-halo-color":new Za(It.paint_symbol["icon-halo-color"]),"icon-halo-width":new Za(It.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Za(It.paint_symbol["icon-halo-blur"]),"icon-translate":new Ga(It.paint_symbol["icon-translate"]),"icon-translate-anchor":new Ga(It.paint_symbol["icon-translate-anchor"]),"text-opacity":new Za(It.paint_symbol["text-opacity"]),"text-color":new Za(It.paint_symbol["text-color"],{runtimeType:Wt,getOverride:e=>e.textColor,hasOverride:e=>!!e.textColor}),"text-halo-color":new Za(It.paint_symbol["text-halo-color"]),"text-halo-width":new Za(It.paint_symbol["text-halo-width"]),"text-halo-blur":new Za(It.paint_symbol["text-halo-blur"]),"text-translate":new Ga(It.paint_symbol["text-translate"]),"text-translate-anchor":new Ga(It.paint_symbol["text-translate-anchor"])})},get layout(){return nd=nd||new Ha({"symbol-placement":new Ga(It.layout_symbol["symbol-placement"]),"symbol-spacing":new Ga(It.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Ga(It.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Za(It.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Ga(It.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Ga(It.layout_symbol["icon-allow-overlap"]),"icon-overlap":new Ga(It.layout_symbol["icon-overlap"]),"icon-ignore-placement":new Ga(It.layout_symbol["icon-ignore-placement"]),"icon-optional":new Ga(It.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Ga(It.layout_symbol["icon-rotation-alignment"]),"icon-size":new Za(It.layout_symbol["icon-size"]),"icon-text-fit":new Ga(It.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Ga(It.layout_symbol["icon-text-fit-padding"]),"icon-image":new Za(It.layout_symbol["icon-image"]),"icon-rotate":new Za(It.layout_symbol["icon-rotate"]),"icon-padding":new Za(It.layout_symbol["icon-padding"]),"icon-keep-upright":new Ga(It.layout_symbol["icon-keep-upright"]),"icon-offset":new Za(It.layout_symbol["icon-offset"]),"icon-anchor":new Za(It.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Ga(It.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Ga(It.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Ga(It.layout_symbol["text-rotation-alignment"]),"text-field":new Za(It.layout_symbol["text-field"]),"text-font":new Za(It.layout_symbol["text-font"]),"text-size":new Za(It.layout_symbol["text-size"]),"text-max-width":new Za(It.layout_symbol["text-max-width"]),"text-line-height":new Ga(It.layout_symbol["text-line-height"]),"text-letter-spacing":new Za(It.layout_symbol["text-letter-spacing"]),"text-justify":new Za(It.layout_symbol["text-justify"]),"text-radial-offset":new Za(It.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Ga(It.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new Za(It.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new Za(It.layout_symbol["text-anchor"]),"text-max-angle":new Ga(It.layout_symbol["text-max-angle"]),"text-writing-mode":new Ga(It.layout_symbol["text-writing-mode"]),"text-rotate":new Za(It.layout_symbol["text-rotate"]),"text-padding":new Ga(It.layout_symbol["text-padding"]),"text-keep-upright":new Ga(It.layout_symbol["text-keep-upright"]),"text-transform":new Za(It.layout_symbol["text-transform"]),"text-offset":new Za(It.layout_symbol["text-offset"]),"text-allow-overlap":new Ga(It.layout_symbol["text-allow-overlap"]),"text-overlap":new Ga(It.layout_symbol["text-overlap"]),"text-ignore-placement":new Ga(It.layout_symbol["text-ignore-placement"]),"text-optional":new Ga(It.layout_symbol["text-optional"])})}};class od{constructor(e){if(void 0===e.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=e.property.overrides?e.property.overrides.runtimeType:Gt,this.defaultValue=e}evaluate(e){if(e.formattedSection){const t=this.defaultValue.property.overrides;if(t&&t.hasOverride(e.formattedSection))return t.getOverride(e.formattedSection)}return e.feature&&e.featureState?this.defaultValue.evaluate(e.feature,e.featureState):this.defaultValue.property.specification.default}eachChild(e){this.defaultValue.isConstant()||e(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}ya("FormatSectionOverride",od,{omit:["defaultValue"]});class ld extends Xa{constructor(e,t){super(e,ad,t)}recalculate(e,t){if(super.recalculate(e,t),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const e=this.layout.get("text-writing-mode");if(e){const t=[];for(const i of e)t.indexOf(i)<0&&t.push(i);this.layout._values["text-writing-mode"]=t}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(e,t,i,r){const n=this.layout.get(e).evaluate(t,{},i,r),s=this._unevaluatedLayout._values[e];return s.isDataDriven()||hs(s.value)||!n?n:function(e,t){return t.replace(/{([^{}]+)}/g,((t,i)=>e&&i in e?String(e[i]):""))}(t.properties,n)}createBucket(e){return new rd(e)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const e of ad.paint.overridableProperties){if(!ld.hasPaintOverride(this.layout,e))continue;const t=this.paint.get(e),i=new od(t),r=new cs(i,t.property.specification);let n=null;n="constant"===t.value.kind||"source"===t.value.kind?new ds("source",r):new ps("composite",r,t.value.zoomStops),this.paint._values[e]=new Na(t.property,n,t.parameters)}}_handleOverridablePaintPropertyUpdate(e,t,i){return!(!this.layout||t.isDataDriven()||i.isDataDriven())&&ld.hasPaintOverride(this.layout,e)}static hasPaintOverride(e,t){const i=e.get("text-field"),r=ad.paint.properties[t];let n=!1;const s=e=>{for(const t of e)if(r.overrides&&r.overrides.hasOverride(t))return void(n=!0)};if("constant"===i.value.kind&&i.value.value instanceof Vi)s(i.value.value.sections);else if("source"===i.value.kind||"composite"===i.value.kind){const e=t=>{n||(t instanceof Ji&&Yi(t.value)===Jt?s(t.value.sections):t instanceof Fr?s(t.sections):t.eachChild(e))},t=i.value;t._styleExpression&&e(t._styleExpression.expression)}return n}}let cd;var hd={get paint(){return cd=cd||new Ha({"background-color":new Ga(It.paint_background["background-color"]),"background-pattern":new qa(It.paint_background["background-pattern"]),"background-opacity":new Ga(It.paint_background["background-opacity"])})}};class ud extends Xa{constructor(e,t){super(e,hd,t)}}class dd extends Xa{constructor(e,t){super(e,{},t),this.onAdd=e=>{this.implementation.onAdd&&this.implementation.onAdd(e,e.painter.context.gl)},this.onRemove=e=>{this.implementation.onRemove&&this.implementation.onRemove(e,e.painter.context.gl)},this.implementation=e}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function pd(e,t){if("custom"===e.type)return new dd(e,t);switch(e.type){case"background":return new ud(e,t);case"circle":return new Ic(e,t);case"color-relief":return new $c(e,t);case"fill":return new Lh(e,t);case"fill-extrusion":return new tu(e,t);case"heatmap":return new Bc(e,t);case"hillshade":return new jc(e,t);case"line":return new _u(e,t);case"raster":return new Qa(e,t);case"symbol":return new ld(e,t)}}function fd(e){const t=[];if("string"==typeof e)t.push({id:"default",url:e});else if(e&&e.length>0){const i=[];for(const{id:r,url:n}of e){const e=`${r}${n}`;-1===i.indexOf(e)&&(i.push(e),t.push({id:r,url:n}))}}return t}function md(e,t,i){try{const r=new URL(e);return r.pathname+=`${t}${i}`,r.toString()}catch(t){throw new Error(`Invalid sprite URL "${e}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}function _d(e){const{userImage:t}=e;return!!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class gd extends Pt{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new kc({width:1,height:1}),this.dirty=!0}destroy(){this.atlasTexture&&(this.atlasTexture.destroy(),this.atlasTexture=null);for(const e of Object.keys(this.images))this.removeImage(e);this.patterns={},this.atlasImage=new kc({width:1,height:1}),this.dirty=!0}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,promiseResolve:t}of this.requestors)t(this._getImagesForIds(e));this.requestors=[]}}getImage(e){const t=this.images[e];if(t&&!t.data&&t.spriteData){const e=t.spriteData;t.data=new kc({width:e.width,height:e.height},e.context.getImageData(e.x,e.y,e.width,e.height).data),t.spriteData=null}return t}addImage(e,t){if(this.images[e])throw new Error(`Image id ${e} already exist, use updateImage instead`);this._validate(e,t)&&(this.images[e]=t)}_validate(e,t){let i=!0;const r=t.data||t.spriteData;return this._validateStretch(t.stretchX,r&&r.width)||(this.fire(new St(new Error(`Image "${e}" has invalid "stretchX" value`))),i=!1),this._validateStretch(t.stretchY,r&&r.height)||(this.fire(new St(new Error(`Image "${e}" has invalid "stretchY" value`))),i=!1),this._validateContent(t.content,t)||(this.fire(new St(new Error(`Image "${e}" has invalid "content" value`))),i=!1),i}_validateStretch(e,t){if(!e)return!0;let i=0;for(const r of e){if(r[0]<i||r[1]<r[0]||t<r[1])return!1;i=r[1]}return!0}_validateContent(e,t){if(!e)return!0;if(4!==e.length)return!1;const i=t.spriteData,r=i&&i.width||t.data.width,n=i&&i.height||t.data.height;return!(e[0]<0||r<e[0]||e[1]<0||n<e[1]||e[2]<0||r<e[2]||e[3]<0||n<e[3]||e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i=!0){const r=this.getImage(e);if(i&&(r.data.width!==t.data.width||r.data.height!==t.data.height))throw new Error(`size mismatch between old image (${r.data.width}x${r.data.height}) and new image (${t.data.width}x${t.data.height}).`);t.version=r.version+1,this.images[e]=t,this.updatedImages[e]=!0}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove()}listImages(){return Object.keys(this.images)}getImages(e){return new Promise(((t,i)=>{let r=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(r=!1);this.isLoaded()||r?t(this._getImagesForIds(e)):this.requestors.push({ids:e,promiseResolve:t})}))}_getImagesForIds(e){const t={};for(const i of e){let e=this.getImage(i);e||(this.fire(new Tt("styleimagemissing",{id:i})),e=this.getImage(i)),e?t[i]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,textFitWidth:e.textFitWidth,textFitHeight:e.textFitHeight,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:Re(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`)}return t}getPixelSize(){const{width:e,height:t}=this.atlasImage;return{width:e,height:t}}getPattern(e){const t=this.patterns[e],i=this.getImage(e);if(!i)return null;if(t&&t.position.version===i.version)return t.position;if(t)t.position.version=i.version;else{const t={w:i.data.width+2,h:i.data.height+2,x:0,y:0},r=new Zu(t,i);this.patterns[e]={bin:t,position:r}}return this._updatePatternAtlas(),this.patterns[e].position}bind(e){const t=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new Gc(e,this.atlasImage,t.RGBA),this.atlasTexture.bind(t.LINEAR,t.CLAMP_TO_EDGE)}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:t,h:i}=Gu(e),r=this.atlasImage;r.resize({width:t||1,height:i||1});for(const e in this.patterns){const{bin:t}=this.patterns[e],i=t.x+1,n=t.y+1,s=this.getImage(e).data,a=s.width,o=s.height;kc.copy(s,r,{x:0,y:0},{x:i,y:n},{width:a,height:o}),kc.copy(s,r,{x:0,y:o-1},{x:i,y:n-1},{width:a,height:1}),kc.copy(s,r,{x:0,y:0},{x:i,y:n+o},{width:a,height:1}),kc.copy(s,r,{x:a-1,y:0},{x:i-1,y:n},{width:1,height:o}),kc.copy(s,r,{x:0,y:0},{x:i+a,y:n},{width:1,height:o})}this.dirty=!0}beginFrame(){this.callbackDispatchedThisFrame={}}dispatchRenderCallbacks(e){for(const t of e){if(this.callbackDispatchedThisFrame[t])continue;this.callbackDispatchedThisFrame[t]=!0;const e=this.getImage(t);e||Re(`Image with ID: "${t}" was not found`),_d(e)&&this.updateImage(t,e)}}cloneImages(){const e={};for(const t in this.images){const i=this.images[t];e[t]=Object.assign(Object.assign({},i),{data:i.data?i.data.clone():null})}return e}}const yd=1e20;function xd(e,t,i,r,n,s,a,o,l){for(let c=t;c<t+r;c++)vd(e,i*s+c,s,n,a,o,l);for(let c=i;c<i+n;c++)vd(e,c*s+t,1,r,a,o,l)}function vd(e,t,i,r,n,s,a){s[0]=0,a[0]=-yd,a[1]=yd,n[0]=e[t];for(let o=1,l=0,c=0;o<r;o++){n[o]=e[t+o*i];const r=o*o;do{const e=s[l];c=(n[o]-n[e]+r-e*e)/(o-e)/2}while(c<=a[l]&&--l>-1);l++,s[l]=o,a[l]=c,a[l+1]=yd}for(let o=0,l=0;o<r;o++){for(;a[l+1]<o;)l++;const r=s[l],c=o-r;e[t+o*i]=n[r]+c*c}}const bd=ca.layout_symbol["text-font"].default.join(",");class wd{constructor(e,t,i){this.requestManager=e,this.localIdeographFontFamily=t,this.entries={},this.lang=i}setURL(e){this.url=e}getGlyphs(e){return n(this,void 0,void 0,(function*(){const t=[];for(const i in e)for(const r of e[i])t.push(this._getAndCacheGlyphsPromise(i,r));const i=yield Promise.all(t),r={};for(const{stack:e,id:t,glyph:n}of i)r[e]||(r[e]={}),r[e][t]=n&&{id:n.id,bitmap:n.bitmap.clone(),metrics:n.metrics};return r}))}_getAndCacheGlyphsPromise(e,t){return n(this,void 0,void 0,(function*(){let i=this.entries[e];i||(i=this.entries[e]={glyphs:{},requests:{},ranges:{}});let r=i.glyphs[t];return void 0!==r?{stack:e,id:t,glyph:r}:!this.url||this._charUsesLocalIdeographFontFamily(t)?(r=i.glyphs[t]=this._drawGlyph(i,e,t),{stack:e,id:t,glyph:r}):yield this._downloadAndCacheRangePromise(e,t)}))}_downloadAndCacheRangePromise(e,t){return n(this,void 0,void 0,(function*(){const i=this.entries[e],r=Math.floor(t/256);if(i.ranges[r])return{stack:e,id:t,glyph:null};if(!i.requests[r]){const t=wd.loadGlyphRange(e,r,this.url,this.requestManager);i.requests[r]=t}try{const n=yield i.requests[r];for(const e in n)i.glyphs[+e]=n[+e];return i.ranges[r]=!0,{stack:e,id:t,glyph:n[t]||null}}catch(n){const s=i.glyphs[t]=this._drawGlyph(i,e,t);return this._warnOnMissingGlyphRange(s,r,t,n),{stack:e,id:t,glyph:s}}}))}_warnOnMissingGlyphRange(e,t,i,r){const n=256*t;Re(`Unable to load glyph range ${t}, ${n}-${n+255}. Rendering codepoint U+${i.toString(16).padStart(4,"0").toUpperCase()} locally instead. ${r}`)}_charUsesLocalIdeographFontFamily(e){return!!this.localIdeographFontFamily&&/[\u02EA\u02EB\u1100-\u11FF\u2E80-\u2FDF\u3000-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE4F\uFF00-\uFFEF]|\uD81B[\uDFE0-\uDFFF]|[\uD81C-\uD822\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFFF]|\uD82C[\uDC00-\uDEFB]|\uD83C[\uDE00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(e))}_drawGlyph(e,t,i){const r=t===bd&&""!==this.localIdeographFontFamily&&this._charUsesLocalIdeographFontFamily(i),n=r?"ideographTinySDF":"tinySDF";e[n]||(e[n]=this._createTinySDF(r?this.localIdeographFontFamily:t));const s=e[n].draw(String.fromCodePoint(i)),a=/^\p{gc=Cf}+$/u.test(String.fromCodePoint(i));return{id:i,bitmap:new Rc({width:s.width||60,height:s.height||60},s.data),metrics:{width:a?0:s.glyphWidth/2||24,height:s.glyphHeight/2||24,left:s.glyphLeft/2+.5||0,top:s.glyphTop/2-27.5||-8,advance:a?0:s.glyphAdvance/2||24,isDoubleResolution:!0}}}_createTinySDF(e){const t=e?e.split(","):[];t.push("sans-serif");const i=t.map((e=>/[-\w]+/.test(e)?e:`'${CSS.escape(e)}'`)).join(",");return new wd.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:i,fontWeight:this._fontWeight(t[0]),fontStyle:this._fontStyle(t[0]),lang:this.lang})}_fontStyle(e){return/italic/i.test(e)?"italic":/oblique/i.test(e)?"oblique":"normal"}_fontWeight(e){const t={thin:100,hairline:100,"extra light":200,"ultra light":200,light:300,normal:400,regular:400,medium:500,semibold:600,demibold:600,bold:700,"extra bold":800,"ultra bold":800,black:900,heavy:900,"extra black":950,"ultra black":950};let i;for(const[r,n]of Object.entries(t))new RegExp(`\\b${r}\\b`,"i").test(e)&&(i=`${n}`);return i}destroy(){for(const e in this.entries){const t=this.entries[e];t.tinySDF&&(t.tinySDF=null),t.ideographTinySDF&&(t.ideographTinySDF=null),t.glyphs={},t.requests={},t.ranges={}}this.entries={}}}wd.loadGlyphRange=function(e,t,i,r){return n(this,void 0,void 0,(function*(){const n=256*t,s=n+255,a=r.transformRequest(i.replace("{fontstack}",e).replace("{range}",`${n}-${s}`),"Glyphs"),o=yield(l=a,c=new AbortController,ht(we(l,{type:"arrayBuffer"}),c));var l,c;if(!o||!o.data)throw new Error(`Could not load glyph range. range: ${t}, ${n}-${s}`);const h={};for(const e of new Eu(o.data).readFields(ju,[]))h[e.id]=e;return h}))},wd.TinySDF=class{constructor({fontSize:e=24,buffer:t=3,radius:i=8,cutoff:r=.25,fontFamily:n="sans-serif",fontWeight:s="normal",fontStyle:a="normal",lang:o=null}={}){this.buffer=t,this.cutoff=r,this.radius=i,this.lang=o;const l=this.size=e+4*t,c=this._createCanvas(l),h=this.ctx=c.getContext("2d",{willReadFrequently:!0});h.font=`${a} ${s} ${e}px ${n}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(l*l),this.gridInner=new Float64Array(l*l),this.f=new Float64Array(l),this.z=new Float64Array(l+1),this.v=new Uint16Array(l)}_createCanvas(e){const t=document.createElement("canvas");return t.width=t.height=e,t}draw(e){const{width:t,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:n,actualBoundingBoxRight:s}=this.ctx.measureText(e),a=Math.ceil(i),o=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-n))),l=Math.min(this.size-this.buffer,a+Math.ceil(r)),c=o+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),d=new Uint8ClampedArray(u),p={data:d,width:c,height:h,glyphWidth:o,glyphHeight:l,glyphTop:a,glyphLeft:0,glyphAdvance:t};if(0===o||0===l)return p;const{ctx:f,buffer:m,gridInner:_,gridOuter:g}=this;this.lang&&(f.lang=this.lang),f.clearRect(m,m,o,l),f.fillText(e,m,m+a);const y=f.getImageData(m,m,o,l);g.fill(yd,0,u),_.fill(0,0,u);for(let e=0;e<l;e++)for(let t=0;t<o;t++){const i=y.data[4*(e*o+t)+3]/255;if(0===i)continue;const r=(e+m)*c+t+m;if(1===i)g[r]=0,_[r]=yd;else{const e=.5-i;g[r]=e>0?e*e:0,_[r]=e<0?e*e:0}}xd(g,0,0,c,h,c,this.f,this.v,this.z),xd(_,m,m,o,l,c,this.f,this.v,this.z);for(let e=0;e<u;e++){const t=Math.sqrt(g[e])-Math.sqrt(_[e]);d[e]=Math.round(255-255*(t/this.radius+this.cutoff))}return p}};class Td{constructor(){this.specification=It.light.position}possiblyEvaluate(e,t){return function([e,t,i]){return t+=90,t*=Math.PI/180,i*=Math.PI/180,{x:e*Math.cos(t)*Math.sin(i),y:e*Math.sin(t)*Math.sin(i),z:e*Math.cos(i)}}(e.expression.evaluate(t))}interpolate(e,t,i){return{x:Tr.number(e.x,t.x,i),y:Tr.number(e.y,t.y,i),z:Tr.number(e.z,t.z,i)}}}let Sd;class Pd extends Pt{constructor(e){super(),Sd=Sd||new Ha({anchor:new Ga(It.light.anchor),position:new Td,color:new Ga(It.light.color),intensity:new Ga(It.light.intensity)}),this._transitionable=new Ba(Sd,void 0),this.setLight(e),this._transitioning=this._transitionable.untransitioned()}getLight(){return this._transitionable.serialize()}setLight(e,t={}){if(!this._validate(ua,e,t))for(const t in e){const i=e[t];t.endsWith(ka)?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i)}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}_validate(e,t,i){return(!i||!1!==i.validate)&&ma(this,e.call(ha,{value:t,style:{glyphs:!0,sprite:!0},styleSpec:It}))}}const Id=new Ha({"sky-color":new Ga(It.sky["sky-color"]),"horizon-color":new Ga(It.sky["horizon-color"]),"fog-color":new Ga(It.sky["fog-color"]),"fog-ground-blend":new Ga(It.sky["fog-ground-blend"]),"horizon-fog-blend":new Ga(It.sky["horizon-fog-blend"]),"sky-horizon-blend":new Ga(It.sky["sky-horizon-blend"]),"atmosphere-blend":new Ga(It.sky["atmosphere-blend"])});class Md extends Pt{constructor(e){super(),this._transitionable=new Ba(Id,void 0),this.setSky(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new Da(0))}setSky(e,t={}){if(!this._validate(da,e,t)){e||(e={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const t in e){const i=e[t];t.endsWith(ka)?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i)}}}getSky(){return this._transitionable.serialize()}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}_validate(e,t,i={}){return!1!==(null==i?void 0:i.validate)&&ma(this,e.call(ha,we({value:t,style:{glyphs:!0,sprite:!0},styleSpec:It})))}calculateFogBlendOpacity(e){return e<60?0:e<70?(e-60)/10:1}}class Ed{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={}}getDash(e,t){const i=e.join(",")+String(t);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(e,t)),this.dashEntry[i]}getDashRanges(e,t,i){const r=[];let n=e.length%2==1?-e[e.length-1]*i:0,s=e[0]*i,a=!0;r.push({left:n,right:s,isDash:a,zeroLength:0===e[0]});let o=e[0];for(let t=1;t<e.length;t++){a=!a;const l=e[t];n=o*i,o+=l,s=o*i,r.push({left:n,right:s,isDash:a,zeroLength:0===l})}return r}addRoundDash(e,t,i){const r=t/2;for(let t=-i;t<=i;t++){const n=this.width*(this.nextRow+i+t);let s=0,a=e[s];for(let o=0;o<this.width;o++){o/a.right>1&&(a=e[++s]);const l=Math.abs(o-a.left),c=Math.abs(o-a.right),h=Math.min(l,c);let u;const d=t/i*(r+1);if(a.isDash){const e=r-Math.abs(d);u=Math.sqrt(h*h+e*e)}else u=r-Math.sqrt(h*h+d*d);this.data[n+o]=Math.max(0,Math.min(255,u+128))}}}addRegularDash(e){for(let t=e.length-1;t>=0;--t){const i=e[t],r=e[t+1];i.zeroLength?e.splice(t,1):r&&r.isDash===i.isDash&&(r.left=i.left,e.splice(t,1))}const t=e[0],i=e[e.length-1];t.isDash===i.isDash&&(t.left=i.left-this.width,i.right=t.right+this.width);const r=this.width*this.nextRow;let n=0,s=e[n];for(let t=0;t<this.width;t++){t/s.right>1&&(s=e[++n]);const i=Math.abs(t-s.left),a=Math.abs(t-s.right),o=Math.min(i,a);this.data[r+t]=Math.max(0,Math.min(255,(s.isDash?o:-o)+128))}}addDash(e,t){const i=t?7:0,r=2*i+1;if(this.nextRow+r>this.height)return Re("LineAtlas out of space"),null;let n=0;for(let t=0;t<e.length;t++)n+=e[t];if(0!==n){const r=this.width/n,s=this.getDashRanges(e,this.width,r);t?this.addRoundDash(s,r,i):this.addRegularDash(s)}const s={y:this.nextRow+i,height:2*i,width:n};return this.nextRow+=r,this.dirty=!0,s}bind(e){const t=e.gl;this.texture?(t.bindTexture(t.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,t.texSubImage2D(t.TEXTURE_2D,0,0,0,this.width,this.height,t.ALPHA,t.UNSIGNED_BYTE,this.data))):(this.texture=t.createTexture(),t.bindTexture(t.TEXTURE_2D,this.texture),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texImage2D(t.TEXTURE_2D,0,t.ALPHA,this.width,this.height,0,t.ALPHA,t.UNSIGNED_BYTE,this.data))}}class Cd{constructor(e){this._methodToThrottle=e,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const Ad={once:!0};class zd{constructor(e,t){this.target=e,this.mapId=t,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new Cd((()=>this.process())),this.subscription=Ve(this.target,"message",(e=>this.receive(e)),!1),this.globalScope=Le(self)?e:window}registerMessageHandler(e,t){this.messageHandlers[e]=t}unregisterMessageHandler(e){delete this.messageHandlers[e]}sendAsync(e,t){return new Promise(((i,r)=>{const n=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=t?Ve(t.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[n];const t={id:n,type:"<cancel>",origin:location.origin,targetMapId:e.targetMapId,sourceMapId:this.mapId};this.target.postMessage(t)}),Ad):null;this.resolveRejects[n]={resolve:e=>{null==s||s.unsubscribe(),i(e)},reject:e=>{null==s||s.unsubscribe(),r(e)}};const a=[],o=Object.assign(Object.assign({},e),{id:n,sourceMapId:this.mapId,origin:location.origin,data:wa(e.data,a)});this.target.postMessage(o,{transfer:a})}))}receive(e){const t=e.data,i=t.id;if(!("file://"!==t.origin&&"file://"!==location.origin&&"resource://android"!==t.origin&&"resource://android"!==location.origin&&t.origin!==location.origin||t.targetMapId&&this.mapId!==t.targetMapId)){if("<cancel>"===t.type){delete this.tasks[i];const e=this.abortControllers[i];return delete this.abortControllers[i],void(e&&e.abort())}if(Le(self)||t.mustQueue)return this.tasks[i]=t,this.taskQueue.push(i),void this.invoker.trigger();this.processTask(i,t)}}process(){if(0===this.taskQueue.length)return;const e=this.taskQueue.shift(),t=this.tasks[e];delete this.tasks[e],this.taskQueue.length>0&&this.invoker.trigger(),t&&this.processTask(e,t)}processTask(e,t){return n(this,void 0,void 0,(function*(){if("<response>"===t.type){const i=this.resolveRejects[e];if(delete this.resolveRejects[e],!i)return;return void(t.error?i.reject(Ta(t.error)):i.resolve(Ta(t.data)))}if(!this.messageHandlers[t.type])return void this.completeTask(e,new Error(`Could not find a registered handler for ${t.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const i=Ta(t.data),r=new AbortController;this.abortControllers[e]=r;try{const n=yield this.messageHandlers[t.type](t.sourceMapId,i,r);this.completeTask(e,null,n)}catch(t){this.completeTask(e,t)}}))}completeTask(e,t,i){const r=[];delete this.abortControllers[e];const n={id:e,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:t?wa(t):null,data:wa(i,r)};this.target.postMessage(n,{transfer:r})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}const Dd="maplibre_preloaded_worker_pool";class Rd{constructor(){this.active={}}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<Rd.workerCount;)this.workers.push(new Worker(st.WORKER_URL));return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach((e=>{e.terminate()})),this.workers=null)}isPreloaded(){return!!this.active[Dd]}numActive(){return Object.keys(this.active).length}}const kd=Math.floor(tt.hardwareConcurrency/2);let Ld,Fd;function Bd(){return Ld||(Ld=new Rd),Ld}Rd.workerCount=function(e){if(null==Fe){const t=e.navigator?e.navigator.userAgent:null;Fe=!!e.safari||!(!t||!(/\b(iPad|iPhone|iPod)\b/.test(t)||t.match("Safari")&&!t.match("Chrome")))}return Fe}(globalThis)?Math.max(Math.min(kd,3),1):1;class Od{constructor(e,t){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=t;const i=this.workerPool.acquire(t);for(let e=0;e<i.length;e++){const r=new zd(i[e],t);r.name=`Worker ${e}`,this.actors.push(r)}if(!this.actors.length)throw new Error("No actors found")}broadcast(e,t){const i=[];for(const r of this.actors)i.push(r.sendAsync({type:e,data:t}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(e=!0){this.actors.forEach((e=>{e.remove()})),this.actors=[],e&&this.workerPool.release(this.id)}registerMessageHandler(e,t){for(const i of this.actors)i.registerMessageHandler(e,t)}unregisterMessageHandler(e){for(const t of this.actors)t.unregisterMessageHandler(e)}}function Vd(){return Fd||(Fd=new Od(Bd(),ot),Fd.registerMessageHandler("GR",((e,t,i)=>ht(t,i)))),Fd}function jd(e,t){const i=_();return b(i,i,[1,1,0]),w(i,i,[.5*e.width,.5*e.height,1]),e.calculatePosMatrix?v(i,i,e.calculatePosMatrix(t.toUnwrapped())):i}function Nd(e,t,i,r,n,s,a){var o;const l=function(e,t,i){if(e)for(const r of e){const e=t[r];if(e&&e.source===i&&"fill-extrusion"===e.type)return!0}else for(const e in t){const r=t[e];if(r.source===i&&"fill-extrusion"===r.type)return!0}return!1}(null!==(o=null==n?void 0:n.layers)&&void 0!==o?o:null,t,e.id),c=s.maxPitchScaleFactor(),h=e.tilesIn(r,c,l);h.sort(Ud);const u=[];for(const r of h)u.push({wrappedTileID:r.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(t,i,e.getState(),r.queryGeometry,r.cameraQueryGeometry,r.scale,n,s,c,jd(s,r.tileID),a?(e,t)=>a(r.tileID,e,t):void 0)});return function(e,t){for(const i in e)for(const r of e[i])Gd(r,t);return e}(function(e){const t={},i={};for(const r of e){const e=r.queryResults,n=r.wrappedTileID,s=i[n]=i[n]||{};for(const i in e){const r=e[i],n=s[i]=s[i]||{},a=t[i]=t[i]||[];for(const e of r)n[e.featureIndex]||(n[e.featureIndex]=!0,a.push(e))}}return t}(u),e)}function Ud(e,t){const i=e.tileID,r=t.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}function Gd(e,t){const i=e.feature,r=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=r}function Zd(e,t,i){return n(this,void 0,void 0,(function*(){let r=e;if(e.url?r=(yield ut(t.transformRequest(e.url,"Source"),i)).data:yield tt.frameAsync(i),!r)return null;const n=Te(we(r,e),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return"vector_layers"in r&&r.vector_layers&&(n.vectorLayerIds=r.vector_layers.map((e=>e.id))),n}))}const $d=6371008.8;class qd{constructor(e,t){if(isNaN(e)||isNaN(t))throw new Error(`Invalid LngLat object: (${e}, ${t})`);if(this.lng=+e,this.lat=+t,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new qd(be(this.lng,-180,180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(e){const t=Math.PI/180,i=this.lat*t,r=e.lat*t,n=Math.sin(i)*Math.sin(r)+Math.cos(i)*Math.cos(r)*Math.cos((e.lng-this.lng)*t);return $d*Math.acos(Math.min(n,1))}static convert(e){if(e instanceof qd)return e;if(Array.isArray(e)&&(2===e.length||3===e.length))return new qd(Number(e[0]),Number(e[1]));if(!Array.isArray(e)&&"object"==typeof e&&null!==e)return new qd(Number("lng"in e?e.lng:e.lon),Number(e.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class Wd{constructor(e,t){e&&(t?this.setSouthWest(e).setNorthEast(t):Array.isArray(e)&&(4===e.length?this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]):this.setSouthWest(e[0]).setNorthEast(e[1])))}setNorthEast(e){return this._ne=e instanceof qd?new qd(e.lng,e.lat):qd.convert(e),this}setSouthWest(e){return this._sw=e instanceof qd?new qd(e.lng,e.lat):qd.convert(e),this}extend(e){const t=this._sw,i=this._ne;let r,n;if(e instanceof qd)r=e,n=e;else{if(!(e instanceof Wd))return Array.isArray(e)?4===e.length||e.every(Array.isArray)?this.extend(Wd.convert(e)):this.extend(qd.convert(e)):e&&("lng"in e||"lon"in e)&&"lat"in e?this.extend(qd.convert(e)):this;if(r=e._sw,n=e._ne,!r||!n)return this}return t||i?(t.lng=Math.min(r.lng,t.lng),t.lat=Math.min(r.lat,t.lat),i.lng=Math.max(n.lng,i.lng),i.lat=Math.max(n.lat,i.lat)):(this._sw=new qd(r.lng,r.lat),this._ne=new qd(n.lng,n.lat)),this}getCenter(){return new qd((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new qd(this.getWest(),this.getNorth())}getSouthEast(){return new qd(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return[this._sw.toArray(),this._ne.toArray()]}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return!(this._sw&&this._ne)}contains(e){const{lng:t,lat:i}=qd.convert(e);let r=this._sw.lng<=t&&t<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=t&&t>=this._ne.lng),this._sw.lat<=i&&i<=this._ne.lat&&r}intersects(e){if(!((e=Wd.convert(e)).getNorth()>=this.getSouth()&&e.getSouth()<=this.getNorth()))return!1;const t=Math.abs(this.getEast()-this.getWest()),i=Math.abs(e.getEast()-e.getWest());if(t>=360||i>=360)return!0;const r=be(this.getWest(),-180,180),n=be(this.getEast(),-180,180),s=be(e.getWest(),-180,180),a=be(e.getEast(),-180,180),o=r>=n,l=s>=a;return!(!o||!l)||(o?a>=r||s<=n:l?n>=s||r<=a:s<=n&&a>=r)}static convert(e){return e instanceof Wd?e:e?new Wd(e):e}static fromLngLat(e,t=0){const i=360*t/40075017,r=i/Math.cos(Math.PI/180*e.lat);return new Wd(new qd(e.lng-r,e.lat-i),new qd(e.lng+r,e.lat+i))}adjustAntiMeridian(){const e=new qd(this._sw.lng,this._sw.lat),t=new qd(this._ne.lng,this._ne.lat);return new Wd(e,e.lng>t.lng?new qd(t.lng+360,t.lat):t)}}const Hd=2*Math.PI*$d;function Xd(e){return Hd*Math.cos(e*Math.PI/180)}function Yd(e){return(180+e)/360}function Kd(e){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e*Math.PI/360)))/360}function Jd(e,t){return e/Xd(t)}function Qd(e){return 360*e-180}function ep(e){return 360/Math.PI*Math.atan(Math.exp((180-360*e)*Math.PI/180))-90}function tp(e,t){return e*Xd(ep(t))}class ip{constructor(e,t,i=0){this.x=+e,this.y=+t,this.z=+i}static fromLngLat(e,t=0){const i=qd.convert(e);return new ip(Yd(i.lng),Kd(i.lat),Jd(t,i.lat))}toLngLat(){return new qd(Qd(this.x),ep(this.y))}toAltitude(){return tp(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Hd*(e=ep(this.y),1/Math.cos(e*Math.PI/180));var e}}class rp{constructor(e,t,i){this.bounds=Wd.convert(this.validateBounds(e)),this.minzoom=t||0,this.maxzoom=i||24}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(e){const t=Math.pow(2,e.z),i=Math.floor(Yd(this.bounds.getWest())*t),r=Math.floor(Kd(this.bounds.getNorth())*t),n=Math.ceil(Yd(this.bounds.getEast())*t),s=Math.ceil(Kd(this.bounds.getSouth())*t);return e.x>=i&&e.x<n&&e.y>=r&&e.y<s}}class np extends Pt{constructor(e,t,i,r){if(super(),this.id=e,this.dispatcher=i,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,we(this,Te(t,["url","scheme","tileSize","promoteId","encoding"])),this._options=we({type:"vector"},t),this._collectResourceTiming=t.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r)}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new Tt("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield Zd(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.tileManagers[this.id].clearTiles(),e&&(we(this,e),e.bounds&&(this.tileBounds=new rp(e.bounds,this.minzoom,this.maxzoom)),this.fire(new Tt("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Tt("data",{dataType:"source",sourceDataType:"content"})))}catch(e){this._tileJSONRequest=null,this._loaded=!0,Ke(e)||this.fire(new St(e))}}))}loaded(){return this._loaded}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load()}setSourceProperty(e){this._tileJSONRequest&&this._tileJSONRequest.abort(),e(),this.load()}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}serialize(){return we({},this._options)}loadTile(e){return n(this,void 0,void 0,(function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(t,"Tile"),uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity,encoding:this.encoding,overzoomParameters:this._getOverzoomParameters(e)};i.request.collectResourceTiming=this._collectResourceTiming;let r="RT";if(e.actor&&"expired"!==e.state){if("loading"===e.state)return new Promise(((t,i)=>{e.reloadPromise={resolve:t,reject:i}}))}else e.actor=this.dispatcher.getActor(),r="LT";e.abortController=new AbortController;try{const t=yield e.actor.sendAsync({type:r,data:i},e.abortController);if(delete e.abortController,e.aborted)return;this._afterTileLoadWorkerResponse(e,t)}catch(t){if(delete e.abortController,e.aborted)return;if(t&&404!==t.status)throw t;this._afterTileLoadWorkerResponse(e,null)}}))}_getOverzoomParameters(e){if(e.tileID.canonical.z<=this.maxzoom)return;if(void 0===this.map._zoomLevelsToOverscale)return;const t=e.tileID.scaledTo(this.maxzoom).canonical,i=t.url(this.tiles,this.map.getPixelRatio(),this.scheme);return{maxZoomTileID:t,overzoomRequest:this.map._requestManager.transformRequest(i,"Tile")}}_afterTileLoadWorkerResponse(e,t){if(t&&t.resourceTiming&&(e.resourceTiming=t.resourceTiming),t&&this.map._refreshExpiredTiles&&e.setExpiryData(t),e.loadVectorData(t,this.map.painter),e.reloadPromise){const t=e.reloadPromise;e.reloadPromise=null,this.loadTile(e).then(t.resolve).catch(t.reject)}}abortTile(e){return n(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.actor&&(yield e.actor.sendAsync({type:"AT",data:{uid:e.uid,type:this.type,source:this.id}}))}))}unloadTile(e){return n(this,void 0,void 0,(function*(){e.unloadVectorData(),e.actor&&(yield e.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}}))}))}hasTransition(){return!1}}class sp extends Pt{constructor(e,t,i,r){super(),this.id=e,this.dispatcher=i,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=we({type:"raster"},t),we(this,Te(t,["url","scheme","tileSize"]))}load(){return n(this,arguments,void 0,(function*(e=!1){this._loaded=!1,this.fire(new Tt("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield Zd(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,t&&(we(this,t),t.bounds&&(this.tileBounds=new rp(t.bounds,this.minzoom,this.maxzoom)),this.fire(new Tt("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Tt("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:e})))}catch(e){this._tileJSONRequest=null,this._loaded=!0,Ke(e)||this.fire(new St(e))}}))}loaded(){return this._loaded}onAdd(e){this.map=e,this.load()}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}setSourceProperty(e){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),e(),this.load(!0)}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e})),this}serialize(){return we({},this._options)}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e){return n(this,void 0,void 0,(function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);e.abortController=new AbortController;try{const i=yield xt.getImage(this.map._requestManager.transformRequest(t,"Tile"),e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&(i.cacheControl||i.expires)&&e.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const t=this.map.painter.context,r=t.gl,n=i.data;e.texture=this.map.painter.getTileTexture(n.width),e.texture?e.texture.update(n,{useMipmap:!0}):(e.texture=new Gc(t,n,r.RGBA,{useMipmap:!0}),e.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),e.state="loaded"}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}abortTile(e){return n(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController)}))}unloadTile(e){return n(this,void 0,void 0,(function*(){e.texture&&this.map.painter.saveTileTexture(e.texture)}))}hasTransition(){return!1}}function ap(e,t,i){var r=2*Math.PI*6378137/256/Math.pow(2,i);return[e*r-2*Math.PI*6378137/2,t*r-2*Math.PI*6378137/2]}function op(e,t){const{x:i,y:r}=ip.fromLngLat(t);return!(e<0||e>25||r<0||r>=1||i<0||i>=1)}class lp{constructor(e,t,i){if(!function(e,t,i){return!(e<0||e>25||i<0||i>=Math.pow(2,e)||t<0||t>=Math.pow(2,e))}(e,t,i))throw new Error(`x=${t}, y=${i}, z=${e} outside of bounds. 0<=x<${Math.pow(2,e)}, 0<=y<${Math.pow(2,e)} 0<=z<=25 `);this.z=e,this.x=t,this.y=i,this.key=up(0,e,e,t,i)}equals(e){return this.z===e.z&&this.x===e.x&&this.y===e.y}url(e,t,i){const r=(s=this.y,a=this.z,o=ap(256*(n=this.x),256*(s=Math.pow(2,a)-s-1),a),l=ap(256*(n+1),256*(s+1),a),o[0]+","+o[1]+","+l[0]+","+l[1]);var n,s,a,o,l;const c=function(e,t,i){let r,n="";for(let s=e;s>0;s--)r=1<<s-1,n+=(t&r?1:0)+(i&r?2:0);return n}(this.z,this.x,this.y);return e[(this.x+this.y)%e.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===i?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,t>1?"@2x":"").replace(/{quadkey}/g,c).replace(/{bbox-epsg-3857}/g,r)}isChildOf(e){const t=this.z-e.z;return t>0&&e.x===this.x>>t&&e.y===this.y>>t}getTilePoint(e){const t=Math.pow(2,this.z);return new s((e.x*t-this.x)*Q,(e.y*t-this.y)*Q)}toString(){return`${this.z}/${this.x}/${this.y}`}}class cp{constructor(e,t){this.wrap=e,this.canonical=t,this.key=up(e,t.z,t.z,t.x,t.y)}}class hp{constructor(e,t,i,r,n){if(this.terrainRttPosMatrix32f=null,e<i)throw new Error(`overscaledZ should be >= z; overscaledZ = ${e}; z = ${i}`);this.overscaledZ=e,this.wrap=t,this.canonical=new lp(i,+r,+n),this.key=up(t,e,i,r,n)}clone(){return new hp(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(e){return this.overscaledZ===e.overscaledZ&&this.wrap===e.wrap&&this.canonical.equals(e.canonical)}scaledTo(e){if(e>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${e}; overscaledZ = ${this.overscaledZ}`);const t=this.canonical.z-e;return e>this.canonical.z?new hp(e,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new hp(e,this.wrap,e,this.canonical.x>>t,this.canonical.y>>t)}isOverscaled(){return this.overscaledZ>this.canonical.z}calculateScaledKey(e,t){if(e>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${e}; overscaledZ = ${this.overscaledZ}`);const i=this.canonical.z-e;return e>this.canonical.z?up(this.wrap*+t,e,this.canonical.z,this.canonical.x,this.canonical.y):up(this.wrap*+t,e,e,this.canonical.x>>i,this.canonical.y>>i)}isChildOf(e){if(e.wrap!==this.wrap)return!1;if(this.overscaledZ-e.overscaledZ<=0)return!1;if(0===e.overscaledZ)return this.overscaledZ>0;const t=this.canonical.z-e.canonical.z;return!(t<0)&&e.canonical.x===this.canonical.x>>t&&e.canonical.y===this.canonical.y>>t}children(e){if(this.overscaledZ>=e)return[new hp(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const t=this.canonical.z+1,i=2*this.canonical.x,r=2*this.canonical.y;return[new hp(t,this.wrap,t,i,r),new hp(t,this.wrap,t,i+1,r),new hp(t,this.wrap,t,i,r+1),new hp(t,this.wrap,t,i+1,r+1)]}isLessThan(e){return this.wrap<e.wrap||!(this.wrap>e.wrap)&&(this.overscaledZ<e.overscaledZ||!(this.overscaledZ>e.overscaledZ)&&(this.canonical.x<e.canonical.x||!(this.canonical.x>e.canonical.x)&&this.canonical.y<e.canonical.y))}wrapped(){return new hp(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(e){return new hp(this.overscaledZ,e,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new cp(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(e){return this.canonical.getTilePoint(new ip(e.x-this.wrap,e.y))}}function up(e,t,i,r,n){(e*=2)<0&&(e=-1*e-1);const s=1<<i;return(s*s*e+s*n+r).toString(36)+i.toString(36)+t.toString(36)}function dp(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),r=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||r-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}ya("CanonicalTileID",lp),ya("OverscaledTileID",hp,{omit:["terrainRttPosMatrix32f"]});class pp extends sp{constructor(e,t,i,r){super(e,t,i,r),this.type="raster-dem",this.maxzoom=22,this._options=we({type:"raster-dem"},t),this.encoding=t.encoding||"mapbox",this.redFactor=t.redFactor,this.greenFactor=t.greenFactor,this.blueFactor=t.blueFactor,this.baseShift=t.baseShift}loadTile(e){return n(this,void 0,void 0,(function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i=this.map._requestManager.transformRequest(t,"Tile");e.neighboringTiles=this._getNeighboringTiles(e.tileID),e.abortController=new AbortController;try{const t=yield xt.getImage(i,e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(t&&t.data){const i=t.data;this.map._refreshExpiredTiles&&(t.cacheControl||t.expires)&&e.setExpiryData({cacheControl:t.cacheControl,expires:t.expires});const r=Be(i)&&u()?i:yield this.readImageNow(i),n={type:this.type,uid:e.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!e.actor||"expired"===e.state){e.actor=this.dispatcher.getActor();const t=yield e.actor.sendAsync({type:"LDT",data:n});e.dem=t,e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0,e.state="loaded"}}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}readImageNow(e){return n(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&function(){if(null==h&&(h=!1,u())){const e=5,t=new OffscreenCanvas(e,e).getContext("2d",{willReadFrequently:!0});if(t){for(let i=0;i<e*e;i++){const r=4*i;t.fillStyle=`rgb(${r},${r+1},${r+2})`,t.fillRect(i%e,Math.floor(i/e),1,1)}const i=t.getImageData(0,0,e,e).data;for(let t=0;t<e*e*4;t++)if(t%4!=3&&i[t]!==t){h=!0;break}}}return h||!1}()){const t=e.width+2,i=e.height+2;try{return new kc({width:t,height:i},yield function(e,t,i,r,s){return n(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const t=new VideoFrame(e,{timestamp:0});try{const i=null==t?void 0:t.format;if(!i||!i.startsWith("BGR")&&!i.startsWith("RGB"))throw new Error(`Unrecognized format ${i}`);const n=i.startsWith("BGR"),a=new Uint8ClampedArray(r*s*4);if(yield t.copyTo(a,function(e,t,i,r,n){const s=4*Math.max(1,0),a=(Math.max(0,-1)- -1)*r*4+s,o=4*r,l=Math.max(0,-1),c=Math.max(0,-1);return{rect:{x:l,y:c,width:Math.min(e.width,-1+r)-l,height:Math.min(e.height,-1+n)-c},layout:[{offset:a,stride:o}]}}(e,0,0,r,s)),n)for(let e=0;e<a.length;e+=4){const t=a[e];a[e]=a[e+2],a[e+2]=t}return a}finally{t.close()}}))}(e,0,0,t,i))}catch(e){}}return tt.getImageData(e,1)}))}_getNeighboringTiles(e){const t=e.canonical,i=Math.pow(2,t.z),r=(t.x-1+i)%i,n=0===t.x?e.wrap-1:e.wrap,s=(t.x+1+i)%i,a=t.x+1===i?e.wrap+1:e.wrap,o={};return o[new hp(e.overscaledZ,n,t.z,r,t.y).key]={backfilled:!1},o[new hp(e.overscaledZ,a,t.z,s,t.y).key]={backfilled:!1},t.y>0&&(o[new hp(e.overscaledZ,n,t.z,r,t.y-1).key]={backfilled:!1},o[new hp(e.overscaledZ,e.wrap,t.z,t.x,t.y-1).key]={backfilled:!1},o[new hp(e.overscaledZ,a,t.z,s,t.y-1).key]={backfilled:!1}),t.y+1<i&&(o[new hp(e.overscaledZ,n,t.z,r,t.y+1).key]={backfilled:!1},o[new hp(e.overscaledZ,e.wrap,t.z,t.x,t.y+1).key]={backfilled:!1},o[new hp(e.overscaledZ,a,t.z,s,t.y+1).key]={backfilled:!1}),o}unloadTile(e){return n(this,void 0,void 0,(function*(){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded",e.actor&&(yield e.actor.sendAsync({type:"RDT",data:{type:this.type,uid:e.uid,source:this.id}}))}))}}function fp(e,t){return t?e.properties[t]:e.id}function mp(e,t){const i={id:e.id};if(t.removeAllProperties&&(delete e.removeProperties,delete e.addOrUpdateProperties,delete t.removeProperties),t.removeProperties)for(const i of t.removeProperties){const t=e.addOrUpdateProperties.findIndex((e=>e.key===i));t>-1&&e.addOrUpdateProperties.splice(t,1)}return(e.removeAllProperties||t.removeAllProperties)&&(i.removeAllProperties=!0),(e.removeProperties||t.removeProperties)&&(i.removeProperties=[...e.removeProperties||[],...t.removeProperties||[]]),(e.addOrUpdateProperties||t.addOrUpdateProperties)&&(i.addOrUpdateProperties=[...e.addOrUpdateProperties||[],...t.addOrUpdateProperties||[]]),(e.newGeometry||t.newGeometry)&&(i.newGeometry=t.newGeometry||e.newGeometry),i}function _p(e){var t,i;if(!e)return{};const r={};return r.removeAll=e.removeAll,r.remove=new Set(e.remove||[]),r.add=new Map(null===(t=e.add)||void 0===t?void 0:t.map((e=>[e.id,e]))),r.update=new Map(null===(i=e.update)||void 0===i?void 0:i.map((e=>[e.id,e]))),r}function gp(e){return"GeometryCollection"===e.type?e.geometries.map((e=>e.coordinates)).flat(1/0):e.coordinates.flat(1/0)}function yp(e){const t=new Wd;let i;switch(e.type){case"FeatureCollection":i=e.features.map((e=>gp(e.geometry))).flat(1/0);break;case"Feature":i=gp(e.geometry);break;default:i=gp(e)}if(0==i.length)return t;for(let e=0;e<i.length-1;e+=2)t.extend([i[e],i[e+1]]);return t}class xp extends Pt{constructor(e,t,i,r){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._isUpdatingWorker=!1,this._pendingWorkerUpdate={data:t.data},this.actor=i.getActor(),this.setEventedParent(r),this._data="string"==typeof t.data?{url:t.data}:{geojson:t.data},this._options=we({},t),this._collectResourceTiming=t.collectResourceTiming,void 0!==t.maxzoom&&(this.maxzoom=t.maxzoom),t.type&&(this.type=t.type),t.attribution&&(this.attribution=t.attribution),this.promoteId=t.promoteId,void 0!==t.clusterMaxZoom&&this.maxzoom<=t.clusterMaxZoom&&Re(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${t.clusterMaxZoom}".`),this.workerOptions=we({source:this.id,cluster:t.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==t.buffer?t.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==t.tolerance?t.tolerance:.375),extent:Q,maxZoom:this.maxzoom,lineMetrics:t.lineMetrics||!1,generateId:t.generateId||!1},superclusterOptions:{maxZoom:this._getClusterMaxZoom(t.clusterMaxZoom),minPoints:Math.max(2,t.clusterMinPoints||2),extent:Q,radius:this._pixelsToTileUnits(t.clusterRadius||50),log:!1,generateId:t.generateId||!1},clusterProperties:t.clusterProperties,filter:t.filter},t.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId)}_hasPendingWorkerUpdate(){return void 0!==this._pendingWorkerUpdate.data||void 0!==this._pendingWorkerUpdate.diff||this._pendingWorkerUpdate.optionsChanged}_pixelsToTileUnits(e){return e*(Q/this.tileSize)}_getClusterMaxZoom(e){const t=e?Math.round(e):this.maxzoom-1;return Number.isInteger(e)||void 0===e||Re(`Integer expected for option 'clusterMaxZoom': provided value "${e}" rounded to "${t}"`),t}load(){return n(this,void 0,void 0,(function*(){yield this._updateWorkerData()}))}onAdd(e){this.map=e,this.load()}setData(e,t){this._data="string"==typeof e?{url:e}:{geojson:e},this._pendingWorkerUpdate={data:e};const i=this._updateWorkerData();return t?i:this}updateData(e,t){this._pendingWorkerUpdate.diff=function(e,t){if(!e)return t||{};if(!t)return e||{};const i=_p(e),r=_p(t);!function(e,t){t.removeAll&&(e.add.clear(),e.update.clear(),e.remove.clear(),t.remove.clear());for(const i of t.remove)e.add.delete(i),e.update.delete(i);for(const[i,r]of t.update){const n=e.update.get(i);n&&(t.update.set(i,mp(n,r)),e.update.delete(i))}}(i,r);const n={};if((i.removeAll||r.removeAll)&&(n.removeAll=!0),n.remove=new Set([...i.remove,...r.remove]),n.add=new Map([...i.add,...r.add]),n.update=new Map([...i.update,...r.update]),n.remove.size&&n.add.size)for(const e of n.add.keys())n.remove.delete(e);const s=function(e){const t={};return e.removeAll&&(t.removeAll=e.removeAll),e.remove&&(t.remove=Array.from(e.remove)),e.add&&(t.add=Array.from(e.add.values())),e.update&&(t.update=Array.from(e.update.values())),t}(n);return s}(this._pendingWorkerUpdate.diff,e);const i=this._updateWorkerData();return t?i:this}getData(){return n(this,void 0,void 0,(function*(){const e=we({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:e})}))}getBounds(){return n(this,void 0,void 0,(function*(){return yp(yield this.getData())}))}setClusterOptions(e){return this.workerOptions.cluster=e.cluster,void 0!==e.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(e.clusterRadius)),void 0!==e.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=this._getClusterMaxZoom(e.clusterMaxZoom)),this._pendingWorkerUpdate.optionsChanged=!0,this._updateWorkerData(),this}getClusterExpansionZoom(e){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:e,source:this.id}})}getClusterChildren(e){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:e,source:this.id}})}getClusterLeaves(e,t,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:e,limit:t,offset:i}})}_updateWorkerData(){return n(this,void 0,void 0,(function*(){if(this._isUpdatingWorker)return;if(!this._hasPendingWorkerUpdate())return void Re(`No pending worker updates for GeoJSONSource ${this.id}.`);const{data:e,diff:t}=this._pendingWorkerUpdate,i=we({type:this.type},this.workerOptions);void 0!==e?("string"==typeof e?(i.request=this.map._requestManager.transformRequest(tt.resolveURL(e),"Source"),i.request.collectResourceTiming=this._collectResourceTiming):i.data=e,this._pendingWorkerUpdate.data=void 0):t&&(i.dataDiff=t,this._pendingWorkerUpdate.diff=void 0),this._pendingWorkerUpdate.optionsChanged=void 0,this._isUpdatingWorker=!0,this.fire(new Tt("dataloading",{dataType:"source"}));try{const e=yield this.actor.sendAsync({type:"LD",data:i});if(this._isUpdatingWorker=!1,this._removed||e.abandoned)return void this.fire(new Tt("dataabort",{dataType:"source"}));e.data&&(this._data={geojson:e.data});const r=this._applyDiffToSource(t),n=this._getShouldReloadTileOptions(r);let s=null;e.resourceTiming&&e.resourceTiming[this.id]&&(s=e.resourceTiming[this.id].slice(0));const a={dataType:"source"};this._collectResourceTiming&&s&&s.length>0&&we(a,{resourceTiming:s}),this.fire(new Tt("data",Object.assign(Object.assign({},a),{sourceDataType:"metadata"}))),this.fire(new Tt("data",Object.assign(Object.assign({},a),{sourceDataType:"content",shouldReloadTileOptions:n})))}catch(e){if(this._isUpdatingWorker=!1,this._removed)return void this.fire(new Tt("dataabort",{dataType:"source"}));this.fire(new St(e))}finally{this._hasPendingWorkerUpdate()&&this._updateWorkerData()}}))}_applyDiffToSource(e){if(!e)return;const t="string"==typeof this.promoteId?this.promoteId:void 0;if(!this._data.url&&!this._data.updateable){const e=function(e,t){const i=new Map;if(null==e)return i;if(null==e.type)return i;if("Feature"===e.type){const r=fp(e,t);if(null==r)return;return i.set(r,e),i}if("FeatureCollection"===e.type){const r=new Set;for(const n of e.features){const e=fp(n,t);if(null==e)return;if(r.has(e))return;r.add(e),i.set(e,n)}return i}}(this._data.geojson,t);if(!e)throw new Error(`GeoJSONSource "${this.id}": GeoJSON data is not compatible with updateData`);this._data={updateable:e}}if(!this._data.updateable)return;const i=function(e,t,i){var r,n;const s=[];if(t.removeAll)e.clear();else if(t.remove)for(const i of t.remove){const t=e.get(i);t&&(s.push(t.geometry),e.delete(i))}if(t.add)for(const r of t.add){const t=fp(r,i);if(null==t)continue;const n=e.get(t);n&&s.push(n.geometry),s.push(r.geometry),e.set(t,r)}if(t.update)for(const i of t.update){const t=e.get(i.id);if(!t)continue;const a=!!i.newGeometry,o=i.removeAllProperties||(null===(r=i.removeProperties)||void 0===r?void 0:r.length)>0||(null===(n=i.addOrUpdateProperties)||void 0===n?void 0:n.length)>0;if(!a&&!o)continue;s.push(t.geometry);const l=Object.assign({},t);if(e.set(i.id,l),a&&(s.push(i.newGeometry),l.geometry=i.newGeometry),o){if(l.properties=i.removeAllProperties?{}:Object.assign({},l.properties||{}),i.removeProperties)for(const e of i.removeProperties)delete l.properties[e];if(i.addOrUpdateProperties)for(const{key:e,value:t}of i.addOrUpdateProperties)l.properties[e]=t}}return s}(this._data.updateable,e,t);return e.removeAll||this._options.cluster?void 0:i}_getShouldReloadTileOptions(e){if(e)return{affectedBounds:e.filter(Boolean).map((e=>yp(e)))}}shouldReloadTile(e,{affectedBounds:t}){if("loading"===e.state)return!0;if("unloaded"===e.state)return!1;const{buffer:i,extent:r}=this.workerOptions.geojsonVtOptions,n=function({x:e,y:t,z:i},r=0){const n=Qd((e-r)/Math.pow(2,i)),s=ep((t+1+r)/Math.pow(2,i)),a=Qd((e+1+r)/Math.pow(2,i)),o=ep((t-r)/Math.pow(2,i));return new Wd([n,s],[a,o])}(e.tileID.canonical,i/r);for(const e of t)if(n.intersects(e))return!0;return!1}loaded(){return!this._isUpdatingWorker&&!this._hasPendingWorkerUpdate()}loadTile(e){return n(this,void 0,void 0,(function*(){const t=e.actor?"RT":"LT";e.actor=this.actor;const i={type:this.type,uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};e.abortController=new AbortController;const r=yield this.actor.sendAsync({type:t,data:i},e.abortController);delete e.abortController,e.unloadVectorData(),e.aborted||e.loadVectorData(r,this.map.painter,"RT"===t)}))}abortTile(e){return n(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.aborted=!0}))}unloadTile(e){return n(this,void 0,void 0,(function*(){e.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}})}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}})}serialize(){return we({},this._options,{type:this.type,data:this._data.updateable?{type:"FeatureCollection",features:Array.from(this._data.updateable.values())}:this._data.url||this._data.geojson})}hasTransition(){return!1}}class vp{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0}extend(e){return this.minX=Math.min(this.minX,e.x),this.minY=Math.min(this.minY,e.y),this.maxX=Math.max(this.maxX,e.x),this.maxY=Math.max(this.maxY,e.y),this}expandBy(e){return this.minX-=e,this.minY-=e,this.maxX+=e,this.maxY+=e,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(e){return this.expandBy(-e)}map(e){const t=new vp;return t.extend(e(new s(this.minX,this.minY))),t.extend(e(new s(this.maxX,this.minY))),t.extend(e(new s(this.minX,this.maxY))),t.extend(e(new s(this.maxX,this.maxY))),t}static fromPoints(e){const t=new vp;for(const i of e)t.extend(i);return t}contains(e){return e.x>=this.minX&&e.x<=this.maxX&&e.y>=this.minY&&e.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(e){return!this.empty()&&!e.empty()&&e.minX>=this.minX&&e.maxX<=this.maxX&&e.minY>=this.minY&&e.maxY<=this.maxY}intersects(e){return!this.empty()&&!e.empty()&&e.minX<=this.maxX&&e.maxX>=this.minX&&e.minY<=this.maxY&&e.maxY>=this.minY}}class bp extends Pt{constructor(e,t,i,r){super(),this.flippedWindingOrder=!1,this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(r),this.options=t}load(e){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new Tt("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const t=yield xt.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,t&&t.data&&(this.image=t.data,e&&(this.coordinates=e),this._finishLoading())}catch(e){this._request=null,this._loaded=!0,Ke(e)||this.fire(new St(e))}}))}loaded(){return this._loaded}updateImage(e){return e.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=e.url,this.load(e.coordinates).finally((()=>{this.texture=null})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new Tt("data",{dataType:"source",sourceDataType:"metadata"})))}onAdd(e){this.map=e,this.load()}onRemove(){this._request&&(this._request.abort(),this._request=null)}setCoordinates(e){this.coordinates=e;const t=e.map(ip.fromLngLat);var i;return this.tileID=function(e){const t=vp.fromPoints(e),i=t.width(),r=t.height(),n=Math.max(i,r),s=Math.max(0,Math.floor(-Math.log(n)/Math.LN2)),a=Math.pow(2,s);return new lp(s,Math.floor((t.minX+t.maxX)/2*a),Math.floor((t.minY+t.maxY)/2*a))}(t),this.terrainTileRanges=this._getOverlappingTileRanges(t),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=t.map((e=>this.tileID.getTilePoint(e)._round())),this.flippedWindingOrder=((i=this.tileCoords)[1].x-i[0].x)*(i[2].y-i[0].y)-(i[1].y-i[0].y)*(i[2].x-i[0].x)<0,this.fire(new Tt("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,t=e.gl;this.texture||(this.texture=new Gc(e,this.image,t.RGBA),this.texture.bind(t.LINEAR,t.CLAMP_TO_EDGE));let i=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,i=!0)}i&&this.fire(new Tt("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}loadTile(e){return n(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={}):e.state="errored"}))}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return!1}_getOverlappingTileRanges(e){const{minX:t,minY:i,maxX:r,maxY:n}=vp.fromPoints(e),s={};for(let e=0;e<=25;e++){const a=Math.pow(2,e),o=Math.floor(t*a),l=Math.floor(i*a),c=Math.floor(r*a),h=Math.floor(n*a),u=(o%a+a)%a,d=c%a,p=Math.floor(o/a),f=Math.floor(c/a);s[e]={minWrap:p,maxWrap:f,minTileXWrapped:u,maxTileXWrapped:d,minTileY:l,maxTileY:h}}return s}}class wp extends bp{constructor(e,t,i,r){super(e,t,i,r),this.roundZoom=!0,this.type="video",this.options=t}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1;const e=this.options;this.urls=[];for(const t of e.urls)this.urls.push(this.map._requestManager.transformRequest(t,"Source").url);try{const e=yield(e=>{const t=window.document.createElement("video");return t.muted=!0,new Promise((i=>{t.onloadstart=()=>{i(t)};for(const i of e){const e=window.document.createElement("source");dt(i)||(t.crossOrigin="Anonymous"),e.src=i,t.appendChild(e)}}))})(this.urls);if(this._loaded=!0,!e)return;this.video=e,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint()})),this.map&&this.video.play(),this._finishLoading()}catch(e){this.fire(new St(e))}}))}pause(){this.video&&this.video.pause()}play(){this.video&&this.video.play()}seek(e){if(this.video){const t=this.video.seekable;e<t.start(0)||e>t.end(0)?this.fire(new St(new Vt(`sources.${this.id}`,null,`Playback for this video can be set only between the ${t.start(0)} and ${t.end(0)}-second mark.`))):this.video.currentTime=e}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)))}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,t=e.gl;this.texture?this.video.paused||(this.texture.bind(t.LINEAR,t.CLAMP_TO_EDGE),t.texSubImage2D(t.TEXTURE_2D,0,0,0,t.RGBA,t.UNSIGNED_BYTE,this.video)):(this.texture=new Gc(e,this.video,t.RGBA),this.texture.bind(t.LINEAR,t.CLAMP_TO_EDGE));let i=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,i=!0)}i&&this.fire(new Tt("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class Tp extends bp{constructor(e,t,i,r){super(e,t,i,r),t.coordinates?Array.isArray(t.coordinates)&&4===t.coordinates.length&&!t.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new St(new Vt(`sources.${e}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new St(new Vt(`sources.${e}`,null,'missing required property "coordinates"'))),t.animate&&"boolean"!=typeof t.animate&&this.fire(new St(new Vt(`sources.${e}`,null,'optional "animate" property must be a boolean value'))),t.canvas?"string"==typeof t.canvas||t.canvas instanceof HTMLCanvasElement||this.fire(new St(new Vt(`sources.${e}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new St(new Vt(`sources.${e}`,null,'missing required property "canvas"'))),this.options=t,this.animate=void 0===t.animate||t.animate}load(){return n(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new St(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint()},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1)},this._finishLoading())}))}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play()}onRemove(){this.pause()}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const t=this.map.painter.context,i=t.gl;this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):(this.texture=new Gc(t,this.canvas,i.RGBA,{premultiply:!0}),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let r=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,r=!0)}r&&this.fire(new Tt("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"canvas",animate:this.animate,canvas:this.options.canvas,coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of[this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return!0;return!1}}const Sp={},Pp=e=>{switch(e){case"geojson":return xp;case"image":return bp;case"raster":return sp;case"raster-dem":return pp;case"vector":return np;case"video":return wp;case"canvas":return Tp}return Sp[e]};class Ip{constructor(e){this._stringToNumber={},this._numberToString=[];for(let t=0;t<e.length;t++){const i=e[t];this._stringToNumber[i]=t,this._numberToString[t]=i}}encode(e){return this._stringToNumber[e]}decode(e){if(e>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${e} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[e]}}class Mp{constructor(e,t,i,r,n){this.type="Feature",this._vectorTileFeature=e,this._x=i,this._y=r,this._z=t,this.properties=e.properties,this.id=n}projectPoint(e,t,i,r){return[360*(e.x+t)/r-180,360/Math.PI*Math.atan(Math.exp((1-2*(e.y+i)/r)*Math.PI))-90]}projectLine(e,t,i,r){return e.map((e=>this.projectPoint(e,t,i,r)))}get geometry(){if(this._geometry)return this._geometry;const e=this._vectorTileFeature,t=e.extent*Math.pow(2,this._z),i=e.extent*this._x,r=e.extent*this._y,n=e.loadGeometry();switch(e.type){case 1:{const e=[];for(const t of n)e.push(t[0]);const s=this.projectLine(e,i,r,t);this._geometry=1===e.length?{type:"Point",coordinates:s[0]}:{type:"MultiPoint",coordinates:s};break}case 2:{const e=n.map((e=>this.projectLine(e,i,r,t)));this._geometry=1===e.length?{type:"LineString",coordinates:e[0]}:{type:"MultiLineString",coordinates:e};break}case 3:{const e=Nh(n),s=[];for(const n of e)s.push(n.map((e=>this.projectLine(e,i,r,t))));this._geometry=1===s.length?{type:"Polygon",coordinates:s[0]}:{type:"MultiPolygon",coordinates:s};break}default:throw new Error(`unknown feature type: ${e.type}`)}return this._geometry}set geometry(e){this._geometry=e}toJSON(){const e={geometry:this.geometry};for(const t in this)"_geometry"!==t&&"_vectorTileFeature"!==t&&"_x"!==t&&"_y"!==t&&"_z"!==t&&(e[t]=this[t]);return e}}class Ep{_name;dataBuffer;nullabilityBuffer;_size;constructor(e,t,i){this._name=e,this.dataBuffer=t,"number"==typeof i?this._size=i:(this.nullabilityBuffer=i,this._size=i.size())}getValue(e){return this.nullabilityBuffer&&!this.nullabilityBuffer.get(e)?null:this.getValueFromBuffer(e)}has(e){return this.nullabilityBuffer&&this.nullabilityBuffer.get(e)||!this.nullabilityBuffer}get name(){return this._name}get size(){return this._size}}class Cp extends Ep{}class Ap extends Cp{getValueFromBuffer(e){return this.dataBuffer[e]}}class zp extends Cp{getValueFromBuffer(e){return this.dataBuffer[e]}}class Dp extends Ep{delta;constructor(e,t,i,r){super(e,t,r),this.delta=i}}class Rp extends Dp{constructor(e,t,i,r){super(e,Int32Array.of(t),i,r)}getValueFromBuffer(e){return this.dataBuffer[0]+e*this.delta}}class kp extends Ep{constructor(e,t,i){super(e,Int32Array.of(t),i)}getValueFromBuffer(e){return this.dataBuffer[0]}}class Lp{_name;_geometryVector;_idVector;_propertyVectors;_extent;propertyVectorsMap;constructor(e,t,i,r,n=4096){this._name=e,this._geometryVector=t,this._idVector=i,this._propertyVectors=r,this._extent=n}get name(){return this._name}get idVector(){return this._idVector}get geometryVector(){return this._geometryVector}get propertyVectors(){return this._propertyVectors}getPropertyVector(e){return this.propertyVectorsMap||(this.propertyVectorsMap=new Map(this._propertyVectors.map((e=>[e.name,e])))),this.propertyVectorsMap.get(e)}*[Symbol.iterator](){const e=this.geometryVector[Symbol.iterator]();let t=0;for(;t<this.numFeatures;){let i;this.idVector&&(i=this.containsMaxSaveIntegerValues(this.idVector)?Number(this.idVector.getValue(t)):this.idVector.getValue(t));const r=e?.next().value,n={};for(const e of this.propertyVectors){if(!e)continue;const i=e.name,r=e.getValue(t);null!==r&&(n[i]=r)}t++,yield{id:i,geometry:r,properties:n}}}get numFeatures(){return this.geometryVector.numGeometries}get extent(){return this._extent}getFeatures(){const e=[],t=this.geometryVector.getGeometries();for(let i=0;i<this.numFeatures;i++){let r;this.idVector&&(r=this.containsMaxSaveIntegerValues(this.idVector)?Number(this.idVector.getValue(i)):this.idVector.getValue(i));const n={coordinates:t[i],type:this.geometryVector.geometryType(i)},s={};for(const e of this.propertyVectors){if(!e)continue;const t=e.name,r=e.getValue(i);null!==r&&(s[t]=r)}e.push({id:r,geometry:n,properties:s})}return e}containsMaxSaveIntegerValues(e){return e instanceof Ap||e instanceof kp&&e instanceof Rp||e instanceof zp}}class Fp{value;constructor(e){this.value=e}get(){return this.value}set(e){this.value=e}increment(){return this.value++}add(e){this.value+=e}}var Bp,Op,Vp,jp,Np,Up,Gp,Zp,$p,qp;function Wp(e,t,i){const r=new Int32Array(i);let n=0,s=t.get();for(let t=0;t<r.length;t++){let t=e[s++],i=127&t;t<128||(t=e[s++],i|=(127&t)<<7,t<128||(t=e[s++],i|=(127&t)<<14,t<128||(t=e[s++],i|=(127&t)<<21,t<128||(t=e[s++],i|=(15&t)<<28)))),r[n++]=i}return t.set(s),r}function Hp(e,t,i){const r=new BigInt64Array(i);for(let i=0;i<r.length;i++)r[i]=Qp(e,t);return r}function Xp(e,t){let i,r;return r=e[t.get()],t.increment(),i=127&r,r<128?i:(r=e[t.get()],t.increment(),i|=(127&r)<<7,r<128?i:(r=e[t.get()],t.increment(),i|=(127&r)<<14,r<128?i:(r=e[t.get()],t.increment(),i|=(127&r)<<21,r<128?i:(r=e[t.get()],i|=(15&r)<<28,function(e,t,i){let r,n;if(n=t[i.get()],i.increment(),r=(112&n)>>4,n<128)return 4294967296*r+(e>>>0);if(n=t[i.get()],i.increment(),r|=(127&n)<<3,n<128)return 4294967296*r+(e>>>0);if(n=t[i.get()],i.increment(),r|=(127&n)<<10,n<128)return 4294967296*r+(e>>>0);if(n=t[i.get()],i.increment(),r|=(127&n)<<17,n<128)return 4294967296*r+(e>>>0);if(n=t[i.get()],i.increment(),r|=(127&n)<<24,n<128)return 4294967296*r+(e>>>0);if(n=t[i.get()],i.increment(),r|=(1&n)<<31,n<128)return 4294967296*r+(e>>>0);throw new Error("Expected varint not more than 10 bytes")}(i,e,t)))))}function Yp(e,t,i,r){throw new Error("FastPFor is not implemented yet.")}function Kp(e){return e>>>1^-(1&e)}function Jp(e){return e>>1n^-(1n&e)}function Qp(e,t){let i=0n,r=0,n=t.get();for(;n<e.length;){const t=e[n++];if(i|=BigInt(127&t)<<BigInt(r),!(128&t))break;if(r+=7,r>=64)throw new Error("Varint too long")}return t.set(n),i}function ef(e,t,i){const r=new Int32Array(i);let n=0;for(let i=0;i<t;i++){const s=e[i];r.fill(e[i+t],n,n+s),n+=s}return r}function tf(e,t,i){const r=new BigInt64Array(i);let n=0;for(let i=0;i<t;i++){const s=Number(e[i]);r.fill(e[i+t],n,n+s),n+=s}return r}function rf(e,t,i){const r=new Float64Array(i);let n=0;for(let i=0;i<t;i++){const s=e[i];r.fill(e[i+t],n,n+s),n+=s}return r}function nf(e){const t=e.length/4*4;let i=1;if(t>=4)for(let r=e[0];i<t-4;i+=4)r=e[i]+=r,r=e[i+1]+=r,r=e[i+2]+=r,r=e[i+3]+=r;for(;i!=e.length;)e[i]+=e[i-1],++i}function sf(e){e[0]=e[0]>>>1^-(1&e[0]),e[1]=e[1]>>>1^-(1&e[1]);const t=e.length/4*4;let i=2;if(t>=4)for(;i<t-4;i+=4){const t=e[i],r=e[i+1],n=e[i+2],s=e[i+3];e[i]=(t>>>1^-(1&t))+e[i-2],e[i+1]=(r>>>1^-(1&r))+e[i-1],e[i+2]=(n>>>1^-(1&n))+e[i],e[i+3]=(s>>>1^-(1&s))+e[i+1]}for(;i!=e.length;i+=2)e[i]=(e[i]>>>1^-(1&e[i]))+e[i-2],e[i+1]=(e[i+1]>>>1^-(1&e[i+1]))+e[i-1]}!function(e){e.NONE="NONE",e.DELTA="DELTA",e.COMPONENTWISE_DELTA="COMPONENTWISE_DELTA",e.RLE="RLE",e.MORTON="MORTON",e.PDE="PDE"}(Bp||(Bp={})),function(e){e.NONE="NONE",e.FAST_PFOR="FAST_PFOR",e.VARINT="VARINT",e.ALP="ALP"}(Op||(Op={})),function(e){e.PRESENT="PRESENT",e.DATA="DATA",e.OFFSET="OFFSET",e.LENGTH="LENGTH"}(Vp||(Vp={}));class af{_dictionaryType;_offsetType;_lengthType;constructor(e,t,i){this._dictionaryType=e,this._offsetType=t,this._lengthType=i}get dictionaryType(){return this._dictionaryType}get offsetType(){return this._offsetType}get lengthType(){return this._lengthType}}function of(e,t){const i=function(e,t){const i=e[t.get()],r=Object.values(Vp)[i>>4];let n=null;switch(r){case Vp.DATA:n=new af(Object.values(jp)[15&i]);break;case Vp.OFFSET:n=new af(null,Object.values(Np)[15&i]);break;case Vp.LENGTH:n=new af(null,null,Object.values(Up)[15&i])}t.increment();const s=e[t.get()],a=Object.values(Bp)[s>>5],o=Object.values(Bp)[s>>2&7],l=Object.values(Op)[3&s];t.increment();const c=Wp(e,t,2),h=c[0];return{physicalStreamType:r,logicalStreamType:n,logicalLevelTechnique1:a,logicalLevelTechnique2:o,physicalLevelTechnique:l,numValues:h,byteLength:c[1],decompressedCount:h}}(e,t);return i.logicalLevelTechnique1===Bp.MORTON?function(e,t,i){const r=Wp(t,i,2);return{physicalStreamType:e.physicalStreamType,logicalStreamType:e.logicalStreamType,logicalLevelTechnique1:e.logicalLevelTechnique1,logicalLevelTechnique2:e.logicalLevelTechnique2,physicalLevelTechnique:e.physicalLevelTechnique,numValues:e.numValues,byteLength:e.byteLength,decompressedCount:e.decompressedCount,numBits:r[0],coordinateShift:r[1]}}(i,e,t):Bp.RLE!==i.logicalLevelTechnique1&&Bp.RLE!==i.logicalLevelTechnique2||Op.NONE===i.physicalLevelTechnique?i:function(e,t,i){const r=Wp(t,i,2);return{physicalStreamType:e.physicalStreamType,logicalStreamType:e.logicalStreamType,logicalLevelTechnique1:e.logicalLevelTechnique1,logicalLevelTechnique2:e.logicalLevelTechnique2,physicalLevelTechnique:e.physicalLevelTechnique,numValues:e.numValues,byteLength:e.byteLength,decompressedCount:r[1],runs:r[0],numRleValues:r[1]}}(i,e,t)}!function(e){e.NONE="NONE",e.SINGLE="SINGLE",e.SHARED="SHARED",e.VERTEX="VERTEX",e.MORTON="MORTON",e.FSST="FSST"}(jp||(jp={})),function(e){e.VERTEX="VERTEX",e.INDEX="INDEX",e.STRING="STRING",e.KEY="KEY"}(Np||(Np={})),function(e){e.VAR_BINARY="VAR_BINARY",e.GEOMETRIES="GEOMETRIES",e.PARTS="PARTS",e.RINGS="RINGS",e.TRIANGLES="TRIANGLES",e.SYMBOL="SYMBOL",e.DICTIONARY="DICTIONARY"}(Up||(Up={})),function(e){e[e.FLAT=0]="FLAT",e[e.CONST=1]="CONST",e[e.SEQUENCE=2]="SEQUENCE",e[e.DICTIONARY=3]="DICTIONARY",e[e.FSST_DICTIONARY=4]="FSST_DICTIONARY"}(Gp||(Gp={}));class lf{values;_size;constructor(e,t){this.values=e,this._size=t}get(e){const t=Math.floor(e/8);return 1==(this.values[t]>>e%8&1)}set(e,t){const i=Math.floor(e/8);this.values[i]=this.values[i]|(t?1:0)<<e%8}getInt(e){const t=Math.floor(e/8);return this.values[t]>>e%8&1}size(){return this._size}getBuffer(){return this.values}}function cf(e,t,i,r,n){return function(e,t,i){switch(t.logicalLevelTechnique1){case Bp.DELTA:return t.logicalLevelTechnique2===Bp.RLE?function(e,t,i){const r=new Int32Array(i);let n=0,s=0;for(let i=0;i<t;i++){const a=e[i],o=Kp(e[i+t]);for(let e=0;e<a;e++)s+=o,r[n++]=s}return r}(e,t.runs,t.numRleValues):(function(e){e[0]=e[0]>>>1^-(1&e[0]);const t=e.length/4*4;let i=1;if(t>=4)for(;i<t-4;i+=4){const t=e[i],r=e[i+1],n=e[i+2],s=e[i+3];e[i]=(t>>>1^-(1&t))+e[i-1],e[i+1]=(r>>>1^-(1&r))+e[i],e[i+2]=(n>>>1^-(1&n))+e[i+1],e[i+3]=(s>>>1^-(1&s))+e[i+2]}for(;i!=e.length;++i)e[i]=(e[i]>>>1^-(1&e[i]))+e[i-1]}(e),e);case Bp.RLE:return function(e,t,i){return i?function(e,t,i){const r=new Int32Array(i);let n=0;for(let i=0;i<t;i++){const s=e[i];let a=e[i+t];a=a>>>1^-(1&a),r.fill(a,n,n+s),n+=s}return r}(e,t.runs,t.numRleValues):ef(e,t.runs,t.numRleValues)}(e,t,i);case Bp.MORTON:return nf(e),e;case Bp.COMPONENTWISE_DELTA:return sf(e),e;case Bp.NONE:return i&&function(e){for(let t=0;t<e.length;t++){const i=e[t];e[t]=i>>>1^-(1&i)}}(e),e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}(uf(e,t,i),i,r)}function hf(e,t,i){return function(e,t){if(t.logicalLevelTechnique1===Bp.DELTA&&t.logicalLevelTechnique2===Bp.NONE){const t=function(e){const t=new Int32Array(e.length+1);t[0]=0,t[1]=Kp(e[0]);let i=t[1],r=2;for(;r!=t.length;++r){const n=e[r-1];i+=n>>>1^-(1&n),t[r]=t[r-1]+i}return t}(e);return t}if(t.logicalLevelTechnique1===Bp.RLE&&t.logicalLevelTechnique2===Bp.NONE){const i=function(e,t,i){const r=new Int32Array(i+1);r[0]=0;let n=1,s=r[0];for(let i=0;i<t;i++){const a=e[i],o=e[i+t];for(let e=n;e<n+a;e++)r[e]=o+s,s=r[e];n+=a}return r}(e,t.runs,t.numRleValues);return i}if(t.logicalLevelTechnique1===Bp.NONE&&t.logicalLevelTechnique2===Bp.NONE){!function(e){let t=0;for(let i=0;i<e.length;i++)e[i]+=t,t=e[i]}(e);const i=new Int32Array(t.numValues+1);return i[0]=0,i.set(e,1),i}if(t.logicalLevelTechnique1===Bp.DELTA&&t.logicalLevelTechnique2===Bp.RLE){const i=function(e,t,i){const r=new Int32Array(i+1);r[0]=0;let n=1,s=r[0];for(let i=0;i<t;i++){const a=e[i];let o=e[i+t];o=o>>>1^-(1&o);for(let e=n;e<n+a;e++)r[e]=o+s,s=r[e];n+=a}return r}(e,t.runs,t.numRleValues);return nf(i),i}throw new Error("Only delta encoding is supported for transforming length to offset streams yet.")}(uf(e,t,i),i)}function uf(e,t,i){const r=i.physicalLevelTechnique;if(r===Op.FAST_PFOR)return Yp();if(r===Op.VARINT)return Wp(e,t,i.numValues);if(r===Op.NONE){const r=t.get();t.add(i.byteLength);const n=e.subarray(r,t.get());return new Int32Array(n)}throw new Error("Specified physicalLevelTechnique is not supported (yet).")}function df(e,t,i,r){const n=uf(e,t,i);if(1===n.length){const e=n[0];return r?Kp(e):e}return r?function(e){return Kp(e[1])}(n):function(e){return e[1]}(n)}function pf(e,t,i){return function(e){if(2==e.length){const t=Kp(e[1]);return[t,t]}return[Kp(e[2]),Kp(e[3])]}(uf(e,t,i))}function ff(e,t,i){return function(e){if(2==e.length){const t=Jp(e[1]);return[t,t]}return[Jp(e[2]),Jp(e[3])]}(Hp(e,t,i.numValues))}function mf(e,t,i,r){return function(e,t,i){switch(t.logicalLevelTechnique1){case Bp.DELTA:return t.logicalLevelTechnique2===Bp.RLE?function(e,t,i){const r=new BigInt64Array(i);let n=0,s=0n;for(let i=0;i<t;i++){const a=Number(e[i]),o=Jp(e[i+t]);for(let e=0;e<a;e++)s+=o,r[n++]=s}return r}(e,t.runs,t.numRleValues):(function(e){e[0]=e[0]>>1n^-(1n&e[0]);const t=e.length/4*4;let i=1;if(t>=4)for(;i<t-4;i+=4){const t=e[i],r=e[i+1],n=e[i+2],s=e[i+3];e[i]=(t>>1n^-(1n&t))+e[i-1],e[i+1]=(r>>1n^-(1n&r))+e[i],e[i+2]=(n>>1n^-(1n&n))+e[i+1],e[i+3]=(s>>1n^-(1n&s))+e[i+2]}for(;i!=e.length;++i)e[i]=(e[i]>>1n^-(1n&e[i]))+e[i-1]}(e),e);case Bp.RLE:return function(e,t,i){return i?function(e,t,i){const r=new BigInt64Array(i);let n=0;for(let i=0;i<t;i++){const s=Number(e[i]);let a=e[i+t];a=a>>1n^-(1n&a),r.fill(a,n,n+s),n+=s}return r}(e,t.runs,t.numRleValues):tf(e,t.runs,t.numRleValues)}(e,t,i);case Bp.NONE:return i&&function(e){for(let t=0;t<e.length;t++){const i=e[t];e[t]=i>>1n^-(1n&i)}}(e),e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}(Hp(e,t,i.numValues),i,r)}function _f(e,t,i,r){const n=Hp(e,t,i.numValues);if(1===n.length){const e=n[0];return r?Jp(e):e}return r?function(e){return Jp(e[1])}(n):function(e){return e[1]}(n)}function gf(e,t,i,r,n){return function(e,t,i,r){switch(t.logicalLevelTechnique1){case Bp.DELTA:return t.logicalLevelTechnique2===Bp.RLE&&(e=ef(e,t.runs,t.numRleValues)),function(e,t){const i=new Int32Array(e.size());let r=0;e.get(0)?(i[0]=e.get(0)?t[0]>>>1^-(1&t[0]):0,r=1):i[0]=0;let n=1;for(;n!=i.length;++n)i[n]=e.get(n)?i[n-1]+(t[r]>>>1^-(1&t[r++])):i[n-1];return i}(r,e);case Bp.RLE:return function(e,t,i,r){const n=t;return i?function(e,t,i){const r=new Int32Array(e.size());let n=0;for(let s=0;s<i;s++){const a=t[s];let o=t[s+i];o=o>>>1^-(1&o);for(let t=n;t<n+a;t++)e.get(t)?r[t]=o:(r[t]=0,n++);n+=a}return r}(r,e,n.runs):function(e,t,i){const r=new Int32Array(e.size());let n=0;for(let s=0;s<i;s++){const a=t[s],o=t[s+i];for(let t=n;t<n+a;t++)e.get(t)?r[t]=o:(r[t]=0,n++);n+=a}return r}(r,e,n.runs)}(e,t,i,r);case Bp.MORTON:return nf(e),e;case Bp.COMPONENTWISE_DELTA:return sf(e),e;case Bp.NONE:return e=i?function(e,t){const i=new Int32Array(e.size());let r=0,n=0;for(;n!=i.length;++n)if(e.get(n)){const e=t[r++];i[n]=e>>>1^-(1&e)}else i[n]=0;return i}(r,e):function(e,t){const i=new Int32Array(e.size());let r=0,n=0;for(;n!=i.length;++n)i[n]=e.get(n)?t[r++]:0;return i}(r,e),e;default:throw new Error("The specified Logical level technique is not supported")}}(i.physicalLevelTechnique===Op.FAST_PFOR?Yp():Wp(e,t,i.numValues),i,r,n)}function yf(e,t,i,r){const n=e.logicalLevelTechnique1;if(n===Bp.RLE)return 1===e.runs?Gp.CONST:Gp.FLAT;const s=t instanceof lf?t.size():t;if(n===Bp.DELTA&&e.logicalLevelTechnique2===Bp.RLE){const t=e.runs,n=2;if(e.numRleValues!==s)return Gp.FLAT;if(1===t)return Gp.SEQUENCE;if(2===t){const t=r.get();let s;if(e.physicalLevelTechnique===Op.VARINT)s=Wp(i,r,4);else{const e=r.get();s=new Int32Array(i.buffer,i.byteOffset+e,4)}if(r.set(t),s[2]===n&&s[3]===n)return Gp.SEQUENCE}}return 1===e.numValues?Gp.CONST:Gp.FLAT}class xf extends Cp{getValueFromBuffer(e){return this.dataBuffer[e]}}class vf extends Dp{constructor(e,t,i,r){super(e,BigInt64Array.of(t),i,r)}getValueFromBuffer(e){return this.dataBuffer[0]+BigInt(e)*this.delta}}class bf{_geometryOffsets;_partOffsets;_ringOffsets;constructor(e,t,i){this._geometryOffsets=e,this._partOffsets=t,this._ringOffsets=i}get geometryOffsets(){return this._geometryOffsets}get partOffsets(){return this._partOffsets}get ringOffsets(){return this._ringOffsets}}function wf(e,t,i){return{x:Tf(e,t)-i,y:Tf(e>>1,t)-i}}function Tf(e,t){let i=0;for(let r=0;r<t;r++)i|=(e&1<<2*r)>>r;return i}!function(e){e[e.POINT=0]="POINT",e[e.LINESTRING=1]="LINESTRING",e[e.POLYGON=2]="POLYGON",e[e.MULTIPOINT=3]="MULTIPOINT",e[e.MULTILINESTRING=4]="MULTILINESTRING",e[e.MULTIPOLYGON=5]="MULTIPOLYGON"}(Zp||(Zp={})),function(e){e[e.POINT=0]="POINT",e[e.LINESTRING=1]="LINESTRING",e[e.POLYGON=2]="POLYGON"}($p||($p={})),function(e){e[e.MORTON=0]="MORTON",e[e.VEC_2=1]="VEC_2",e[e.VEC_3=2]="VEC_3"}(qp||(qp={}));class Sf{createPoint(e){return[[e]]}createMultiPoint(e){return e.map((e=>[e]))}createLineString(e){return[e]}createMultiLineString(e){return e}createPolygon(e,t){return[e].concat(t)}createMultiPolygon(e){return e.flat()}}function Pf(e){const t=new Array(e.numGeometries);let i=1,r=1,n=1,a=0;const o=new Sf;let l=0,c=0;const h=e.mortonSettings,u=e.topologyVector,d=u.geometryOffsets,p=u.partOffsets,f=u.ringOffsets,m=e.vertexOffsets,_=e.containsPolygonGeometry(),g=e.vertexBuffer;for(let u=0;u<e.numGeometries;u++){const y=e.geometryType(u);if(y===Zp.POINT){if(m&&0!==m.length)if(e.vertexBufferType===qp.VEC_2){const e=2*m[c++],i=new s(g[e],g[e+1]);t[a++]=o.createPoint(i)}else{const e=wf(g[m[c++]],h.numBits,h.coordinateShift),i=new s(e.x,e.y);t[a++]=o.createPoint(i)}else{const e=new s(g[l++],g[l++]);t[a++]=o.createPoint(e)}d&&n++,p&&i++,f&&r++}else if(y===Zp.MULTIPOINT){const e=d[n]-d[n-1];n++;const i=new Array(e);if(m&&0!==m.length){for(let t=0;t<e;t++){const e=2*m[c++];i[t]=new s(g[e],g[e+1])}t[a++]=o.createMultiPoint(i)}else{for(let t=0;t<e;t++){const e=g[l++],r=g[l++];i[t]=new s(e,r)}t[a++]=o.createMultiPoint(i)}}else if(y===Zp.LINESTRING){let s,u=0;_?(u=f[r]-f[r-1],r++):u=p[i]-p[i-1],i++,m&&0!==m.length?(s=e.vertexBufferType===qp.VEC_2?Af(g,m,c,u,!1):zf(g,m,c,u,!1,h),c+=u):(s=Cf(g,l,u,!1),l+=2*u),t[a++]=o.createLineString(s),d&&n++}else if(y===Zp.POLYGON){const s=p[i]-p[i-1];i++;const u=new Array(s-1);let _=f[r]-f[r-1];if(r++,m&&0!==m.length){const i=e.vertexBufferType===qp.VEC_2?Mf(g,m,c,_):Ef(g,m,c,_,0,h);c+=_;for(let t=0;t<u.length;t++)_=f[r]-f[r-1],r++,u[t]=e.vertexBufferType===qp.VEC_2?Mf(g,m,c,_):Ef(g,m,c,_,0,h),c+=_;t[a++]=o.createPolygon(i,u)}else{const e=If(g,l,_);l+=2*_;for(let e=0;e<u.length;e++)_=f[r]-f[r-1],r++,u[e]=If(g,l,_),l+=2*_;t[a++]=o.createPolygon(e,u)}d&&n++}else if(y===Zp.MULTILINESTRING){const s=d[n]-d[n-1];n++;const u=new Array(s);if(m&&0!==m.length){for(let t=0;t<s;t++){let n=0;_?(n=f[r]-f[r-1],r++):n=p[i]-p[i-1],i++;const s=e.vertexBufferType===qp.VEC_2?Af(g,m,c,n,!1):zf(g,m,c,n,!1,h);u[t]=s,c+=n}t[a++]=o.createMultiLineString(u)}else{for(let e=0;e<s;e++){let t=0;_?(t=f[r]-f[r-1],r++):t=p[i]-p[i-1],i++,u[e]=Cf(g,l,t,!1),l+=2*t}t[a++]=o.createMultiLineString(u)}}else{if(y!==Zp.MULTIPOLYGON)throw new Error("The specified geometry type is currently not supported.");{const s=d[n]-d[n-1];n++;const u=new Array(s);let _=0;if(m&&0!==m.length){for(let t=0;t<s;t++){const n=p[i]-p[i-1];i++;const s=new Array(n-1);_=f[r]-f[r-1],r++;const a=e.vertexBufferType===qp.VEC_2?Mf(g,m,c,_):Ef(g,m,c,_,0,h);c+=_;for(let t=0;t<s.length;t++)_=f[r]-f[r-1],r++,s[t]=e.vertexBufferType===qp.VEC_2?Mf(g,m,c,_):Ef(g,m,c,_,0,h),c+=_;u[t]=o.createPolygon(a,s)}t[a++]=o.createMultiPolygon(u)}else{for(let e=0;e<s;e++){const t=p[i]-p[i-1];i++;const n=new Array(t-1);_=f[r]-f[r-1],r++;const s=If(g,l,_);l+=2*_;for(let e=0;e<n.length;e++){const t=f[r]-f[r-1];r++,n[e]=If(g,l,t),l+=2*t}u[e]=o.createPolygon(s,n)}t[a++]=o.createMultiPolygon(u)}}}}return t}function If(e,t,i){return Cf(e,t,i,!0)}function Mf(e,t,i,r){return Af(e,t,i,r,!0)}function Ef(e,t,i,r,n,s){return zf(e,t,i,r,!0,s)}function Cf(e,t,i,r){const n=new Array(r?i+1:i);for(let r=0;r<2*i;r+=2)n[r/2]=new s(e[t+r],e[t+r+1]);return r&&(n[n.length-1]=n[0]),n}function Af(e,t,i,r,n){const a=new Array(n?r+1:r);for(let n=0;n<2*r;n+=2){const r=2*t[i+n/2];a[n/2]=new s(e[r],e[r+1])}return n&&(a[a.length-1]=a[0]),a}function zf(e,t,i,r,n,a){const o=new Array(n?r+1:r);for(let n=0;n<r;n++){const r=wf(e[t[i+n]],a.numBits,a.coordinateShift);o[n]=new s(r.x,r.y)}return n&&(o[o.length-1]=o[0]),o}class Df{_vertexBufferType;_topologyVector;_vertexOffsets;_vertexBuffer;_mortonSettings;constructor(e,t,i,r,n){this._vertexBufferType=e,this._topologyVector=t,this._vertexOffsets=i,this._vertexBuffer=r,this._mortonSettings=n}get vertexBufferType(){return this._vertexBufferType}get topologyVector(){return this._topologyVector}get vertexOffsets(){return this._vertexOffsets}get vertexBuffer(){return this._vertexBuffer}*[Symbol.iterator](){const e=Pf(this);let t=0;for(;t<this.numGeometries;)yield{coordinates:e[t],type:this.geometryType(t)},t++}getSimpleEncodedVertex(e){const t=this.vertexOffsets?2*this.vertexOffsets[e]:2*e;return[this.vertexBuffer[t],this.vertexBuffer[t+1]]}getVertex(e){if(this.vertexOffsets&&this.mortonSettings){const t=wf(this.vertexBuffer[this.vertexOffsets[e]],this.mortonSettings.numBits,this.mortonSettings.coordinateShift);return[t.x,t.y]}const t=this.vertexOffsets?2*this.vertexOffsets[e]:2*e;return[this.vertexBuffer[t],this.vertexBuffer[t+1]]}getGeometries(){return Pf(this)}get mortonSettings(){return this._mortonSettings}}class Rf extends Df{_numGeometries;_geometryType;constructor(e,t,i,r,n,s,a){super(i,r,n,s,a),this._numGeometries=e,this._geometryType=t}geometryType(e){return this._geometryType}get numGeometries(){return this._numGeometries}containsPolygonGeometry(){return this._geometryType===Zp.POLYGON||this._geometryType===Zp.MULTIPOLYGON}containsSingleGeometryType(){return!0}}class kf extends Df{_geometryTypes;constructor(e,t,i,r,n,s){super(e,i,r,n,s),this._geometryTypes=t}geometryType(e){return this._geometryTypes[e]}get numGeometries(){return this._geometryTypes.length}containsPolygonGeometry(){for(let e=0;e<this.numGeometries;e++)if(this.geometryType(e)===Zp.POLYGON||this.geometryType(e)===Zp.MULTIPOLYGON)return!0;return!1}containsSingleGeometryType(){return!1}}class Lf{_triangleOffsets;_indexBuffer;_vertexBuffer;_topologyVector;constructor(e,t,i,r){this._triangleOffsets=e,this._indexBuffer=t,this._vertexBuffer=i,this._topologyVector=r}get triangleOffsets(){return this._triangleOffsets}get indexBuffer(){return this._indexBuffer}get vertexBuffer(){return this._vertexBuffer}get topologyVector(){return this._topologyVector}getGeometries(){if(!this._topologyVector)throw new Error("Cannot convert GpuVector to coordinates without topology information");const e=new Array(this.numGeometries),t=this._topologyVector,i=t.partOffsets,r=t.ringOffsets,n=t.geometryOffsets;let a=0,o=1,l=1,c=1;for(let t=0;t<this.numGeometries;t++)switch(this.geometryType(t)){case Zp.POLYGON:{const h=i[o]-i[o-1];o++;const u=[];for(let e=0;e<h;e++){const e=r[l]-r[l-1];l++;const t=[];for(let i=0;i<e;i++){const e=this._vertexBuffer[a++],i=this._vertexBuffer[a++];t.push(new s(e,i))}t.length>0&&t.push(t[0]),u.push(t)}e[t]=u,n&&c++}break;case Zp.MULTIPOLYGON:{const h=n[c]-n[c-1];c++;const u=[];for(let e=0;e<h;e++){const e=i[o]-i[o-1];o++;for(let t=0;t<e;t++){const e=r[l]-r[l-1];l++;const t=[];for(let i=0;i<e;i++){const e=this._vertexBuffer[a++],i=this._vertexBuffer[a++];t.push(new s(e,i))}t.length>0&&t.push(t[0]),u.push(t)}}e[t]=u}}return e}[Symbol.iterator](){return null}}function Ff(e,t,i,r,n,s){return new Bf(e,t,i,r,n,s)}class Bf extends Lf{_numGeometries;_geometryType;constructor(e,t,i,r,n,s){super(i,r,n,s),this._numGeometries=e,this._geometryType=t}geometryType(e){return this._geometryType}get numGeometries(){return this._numGeometries}containsSingleGeometryType(){return!0}}function Of(e,t,i,r,n){return new Vf(e,t,i,r,n)}class Vf extends Lf{_geometryTypes;constructor(e,t,i,r,n){super(t,i,r,n),this._geometryTypes=e}geometryType(e){return this._geometryTypes[e]}get numGeometries(){return this._geometryTypes.length}containsSingleGeometryType(){return!1}}function jf(e,t,i,r,n){const s=of(e,i);let a=null,o=null,l=null,c=null,h=null,u=null,d=null,p=null;if(yf(s,r,e,i)===Gp.CONST){const n=df(e,i,s,!1);for(let r=0;r<t-1;r++){const t=of(e,i);switch(t.physicalStreamType){case Vp.LENGTH:switch(t.logicalStreamType.lengthType){case Up.GEOMETRIES:a=hf(e,i,t);break;case Up.PARTS:o=hf(e,i,t);break;case Up.RINGS:l=hf(e,i,t);break;case Up.TRIANGLES:d=hf(e,i,t)}break;case Vp.OFFSET:switch(t.logicalStreamType.offsetType){case Np.VERTEX:c=cf(e,i,t,!1);break;case Np.INDEX:p=cf(e,i,t,!1)}break;case Vp.DATA:jp.VERTEX===t.logicalStreamType.dictionaryType?h=cf(e,i,t,!0):(u={numBits:t.numBits,coordinateShift:t.coordinateShift},h=cf(e,i,t,!1))}}return null!==p?null!=a||null!=o?Ff(r,n,d,p,h,new bf(a,o,l)):Ff(r,n,d,p,h):null===u?function(e,t,i,r,n){return new Rf(e,t,qp.VEC_2,i,r,n)}(r,n,new bf(a,o,l),c,h):function(e,t,i,r,n,s){return new Rf(e,t,qp.MORTON,i,r,n,s)}(r,n,new bf(a,o,l),c,h,u)}const f=cf(e,i,s,!1);for(let r=0;r<t-1;r++){const t=of(e,i);switch(t.physicalStreamType){case Vp.LENGTH:switch(t.logicalStreamType.lengthType){case Up.GEOMETRIES:a=cf(e,i,t,!1);break;case Up.PARTS:o=cf(e,i,t,!1);break;case Up.RINGS:l=cf(e,i,t,!1);break;case Up.TRIANGLES:d=hf(e,i,t)}break;case Vp.OFFSET:switch(t.logicalStreamType.offsetType){case Np.VERTEX:c=cf(e,i,t,!1);break;case Np.INDEX:p=cf(e,i,t,!1)}break;case Vp.DATA:jp.VERTEX===t.logicalStreamType.dictionaryType?h=cf(e,i,t,!0):(u={numBits:t.numBits,coordinateShift:t.coordinateShift},h=cf(e,i,t,!1))}}return null!==p&&null===o?Of(f,d,p,h):(null!==a?(a=Nf(f,a,2),null!==o&&null!==l?(o=Uf(f,a,o,!1),l=function(e,t,i,r){const n=new Int32Array(i[i.length-1]+1);let s=0;n[0]=s;let a=1,o=1,l=0;for(let c=0;c<e.length;c++){const h=e[c],u=t[c+1]-t[c];if(0!==h&&3!==h)for(let e=0;e<u;e++){const e=i[a]-i[a-1];a++;for(let t=0;t<e;t++)s=n[o++]=s+r[l++]}else for(let e=0;e<u;e++)n[o++]=++s,a++}return n}(f,a,o,l)):null!==o&&(o=function(e,t,i){const r=new Int32Array(t[t.length-1]+1);let n=0;r[0]=n;let s=1,a=0;for(let o=0;o<e.length;o++){const l=e[o],c=t[o+1]-t[o];if(4===l||1===l)for(let e=0;e<c;e++)n=r[s++]=n+i[a++];else for(let e=0;e<c;e++)r[s++]=++n}return r}(f,a,o))):null!==o&&null!==l?(o=Nf(f,o,1),l=Uf(f,o,l,!0)):null!==o&&(o=Nf(f,o,0)),null!==p?Of(f,d,p,h,new bf(a,o,l)):null===u?function(e,t,i,r){return new kf(qp.VEC_2,e,t,i,r)}(f,new bf(a,o,l),c,h):function(e,t,i,r,n){return new kf(qp.MORTON,e,t,i,r,n)}(f,new bf(a,o,l),c,h,u))}function Nf(e,t,i){const r=new Int32Array(e.length+1);let n=0;r[0]=n;let s=0;for(let a=0;a<e.length;a++)n=r[a+1]=n+(e[a]>i?t[s++]:1);return r}function Uf(e,t,i,r){const n=new Int32Array(t[t.length-1]+1);let s=0;n[0]=s;let a=1,o=0;for(let l=0;l<e.length;l++){const c=e[l],h=t[l+1]-t[l];if(5===c||2===c||r&&(4===c||1===c))for(let e=0;e<h;e++)s=n[a++]=s+i[o++];else for(let e=0;e<h;e++)n[a++]=++s}return n}class Gf extends Ep{dataVector;constructor(e,t,i){super(e,t.getBuffer(),i),this.dataVector=t}getValueFromBuffer(e){return this.dataVector.get(e)}}class Zf extends Cp{getValueFromBuffer(e){return this.dataBuffer[e]}}class $f extends Ep{constructor(e,t,i){super(e,BigInt64Array.of(t),i)}getValueFromBuffer(e){return this.dataBuffer[0]}}function qf(e,t,i){return Wf(e,Math.ceil(t/8),i)}function Wf(e,t,i){const r=new Uint8Array(t);let n=0;for(;n<t;){const t=e[i.increment()];if(t<=127){const s=t+3,a=e[i.increment()],o=n+s;r.fill(a,n,o),n=o}else{const s=256-t;for(let t=0;t<s;t++)r[n++]=e[i.increment()]}}return r}const Hf=new TextDecoder;function Xf(e,t,i){return i-t>=12?Hf.decode(e.subarray(t,i)):function(e,t,i){let r="",n=t;for(;n<i;){const t=e[n];let s,a,o,l=null,c=t>239?4:t>223?3:t>191?2:1;if(n+c>i)break;1===c?t<128&&(l=t):2===c?(s=e[n+1],128==(192&s)&&(l=(31&t)<<6|63&s,l<=127&&(l=null))):3===c?(s=e[n+1],a=e[n+2],128==(192&s)&&128==(192&a)&&(l=(15&t)<<12|(63&s)<<6|63&a,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===c&&(s=e[n+1],a=e[n+2],o=e[n+3],128==(192&s)&&128==(192&a)&&128==(192&o)&&(l=(15&t)<<18|(63&s)<<12|(63&a)<<6|63&o,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,c=1):l>65535&&(l-=65536,r+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),r+=String.fromCharCode(l),n+=c}return r}(e,t,i)}class Yf extends Ep{offsetBuffer;constructor(e,t,i,r){super(e,i,r),this.offsetBuffer=t}}class Kf extends Yf{textEncoder;constructor(e,t,i,r){super(e,t,i,r??t.length-1),this.textEncoder=new TextEncoder}getValueFromBuffer(e){return Xf(this.dataBuffer,this.offsetBuffer[e],this.offsetBuffer[e+1])}}class Jf extends Yf{indexBuffer;textEncoder;constructor(e,t,i,r,n){super(e,i,r,n??t.length),this.indexBuffer=t,this.indexBuffer=t,this.textEncoder=new TextEncoder}getValueFromBuffer(e){const t=this.indexBuffer[e];return Xf(this.dataBuffer,this.offsetBuffer[t],this.offsetBuffer[t+1])}}class Qf extends Yf{indexBuffer;symbolOffsetBuffer;symbolTableBuffer;textEncoder;symbolLengthBuffer;lengthBuffer;decodedDictionary;constructor(e,t,i,r,n,s,a){super(e,i,r,a),this.indexBuffer=t,this.symbolOffsetBuffer=n,this.symbolTableBuffer=s,this.textEncoder=new TextEncoder}getValueFromBuffer(e){null==this.decodedDictionary&&(null==this.symbolLengthBuffer&&(this.symbolLengthBuffer=this.offsetToLengthBuffer(this.symbolOffsetBuffer),this.lengthBuffer=this.offsetToLengthBuffer(this.offsetBuffer)),this.decodedDictionary=function(e,t,i){const r=[],n=new Array(t.length).fill(0);for(let e=1;e<t.length;e++)n[e]=n[e-1]+t[e-1];for(let s=0;s<i.length;s++)if(255===i[s])r.push(i[++s]);else{const a=t[i[s]],o=n[i[s]];for(let t=0;t<a;t++)r.push(e[o+t])}return new Uint8Array(r)}(this.symbolTableBuffer,this.symbolLengthBuffer,this.dataBuffer));const t=this.indexBuffer[e];return Xf(this.decodedDictionary,this.offsetBuffer[t],this.offsetBuffer[t+1])}offsetToLengthBuffer(e){const t=new Uint32Array(e.length-1);let i=e[0];for(let r=1;r<e.length;r++){const n=e[r];t[r-1]=n-i,i=n}return t}}function em(e,t,i,r,n,s){return"scalarType"===i.type?function(e,t,i,r,n,s){let a=null,o=0;if(0===e)return null;if(s.nullable){const e=of(t,i);o=e.numValues;const r=i.get(),n=qf(t,o,i);i.set(r+e.byteLength),a=new lf(n,e.numValues)}const l=a??r;switch(n.physicalType){case 4:case 3:return function(e,t,i,r,n){const s=of(e,t),a=yf(s,n,e,t),o=3===r.physicalType;if(a===Gp.FLAT){const r=tm(n)?gf(e,t,s,o,n):cf(e,t,s,o);return new Ap(i.name,r,n)}if(a===Gp.SEQUENCE){const r=pf(e,t,s);return new Rp(i.name,r[0],r[1],s.numRleValues)}{const r=df(e,t,s,o);return new kp(i.name,r,n)}}(t,i,s,n,l);case 9:return function(e,t,i,r,n){let s=null,a=null,o=null,l=null,c=null,h=null,u=null,d=null;for(let e=0;e<r;e++){const e=of(t,i);if(0!==e.byteLength)switch(e.physicalStreamType){case Vp.PRESENT:{const r=qf(t,e.numValues,i);h=new lf(r,e.numValues);break}case Vp.OFFSET:a=null!=n||null!=h?gf(t,i,e,!1,n??h):cf(t,i,e,!1);break;case Vp.LENGTH:{const r=hf(t,i,e);Up.DICTIONARY===e.logicalStreamType.lengthType?s=r:Up.SYMBOL===e.logicalStreamType.lengthType?l=r:u=r;break}case Vp.DATA:{const r=t.subarray(i.get(),i.get()+e.byteLength);i.add(e.byteLength);const n=e.logicalStreamType.dictionaryType;jp.FSST===n?c=r:jp.SINGLE===n||jp.SHARED===n?o=r:jp.NONE===n&&(d=r);break}}}return function(e,t,i,r,n,s,a){return t?new Qf(e,i,r,n,s,t,a):null}(e,c,a,s,o,l,n??h)??function(e,t,i,r,n){return t?n?new Jf(e,i,r,t,n):new Jf(e,i,r,t):null}(e,o,a,s,n??h)??function(e,t,i,r,n){if(!t||!i)return null;if(r)return n?new Jf(e,r,t,i,n):new Jf(e,r,t,i);if(n&&n.size()!==t.length-1){const r=new Int32Array(n.size());let s=0;for(let e=0;e<n.size();e++)r[e]=n.get(e)?s++:0;return new Jf(e,r,t,i,n)}return n?new Kf(e,t,i,n):new Kf(e,t,i)}(e,u,d,a,n??h)}(s.name,t,i,s.nullable?e-1:e,a);case 0:return function(e,t,i,r,n){const s=of(e,t),a=s.numValues,o=t.get(),l=tm(n)?function(e,t,i,r){const n=Wf(e,Math.ceil(t/8),i),s=new lf(n,t),a=r.size(),o=new lf(new Uint8Array(a),a);let l=0;for(let e=0;e<r.size();e++){const t=!!r.get(e)&&s.get(l++);o.set(e,t)}return o.getBuffer()}(e,a,t,n):qf(e,a,t);t.set(o+s.byteLength);const c=new lf(l,a);return new Gf(i.name,c,n)}(t,i,s,0,l);case 6:case 5:return function(e,t,i,r,n){const s=of(e,t),a=yf(s,r,e,t),o=5===n.physicalType;if(a===Gp.FLAT){const n=tm(r)?function(e,t,i,r,n){return function(e,t,i,r){switch(t.logicalLevelTechnique1){case Bp.DELTA:return t.logicalLevelTechnique2===Bp.RLE&&(e=tf(e,t.runs,t.numRleValues)),function(e,t){const i=new BigInt64Array(e.size());let r=0;e.get(0)?(i[0]=e.get(0)?t[0]>>1n^-(1n&t[0]):0n,r=1):i[0]=0n;let n=1;for(;n!=i.length;++n)i[n]=e.get(n)?i[n-1]+(t[r]>>1n^-(1n&t[r++])):i[n-1];return i}(r,e);case Bp.RLE:return function(e,t,i,r){const n=t;return i?function(e,t,i){const r=new BigInt64Array(e.size());let n=0;for(let s=0;s<i;s++){const a=Number(t[s]);let o=t[s+i];o=o>>1n^-(1n&o);for(let t=n;t<n+a;t++)e.get(t)?r[t]=o:(r[t]=0n,n++);n+=a}return r}(r,e,n.runs):function(e,t,i){const r=new BigInt64Array(e.size());let n=0;for(let s=0;s<i;s++){const a=Number(t[s]),o=t[s+i];for(let t=n;t<n+a;t++)e.get(t)?r[t]=o:(r[t]=0n,n++);n+=a}return r}(r,e,n.runs)}(e,t,i,r);case Bp.NONE:return e=i?function(e,t){const i=new BigInt64Array(e.size());let r=0,n=0;for(;n!=i.length;++n)if(e.get(n)){const e=t[r++];i[n]=e>>1n^-(1n&e)}else i[n]=0n;return i}(r,e):function(e,t){const i=new BigInt64Array(e.size());let r=0,n=0;for(;n!=i.length;++n)i[n]=e.get(n)?t[r++]:0n;return i}(r,e),e;default:throw new Error("The specified Logical level technique is not supported")}}(Hp(e,t,i.numValues),i,r,n)}(e,t,s,o,r):mf(e,t,s,o);return new xf(i.name,n,r)}if(a===Gp.SEQUENCE){const r=ff(e,t,s);return new vf(i.name,r[0],r[1],s.numRleValues)}{const n=_f(e,t,s,o);return new $f(i.name,n,r)}}(t,i,s,l,n);case 7:return function(e,t,i,r){const n=of(e,t),s=tm(r)?function(e,t,i,r){const n=t.get(),s=n+r*Float32Array.BYTES_PER_ELEMENT,a=new Uint8Array(e.subarray(n,s)).buffer,o=new Float32Array(a);t.set(s);const l=i.size(),c=new Float32Array(l);let h=0;for(let e=0;e<l;e++)c[e]=i.get(e)?o[h++]:0;return c}(e,t,r,n.numValues):function(e,t,i){const r=t.get(),n=r+i*Float32Array.BYTES_PER_ELEMENT,s=new Uint8Array(e.subarray(r,n)).buffer,a=new Float32Array(s);return t.set(n),a}(e,t,n.numValues);return new Zf(i.name,s,r)}(t,i,s,l);case 8:return function(e,t,i,r){const n=of(e,t),s=tm(r)?function(e,t,i,r){const n=t.get(),s=n+r*Float64Array.BYTES_PER_ELEMENT,a=new Uint8Array(e.subarray(n,s)).buffer,o=new Float64Array(a);t.set(s);const l=i.size(),c=new Float64Array(l);let h=0;for(let e=0;e<l;e++)c[e]=i.get(e)?o[h++]:0;return c}(e,t,r,n.numValues):function(e,t,i){const r=t.get(),n=r+i*Float64Array.BYTES_PER_ELEMENT,s=new Uint8Array(e.subarray(r,n)).buffer,a=new Float64Array(s);return t.set(n),a}(e,t,n.numValues);return new zp(i.name,s,r)}(t,i,s,l);default:throw new Error(`The specified data type for the field is currently not supported: ${n}`)}}(r,e,t,n,i.scalarType,i):1!=r?null:function(e,t,i,r){let n=null,s=null,a=null,o=null,l=!1;for(;!l;){const i=of(e,t);switch(i.physicalStreamType){case Vp.LENGTH:Up.DICTIONARY===i.logicalStreamType.lengthType?n=hf(e,t,i):a=hf(e,t,i);break;case Vp.DATA:jp.SINGLE===i.logicalStreamType.dictionaryType||jp.SHARED===i.logicalStreamType.dictionaryType?(s=e.subarray(t.get(),t.get()+i.byteLength),l=!0):o=e.subarray(t.get(),t.get()+i.byteLength),t.add(i.byteLength)}}const c=i.complexType.children,h=[];let u=0;for(const l of c){const c=Wp(e,t,1)[0];if(0==c)continue;const d=`${i.name}${"default"===l.name?"":":"+l.name}`;if(2!==c||"scalarField"!==l.type||9!==l.scalarField.physicalType)throw new Error("Currently only optional string fields are implemented for a struct.");const p=of(e,t),f=qf(e,p.numValues,t),m=of(e,t),_=m.decompressedCount!==r?gf(e,t,m,!1,new lf(f,p.numValues)):cf(e,t,m,!1);h[u++]=o?new Qf(d,_,n,s,a,o,new lf(f,p.numValues)):new Jf(d,_,n,s,new lf(f,p.numValues))}return h}(e,t,i,n)}function tm(e){return e instanceof lf}function im(e){if("id"===e.name)return!1;if("scalarType"===e.type){const t=e.scalarType;if("physicalType"===t.type)switch(t.physicalType){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:default:return!1;case 9:return!0}else if("logicalType"===t.type)return!1}else if("complexType"===e.type){const t=e.complexType;if("physicalType"===t.type)switch(t.physicalType){case 0:case 1:return!0;default:return!1}}return console.warn("Unexpected column type in hasStreamCount",e),!1}const rm=new TextDecoder;function nm(e,t){const i=Wp(e,t,1)[0];if(0===i)return"";const r=t.get(),n=e.subarray(r,r+i);return t.add(i),rm.decode(n)}function sm(e,t){const i=Wp(e,t,1)[0]>>>0,r=!!(4&i),n=!!(2&i),s=Wp(e,t,1)[0]>>>0,a={};if(1&i&&(a.nullable=!0),n){const n={};if(r?(n.type="logicalType",n.logicalType=s):(n.type="physicalType",n.physicalType=s),8&i){const i=Wp(e,t,1)[0]>>>0;n.children=new Array(i);for(let r=0;r<i;r++)n.children[r]=sm(e,t)}a.type="complexField",a.complexField=n}else{const e={};r?(e.type="logicalType",e.logicalType=s):(e.type="physicalType",e.physicalType=s),a.type="scalarField",a.scalarField=e}return a}function am(e,t){const i=Wp(e,t,1)[0]>>>0,r=function(e){switch(e){case 0:case 1:case 2:case 3:{const t={};t.nullable=!!(1&e),t.columnScope=0;const i={};return i.physicalType=e>1?6:4,i.type="physicalType",t.scalarType=i,t.type="scalarType",t}case 4:{const e={nullable:!1,columnScope:0},t={type:"physicalType",physicalType:0};return e.type="complexType",e.complexType=t,e}case 30:{const e={nullable:!1,columnScope:0},t={type:"physicalType",physicalType:1};return e.type="complexType",e.complexType=t,e}default:return function(e){let t=null;switch(e){case 10:case 11:t=0;break;case 12:case 13:t=1;break;case 14:case 15:t=2;break;case 16:case 17:t=3;break;case 18:case 19:t=4;break;case 20:case 21:t=5;break;case 22:case 23:t=6;break;case 24:case 25:t=7;break;case 26:case 27:t=8;break;case 28:case 29:t=9;break;default:return null}const i={};i.nullable=!!(1&e),i.columnScope=0;const r={type:"physicalType"};return r.physicalType=t,i.type="scalarType",i.scalarType=r,i}(e)}}(i);if(!r)throw new Error(`Unsupported column type code: ${i}`);if(function(e){return e>=10}(i)?r.name=nm(e,t):i>=0&&i<=3?r.name="id":4===i&&(r.name="geometry"),function(e){return 30===e}(i)){const i=Wp(e,t,1)[0]>>>0,n=r.complexType;n.children=new Array(i);for(let r=0;r<i;r++)n.children[r]=sm(e,t)}return r}function om(e,t){const i={featureTables:[]},r={};r.name=nm(e,t);const n=Wp(e,t,1)[0]>>>0,s=Wp(e,t,1)[0]>>>0;r.columns=new Array(s);for(let i=0;i<s;i++)r.columns[i]=am(e,t);return i.featureTables.push(r),[i,n]}function lm(e,t,i,r,n,s,a=!1){const o=t.scalarType.physicalType,l=yf(n,s,e,i);if(4===o)switch(l){case Gp.FLAT:{const t=cf(e,i,n,!1);return new Ap(r,t,s)}case Gp.SEQUENCE:{const t=pf(e,i,n);return new Rp(r,t[0],t[1],n.numRleValues)}case Gp.CONST:{const t=df(e,i,n,!1);return new kp(r,t,s)}}else switch(l){case Gp.FLAT:{if(a){const t=function(e,t,i,r){const n=function(e,t,i){const r=new Float64Array(t);for(let n=0;n<t;n++)r[n]=Xp(e,i);return r}(e,i.numValues,t);return function(e,t,i){switch(t.logicalLevelTechnique1){case Bp.DELTA:return t.logicalLevelTechnique2===Bp.RLE&&(e=rf(e,t.runs,t.numRleValues)),function(e){e[0]=e[0]%2==1?(e[0]+1)/-2:e[0]/2;const t=e.length/4*4;let i=1;if(t>=4)for(;i<t-4;i+=4){const t=e[i],r=e[i+1],n=e[i+2],s=e[i+3];e[i]=(t%2==1?(t+1)/-2:t/2)+e[i-1],e[i+1]=(r%2==1?(r+1)/-2:r/2)+e[i],e[i+2]=(n%2==1?(n+1)/-2:n/2)+e[i+1],e[i+3]=(s%2==1?(s+1)/-2:s/2)+e[i+2]}for(;i!=e.length;++i)e[i]=(e[i]%2==1?(e[i]+1)/-2:e[i]/2)+e[i-1]}(e),e;case Bp.RLE:return function(e,t,i){return i?function(e,t,i){const r=new Float64Array(i);let n=0;for(let i=0;i<t;i++){const s=e[i];let a=e[i+t];a=a%2==1?(a+1)/-2:a/2,r.fill(a,n,n+s),n+=s}return r}(e,t.runs,t.numRleValues):rf(e,t.runs,t.numRleValues)}(e,t,i);case Bp.NONE:return e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}(n,i,r)}(e,i,n,!1);return new zp(r,t,s)}const t=mf(e,i,n,!1);return new xf(r,t,s)}case Gp.SEQUENCE:{const t=ff(e,i,n);return new vf(r,t[0],t[1],n.numRleValues)}case Gp.CONST:{const t=_f(e,i,n,!1);return new $f(r,t,s)}}throw new Error("Vector type not supported for id column.")}class cm{constructor(e,t){var i;switch(this._featureData=e,this.properties=this._featureData.properties||{},null===(i=this._featureData.geometry)||void 0===i?void 0:i.type){case Zp.POINT:case Zp.MULTIPOINT:this.type=1;break;case Zp.LINESTRING:case Zp.MULTILINESTRING:this.type=2;break;case Zp.POLYGON:case Zp.MULTIPOLYGON:this.type=3;break;default:this.type=0}this.extent=t,this.id=Number(this._featureData.id)}loadGeometry(){const e=[];for(const t of this._featureData.geometry.coordinates){const i=[];for(const e of t)i.push(new s(e.x,e.y));e.push(i)}return e}}class hm{constructor(e){this.features=[],this.featureTable=e,this.name=e.name,this.extent=e.extent,this.version=2,this.features=e.getFeatures(),this.length=this.features.length}feature(e){return new cm(this.features[e],this.extent)}}class um{constructor(e){this.layers={};const t=function(e,t,i=!0){const r=new Fp(0),n=[];for(;r.get()<e.length;){const t=Wp(e,r,1)[0]>>>0,s=r.get()+t;if(s>e.length)throw new Error(`Block overruns tile: ${s} > ${e.length}`);if(1!=Wp(e,r,1)[0]>>>0){r.set(s);continue}const a=om(e,r),o=a[1],l=a[0].featureTables[0];let c=null,h=null;const u=[];let d=0;for(const t of l.columns){const n=t.name;if("id"===n){let s=null;if(t.nullable){const t=of(e,r),i=r.get(),n=qf(e,t.numValues,r);r.set(i+t.byteLength),s=new lf(n,t.numValues)}const a=of(e,r);d=a.decompressedCount,c=lm(e,t,r,n,a,s??d,i)}else if("geometry"===n){const t=Wp(e,r,1)[0];if(0===d){const t=r.get();d=of(e,r).decompressedCount,r.set(t)}h=jf(e,t,r,d)}else{const i=im(t)?Wp(e,r,1)[0]:1;if(0===i&&"scalarType"===t.type)continue;const n=em(e,r,t,i,d);if(n)if(Array.isArray(n))for(const e of n)u.push(e);else u.push(n)}}const p=new Lp(l.name,h,c,u,o);n.push(p),r.set(s)}return n}(new Uint8Array(e));this.layers=t.reduce(((e,t)=>Object.assign(Object.assign({},e),{[t.name]:new hm(t)})),{})}}const dm="_geojsonTileLayer";function pm(e,t,i,r,n){return Ee(e,((e,s)=>{const a=t instanceof Ua?t.get(s):null;return a&&a.evaluate?a.evaluate(i,r,n):a}))}function fm(e,t){return t-e}ya("FeatureIndex",class{constructor(e,t){this.tileID=e,this.x=e.canonical.x,this.y=e.canonical.y,this.z=e.canonical.z,this.grid=new _a(Q,16,0),this.grid3D=new _a(Q,16,0),this.featureIndexArray=new No,this.promoteId=t}insert(e,t,i,r,n,s){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(i,r,n);const o=s?this.grid3D:this.grid;for(let e=0;e<t.length;e++){const i=t[e],r=[1/0,1/0,-1/0,-1/0];for(let e=0;e<i.length;e++){const t=i[e];r[0]=Math.min(r[0],t.x),r[1]=Math.min(r[1],t.y),r[2]=Math.max(r[2],t.x),r[3]=Math.max(r[3],t.y)}r[0]<Q&&r[1]<Q&&r[2]>=0&&r[3]>=0&&o.insert(a,r[0],r[1],r[2],r[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers="mlt"!==this.encoding?new $h(new Eu(this.rawTileData)).layers:new um(this.rawTileData).layers,this.sourceLayerCoder=new Ip(this.vtLayers?Object.keys(this.vtLayers).sort():[dm])),this.vtLayers}query(e,t,i,r){this.loadVTLayers();const n=e.params,a=Q/e.tileSize/e.scale,o=bs(n.filter,n.globalState),l=e.queryGeometry,c=e.queryPadding*a,h=vp.fromPoints(l),u=this.grid.query(h.minX-c,h.minY-c,h.maxX+c,h.maxY+c),d=vp.fromPoints(e.cameraQueryGeometry).expandBy(c),p=this.grid3D.query(d.minX,d.minY,d.maxX,d.maxY,((t,i,r,n)=>function(e,t,i,r,n){for(const s of e)if(t<=s.x&&i<=s.y&&r>=s.x&&n>=s.y)return!0;const a=[new s(t,i),new s(t,n),new s(r,n),new s(r,i)];if(e.length>2)for(const t of a)if(uc(e,t))return!0;for(let t=0;t<e.length-1;t++)if(dc(e[t],e[t+1],a))return!0;return!1}(e.cameraQueryGeometry,t-c,i-c,r+c,n+c)));for(const e of p)u.push(e);u.sort(fm);const f={};let m;for(let s=0;s<u.length;s++){const c=u[s];if(c===m)continue;m=c;const h=this.featureIndexArray.get(c);let d=null;this.loadMatchingFeature(f,h.bucketIndex,h.sourceLayerIndex,h.featureIndex,o,n.layers,n.availableImages,t,i,r,((t,i,r)=>(d||(d=Kl(t)),i.queryIntersectsFeature({queryGeometry:l,feature:t,featureState:r,geometry:d,zoom:this.z,transform:e.transform,pixelsToTileUnits:a,pixelPosMatrix:e.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:e.getElevation}))))}return f}loadMatchingFeature(e,t,i,r,n,s,a,o,l,c,h){const u=this.bucketLayerIDs[t];if(s&&!u.some((e=>s.has(e))))return;const d=this.sourceLayerCoder.decode(i),p=this.vtLayers[d].feature(r);if(n.needGeometry){const e=Jl(p,!0);if(!n.filter(new Da(this.tileID.overscaledZ),e,this.tileID.canonical))return}else if(!n.filter(new Da(this.tileID.overscaledZ),p))return;const f=this.getId(p,d);for(let t=0;t<u.length;t++){const i=u[t];if(s&&!s.has(i))continue;const n=o[i];if(!n)continue;let d={};f&&c&&(d=c.getState(n.sourceLayer||dm,f));const m=we({},l[i]);m.paint=pm(m.paint,n.paint,p,d,a),m.layout=pm(m.layout,n.layout,p,d,a);const _=!h||h(p,n,d);if(!_)continue;const g=new Mp(p,this.z,this.x,this.y,f);g.layer=m;let y=e[i];void 0===y&&(y=e[i]=[]),y.push({featureIndex:r,feature:g,intersectionZ:_})}}lookupSymbolFeatures(e,t,i,r,n,s,a,o){const l={};this.loadVTLayers();const c=bs(n.filterSpec,n.globalState);for(const n of e)this.loadMatchingFeature(l,i,r,n,c,s,a,o,t);return l}hasLayer(e){for(const t of this.bucketLayerIDs)for(const i of t)if(e===i)return!0;return!1}getId(e,t){var i;let r=e.id;return this.promoteId&&(r=e.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[t]],"boolean"==typeof r&&(r=Number(r)),void 0===r&&(null===(i=e.properties)||void 0===i?void 0:i.cluster)&&this.promoteId&&(r=Number(e.properties.cluster_id))),r}},{omit:["rawTileData","sourceLayerCoder"]});const mm="RTLPluginLoaded";class _m extends Pt{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=Vd()}_syncState(e){return this.status=e,this.dispatcher.broadcast("SRPS",{pluginStatus:e,pluginURL:this.url}).catch((e=>{throw this.status="error",e}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null}setRTLTextPlugin(e){return n(this,arguments,void 0,(function*(e,t=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=tt.resolveURL(e),!this.url)throw new Error(`requested url ${e} is invalid`);if("unavailable"===this.status){if(!t)return this._requestImport();this.status="deferred",this._syncState(this.status)}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return n(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new Tt(mm))}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport()}}let gm=null;function ym(){return gm||(gm=new _m),gm}var xm,vm;!function(e){e[e.Base=0]="Base",e[e.Parent=1]="Parent"}(xm||(xm={})),function(e){e[e.Departing=0]="Departing",e[e.Incoming=1]="Incoming"}(vm||(vm={}));class bm{constructor(e,t){this.timeAdded=0,this.fadeEndTime=0,this.fadeOpacity=1,this.tileID=e,this.uid=Pe(),this.uses=0,this.tileSize=t,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading"}isRenderable(e){return this.hasData()&&(!this.fadeEndTime||this.fadeOpacity>0)&&(e||!this.holdingForSymbolFade())}setCrossFadeLogic({fadingRole:e,fadingDirection:t,fadingParentID:i,fadeEndTime:r}){this.resetFadeLogic(),this.fadingRole=e,this.fadingDirection=t,this.fadingParentID=i,this.fadeEndTime=r}setSelfFadeLogic(e){this.resetFadeLogic(),this.selfFading=!0,this.fadeEndTime=e}resetFadeLogic(){this.fadingRole=null,this.fadingDirection=null,this.fadingParentID=null,this.selfFading=!1,this.timeAdded=rt(),this.fadeEndTime=0,this.fadeOpacity=1}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(e){this.demTexture&&e.saveTileTexture(this.demTexture),this.demTexture=null}loadVectorData(e,t,i){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",e){e.featureIndex&&(this.latestFeatureIndex=e.featureIndex,e.rawTileData?(this.latestRawTileData=e.rawTileData,this.latestFeatureIndex.rawTileData=e.rawTileData,this.latestFeatureIndex.encoding=e.encoding):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData,this.latestFeatureIndex.encoding=this.latestEncoding)),this.collisionBoxArray=e.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const r of e){const e=r.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){r.layers=e,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.id]=r}}return i}(e.buckets,null==t?void 0:t.style),this.hasSymbolBuckets=!1;for(const e in this.buckets){const t=this.buckets[e];if(t instanceof rd){if(this.hasSymbolBuckets=!0,!i)break;t.justReloaded=!0}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const e in this.buckets){const t=this.buckets[e];if(t instanceof rd&&t.hasRTLText){this.hasRTLText=!0,ym().lazyLoad();break}}this.queryPadding=0;for(const e in this.buckets){const i=this.buckets[e];this.queryPadding=Math.max(this.queryPadding,t.style.getLayer(e).queryRadius(i))}e.imageAtlas&&(this.imageAtlas=e.imageAtlas),e.glyphAtlasImage&&(this.glyphAtlasImage=e.glyphAtlasImage),this.dashPositions=e.dashPositions}else this.collisionBoxArray=new zo}unloadVectorData(){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.dashPositions&&(this.dashPositions=null),this.latestFeatureIndex=null,this.state="unloaded"}getBucket(e){return this.buckets[e.id]}upload(e){for(const t in this.buckets){const i=this.buckets[t];i.uploadPending()&&i.upload(e)}const t=e.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Gc(e,this.imageAtlas.image,t.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Gc(e,this.glyphAtlasImage,t.ALPHA),this.glyphAtlasImage=null)}prepare(e){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture)}queryRenderedFeatures(e,t,i,r,n,s,a,o,l,c,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:r,cameraQueryGeometry:n,scale:s,tileSize:this.tileSize,pixelPosMatrix:c,transform:o,params:a,queryPadding:this.queryPadding*l,getElevation:h},e,t,i):{}}querySourceFeatures(e,t){const i=this.latestFeatureIndex;if(!i||!i.rawTileData)return;const r=i.loadVTLayers(),n=t&&t.sourceLayer?t.sourceLayer:"",s=r[dm]||r[n];if(!s)return;const a=bs(null==t?void 0:t.filter,null==t?void 0:t.globalState),{z:o,x:l,y:c}=this.tileID.canonical,h={z:o,x:l,y:c};for(let t=0;t<s.length;t++){const r=s.feature(t);if(a.needGeometry){const e=Jl(r,!0);if(!a.filter(new Da(this.tileID.overscaledZ),e,this.tileID.canonical))continue}else if(!a.filter(new Da(this.tileID.overscaledZ),r))continue;const u=i.getId(r,n),d=new Mp(r,o,l,c,u);d.tile=h,e.push(d)}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(e){const t=this.expirationTime;if(e.cacheControl){const t=function(e){const t={};if(e.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((e,i,r,n)=>{const s=r||n;return t[i]=!s||s.toLowerCase(),""})),t["max-age"]){const e=parseInt(t["max-age"],10);isNaN(e)?delete t["max-age"]:t["max-age"]=e}return t}(e.cacheControl);t["max-age"]&&(this.expirationTime=Date.now()+1e3*t["max-age"])}else e.expires&&(this.expirationTime=new Date(e.expires).getTime());if(this.expirationTime){const e=Date.now();let i=!1;if(this.expirationTime>e)i=!1;else if(t)if(this.expirationTime<t)i=!0;else{const r=this.expirationTime-t;r?this.expirationTime=e+Math.max(r,3e4):i=!0}else i=!0;i?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(e,t){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(e).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!t.style.hasLayer(r))continue;const n=this.buckets[r],s=n.layers[0].sourceLayer||dm,a=i[s],o=e[s];if(!a||!o||0===Object.keys(o).length)continue;n.update(o,a,this.imageAtlas&&this.imageAtlas.patternPositions||{},this.dashPositions||{});const l=t&&t.style&&t.style.getLayer(r);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(n)))}}holdingForSymbolFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<rt()}clearSymbolFadeHold(){this.symbolFadeHoldUntil=void 0}setSymbolHoldDuration(e){this.symbolFadeHoldUntil=rt()+e}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return!0}return!1}}class wm{constructor(e,t){this.max=e,this.onRemove=t,this.reset()}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const r=e.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const n={value:t,timeout:void 0};if(void 0!==i&&(n.timeout=setTimeout((()=>{this.remove(e,n)}),i)),this.data[r].push(n),this.order.push(r),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e)}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,r=void 0===t?0:this.data[i].indexOf(t),n=this.data[i][r];return this.data[i].splice(r,1),n.timeout&&clearTimeout(n.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(n.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e)}return this}filter(e){const t=[];for(const i in this.data)for(const r of this.data[i])e(r.value)||t.push(r);for(const e of t)this.remove(e.value.tileID,e)}}class Tm{constructor(){this.state={},this.stateChanges={},this.deletedStates={}}updateState(e,t,i){const r=String(t);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][r]=this.stateChanges[e][r]||{},we(this.stateChanges[e][r],i),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==r&&(this.deletedStates[e][t]=null)}else if(this.deletedStates[e]&&null===this.deletedStates[e][r]){this.deletedStates[e][r]={};for(const t in this.state[e][r])i[t]||(this.deletedStates[e][r][t]=null)}else for(const t in i)this.deletedStates[e]&&this.deletedStates[e][r]&&null===this.deletedStates[e][r][t]&&delete this.deletedStates[e][r][t]}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const r=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][r]&&(this.deletedStates[e][r]=this.deletedStates[e][r]||{},this.deletedStates[e][r][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][r])for(i in this.deletedStates[e][r]={},this.stateChanges[e][r])this.deletedStates[e][r][i]=null;else this.deletedStates[e][r]=null;else this.deletedStates[e]=null}getState(e,t){const i=String(t),r=we({},(this.state[e]||{})[i],(this.stateChanges[e]||{})[i]);if(null===this.deletedStates[e])return{};if(this.deletedStates[e]){const i=this.deletedStates[e][t];if(null===i)return{};for(const e in i)delete r[e]}return r}initializeTileState(e,t){e.setFeatureState(this.state,t)}coalesceChanges(e,t){const i={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const t={};for(const i in this.stateChanges[e])this.state[e][i]||(this.state[e][i]={}),we(this.state[e][i],this.stateChanges[e][i]),t[i]=this.state[e][i];i[e]=t}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const t={};if(null===this.deletedStates[e])for(const i in this.state[e])t[i]={},this.state[e][i]={};else for(const i in this.deletedStates[e]){if(null===this.deletedStates[e][i])this.state[e][i]={};else for(const t of Object.keys(this.deletedStates[e][i]))delete this.state[e][i][t];t[i]=this.state[e][i]}i[e]=i[e]||{},we(i[e],t)}this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length&&e.setFeatureState(i,t)}}const Sm=89.25;function Pm(e,t){const i=ve(t.lat,-85.051129,$e);return new s(Yd(t.lng)*e,Kd(i)*e)}function Im(e,t){return new ip(t.x/e,t.y/e).toLngLat()}function Mm(e){return e.cameraToCenterDistance*Math.min(.85*Math.tan(je(90-e.pitch)),Math.tan(je(Sm-e.pitch)))}function Em(e,t){const i=e.canonical,r=t/Ie(i.z),n=i.x+Math.pow(2,i.z)*e.wrap,s=y(new Float64Array(16));return b(s,s,[n*r,i.y*r,0]),w(s,s,[r/Q,r/Q,1]),s}function Cm(e,t,i,r,n){const s=ip.fromLngLat(e,t),a=n*Jd(1,e.lat),{x:o,y:l,z:c}=Am(i,r);return new ip(s.x+a*-o,s.y+a*-l,s.z+a*-c)}function Am(e,t){const i=je(e),r=je(t),n=Math.cos(-i),s=Math.sin(i);return{x:s*Math.sin(r),y:-s*Math.cos(r),z:n}}function zm(e,t,i){const r=t.intersectsFrustum(e);if(!i||0===r)return r;const n=t.intersectsPlane(i);return 0===n?0:2===r&&2===n?2:1}function Dm(e,t,i){let r=0;const n=(i-t)/10;for(let s=0;s<10;s++)r+=n*Math.pow(Math.cos(t+(s+.5)/10*(i-t)),e);return r}function Rm(e,t){return function(i,r,n,s,a){const o=2*((e-1)/Me(Math.cos(je(Sm-a))/Math.cos(je(Sm)))-1),l=Math.acos(n/s),c=2*Dm(o-1,0,je(a/2)),h=Math.min(je(Sm),l+je(a/2)),u=Dm(o-1,Math.min(h,l-je(a/2)),h),d=Math.atan(r/n);let p=i;return p+=Me(s/Math.hypot(r,n)/Math.max(.5,Math.cos(je(a/2)))),p+=o*Me(Math.cos(d))/2,p-=Me(Math.max(1,u/c/t))/2,p}}const km=Rm(9.314,3);function Lm(e,t){const i=(t.roundZoom?Math.round:Math.floor)(e.zoom+Me(e.tileSize/t.tileSize));return Math.max(0,i)}function Fm(e,t){const i=e.getCameraFrustum(),r=e.getClippingPlane(),n=e.screenPointToMercatorCoordinate(e.getCameraPoint()),s=ip.fromLngLat(e.center,e.elevation);n.z=s.z+Math.cos(e.pitchInRadians)*e.cameraToCenterDistance/e.worldSize;const a=e.getCoveringTilesDetailsProvider(),o=a.allowVariableZoom(e,t),l=Lm(e,t),c=t.minzoom||0,h=void 0!==t.maxzoom?t.maxzoom:e.maxZoom,u=Math.min(Math.max(0,l),h),d=Math.pow(2,u),p=[d*n.x,d*n.y,0],f=[d*s.x,d*s.y,0],m=Math.hypot(s.x-n.x,s.y-n.y),_=Math.abs(s.z-n.z),g=Math.hypot(m,_),y=e=>({zoom:0,x:0,y:0,wrap:e,fullyVisible:!1}),x=[],v=[];if(e.renderWorldCopies&&a.allowWorldCopies())for(let e=1;e<=3;e++)x.push(y(-e)),x.push(y(e));for(x.push(y(0));x.length>0;){const d=x.pop(),m=d.x,y=d.y;let b=d.fullyVisible;const w={x:m,y:y,z:d.zoom},T=a.getTileBoundingVolume(w,d.wrap,e.elevation,t);if(!b){const e=zm(i,T,r);if(0===e)continue;b=2===e}const S=a.distanceToTile2d(n.x,n.y,w,T);let P=l;o&&(P=(t.calculateTileZoom||km)(e.zoom+Me(e.tileSize/t.tileSize),S,_,g,e.fov)),P=(t.roundZoom?Math.round:Math.floor)(P),P=Math.max(0,P);const I=Math.min(P,h);if(d.wrap=a.getWrap(s,w,d.wrap),d.zoom>=I){if(d.zoom<c)continue;const e=u-d.zoom,i=p[0]-.5-(m<<e),r=p[1]-.5-(y<<e),n=t.reparseOverscaled?Math.max(d.zoom,P):d.zoom;v.push({tileID:new hp(d.zoom===h?n:d.zoom,d.wrap,d.zoom,m,y),distanceSq:J([f[0]-.5-m,f[1]-.5-y]),tileDistanceToCamera:Math.sqrt(i*i+r*r)})}else for(let e=0;e<4;e++)x.push({zoom:d.zoom+1,x:(m<<1)+e%2,y:(y<<1)+(e>>1),wrap:d.wrap,fullyVisible:b})}return v.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}const Bm=vp.fromPoints([new s(0,0),new s(Q,Q)]);function Om(e){return"raster"===e||"image"===e||"video"===e}function Vm(e,t,i,r,n,s,a){if(!t.hasData())return!1;const{tileID:o,fadingRole:l,fadingDirection:c,fadingParentID:h}=t;if(l===xm.Base&&c===vm.Incoming&&h)return i[h.key]=h,!0;const u=Math.max(o.overscaledZ-n,s);for(let n=o.overscaledZ-1;n>=u;n--){const s=o.scaledTo(n),l=e.getLoadedTile(s);if(l)return t.setCrossFadeLogic({fadingRole:xm.Base,fadingDirection:vm.Incoming,fadingParentID:l.tileID,fadeEndTime:r+a}),l.setCrossFadeLogic({fadingRole:xm.Parent,fadingDirection:vm.Departing,fadeEndTime:r+a}),i[s.key]=s,!0}return!1}function jm(e,t,i,r,n,s){if(!t.hasData())return!1;const a=t.tileID.children(n);let o=Nm(e,t,a,i,r,n,s);if(o)return!0;for(const l of a)Nm(e,t,l.children(n),i,r,n,s)&&(o=!0);return o}function Nm(e,t,i,r,n,s,a){if(i[0].overscaledZ>=s)return!1;let o=!1;for(const s of i){const i=e.getLoadedTile(s);if(!i)continue;const{fadingRole:l,fadingDirection:c,fadingParentID:h}=i;l===xm.Base&&c===vm.Departing&&h||(i.setCrossFadeLogic({fadingRole:xm.Base,fadingDirection:vm.Departing,fadingParentID:t.tileID,fadeEndTime:n+a}),t.setCrossFadeLogic({fadingRole:xm.Parent,fadingDirection:vm.Incoming,fadeEndTime:n+a})),r[s.key]=s,o=!0}return o}function Um(e,t,i,r){const n=e.tileID;return!!e.selfFading||!e.hasData()&&!!t.has(n)&&(e.setSelfFadeLogic(i+r),!0)}function Gm(e,t){var i;e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0;let r=t.tileID.canonical.x-e.tileID.canonical.x;const n=t.tileID.canonical.y-e.tileID.canonical.y,s=Math.pow(2,e.tileID.canonical.z),a=t.tileID.key;0===r&&0===n||Math.abs(n)>1||(Math.abs(r)>1&&(1===Math.abs(r+s)?r+=s:1===Math.abs(r-s)&&(r-=s)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,r,n),(null===(i=e.neighboringTiles)||void 0===i?void 0:i[a])&&(e.neighboringTiles[a].backfilled=!0)))}class Zm{constructor(){this._tiles={}}handleWrapJump(e){const t={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+e),t[r.tileID.key]=r}this._tiles=t}setFeatureState(e,t){for(const i in this._tiles)this._tiles[i].setFeatureState(e,t)}getAllTiles(){return Object.values(this._tiles)}getAllIds(e=!1){return e?Object.values(this._tiles).map((e=>e.tileID)).sort(dp).map((e=>e.key)):Object.keys(this._tiles)}getTileById(e){return this._tiles[e]}setTile(e,t){this._tiles[e]=t}deleteTileById(e){delete this._tiles[e]}getLoadedTile(e){const t=this.getTileById(e.key);return(null==t?void 0:t.hasData())?t:null}isIdRenderable(e,t=!1){var i;return null===(i=this.getTileById(e))||void 0===i?void 0:i.isRenderable(t)}getRenderableIds(e=0,t){const i=[];for(const e of this.getAllIds())this.isIdRenderable(e,t)&&i.push(this.getTileById(e));return t?i.sort(((t,i)=>{const r=t.tileID,n=i.tileID,a=new s(r.canonical.x,r.canonical.y)._rotate(-e),o=new s(n.canonical.x,n.canonical.y)._rotate(-e);return r.overscaledZ-n.overscaledZ||o.y-a.y||o.x-a.x})).map((e=>e.tileID.key)):i.map((e=>e.tileID)).sort(dp).map((e=>e.key))}}class $m extends Pt{constructor(e,t,i){super(),this.id=e,this.dispatcher=i,this.on("data",(e=>this._dataHandler(e))),this.on("dataloading",(()=>{this._sourceErrored=!1})),this.on("error",(()=>{this._sourceErrored=this._source.loaded()})),this._source=((e,t,i,r)=>{const n=new(Pp(t.type))(e,t,i,r);if(n.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${n.id}`);return n})(e,t,i,this),this._inViewTiles=new Zm,this._outOfViewCache=new wm(0,(e=>this._unloadTile(e))),this._timers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._rasterFadeDuration=0,this._maxFadingAncestorLevels=5,this._state=new Tm,this._didEmitContent=!1,this._updated=!1}onAdd(e){this.map=e,this._maxTileCacheSize=e?e._maxTileCacheSize:null,this._maxTileCacheZoomLevels=e?e._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(e)}onRemove(e){for(const e of this._inViewTiles.getAllTiles())e.unloadVectorData();this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(e),this._inViewTiles=new Zm}loaded(){if(this._sourceErrored)return!0;if(!this._sourceLoaded)return!1;if(!this._source.loaded())return!1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return!0;if(!this._updated)return!1;for(const e of this._inViewTiles.getAllTiles())if("loaded"!==e.state&&"errored"!==e.state)return!1;return!0}getSource(){return this._source}getState(){return this._state}pause(){this._paused=!0}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform,this.terrain)}_loadTile(e,t,i){return n(this,void 0,void 0,(function*(){try{yield this._source.loadTile(e),this._tileLoaded(e,t,i)}catch(t){e.state="errored",404!==t.status?this._source.fire(new St(t,{tile:e})):this.update(this.transform,this.terrain)}}))}_unloadTile(e){this._source.unloadTile&&this._source.unloadTile(e)}_abortTile(e){this._source.abortTile&&this._source.abortTile(e),this._source.fire(new Tt("dataabort",{tile:e,coord:e.tileID,dataType:"source"}))}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._inViewTiles,this.map?this.map.painter:null);for(const t of this._inViewTiles.getAllTiles())t.upload(e),t.prepare(this.map.style.imageManager)}getIds(){return this._inViewTiles.getAllIds(!0)}getRenderableIds(e){var t;return this._inViewTiles.getRenderableIds(null===(t=this.transform)||void 0===t?void 0:t.bearingInRadians,e)}hasRenderableParent(e){const t=e.overscaledZ-1;if(t>=this._source.minzoom){const i=this.getLoadedTile(e.scaledTo(t));if(i)return this._inViewTiles.isIdRenderable(i.tileID.key)}return!1}reload(e,t=void 0){if(this._paused)this._shouldReloadOnResume=!0;else{this._outOfViewCache.reset();for(const i of this._inViewTiles.getAllIds()){const r=this._inViewTiles.getTileById(i);t&&!this._source.shouldReloadTile(r,t)||(e?this._reloadTile(i,"expired"):"errored"!==r.state&&this._reloadTile(i,"reloading"))}}}_reloadTile(e,t){return n(this,void 0,void 0,(function*(){const i=this._inViewTiles.getTileById(e);i&&("loading"!==i.state&&(i.state=t),yield this._loadTile(i,e,t))}))}_tileLoaded(e,t,i){e.timeAdded=rt(),e.selfFading&&(e.fadeEndTime=e.timeAdded+this._rasterFadeDuration),"expired"===i&&(e.refreshedUponExpiration=!0),this._setTileReloadTimer(t,e),"raster-dem"===this.getSource().type&&e.dem&&function(e,t){var i,r;const n=t.getRenderableIds();for(const s of n){if(!e.neighboringTiles||!e.neighboringTiles[s])continue;const n=t.getTileById(s);e.neighboringTiles[s].backfilled||Gm(e,n),(null===(r=null===(i=n.neighboringTiles)||void 0===i?void 0:i[e.tileID.key])||void 0===r?void 0:r.backfilled)||Gm(n,e)}}(e,this._inViewTiles),this._state.initializeTileState(e,this.map?this.map.painter:null),e.aborted||this._source.fire(new Tt("data",{dataType:"source",tile:e,coord:e.tileID}))}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._inViewTiles.getTileById(e)}_retainLoadedChildren(e,t){const i=this._getLoadedDescendents(t),r=new Set;for(const n of t){const t=i[n.key];if(!(null==t?void 0:t.length)){r.add(n);continue}const s=n.overscaledZ+$m.maxOverzooming,a=t.filter((e=>e.tileID.overscaledZ<=s));if(!a.length){r.add(n);continue}const o=Math.min(...a.map((e=>e.tileID.overscaledZ))),l=a.filter((e=>e.tileID.overscaledZ===o)).map((e=>e.tileID));for(const t of l)e[t.key]=t;this._areDescendentsComplete(l,o,n.overscaledZ)||r.add(n)}return r}_getLoadedDescendents(e){var t;const i={};for(const r of this._inViewTiles.getAllTiles().filter((e=>e.hasData())))for(const n of e)r.tileID.isChildOf(n)&&(i[t=n.key]||(i[t]=[])).push(r);return i}_areDescendentsComplete(e,t,i){return 1===e.length&&e[0].isOverscaled()?e[0].overscaledZ===t:Math.pow(4,t-i)===e.length}getLoadedTile(e){return this._inViewTiles.getLoadedTile(e)}updateCacheSize(e){const t=Math.ceil(e.width/this._source.tileSize)+1,i=Math.ceil(e.height/this._source.tileSize)+1,r=Math.floor(t*i*(null===this._maxTileCacheZoomLevels?st.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._outOfViewCache.setMaxSize(n)}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);this._prevLng=e,t&&(this._inViewTiles.handleWrapJump(t),this._resetTileReloadTimers())}update(e,t){if(!this._sourceLoaded||this._paused)return;let i;this.transform=e,this.terrain=t,this.updateCacheSize(e),this.handleWrapJump(this.transform.center.lng),this.used||this.usedForTerrain?this._source.tileID?i=e.getVisibleUnwrappedCoordinates(this._source.tileID).map((e=>new hp(e.canonical.z,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y))):(i=Fm(e,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:"vector"===this._source.type&&void 0!==this.map._zoomLevelsToOverscale?e.maxZoom-this.map._zoomLevelsToOverscale:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:t,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(i=i.filter((e=>this._source.hasTile(e))))):i=[],this.usedForTerrain&&(i=this._addTerrainIdealTiles(i));const r=0===i.length&&!this._updated&&this._didEmitContent;this._updated=!0,r&&this.fire(new Tt("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const n=Lm(e,this._source),s=this._updateRetainedTiles(i,n),a=Om(this._source.type);a&&this._rasterFadeDuration>0&&!t&&function(e,t,i,r,n,s,a){const o=rt(),l=function(e){if(!e.length)return new Set;const t=Math.max(...e.map((e=>e.canonical.z)));let i=1/0,r=-1/0,n=1/0,s=-1/0;const a=[];for(const o of e){const{x:e,y:l,z:c}=o.canonical,h=Math.pow(2,t-c),u=e*h,d=l*h;a.push({id:o,x:u,y:d}),u<i&&(i=u),u>r&&(r=u),d<n&&(n=d),d>s&&(s=d)}const o=new Set;for(const e of a)e.x!==i&&e.x!==r&&e.y!==n&&e.y!==s||o.add(e.id);return o}(t);for(const c of t){const t=e.getTileById(c.key);t.fadingDirection!==vm.Departing&&0!==t.fadeOpacity||t.resetFadeLogic(),Vm(e,t,i,o,r,n,a)||jm(e,t,i,o,s,a)||Um(t,l,o,a)||t.resetFadeLogic()}}(this._inViewTiles,i,s,this._maxFadingAncestorLevels,this._source.minzoom,this._source.maxzoom,this._rasterFadeDuration),a?this._cleanUpRasterTiles(s):this._cleanUpVectorTiles(s)}_cleanUpRasterTiles(e){for(const t of this._inViewTiles.getAllIds())e[t]||this._removeTile(t)}_cleanUpVectorTiles(e){for(const t of this._inViewTiles.getAllIds()){const i=this._inViewTiles.getTileById(t);e[t]?i.clearSymbolFadeHold():i.hasSymbolBuckets?i.holdingForSymbolFade()?i.symbolFadeFinished()&&this._removeTile(t):i.setSymbolHoldDuration(this.map._fadeDuration):this._removeTile(t)}}_addTerrainIdealTiles(e){const t=[];for(const i of e)if(i.canonical.z>this._source.minzoom){const e=i.scaledTo(i.canonical.z-1);t.push(e);const r=i.scaledTo(Math.max(this._source.minzoom,Math.min(i.canonical.z,5)));t.push(r)}return e.concat(t)}releaseSymbolFadeTiles(){for(const e of this._inViewTiles.getAllIds())this._inViewTiles.getTileById(e).holdingForSymbolFade()&&this._removeTile(e)}_updateRetainedTiles(e,t){var i;const r=new Set;for(const t of e)this._addTile(t).hasData()||r.add(t);const n=e.reduce(((e,t)=>(e[t.key]=t,e)),{}),s=this._retainLoadedChildren(n,r),a={},o=Math.max(t-$m.maxUnderzooming,this._source.minzoom);for(const e of s){let t=this._inViewTiles.getTileById(e.key),r=null==t?void 0:t.wasRequested();for(let s=e.overscaledZ-1;s>=o;--s){const o=e.scaledTo(s);if(a[o.key])break;if(a[o.key]=!0,t=this.getTile(o),!t&&r&&(t=this._addTile(o)),t){const e=t.hasData();if((e||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||r)&&(n[o.key]=o),r=t.wasRequested(),e)break}}}return n}_addTile(e){let t=this._inViewTiles.getTileById(e.key);if(t)return t;t=this._outOfViewCache.getAndRemove(e),t&&(t.resetFadeLogic(),this._setTileReloadTimer(e.key,t),t.tileID=e,this._state.initializeTileState(t,this.map?this.map.painter:null));const i=t;return t||(t=new bm(e,this._source.tileSize*e.overscaleFactor()),this._loadTile(t,e.key,t.state)),t.uses++,this._inViewTiles.setTile(e.key,t),i||this._source.fire(new Tt("dataloading",{tile:t,coord:t.tileID,dataType:"source"})),t}_setTileReloadTimer(e,t){this._clearTileReloadTimer(e);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e]}),i))}_clearTileReloadTimer(e){const t=this._timers[e];t&&(clearTimeout(t),delete this._timers[e])}_resetTileReloadTimers(){for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e of this._inViewTiles.getAllIds()){const t=this._inViewTiles.getTileById(e);this._setTileReloadTimer(e,t)}}refreshTiles(e){for(const t of this._inViewTiles.getAllIds()){const i=this._inViewTiles.getTileById(t);(this._inViewTiles.isIdRenderable(t)||"errored"==i.state)&&e.some((e=>e.equals(i.tileID.canonical)))&&this._reloadTile(t,"expired")}}_removeTile(e){const t=this._inViewTiles.getTileById(e);t&&(t.uses--,this._inViewTiles.deleteTileById(e),this._clearTileReloadTimer(e),t.uses>0||(t.hasData()&&"reloading"!==t.state?this._outOfViewCache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))))}_dataHandler(e){"source"===e.dataType&&("metadata"!==e.sourceDataType?"content"===e.sourceDataType&&this._sourceLoaded&&!this._paused&&(this.reload(e.sourceDataChanged,e.shouldReloadTileOptions),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0):this._sourceLoaded=!0)}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e of this._inViewTiles.getAllIds())this._removeTile(e);this._outOfViewCache.reset()}tilesIn(e,t,i){const r=[],n=this.transform;if(!n)return r;const s=n.getCoveringTilesDetailsProvider().allowWorldCopies(),a=i?n.getCameraQueryGeometry(e):e,o=e=>n.screenPointToMercatorCoordinate(e,this.terrain),l=this.transformBbox(e,o,!s),c=this.transformBbox(a,o,!s),h=this.getIds(),u=vp.fromPoints(c);for(let e=0;e<h.length;e++){const i=this._inViewTiles.getTileById(h[e]);if(i.holdingForSymbolFade())continue;const a=s?[i.tileID]:[i.tileID.unwrapTo(-1),i.tileID.unwrapTo(0)],o=Math.pow(2,n.zoom-i.tileID.overscaledZ),d=t*i.queryPadding*Q/i.tileSize/o;for(const e of a){const t=u.map((t=>e.getTilePoint(new ip(t.x,t.y))));if(t.expandBy(d),t.intersects(Bm)){const t=l.map((t=>e.getTilePoint(t))),n=c.map((t=>e.getTilePoint(t)));r.push({tile:i,tileID:s?e:e.unwrapTo(0),queryGeometry:t,cameraQueryGeometry:n,scale:o})}}}return r}transformBbox(e,t,i){let r=e.map(t);if(i){const i=vp.fromPoints(e);i.shrinkBy(.001*Math.min(i.width(),i.height()));const n=i.map(t);vp.fromPoints(r).covers(n)||(r=r.map((e=>e.x>.5?new ip(e.x-1,e.y,e.z):e)))}return r}getVisibleCoordinates(e){const t=this.getRenderableIds(e).map((e=>this._inViewTiles.getTileById(e).tileID));return this.transform&&this.transform.populateCache(t),t}hasTransition(){return!!this._source.hasTransition()||!(!Om(this._source.type)||!function(e,t){if(t<=0)return!1;const i=rt();for(const t of e.getAllTiles())if(t.fadeEndTime>=i)return!0;return!1}(this._inViewTiles,this._rasterFadeDuration))}setRasterFadeDuration(e){this._rasterFadeDuration=e}setFeatureState(e,t,i){this._state.updateState(e=e||dm,t,i)}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||dm,t,i)}getFeatureState(e,t){return this._state.getState(e=e||dm,t)}setDependencies(e,t,i){const r=this._inViewTiles.getTileById(e);r&&r.setDependencies(t,i)}reloadTilesForDependencies(e,t){for(const i of this._inViewTiles.getAllIds())this._inViewTiles.getTileById(i).hasDependency(e,t)&&this._reloadTile(i,"reloading");this._outOfViewCache.filter((i=>!i.hasDependency(e,t)))}areTilesLoaded(){for(const e of this._inViewTiles.getAllTiles())if("loaded"!==e.state&&"errored"!==e.state)return!1;return!0}}$m.maxUnderzooming=10,$m.maxOverzooming=3;class qm{constructor(e,t){this.reset(e,t)}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding}lerp(e){if(1===this.points.length)return this.points[0];e=ve(e,0,1);let t=1,i=this._distances[t];const r=e*this.paddedLength+this.padding;for(;i<r&&t<this._distances.length;)i=this._distances[++t];const n=t-1,s=this._distances[n],a=i-s,o=a>0?(r-s)/a:0;return this.points[n].mult(1-o).add(this.points[t].mult(o))}}function Wm(e,t){let i=!0;return"always"===e||"never"!==e&&"never"!==t||(i=!1),i}class Hm{constructor(e,t,i){const r=this.boxCells=[],n=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)r.push([]),n.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,r,n){this._forEachCell(t,i,r,n,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}insertCircle(e,t,i,r){this._forEachCell(t-r,i-r,t+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(r)}_insertBoxCell(e,t,i,r,n,s){this.boxCells[n].push(s)}_insertCircleCell(e,t,i,r,n,s){this.circleCells[n].push(s)}_query(e,t,i,r,n,s,a){if(i<0||e>this.width||r<0||t>this.height)return[];const o=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=r){if(n)return[{key:null,x1:e,y1:t,x2:i,y2:r}];for(let e=0;e<this.boxKeys.length;e++)o.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],r=this.circles[3*e+2];o.push({key:this.circleKeys[e],x1:t-r,y1:i-r,x2:t+r,y2:i+r})}}else this._forEachCell(e,t,i,r,this._queryCell,o,{hitTest:n,overlapMode:s,seenUids:{box:{},circle:{}}},a);return o}query(e,t,i,r){return this._query(e,t,i,r,!1,null)}hitTest(e,t,i,r,n,s){return this._query(e,t,i,r,!0,n,s).length>0}hitTestCircle(e,t,i,r,n){const s=e-i,a=e+i,o=t-i,l=t+i;if(a<0||s>this.width||l<0||o>this.height)return!1;const c=[];return this._forEachCell(s,o,a,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:r,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},n),c.length>0}_queryCell(e,t,i,r,n,s,a,o){const{seenUids:l,hitTest:c,overlapMode:h}=a,u=this.boxCells[n];if(null!==u){const n=this.bboxes;for(const a of u)if(!l.box[a]){l.box[a]=!0;const u=4*a,d=this.boxKeys[a];if(e<=n[u+2]&&t<=n[u+3]&&i>=n[u+0]&&r>=n[u+1]&&(!o||o(d))&&(!c||!Wm(h,d.overlapMode))&&(s.push({key:d,x1:n[u],y1:n[u+1],x2:n[u+2],y2:n[u+3]}),c))return!0}}const d=this.circleCells[n];if(null!==d){const n=this.circles;for(const a of d)if(!l.circle[a]){l.circle[a]=!0;const u=3*a,d=this.circleKeys[a];if(this._circleAndRectCollide(n[u],n[u+1],n[u+2],e,t,i,r)&&(!o||o(d))&&(!c||!Wm(h,d.overlapMode))){const e=n[u],t=n[u+1],i=n[u+2];if(s.push({key:d,x1:e-i,y1:t-i,x2:e+i,y2:t+i}),c)return!0}}}return!1}_queryCellCircle(e,t,i,r,n,s,a,o){const{circle:l,seenUids:c,overlapMode:h}=a,u=this.boxCells[n];if(null!==u){const e=this.bboxes;for(const t of u)if(!c.box[t]){c.box[t]=!0;const i=4*t,r=this.boxKeys[t];if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!o||o(r))&&!Wm(h,r.overlapMode))return s.push(!0),!0}}const d=this.circleCells[n];if(null!==d){const e=this.circles;for(const t of d)if(!c.circle[t]){c.circle[t]=!0;const i=3*t,r=this.circleKeys[t];if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!o||o(r))&&!Wm(h,r.overlapMode))return s.push(!0),!0}}}_forEachCell(e,t,i,r,n,s,a,o){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(r);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(n.call(this,e,t,i,r,this.xCellCount*l+d,s,a,o))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,r,n,s){const a=r-e,o=n-t,l=i+s;return l*l>a*a+o*o}_circleAndRectCollide(e,t,i,r,n,s,a){const o=(s-r)/2,l=Math.abs(e-(r+o));if(l>o+i)return!1;const c=(a-n)/2,h=Math.abs(t-(n+c));if(h>c+i)return!1;if(l<=o||h<=c)return!0;const u=l-o,d=h-c;return u*u+d*d<=i*i}}function Xm(e,t,i){const r=_();if(!e){const{vecSouth:e,vecEast:i}=Km(t),u=f();u[0]=i[0],u[1]=i[1],u[2]=e[0],u[3]=e[1],n=u,(h=(a=(s=u)[0])*(c=s[3])-(l=s[2])*(o=s[1]))&&(n[0]=c*(h=1/h),n[1]=-o*h,n[2]=-l*h,n[3]=a*h),r[0]=u[0],r[1]=u[1],r[4]=u[2],r[5]=u[3]}var n,s,a,o,l,c,h;return w(r,r,[1/i,1/i,1]),r}function Ym(e,t,i,r){if(e){const e=_();if(!t){const{vecSouth:t,vecEast:r}=Km(i);e[0]=r[0],e[1]=r[1],e[4]=t[0],e[5]=t[1]}return w(e,e,[r,r,1]),e}return i.pixelsToClipSpaceMatrix}function Km(e){const t=Math.cos(e.rollInRadians),i=Math.sin(e.rollInRadians),r=Math.cos(e.pitchInRadians),n=Math.cos(e.bearingInRadians),s=Math.sin(e.bearingInRadians),a=W();a[0]=-n*r*i-s*t,a[1]=-s*r*i+n*t;const o=Y(a);o<1e-9?K(a):X(a,a,1/o);const l=W();l[0]=n*r*t-s*i,l[1]=s*r*t+n*i;const c=Y(l);return c<1e-9?K(l):X(l,l,1/c),{vecEast:l,vecSouth:a}}function Jm(e,t,i,r){let n;r?(n=[e,t,r(e,t),1],Z(n,n,i)):(n=[e,t,0,1],m_(n,n,i));const a=n[3];return{point:new s(n[0]/a,n[1]/a),signedDistanceFromCamera:a,isOccluded:!1}}function Qm(e,t){return.5+e/t*.5}function e_(e,t){return e.x>=-t[0]&&e.x<=t[0]&&e.y>=-t[1]&&e.y<=t[1]}function t_(e,t,i,r,n,a,o,l,c,h,u,d,p){const f=i?e.textSizeData:e.iconSizeData,m=Xu(f,t.transform.zoom),_=[256/t.width*2+1,256/t.height*2+1],g=i?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;g.clear();const y=e.lineVertexArray,x=i?e.text.placedSymbolArray:e.icon.placedSymbolArray,v=t.transform.width/t.transform.height;let b=!1;for(let i=0;i<x.length;i++){const w=x.get(i);if(w.hidden||w.writingMode===$u.vertical&&!b){f_(w.numGlyphs,g);continue}b=!1;const T=new s(w.anchorX,w.anchorY),S={getElevation:p,pitchedLabelPlaneMatrix:r,lineVertexArray:y,pitchWithMap:a,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:t.transform,tileAnchorPoint:T,unwrappedTileID:c,width:h,height:u,translation:d},P=c_(w.anchorX,w.anchorY,S);if(!e_(P.point,_)){f_(w.numGlyphs,g);continue}const I=Qm(t.transform.cameraToCenterDistance,P.signedDistanceFromCamera),M=Hu(f,m,w),E=a?M*t.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,c)/I:M*I,C=n_({projectionContext:S,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:E,flip:!1,keepUpright:o,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:l});b=C.useVertical,(C.notEnoughRoom||b||C.needsFlipping&&n_({projectionContext:S,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:E,flip:!0,keepUpright:o,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:l}).notEnoughRoom)&&f_(w.numGlyphs,g)}i?e.text.dynamicLayoutVertexBuffer.updateData(g):e.icon.dynamicLayoutVertexBuffer.updateData(g)}function i_(e,t,i,r,n,s,a,o){const l=s.glyphStartIndex+s.numGlyphs,c=s.lineStartIndex,h=s.lineStartIndex+s.lineLength,u=t.getoffsetX(s.glyphStartIndex),d=t.getoffsetX(l-1),p=d_(e*u,i,r,n,s.segment,c,h,o,a);if(!p)return null;const f=d_(e*d,i,r,n,s.segment,c,h,o,a);return f?o.projectionCache.anyProjectionOccluded?null:{first:p,last:f}:null}function r_(e,t,i,r){return e===$u.horizontal&&Math.abs(i.y-t.y)>Math.abs(i.x-t.x)*r?{useVertical:!0}:(e===$u.vertical?t.y<i.y:t.x>i.x)?{needsFlipping:!0}:null}function n_(e){const{projectionContext:t,pitchedLabelPlaneMatrixInverse:i,symbol:r,fontSize:n,flip:a,keepUpright:o,glyphOffsetArray:l,dynamicLayoutVertexArray:c,aspectRatio:h,rotateToLine:u}=e,d=n/24,p=r.lineOffsetX*d,f=r.lineOffsetY*d;let m;if(r.numGlyphs>1){const e=r.glyphStartIndex+r.numGlyphs,n=r.lineStartIndex,s=r.lineStartIndex+r.lineLength,c=i_(d,l,p,f,a,r,u,t);if(!c)return{notEnoughRoom:!0};const _=l_(c.first.point.x,c.first.point.y,t,i),g=l_(c.last.point.x,c.last.point.y,t,i);if(o&&!a){const e=r_(r.writingMode,_,g,h);if(e)return e}m=[c.first];for(let i=r.glyphStartIndex+1;i<e-1;i++){const e=d_(d*l.getoffsetX(i),p,f,a,r.segment,n,s,t,u);if(!e)return{notEnoughRoom:!0};m.push(e)}m.push(c.last)}else{if(o&&!a){const e=o_(t.tileAnchorPoint.x,t.tileAnchorPoint.y,t).point,n=r.lineStartIndex+r.segment+1,a=new s(t.lineVertexArray.getx(n),t.lineVertexArray.gety(n)),o=o_(a.x,a.y,t),l=o.signedDistanceFromCamera>0?o.point:s_(t.tileAnchorPoint,a,e,1,t),c=l_(e.x,e.y,t,i),u=l_(l.x,l.y,t,i),d=r_(r.writingMode,c,u,h);if(d)return d}const e=d_(d*l.getoffsetX(r.glyphStartIndex),p,f,a,r.segment,r.lineStartIndex,r.lineStartIndex+r.lineLength,t,u);if(!e||t.projectionCache.anyProjectionOccluded)return{notEnoughRoom:!0};m=[e]}for(const e of m)Qu(c,e.point,e.angle);return{}}function s_(e,t,i,r,n){const s=e.add(e.sub(t)._unit()),a=o_(s.x,s.y,n).point,o=i.sub(a);return i.add(o._mult(r/o.mag()))}function a_(e,t,i){const r=t.projectionCache;if(r.projections[e])return r.projections[e];const n=new s(t.lineVertexArray.getx(e),t.lineVertexArray.gety(e)),a=o_(n.x,n.y,t);if(a.signedDistanceFromCamera>0)return r.projections[e]=a.point,r.anyProjectionOccluded=r.anyProjectionOccluded||a.isOccluded,a.point;const o=e-i.direction;return s_(0===i.distanceFromAnchor?t.tileAnchorPoint:new s(t.lineVertexArray.getx(o),t.lineVertexArray.gety(o)),n,i.previousVertex,i.absOffsetX-i.distanceFromAnchor+1,t)}function o_(e,t,i){const r=e+i.translation[0],n=t+i.translation[1];let s;return i.pitchWithMap?(s=Jm(r,n,i.pitchedLabelPlaneMatrix,i.getElevation),s.isOccluded=!1):(s=i.transform.projectTileCoordinates(r,n,i.unwrappedTileID,i.getElevation),s.point.x=(.5*s.point.x+.5)*i.width,s.point.y=(.5*-s.point.y+.5)*i.height),s}function l_(e,t,i,r){if(i.pitchWithMap){const n=[e,t,0,1];return Z(n,n,r),i.transform.projectTileCoordinates(n[0]/n[3],n[1]/n[3],i.unwrappedTileID,i.getElevation).point}return{x:e/i.width*2-1,y:1-t/i.height*2}}function c_(e,t,i){return i.transform.projectTileCoordinates(e,t,i.unwrappedTileID,i.getElevation)}function h_(e,t,i){return e._unit()._perp()._mult(t*i)}function u_(e,t,i,r,n,a,o,l,c){if(l.projectionCache.offsets[e])return l.projectionCache.offsets[e];const h=i.add(t);if(e+c.direction<r||e+c.direction>=n)return l.projectionCache.offsets[e]=h,h;const u=a_(e+c.direction,l,c),d=h_(u.sub(i),o,c.direction),p=i.add(d),f=u.add(d);return l.projectionCache.offsets[e]=function(e,t,i,r){const n=t.y-e.y,a=t.x-e.x,o=r.y-i.y,l=r.x-i.x,c=o*a-l*n;if(0===c)return null;const h=(l*(e.y-i.y)-o*(e.x-i.x))/c;return new s(e.x+h*a,e.y+h*n)}(a,h,p,f)||h,l.projectionCache.offsets[e]}function d_(e,t,i,r,n,s,a,o,l){const c=r?e-t:e+t;let h=c>0?1:-1,u=0;r&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let d,p=h>0?s+n:s+n+1;o.projectionCache.cachedAnchorPoint?d=o.projectionCache.cachedAnchorPoint:(d=o_(o.tileAnchorPoint.x,o.tileAnchorPoint.y,o).point,o.projectionCache.cachedAnchorPoint=d);let f,m,_=d,g=d,y=0,x=0;const v=Math.abs(c),b=[];let w;for(;y+x<=v;){if(p+=h,p<s||p>=a)return null;y+=x,g=_,m=f;const e={absOffsetX:v,direction:h,distanceFromAnchor:y,previousVertex:g};if(_=a_(p,o,e),0===i)b.push(g),w=_.sub(g);else{let t;const r=_.sub(g);t=0===r.mag()?h_(a_(p+h,o,e).sub(_),i,h):h_(r,i,h),m||(m=g.add(t)),f=u_(p,t,_,s,a,m,i,o,e),b.push(m),w=f.sub(m)}x=w.mag()}const T=w._mult((v-y)/x)._add(m||g),S=u+Math.atan2(_.y-g.y,_.x-g.x);return b.push(T),{point:T,angle:l?S:0,path:b}}const p_=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function f_(e,t){for(let i=0;i<e;i++){const e=t.length;t.resize(e+4),t.float32.set(p_,3*e)}}function m_(e,t,i){const r=t[0],n=t[1];return e[0]=i[0]*r+i[4]*n+i[12],e[1]=i[1]*r+i[5]*n+i[13],e[3]=i[3]*r+i[7]*n+i[15],e}const __=100;class g_{constructor(e,t=new Hm(e.width+200,e.height+200,25),i=new Hm(e.width+200,e.height+200,25)){this.transform=e,this.grid=t,this.ignoredGrid=i,this.pitchFactor=Math.cos(e.pitch*Math.PI/180)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+__,this.screenBottomBoundary=e.height+__,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.perspectiveRatioCutoff=.6}placeCollisionBox(e,t,i,r,n,s,a,o,l,c,h,u){const d=this.projectAndGetPerspectiveRatio(e.anchorPointX+o[0],e.anchorPointY+o[1],n,c,u),p=i*d.perspectiveRatio;let f;if(s||a)f=this._projectCollisionBox(e,p,r,n,s,a,o,d,c,h,u);else{const t=d.x+(h?h.x*p:0),i=d.y+(h?h.y*p:0);f={allPointsOccluded:!1,box:[t+e.x1*p,i+e.y1*p,t+e.x2*p,i+e.y2*p]}}const[m,_,g,y]=f.box,x=s?f.allPointsOccluded:d.isOccluded;let v=x;return v||(v=d.perspectiveRatio<this.perspectiveRatioCutoff),v||(v=!this.isInsideGrid(m,_,g,y)),v||"always"!==t&&this.grid.hitTest(m,_,g,y,t,l)?{box:[m,_,g,y],placeable:!1,offscreen:!1,occluded:x}:{box:[m,_,g,y],placeable:!0,offscreen:this.isOffscreen(m,_,g,y),occluded:x}}placeCollisionCircles(e,t,i,r,n,a,o,l,c,h,u,d,p,f){const m=[],_=new s(t.anchorX,t.anchorY),g=this.getPerspectiveRatio(_.x,_.y,a,f),y=(c?n*this.transform.getPitchedTextCorrection(t.anchorX,t.anchorY,a)/g:n*g)/24,x={getElevation:f,pitchedLabelPlaneMatrix:o,lineVertexArray:i,pitchWithMap:c,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:_,unwrappedTileID:a,width:this.transform.width,height:this.transform.height,translation:p},v=i_(y,r,t.lineOffsetX*y,t.lineOffsetY*y,!1,t,!1,x);let b=!1,w=!1,T=!0;if(v){const t=.5*u*g+d,i=new s(-100,-100),r=new s(this.screenRightBoundary,this.screenBottomBoundary),n=new qm,a=v.first,o=v.last;let p=[];for(let e=a.path.length-1;e>=1;e--)p.push(a.path[e]);for(let e=1;e<o.path.length;e++)p.push(o.path[e]);const f=2.5*t;if(c){const e=this.projectPathToScreenSpace(p,x);p=e.some((e=>e.signedDistanceFromCamera<=0))?[]:e.map((e=>e.point))}let _=[];if(p.length>0){const e=p[0].clone(),t=p[0].clone();for(let i=1;i<p.length;i++)e.x=Math.min(e.x,p[i].x),e.y=Math.min(e.y,p[i].y),t.x=Math.max(t.x,p[i].x),t.y=Math.max(t.y,p[i].y);_=e.x>=i.x&&t.x<=r.x&&e.y>=i.y&&t.y<=r.y?[p]:t.x<i.x||e.x>r.x||t.y<i.y||e.y>r.y?[]:function(e,t,i,r,n){const a=[];for(let o=0;o<e.length;o++){const l=e[o];let c;for(let e=0;e<l.length-1;e++){let o=l[e],h=l[e+1];o.x<t&&h.x<t||(o.x<t?o=new s(t,o.y+(t-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x<t&&(h=new s(t,o.y+(t-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y<i&&h.y<i||(o.y<i?o=new s(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round():h.y<i&&(h=new s(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round()),o.x>=r&&h.x>=r||(o.x>=r?o=new s(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x>=r&&(h=new s(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y>=n&&h.y>=n||(o.y>=n?o=new s(o.x+(n-o.y)/(h.y-o.y)*(h.x-o.x),n)._round():h.y>=n&&(h=new s(o.x+(n-o.y)/(h.y-o.y)*(h.x-o.x),n)._round()),c&&o.equals(c[c.length-1])||(c=[o],a.push(c)),c.push(h)))))}}return a}([p],i.x,i.y,r.x,r.y)}for(const i of _){n.reset(i,.25*t);let r=0;r=n.length<=.5*t?1:Math.ceil(n.paddedLength/f)+1;for(let i=0;i<r;i++){const s=i/Math.max(r-1,1),a=n.lerp(s),o=a.x+__,c=a.y+__;m.push(o,c,t,0);const u=o-t,d=c-t,p=o+t,f=c+t;if(T=T&&this.isOffscreen(u,d,p,f),w=w||this.isInsideGrid(u,d,p,f),"always"!==e&&this.grid.hitTestCircle(o,c,t,e,h)&&(b=!0,!l))return{circles:[],offscreen:!1,collisionDetected:b}}}}return{circles:!l&&b||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:b}}projectPathToScreenSpace(e,t){const i=function(e,t){const i=_();return x(i,t.pitchedLabelPlaneMatrix),e.map((e=>{const r=Jm(e.x,e.y,i,t.getElevation),n=t.transform.projectTileCoordinates(r.point.x,r.point.y,t.unwrappedTileID,t.getElevation);return n.point.x=(.5*n.point.x+.5)*t.width,n.point.y=(.5*-n.point.y+.5)*t.height,n}))}(e,t);return function(e){let t=0,i=0,r=0,n=0;for(let s=0;s<e.length;s++)e[s].isOccluded?(r=s+1,n=0):(n++,n>i&&(i=n,t=r));return e.slice(t,t+i)}(i)}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return{};const t=[],i=new vp;for(const r of e){const e=new s(r.x+__,r.y+__);i.extend(e),t.push(e)}const{minX:r,minY:n,maxX:a,maxY:o}=i,l=this.grid.query(r,n,a,o).concat(this.ignoredGrid.query(r,n,a,o)),c={},h={};for(const e of l){const i=e.key;void 0===c[i.bucketInstanceId]&&(c[i.bucketInstanceId]={}),c[i.bucketInstanceId][i.featureIndex]||ic(t,[new s(e.x1,e.y1),new s(e.x2,e.y1),new s(e.x2,e.y2),new s(e.x1,e.y2)])&&(c[i.bucketInstanceId][i.featureIndex]=!0,void 0===h[i.bucketInstanceId]&&(h[i.bucketInstanceId]=[]),h[i.bucketInstanceId].push(i.featureIndex))}return h}insertCollisionBox(e,t,i,r,n,s){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:r,featureIndex:n,collisionGroupID:s,overlapMode:t},e[0],e[1],e[2],e[3])}insertCollisionCircles(e,t,i,r,n,s){const a=i?this.ignoredGrid:this.grid,o={bucketInstanceId:r,featureIndex:n,collisionGroupID:s,overlapMode:t};for(let t=0;t<e.length;t+=4)a.insertCircle(o,e[t],e[t+1],e[t+2])}projectAndGetPerspectiveRatio(e,t,i,r,n){if(n){let i;r?(i=[e,t,r(e,t),1],Z(i,i,n)):(i=[e,t,0,1],m_(i,i,n));const s=i[3];return{x:(i[0]/s+1)/2*this.transform.width+__,y:(-i[1]/s+1)/2*this.transform.height+__,perspectiveRatio:.5+this.transform.cameraToCenterDistance/s*.5,isOccluded:!1,signedDistanceFromCamera:s}}{const n=this.transform.projectTileCoordinates(e,t,i,r);return{x:(n.point.x+1)/2*this.transform.width+__,y:(1-n.point.y)/2*this.transform.height+__,perspectiveRatio:.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5,isOccluded:n.isOccluded,signedDistanceFromCamera:n.signedDistanceFromCamera}}}getPerspectiveRatio(e,t,i,r){const n=this.transform.projectTileCoordinates(e,t,i,r);return.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5}isOffscreen(e,t,i,r){return i<__||e>=this.screenRightBoundary||r<__||t>this.screenBottomBoundary}isInsideGrid(e,t,i,r){return i>=0&&e<this.gridRightBoundary&&r>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const e=y([]);return b(e,e,[-100,-100,0]),e}_projectCollisionBox(e,t,i,r,n,a,o,l,c,h,u){let d=1,p=0,f=0,m=1;const _=e.anchorPointX+o[0],g=e.anchorPointY+o[1];if(a&&!n){const e=this.projectAndGetPerspectiveRatio(_+1,g,r,c,u),t=e.x-l.x,i=Math.atan((e.y-l.y)/t)+(t<0?Math.PI:0),n=Math.sin(i),s=Math.cos(i);d=s,p=n,f=-n,m=s}else if(!a&&n){const e=Km(this.transform);d=e.vecEast[0],p=e.vecEast[1],f=e.vecSouth[0],m=e.vecSouth[1]}let y=l.x,x=l.y,v=t;n&&(y=_,x=g,v=Math.pow(2,-(this.transform.zoom-i.overscaledZ)),v*=this.transform.getPitchedTextCorrection(_,g,r),h||(v*=ve(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(y+=d*h.x*v+f*h.y*v,x+=p*h.x*v+m*h.y*v);const b=e.x1*v,w=e.x2*v,T=(b+w)/2,S=e.y1*v,P=e.y2*v,I=(S+P)/2,M=[{offsetX:b,offsetY:S},{offsetX:T,offsetY:S},{offsetX:w,offsetY:S},{offsetX:w,offsetY:I},{offsetX:w,offsetY:P},{offsetX:T,offsetY:P},{offsetX:b,offsetY:P},{offsetX:b,offsetY:I}];let E=[];for(const{offsetX:e,offsetY:t}of M)E.push(new s(y+d*e+f*t,x+p*e+m*t));let C=!1;if(n){const e=E.map((e=>this.projectAndGetPerspectiveRatio(e.x,e.y,r,c,u)));C=e.some((e=>!e.isOccluded)),E=e.map((e=>new s(e.x,e.y)))}else C=!0;return{box:_e(E),allPointsOccluded:!C}}}class y_ extends s{constructor(e,t,i,r){super(e,t),this.angle=i,void 0!==r&&(this.segment=r)}clone(){return new y_(this.x,this.y,this.angle,this.segment)}}var x_;ya("Anchor",y_),function(e){e[e.center=1]="center",e[e.left=2]="left",e[e.right=3]="right",e[e.top=4]="top",e[e.bottom=5]="bottom",e[e["top-left"]=6]="top-left",e[e["top-right"]=7]="top-right",e[e["bottom-left"]=8]="bottom-left",e[e["bottom-right"]=9]="bottom-right"}(x_||(x_={}));class v_{constructor(e,t,i,r){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):r&&i?1:0,this.placed=i}isHidden(){return 0===this.opacity&&!this.placed}}class b_{constructor(e,t,i,r,n){this.text=new v_(e?e.text:null,t,i,n),this.icon=new v_(e?e.icon:null,t,r,n)}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class w_{constructor(e,t,i){this.text=e,this.icon=t,this.skipFade=i}}class T_{constructor(e,t,i,r,n){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=n}}class S_{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={}}get(e){if(this.crossSourceCollisions)return{ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t}}return this.collisionGroups[e]}}function P_(e,t,i,r,n){const{horizontalAlign:a,verticalAlign:o}=qu(e);return new s(-(a-.5)*t+r[0]*n,-(o-.5)*i+r[1]*n)}class I_{constructor(e,t,i,r,n){this.transform=e.clone(),this.terrain=t,this.collisionIndex=new g_(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new S_(r),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=n,n&&(n.prevPlacement=void 0),this.placedOrientations={}}_getTerrainElevationFunc(e){const t=this.terrain;return t?(i,r)=>t.getElevation(e,i,r):null}getBucketParts(e,t,i,r){const n=i.getBucket(t),s=i.latestFeatureIndex;if(!n||!s||t.id!==n.layerIds[0])return;const a=i.collisionBoxArray,o=n.layers[0].layout,l=n.layers[0].paint,c=Math.pow(2,this.transform.zoom-i.tileID.overscaledZ),h=i.tileSize/Q,u=i.tileID.toUnwrapped(),d="map"===o.get("text-rotation-alignment"),p=ee(i,1,this.transform.zoom),f=ae(this.collisionIndex.transform,i,l.get("text-translate"),l.get("text-translate-anchor")),m=ae(this.collisionIndex.transform,i,l.get("icon-translate"),l.get("icon-translate-anchor")),_=Xm(d,this.transform,p);this.retainedQueryData[n.bucketInstanceId]=new T_(n.bucketInstanceId,s,n.sourceLayerIndex,n.index,i.tileID);const g={bucket:n,layout:o,translationText:f,translationIcon:m,unwrappedTileID:u,pitchedLabelPlaneMatrix:_,scale:c,textPixelRatio:h,holdingForFade:i.holdingForSymbolFade(),collisionBoxArray:a,partiallyEvaluatedTextSize:Xu(n.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const t of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n}=t;e.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n,parameters:g})}else e.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:g})}attemptAnchorPlacement(e,t,i,r,n,s,a,o,l,c,h,u,d,p,f,m,_,g,y,x){const v=x_[e.textAnchor],b=[e.textOffset0,e.textOffset1],w=P_(v,i,r,b,n),T=this.collisionIndex.placeCollisionBox(t,u,o,l,c,a,s,m,h.predicate,y,w,x);if((!g||this.collisionIndex.placeCollisionBox(g,u,o,l,c,a,s,_,h.predicate,y,w,x).placeable)&&T.placeable){let e;if(this.prevPlacement&&this.prevPlacement.variableOffsets[d.crossTileID]&&this.prevPlacement.placements[d.crossTileID]&&this.prevPlacement.placements[d.crossTileID].text&&(e=this.prevPlacement.variableOffsets[d.crossTileID].anchor),0===d.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[d.crossTileID]={textOffset:b,width:i,height:r,anchor:v,textBoxScale:n,prevAnchor:e},this.markUsedJustification(p,v,d,f),p.allowVerticalPlacement&&(this.markUsedOrientation(p,f,d),this.placedOrientations[d.crossTileID]=f),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(e,t,i){const{bucket:r,layout:n,translationText:s,translationIcon:a,unwrappedTileID:o,pitchedLabelPlaneMatrix:l,textPixelRatio:c,holdingForFade:h,collisionBoxArray:u,partiallyEvaluatedTextSize:d,collisionGroup:p}=e.parameters,f=n.get("text-optional"),m=n.get("icon-optional"),_=Yu(n,"text-overlap","text-allow-overlap"),g="always"===_,y=Yu(n,"icon-overlap","icon-allow-overlap"),x="always"===y,v="map"===n.get("text-rotation-alignment"),b="map"===n.get("text-pitch-alignment"),w="none"!==n.get("icon-text-fit"),T="viewport-y"===n.get("symbol-z-order"),S=g&&(x||!r.hasIconData()||m),P=x&&(g||!r.hasTextData()||f);!r.collisionArrays&&u&&r.deserializeCollisionBoxes(u);const I=this.retainedQueryData[r.bucketInstanceId].tileID,M=this._getTerrainElevationFunc(I),E=this.transform.getFastPathSimpleProjectionMatrix(I),C=(e,u,x)=>{var T,C;if(t[e.crossTileID])return;if(h)return void(this.placements[e.crossTileID]=new w_(!1,!1,!1));let A=!1,z=!1,D=!0,R=null,k={box:null,placeable:!1,offscreen:null,occluded:!1},L={placeable:!1},F=null,B=null,O=null,V=0,j=0,N=0;u.textFeatureIndex?V=u.textFeatureIndex:e.useRuntimeCollisionCircles&&(V=e.featureIndex),u.verticalTextFeatureIndex&&(j=u.verticalTextFeatureIndex);const U=u.textBox;if(U){const t=t=>{let i=$u.horizontal;if(r.allowVerticalPlacement&&!t&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[e.crossTileID];t&&(this.placedOrientations[e.crossTileID]=t,i=t,this.markUsedOrientation(r,i,e))}return i},n=(t,i)=>{if(r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&u.verticalTextBox){for(const e of r.writingModes)if(e===$u.vertical?(k=i(),L=k):k=t(),k&&k.placeable)break}else k=t()},l=e.textAnchorOffsetStartIndex,h=e.textAnchorOffsetEndIndex;if(h===l){const i=(t,i)=>{const n=this.collisionIndex.placeCollisionBox(t,_,c,I,o,b,v,s,p.predicate,M,void 0,E);return n&&n.placeable&&(this.markUsedOrientation(r,i,e),this.placedOrientations[e.crossTileID]=i),n};n((()=>i(U,$u.horizontal)),(()=>{const t=u.verticalTextBox;return r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&t?i(t,$u.vertical):{box:null,offscreen:null}})),t(k&&k.placeable)}else{let d=x_[null===(C=null===(T=this.prevPlacement)||void 0===T?void 0:T.variableOffsets[e.crossTileID])||void 0===C?void 0:C.anchor];const f=(t,n,u)=>{const f=t.x2-t.x1,m=t.y2-t.y1,g=e.textBoxScale,x=w&&"never"===y?n:null;let T=null,S="never"===_?1:2,P="never";d&&S++;for(let i=0;i<S;i++){for(let i=l;i<h;i++){const n=r.textAnchorOffsets.get(i);if(d&&n.textAnchor!==d)continue;const l=this.attemptAnchorPlacement(n,t,f,m,g,v,b,c,I,o,p,P,e,r,u,s,a,x,M);if(l&&(T=l.placedGlyphBoxes,T&&T.placeable))return A=!0,R=l.shift,T}d?d=null:P=_}return i&&!T&&(T={box:this.collisionIndex.placeCollisionBox(U,"always",c,I,o,b,v,s,p.predicate,M,void 0,E).box,offscreen:!1,placeable:!1,occluded:!1}),T};n((()=>f(U,u.iconBox,$u.horizontal)),(()=>{const t=u.verticalTextBox;return r.allowVerticalPlacement&&(!k||!k.placeable)&&e.numVerticalGlyphVertices>0&&t?f(t,u.verticalIconBox,$u.vertical):{box:null,occluded:!0,offscreen:null}})),k&&(A=k.placeable,D=k.offscreen);const m=t(k&&k.placeable);if(!A&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[e.crossTileID];t&&(this.variableOffsets[e.crossTileID]=t,this.markUsedJustification(r,t.anchor,e,m))}}}if(F=k,A=F&&F.placeable,D=F&&F.offscreen,e.useRuntimeCollisionCircles&&e.centerJustifiedTextSymbolIndex>=0){const t=r.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex),a=Hu(r.textSizeData,d,t),c=n.get("text-padding");B=this.collisionIndex.placeCollisionCircles(_,t,r.lineVertexArray,r.glyphOffsetArray,a,o,l,i,b,p.predicate,e.collisionCircleDiameter,c,s,M),B.circles.length&&B.collisionDetected&&!i&&Re("Collisions detected, but collision boxes are not shown"),A=g||B.circles.length>0&&!B.collisionDetected,D=D&&B.offscreen}if(u.iconFeatureIndex&&(N=u.iconFeatureIndex),u.iconBox){const e=e=>this.collisionIndex.placeCollisionBox(e,y,c,I,o,b,v,a,p.predicate,M,w&&R?R:void 0,E);L&&L.placeable&&u.verticalIconBox?(O=e(u.verticalIconBox),z=O.placeable):(O=e(u.iconBox),z=O.placeable),D=D&&O.offscreen}const G=f||0===e.numHorizontalGlyphVertices&&0===e.numVerticalGlyphVertices,Z=m||0===e.numIconVertices;G||Z?Z?G||(z=z&&A):A=z&&A:z=A=z&&A;const $=z&&O.placeable;if(A&&F.placeable&&this.collisionIndex.insertCollisionBox(F.box,_,n.get("text-ignore-placement"),r.bucketInstanceId,L&&L.placeable&&j?j:V,p.ID),$&&this.collisionIndex.insertCollisionBox(O.box,y,n.get("icon-ignore-placement"),r.bucketInstanceId,N,p.ID),B&&A&&this.collisionIndex.insertCollisionCircles(B.circles,_,n.get("text-ignore-placement"),r.bucketInstanceId,V,p.ID),i&&this.storeCollisionData(r.bucketInstanceId,x,u,F,O,B),0===e.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[e.crossTileID]=new w_((A||S)&&!(null==F?void 0:F.occluded),(z||P)&&!(null==O?void 0:O.occluded),D||r.justReloaded),t[e.crossTileID]=!0};if(T){if(0!==e.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const t=r.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let e=t.length-1;e>=0;--e){const i=t[e];C(r.symbolInstances.get(i),r.collisionArrays[i],i)}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)C(r.symbolInstances.get(t),r.collisionArrays[t],t);r.justReloaded=!1}storeCollisionData(e,t,i,r,n,s){if(i.textBox||i.iconBox){let s,a;this.collisionBoxArrays.has(e)?s=this.collisionBoxArrays.get(e):(s=new Map,this.collisionBoxArrays.set(e,s)),s.has(t)?a=s.get(t):(a={text:null,icon:null},s.set(t,a)),i.textBox&&(a.text=r.box),i.iconBox&&(a.icon=n.box)}if(s){let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=[]);for(let e=0;e<s.circles.length;e+=4)t.push(s.circles[e+0]-__),t.push(s.circles[e+1]-__),t.push(s.circles[e+2]),t.push(s.collisionDetected?1:0)}}markUsedJustification(e,t,i,r){let n;n=r===$u.vertical?i.verticalPlacedTextSymbolIndex:{left:i.leftJustifiedTextSymbolIndex,center:i.centerJustifiedTextSymbolIndex,right:i.rightJustifiedTextSymbolIndex}[function(e){switch(e){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}(t)];const s=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex,i.verticalPlacedTextSymbolIndex];for(const t of s)t>=0&&(e.text.placedSymbolArray.get(t).crossTileID=n>=0&&t!==n?0:i.crossTileID)}markUsedOrientation(e,t,i){const r=t===$u.horizontal||t===$u.horizontalOnly?t:0,n=t===$u.vertical?t:0,s=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex];for(const t of s)e.text.placedSymbolArray.get(t).placedOrientation=r;i.verticalPlacedTextSymbolIndex&&(e.text.placedSymbolArray.get(i.verticalPlacedTextSymbolIndex).placedOrientation=n)}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const r=t?t.symbolFadeChange(e):1,n=t?t.opacities:{},s=t?t.variableOffsets:{},a=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],s=n[e];s?(this.opacities[e]=new b_(s,r,t.text,t.icon),i=i||t.text!==s.text.placed||t.icon!==s.icon.placed):(this.opacities[e]=new b_(null,r,t.text,t.icon,t.skipFade),i=i||t.text||t.icon)}for(const e in n){const t=n[e];if(!this.opacities[e]){const n=new b_(t,r,!1,!1);n.isHidden()||(this.opacities[e]=n,i=i||t.text.placed||t.icon.placed)}}for(const e in s)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=s[e]);for(const e in a)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=a[e]);if(t&&void 0===t.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e)}updateLayerOpacities(e,t){const i={};for(const r of t){const t=r.getBucket(e);t&&r.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,r.tileID,i,r.collisionBoxArray)}}updateBucketOpacities(e,t,i,r){e.hasTextData()&&(e.text.opacityVertexArray.clear(),e.text.hasVisibleVertices=!1),e.hasIconData()&&(e.icon.opacityVertexArray.clear(),e.icon.hasVisibleVertices=!1),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const n=e.layers[0],a=n.layout,o=new b_(null,0,!1,!1,!0),l=a.get("text-allow-overlap"),c=a.get("icon-allow-overlap"),h=n._unevaluatedLayout.hasValue("text-variable-anchor")||n._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===a.get("text-rotation-alignment"),d="map"===a.get("text-pitch-alignment"),p="none"!==a.get("icon-text-fit"),f=new b_(null,0,l&&(c||!e.hasIconData()||a.get("icon-optional")),c&&(l||!e.hasTextData()||a.get("text-optional")),!0);!e.collisionArrays&&r&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(r);const m=(e,t,i)=>{for(let r=0;r<t/4;r++)e.opacityVertexArray.emplaceBack(i);e.hasVisibleVertices=e.hasVisibleVertices||i!==F_},_=this.collisionBoxArrays.get(e.bucketInstanceId);for(let t=0;t<e.symbolInstances.length;t++){const r=e.symbolInstances.get(t),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:a,crossTileID:l}=r;let c=this.opacities[l];i[l]?c=o:c||(c=f,this.opacities[l]=c),i[l]=!0;const g=r.numIconVertices>0,y=this.placedOrientations[r.crossTileID],x=y===$u.vertical,v=y===$u.horizontal||y===$u.horizontalOnly;if(n>0||a>0){const t=L_(c.text);m(e.text,n,x?F_:t),m(e.text,a,v?F_:t);const i=c.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((t=>{t>=0&&(e.text.placedSymbolArray.get(t).hidden=i||x?1:0)})),r.verticalPlacedTextSymbolIndex>=0&&(e.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||v?1:0);const s=this.variableOffsets[r.crossTileID];s&&this.markUsedJustification(e,s.anchor,r,y);const o=this.placedOrientations[r.crossTileID];o&&(this.markUsedJustification(e,"left",r,o),this.markUsedOrientation(e,o,r))}if(g){const t=L_(c.icon),i=!(p&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(m(e.icon,r.numIconVertices,i?t:F_),e.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=c.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(e.icon,r.numVerticalIconVertices,i?F_:t),e.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=c.icon.isHidden())}const b=_&&_.has(t)?_.get(t):{text:null,icon:null};if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const i=e.collisionArrays[t];if(i){let t=new s(0,0);if(i.textBox||i.verticalTextBox){let r=!0;if(h){const e=this.variableOffsets[l];e?(t=P_(e.anchor,e.width,e.height,e.textOffset,e.textBoxScale),u&&t._rotate(d?-this.transform.bearingInRadians:this.transform.bearingInRadians)):r=!1}if(i.textBox||i.verticalTextBox){let n;i.textBox&&(n=x),i.verticalTextBox&&(n=v),M_(e.textCollisionBox.collisionVertexArray,c.text.placed,!r||n,b.text,t.x,t.y)}}if(i.iconBox||i.verticalIconBox){const r=Boolean(!v&&i.verticalIconBox);let n;i.iconBox&&(n=r),i.verticalIconBox&&(n=!r),M_(e.iconCollisionBox.collisionVertexArray,c.icon.placed,n,b.icon,p?t.x:0,p?t.y:0)}}}}if(e.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.text.opacityVertexArray.length!==e.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${e.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${e.text.layoutVertexArray.length}) / 4`);if(e.icon.opacityVertexArray.length!==e.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${e.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${e.icon.layoutVertexArray.length}) / 4`);e.bucketInstanceId in this.collisionCircleArrays&&(e.collisionCircleArray=this.collisionCircleArrays[e.bucketInstanceId],delete this.collisionCircleArrays[e.bucketInstanceId])}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0}}function M_(e,t,i,r,n,s){r&&0!==r.length||(r=[0,0,0,0]);const a=r[0]-__,o=r[1]-__,l=r[2]-__,c=r[3]-__;e.emplaceBack(t?1:0,i?1:0,n||0,s||0,a,o),e.emplaceBack(t?1:0,i?1:0,n||0,s||0,l,o),e.emplaceBack(t?1:0,i?1:0,n||0,s||0,l,c),e.emplaceBack(t?1:0,i?1:0,n||0,s||0,a,c)}const E_=Math.pow(2,25),C_=Math.pow(2,24),A_=Math.pow(2,17),z_=Math.pow(2,16),D_=Math.pow(2,9),R_=Math.pow(2,8),k_=Math.pow(2,1);function L_(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*E_+t*C_+i*A_+t*z_+i*D_+t*R_+i*k_+t}const F_=0;class B_{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&!e.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[]}continuePlacement(e,t,i,r,n){const s=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(s,r,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,n())return!0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,s.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<s.length;)if(t.placeLayerBucketPart(s[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,n())return!0;return!1}}class O_{constructor(e,t,i,r,n,s,a,o){this.placement=new I_(e,t,s,a,o),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=r,this._showCollisionBoxes=n,this._done=!1}isDone(){return this._done}continuePlacement(e,t,i){const r=rt(),n=()=>!this._forceFullPlacement&&rt()-r>2;for(;this._currentPlacementIndex>=0;){const r=t[e[this._currentPlacementIndex]],s=this.placement.collisionIndex.transform.zoom;if("symbol"===r.type&&(!r.minzoom||r.minzoom<=s)&&(!r.maxzoom||r.maxzoom>s)){if(this._inProgressLayer||(this._inProgressLayer=new B_(r)),this._inProgressLayer.continuePlacement(i[r.source],this.placement,this._showCollisionBoxes,r,n))return;delete this._inProgressLayer}this._currentPlacementIndex--}this._done=!0}commit(e){return this.placement.commit(e),this.placement}}const V_=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class j_{static from(e){if(!(e instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[t,i]=new Uint8Array(e,0,2);if(219!==t)throw new Error("Data does not appear to be in a KDBush format.");const r=i>>4;if(1!==r)throw new Error(`Got v${r} data when expected v1.`);const n=V_[15&i];if(!n)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(e,2,1),[a]=new Uint32Array(e,4,1);return new j_(a,s,n,e)}constructor(e,t=64,i=Float64Array,r){if(isNaN(e)||e<0)throw new Error(`Unpexpected numItems value: ${e}.`);this.numItems=+e,this.nodeSize=Math.min(Math.max(+t,2),65535),this.ArrayType=i,this.IndexArrayType=e<65536?Uint16Array:Uint32Array;const n=V_.indexOf(this.ArrayType),s=2*e*this.ArrayType.BYTES_PER_ELEMENT,a=e*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(n<0)throw new Error(`Unexpected typed array class: ${i}.`);r&&r instanceof ArrayBuffer?(this.data=r,this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+a+o,2*e),this._pos=2*e,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+a+o,2*e),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+n]),new Uint16Array(this.data,2,1)[0]=t,new Uint32Array(this.data,4,1)[0]=e)}add(e,t){const i=this._pos>>1;return this.ids[i]=i,this.coords[this._pos++]=e,this.coords[this._pos++]=t,i}finish(){const e=this._pos>>1;if(e!==this.numItems)throw new Error(`Added ${e} items when expected ${this.numItems}.`);return N_(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(e,t,i,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:s,nodeSize:a}=this,o=[0,n.length-1,0],l=[];for(;o.length;){const c=o.pop()||0,h=o.pop()||0,u=o.pop()||0;if(h-u<=a){for(let a=u;a<=h;a++){const o=s[2*a],c=s[2*a+1];o>=e&&o<=i&&c>=t&&c<=r&&l.push(n[a])}continue}const d=u+h>>1,p=s[2*d],f=s[2*d+1];p>=e&&p<=i&&f>=t&&f<=r&&l.push(n[d]),(0===c?e<=p:t<=f)&&(o.push(u),o.push(d-1),o.push(1-c)),(0===c?i>=p:r>=f)&&(o.push(d+1),o.push(h),o.push(1-c))}return l}within(e,t,i){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:r,coords:n,nodeSize:s}=this,a=[0,r.length-1,0],o=[],l=i*i;for(;a.length;){const c=a.pop()||0,h=a.pop()||0,u=a.pop()||0;if(h-u<=s){for(let i=u;i<=h;i++)$_(n[2*i],n[2*i+1],e,t)<=l&&o.push(r[i]);continue}const d=u+h>>1,p=n[2*d],f=n[2*d+1];$_(p,f,e,t)<=l&&o.push(r[d]),(0===c?e-i<=p:t-i<=f)&&(a.push(u),a.push(d-1),a.push(1-c)),(0===c?e+i>=p:t+i>=f)&&(a.push(d+1),a.push(h),a.push(1-c))}return o}}function N_(e,t,i,r,n,s){if(n-r<=i)return;const a=r+n>>1;U_(e,t,a,r,n,s),N_(e,t,i,r,a-1,1-s),N_(e,t,i,a+1,n,1-s)}function U_(e,t,i,r,n,s){for(;n>r;){if(n-r>600){const a=n-r+1,o=i-r+1,l=Math.log(a),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(a-c)/a)*(o-a/2<0?-1:1);U_(e,t,i,Math.max(r,Math.floor(i-o*c/a+h)),Math.min(n,Math.floor(i+(a-o)*c/a+h)),s)}const a=t[2*i+s];let o=r,l=n;for(G_(e,t,r,i),t[2*n+s]>a&&G_(e,t,r,n);o<l;){for(G_(e,t,o,l),o++,l--;t[2*o+s]<a;)o++;for(;t[2*l+s]>a;)l--}t[2*r+s]===a?G_(e,t,r,l):(l++,G_(e,t,l,n)),l<=i&&(r=l+1),i<=l&&(n=l-1)}}function G_(e,t,i,r){Z_(e,i,r),Z_(t,2*i,2*r),Z_(t,2*i+1,2*r+1)}function Z_(e,t,i){const r=e[t];e[t]=e[i],e[i]=r}function $_(e,t,i,r){const n=e-i,s=t-r;return n*n+s*s}const q_=.03125;class W_{constructor(e,t,i){this.tileID=e,this.bucketInstanceId=i,this._symbolsByKey={};const r=new Map;for(let e=0;e<t.length;e++){const i=t.get(e),n=i.key,s=r.get(n);s?s.push(i):r.set(n,[i])}for(const[e,t]of r){const i={positions:t.map((e=>({x:Math.floor(e.anchorX*q_),y:Math.floor(e.anchorY*q_)}))),crossTileIDs:t.map((e=>e.crossTileID))};if(i.positions.length>128){const e=new j_(i.positions.length,16,Uint16Array);for(const{x:t,y:r}of i.positions)e.add(t,r);e.finish(),delete i.positions,i.index=e}this._symbolsByKey[e]=i}}getScaledCoordinates(e,t){const{x:i,y:r,z:n}=this.tileID.canonical,{x:s,y:a,z:o}=t.canonical,l=q_/Math.pow(2,o-n),c=(a*Q+e.anchorY)*l,h=r*Q*q_;return{x:Math.floor((s*Q+e.anchorX)*l-i*Q*q_),y:Math.floor(c-h)}}findMatches(e,t,i){const r=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z);for(let n=0;n<e.length;n++){const s=e.get(n);if(s.crossTileID)continue;const a=this._symbolsByKey[s.key];if(!a)continue;const o=this.getScaledCoordinates(s,t);if(a.index){const e=a.index.range(o.x-r,o.y-r,o.x+r,o.y+r).sort();for(const t of e){const e=a.crossTileIDs[t];if(!i[e]){i[e]=!0,s.crossTileID=e;break}}}else if(a.positions)for(let e=0;e<a.positions.length;e++){const t=a.positions[e],n=a.crossTileIDs[e];if(Math.abs(t.x-o.x)<=r&&Math.abs(t.y-o.y)<=r&&!i[n]){i[n]=!0,s.crossTileID=n;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:e})=>e))}}class H_{constructor(){this.maxCrossTileID=0}generate(){return++this.maxCrossTileID}}class X_{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],r={};for(const e in i){const n=i[e];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+t),r[n.tileID.key]=n}this.indexes[e]=r}this.lng=e}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return!1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key])}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]={});const r=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const n=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in n){const s=n[i];s.tileID.isChildOf(e)&&s.findMatches(t.symbolInstances,e,r)}else{const s=n[e.scaledTo(Number(i)).key];s&&s.findMatches(t.symbolInstances,e,r)}}for(let e=0;e<t.symbolInstances.length;e++){const n=t.symbolInstances.get(e);n.crossTileID||(n.crossTileID=i.generate(),r[n.crossTileID]=!0)}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new W_(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.getCrossTileIDsLists())for(const t of i)delete this.usedCrossTileIDs[e][t]}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const r=this.indexes[i];for(const n in r)e[r[n].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[n]),delete r[n],t=!0)}return t}}class Y_{constructor(){this.layerIndexes={},this.crossTileIDs=new H_,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={}}addLayer(e,t,i){let r=this.layerIndexes[e.id];void 0===r&&(r=this.layerIndexes[e.id]=new X_);let n=!1;const s={};r.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,t,this.crossTileIDs)&&(n=!0),s[t.bucketInstanceId]=!0)}return r.removeStaleBuckets(s)&&(n=!0),n}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e]}}var K_="void main() {fragColor=vec4(1.0);}";const J_={prelude:Q_("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:Q_("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:Q_("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:Q_("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:Q_("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:Q_("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:Q_(K_,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:Q_("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:Q_("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:Q_("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:Q_("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),colorRelief:Q_("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;uniform vec4 u_unpack;uniform sampler2D u_elevation_stops;uniform sampler2D u_color_stops;uniform int u_color_ramp_size;uniform float u_opacity;in vec2 v_pos;float getElevation(vec2 coord) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}float getElevationStop(int stop) {float x=(float(stop)+0.5)/float(u_color_ramp_size);vec4 data=texture(u_elevation_stops,vec2(x,0))*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {float el=getElevation(v_pos);int r=(u_color_ramp_size-1);int l=0;float el_l=getElevationStop(l);float el_r=getElevationStop(r);while(r-l > 1){int m=(r+l)/2;float el_m=getElevationStop(m);if(el < el_m){r=m;el_r=el_m;}else\n{l=m;el_l=el_m;}}float x=(float(l)+(el-el_l)/(el_r-el_l)+0.5)/float(u_color_ramp_size);fragColor=u_opacity*texture(u_color_stops,vec2(x,0));\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_dimension;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_pos/8192.0)*scale+epsilon;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),debug:Q_("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:Q_(K_,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:Q_("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:Q_("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:Q_("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:Q_("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:Q_("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:Q_("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:Q_("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {vec2 epsilon=1.0/u_dimension;float tileSize=u_dimension.x-2.0;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))*tileSize/pow(2.0,exaggeration+(28.2562-u_zoom));fragColor=clamp(vec4(deriv.x/8.0+0.5,deriv.y/8.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Q_("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform float u_exaggeration;uniform vec4 u_accent;uniform int u_method;uniform float u_altitudes[NUM_ILLUMINATION_SOURCES];uniform float u_azimuths[NUM_ILLUMINATION_SOURCES];uniform vec4 u_shadows[NUM_ILLUMINATION_SOURCES];uniform vec4 u_highlights[NUM_ILLUMINATION_SOURCES];\n#define PI 3.141592653589793\n#define STANDARD 0\n#define COMBINED 1\n#define IGOR 2\n#define MULTIDIRECTIONAL 3\n#define BASIC 4\nfloat get_aspect(vec2 deriv){return deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);}void igor_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float aspect=get_aspect(deriv);float azimuth=u_azimuths[0]+PI;float slope_stength=atan(length(deriv))*2.0/PI;float aspect_strength=1.0-abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);float shadow_strength=slope_stength*aspect_strength;float highlight_strength=slope_stength*(1.0-aspect_strength);fragColor=u_shadows[0]*shadow_strength+u_highlights[0]*highlight_strength;}void standard_hillshade(vec2 deriv){float azimuth=u_azimuths[0]+PI;float slope=atan(0.625*length(deriv));float aspect=get_aspect(deriv);float intensity=u_exaggeration;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadows[0],u_highlights[0],shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;}void basic_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor=u_highlights[0]*(2.0*shade-1.0);}else\n{fragColor=u_shadows[0]*(1.0-2.0*shade);}}void multidirectional_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;fragColor=vec4(0,0,0,0);for(int i=0; i < NUM_ILLUMINATION_SOURCES; i++){float cos_alt=cos(u_altitudes[i]);float sin_alt=sin(u_altitudes[i]);float cos_az=-cos(u_azimuths[i]);float sin_az=-sin(u_azimuths[i]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor+=u_highlights[i]*(2.0*shade-1.0)/float(NUM_ILLUMINATION_SOURCES);}else\n{fragColor+=u_shadows[i]*(1.0-2.0*shade)/float(NUM_ILLUMINATION_SOURCES);}}}void combined_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=acos((sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv)));cang=clamp(cang,0.0,PI/2.0);float shade=cang*atan(length(deriv))*4.0/PI/PI;float highlight=(PI/2.0-cang)*atan(length(deriv))*4.0/PI/PI;fragColor=u_shadows[0]*shade+u_highlights[0]*highlight;}void main() {vec4 pixel=texture(u_image,v_pos);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));vec2 deriv=((pixel.rg*8.0)-4.0)/scaleFactor;if (u_method==BASIC) {basic_hillshade(deriv);} else if (u_method==COMBINED) {combined_hillshade(deriv);} else if (u_method==IGOR) {igor_hillshade(deriv);} else if (u_method==MULTIDIRECTIONAL) {multidirectional_hillshade(deriv);} else if (u_method==STANDARD) {standard_hillshade(deriv);} else {standard_hillshade(deriv);}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:Q_("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:Q_("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:Q_("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:Q_("uniform lowp float u_device_pixel_ratio;uniform lowp float u_lineatlas_width;uniform sampler2D u_image;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfgamma=(u_lineatlas_width/256.0/u_device_pixel_ratio)/min(dasharray_from.w,dasharray_to.w);alpha*=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_tileratio;uniform float u_crossfade_from;uniform float u_crossfade_to;uniform float u_lineatlas_height;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nfloat u_patternscale_a_x=u_tileratio/dasharray_from.w/u_crossfade_from;float u_patternscale_a_y=-dasharray_from.z/2.0/u_lineatlas_height;float u_patternscale_b_x=u_tileratio/dasharray_to.w/u_crossfade_to;float u_patternscale_b_y=-dasharray_to.z/2.0/u_lineatlas_height;v_tex_a=vec2(a_linesofar*u_patternscale_a_x/floorwidth,normal.y*u_patternscale_a_y+(float(dasharray_from.y)+0.5)/u_lineatlas_height);v_tex_b=vec2(a_linesofar*u_patternscale_b_x/floorwidth,normal.y*u_patternscale_b_y+(float(dasharray_to.y)+0.5)/u_lineatlas_height);v_width2=vec2(outset,inset);}"),lineGradientSDF:Q_("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform sampler2D u_image_dash;uniform float u_mix;uniform lowp float u_lineatlas_width;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);float sdfdist_a=texture(u_image_dash,v_tex_a).a;float sdfdist_b=texture(u_image_dash,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfgamma=(u_lineatlas_width/256.0)/min(dasharray_from.w,dasharray_to.w);float dash_alpha=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*dash_alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;uniform float u_tileratio;uniform float u_crossfade_from;uniform float u_crossfade_to;uniform float u_lineatlas_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;out vec2 v_tex_a;out vec2 v_tex_b;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;float texel_height=1.0/u_image_height;float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nfloat u_patternscale_a_x=u_tileratio/dasharray_from.w/u_crossfade_from;float u_patternscale_a_y=-dasharray_from.z/2.0/u_lineatlas_height;float u_patternscale_b_x=u_tileratio/dasharray_to.w/u_crossfade_to;float u_patternscale_b_y=-dasharray_to.z/2.0/u_lineatlas_height;v_tex_a=vec2(a_linesofar*u_patternscale_a_x/floorwidth,normal.y*u_patternscale_a_y+(float(dasharray_from.y)+0.5)/u_lineatlas_height);v_tex_b=vec2(a_linesofar*u_patternscale_b_x/floorwidth,normal.y*u_patternscale_b_y+(float(dasharray_to.y)+0.5)/u_lineatlas_height);v_width2=vec2(outset,inset);}"),raster:Q_("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:Q_("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:Q_("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:Q_("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:Q_("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:Q_("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:Q_("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:Q_("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:Q_("#ifdef GL_ES\nprecision highp float;\n#endif\nin vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:Q_("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function Q_(e,t){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=t.match(/in ([\w]+) ([\w]+)/g),n=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),a=s?s.concat(n):n,o={};return{fragmentSource:e=e.replace(i,((e,t,i,r,n)=>(o[n]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nin ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = u_${n};\n#endif\n`))),vertexSource:t=t.replace(i,((e,t,i,r,n)=>{const s="float"===r?"vec2":"vec4",a=n.match(/color/)?"color":s;return o[n]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${s} a_${n};\nout ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = unpack_mix_${a}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${s} a_${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = unpack_mix_${a}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`})),staticAttributes:r,staticUniforms:a}}class eg{constructor(e,t,i){this.vertexBuffer=e,this.indexBuffer=t,this.segments=i}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null}}var tg=ro([{name:"a_pos",type:"Int16",components:2}]);const ig="#define PROJECTION_MERCATOR",rg="mercator";class ng{constructor(){this._cachedMesh=null}get name(){return"mercator"}get useSubdivision(){return!1}get shaderVariantName(){return rg}get shaderDefine(){return ig}get shaderPreludeCode(){return J_.projectionMercator}get vertexShaderPreludeCode(){return J_.projectionMercator.vertexSource}get subdivisionGranularity(){return wh.noSubdivision}get useGlobeControls(){return!1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(e){}getMeshFromTileID(e,t,i,r,n){if(this._cachedMesh)return this._cachedMesh;const s=new Uo;s.emplaceBack(0,0),s.emplaceBack(Q,0),s.emplaceBack(0,Q),s.emplaceBack(Q,Q);const a=e.createVertexBuffer(s,tg.members),o=hl.simpleSegment(0,0,4,2),l=new sl;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3);const c=e.createIndexBuffer(l);return this._cachedMesh=new eg(a,c,o),this._cachedMesh}recalculate(){}hasTransition(){return!1}setErrorQueryLatitudeDegrees(e){}}class sg{constructor(e=0,t=0,i=0,r=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=r}interpolate(e,t,i){return null!=t.top&&null!=e.top&&(this.top=Tr.number(e.top,t.top,i)),null!=t.bottom&&null!=e.bottom&&(this.bottom=Tr.number(e.bottom,t.bottom,i)),null!=t.left&&null!=e.left&&(this.left=Tr.number(e.left,t.left,i)),null!=t.right&&null!=e.right&&(this.right=Tr.number(e.right,t.right,i)),this}getCenter(e,t){return new s(ve((this.left+e-this.right)/2,0,e),ve((this.top+t-this.bottom)/2,0,t))}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new sg(this.top,this.bottom,this.left,this.right)}toJSON(){return{top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function ag(e,t){if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0}function og(e){return Math.max(0,Math.floor(e))}class lg{constructor(e,t){var i;this.applyConstrain=(e,t)=>null!==this._constrainOverride?this._constrainOverride(e,t):this._callbacks.defaultConstrain(e,t),this._callbacks=e,this._tileSize=512,this._renderWorldCopies=void 0===(null==t?void 0:t.renderWorldCopies)||!!(null==t?void 0:t.renderWorldCopies),this._minZoom=(null==t?void 0:t.minZoom)||0,this._maxZoom=(null==t?void 0:t.maxZoom)||22,this._minPitch=null==(null==t?void 0:t.minPitch)?0:null==t?void 0:t.minPitch,this._maxPitch=null==(null==t?void 0:t.maxPitch)?60:null==t?void 0:t.maxPitch,this._constrainOverride=null!==(i=null==t?void 0:t.constrainOverride)&&void 0!==i?i:null,this.setMaxBounds(),this._width=0,this._height=0,this._center=new qd(0,0),this._elevation=0,this._zoom=0,this._tileZoom=og(this._zoom),this._scale=Ie(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new sg,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0}apply(e,t,i){this._constrainOverride=e.constrainOverride,this._latRange=e.latRange,this._lngRange=e.lngRange,this._width=e.width,this._height=e.height,this._center=e.center,this._elevation=e.elevation,this._minElevationForCurrentTile=e.minElevationForCurrentTile,this._zoom=e.zoom,this._tileZoom=og(this._zoom),this._scale=Ie(this._zoom),this._bearingInRadians=e.bearingInRadians,this._fovInRadians=e.fovInRadians,this._pitchInRadians=e.pitchInRadians,this._rollInRadians=e.rollInRadians,this._unmodified=e.unmodified,this._edgeInsets=new sg(e.padding.top,e.padding.bottom,e.padding.left,e.padding.right),this._minZoom=e.minZoom,this._maxZoom=e.maxZoom,this._minPitch=e.minPitch,this._maxPitch=e.maxPitch,this._renderWorldCopies=e.renderWorldCopies,this._cameraToCenterDistance=e.cameraToCenterDistance,this._nearZ=e.nearZ,this._farZ=e.farZ,this._autoCalculateNearFarZ=!i&&e.autoCalculateNearFarZ,t&&this.constrainInternal(),this._calcMatrices()}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(e){this._minElevationForCurrentTile=e}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(e){this._minZoom!==e&&(this._minZoom=e,this.setZoom(this.applyConstrain(this._center,this.zoom).zoom))}get maxZoom(){return this._maxZoom}setMaxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.setZoom(this.applyConstrain(this._center,this.zoom).zoom))}get minPitch(){return this._minPitch}setMinPitch(e){this._minPitch!==e&&(this._minPitch=e,this.setPitch(Math.max(this.pitch,e)))}get maxPitch(){return this._maxPitch}setMaxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.setPitch(Math.min(this.pitch,e)))}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e}get constrainOverride(){return this._constrainOverride}setConstrainOverride(e){void 0===e&&(e=null),this._constrainOverride!==e&&(this._constrainOverride=e,this.constrainInternal(),this._calcMatrices())}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new s(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(e){const t=be(e,-180,180)*Math.PI/180;var i,r,n,s,a,o,l,c,h;this._bearingInRadians!==t&&(this._unmodified=!1,this._bearingInRadians=t,this._calcMatrices(),this._rotationMatrix=f(),i=this._rotationMatrix,n=-this._bearingInRadians,s=(r=this._rotationMatrix)[0],a=r[1],o=r[2],l=r[3],c=Math.sin(n),h=Math.cos(n),i[0]=s*h+o*c,i[1]=a*h+l*c,i[2]=s*-c+o*h,i[3]=a*-c+l*h)}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(e){const t=ve(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==t&&(this._unmodified=!1,this._pitchInRadians=t,this._calcMatrices())}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(e){const t=e/180*Math.PI;this._rollInRadians!==t&&(this._unmodified=!1,this._rollInRadians=t,this._calcMatrices())}get fovInRadians(){return this._fovInRadians}get fov(){return Ne(this._fovInRadians)}setFov(e){e=ve(e,.1,150),this.fov!==e&&(this._unmodified=!1,this._fovInRadians=je(e),this._calcMatrices())}get zoom(){return this._zoom}setZoom(e){const t=this.applyConstrain(this._center,e).zoom;this._zoom!==t&&(this._unmodified=!1,this._zoom=t,this._tileZoom=Math.max(0,Math.floor(t)),this._scale=Ie(t),this.constrainInternal(),this._calcMatrices())}get center(){return this._center}setCenter(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this.constrainInternal(),this._calcMatrices())}get elevation(){return this._elevation}setElevation(e){e!==this._elevation&&(this._elevation=e,this.constrainInternal(),this._calcMatrices())}get padding(){return this._edgeInsets.toJSON()}setPadding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices())}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(e,t){this._autoCalculateNearFarZ=!1,this._nearZ=e,this._farZ=t,this._calcMatrices()}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices()}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this.constrainInternal(),this._calcMatrices()}resize(e,t,i=!0){this._width=e,this._height=t,i&&this.constrainInternal(),this._calcMatrices()}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new Wd([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(e){e?(this._lngRange=[e.getWest(),e.getEast()],this._latRange=[e.getSouth(),e.getNorth()],this.constrainInternal()):(this._lngRange=null,this._latRange=[-85.051129,$e])}getCameraQueryGeometry(e,t){if(1===t.length)return[t[0],e];{const{minX:i,minY:r,maxX:n,maxY:a}=vp.fromPoints(t).extend(e);return[new s(i,r),new s(n,r),new s(n,a),new s(i,a),new s(i,r)]}}constrainInternal(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const e=this._unmodified,{center:t,zoom:i}=this.applyConstrain(this.center,this.zoom);this.setCenter(t),this.setZoom(i),this._unmodified=e,this._constraining=!1}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let e=y(new Float64Array(16));w(e,e,[this._width/2,-this._height/2,1]),b(e,e,[1,-1,0]),this._clipSpaceToPixelsMatrix=e,e=y(new Float64Array(16)),w(e,e,[1,-1,1]),b(e,e,[-1,-1,0]),w(e,e,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=e,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height}this._callbacks.calcMatrices()}calculateCenterFromCameraLngLatAlt(e,t,i,r){const n=void 0!==i?i:this.bearing,s=r=void 0!==r?r:this.pitch,{distanceToCenter:a,clampedElevation:o}=this._distanceToCenterFromAltElevationPitch(t,this.elevation,s),{x:l,y:c}=Am(s,n),h=ip.fromLngLat(e,t);let u,d,p=tp(1,h.y),f=0;do{if(f+=1,f>10)break;d=a/p,u=new ip(h.x+l*d,h.y+c*d),p=1/u.meterInMercatorCoordinateUnits()}while(Math.abs(a-d*p)>1e-12);return{center:u.toLngLat(),elevation:o,zoom:Me(this.height/2/Math.tan(this.fovInRadians/2)/d/this.tileSize)}}recalculateZoomAndCenter(e){if(this.elevation-e==0)return;const t=1/this.worldSize,i=Jd(1,this.center.lat)*this.worldSize,r=ip.fromLngLat(this.center,this.elevation),n=r.x/t,s=r.y/t,a=r.z/t,o=this.pitch,l=this.bearing,{x:c,y:h,z:u}=Am(o,l),d=this.cameraToCenterDistance,p=n+d*-c,f=s+d*-h,m=a+d*u,{distanceToCenter:_,clampedElevation:g}=this._distanceToCenterFromAltElevationPitch(m/i,e,o),y=_*i,x=new ip((p+c*y)*t,(f+h*y)*t,0).toLngLat(),v=Jd(1,x.lat),b=Me(this.height/2/Math.tan(this.fovInRadians/2)/_/v/this.tileSize);this._elevation=g,this._center=x,this.setZoom(b)}_distanceToCenterFromAltElevationPitch(e,t,i){const r=-Math.cos(je(i)),n=e-t;let s,a=t;return r*n>=0||Math.abs(r)<.1?(s=1e4,a=e+s*r):s=-n/r,{distanceToCenter:s,clampedElevation:a}}getCameraPoint(){const e=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new s(e*Math.sin(this.rollInRadians),e*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const e=Jd(1,this.center.lat)*this.worldSize;return Cm(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/e).toLngLat()}getMercatorTileCoordinates(e){if(!e)return[0,0,1,1];const t=e.canonical.z>=0?1<<e.canonical.z:Math.pow(2,e.canonical.z);return[e.canonical.x/t,e.canonical.y/t,1/t/Q,1/t/Q]}}class cg{constructor(e,t){this.min=e,this.max=t,this.center=R([],D([],this.min,this.max),.5)}quadrant(e){const t=[e%2==0,e<2],i=C(this.min),r=C(this.max);for(let e=0;e<t.length;e++)i[e]=t[e]?this.min[e]:this.center[e],r[e]=t[e]?this.center[e]:this.max[e];return r[2]=this.max[2],new cg(i,r)}distanceX(e){return Math.max(Math.min(this.max[0],e[0]),this.min[0])-e[0]}distanceY(e){return Math.max(Math.min(this.max[1],e[1]),this.min[1])-e[1]}intersectsFrustum(e){let t=!0;for(let i=0;i<e.planes.length;i++){const r=this.intersectsPlane(e.planes[i]);if(0===r)return 0;1===r&&(t=!1)}return t?2:e.aabb.min[0]>this.max[0]||e.aabb.min[1]>this.max[1]||e.aabb.min[2]>this.max[2]||e.aabb.max[0]<this.min[0]||e.aabb.max[1]<this.min[1]||e.aabb.max[2]<this.min[2]?0:1}intersectsPlane(e){let t=e[3],i=e[3];for(let r=0;r<3;r++)e[r]>0?(t+=e[r]*this.min[r],i+=e[r]*this.max[r]):(i+=e[r]*this.min[r],t+=e[r]*this.max[r]);return t>=0?2:i<0?0:1}}class hg{distanceToTile2d(e,t,i,r){const n=r.distanceX([e,t]),s=r.distanceY([e,t]);return Math.hypot(n,s)}getWrap(e,t,i){return i}getTileBoundingVolume(e,t,i,r){var n,s;let a=0,o=0;if(null==r?void 0:r.terrain){const l=new hp(e.z,t,e.z,e.x,e.y),c=r.terrain.getMinMaxElevation(l);a=null!==(n=c.minElevation)&&void 0!==n?n:Math.min(0,i),o=null!==(s=c.maxElevation)&&void 0!==s?s:Math.max(0,i)}const l=1<<e.z;return new cg([t+e.x/l,e.y/l,a],[t+(e.x+1)/l,(e.y+1)/l,o])}allowVariableZoom(e,t){const i=ve(78.5-e.fov*(Math.abs(Math.cos(e.rollInRadians))*e.height+Math.abs(Math.sin(e.rollInRadians))*e.width)/e.height/2,0,60);return!!t.terrain||e.pitch>i}allowWorldCopies(){return!0}prepareNextFrame(){}}class ug{constructor(e,t,i){this.points=e,this.planes=t,this.aabb=i}static fromInvProjectionMatrix(e,t=1,i=0,r,n){const s=n?[[6,5,4],[0,1,2],[0,3,7],[2,1,5],[3,2,6],[0,4,5]]:[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]],a=Math.pow(2,i),o=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((i=>function(e,t,i,r){const n=Z([],e,t),s=1/n[3]/i*r;return function(e,t,i){return e[0]=t[0]*i[0],e[1]=t[1]*i[1],e[2]=t[2]*i[2],e[3]=t[3]*i[3],e}(n,n,[s,s,1/n[3],s])}(i,e,t,a)));r&&function(e,t,i,r){const n=r?4:0,s=r?0:4;let a=0;const o=[],l=[];for(let t=0;t<4;t++){const i=U([],e[t+s],e[t+n]),r=A(i);R(i,i,1/r),o.push(r),l.push(i)}for(let t=0;t<4;t++){const r=ce(e[t+n],l[t],i);a=null!==r&&r>=0?Math.max(a,r):Math.max(a,o[t])}const c=function(e,t){const i=[0,0,0,0];return k(i,F([],U([],e[t[0]],e[t[1]]),U([],e[t[2]],e[t[1]]))),i[3]=-L(i,e[t[0]]),i}(e,t),h=function(e,t){const i=G(e),r=((a=[])[0]=(o=e)[0]*(l=1/i),a[1]=o[1]*l,a[2]=o[2]*l,a[3]=o[3]*l,a),n=U([],t,R([],r,L(t,r))),s=G(n);var a,o,l;if(s>0){const e=Math.sqrt(1-r[3]*r[3]);return oe(t,D([],R([],r,-r[3]),R([],n,e/s)))}return null}(i,c);if(null!==h){const e=h/L(l[0],c);a=Math.min(a,e)}for(let t=0;t<4;t++){const i=Math.min(a,o[t]);e[t+s]=[e[t+n][0]+l[t][0]*i,e[t+n][1]+l[t][1]*i,e[t+n][2]+l[t][2]*i,1]}}(o,s[0],r,n);const l=s.map((e=>{const t=k([],F([],U([],o[e[0]],o[e[1]]),U([],o[e[2]],o[e[1]]))),i=-L(t,o[e[1]]);return t.concat(i)})),c=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],h=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const e of o)for(let t=0;t<3;t++)c[t]=Math.min(c[t],e[t]),h[t]=Math.max(h[t],e[t]);return new ug(o,l,new cg(c,h))}}class dg{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e)}setMaxZoom(e){this._helper.setMaxZoom(e)}setMinPitch(e){this._helper.setMinPitch(e)}setMaxPitch(e){this._helper.setMaxPitch(e)}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e)}setBearing(e){this._helper.setBearing(e)}setPitch(e){this._helper.setPitch(e)}setRoll(e){this._helper.setRoll(e)}setFov(e){this._helper.setFov(e)}setZoom(e){this._helper.setZoom(e)}setCenter(e){this._helper.setCenter(e)}setElevation(e){this._helper.setElevation(e)}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e)}setPadding(e){this._helper.setPadding(e)}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e)}setConstrainOverride(e){this._helper.setConstrainOverride(e)}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e,t){}constructor(e){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this.defaultConstrain=(e,t)=>{t=ve(+t,this.minZoom,this.maxZoom);const i={center:new qd(e.lng,e.lat),zoom:t};let r=this._helper._lngRange;if(!this._helper._renderWorldCopies&&null===r){const e=180-1e-10;r=[-e,e]}const n=this.tileSize*Ie(i.zoom);let a=0,o=n,l=0,c=n,h=0,u=0;const{x:d,y:p}=this.size;if(this._helper._latRange){const e=this._helper._latRange;a=Kd(e[1])*n,o=Kd(e[0])*n,o-a<p&&(h=p/(o-a))}r&&(l=be(Yd(r[0])*n,0,n),c=be(Yd(r[1])*n,0,n),c<l&&(c+=n),c-l<d&&(u=d/(c-l)));const{x:f,y:m}=Pm(n,e);let _,g;const y=Math.max(u||0,h||0);if(y){const e=new s(u?(c+l)/2:f,h?(o+a)/2:m);return i.center=Im(n,e).wrap(),i.zoom+=Me(y),i}if(this._helper._latRange){const e=p/2;m-e<a&&(g=a+e),m+e>o&&(g=o-e)}if(r){const e=(l+c)/2;let t=f;this._helper._renderWorldCopies&&(t=be(f,e-n/2,e+n/2));const i=d/2;t-i<l&&(_=l+i),t+i>c&&(_=c-i)}if(void 0!==_||void 0!==g){const e=new s(null!=_?_:f,null!=g?g:m);i.center=Im(n,e).wrap()}return i},this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new lg({calcMatrices:()=>{this._calcMatrices()},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._coveringTilesDetailsProvider=new hg}clone(){const e=new dg;return e.apply(this,!1),e}apply(e,t,i){this._helper.apply(e,t,i)}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(e){const t=[new cp(0,e)];if(this._helper._renderWorldCopies){const i=this.screenPointToMercatorCoordinate(new s(0,0)),r=this.screenPointToMercatorCoordinate(new s(this._helper._width,0)),n=this.screenPointToMercatorCoordinate(new s(this._helper._width,this._helper._height)),a=this.screenPointToMercatorCoordinate(new s(0,this._helper._height)),o=Math.floor(Math.min(i.x,r.x,n.x,a.x)),l=Math.floor(Math.max(i.x,r.x,n.x,a.x)),c=1;for(let i=o-c;i<=l+c;i++)0!==i&&t.push(new cp(i,e))}return t}getCameraFrustum(){return ug.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){const t=this.screenPointToLocation(this.centerPoint,e),i=e?e.getElevationForLngLatZoom(t,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i)}setLocationAtPoint(e,t){const i=Jd(this.elevation,this.center.lat),r=this.screenPointToMercatorCoordinateAtZ(t,i),n=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,i),s=ip.fromLngLat(e),a=new ip(s.x-(r.x-n.x),s.y-(r.y-n.y));this.setCenter(null==a?void 0:a.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap())}locationToScreenPoint(e,t){return t?this.coordinatePoint(ip.fromLngLat(e),t.getElevationForLngLat(e,this),this._pixelMatrix3D):this.coordinatePoint(ip.fromLngLat(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(e,t){if(t){const i=t.pointCoordinate(e);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(e)}screenPointToMercatorCoordinateAtZ(e,t){const i=t||0,r=[e.x,e.y,0,1],n=[e.x,e.y,1,1];Z(r,r,this._pixelMatrixInverse),Z(n,n,this._pixelMatrixInverse);const s=r[3],a=n[3],o=r[1]/s,l=n[1]/a,c=r[2]/s,h=n[2]/a,u=c===h?0:(i-c)/(h-c);return new ip(Tr.number(r[0]/s,n[0]/a,u)/this.worldSize,Tr.number(o,l,u)/this.worldSize,i)}coordinatePoint(e,t=0,i=this._pixelMatrix){const r=[e.x*this.worldSize,e.y*this.worldSize,t,1];return Z(r,r,i),new s(r[0]/r[3],r[1]/r[3])}getBounds(){const e=Math.max(0,this._helper._height/2-Mm(this));return(new Wd).extend(this.screenPointToLocation(new s(0,e))).extend(this.screenPointToLocation(new s(this._helper._width,e))).extend(this.screenPointToLocation(new s(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new s(0,this._helper._height)))}isPointOnMapSurface(e,t){return t?null!=t.pointCoordinate(e):e.y>this.height/2-Mm(this)}calculatePosMatrix(e,t=!1,i){var r;const n=null!==(r=e.key)&&void 0!==r?r:up(e.wrap,e.canonical.z,e.canonical.z,e.canonical.x,e.canonical.y),s=t?this._alignedPosMatrixCache:this._posMatrixCache;if(s.has(n)){const e=s.get(n);return i?e.f32:e.f64}const a=Em(e,this.worldSize);v(a,t?this._alignedProjMatrix:this._viewProjMatrix,a);const o={f64:a,f32:new Float32Array(a)};return s.set(n,o),i?o.f32:o.f64}calculateFogMatrix(e){const t=e.key,i=this._fogMatrixCacheF32;if(i.has(t))return i.get(t);const r=Em(e,this.worldSize);return v(r,this._fogMatrix,r),i.set(t,new Float32Array(r)),i.get(t)}calculateCenterFromCameraLngLatAlt(e,t,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,r)}_calculateNearFarZIfNeeded(e,t,i){if(!this._helper.autoCalculateNearFarZ)return;const r=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),n=e-r*this._helper._pixelPerMeter/Math.cos(t),s=r<0?n:e,a=Math.PI/2+this.pitchInRadians,o=je(this.fov)*(Math.abs(Math.cos(je(this.roll)))*this.height+Math.abs(Math.sin(je(this.roll)))*this.width)/this.height*(.5+i.y/this.height),l=Math.sin(o)*s/Math.sin(ve(Math.PI-a-o,.01,Math.PI-.01)),c=Mm(this),h=Math.atan(c/this._helper.cameraToCenterDistance),u=je(.75),d=h>u?2*h*(.5+i.y/(2*c)):u,p=Math.sin(d)*s/Math.sin(ve(Math.PI-a-d,.01,Math.PI-.01)),f=Math.min(l,p);this._helper._farZ=1.01*(Math.cos(Math.PI/2-t)*f+s),this._helper._nearZ=this._helper._height/50}_calcMatrices(){if(!this._helper._height)return;const e=this.centerOffset,t=Pm(this.worldSize,this.center),i=t.x,r=t.y;this._helper._pixelPerMeter=Jd(1,this.center.lat)*this.worldSize;const n=je(Math.min(this.pitch,Sm)),s=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(n));let a;this._calculateNearFarZIfNeeded(s,n,e),a=new Float64Array(16),I(a,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),x(this._invProjMatrix,a),a[8]=2*-e.x/this._helper._width,a[9]=2*e.y/this._helper._height,this._projectionMatrix=g(a),w(a,a,[1,-1,1]),b(a,a,[0,0,-this._helper.cameraToCenterDistance]),P(a,a,-this.rollInRadians),T(a,a,this.pitchInRadians),P(a,a,-this.bearingInRadians),b(a,a,[-i,-r,0]),this._mercatorMatrix=w([],a,[this.worldSize,this.worldSize,this.worldSize]),w(a,a,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=v(new Float64Array(16),this.clipSpaceToPixelsMatrix,a),b(a,a,[0,0,-this.elevation]),this._viewProjMatrix=a,this._invViewProjMatrix=x([],a);const o=[0,0,-1,1];Z(o,o,this._invViewProjMatrix),this._cameraPosition=[o[0]/o[3],o[1]/o[3],o[2]/o[3]],this._fogMatrix=new Float64Array(16),I(this._fogMatrix,this.fovInRadians,this.width/this.height,s,this._helper._farZ),this._fogMatrix[8]=2*-e.x/this.width,this._fogMatrix[9]=2*e.y/this.height,w(this._fogMatrix,this._fogMatrix,[1,-1,1]),b(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),P(this._fogMatrix,this._fogMatrix,-this.rollInRadians),T(this._fogMatrix,this._fogMatrix,this.pitchInRadians),P(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),b(this._fogMatrix,this._fogMatrix,[-i,-r,0]),w(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),b(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=v(new Float64Array(16),this.clipSpaceToPixelsMatrix,a);const l=this._helper._width%2/2,c=this._helper._height%2/2,h=Math.cos(this.bearingInRadians),u=Math.sin(-this.bearingInRadians),d=i-Math.round(i)+h*l+u*c,p=r-Math.round(r)+h*c+u*l,f=new Float64Array(a);if(b(f,f,[d>.5?d-1:d,p>.5?p-1:p,0]),this._alignedProjMatrix=f,a=x(new Float64Array(16),this._pixelMatrix),!a)throw new Error("failed to invert matrix");this._pixelMatrixInverse=a,this._clearMatrixCaches()}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear()}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const e=this.screenPointToMercatorCoordinate(new s(0,0)),t=[e.x*this.worldSize,e.y*this.worldSize,0,1];return Z(t,t,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const e=Jd(1,this.center.lat)*this.worldSize;return Cm(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/e).toLngLat()}lngLatToCameraDepth(e,t){const i=ip.fromLngLat(e),r=[i.x*this.worldSize,i.y*this.worldSize,t,1];return Z(r,r,this._viewProjMatrix),r[2]/r[3]}getProjectionData(e){const{overscaledTileID:t,aligned:i,applyTerrainMatrix:r}=e,n=this._helper.getMercatorTileCoordinates(t),s=t?this.calculatePosMatrix(t,i,!0):null;let a;return a=t&&t.terrainRttPosMatrix32f&&r?t.terrainRttPosMatrix32f:s||se(),{mainMatrix:a,tileMercatorCoords:n,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:a}}isLocationOccluded(e){return!1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(e,t,i){return 1}transformLightDirection(e){return C(e)}getRayDirectionFromPixel(e){throw new Error("Not implemented.")}projectTileCoordinates(e,t,i,r){const n=this.calculatePosMatrix(i);let a;r?(a=[e,t,r(e,t),1],Z(a,a,n)):(a=[e,t,0,1],m_(a,a,n));const o=a[3];return{point:new s(a[0]/o,a[1]/o),signedDistanceFromCamera:o,isOccluded:!1}}populateCache(e){for(const t of e)this.calculatePosMatrix(t)}getMatrixForModel(e,t){const i=ip.fromLngLat(e,t),r=i.meterInMercatorCoordinateUnits(),n=ne();return b(n,n,[i.x,i.y,i.z]),P(n,n,Math.PI),T(n,n,Math.PI/2),w(n,n,[-r,r,r]),n}getProjectionDataForCustomLayer(e=!0){const t=new hp(0,0,0,0,0),i=this.getProjectionData({overscaledTileID:t,applyGlobeMatrix:e}),r=Em(t,this.worldSize);v(r,this._viewProjMatrix,r),i.tileMercatorCoords=[0,0,1,1];const n=[Q,Q,this.worldSize/this._helper.pixelsPerMeter],s=re();return w(s,r,n),i.fallbackMatrix=s,i.mainMatrix=s,i}getFastPathSimpleProjectionMatrix(e){return this.calculatePosMatrix(e)}}function pg(){Re("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}function fg(e){if(e.useSlerp)if(e.k<1){const t=Ze(e.startEulerAngles.roll,e.startEulerAngles.pitch,e.startEulerAngles.bearing),i=Ze(e.endEulerAngles.roll,e.endEulerAngles.pitch,e.endEulerAngles.bearing),r=new Float64Array(4);!function(e,t,i,r){var n,s,a,o,l,c=t[0],h=t[1],u=t[2],p=t[3],f=i[0],m=i[1],_=i[2],g=i[3];(s=c*f+h*m+u*_+p*g)<0&&(s=-s,f=-f,m=-m,_=-_,g=-g),1-s>d?(n=Math.acos(s),a=Math.sin(n),o=Math.sin((1-r)*n)/a,l=Math.sin(r*n)/a):(o=1-r,l=r),e[0]=o*c+l*f,e[1]=o*h+l*m,e[2]=o*u+l*_,e[3]=o*p+l*g}(r,t,i,e.k);const n=function(e){const t=new Float64Array(9);var i,r,n,s,a,o,l,c,h,u,d,p,f,m,_,g,y,x;u=(n=(r=e)[0])*(l=n+n),d=(s=r[1])*l,f=(a=r[2])*l,m=a*(c=s+s),g=(o=r[3])*l,y=o*c,x=o*(h=a+a),(i=t)[0]=1-(p=s*c)-(_=a*h),i[3]=d-x,i[6]=f+y,i[1]=d+x,i[4]=1-u-_,i[7]=m-g,i[2]=f-y,i[5]=m+g,i[8]=1-u-p;const v=Ne(-Math.asin(ve(t[2],-1,1)));let b,w;return Math.hypot(t[5],t[8])<.001?(b=0,w=-Ne(Math.atan2(t[3],t[4]))):(b=Ne(0===t[5]&&0===t[8]?0:Math.atan2(t[5],t[8])),w=Ne(0===t[1]&&0===t[0]?0:Math.atan2(t[1],t[0]))),{roll:b,pitch:v+90,bearing:w}}(r);e.tr.setRoll(n.roll),e.tr.setPitch(n.pitch),e.tr.setBearing(n.bearing)}else e.tr.setRoll(e.endEulerAngles.roll),e.tr.setPitch(e.endEulerAngles.pitch),e.tr.setBearing(e.endEulerAngles.bearing);else e.tr.setRoll(Tr.number(e.startEulerAngles.roll,e.endEulerAngles.roll,e.k)),e.tr.setPitch(Tr.number(e.startEulerAngles.pitch,e.endEulerAngles.pitch,e.k)),e.tr.setBearing(Tr.number(e.startEulerAngles.bearing,e.endEulerAngles.bearing,e.k))}function mg(e,t,i,r,n){const a=n.padding,o=Pm(n.worldSize,i.getNorthWest()),l=Pm(n.worldSize,i.getNorthEast()),c=Pm(n.worldSize,i.getSouthEast()),h=Pm(n.worldSize,i.getSouthWest()),u=je(-r),d=o.rotate(u),p=l.rotate(u),f=c.rotate(u),m=h.rotate(u),_=new s(Math.max(d.x,p.x,m.x,f.x),Math.max(d.y,p.y,m.y,f.y)),g=new s(Math.min(d.x,p.x,m.x,f.x),Math.min(d.y,p.y,m.y,f.y)),y=_.sub(g),x=(n.width-(a.left+a.right+t.left+t.right))/y.x,v=(n.height-(a.top+a.bottom+t.top+t.bottom))/y.y;if(v<0||x<0)return void pg();const b=Math.min(Me(n.scale*Math.min(x,v)),e.maxZoom),w=s.convert(e.offset),T=new s((t.left-t.right)/2,(t.top-t.bottom)/2).rotate(je(r)),S=w.add(T).mult(n.scale/Ie(b));return{center:Im(n.worldSize,o.add(c).div(2).sub(S)),zoom:b,bearing:r}}class _g{get useGlobeControls(){return!1}handlePanInertia(e,t){const i=e.mag(),r=Math.abs(Mm(t));return{easingOffset:e.mult(Math.min(.75*r/i,1)),easingCenter:t.center}}handleMapControlsRollPitchBearingZoom(e,t){e.bearingDelta&&t.setBearing(t.bearing+e.bearingDelta),e.pitchDelta&&t.setPitch(t.pitch+e.pitchDelta),e.rollDelta&&t.setRoll(t.roll+e.rollDelta),e.zoomDelta&&t.setZoom(t.zoom+e.zoomDelta)}handleMapControlsPan(e,t,i){e.around.distSqr(t.centerPoint)<.01||t.setLocationAtPoint(i,e.around)}cameraForBoxAndBearing(e,t,i,r,n){return mg(e,t,i,r,n)}handleJumpToCenterZoom(e,t){e.zoom!==(void 0!==t.zoom?+t.zoom:e.zoom)&&e.setZoom(+t.zoom),void 0!==t.center&&e.setCenter(qd.convert(t.center))}handleEaseTo(e,t){const i=e.zoom,r=e.padding,n={roll:e.roll,pitch:e.pitch,bearing:e.bearing},s={roll:void 0===t.roll?e.roll:t.roll,pitch:void 0===t.pitch?e.pitch:t.pitch,bearing:void 0===t.bearing?e.bearing:t.bearing},a=void 0!==t.zoom,o=!e.isPaddingEqual(t.padding);let l=!1;const c=a?+t.zoom:e.zoom;let h=e.centerPoint.add(t.offsetAsPoint);const u=e.screenPointToLocation(h),{center:d,zoom:p}=e.applyConstrain(qd.convert(t.center||u),null!=c?c:i);ag(e,d);const f=Pm(e.worldSize,u),m=Pm(e.worldSize,d).sub(f),_=Ie(p-i);return l=p!==i,{easeFunc:a=>{if(l&&e.setZoom(Tr.number(i,p,a)),Ue(n,s)||fg({startEulerAngles:n,endEulerAngles:s,tr:e,k:a,useSlerp:n.roll!=s.roll}),o&&(e.interpolatePadding(r,t.padding,a),h=e.centerPoint.add(t.offsetAsPoint)),t.around)e.setLocationAtPoint(t.around,t.aroundPoint);else{const t=Ie(e.zoom-i),r=p>i?Math.min(2,_):Math.max(.5,_),n=Math.pow(r,1-a),s=Im(e.worldSize,f.add(m.mult(a*n)).mult(t));e.setLocationAtPoint(e.renderWorldCopies?s.wrap():s,h)}},isZooming:l,elevationCenter:d}}handleFlyTo(e,t){const i=void 0!==t.zoom,r=e.zoom,n=e.applyConstrain(qd.convert(t.center||t.locationAtOffset),i?+t.zoom:r),s=n.center,a=n.zoom;ag(e,s);const o=Pm(e.worldSize,t.locationAtOffset),l=Pm(e.worldSize,s).sub(o),c=l.mag(),h=Ie(a-r);let u;if(void 0!==t.minZoom){const i=Math.min(+t.minZoom,r,a);u=Ie(e.applyConstrain(s,i).zoom-r)}return{easeFunc:(t,i,n,c)=>{e.setZoom(1===t?a:r+Me(i));const h=1===t?s:Im(e.worldSize,o.add(l.mult(n)).mult(i));e.setLocationAtPoint(e.renderWorldCopies?h.wrap():h,c)},scaleOfZoom:h,targetCenter:s,scaleOfMinZoom:u,pixelPathLength:c}}}class gg{constructor(e,t,i){this.blendFunction=e,this.blendColor=t,this.mask=i}}gg.Replace=[1,0],gg.disabled=new gg(gg.Replace,Li.transparent,[!1,!1,!1,!1]),gg.unblended=new gg(gg.Replace,Li.transparent,[!0,!0,!0,!0]),gg.alphaBlended=new gg([1,771],Li.transparent,[!0,!0,!0,!0]);const yg=2305;class xg{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i}}xg.disabled=new xg(!1,1029,yg),xg.backCCW=new xg(!0,1029,yg),xg.frontCCW=new xg(!0,1028,yg);class vg{constructor(e,t,i){this.func=e,this.mask=t,this.range=i}}vg.ReadOnly=!1,vg.ReadWrite=!0,vg.disabled=new vg(519,vg.ReadOnly,[0,1]);const bg=7680;class wg{constructor(e,t,i,r,n,s){this.test=e,this.ref=t,this.mask=i,this.fail=r,this.depthFail=n,this.pass=s}}wg.disabled=new wg({func:519,mask:0},0,0,bg,bg,bg);const Tg=new WeakMap;function Sg(e){var t;if(Tg.has(e))return Tg.get(e);{const i=null===(t=e.getParameter(e.VERSION))||void 0===t?void 0:t.startsWith("WebGL 2.0");return Tg.set(e,i),i}}class Pg{get awaitingQuery(){return!!this._readbackQueue}constructor(e){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=e;const t=e.context,i=t.gl;this._texFormat=i.RGBA,this._texType=i.UNSIGNED_BYTE;const r=new Uo;r.emplaceBack(-1,-1),r.emplaceBack(2,-1),r.emplaceBack(-1,2);const n=new sl;n.emplaceBack(0,1,2),this._fullscreenTriangle=new eg(t.createVertexBuffer(r,tg.members),t.createIndexBuffer(n),hl.simpleSegment(0,0,r.length,n.length)),this._resultBuffer=new Uint8Array(4),t.activeTexture.set(i.TEXTURE1);const s=i.createTexture();i.bindTexture(i.TEXTURE_2D,s),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,i.NEAREST),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,i.NEAREST),i.texImage2D(i.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=t.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(s),Sg(i)&&(this._pbo=i.createBuffer(),i.bindBuffer(i.PIXEL_PACK_BUFFER,this._pbo),i.bufferData(i.PIXEL_PACK_BUFFER,4,i.STREAM_READ),i.bindBuffer(i.PIXEL_PACK_BUFFER,null))}destroy(){const e=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),e.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null}updateErrorLoop(e,t){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(e,t),this._updateCount++,this._measuredError}_bindFramebuffer(){const e=this._cachedRenderContext.context,t=e.gl;e.activeTexture.set(t.TEXTURE1),t.bindTexture(t.TEXTURE_2D,this._fbo.colorAttachment.get()),e.bindFramebuffer.set(this._fbo.framebuffer)}_renderErrorTexture(e,t){const i=this._cachedRenderContext.context,r=i.gl;if(this._bindFramebuffer(),i.viewport.set([0,0,this._texWidth,this._texHeight]),i.clear({color:Li.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(i,r.TRIANGLES,vg.disabled,wg.disabled,gg.unblended,xg.disabled,((e,t)=>({u_input:e,u_output_expected:t}))(e,t),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&Sg(r)){r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.readBuffer(r.COLOR_ATTACHMENT0),r.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),r.bindBuffer(r.PIXEL_PACK_BUFFER,null);const e=r.fenceSync(r.SYNC_GPU_COMMANDS_COMPLETE,0);r.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:e}}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null}}_tryReadback(){const e=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&Sg(e)){const t=e.clientWaitSync(this._readbackQueue.sync,0,0);if(t===e.WAIT_FAILED)return Re("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(t===e.TIMEOUT_EXPIRED)return;e.bindBuffer(e.PIXEL_PACK_BUFFER,this._pbo),e.getBufferSubData(e.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),e.bindBuffer(e.PIXEL_PACK_BUFFER,null)}else this._bindFramebuffer(),e.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=Pg._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount}static _parseRGBA8float(e){let t=0;return t+=e[0]/256,t+=e[1]/65536,t+=e[2]/16777216,e[3]<127&&(t=-t),t/128}}function Ig(e,t){const i=void 0!==e.granularity?Math.max(e.granularity,1):1,r=i+(e.generateBorders?2:0),n=i+(e.extendToNorthPole||e.generateBorders?1:0)+(e.extendToSouthPole||e.generateBorders?1:0),s=r+1,a=n+1,o=e.generateBorders?-1:0,l=e.generateBorders||e.extendToNorthPole?-1:0,c=i+(e.generateBorders?1:0),h=i+(e.generateBorders||e.extendToSouthPole?1:0),u=s*a,d=r*n*6,p=s*a>65536;if(p&&"16bit"===t)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const f=p||"32bit"===t,m=new Int16Array(2*u);let _=0;for(let t=l;t<=h;t++)for(let r=o;r<=c;r++){let n=r/i*Q;-1===r&&(n=-64),r===i+1&&(n=8256);let s=t/i*Q;-1===t&&(s=e.extendToNorthPole?Th:-64),t===i+1&&(s=e.extendToSouthPole?Sh:8256),m[_++]=n,m[_++]=s}const g=f?new Uint32Array(d):new Uint16Array(d);let y=0;for(let e=0;e<n;e++)for(let t=0;t<r;t++){const i=t+1+e*s,r=t+(e+1)*s,n=t+1+(e+1)*s;g[y++]=t+e*s,g[y++]=r,g[y++]=i,g[y++]=i,g[y++]=r,g[y++]=n}return{vertices:m.buffer.slice(0),indices:g.buffer.slice(0),uses32bitIndices:f}}const Mg=new wh({fill:new bh(128,2),line:new bh(512,0),tile:new bh(128,32),stencil:new bh(128,1),circle:3});class Eg{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3}get name(){return"vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return!0}get shaderVariantName(){return"globe"}get shaderDefine(){return"#define GLOBE"}get shaderPreludeCode(){return J_.projectionGlobe}get vertexShaderPreludeCode(){return J_.projectionMercator.vertexSource}get subdivisionGranularity(){return Mg}get useGlobeControls(){return!0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy()}updateGPUdependent(e){this._errorMeasurement||(this._errorMeasurement=new Pg(e));const t=Kd(this._errorQueryLatitudeDegrees),i=2*Math.atan(Math.exp(Math.PI-t*Math.PI*2))-.5*Math.PI,r=this._errorMeasurement.updateErrorLoop(t,i),n=rt();r!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=r,this._errorMeasurementLastChangeTime=n);const s=Math.min(Math.max((n-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=me(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,ge(s))}_getMeshKey(e){return`${e.granularity.toString(36)}_${e.generateBorders?"b":""}${e.extendToNorthPole?"n":""}${e.extendToSouthPole?"s":""}`}getMeshFromTileID(e,t,i,r,n){const s=("stencil"===n?Mg.stencil:Mg.tile).getGranularityForZoomLevel(t.z);return this._getMesh(e,{granularity:s,generateBorders:i,extendToNorthPole:0===t.y&&r,extendToSouthPole:t.y===(1<<t.z)-1&&r})}_getMesh(e,t){const i=this._getMeshKey(t);if(i in this._tileMeshCache)return this._tileMeshCache[i];const r=function(e,t){const i=Ig(t,"16bit"),r=Uo.deserialize({arrayBuffer:i.vertices,length:i.vertices.byteLength/2/2}),n=sl.deserialize({arrayBuffer:i.indices,length:i.indices.byteLength/2/3});return new eg(e.createVertexBuffer(r,tg.members),e.createIndexBuffer(n),hl.simpleSegment(0,0,r.length,n.length))}(e,t);return this._tileMeshCache[i]=r,r}recalculate(e){}hasTransition(){const e=rt();let t=!1;return t=t||(e-this._errorMeasurementLastChangeTime)/1e3<.7,t=t||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,t}setErrorQueryLatitudeDegrees(e){this._errorQueryLatitudeDegrees=e}}const Cg=new Ha({type:new Ga(It.projection.type)});class Ag extends Pt{constructor(e){super(),this._transitionable=new Ba(Cg,void 0),this.setProjection(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new Da(0)),this._mercatorProjection=new ng,this._verticalPerspectiveProjection=new Eg}get transitionState(){const e=this.properties.get("type");if("string"==typeof e&&"mercator"===e)return 0;if("string"==typeof e&&"vertical-perspective"===e)return 1;if(e instanceof Wi){if("vertical-perspective"===e.from&&"mercator"===e.to)return 1-e.transition;if("mercator"===e.from&&"vertical-perspective"===e.to)return e.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return"globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy()}updateGPUdependent(e){this._mercatorProjection.updateGPUdependent(e),this._verticalPerspectiveProjection.updateGPUdependent(e)}getMeshFromTileID(e,t,i,r,n){return this.currentProjection.getMeshFromTileID(e,t,i,r,n)}setProjection(e){this._transitionable.setValue("type",(null==e?void 0:e.type)||"mercator")}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}setErrorQueryLatitudeDegrees(e){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(e),this._mercatorProjection.setErrorQueryLatitudeDegrees(e)}}function zg(e){const t=kg(e.worldSize,e.center.lat);return 2*Math.PI*t}function Dg(e,t,i,r,n){const s=1/(1<<n),a=t/Q*s+r*s,o=pe((e/Q*s+i*s)*Math.PI*2+Math.PI,2*Math.PI),l=2*Math.atan(Math.exp(Math.PI-a*Math.PI*2))-.5*Math.PI,c=Math.cos(l),h=new Float64Array(3);return h[0]=Math.sin(o)*c,h[1]=Math.sin(l),h[2]=Math.cos(o)*c,h}function Rg(e){return function(e,t){const i=Math.cos(t),r=new Float64Array(3);return r[0]=Math.sin(e)*i,r[1]=Math.sin(t),r[2]=Math.cos(e)*i,r}(e.lng*Math.PI/180,e.lat*Math.PI/180)}function kg(e,t){return e/(2*Math.PI)/Math.cos(t*Math.PI/180)}function Lg(e){const t=Math.asin(e[1])/Math.PI*180,i=Math.sqrt(e[0]*e[0]+e[2]*e[2]);if(i>1e-6){const r=e[0]/i,n=Math.acos(e[2]/i),s=(r>0?n:-n)/Math.PI*180;return new qd(be(s,-180,180),t)}return new qd(0,t)}function Fg(e){return Math.cos(e*Math.PI/180)}function Bg(e,t){const i=Fg(e);return Me(Fg(t)/i)}function Og(e,t){const i=e.rotate(t.bearingInRadians),r=t.zoom+Bg(t.center.lat,0),n=me(1/Fg(t.center.lat),1/Fg(Math.min(Math.abs(t.center.lat),60)),fe(r,7,3,0,1)),s=360/zg({worldSize:t.worldSize,center:{lat:t.center.lat}});return new qd(t.center.lng-i.x*s*n,ve(t.center.lat+i.y*s,-85.051129,$e))}function Vg(e){const t=.5*e,i=Math.sin(t),r=Math.cos(t);return Math.log(i+r)-Math.log(r-i)}function jg(e,t,i,r){const n=e.lat+i*r;if(Math.abs(i)>1){const s=(Math.sign(e.lat+i)!==Math.sign(e.lat)?-Math.abs(e.lat):Math.abs(e.lat))*Math.PI/180,a=Math.abs(e.lat+i)*Math.PI/180,o=Vg(s+r*(a-s)),l=Vg(s),c=Vg(a);return new qd(e.lng+t*((o-l)/(c-l)),n)}return new qd(e.lng+t*r,n)}class Ng{constructor(e){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._boundingVolumeFactory=e}swapBuffers(){if(!this._hadAnyChanges)return;const e=this._cachePrevious;this._cachePrevious=this._cache,this._cache=e,this._cache.clear(),this._hadAnyChanges=!1}getTileBoundingVolume(e,t,i,r){const n=`${e.z}_${e.x}_${e.y}_${(null==r?void 0:r.terrain)?"t":""}`,s=this._cache.get(n);if(s)return s;const a=this._cachePrevious.get(n);if(a)return this._cache.set(n,a),a;const o=this._boundingVolumeFactory(e,t,i,r);return this._cache.set(n,o),this._hadAnyChanges=!0,o}}class Ug{constructor(e,t,i,r){this.min=i,this.max=r,this.points=e,this.planes=t}static fromAabb(e,t){const i=[];for(let r=0;r<8;r++)i.push([1&~r?e[0]:t[0],1==(r>>1&1)?t[1]:e[1],1==(r>>2&1)?t[2]:e[2]]);return new Ug(i,[[-1,0,0,t[0]],[1,0,0,-e[0]],[0,-1,0,t[1]],[0,1,0,-e[1]],[0,0,-1,t[2]],[0,0,1,-e[2]]],e,t)}static fromCenterSizeAngles(e,t,i){const r=q([],i[0],i[1],i[2]),n=B([],[t[0],0,0],r),s=B([],[0,t[1],0],r),a=B([],[0,0,t[2]],r),o=[...e],l=[...e];for(let t=0;t<8;t++)for(let i=0;i<3;i++){const r=e[i]+n[i]*(1&~t?-1:1)+s[i]*(1==(t>>1&1)?1:-1)+a[i]*(1==(t>>2&1)?1:-1);o[i]=Math.min(o[i],r),l[i]=Math.max(l[i],r)}const c=[];for(let t=0;t<8;t++){const i=[...e];D(i,i,R([],n,1&~t?-1:1)),D(i,i,R([],s,1==(t>>1&1)?1:-1)),D(i,i,R([],a,1==(t>>2&1)?1:-1)),c.push(i)}return new Ug(c,[[...n,-L(n,c[0])],[...s,-L(s,c[0])],[...a,-L(a,c[0])],[-n[0],-n[1],-n[2],-L(n,c[7])],[-s[0],-s[1],-s[2],-L(s,c[7])],[-a[0],-a[1],-a[2],-L(a,c[7])]],o,l)}intersectsFrustum(e){let t=!0;const i=this.points.length,r=this.planes.length,n=e.planes.length,s=e.points.length;for(let r=0;r<n;r++){const n=e.planes[r];let s=0;for(let e=0;e<i;e++){const t=this.points[e];n[0]*t[0]+n[1]*t[1]+n[2]*t[2]+n[3]>=0&&s++}if(0===s)return 0;s<i&&(t=!1)}if(t)return 2;for(let t=0;t<r;t++){const i=this.planes[t];let r=0;for(let t=0;t<s;t++){const n=e.points[t];i[0]*n[0]+i[1]*n[1]+i[2]*n[2]+i[3]>=0&&r++}if(0===r)return 0}return 1}intersectsPlane(e){const t=this.points.length;let i=0;for(let r=0;r<t;r++){const t=this.points[r];e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]>=0&&i++}return i===t?2:0===i?0:1}}function Gg(e,t,i){const r=e-t;return r<0?-r:Math.max(0,r-i)}function Zg(e,t,i,r,n){const s=e-i;let a;return a=s<0?Math.min(-s,1+s-n):s>1?Math.min(Math.max(s-n,0),1-s):0,Math.max(a,Gg(t,r,n))}class $g{constructor(){this._boundingVolumeCache=new Ng(this._computeTileBoundingVolume)}prepareNextFrame(){this._boundingVolumeCache.swapBuffers()}distanceToTile2d(e,t,i,r){const n=1<<i.z,s=1/n,a=i.x/n,o=i.y/n;let l=2;return l=Math.min(l,Zg(e,t,a,o,s)),l=Math.min(l,Zg(e,t,a+.5,-o-s,s)),l=Math.min(l,Zg(e,t,a+.5,2-o-s,s)),l}getWrap(e,t,i){const r=1<<t.z,n=1/r,s=t.x/r,a=Gg(e.x,s,n),o=Gg(e.x,s-1,n),l=Gg(e.x,s+1,n),c=Math.min(a,o,l);return c===l?1:c===o?-1:0}allowVariableZoom(e,t){return Lm(e,t)>4}allowWorldCopies(){return!1}getTileBoundingVolume(e,t,i,r){return this._boundingVolumeCache.getTileBoundingVolume(e,t,i,r)}_computeTileBoundingVolume(e,t,i,r){var n,s;let a=0,o=0;if(null==r?void 0:r.terrain){const l=new hp(e.z,t,e.z,e.x,e.y),c=r.terrain.getMinMaxElevation(l);a=null!==(n=c.minElevation)&&void 0!==n?n:Math.min(0,i),o=null!==(s=c.maxElevation)&&void 0!==s?s:Math.max(0,i)}if(a/=$d,o/=$d,a+=1,o+=1,e.z<=0)return Ug.fromAabb([-o,-o,-o],[o,o,o]);if(1===e.z)return Ug.fromAabb([0===e.x?-o:0,0===e.y?0:-o,-o],[0===e.x?0:o,0===e.y?o:0,o]);{const t=[Dg(0,0,e.x,e.y,e.z),Dg(Q,0,e.x,e.y,e.z),Dg(Q,Q,e.x,e.y,e.z),Dg(0,Q,e.x,e.y,e.z)],i=[];for(const e of t)i.push(R([],e,o));if(o!==a)for(const e of t)i.push(R([],e,a));0===e.y&&i.push([0,1,0]),e.y===(1<<e.z)-1&&i.push([0,-1,0]);const r=[1,1,1],n=[-1,-1,-1];for(const e of i)for(let t=0;t<3;t++)r[t]=Math.min(r[t],e[t]),n[t]=Math.max(n[t],e[t]);const s=Dg(4096,4096,e.x,e.y,e.z),l=F([],[0,1,0],s);k(l,l);const c=F([],s,l);k(c,c);const h=F([],t[2],t[1]);k(h,h);const u=F([],t[0],t[3]);k(u,u),i.push(R([],s,o)),e.y>=(1<<e.z)/2&&i.push(R([],Dg(4096,0,e.x,e.y,e.z),o)),e.y<(1<<e.z)/2&&i.push(R([],Dg(4096,Q,e.x,e.y,e.z),o));const d=qg(s,i),p=qg(c,i),f=[-s[0],-s[1],-s[2],d.max],m=[s[0],s[1],s[2],-d.min],_=[-c[0],-c[1],-c[2],p.max],g=[c[0],c[1],c[2],-p.min],y=[...h,0],x=[...u,0],v=[];return 0===e.y?v.push(le(x,y,f),le(x,y,m)):v.push(le(_,y,f),le(_,y,m),le(_,x,f),le(_,x,m)),e.y===(1<<e.z)-1?v.push(le(x,y,f),le(x,y,m)):v.push(le(g,y,f),le(g,y,m),le(g,x,f),le(g,x,m)),new Ug(v,[f,m,_,g,y,x],r,n)}}}function qg(e,t){let i=1/0,r=-1/0;for(const n of t){const t=L(e,n);i=Math.min(i,t),r=Math.max(r,t)}return{min:i,max:r}}class Wg{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e)}setMaxZoom(e){this._helper.setMaxZoom(e)}setMinPitch(e){this._helper.setMinPitch(e)}setMaxPitch(e){this._helper.setMaxPitch(e)}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e)}setBearing(e){this._helper.setBearing(e)}setPitch(e){this._helper.setPitch(e)}setRoll(e){this._helper.setRoll(e)}setFov(e){this._helper.setFov(e)}setZoom(e){this._helper.setZoom(e)}setCenter(e){this._helper.setCenter(e)}setElevation(e){this._helper.setElevation(e)}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e)}setPadding(e){this._helper.setPadding(e)}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t){this._helper.resize(e,t)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e)}setConstrainOverride(e){this._helper.setConstrainOverride(e)}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e){}constructor(e){this._cachedClippingPlane=te(),this._projectionMatrix=ne(),this._globeViewProjMatrix32f=se(),this._globeViewProjMatrixNoCorrection=ne(),this._globeViewProjMatrixNoCorrectionInverted=ne(),this._globeProjMatrixInverted=ne(),this._cameraPosition=ie(),this._globeLatitudeErrorCorrectionRadians=0,this.defaultConstrain=(e,t)=>{const i=ve(e.lat,-85.051129,$e),r=ve(+t,this.minZoom+Bg(0,i),this.maxZoom);return{center:new qd(e.lng,i),zoom:r}},this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new lg({calcMatrices:()=>{this._calcMatrices()},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._coveringTilesDetailsProvider=new $g}clone(){const e=new Wg;return e.apply(this,!1),e}apply(e,t,i){this._globeLatitudeErrorCorrectionRadians=i||0,this._helper.apply(e,t)}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const e=ie();return e[0]=this._cameraPosition[0],e[1]=this._cameraPosition[1],e[2]=this._cameraPosition[2],e}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(e){const{overscaledTileID:t,applyGlobeMatrix:i}=e,r=this._helper.getMercatorTileCoordinates(t);return{mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:r,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(e){const t=this.pitchInRadians,i=this.cameraToCenterDistance/e,r=Math.sin(t)*i,n=Math.cos(t)*i+1,s=1/Math.sqrt(r*r+n*n)*1;let a=-r,o=n;const l=Math.sqrt(a*a+o*o);a/=l,o/=l;const c=[0,a,o];j(c,c,[0,0,0],-this.bearingInRadians),O(c,c,[0,0,0],-1*this.center.lat*Math.PI/180),V(c,c,[0,0,0],this.center.lng*Math.PI/180);const h=1/A(c);return R(c,c,h),[...c,-s*h]}isLocationOccluded(e){return!this.isSurfacePointVisible(Rg(e))}transformLightDirection(e){const t=this._helper._center.lng*Math.PI/180,i=this._helper._center.lat*Math.PI/180,r=Math.cos(i),n=[Math.sin(t)*r,Math.sin(i),Math.cos(t)*r],s=[n[2],0,-n[0]],a=[0,0,0];F(a,s,n),k(s,s),k(a,a);const o=[0,0,0];return k(o,[s[0]*e[0]+a[0]*e[1]+n[0]*e[2],s[1]*e[0]+a[1]*e[1]+n[1]*e[2],s[2]*e[0]+a[2]*e[1]+n[2]*e[2]]),o}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(e,t,i){const r=function(e,t,i){const r=1/(1<<i.z);return new ip(e/Q*r+i.x*r,t/Q*r+i.y*r)}(e,t,i.canonical),n=(s=r.y,[pe(r.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-s*Math.PI*2))-.5*Math.PI]);var s;return this.getCircleRadiusCorrection()/Math.cos(n[1])}projectTileCoordinates(e,t,i,r){const n=i.canonical,a=Dg(e,t,n.x,n.y,n.z),o=1+(r?r(e,t):0)/$d,l=[a[0]*o,a[1]*o,a[2]*o,1];Z(l,l,this._globeViewProjMatrixNoCorrection);const c=this._cachedClippingPlane,h=c[0]*a[0]+c[1]*a[1]+c[2]*a[2]+c[3]<0;return{point:new s(l[0]/l[3],l[1]/l[3]),signedDistanceFromCamera:l[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const e=kg(this.worldSize,this.center.lat),t=re(),i=re();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*e),I(t,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const r=this.centerOffset;t[8]=2*-r.x/this._helper._width,t[9]=2*r.y/this._helper._height,this._projectionMatrix=g(t),this._globeProjMatrixInverted=re(),x(this._globeProjMatrixInverted,t),b(t,t,[0,0,-this.cameraToCenterDistance]),P(t,t,this.rollInRadians),T(t,t,-this.pitchInRadians),P(t,t,this.bearingInRadians),b(t,t,[0,0,-e]);const n=ie();n[0]=e,n[1]=e,n[2]=e,T(i,t,this.center.lat*Math.PI/180),S(i,i,-this.center.lng*Math.PI/180),w(i,i,n),this._globeViewProjMatrixNoCorrection=i,T(t,t,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),S(t,t,-this.center.lng*Math.PI/180),w(t,t,n),this._globeViewProjMatrix32f=new Float32Array(t),this._globeViewProjMatrixNoCorrectionInverted=re(),x(this._globeViewProjMatrixNoCorrectionInverted,i);const s=ie();this._cameraPosition=ie(),this._cameraPosition[2]=this.cameraToCenterDistance/e,j(this._cameraPosition,this._cameraPosition,s,-this.rollInRadians),O(this._cameraPosition,this._cameraPosition,s,this.pitchInRadians),j(this._cameraPosition,this._cameraPosition,s,-this.bearingInRadians),D(this._cameraPosition,this._cameraPosition,[0,0,1]),O(this._cameraPosition,this._cameraPosition,s,-this.center.lat*Math.PI/180),V(this._cameraPosition,this._cameraPosition,s,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(e);const a=g(this._globeViewProjMatrixNoCorrectionInverted);w(a,a,[1,1,-1]),this._cachedFrustum=ug.fromInvProjectionMatrix(a,1,0,this._cachedClippingPlane,!0)}calculateFogMatrix(e){Re("calculateFogMatrix is not supported on globe projection.");const t=re();return y(t),t}getVisibleUnwrappedCoordinates(e){return[new cp(0,e)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){e&&Re("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0)}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,t){if(!this._globeViewProjMatrixNoCorrection)return 1;const i=Rg(e);R(i,i,1+t/$d);const r=te();return Z(r,[i[0],i[1],i[2],1],this._globeViewProjMatrixNoCorrection),r[2]/r[3]}populateCache(e){}getBounds(){const e=.5*this.width,t=.5*this.height,i=[new s(0,0),new s(e,0),new s(this.width,0),new s(this.width,t),new s(this.width,this.height),new s(e,this.height),new s(0,this.height),new s(0,t)],r=[];for(const e of i)r.push(this.unprojectScreenPoint(e));let n=0,a=0,o=0,l=0;const c=this.center;for(const e of r){const t=ue(c.lng,e.lng),i=ue(c.lat,e.lat);t<a&&(a=t),t>n&&(n=t),i<l&&(l=i),i>o&&(o=i)}const h=[c.lng+a,c.lat+l,c.lng+n,c.lat+o];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new Wd(h)}calculateCenterFromCameraLngLatAlt(e,t,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,r)}setLocationAtPoint(e,t){const i=Rg(this.unprojectScreenPoint(t)),r=Rg(e),n=ie();var s;(s=n)[0]=0,s[1]=0,s[2]=0;const a=ie();V(a,i,n,-this.center.lng*Math.PI/180),O(a,a,n,this.center.lat*Math.PI/180);const o=r[0]*r[0]+r[2]*r[2],l=a[0]*a[0];if(o<l)return;const c=Math.sqrt(o-l),h=-c,u=he(r[0],r[2],a[0],c),d=he(r[0],r[2],a[0],h),p=ie();V(p,r,n,-u);const f=he(p[1],p[2],a[1],a[2]),m=ie();V(m,r,n,-d);const _=he(m[1],m[2],a[1],a[2]),g=.5*Math.PI,y=f>=-g&&f<=g,x=_>=-g&&_<=g;let v,b;if(y&&x){const e=this.center.lng*Math.PI/180,t=this.center.lat*Math.PI/180;de(u,e)+de(f,t)<de(d,e)+de(_,t)?(v=u,b=f):(v=d,b=_)}else if(y)v=u,b=f;else{if(!x)return;v=d,b=_}const w=v/Math.PI*180,T=b/Math.PI*180,S=this.center.lat;this.setCenter(new qd(w,ve(T,-90,90))),this.setZoom(this.zoom+Bg(S,this.center.lat))}locationToScreenPoint(e,t){const i=Rg(e);return t&&R(i,i,1+t.getElevationForLngLatZoom(e,this._helper._tileZoom)/$d),this._projectSurfacePointToScreen(i)}_projectSurfacePointToScreen(e){const t=te();return Z(t,[...e,1],this._globeViewProjMatrixNoCorrection),t[0]/=t[3],t[1]/=t[3],new s((.5*t[0]+.5)*this.width,(.5*-t[1]+.5)*this.height)}screenPointToMercatorCoordinate(e,t){if(t){const i=t.pointCoordinate(e);if(i)return i}return ip.fromLngLat(this.unprojectScreenPoint(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(e,t){const i=this._cameraPosition,r=this.getRayDirectionFromPixel(e);return!!this.rayPlanetIntersection(i,r)}getRayDirectionFromPixel(e){const t=te();t[0]=e.x/this.width*2-1,t[1]=-1*(e.y/this.height*2-1),t[2]=1,t[3]=1,Z(t,t,this._globeViewProjMatrixNoCorrectionInverted),t[0]/=t[3],t[1]/=t[3],t[2]/=t[3];const i=ie();i[0]=t[0]-this._cameraPosition[0],i[1]=t[1]-this._cameraPosition[1],i[2]=t[2]-this._cameraPosition[2];const r=ie();return k(r,i),r}isSurfacePointVisible(e){const t=this._cachedClippingPlane;return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]>=0}isSurfacePointOnScreen(e){if(!this.isSurfacePointVisible(e))return!1;const t=te();return Z(t,[...e,1],this._globeViewProjMatrixNoCorrection),t[0]/=t[3],t[1]/=t[3],t[2]/=t[3],t[0]>-1&&t[0]<1&&t[1]>-1&&t[1]<1&&t[2]>-1&&t[2]<1}rayPlanetIntersection(e,t){const i=L(e,t),r=ie(),n=ie();R(n,t,i),U(r,e,n);const s=1-L(r,r);if(s<0)return null;const a=L(e,e)-1,o=-i+(i<0?1:-1)*Math.sqrt(s),l=a/o,c=o;return{tMin:Math.min(l,c),tMax:Math.max(l,c)}}unprojectScreenPoint(e){const t=this._cameraPosition,i=this.getRayDirectionFromPixel(e),r=this.rayPlanetIntersection(t,i);if(r){const e=ie();D(e,t,[i[0]*r.tMin,i[1]*r.tMin,i[2]*r.tMin]);const n=ie();return k(n,e),Lg(n)}const n=this._cachedClippingPlane,s=n[0]*i[0]+n[1]*i[1]+n[2]*i[2],a=-oe(n,t)/s,o=ie();if(a>0)D(o,t,[i[0]*a,i[1]*a,i[2]*a]);else{const e=ie();D(e,t,[2*i[0],2*i[1],2*i[2]]);const r=oe(this._cachedClippingPlane,e);U(o,e,[this._cachedClippingPlane[0]*r,this._cachedClippingPlane[1]*r,this._cachedClippingPlane[2]*r])}const l=function(e){const t=ie();return t[0]=e[0]*-e[3],t[1]=e[1]*-e[3],t[2]=e[2]*-e[3],{center:t,radius:Math.sqrt(1-e[3]*e[3])}}(n),c=function(e,t,i){const r=ie();U(r,i,e);const n=ie();return function(e,t,i,r){e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e[2]=t[2]+i[2]*r}(n,e,r,t/G(r)),n}(l.center,l.radius,o);return Lg(c)}getMatrixForModel(e,t){const i=qd.convert(e),r=1/$d,n=ne();return S(n,n,i.lng/180*Math.PI),T(n,n,-i.lat/180*Math.PI),b(n,n,[0,0,1+t/$d]),T(n,n,.5*Math.PI),w(n,n,[r,r,r]),n}getProjectionDataForCustomLayer(e=!0){const t=this.getProjectionData({overscaledTileID:new hp(0,0,0,0,0),applyGlobeMatrix:e});return t.tileMercatorCoords=[0,0,1,1],t}getFastPathSimpleProjectionMatrix(e){}}class Hg{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e)}setMaxZoom(e){this._helper.setMaxZoom(e)}setMinPitch(e){this._helper.setMinPitch(e)}setMaxPitch(e){this._helper.setMaxPitch(e)}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e)}setBearing(e){this._helper.setBearing(e)}setPitch(e){this._helper.setPitch(e)}setRoll(e){this._helper.setRoll(e)}setFov(e){this._helper.setFov(e)}setZoom(e){this._helper.setZoom(e)}setCenter(e){this._helper.setCenter(e)}setElevation(e){this._helper.setElevation(e)}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e)}setPadding(e){this._helper.setPadding(e)}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e)}setConstrainOverride(e){this._helper.setConstrainOverride(e)}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(e,t){this._globeness=e,this._globeLatitudeErrorCorrectionRadians=t,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().prepareNextFrame(),this._mercatorTransform.getCoveringTilesDetailsProvider().prepareNextFrame()}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(e){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this.defaultConstrain=(e,t)=>this.currentTransform.defaultConstrain(e,t),this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new lg({calcMatrices:()=>{this._calcMatrices()},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._globeness=1,this._mercatorTransform=new dg,this._verticalPerspectiveTransform=new Wg}clone(){const e=new Hg;return e._globeness=this._globeness,e._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,e.apply(this,!1),e}apply(e,t){this._helper.apply(e,t),this._mercatorTransform.apply(this,!1),this._verticalPerspectiveTransform.apply(this,!1,this._globeLatitudeErrorCorrectionRadians)}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(e){const t=this._mercatorTransform.getProjectionData(e),i=this._verticalPerspectiveTransform.getProjectionData(e);return{mainMatrix:this.isGlobeRendering?i.mainMatrix:t.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:e.applyGlobeMatrix?this._globeness:0,fallbackMatrix:t.fallbackMatrix}}isLocationOccluded(e){return this.currentTransform.isLocationOccluded(e)}transformLightDirection(e){return this.currentTransform.transformLightDirection(e)}getPixelScale(){return me(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return me(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(e,t,i){return me(this._mercatorTransform.getPitchedTextCorrection(e,t,i),this._verticalPerspectiveTransform.getPitchedTextCorrection(e,t,i),this._globeness)}projectTileCoordinates(e,t,i,r){return this.currentTransform.projectTileCoordinates(e,t,i,r)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,!1,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ)}calculateFogMatrix(e){return this.currentTransform.calculateFogMatrix(e)}getVisibleUnwrappedCoordinates(e){return this.currentTransform.getVisibleUnwrappedCoordinates(e)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(e){this._mercatorTransform.recalculateZoomAndCenter(e),this._verticalPerspectiveTransform.recalculateZoomAndCenter(e)}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,t){return this.currentTransform.lngLatToCameraDepth(e,t)}populateCache(e){this._mercatorTransform.populateCache(e),this._verticalPerspectiveTransform.populateCache(e)}getBounds(){return this.currentTransform.getBounds()}calculateCenterFromCameraLngLatAlt(e,t,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,r)}setLocationAtPoint(e,t){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(e,t),void this.apply(this._mercatorTransform,!1);this._verticalPerspectiveTransform.setLocationAtPoint(e,t),this.apply(this._verticalPerspectiveTransform,!1)}locationToScreenPoint(e,t){return this.currentTransform.locationToScreenPoint(e,t)}screenPointToMercatorCoordinate(e,t){return this.currentTransform.screenPointToMercatorCoordinate(e,t)}screenPointToLocation(e,t){return this.currentTransform.screenPointToLocation(e,t)}isPointOnMapSurface(e,t){return this.currentTransform.isPointOnMapSurface(e,t)}getRayDirectionFromPixel(e){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(e)}getMatrixForModel(e,t){return this.currentTransform.getMatrixForModel(e,t)}getProjectionDataForCustomLayer(e=!0){const t=this._mercatorTransform.getProjectionDataForCustomLayer(e);if(!this.isGlobeRendering)return t;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(e);return i.fallbackMatrix=t.mainMatrix,i}getFastPathSimpleProjectionMatrix(e){return this.currentTransform.getFastPathSimpleProjectionMatrix(e)}}class Xg{get useGlobeControls(){return!0}handlePanInertia(e,t){const i=Og(e,t);return Math.abs(i.lng-t.center.lng)>180&&(i.lng=t.center.lng+179.5*Math.sign(i.lng-t.center.lng)),{easingCenter:i,easingOffset:new s(0,0)}}handleMapControlsRollPitchBearingZoom(e,t){const i=e.around,r=t.screenPointToLocation(i);e.bearingDelta&&t.setBearing(t.bearing+e.bearingDelta),e.pitchDelta&&t.setPitch(t.pitch+e.pitchDelta),e.rollDelta&&t.setRoll(t.roll+e.rollDelta);const n=t.zoom;e.zoomDelta&&t.setZoom(t.zoom+e.zoomDelta);const s=t.zoom-n;if(0===s)return;const a=ue(t.center.lng,r.lng),o=a/(Math.abs(a/180)+1),l=ue(t.center.lat,r.lat),c=t.getRayDirectionFromPixel(i),h=t.cameraPosition,u=-1*L(h,c),d=ie();D(d,h,[c[0]*u,c[1]*u,c[2]*u]);const p=A(d)-1,f=Math.exp(.5*-Math.max(p-.3,0)),m=kg(t.worldSize,t.center.lat)/Math.min(t.width,t.height),_=fe(m,.9,.5,1,.25),g=(1-Ie(-s))*Math.min(f,_),y=t.center.lat,x=t.zoom,v=new qd(t.center.lng+o*g,ve(t.center.lat+l*g,-85.051129,$e));t.setLocationAtPoint(r,i);const b=t.center,w=fe(Math.abs(a),45,85,0,1),T=fe(m,.75,.35,0,1),S=Math.pow(Math.max(w,T),.25),P=ue(b.lng,v.lng),I=ue(b.lat,v.lat);t.setCenter(new qd(b.lng+P*S,b.lat+I*S).wrap()),t.setZoom(x+Bg(y,t.center.lat))}handleMapControlsPan(e,t,i){if(!e.panDelta)return;const r=t.center.lat,n=t.zoom;t.setCenter(Og(e.panDelta,t).wrap()),t.setZoom(n+Bg(r,t.center.lat))}cameraForBoxAndBearing(e,t,i,r,n){const s=mg(e,t,i,r,n),a=t.left/n.width*2-1,o=(n.width-t.right)/n.width*2-1,l=t.top/n.height*-2+1,c=(n.height-t.bottom)/n.height*-2+1,h=ue(i.getWest(),i.getEast())<0,u=h?i.getEast():i.getWest(),d=h?i.getWest():i.getEast(),p=Math.max(i.getNorth(),i.getSouth()),f=Math.min(i.getNorth(),i.getSouth()),m=u+.5*ue(u,d),_=p+.5*ue(p,f),g=n.clone();g.setCenter(s.center),g.setBearing(s.bearing),g.setPitch(0),g.setRoll(0),g.setZoom(s.zoom);const y=g.modelViewProjectionMatrix,x=[Rg(i.getNorthWest()),Rg(i.getNorthEast()),Rg(i.getSouthWest()),Rg(i.getSouthEast()),Rg(new qd(d,_)),Rg(new qd(u,_)),Rg(new qd(m,p)),Rg(new qd(m,f))],v=Rg(s.center);let b=Number.POSITIVE_INFINITY;for(const e of x)a<0&&(b=Xg.getLesserNonNegativeNonNull(b,Xg.solveVectorScale(e,v,y,"x",a))),o>0&&(b=Xg.getLesserNonNegativeNonNull(b,Xg.solveVectorScale(e,v,y,"x",o))),l>0&&(b=Xg.getLesserNonNegativeNonNull(b,Xg.solveVectorScale(e,v,y,"y",l))),c<0&&(b=Xg.getLesserNonNegativeNonNull(b,Xg.solveVectorScale(e,v,y,"y",c)));if(Number.isFinite(b)&&0!==b)return s.zoom=g.zoom+Me(b),s;pg()}handleJumpToCenterZoom(e,t){const i=e.center.lat,r=e.applyConstrain(t.center?qd.convert(t.center):e.center,e.zoom).center;e.setCenter(r.wrap());const n=void 0!==t.zoom?+t.zoom:e.zoom+Bg(i,r.lat);e.zoom!==n&&e.setZoom(n)}handleEaseTo(e,t){const i=e.zoom,r=e.center,n=e.padding,a={roll:e.roll,pitch:e.pitch,bearing:e.bearing},o={roll:void 0===t.roll?e.roll:t.roll,pitch:void 0===t.pitch?e.pitch:t.pitch,bearing:void 0===t.bearing?e.bearing:t.bearing},l=void 0!==t.zoom,c=!e.isPaddingEqual(t.padding);let h=!1;const u=t.center?qd.convert(t.center):r,d=e.applyConstrain(u,i).center;ag(e,d);const p=e.clone();p.setCenter(d),p.setZoom(l?+t.zoom:i+Bg(r.lat,u.lat)),p.setBearing(t.bearing);const f=new s(ve(e.centerPoint.x+t.offsetAsPoint.x,0,e.width),ve(e.centerPoint.y+t.offsetAsPoint.y,0,e.height));p.setLocationAtPoint(d,f);const m=(t.offset&&t.offsetAsPoint.mag())>0?p.center:d,_=l?+t.zoom:i+Bg(r.lat,m.lat),g=i+Bg(r.lat,0),y=_+Bg(m.lat,0),x=ue(r.lng,m.lng),v=ue(r.lat,m.lat),b=Ie(y-g);return h=_!==i,{easeFunc:i=>{if(Ue(a,o)||fg({startEulerAngles:a,endEulerAngles:o,tr:e,k:i,useSlerp:a.roll!=o.roll}),c&&e.interpolatePadding(n,t.padding,i),t.around)Re("Easing around a point is not supported under globe projection."),e.setLocationAtPoint(t.around,t.aroundPoint);else{const t=y>g?Math.min(2,b):Math.max(.5,b),n=Math.pow(t,1-i),s=jg(r,x,v,i*n);e.setCenter(s.wrap())}if(h){const t=Tr.number(g,y,i)+Bg(0,e.center.lat);e.setZoom(t)}},isZooming:h,elevationCenter:m}}handleFlyTo(e,t){const i=void 0!==t.zoom,r=e.center,n=e.zoom,a=e.padding,o=!e.isPaddingEqual(t.padding),l=e.applyConstrain(qd.convert(t.center||t.locationAtOffset),n).center,c=i?+t.zoom:e.zoom+Bg(e.center.lat,l.lat),h=e.clone();h.setCenter(l),h.setZoom(c),h.setBearing(t.bearing);const u=new s(ve(e.centerPoint.x+t.offsetAsPoint.x,0,e.width),ve(e.centerPoint.y+t.offsetAsPoint.y,0,e.height));h.setLocationAtPoint(l,u);const d=h.center;ag(e,d);const p=function(e,t,i){const r=L(Rg(t),Rg(i)),n=Math.acos(r),s=zg(e);return n/(2*Math.PI)*s}(e,r,d),f=n+Bg(r.lat,0),m=c+Bg(d.lat,0),_=Ie(m-f);let g;if("number"==typeof t.minZoom){const i=+t.minZoom+Bg(d.lat,0),r=Math.min(i,f,m)+Bg(0,d.lat);g=Ie(e.applyConstrain(d,r).zoom+Bg(d.lat,0)-f)}const y=ue(r.lng,d.lng),x=ue(r.lat,d.lat);return{easeFunc:(i,n,s,l)=>{const h=jg(r,y,x,s);o&&e.interpolatePadding(a,t.padding,i);const u=1===i?d:h;e.setCenter(u.wrap());const p=f+Me(n);e.setZoom(1===i?c:p+Bg(0,u.lat))},scaleOfZoom:_,targetCenter:d,scaleOfMinZoom:g,pixelPathLength:p}}static solveVectorScale(e,t,i,r,n){const s="x"===r?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],a=[i[3],i[7],i[11],i[15]],o=e[0]*s[0]+e[1]*s[1]+e[2]*s[2],l=e[0]*a[0]+e[1]*a[1]+e[2]*a[2],c=t[0]*s[0]+t[1]*s[1]+t[2]*s[2],h=t[0]*a[0]+t[1]*a[1]+t[2]*a[2];return c+n*l===o+n*h||a[3]*(o-c)+s[3]*(h-l)+o*h==c*l?null:(c+s[3]-n*h-n*a[3])/(c-o-n*h+n*l)}static getLesserNonNegativeNonNull(e,t){return null!==t&&t>=0&&t<e?t:e}}class Yg{constructor(e){this._globe=e,this._mercatorCameraHelper=new _g,this._verticalPerspectiveCameraHelper=new Xg}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(e,t){return this.currentHelper.handlePanInertia(e,t)}handleMapControlsRollPitchBearingZoom(e,t){return this.currentHelper.handleMapControlsRollPitchBearingZoom(e,t)}handleMapControlsPan(e,t,i){this.currentHelper.handleMapControlsPan(e,t,i)}cameraForBoxAndBearing(e,t,i,r,n){return this.currentHelper.cameraForBoxAndBearing(e,t,i,r,n)}handleJumpToCenterZoom(e,t){this.currentHelper.handleJumpToCenterZoom(e,t)}handleEaseTo(e,t){return this.currentHelper.handleEaseTo(e,t)}handleFlyTo(e,t){return this.currentHelper.handleFlyTo(e,t)}}const Kg=(e,t)=>ma(e,t&&t.filter((e=>"source.canvas"!==e.identifier))),Jg=function(){const e={},t=It.$version;for(const i in It.$root){const r=It.$root[i];if(r.required){let n=null;n="version"===i?t:"array"===r.type?[]:{},null!=n&&(e[i]=n)}}return e}();class Qg extends Pt{constructor(e,t={}){var i,r;super(),this._rtlPluginLoaded=()=>{for(const e in this.tileManagers){const t=this.tileManagers[e].getSource().type;"vector"!==t&&"geojson"!==t||this.tileManagers[e].reload()}},this.map=e,this.dispatcher=new Od(Bd(),e._getMapId()),this.dispatcher.registerMessageHandler("GG",((e,t)=>this.getGlyphs(e,t))),this.dispatcher.registerMessageHandler("GI",((e,t)=>this.getImages(e,t))),this.dispatcher.registerMessageHandler("GDA",((e,t)=>this.getDashes(e,t))),this.imageManager=new gd,this.imageManager.setEventedParent(this);const n=(null===(i=e._container)||void 0===i?void 0:i.lang)||"undefined"!=typeof document&&(null===(r=document.documentElement)||void 0===r?void 0:r.lang)||void 0;this.glyphManager=new wd(e._requestManager,t.localIdeographFontFamily,n),this.lineAtlas=new Ed(256,512),this.crossTileSymbolIndex=new Y_,this._setInitialValues(),this._resetUpdates(),this.dispatcher.broadcast("SR",ct()),ym().on(mm,this._rtlPluginLoaded),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.tileManagers[e.sourceId];if(!t)return;const i=t.getSource();if(i&&i.vectorLayerIds)for(const e in this._layers){const t=this._layers[e];t.source===i.id&&this._validateLayer(t)}}))}_setInitialValues(){var e;this._spritesImagesIds={},this._layers={},this._order=[],this.tileManagers={},this.zoomHistory=new Sa,this._availableImages=[],this._globalState={},this._serializedLayers={},this.stylesheet=null,this.light=null,this.sky=null,this.projection&&(this.projection.destroy(),delete this.projection),this._loaded=!1,this._changed=!1,this._updatedLayers={},this._updatedSources={},this._changedImages={},this._glyphsDidChange=!1,this._updatedPaintProps={},this._layerOrderChanged=!1,this.crossTileSymbolIndex=new((null===(e=this.crossTileSymbolIndex)||void 0===e?void 0:e.constructor)||Object),this.pauseablePlacement=void 0,this.placement=void 0,this.z=0}setGlobalStateProperty(e,t){var i,r,n;this._checkLoaded();const s=null===t?null!==(n=null===(r=null===(i=this.stylesheet.state)||void 0===i?void 0:i[e])||void 0===r?void 0:r.default)&&void 0!==n?n:null:t;if(Ae(s,this._globalState[e]))return this;this._globalState[e]=s,this._applyGlobalStateChanges([e])}getGlobalState(){return this._globalState}setGlobalState(e){this._checkLoaded();const t=[];for(const i in e)!Ae(this._globalState[i],e[i].default)&&(t.push(i),this._globalState[i]=e[i].default);this._applyGlobalStateChanges(t)}_applyGlobalStateChanges(e){if(0===e.length)return;const t=new Set,i={};for(const r of e){i[r]=this._globalState[r];for(const e in this._layers){const i=this._layers[e],n=i.getLayoutAffectingGlobalStateRefs(),s=i.getPaintAffectingGlobalStateRefs(),a=i.getVisibilityAffectingGlobalStateRefs();if(n.has(r)&&t.add(i.source),s.has(r))for(const{name:e,value:t}of s.get(r))this._updatePaintProperty(i,e,t);(null==a?void 0:a.has(r))&&(i.recalculateVisibility(),this._updateLayer(i))}}this.dispatcher.broadcast("UGS",i);for(const e in this.tileManagers)t.has(e)&&(this._reloadSource(e),this._changed=!0)}loadURL(e,t={},i){this.fire(new Tt("dataloading",{dataType:"style"})),t.validate="boolean"!=typeof t.validate||t.validate;const r=this.map._requestManager.transformRequest(e,"Style");this._loadStyleRequest=new AbortController;const n=this._loadStyleRequest;ut(r,this._loadStyleRequest).then((e=>{this._loadStyleRequest=null,this._load(e.data,t,i)})).catch((e=>{this._loadStyleRequest=null,e&&!n.signal.aborted&&this.fire(new St(e))}))}loadJSON(e,t={},i){this.fire(new Tt("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,tt.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,t.validate=!1!==t.validate,this._load(e,t,i)})).catch((()=>{}))}loadEmpty(){this.fire(new Tt("dataloading",{dataType:"style"})),this._load(Jg,{validate:!1})}_load(e,t,i){var r,n;let s=t.transformStyle?t.transformStyle(i,e):e;if(!t.validate||!Kg(this,ha(s))){s=Object.assign({},s),this._loaded=!0,this.stylesheet=s;for(const e in s.sources)this.addSource(e,s.sources[e],{validate:!1});s.sprite?this._loadSprite(s.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(s.glyphs),this._createLayers(),this.light=new Pd(this.stylesheet.light),this._setProjectionInternal((null===(r=this.stylesheet.projection)||void 0===r?void 0:r.type)||"mercator"),this.sky=new Md(this.stylesheet.sky),this.map.setTerrain(null!==(n=this.stylesheet.terrain)&&void 0!==n?n:null),this.fire(new Tt("data",{dataType:"style"})),this.fire(new Tt("style.load"))}}_createLayers(){var e,t,i;const r=Ct(this.stylesheet.layers);this.setGlobalState(null!==(e=this.stylesheet.state)&&void 0!==e?e:null),this.dispatcher.broadcast("SL",r),this._order=r.map((e=>e.id)),this._layers={},this._serializedLayers=null;for(const e of r){const r=pd(e,this._globalState);if(r.setEventedParent(this,{layer:{id:e.id}}),this._layers[e.id]=r,Ja(r)&&this.tileManagers[r.source]){const n=null!==(i=null===(t=e.paint)||void 0===t?void 0:t["raster-fade-duration"])&&void 0!==i?i:r.paint.get("raster-fade-duration");this.tileManagers[r.source].setRasterFadeDuration(n)}}}_loadSprite(e,t=!1,i=void 0){this.imageManager.setLoaded(!1);const r=new AbortController;let s;this._spriteRequest=r,function(e,t,i,r){return n(this,void 0,void 0,(function*(){const s=fd(e),a=i>1?"@2x":"",o={},l={};for(const{id:e,url:i}of s){const n=t.transformRequest(md(i,a,".json"),"SpriteJSON");o[e]=ut(n,r);const s=t.transformRequest(md(i,a,".png"),"SpriteImage");l[e]=xt.getImage(s,r)}return yield Promise.all([...Object.values(o),...Object.values(l)]),function(e,t){return n(this,void 0,void 0,(function*(){const i={};for(const r in e){i[r]={};const n=tt.getImageCanvasContext((yield t[r]).data),s=(yield e[r]).data;for(const e in s){const{width:t,height:a,x:o,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:p,textFitWidth:f,textFitHeight:m}=s[e];i[r][e]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:p,textFitWidth:f,textFitHeight:m,spriteData:{width:t,height:a,x:o,y:l,context:n}}}}return i}))}(o,l)}))}(e,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((e=>{if(this._spriteRequest=null,e)for(const i in e){this._spritesImagesIds[i]=[];const r=this._spritesImagesIds[i]?this._spritesImagesIds[i].filter((t=>!(t in e))):[];for(const e of r)this.imageManager.removeImage(e),this._changedImages[e]=!0;for(const r in e[i]){const n="default"===i?r:`${i}:${r}`;this._spritesImagesIds[i].push(n),n in this.imageManager.images?this.imageManager.updateImage(n,e[i][r],!1):this.imageManager.addImage(n,e[i][r]),t&&(this._changedImages[n]=!0)}}})).catch((e=>{this._spriteRequest=null,s=e,r.signal.aborted||this.fire(new St(s))})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),t&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new Tt("data",{dataType:"style"})),i&&i(s)}))}_unloadSprite(){for(const e of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(e),this._changedImages[e]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new Tt("data",{dataType:"style"}))}_validateLayer(e){const t=this.tileManagers[e.source];if(!t)return;const i=e.sourceLayer;if(!i)return;const r=t.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(i))&&this.fire(new St(new Error(`Source layer "${i}" does not exist on source "${r.id}" as specified by style layer "${e.id}".`)))}loaded(){if(!this._loaded)return!1;if(Object.keys(this._updatedSources).length)return!1;for(const e in this.tileManagers)if(!this.tileManagers[e].loaded())return!1;return!!this.imageManager.isLoaded()}_serializeByIds(e,t=!1){const i=this._serializedAllLayers();if(!e||0===e.length)return Object.values(t?ze(i):i);const r=[];for(const n of e)if(i[n]){const e=t?ze(i[n]):i[n];r.push(e)}return r}_serializedAllLayers(){let e=this._serializedLayers;if(e)return e;e=this._serializedLayers={};const t=Object.keys(this._layers);for(const i of t){const t=this._layers[i];"custom"!==t.type&&(e[i]=t.serialize())}return e}hasTransitions(){var e,t,i;if(null===(e=this.light)||void 0===e?void 0:e.hasTransition())return!0;if(null===(t=this.sky)||void 0===t?void 0:t.hasTransition())return!0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return!0;for(const e in this.tileManagers)if(this.tileManagers[e].hasTransition())return!0;for(const e in this._layers)if(this._layers[e].hasTransition())return!0;return!1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(e){if(!this._loaded)return;const t=this._changed;if(t){const t=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(t.length||i.length)&&this._updateWorkerLayers(t,i);for(const e in this._updatedSources){const t=this._updatedSources[e];if("reload"===t)this._reloadSource(e);else{if("clear"!==t)throw new Error(`Invalid action ${t}`);this._clearSource(e)}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const t in this._updatedPaintProps)this._layers[t].updateTransitions(e);this.light.updateTransitions(e),this.sky.updateTransitions(e),this._resetUpdates()}const i={};for(const e in this.tileManagers){const t=this.tileManagers[e];i[e]=t.used,t.used=!1}for(const t of this._order){const i=this._layers[t];i.recalculate(e,this._availableImages),!i.isHidden(e.zoom)&&i.source&&(this.tileManagers[i.source].used=!0)}for(const e in i){const t=this.tileManagers[e];!!i[e]!=!!t.used&&t.fire(new Tt("data",{sourceDataType:"visibility",dataType:"source",sourceId:e}))}this.light.recalculate(e),this.sky.recalculate(e),this.projection.recalculate(e),this.z=e.zoom,t&&this.fire(new Tt("data",{dataType:"style"}))}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this.tileManagers)this.tileManagers[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={}}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const e in this.tileManagers)this.tileManagers[e].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(e,!1),removedIds:t})}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1}setState(e,t={}){var i;this._checkLoaded();const r=this.serialize();if(e=t.transformStyle?t.transformStyle(r,e):e,(null===(i=t.validate)||void 0===i||i)&&Kg(this,ha(e)))return!1;(e=ze(e)).layers=Ct(e.layers);const n=function(e,t){if(!e)return[{command:"setStyle",args:[t]}];let i=[];try{if(!At(e.version,t.version))return[{command:"setStyle",args:[t]}];At(e.center,t.center)||i.push({command:"setCenter",args:[t.center]}),At(e.state,t.state)||i.push({command:"setGlobalState",args:[t.state]}),At(e.centerAltitude,t.centerAltitude)||i.push({command:"setCenterAltitude",args:[t.centerAltitude]}),At(e.zoom,t.zoom)||i.push({command:"setZoom",args:[t.zoom]}),At(e.bearing,t.bearing)||i.push({command:"setBearing",args:[t.bearing]}),At(e.pitch,t.pitch)||i.push({command:"setPitch",args:[t.pitch]}),At(e.roll,t.roll)||i.push({command:"setRoll",args:[t.roll]}),At(e.sprite,t.sprite)||i.push({command:"setSprite",args:[t.sprite]}),At(e.glyphs,t.glyphs)||i.push({command:"setGlyphs",args:[t.glyphs]}),At(e.transition,t.transition)||i.push({command:"setTransition",args:[t.transition]}),At(e.light,t.light)||i.push({command:"setLight",args:[t.light]}),At(e.terrain,t.terrain)||i.push({command:"setTerrain",args:[t.terrain]}),At(e.sky,t.sky)||i.push({command:"setSky",args:[t.sky]}),At(e.projection,t.projection)||i.push({command:"setProjection",args:[t.projection]});const r={},n=[];!function(e,t,i,r){let n;for(n in t=t||{},e=e||{})Object.prototype.hasOwnProperty.call(e,n)&&(Object.prototype.hasOwnProperty.call(t,n)||Rt(n,i,r));for(n in t)Object.prototype.hasOwnProperty.call(t,n)&&(Object.prototype.hasOwnProperty.call(e,n)?At(e[n],t[n])||("geojson"===e[n].type&&"geojson"===t[n].type&&Lt(e,t,n)?zt(i,{command:"setGeoJSONSourceData",args:[n,t[n].data]}):kt(n,t,i,r)):Dt(n,t,i))}(e.sources,t.sources,n,r);const s=[];e.layers&&e.layers.forEach((e=>{"source"in e&&r[e.source]?i.push({command:"removeLayer",args:[e.id]}):s.push(e)})),i=i.concat(n),function(e,t,i){t=t||[];const r=(e=e||[]).map(Bt),n=t.map(Bt),s=e.reduce(Ot,{}),a=t.reduce(Ot,{}),o=r.slice(),l=Object.create(null);let c,h,u,d,p;for(let e=0,t=0;e<r.length;e++)c=r[e],Object.prototype.hasOwnProperty.call(a,c)?t++:(zt(i,{command:"removeLayer",args:[c]}),o.splice(o.indexOf(c,t),1));for(let e=0,t=0;e<n.length;e++)c=n[n.length-1-e],o[o.length-1-e]!==c&&(Object.prototype.hasOwnProperty.call(s,c)?(zt(i,{command:"removeLayer",args:[c]}),o.splice(o.lastIndexOf(c,o.length-t),1)):t++,d=o[o.length-e],zt(i,{command:"addLayer",args:[a[c],d]}),o.splice(o.length-e,0,c),l[c]=!0);for(let e=0;e<n.length;e++)if(c=n[e],h=s[c],u=a[c],!l[c]&&!At(h,u))if(At(h.source,u.source)&&At(h["source-layer"],u["source-layer"])&&At(h.type,u.type)){for(p in Ft(h.layout,u.layout,i,c,null,"setLayoutProperty"),Ft(h.paint,u.paint,i,c,null,"setPaintProperty"),At(h.filter,u.filter)||zt(i,{command:"setFilter",args:[c,u.filter]}),At(h.minzoom,u.minzoom)&&At(h.maxzoom,u.maxzoom)||zt(i,{command:"setLayerZoomRange",args:[c,u.minzoom,u.maxzoom]}),h)Object.prototype.hasOwnProperty.call(h,p)&&"layout"!==p&&"paint"!==p&&"filter"!==p&&"metadata"!==p&&"minzoom"!==p&&"maxzoom"!==p&&(0===p.indexOf("paint.")?Ft(h[p],u[p],i,c,p.slice(6),"setPaintProperty"):At(h[p],u[p])||zt(i,{command:"setLayerProperty",args:[c,p,u[p]]}));for(p in u)Object.prototype.hasOwnProperty.call(u,p)&&!Object.prototype.hasOwnProperty.call(h,p)&&"layout"!==p&&"paint"!==p&&"filter"!==p&&"metadata"!==p&&"minzoom"!==p&&"maxzoom"!==p&&(0===p.indexOf("paint.")?Ft(h[p],u[p],i,c,p.slice(6),"setPaintProperty"):At(h[p],u[p])||zt(i,{command:"setLayerProperty",args:[c,p,u[p]]}))}else zt(i,{command:"removeLayer",args:[c]}),d=o[o.lastIndexOf(c)+1],zt(i,{command:"addLayer",args:[u,d]})}(s,t.layers,i)}catch(e){console.warn("Unable to compute style diff:",e),i=[{command:"setStyle",args:[t]}]}return i}(r,e),s=this._getOperationsToPerform(n);if(s.unimplemented.length>0)throw new Error(`Unimplemented: ${s.unimplemented.join(", ")}.`);if(0===s.operations.length)return!1;for(const e of s.operations)e();return this.stylesheet=e,this._serializedLayers=null,this.fire(new Tt("style.load",{style:this})),!0}_getOperationsToPerform(e){const t=[],i=[];for(const r of e)switch(r.command){case"setCenter":case"setZoom":case"setBearing":case"setPitch":case"setRoll":continue;case"addLayer":t.push((()=>this.addLayer.apply(this,r.args)));break;case"removeLayer":t.push((()=>this.removeLayer.apply(this,r.args)));break;case"setPaintProperty":t.push((()=>this.setPaintProperty.apply(this,r.args)));break;case"setLayoutProperty":t.push((()=>this.setLayoutProperty.apply(this,r.args)));break;case"setFilter":t.push((()=>this.setFilter.apply(this,r.args)));break;case"addSource":t.push((()=>this.addSource.apply(this,r.args)));break;case"removeSource":t.push((()=>this.removeSource.apply(this,r.args)));break;case"setLayerZoomRange":t.push((()=>this.setLayerZoomRange.apply(this,r.args)));break;case"setLight":t.push((()=>this.setLight.apply(this,r.args)));break;case"setGeoJSONSourceData":t.push((()=>this.setGeoJSONSourceData.apply(this,r.args)));break;case"setGlyphs":t.push((()=>this.setGlyphs.apply(this,r.args)));break;case"setSprite":t.push((()=>this.setSprite.apply(this,r.args)));break;case"setTerrain":t.push((()=>this.map.setTerrain.apply(this,r.args)));break;case"setSky":t.push((()=>this.setSky.apply(this,r.args)));break;case"setProjection":this.setProjection.apply(this,r.args);break;case"setGlobalState":t.push((()=>this.setGlobalState.apply(this,r.args)));break;case"setTransition":t.push((()=>{}));break;default:i.push(r.command)}return{operations:t,unimplemented:i}}addImage(e,t){if(this.getImage(e))return this.fire(new St(new Error(`An image named "${e}" already exists.`)));this.imageManager.addImage(e,t),this._afterImageUpdated(e)}updateImage(e,t){this.imageManager.updateImage(e,t)}getImage(e){return this.imageManager.getImage(e)}removeImage(e){if(!this.getImage(e))return this.fire(new St(new Error(`An image named "${e}" does not exist.`)));this.imageManager.removeImage(e),this._afterImageUpdated(e)}_afterImageUpdated(e){this._availableImages=this.imageManager.listImages(),this._changedImages[e]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new Tt("data",{dataType:"style"}))}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(e,t,i={}){if(this._checkLoaded(),void 0!==this.tileManagers[e])throw new Error(`Source "${e}" already exists.`);if(!t.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(t).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(t.type)>=0&&this._validate(ha.source,`sources.${e}`,t,null,i))return;this.map&&this.map._collectResourceTiming&&(t.collectResourceTiming=!0);const r=this.tileManagers[e]=new $m(e,t,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:e}))),r.onAdd(this.map),this._changed=!0}removeSource(e){if(this._checkLoaded(),void 0===this.tileManagers[e])throw new Error("There is no source with this ID");for(const t in this._layers)if(this._layers[t].source===e)return this.fire(new St(new Error(`Source "${e}" cannot be removed while layer "${t}" is using it.`)));const t=this.tileManagers[e];delete this.tileManagers[e],delete this._updatedSources[e],t.fire(new Tt("data",{sourceDataType:"metadata",dataType:"source",sourceId:e})),t.setEventedParent(null),t.onRemove(this.map),this._changed=!0}setGeoJSONSourceData(e,t){if(this._checkLoaded(),void 0===this.tileManagers[e])throw new Error(`There is no source with this ID=${e}`);const i=this.tileManagers[e].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(t),this._changed=!0}getSource(e){return this.tileManagers[e]&&this.tileManagers[e].getSource()}addLayer(e,t,i={}){this._checkLoaded();const r=e.id;if(this.getLayer(r))return void this.fire(new St(new Error(`Layer "${r}" already exists on this map.`)));let n;if("custom"===e.type){if(Kg(this,function(e){const t=[],i=e.id;return void 0===i&&t.push({message:`layers.${i}: missing required property "id"`}),void 0===e.render&&t.push({message:`layers.${i}: missing required method "render"`}),e.renderingMode&&"2d"!==e.renderingMode&&"3d"!==e.renderingMode&&t.push({message:`layers.${i}: property "renderingMode" must be either "2d" or "3d"`}),t}(e)))return;n=pd(e,this._globalState)}else{if("source"in e&&"object"==typeof e.source&&(this.addSource(r,e.source),e=we(e=ze(e),{source:r})),this._validate(ha.layer,`layers.${r}`,e,{arrayIndex:-1},i))return;n=pd(e,this._globalState),this._validateLayer(n),n.setEventedParent(this,{layer:{id:r}})}const s=t?this._order.indexOf(t):this._order.length;if(t&&-1===s)this.fire(new St(new Error(`Cannot add layer "${r}" before non-existing layer "${t}".`)));else{if(this._order.splice(s,0,r),this._layerOrderChanged=!0,this._layers[r]=n,this._removedLayers[r]&&n.source&&"custom"!==n.type){const e=this._removedLayers[r];delete this._removedLayers[r],e.type!==n.type?this._updatedSources[n.source]="clear":(this._updatedSources[n.source]="reload",this.tileManagers[n.source].pause())}this._updateLayer(n),n.onAdd&&n.onAdd(this.map)}}moveLayer(e,t){if(this._checkLoaded(),this._changed=!0,!this._layers[e])return void this.fire(new St(new Error(`The layer '${e}' does not exist in the map's style and cannot be moved.`)));if(e===t)return;const i=this._order.indexOf(e);this._order.splice(i,1);const r=t?this._order.indexOf(t):this._order.length;t&&-1===r?this.fire(new St(new Error(`Cannot move layer "${e}" before non-existing layer "${t}".`))):(this._order.splice(r,0,e),this._layerOrderChanged=!0)}removeLayer(e){this._checkLoaded();const t=this._layers[e];if(!t)return void this.fire(new St(new Error(`Cannot remove non-existing layer "${e}".`)));t.setEventedParent(null);const i=this._order.indexOf(e);this._order.splice(i,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[e]=t,delete this._layers[e],this._serializedLayers&&delete this._serializedLayers[e],delete this._updatedLayers[e],delete this._updatedPaintProps[e],t.onRemove&&t.onRemove(this.map)}getLayer(e){return this._layers[e]}getLayersOrder(){return[...this._order]}hasLayer(e){return e in this._layers}setLayerZoomRange(e,t,i){this._checkLoaded();const r=this.getLayer(e);r?r.minzoom===t&&r.maxzoom===i||(null!=t&&(r.minzoom=t),null!=i&&(r.maxzoom=i),this._updateLayer(r)):this.fire(new St(new Error(`Cannot set the zoom range of non-existing layer "${e}".`)))}setFilter(e,t,i={}){this._checkLoaded();const r=this.getLayer(e);if(r){if(!Ae(r.filter,t))return null==t?(r.setFilter(void 0),void this._updateLayer(r)):void(this._validate(ha.filter,`layers.${r.id}.filter`,t,null,i)||(r.setFilter(ze(t)),this._updateLayer(r)))}else this.fire(new St(new Error(`Cannot filter non-existing layer "${e}".`)))}getFilter(e){return ze(this.getLayer(e).filter)}setLayoutProperty(e,t,i,r={}){this._checkLoaded();const n=this.getLayer(e);n?Ae(n.getLayoutProperty(t),i)||(n.setLayoutProperty(t,i,r),this._updateLayer(n)):this.fire(new St(new Error(`Cannot style non-existing layer "${e}".`)))}getLayoutProperty(e,t){const i=this.getLayer(e);if(i)return i.getLayoutProperty(t);this.fire(new St(new Error(`Cannot get style of non-existing layer "${e}".`)))}setPaintProperty(e,t,i,r={}){this._checkLoaded();const n=this.getLayer(e);n?Ae(n.getPaintProperty(t),i)||this._updatePaintProperty(n,t,i,r):this.fire(new St(new Error(`Cannot style non-existing layer "${e}".`)))}_updatePaintProperty(e,t,i,r={}){e.setPaintProperty(t,i,r)&&this._updateLayer(e),Ja(e)&&"raster-fade-duration"===t&&this.tileManagers[e.source].setRasterFadeDuration(i),this._changed=!0,this._updatedPaintProps[e.id]=!0,this._serializedLayers=null}getPaintProperty(e,t){return this.getLayer(e).getPaintProperty(t)}setFeatureState(e,t){this._checkLoaded();const i=e.source,r=e.sourceLayer,n=this.tileManagers[i];if(void 0===n)return void this.fire(new St(new Error(`The source '${i}' does not exist in the map's style.`)));const s=n.getSource().type;"geojson"===s&&r?this.fire(new St(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==s||r?(void 0===e.id&&this.fire(new St(new Error("The feature id parameter must be provided."))),n.setFeatureState(r,e.id,t)):this.fire(new St(new Error("The sourceLayer parameter must be provided for vector source types.")))}removeFeatureState(e,t){this._checkLoaded();const i=e.source,r=this.tileManagers[i];if(void 0===r)return void this.fire(new St(new Error(`The source '${i}' does not exist in the map's style.`)));const n=r.getSource().type,s="vector"===n?e.sourceLayer:void 0;"vector"!==n||s?t&&"string"!=typeof e.id&&"number"!=typeof e.id?this.fire(new St(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(s,e.id,t):this.fire(new St(new Error("The sourceLayer parameter must be provided for vector source types.")))}getFeatureState(e){this._checkLoaded();const t=e.source,i=e.sourceLayer,r=this.tileManagers[t];if(void 0!==r)return"vector"!==r.getSource().type||i?(void 0===e.id&&this.fire(new St(new Error("The feature id parameter must be provided."))),r.getFeatureState(i,e.id)):void this.fire(new St(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new St(new Error(`The source '${t}' does not exist in the map's style.`)))}getTransition(){return we({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const e=Ee(this.tileManagers,(e=>e.serialize())),t=this._serializeByIds(this._order,!0),i=this.map.getTerrain()||void 0,r=this.stylesheet;return Ce({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,projection:r.projection,sources:e,layers:t,terrain:i},(e=>void 0!==e))}_updateLayer(e){this._updatedLayers[e.id]=!0,e.source&&!this._updatedSources[e.source]&&"raster"!==this.tileManagers[e.source].getSource().type&&(this._updatedSources[e.source]="reload",this.tileManagers[e.source].pause()),this._serializedLayers=null,this._changed=!0}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},r=[];for(let n=this._order.length-1;n>=0;n--){const s=this._order[n];if(t(s)){i[s]=n;for(const t of e){const e=t[s];if(e)for(const t of e)r.push(t)}}}r.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const n=[];for(let s=this._order.length-1;s>=0;s--){const a=this._order[s];if(t(a))for(let e=r.length-1;e>=0;e--){const t=r[e].feature;if(i[t.layer.id]<s)break;n.push(t),r.pop()}else for(const t of e){const e=t[a];if(e)for(const t of e)n.push(t.feature)}}return n}queryRenderedFeatures(e,t,i){t&&t.filter&&this._validate(ha.filter,"queryRenderedFeatures.filter",t.filter,null,t);const r={};if(t&&t.layers){if(!(Array.isArray(t.layers)||t.layers instanceof Set))return this.fire(new St(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const e of t.layers){const t=this._layers[e];if(!t)return this.fire(new St(new Error(`The layer '${e}' does not exist in the map's style and cannot be queried for features.`))),[];r[t.source]=!0}}const n=[];t.availableImages=this._availableImages;const s=this._serializedAllLayers(),a=t.layers instanceof Set?t.layers:Array.isArray(t.layers)?new Set(t.layers):null,o=Object.assign(Object.assign({},t),{layers:a,globalState:this._globalState});for(const a in this.tileManagers)t.layers&&!r[a]||n.push(Nd(this.tileManagers[a],this._layers,s,e,o,i,this.map.terrain?(e,t,i)=>this.map.terrain.getElevation(e,t,i):void 0));return this.placement&&n.push(function(e,t,i,r,n,s,a){const o={},l=s.queryRenderedSymbols(r),c=[];for(const e of Object.keys(l).map(Number))c.push(a[e]);c.sort(Ud);for(const i of c){const r=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,{filterSpec:n.filter,globalState:n.globalState},n.layers,n.availableImages,e);for(const e in r){const t=o[e]=o[e]||[],n=r[e];n.sort(((e,t)=>{const r=i.featureSortOrder;if(r){const i=r.indexOf(e.featureIndex);return r.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of n)t.push(e)}}return function(e,t,i){for(const r in e)for(const n of e[r])Gd(n,i[t[r].source]);return e}(o,e,i)}(this._layers,s,this.tileManagers,e,o,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(n)}querySourceFeatures(e,t){(null==t?void 0:t.filter)&&this._validate(ha.filter,"querySourceFeatures.filter",t.filter,null,t);const i=this.tileManagers[e];return i?function(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),r=[],n={};for(let e=0;e<i.length;e++){const s=i[e],a=s.tileID.canonical.key;n[a]||(n[a]=!0,s.querySourceFeatures(r,t))}return r}(i,t?Object.assign(Object.assign({},t),{globalState:this._globalState}):{globalState:this._globalState}):[]}getLight(){return this.light.getLight()}setLight(e,t={}){this._checkLoaded();const i=this.light.getLight();let r=!1;for(const t in e)if(!Ae(e[t],i[t])){r=!0;break}if(!r)return;const n={now:rt(),transition:we({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(e,t),this.light.updateTransitions(n)}getProjection(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.projection}setProjection(e){if(this._checkLoaded(),this.projection){if(this.projection.name===e.type)return;this.projection.destroy(),delete this.projection}this.stylesheet.projection=e,this._setProjectionInternal(e.type)}getSky(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.sky}setSky(e,t={}){this._checkLoaded();const i=this.getSky();let r=!1;if(!e&&!i)return;if(e&&!i)r=!0;else if(!e&&i)r=!0;else for(const t in e)if(!Ae(e[t],i[t])){r=!0;break}if(!r)return;const n={now:rt(),transition:we({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=e,this.sky.setSky(e,t),this.sky.updateTransitions(n)}_setProjectionInternal(e){const t=function(e,t){const i={constrainOverride:t};if(Array.isArray(e)){const t=new Ag({type:e});return{projection:t,transform:new Hg(i),cameraHelper:new Yg(t)}}switch(e){case"mercator":return{projection:new ng,transform:new dg(i),cameraHelper:new _g};case"globe":{const e=new Ag({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return{projection:e,transform:new Hg(i),cameraHelper:new Yg(e)}}case"vertical-perspective":return{projection:new Eg,transform:new Wg(i),cameraHelper:new Xg};default:return Re(`Unknown projection name: ${e}. Falling back to mercator projection.`),{projection:new ng,transform:new dg(i),cameraHelper:new _g}}}(e,this.map.transformConstrain);this.projection=t.projection,this.map.migrateProjection(t.transform,t.cameraHelper);for(const e in this.tileManagers)this.tileManagers[e].reload()}_validate(e,t,i,r,n={}){return(!n||!1!==n.validate)&&Kg(this,e.call(ha,we({key:t,style:this.serialize(),value:i,styleSpec:It},r)))}_remove(e=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),ym().off(mm,this._rtlPluginLoaded);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this.tileManagers){const t=this.tileManagers[e];t.setEventedParent(null),t.onRemove(this.map)}this.imageManager.setEventedParent(null),this.setEventedParent(null),e&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(e)}_clearSource(e){this.tileManagers[e].clearTiles()}_reloadSource(e){this.tileManagers[e].resume(),this.tileManagers[e].reload()}_updateSources(e){for(const t in this.tileManagers)this.tileManagers[t].update(e,this.map.terrain)}_generateCollisionBoxes(){for(const e in this.tileManagers)this._reloadSource(e)}_updatePlacement(e,t,i,r,n=!1){let s=!1,a=!1;const o={};for(const t of this._order){const i=this._layers[t];if("symbol"!==i.type)continue;if(!o[i.source]){const e=this.tileManagers[i.source];o[i.source]=e.getRenderableIds(!0).map((t=>e.getTileByID(t))).sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)))}const r=this.crossTileSymbolIndex.addLayer(i,o[i.source],e.center.lng);s=s||r}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((n=n||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(rt(),e.zoom))&&(this.pauseablePlacement=new O_(e,this.map.terrain,this._order,n,t,i,r,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,o),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(rt()),a=!0),s&&this.pauseablePlacement.placement.setStale()),a||s)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,o[t.source])}return!this.pauseablePlacement.isDone()||this.placement.hasTransitions(rt())}_releaseSymbolFadeTiles(){for(const e in this.tileManagers)this.tileManagers[e].releaseSymbolFadeTiles()}getImages(e,t){return n(this,void 0,void 0,(function*(){const e=yield this.imageManager.getImages(t.icons);this._updateTilesForChangedImages();const i=this.tileManagers[t.source];return i&&i.setDependencies(t.tileID.key,t.type,t.icons),e}))}getGlyphs(e,t){return n(this,void 0,void 0,(function*(){const e=yield this.glyphManager.getGlyphs(t.stacks),i=this.tileManagers[t.source];return i&&i.setDependencies(t.tileID.key,t.type,[""]),e}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(e,t={}){this._checkLoaded(),e&&this._validate(ha.glyphs,"glyphs",e,null,t)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=e,this.glyphManager.entries={},this.glyphManager.setURL(e))}getDashes(e,t){return n(this,void 0,void 0,(function*(){const e={};for(const[i,r]of Object.entries(t.dashes))e[i]=this.lineAtlas.getDash(r.dasharray,r.round);return e}))}addSprite(e,t,i={},r){this._checkLoaded();const n=[{id:e,url:t}],s=[...fd(this.stylesheet.sprite),...n];this._validate(ha.sprite,"sprite",s,null,i)||(this.stylesheet.sprite=s,this._loadSprite(n,!0,r))}removeSprite(e){this._checkLoaded();const t=fd(this.stylesheet.sprite);if(t.find((t=>t.id===e))){if(this._spritesImagesIds[e])for(const t of this._spritesImagesIds[e])this.imageManager.removeImage(t),this._changedImages[t]=!0;t.splice(t.findIndex((t=>t.id===e)),1),this.stylesheet.sprite=t.length>0?t:void 0,delete this._spritesImagesIds[e],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new Tt("data",{dataType:"style"}))}else this.fire(new St(new Error(`Sprite "${e}" doesn't exists on this map.`)))}getSprite(){return fd(this.stylesheet.sprite)}setSprite(e,t={},i){this._checkLoaded(),e&&this._validate(ha.sprite,"sprite",e,null,t)||(this.stylesheet.sprite=e,e?this._loadSprite(e,!0,i):(this._unloadSprite(),i&&i(null)))}destroy(){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null);for(const e in this.tileManagers){const t=this.tileManagers[e];t.setEventedParent(null),t.onRemove(this.map)}this.tileManagers={},this.imageManager&&(this.imageManager.setEventedParent(null),this.imageManager.destroy(),this._availableImages=[],this._spritesImagesIds={}),this.glyphManager&&this.glyphManager.destroy();for(const e in this._layers){const t=this._layers[e];t.setEventedParent(null),t.onRemove&&t.onRemove(this.map)}this._setInitialValues(),this.setEventedParent(null),this.dispatcher.unregisterMessageHandler("GG"),this.dispatcher.unregisterMessageHandler("GI"),this.dispatcher.unregisterMessageHandler("GDA"),this.dispatcher.remove(!0),this._listeners={},this._oneTimeListeners={}}}var ey=ro([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class ty{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null}bind(e,t,i,r,n,s,a,o,l){this.context=e;let c=this.boundPaintVertexBuffers.length!==r.length;for(let e=0;!c&&e<r.length;e++)this.boundPaintVertexBuffers[e]!==r[e]&&(c=!0);!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==n||this.boundVertexOffset!==s||this.boundDynamicVertexBuffer!==a||this.boundDynamicVertexBuffer2!==o||this.boundDynamicVertexBuffer3!==l?this.freshBind(t,i,r,n,s,a,o,l):(e.bindVertexArray.set(this.vao),a&&a.bind(),n&&n.dynamicDraw&&n.bind(),o&&o.bind(),l&&l.bind())}freshBind(e,t,i,r,n,s,a,o){const l=e.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=n,this.boundDynamicVertexBuffer=s,this.boundDynamicVertexBuffer2=a,this.boundDynamicVertexBuffer3=o,t.enableAttributes(h,e);for(const t of i)t.enableAttributes(h,e);s&&s.enableAttributes(h,e),a&&a.enableAttributes(h,e),o&&o.enableAttributes(h,e),t.bind(),t.setVertexAttribPointers(h,e,n);for(const t of i)t.bind(),t.setVertexAttribPointers(h,e,n);s&&(s.bind(),s.setVertexAttribPointers(h,e,n)),r&&r.bind(),a&&(a.bind(),a.setVertexAttribPointers(h,e,n)),o&&(o.bind(),o.setVertexAttribPointers(h,e,n)),c.currentNumAttributes=l}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null)}}const iy=(e,t,i,r,n)=>({u_texture:0,u_ele_delta:e,u_fog_matrix:t,u_fog_color:i?i.properties.get("fog-color"):Li.white,u_fog_ground_blend:i?i.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:n?0:i?i.calculateFogBlendOpacity(r):0,u_horizon_color:i?i.properties.get("horizon-color"):Li.white,u_horizon_fog_blend:i?i.properties.get("horizon-fog-blend"):1,u_is_globe_mode:n?1:0}),ry={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function ny(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const r=e[i].split(" ");t.push(r.pop())}return t}class sy{constructor(e,t,i,r,n,s,a,o,l=[]){const c=e.gl;this.program=c.createProgram();const h=ny(t.staticAttributes),u=i?i.getBinderAttributes():[],d=h.concat(u),p=J_.prelude.staticUniforms?ny(J_.prelude.staticUniforms):[],f=a.staticUniforms?ny(a.staticUniforms):[],m=t.staticUniforms?ny(t.staticUniforms):[],_=i?i.getBinderUniforms():[],g=p.concat(f).concat(m).concat(_),y=[];for(const e of g)y.indexOf(e)<0&&y.push(e);const x=i?i.defines():[];Sg(c)&&x.unshift("#version 300 es"),n&&x.push("#define OVERDRAW_INSPECTOR;"),s&&x.push("#define TERRAIN3D;"),o&&x.push(o),l&&x.push(...l);let v=x.concat(J_.prelude.fragmentSource,a.fragmentSource,t.fragmentSource).join("\n"),b=x.concat(J_.prelude.vertexSource,a.vertexSource,t.vertexSource).join("\n");Sg(c)||(v=function(e){return e.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(v),b=function(e){return e.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(b));const w=c.createShader(c.FRAGMENT_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(w,v),c.compileShader(w),!c.getShaderParameter(w,c.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${c.getShaderInfoLog(w)}`);c.attachShader(this.program,w);const T=c.createShader(c.VERTEX_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(T,b),c.compileShader(T),!c.getShaderParameter(T,c.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${c.getShaderInfoLog(T)}`);c.attachShader(this.program,T),this.attributes={};const S={};this.numAttributes=d.length;for(let e=0;e<this.numAttributes;e++)d[e]&&(c.bindAttribLocation(this.program,e,d[e]),this.attributes[d[e]]=e);if(c.linkProgram(this.program),!c.getProgramParameter(this.program,c.LINK_STATUS))throw new Error(`Program failed to link: ${c.getProgramInfoLog(this.program)}`);c.deleteShader(T),c.deleteShader(w);for(let e=0;e<y.length;e++){const t=y[e];if(t&&!S[t]){const e=c.getUniformLocation(this.program,t);e&&(S[t]=e)}}this.fixedUniforms=r(e,S),this.terrainUniforms=((e,t)=>({u_depth:new Ml(e,t.u_depth),u_terrain:new Ml(e,t.u_terrain),u_terrain_dim:new El(e,t.u_terrain_dim),u_terrain_matrix:new Fl(e,t.u_terrain_matrix),u_terrain_unpack:new zl(e,t.u_terrain_unpack),u_terrain_exaggeration:new El(e,t.u_terrain_exaggeration)}))(e,S),this.projectionUniforms=((e,t)=>({u_projection_matrix:new Fl(e,t.u_projection_matrix),u_projection_tile_mercator_coords:new zl(e,t.u_projection_tile_mercator_coords),u_projection_clipping_plane:new zl(e,t.u_projection_clipping_plane),u_projection_transition:new El(e,t.u_projection_transition),u_projection_fallback_matrix:new Fl(e,t.u_projection_fallback_matrix)}))(e,S),this.binderUniforms=i?i.getUniforms(e,S):[]}draw(e,t,i,r,n,s,a,o,l,c,h,u,d,p,f,m,_,g,y){const x=e.gl;if(this.failedToCreate)return;if(e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(r),e.setColorMode(n),e.setCullFace(s),o){e.activeTexture.set(x.TEXTURE2),x.bindTexture(x.TEXTURE_2D,o.depthTexture),e.activeTexture.set(x.TEXTURE3),x.bindTexture(x.TEXTURE_2D,o.texture);for(const e in this.terrainUniforms)this.terrainUniforms[e].set(o[e])}if(l)for(const e in l)this.projectionUniforms[ry[e]].set(l[e]);if(a)for(const e in this.fixedUniforms)this.fixedUniforms[e].set(a[e]);m&&m.setUniforms(e,this.binderUniforms,p,{zoom:f});let v=0;switch(t){case x.LINES:v=2;break;case x.TRIANGLES:v=3;break;case x.LINE_STRIP:v=1}for(const i of d.get()){const r=i.vaos||(i.vaos={});(r[c]||(r[c]=new ty)).bind(e,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,_,g,y),x.drawElements(t,i.primitiveLength*v,x.UNSIGNED_SHORT,i.primitiveOffset*v*2)}}}function ay(e,t,i){const r=1/ee(i,1,t.transform.tileZoom),n=Math.pow(2,i.tileID.overscaledZ),s=i.tileSize*Math.pow(2,t.transform.tileZoom)/n,a=s*(i.tileID.canonical.x+i.tileID.wrap*n),o=s*i.tileID.canonical.y;return{u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[r,e.fromScale,e.toScale],u_fade:e.t,u_pixel_coord_upper:[a>>16,o>>16],u_pixel_coord_lower:[65535&a,65535&o]}}const oy=(e,t,i,r)=>{const n=e.style.light,s=n.properties.get("position"),a=[s.x,s.y,s.z],o=m();var l,c,h,u;"viewport"===n.properties.get("anchor")&&(l=o,c=e.transform.bearingInRadians,h=Math.sin(c),u=Math.cos(c),l[0]=u,l[1]=h,l[2]=0,l[3]=-h,l[4]=u,l[5]=0,l[6]=0,l[7]=0,l[8]=1),function(e,t,i){var r=t[0],n=t[1],s=t[2];e[0]=r*i[0]+n*i[3]+s*i[6],e[1]=r*i[1]+n*i[4]+s*i[7],e[2]=r*i[2]+n*i[5]+s*i[8]}(a,a,o);const d=e.transform.transformLightDirection(a),p=n.properties.get("color");return{u_lightpos:a,u_lightpos_globe:d,u_lightintensity:n.properties.get("intensity"),u_lightcolor:[p.r,p.g,p.b],u_vertical_gradient:+t,u_opacity:i,u_fill_translate:r}},ly=(e,t,i,r,n,s,a)=>we(oy(e,t,i,r),ay(s,e,a),{u_height_factor:-Math.pow(2,n.overscaledZ)/a.tileSize/8}),cy=(e,t,i,r)=>we(ay(t,e,i),{u_fill_translate:r}),hy=e=>({u_fill_translate:e}),uy=(e,t)=>({u_world:e,u_fill_translate:t}),dy=(e,t,i,r,n)=>we(cy(e,t,i,n),{u_world:r}),py=(e,t,i,r,n)=>{const s=e.transform;let a,o,l=0;if("map"===i.paint.get("circle-pitch-alignment")){const e=ee(t,1,s.zoom);a=!0,o=[e,e],l=e/(Q*Math.pow(2,t.tileID.overscaledZ))*2*Math.PI*n}else a=!1,o=s.pixelsToGLUnits;return{u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===i.paint.get("circle-pitch-scale")),u_pitch_with_map:+a,u_device_pixel_ratio:e.pixelRatio,u_extrude_scale:o,u_globe_extrude_scale:l,u_translate:r}},fy=e=>({u_pixel_extrude_scale:[1/e.width,1/e.height]}),my=e=>({u_viewport_size:[e.width,e.height]}),_y=(e,t=1)=>({u_color:e,u_overlay:0,u_overlay_scale:t}),gy=(e,t,i,r)=>{const n=ee(e,1,t)/(Q*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*r;return{u_extrude_scale:ee(e,1,t),u_intensity:i,u_globe_extrude_scale:n}},yy=(e,t,i,r)=>{const n=_();M(n,0,e.width,e.height,0,0,1);const s=e.context.gl;return{u_matrix:n,u_world:[s.drawingBufferWidth,s.drawingBufferHeight],u_image:i,u_color_ramp:r,u_opacity:t.paint.get("heatmap-opacity")}},xy=(e,t,i)=>{const r=i.paint.get("hillshade-accent-color");let n;switch(i.paint.get("hillshade-method")){case"basic":n=4;break;case"combined":n=1;break;case"igor":n=2;break;case"multidirectional":n=3;break;default:n=0}const s=i.getIlluminationProperties();for(let t=0;t<s.directionRadians.length;t++)"viewport"===i.paint.get("hillshade-illumination-anchor")&&(s.directionRadians[t]+=e.transform.bearingInRadians);return{u_image:0,u_latrange:by(0,t.tileID),u_exaggeration:i.paint.get("hillshade-exaggeration"),u_altitudes:s.altitudeRadians,u_azimuths:s.directionRadians,u_accent:r,u_method:n,u_highlights:s.highlightColor,u_shadows:s.shadowColor}},vy=(e,t)=>{const i=t.stride,r=_();return M(r,0,Q,-8192,0,0,1),b(r,r,[0,-8192,0]),{u_matrix:r,u_image:1,u_dimension:[i,i],u_zoom:e.overscaledZ,u_unpack:t.getUnpackVector()}};function by(e,t){const i=Math.pow(2,t.canonical.z),r=t.canonical.y;return[new ip(0,r/i).toLngLat().lat,new ip(0,(r+1)/i).toLngLat().lat]}const wy=(e,t,i=0)=>({u_image:0,u_unpack:t.getUnpackVector(),u_dimension:[t.stride,t.stride],u_elevation_stops:1,u_color_stops:4,u_color_ramp_size:i,u_opacity:e.paint.get("color-relief-opacity")}),Ty=(e,t,i,r)=>{const n=e.transform;return{u_translation:Cy(e,t,i),u_ratio:r/ee(t,1,n.zoom),u_device_pixel_ratio:e.pixelRatio,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},Sy=(e,t,i,r,n)=>we(Ty(e,t,i,r),{u_image:0,u_image_height:n}),Py=(e,t,i,r,n)=>{const s=e.transform,a=Ey(t,s);return{u_translation:Cy(e,t,i),u_texsize:t.imageAtlasTexture.size,u_ratio:r/ee(t,1,s.zoom),u_device_pixel_ratio:e.pixelRatio,u_image:0,u_scale:[a,n.fromScale,n.toScale],u_fade:n.t,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},Iy=(e,t,i,r,n)=>{const s=Ey(t,e.transform);return we(Ty(e,t,i,r),{u_tileratio:s,u_crossfade_from:n.fromScale,u_crossfade_to:n.toScale,u_image:0,u_mix:n.t,u_lineatlas_width:e.lineAtlas.width,u_lineatlas_height:e.lineAtlas.height})},My=(e,t,i,r,n,s)=>{const a=Ey(t,e.transform);return we(Ty(e,t,i,r),{u_image:0,u_image_height:s,u_tileratio:a,u_crossfade_from:n.fromScale,u_crossfade_to:n.toScale,u_image_dash:1,u_mix:n.t,u_lineatlas_width:e.lineAtlas.width,u_lineatlas_height:e.lineAtlas.height})};function Ey(e,t){return 1/ee(e,1,t.tileZoom)}function Cy(e,t,i){return ae(e.transform,t,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const Ay=(e,t,i,r,n)=>{return{u_tl_parent:e,u_scale_parent:t,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(a=r.paint.get("raster-saturation"),a>0?1-1/(1.001-a):-a),u_contrast_factor:(s=r.paint.get("raster-contrast"),s>0?1/(1-s):1+s),u_spin_weights:zy(r.paint.get("raster-hue-rotate")),u_coords_top:[n[0].x,n[0].y,n[1].x,n[1].y],u_coords_bottom:[n[3].x,n[3].y,n[2].x,n[2].y]};var s,a};function zy(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return[(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const Dy=(e,t,i,r,n,s,a,o,l,c,h,u,d)=>{const p=a.transform;return{u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:p.cameraToCenterDistance,u_pitch:p.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:p.width/p.height,u_fade_change:a.options.fadeDuration?a.symbolFadeChange:1,u_label_plane_matrix:o,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+r,u_is_along_line:n,u_is_variable_anchor:s,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:d}},Ry=(e,t,i,r,n,s,a,o,l,c,h,u,d,p)=>{const f=a.transform;return we(Dy(e,t,i,r,n,s,a,o,l,c,h,u,p),{u_gamma_scale:r?Math.cos(f.pitch*Math.PI/180)*f.cameraToCenterDistance:1,u_device_pixel_ratio:a.pixelRatio,u_is_halo:1})},ky=(e,t,i,r,n,s,a,o,l,c,h,u,d)=>we(Ry(e,t,i,r,n,s,a,o,l,c,!0,h,0,d),{u_texsize_icon:u,u_texture_icon:1}),Ly=(e,t)=>({u_opacity:e,u_color:t}),Fy=(e,t,i,r,n)=>we(function(e,t,i,r){const n=i.imageManager.getPattern(e.from.toString()),s=i.imageManager.getPattern(e.to.toString()),{width:a,height:o}=i.imageManager.getPixelSize(),l=Math.pow(2,r.tileID.overscaledZ),c=r.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(r.tileID.canonical.x+r.tileID.wrap*l),u=c*r.tileID.canonical.y;return{u_image:0,u_pattern_tl_a:n.tl,u_pattern_br_a:n.br,u_pattern_tl_b:s.tl,u_pattern_br_b:s.br,u_texsize:[a,o],u_mix:t.t,u_pattern_size_a:n.displaySize,u_pattern_size_b:s.displaySize,u_scale_a:t.fromScale,u_scale_b:t.toScale,u_tile_units_to_pixels:1/ee(r,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(i,n,t,r),{u_opacity:e}),By=(e,t)=>{},Oy={fillExtrusion:(e,t)=>({u_lightpos:new Al(e,t.u_lightpos),u_lightpos_globe:new Al(e,t.u_lightpos_globe),u_lightintensity:new El(e,t.u_lightintensity),u_lightcolor:new Al(e,t.u_lightcolor),u_vertical_gradient:new El(e,t.u_vertical_gradient),u_opacity:new El(e,t.u_opacity),u_fill_translate:new Cl(e,t.u_fill_translate)}),fillExtrusionPattern:(e,t)=>({u_lightpos:new Al(e,t.u_lightpos),u_lightpos_globe:new Al(e,t.u_lightpos_globe),u_lightintensity:new El(e,t.u_lightintensity),u_lightcolor:new Al(e,t.u_lightcolor),u_vertical_gradient:new El(e,t.u_vertical_gradient),u_height_factor:new El(e,t.u_height_factor),u_opacity:new El(e,t.u_opacity),u_fill_translate:new Cl(e,t.u_fill_translate),u_image:new Ml(e,t.u_image),u_texsize:new Cl(e,t.u_texsize),u_pixel_coord_upper:new Cl(e,t.u_pixel_coord_upper),u_pixel_coord_lower:new Cl(e,t.u_pixel_coord_lower),u_scale:new Al(e,t.u_scale),u_fade:new El(e,t.u_fade)}),fill:(e,t)=>({u_fill_translate:new Cl(e,t.u_fill_translate)}),fillPattern:(e,t)=>({u_image:new Ml(e,t.u_image),u_texsize:new Cl(e,t.u_texsize),u_pixel_coord_upper:new Cl(e,t.u_pixel_coord_upper),u_pixel_coord_lower:new Cl(e,t.u_pixel_coord_lower),u_scale:new Al(e,t.u_scale),u_fade:new El(e,t.u_fade),u_fill_translate:new Cl(e,t.u_fill_translate)}),fillOutline:(e,t)=>({u_world:new Cl(e,t.u_world),u_fill_translate:new Cl(e,t.u_fill_translate)}),fillOutlinePattern:(e,t)=>({u_world:new Cl(e,t.u_world),u_image:new Ml(e,t.u_image),u_texsize:new Cl(e,t.u_texsize),u_pixel_coord_upper:new Cl(e,t.u_pixel_coord_upper),u_pixel_coord_lower:new Cl(e,t.u_pixel_coord_lower),u_scale:new Al(e,t.u_scale),u_fade:new El(e,t.u_fade),u_fill_translate:new Cl(e,t.u_fill_translate)}),circle:(e,t)=>({u_camera_to_center_distance:new El(e,t.u_camera_to_center_distance),u_scale_with_map:new Ml(e,t.u_scale_with_map),u_pitch_with_map:new Ml(e,t.u_pitch_with_map),u_extrude_scale:new Cl(e,t.u_extrude_scale),u_device_pixel_ratio:new El(e,t.u_device_pixel_ratio),u_globe_extrude_scale:new El(e,t.u_globe_extrude_scale),u_translate:new Cl(e,t.u_translate)}),collisionBox:(e,t)=>({u_pixel_extrude_scale:new Cl(e,t.u_pixel_extrude_scale)}),collisionCircle:(e,t)=>({u_viewport_size:new Cl(e,t.u_viewport_size)}),debug:(e,t)=>({u_color:new Dl(e,t.u_color),u_overlay:new Ml(e,t.u_overlay),u_overlay_scale:new El(e,t.u_overlay_scale)}),depth:By,clippingMask:By,heatmap:(e,t)=>({u_extrude_scale:new El(e,t.u_extrude_scale),u_intensity:new El(e,t.u_intensity),u_globe_extrude_scale:new El(e,t.u_globe_extrude_scale)}),heatmapTexture:(e,t)=>({u_matrix:new Fl(e,t.u_matrix),u_world:new Cl(e,t.u_world),u_image:new Ml(e,t.u_image),u_color_ramp:new Ml(e,t.u_color_ramp),u_opacity:new El(e,t.u_opacity)}),hillshade:(e,t)=>({u_image:new Ml(e,t.u_image),u_latrange:new Cl(e,t.u_latrange),u_exaggeration:new El(e,t.u_exaggeration),u_altitudes:new kl(e,t.u_altitudes),u_azimuths:new kl(e,t.u_azimuths),u_accent:new Dl(e,t.u_accent),u_method:new Ml(e,t.u_method),u_shadows:new Rl(e,t.u_shadows),u_highlights:new Rl(e,t.u_highlights)}),hillshadePrepare:(e,t)=>({u_matrix:new Fl(e,t.u_matrix),u_image:new Ml(e,t.u_image),u_dimension:new Cl(e,t.u_dimension),u_zoom:new El(e,t.u_zoom),u_unpack:new zl(e,t.u_unpack)}),colorRelief:(e,t)=>({u_image:new Ml(e,t.u_image),u_unpack:new zl(e,t.u_unpack),u_dimension:new Cl(e,t.u_dimension),u_elevation_stops:new Ml(e,t.u_elevation_stops),u_color_stops:new Ml(e,t.u_color_stops),u_color_ramp_size:new Ml(e,t.u_color_ramp_size),u_opacity:new El(e,t.u_opacity)}),line:(e,t)=>({u_translation:new Cl(e,t.u_translation),u_ratio:new El(e,t.u_ratio),u_device_pixel_ratio:new El(e,t.u_device_pixel_ratio),u_units_to_pixels:new Cl(e,t.u_units_to_pixels)}),lineGradient:(e,t)=>({u_translation:new Cl(e,t.u_translation),u_ratio:new El(e,t.u_ratio),u_device_pixel_ratio:new El(e,t.u_device_pixel_ratio),u_units_to_pixels:new Cl(e,t.u_units_to_pixels),u_image:new Ml(e,t.u_image),u_image_height:new El(e,t.u_image_height)}),linePattern:(e,t)=>({u_translation:new Cl(e,t.u_translation),u_texsize:new Cl(e,t.u_texsize),u_ratio:new El(e,t.u_ratio),u_device_pixel_ratio:new El(e,t.u_device_pixel_ratio),u_image:new Ml(e,t.u_image),u_units_to_pixels:new Cl(e,t.u_units_to_pixels),u_scale:new Al(e,t.u_scale),u_fade:new El(e,t.u_fade)}),lineSDF:(e,t)=>({u_translation:new Cl(e,t.u_translation),u_ratio:new El(e,t.u_ratio),u_device_pixel_ratio:new El(e,t.u_device_pixel_ratio),u_units_to_pixels:new Cl(e,t.u_units_to_pixels),u_image:new Ml(e,t.u_image),u_mix:new El(e,t.u_mix),u_tileratio:new El(e,t.u_tileratio),u_crossfade_from:new El(e,t.u_crossfade_from),u_crossfade_to:new El(e,t.u_crossfade_to),u_lineatlas_width:new El(e,t.u_lineatlas_width),u_lineatlas_height:new El(e,t.u_lineatlas_height)}),lineGradientSDF:(e,t)=>({u_translation:new Cl(e,t.u_translation),u_ratio:new El(e,t.u_ratio),u_device_pixel_ratio:new El(e,t.u_device_pixel_ratio),u_units_to_pixels:new Cl(e,t.u_units_to_pixels),u_image:new Ml(e,t.u_image),u_image_height:new El(e,t.u_image_height),u_tileratio:new El(e,t.u_tileratio),u_crossfade_from:new El(e,t.u_crossfade_from),u_crossfade_to:new El(e,t.u_crossfade_to),u_image_dash:new Ml(e,t.u_image_dash),u_mix:new El(e,t.u_mix),u_lineatlas_width:new El(e,t.u_lineatlas_width),u_lineatlas_height:new El(e,t.u_lineatlas_height)}),raster:(e,t)=>({u_tl_parent:new Cl(e,t.u_tl_parent),u_scale_parent:new El(e,t.u_scale_parent),u_buffer_scale:new El(e,t.u_buffer_scale),u_fade_t:new El(e,t.u_fade_t),u_opacity:new El(e,t.u_opacity),u_image0:new Ml(e,t.u_image0),u_image1:new Ml(e,t.u_image1),u_brightness_low:new El(e,t.u_brightness_low),u_brightness_high:new El(e,t.u_brightness_high),u_saturation_factor:new El(e,t.u_saturation_factor),u_contrast_factor:new El(e,t.u_contrast_factor),u_spin_weights:new Al(e,t.u_spin_weights),u_coords_top:new zl(e,t.u_coords_top),u_coords_bottom:new zl(e,t.u_coords_bottom)}),symbolIcon:(e,t)=>({u_is_size_zoom_constant:new Ml(e,t.u_is_size_zoom_constant),u_is_size_feature_constant:new Ml(e,t.u_is_size_feature_constant),u_size_t:new El(e,t.u_size_t),u_size:new El(e,t.u_size),u_camera_to_center_distance:new El(e,t.u_camera_to_center_distance),u_pitch:new El(e,t.u_pitch),u_rotate_symbol:new Ml(e,t.u_rotate_symbol),u_aspect_ratio:new El(e,t.u_aspect_ratio),u_fade_change:new El(e,t.u_fade_change),u_label_plane_matrix:new Fl(e,t.u_label_plane_matrix),u_coord_matrix:new Fl(e,t.u_coord_matrix),u_is_text:new Ml(e,t.u_is_text),u_pitch_with_map:new Ml(e,t.u_pitch_with_map),u_is_along_line:new Ml(e,t.u_is_along_line),u_is_variable_anchor:new Ml(e,t.u_is_variable_anchor),u_texsize:new Cl(e,t.u_texsize),u_texture:new Ml(e,t.u_texture),u_translation:new Cl(e,t.u_translation),u_pitched_scale:new El(e,t.u_pitched_scale)}),symbolSDF:(e,t)=>({u_is_size_zoom_constant:new Ml(e,t.u_is_size_zoom_constant),u_is_size_feature_constant:new Ml(e,t.u_is_size_feature_constant),u_size_t:new El(e,t.u_size_t),u_size:new El(e,t.u_size),u_camera_to_center_distance:new El(e,t.u_camera_to_center_distance),u_pitch:new El(e,t.u_pitch),u_rotate_symbol:new Ml(e,t.u_rotate_symbol),u_aspect_ratio:new El(e,t.u_aspect_ratio),u_fade_change:new El(e,t.u_fade_change),u_label_plane_matrix:new Fl(e,t.u_label_plane_matrix),u_coord_matrix:new Fl(e,t.u_coord_matrix),u_is_text:new Ml(e,t.u_is_text),u_pitch_with_map:new Ml(e,t.u_pitch_with_map),u_is_along_line:new Ml(e,t.u_is_along_line),u_is_variable_anchor:new Ml(e,t.u_is_variable_anchor),u_texsize:new Cl(e,t.u_texsize),u_texture:new Ml(e,t.u_texture),u_gamma_scale:new El(e,t.u_gamma_scale),u_device_pixel_ratio:new El(e,t.u_device_pixel_ratio),u_is_halo:new Ml(e,t.u_is_halo),u_translation:new Cl(e,t.u_translation),u_pitched_scale:new El(e,t.u_pitched_scale)}),symbolTextAndIcon:(e,t)=>({u_is_size_zoom_constant:new Ml(e,t.u_is_size_zoom_constant),u_is_size_feature_constant:new Ml(e,t.u_is_size_feature_constant),u_size_t:new El(e,t.u_size_t),u_size:new El(e,t.u_size),u_camera_to_center_distance:new El(e,t.u_camera_to_center_distance),u_pitch:new El(e,t.u_pitch),u_rotate_symbol:new Ml(e,t.u_rotate_symbol),u_aspect_ratio:new El(e,t.u_aspect_ratio),u_fade_change:new El(e,t.u_fade_change),u_label_plane_matrix:new Fl(e,t.u_label_plane_matrix),u_coord_matrix:new Fl(e,t.u_coord_matrix),u_is_text:new Ml(e,t.u_is_text),u_pitch_with_map:new Ml(e,t.u_pitch_with_map),u_is_along_line:new Ml(e,t.u_is_along_line),u_is_variable_anchor:new Ml(e,t.u_is_variable_anchor),u_texsize:new Cl(e,t.u_texsize),u_texsize_icon:new Cl(e,t.u_texsize_icon),u_texture:new Ml(e,t.u_texture),u_texture_icon:new Ml(e,t.u_texture_icon),u_gamma_scale:new El(e,t.u_gamma_scale),u_device_pixel_ratio:new El(e,t.u_device_pixel_ratio),u_is_halo:new Ml(e,t.u_is_halo),u_translation:new Cl(e,t.u_translation),u_pitched_scale:new El(e,t.u_pitched_scale)}),background:(e,t)=>({u_opacity:new El(e,t.u_opacity),u_color:new Dl(e,t.u_color)}),backgroundPattern:(e,t)=>({u_opacity:new El(e,t.u_opacity),u_image:new Ml(e,t.u_image),u_pattern_tl_a:new Cl(e,t.u_pattern_tl_a),u_pattern_br_a:new Cl(e,t.u_pattern_br_a),u_pattern_tl_b:new Cl(e,t.u_pattern_tl_b),u_pattern_br_b:new Cl(e,t.u_pattern_br_b),u_texsize:new Cl(e,t.u_texsize),u_mix:new El(e,t.u_mix),u_pattern_size_a:new Cl(e,t.u_pattern_size_a),u_pattern_size_b:new Cl(e,t.u_pattern_size_b),u_scale_a:new El(e,t.u_scale_a),u_scale_b:new El(e,t.u_scale_b),u_pixel_coord_upper:new Cl(e,t.u_pixel_coord_upper),u_pixel_coord_lower:new Cl(e,t.u_pixel_coord_lower),u_tile_units_to_pixels:new El(e,t.u_tile_units_to_pixels)}),terrain:(e,t)=>({u_texture:new Ml(e,t.u_texture),u_ele_delta:new El(e,t.u_ele_delta),u_fog_matrix:new Fl(e,t.u_fog_matrix),u_fog_color:new Dl(e,t.u_fog_color),u_fog_ground_blend:new El(e,t.u_fog_ground_blend),u_fog_ground_blend_opacity:new El(e,t.u_fog_ground_blend_opacity),u_horizon_color:new Dl(e,t.u_horizon_color),u_horizon_fog_blend:new El(e,t.u_horizon_fog_blend),u_is_globe_mode:new El(e,t.u_is_globe_mode)}),terrainDepth:(e,t)=>({u_ele_delta:new El(e,t.u_ele_delta)}),terrainCoords:(e,t)=>({u_texture:new Ml(e,t.u_texture),u_terrain_coords_id:new El(e,t.u_terrain_coords_id),u_ele_delta:new El(e,t.u_ele_delta)}),projectionErrorMeasurement:(e,t)=>({u_input:new El(e,t.u_input),u_output_expected:new El(e,t.u_output_expected)}),atmosphere:(e,t)=>({u_sun_pos:new Al(e,t.u_sun_pos),u_atmosphere_blend:new El(e,t.u_atmosphere_blend),u_globe_position:new Al(e,t.u_globe_position),u_globe_radius:new El(e,t.u_globe_radius),u_inv_proj_matrix:new Fl(e,t.u_inv_proj_matrix)}),sky:(e,t)=>({u_sky_color:new Dl(e,t.u_sky_color),u_horizon_color:new Dl(e,t.u_horizon_color),u_horizon:new Cl(e,t.u_horizon),u_horizon_normal:new Cl(e,t.u_horizon_normal),u_sky_horizon_blend:new El(e,t.u_sky_horizon_blend),u_sky_blend:new El(e,t.u_sky_blend)})};class Vy{constructor(e,t,i){this.context=e;const r=e.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer}bind(){this.context.bindElementBuffer.set(this.buffer)}updateData(e){const t=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer)}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}const jy={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class Ny{constructor(e,t,i,r){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=r,this.context=e;const n=e.gl;this.buffer=n.createBuffer(),e.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer}bind(){this.context.bindVertexBuffer.set(this.buffer)}updateData(e){if(e.length!==this.length)throw new Error(`Length of new data is ${e.length}, which doesn't match current length of ${this.length}`);const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer)}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const r=t.attributes[this.attributes[i].name];void 0!==r&&e.enableVertexAttribArray(r)}}setVertexAttribPointers(e,t,i){for(let r=0;r<this.attributes.length;r++){const n=this.attributes[r],s=t.attributes[n.name];void 0!==s&&e.vertexAttribPointer(s,n.components,e[jy[n.type]],!1,this.itemSize,n.offset+this.itemSize*(i||0))}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}class Uy{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default)}}class Gy extends Uy{getDefault(){return Li.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1)}}class Zy extends Uy{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1)}}class $y extends Uy{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1)}}class qy extends Uy{getDefault(){return[!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1)}}class Wy extends Uy{getDefault(){return!0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1)}}class Hy extends Uy{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1)}}class Xy extends Uy{getDefault(){return{func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1)}}class Yy extends Uy{getDefault(){const e=this.gl;return[e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1)}}class Ky extends Uy{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1}}class Jy extends Uy{getDefault(){return[0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1)}}class Qy extends Uy{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1}}class ex extends Uy{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1)}}class tx extends Uy{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1}}class ix extends Uy{getDefault(){const e=this.gl;return[e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.blendFunc(e[0],e[1]),this.current=e,this.dirty=!1)}}class rx extends Uy{getDefault(){return Li.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1)}}class nx extends Uy{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquation(e),this.current=e,this.dirty=!1)}}class sx extends Uy{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1}}class ax extends Uy{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1)}}class ox extends Uy{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1)}}class lx extends Uy{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1)}}class cx extends Uy{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1)}}class hx extends Uy{getDefault(){const e=this.gl;return[0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1)}}class ux extends Uy{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1}}class dx extends Uy{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1}}class px extends Uy{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1}}class fx extends Uy{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1}}class mx extends Uy{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1}}class _x extends Uy{getDefault(){return null}set(e){var t;if(e===this.current&&!this.dirty)return;const i=this.gl;Sg(i)?i.bindVertexArray(e):null===(t=i.getExtension("OES_vertex_array_object"))||void 0===t||t.bindVertexArrayOES(e),this.current=e,this.dirty=!1}}class gx extends Uy{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1}}class yx extends Uy{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1}}class xx extends Uy{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1}}class vx extends Uy{constructor(e,t){super(e),this.context=e,this.parent=t}getDefault(){return null}}class bx extends vx{setDirty(){this.dirty=!0}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1}}class wx extends vx{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1}}class Tx extends vx{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1}}const Sx="Framebuffer is not complete";class Px{constructor(e,t,i,r,n){this.context=e,this.width=t,this.height=i;const s=e.gl,a=this.framebuffer=s.createFramebuffer();if(this.colorAttachment=new bx(e,a),r)this.depthAttachment=n?new Tx(e,a):new wx(e,a);else if(n)throw new Error("Stencil cannot be set without depth");if(s.checkFramebufferStatus(s.FRAMEBUFFER)!==s.FRAMEBUFFER_COMPLETE)throw new Error(Sx)}destroy(){const e=this.context.gl,t=this.colorAttachment.get();if(t&&e.deleteTexture(t),this.depthAttachment){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t)}e.deleteFramebuffer(this.framebuffer)}}class Ix{constructor(e){var t,i;if(this.gl=e,this.clearColor=new Gy(this),this.clearDepth=new Zy(this),this.clearStencil=new $y(this),this.colorMask=new qy(this),this.depthMask=new Wy(this),this.stencilMask=new Hy(this),this.stencilFunc=new Xy(this),this.stencilOp=new Yy(this),this.stencilTest=new Ky(this),this.depthRange=new Jy(this),this.depthTest=new Qy(this),this.depthFunc=new ex(this),this.blend=new tx(this),this.blendFunc=new ix(this),this.blendColor=new rx(this),this.blendEquation=new nx(this),this.cullFace=new sx(this),this.cullFaceSide=new ax(this),this.frontFace=new ox(this),this.program=new lx(this),this.activeTexture=new cx(this),this.viewport=new hx(this),this.bindFramebuffer=new ux(this),this.bindRenderbuffer=new dx(this),this.bindTexture=new px(this),this.bindVertexBuffer=new fx(this),this.bindElementBuffer=new mx(this),this.bindVertexArray=new _x(this),this.pixelStoreUnpack=new gx(this),this.pixelStoreUnpackPremultiplyAlpha=new yx(this),this.pixelStoreUnpackFlipY=new xx(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),Sg(e)){this.HALF_FLOAT=e.HALF_FLOAT;const r=e.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(t=e.RGBA16F)&&void 0!==t?t:null==r?void 0:r.RGBA16F_EXT,this.RGB16F=null!==(i=e.RGB16F)&&void 0!==i?i:null==r?void 0:r.RGB16F_EXT,e.getExtension("EXT_color_buffer_float")}else{e.getExtension("EXT_color_buffer_half_float"),e.getExtension("OES_texture_half_float_linear");const t=e.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==t?void 0:t.HALF_FLOAT_OES}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault()}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0}createIndexBuffer(e,t){return new Vy(this,e,t)}createVertexBuffer(e,t,i){return new Ny(this,e,t,i)}createRenderbuffer(e,t,i){const r=this.gl,n=r.createRenderbuffer();return this.bindRenderbuffer.set(n),r.renderbufferStorage(r.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),n}createFramebuffer(e,t,i,r){return new Px(this,e,t,i,r)}clear({color:e,depth:t,stencil:i}){const r=this.gl;let n=0;e&&(n|=r.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set([!0,!0,!0,!0])),void 0!==t&&(n|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(n|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(n)}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace))}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1)}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1)}setColorMode(e){Ae(e.blendFunction,gg.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor)),this.colorMask.set(e.mask)}createVertexArray(){var e;return Sg(this.gl)?this.gl.createVertexArray():null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.createVertexArrayOES()}deleteVertexArray(e){var t;return Sg(this.gl)?this.gl.deleteVertexArray(e):null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.deleteVertexArrayOES(e)}unbindVAO(){this.bindVertexArray.set(null)}}let Mx;function Ex(e,t,i,r,n){const s=e.context,a=e.transform,o=s.gl,l=e.useProgram("collisionBox"),c=[];let h=0,u=0;for(let d=0;d<r.length;d++){const p=r[d],f=t.getTile(p).getBucket(i);if(!f)continue;const m=n?f.textCollisionBox:f.iconCollisionBox,_=f.collisionCircleArray;_.length>0&&(c.push({circleArray:_,circleOffset:u,coord:p}),h+=_.length/4,u=h),m&&l.draw(s,o.LINES,vg.disabled,wg.disabled,e.colorModeForRenderPass(),xg.disabled,fy(e.transform),e.style.map.terrain&&e.style.map.terrain.getTerrainData(p),a.getProjectionData({overscaledTileID:p,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,e.transform.zoom,null,null,m.collisionVertexBuffer)}if(!n||!c.length)return;const d=e.useProgram("collisionCircle"),p=new il;p.resize(4*h),p._trim();let f=0;for(const e of c)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,r=e.circleArray[i+0],n=e.circleArray[i+1],s=e.circleArray[i+2],a=e.circleArray[i+3];p.emplace(f++,r,n,s,a,0),p.emplace(f++,r,n,s,a,1),p.emplace(f++,r,n,s,a,2),p.emplace(f++,r,n,s,a,3)}(!Mx||Mx.length<2*h)&&(Mx=function(e){const t=2*e,i=new nl;i.resize(t),i._trim();for(let e=0;e<t;e++){const t=6*e;i.uint16[t+0]=4*e+0,i.uint16[t+1]=4*e+1,i.uint16[t+2]=4*e+2,i.uint16[t+3]=4*e+2,i.uint16[t+4]=4*e+3,i.uint16[t+5]=4*e+0}return i}(h));const m=s.createIndexBuffer(Mx,!0),_=s.createVertexBuffer(p,wu.members,!0);for(const t of c){const r=my(e.transform);d.draw(s,o.TRIANGLES,vg.disabled,wg.disabled,e.colorModeForRenderPass(),xg.disabled,r,e.style.map.terrain&&e.style.map.terrain.getTerrainData(t.coord),null,i.id,_,m,hl.simpleSegment(0,2*t.circleOffset,t.circleArray.length,t.circleArray.length/2),null,e.transform.zoom,null,null,null)}_.destroy(),m.destroy()}const Cx=y(new Float32Array(16));function Ax(e,t,i,r,n,a){const{horizontalAlign:o,verticalAlign:l}=qu(e);return new s((-(o-.5)*t/n+r[0])*a,(-(l-.5)*i/n+r[1])*a)}function zx(e,t,i,r,n,a){const o=t.tileAnchorPoint.add(new s(t.translation[0],t.translation[1]));if(t.pitchWithMap){let e=r.mult(a);i||(e=e.rotate(-n));const s=o.add(e);return Jm(s.x,s.y,t.pitchedLabelPlaneMatrix,t.getElevation).point}if(i){const i=o_(t.tileAnchorPoint.x+1,t.tileAnchorPoint.y,t).point.sub(e),n=Math.atan(i.y/i.x)+(i.x<0?Math.PI:0);return e.add(r.rotate(n))}return e.add(r)}function Dx(e,t,i,r,n,a,o,l,c,h,u,d){const p=e.text.placedSymbolArray,f=e.text.dynamicLayoutVertexArray,m=e.icon.dynamicLayoutVertexArray,_={};f.clear();for(let m=0;m<p.length;m++){const g=p.get(m),y=g.hidden||!g.crossTileID||e.allowVerticalPlacement&&!g.placedOrientation?null:r[g.crossTileID];if(y){const r=new s(g.anchorX,g.anchorY),p={getElevation:d,width:n.width,height:n.height,pitchedLabelPlaneMatrix:a,pitchWithMap:i,transform:n,tileAnchorPoint:r,translation:h,unwrappedTileID:u},m=i?c_(r.x,r.y,p):o_(r.x,r.y,p),x=Qm(n.cameraToCenterDistance,m.signedDistanceFromCamera);let v=Hu(e.textSizeData,l,g)*x/24;i&&(v*=e.tilePixelRatio/o);const{width:b,height:w,anchor:T,textOffset:S,textBoxScale:P}=y,I=Ax(T,b,w,S,P,v),M=n.getPitchedTextCorrection(r.x+h[0],r.y+h[1],u),E=zx(m.point,p,t,I,-n.bearingInRadians,M),C=e.allowVerticalPlacement&&g.placedOrientation===$u.vertical?Math.PI/2:0;for(let e=0;e<g.numGlyphs;e++)Qu(f,E,C);c&&g.associatedIconIndex>=0&&(_[g.associatedIconIndex]={shiftedAnchor:E,angle:C})}else f_(g.numGlyphs,f)}if(c){m.clear();const t=e.icon.placedSymbolArray;for(let e=0;e<t.length;e++){const i=t.get(e);if(i.hidden)f_(i.numGlyphs,m);else{const t=_[e];if(t)for(let e=0;e<i.numGlyphs;e++)Qu(m,t.shiftedAnchor,t.angle);else f_(i.numGlyphs,m)}}e.icon.dynamicLayoutVertexBuffer.updateData(m)}e.text.dynamicLayoutVertexBuffer.updateData(f)}function Rx(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function kx(e,t,i,r,n,s,a,o,l,c,h,u,d){const p=e.context,f=p.gl,m=e.transform,g="map"===o,y="map"===l,v="viewport"!==o&&"point"!==i.layout.get("symbol-placement"),b=g&&!y&&!v,w=!i.layout.get("symbol-sort-key").isConstant();let T=!1;const S=e.getDepthModeForSublayer(0,vg.ReadOnly),P=i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"),I=[],M=m.getCircleRadiusCorrection();for(const o of r){const r=t.getTile(o),l=r.getBucket(i);if(!l)continue;const h=n?l.text:l.icon;if(!h||!h.segments.get().length||!h.hasVisibleVertices)continue;const u=h.programConfigurations.get(i.id),p=n||l.sdfIcons,S=n?l.textSizeData:l.iconSizeData,E=y||0!==m.pitch,C=e.useProgram(Rx(p,n,l),u),A=Xu(S,m.zoom),z=e.style.map.terrain&&e.style.map.terrain.getTerrainData(o);let D,R,k,L,F=[0,0],B=null;if(n)R=r.glyphAtlasTexture,k=f.LINEAR,D=r.glyphAtlasTexture.size,l.iconsInText&&(F=r.imageAtlasTexture.size,B=r.imageAtlasTexture,L=E||e.options.rotating||e.options.zooming||"composite"===S.kind||"camera"===S.kind?f.LINEAR:f.NEAREST);else{const t=1!==i.layout.get("icon-size").constantOr(0)||l.iconsNeedLinear;R=r.imageAtlasTexture,k=p||e.options.rotating||e.options.zooming||t||E?f.LINEAR:f.NEAREST,D=r.imageAtlasTexture.size}const O=ee(r,1,e.transform.zoom),V=Xm(g,e.transform,O),j=_();x(j,V);const N=Ym(y,g,e.transform,O),U=ae(m,r,s,a),G=m.getProjectionData({overscaledTileID:o,applyGlobeMatrix:!d,applyTerrainMatrix:!0}),Z=P&&l.hasTextData(),$="none"!==i.layout.get("icon-text-fit")&&Z&&l.hasIconData();if(v){const t=e.style.map.terrain?(t,i)=>e.style.map.terrain.getElevation(o,t,i):null,r="map"===i.layout.get("text-rotation-alignment");t_(l,e,n,V,j,y,c,r,o.toUnwrapped(),m.width,m.height,U,t)}const q=n&&P||$,W=v||q?Cx:y?V:e.transform.clipSpaceToPixelsMatrix,H=p&&0!==i.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let X;X=p?l.iconsInText?ky(S.kind,A,b,y,v,q,e,W,N,U,D,F,M):Ry(S.kind,A,b,y,v,q,e,W,N,U,n,D,0,M):Dy(S.kind,A,b,y,v,q,e,W,N,U,n,D,M);const Y={program:C,buffers:h,uniformValues:X,projectionData:G,atlasTexture:R,atlasTextureIcon:B,atlasInterpolation:k,atlasInterpolationIcon:L,isSDF:p,hasHalo:H};if(w&&l.canOverlap){T=!0;const e=h.segments.get();for(const t of e)I.push({segments:new hl([t]),sortKey:t.sortKey,state:Y,terrainData:z})}else I.push({segments:h.segments,sortKey:0,state:Y,terrainData:z})}T&&I.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of I){const r=t.state;if(p.activeTexture.set(f.TEXTURE0),r.atlasTexture.bind(r.atlasInterpolation,f.CLAMP_TO_EDGE),r.atlasTextureIcon&&(p.activeTexture.set(f.TEXTURE1),r.atlasTextureIcon&&r.atlasTextureIcon.bind(r.atlasInterpolationIcon,f.CLAMP_TO_EDGE)),r.isSDF){const n=r.uniformValues;r.hasHalo&&(n.u_is_halo=1,Lx(r.buffers,t.segments,i,e,r.program,S,h,u,n,r.projectionData,t.terrainData)),n.u_is_halo=0}Lx(r.buffers,t.segments,i,e,r.program,S,h,u,r.uniformValues,r.projectionData,t.terrainData)}}function Lx(e,t,i,r,n,s,a,o,l,c,h){const u=r.context;n.draw(u,u.gl.TRIANGLES,s,a,o,xg.backCCW,l,h,c,i.id,e.layoutVertexBuffer,e.indexBuffer,t,i.paint,r.transform.zoom,e.programConfigurations.get(i.id),e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer)}function Fx(e,t,i,r,n){const s=e.context,a=s.gl,o=wg.disabled,l=new gg([a.ONE,a.ONE],Li.transparent,[!0,!0,!0,!0]),c=t.getBucket(i);if(!c)return;const h=r.key;let u=i.heatmapFbos.get(h);u||(u=Ox(s,t.tileSize,t.tileSize),i.heatmapFbos.set(h,u)),s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,t.tileSize,t.tileSize]),s.clear({color:Li.transparent});const d=c.programConfigurations.get(i.id),p=e.useProgram("heatmap",d,!n),f=e.transform.getProjectionData({overscaledTileID:t.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),m=e.style.map.terrain.getTerrainData(r);p.draw(s,a.TRIANGLES,vg.disabled,o,l,xg.disabled,gy(t,e.transform.zoom,i.paint.get("heatmap-intensity"),1),m,f,i.id,c.layoutVertexBuffer,c.indexBuffer,c.segments,i.paint,e.transform.zoom,d)}function Bx(e,t,i,r,n){const s=e.context,a=s.gl,o=e.transform;s.setColorMode(e.colorModeForRenderPass());const l=Vx(s,t),c=i.key,h=t.heatmapFbos.get(c);if(!h)return;s.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,h.colorAttachment.get()),s.activeTexture.set(a.TEXTURE1),l.bind(a.LINEAR,a.CLAMP_TO_EDGE);const u=o.getProjectionData({overscaledTileID:i,applyTerrainMatrix:n,applyGlobeMatrix:!r});e.useProgram("heatmapTexture").draw(s,a.TRIANGLES,vg.disabled,wg.disabled,e.colorModeForRenderPass(),xg.disabled,yy(e,t,0,1),null,u,t.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments,t.paint,o.zoom),h.destroy(),t.heatmapFbos.delete(c)}function Ox(e,t,i){var r,n;const s=e.gl,a=s.createTexture();s.bindTexture(s.TEXTURE_2D,a),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR);const o=null!==(r=e.HALF_FLOAT)&&void 0!==r?r:s.UNSIGNED_BYTE,l=null!==(n=e.RGBA16F)&&void 0!==n?n:s.RGBA;s.texImage2D(s.TEXTURE_2D,0,l,t,i,0,s.RGBA,o,null);const c=e.createFramebuffer(t,i,!1,!1);return c.colorAttachment.set(a),c}function Vx(e,t){return t.colorRampTexture||(t.colorRampTexture=new Gc(e,t.colorRamp,e.gl.RGBA)),t.colorRampTexture}function jx(e,t,i,r,n,s,a,o){let l=256;if(n.stepInterpolant){const r=t.getSource().maxzoom,n=a.canonical.z===r?Math.ceil(1<<e.transform.maxZoom-a.canonical.z):1;l=ve((c=s.maxLineLength/Q*1024*n)<=1?1:Math.pow(2,Math.ceil(Math.log(c)/Math.LN2)),256,i.maxTextureSize)}var c;return o.gradient=Lc({expression:n.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:o.gradient||void 0,clips:s.lineClipsArray}),o.texture?o.texture.update(o.gradient):o.texture=new Gc(i,o.gradient,r.RGBA),o.version=n.gradientVersion,o.texture}function Nx(e,t,i,r,n){e.activeTexture.set(t.TEXTURE0),i.imageAtlasTexture.bind(t.LINEAR,t.CLAMP_TO_EDGE),r.updatePaintBuffers(n)}function Ux(e,t,i,r,n,s){(n||e.lineAtlas.dirty)&&(t.activeTexture.set(i.TEXTURE0),e.lineAtlas.bind(t)),r.updatePaintBuffers(s)}function Gx(e,t,i,r,n,s,a){const o=s.gradients[n.id];let l=o.texture;n.gradientVersion!==o.version&&(l=jx(e,t,i,r,n,s,a,o)),i.activeTexture.set(r.TEXTURE0),l.bind(n.stepInterpolant?r.NEAREST:r.LINEAR,r.CLAMP_TO_EDGE)}function Zx(e,t,i,r,n,s,a,o,l){const c=s.gradients[n.id];let h=c.texture;n.gradientVersion!==c.version&&(h=jx(e,t,i,r,n,s,a,c)),i.activeTexture.set(r.TEXTURE0),h.bind(n.stepInterpolant?r.NEAREST:r.LINEAR,r.CLAMP_TO_EDGE),i.activeTexture.set(r.TEXTURE1),e.lineAtlas.bind(i),o.updatePaintBuffers(l)}function $x(e,t,i,r,n){if(!i||!r||!r.imageAtlas)return;const s=r.imageAtlas.patternPositions;let a=s[i.to.toString()],o=s[i.from.toString()];if(!a&&o&&(a=o),!o&&a&&(o=a),!a||!o){const e=n.getPaintProperty(t);a=s[e],o=s[e]}a&&o&&e.setConstantPatternPositions(a,o)}function qx(e,t,i,r,n,s,a,o){const l=e.context.gl,c="fill-pattern",h=i.paint.get(c),u=h&&h.constantOr(1),d=i.getCrossfadeParameters();let p,f,m,_,g;const y=e.transform,x=i.paint.get("fill-translate"),v=i.paint.get("fill-translate-anchor");a?(f=u&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",p=l.LINES):(f=u?"fillPattern":"fill",p=l.TRIANGLES);const b=h.constantOr(null);for(const h of r){const r=t.getTile(h);if(u&&!r.patternsLoaded())continue;const w=r.getBucket(i);if(!w)continue;const T=w.programConfigurations.get(i.id),S=e.useProgram(f,T),P=e.style.map.terrain&&e.style.map.terrain.getTerrainData(h);u&&(e.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),T.updatePaintBuffers(d)),$x(T,c,b,r,i);const I=y.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!o,applyTerrainMatrix:!0}),M=ae(y,r,x,v);if(a){_=w.indexBuffer2,g=w.segments2;const t=[l.drawingBufferWidth,l.drawingBufferHeight];m="fillOutlinePattern"===f&&u?dy(e,d,r,t,M):uy(t,M)}else _=w.indexBuffer,g=w.segments,m=u?cy(e,d,r,M):hy(M);const E=e.stencilModeForClipping(h);S.draw(e.context,p,n,E,s,xg.backCCW,m,P,I,i.id,w.layoutVertexBuffer,_,g,i.paint,e.transform.zoom,T)}}function Wx(e,t,i,r,n,s,a,o){const l=e.context,c=l.gl,h="fill-extrusion-pattern",u=i.paint.get(h),d=u.constantOr(1),p=i.getCrossfadeParameters(),f=i.paint.get("fill-extrusion-opacity"),m=u.constantOr(null),_=e.transform;for(const u of r){const r=t.getTile(u),g=r.getBucket(i);if(!g)continue;const y=e.style.map.terrain&&e.style.map.terrain.getTerrainData(u),x=g.programConfigurations.get(i.id),v=e.useProgram(d?"fillExtrusionPattern":"fillExtrusion",x);d&&(e.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),x.updatePaintBuffers(p));const b=_.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!o,applyTerrainMatrix:!0});$x(x,h,m,r,i);const w=ae(_,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),T=i.paint.get("fill-extrusion-vertical-gradient"),S=d?ly(e,T,f,w,u,p,r):oy(e,T,f,w);v.draw(l,l.gl.TRIANGLES,n,s,a,xg.backCCW,S,y,b,i.id,g.layoutVertexBuffer,g.indexBuffer,g.segments,i.paint,e.transform.zoom,x,e.style.map.terrain&&g.centroidVertexBuffer)}}function Hx(e,t,i,r,n,s,a,o,l){var c;const h=e.style.projection,u=e.context,d=e.transform,p=u.gl,f=[`#define NUM_ILLUMINATION_SOURCES ${i.paint.get("hillshade-highlight-color").values.length}`],m=e.useProgram("hillshade",null,!1,f),_=!e.options.moving;for(const f of r){const r=t.getTile(f),g=r.fbo;if(!g)continue;const y=h.getMeshFromTileID(u,f.canonical,o,!0,"raster"),x=null===(c=e.style.map.terrain)||void 0===c?void 0:c.getTerrainData(f);u.activeTexture.set(p.TEXTURE0),p.bindTexture(p.TEXTURE_2D,g.colorAttachment.get());const v=d.getProjectionData({overscaledTileID:f,aligned:_,applyGlobeMatrix:!l,applyTerrainMatrix:!0});m.draw(u,p.TRIANGLES,s,n[f.overscaledZ],a,xg.backCCW,xy(e,r,i),x,v,i.id,y.vertexBuffer,y.indexBuffer,y.segments)}}function Xx(e,t,i,r,n,s,a,o,l){var c;const h=e.style.projection,u=e.context,d=e.transform,p=u.gl,f=e.useProgram("colorRelief"),m=!e.options.moving;let _=!0,g=0;for(const y of r){const r=t.getTile(y),x=r.dem;if(_){const e=p.getParameter(p.MAX_TEXTURE_SIZE),{elevationTexture:t,colorTexture:r}=i.getColorRampTextures(u,e,x.getUnpackVector());u.activeTexture.set(p.TEXTURE1),t.bind(p.NEAREST,p.CLAMP_TO_EDGE),u.activeTexture.set(p.TEXTURE4),r.bind(p.LINEAR,p.CLAMP_TO_EDGE),_=!1,g=t.size[0]}if(!x||!x.data)continue;const v=x.stride,b=x.getPixels();if(u.activeTexture.set(p.TEXTURE0),u.pixelStoreUnpackPremultiplyAlpha.set(!1),r.demTexture=r.demTexture||e.getTileTexture(v),r.demTexture){const e=r.demTexture;e.update(b,{premultiply:!1}),e.bind(p.LINEAR,p.CLAMP_TO_EDGE)}else r.demTexture=new Gc(u,b,p.RGBA,{premultiply:!1}),r.demTexture.bind(p.LINEAR,p.CLAMP_TO_EDGE);const w=h.getMeshFromTileID(u,y.canonical,o,!0,"raster"),T=null===(c=e.style.map.terrain)||void 0===c?void 0:c.getTerrainData(y),S=d.getProjectionData({overscaledTileID:y,aligned:m,applyGlobeMatrix:!l,applyTerrainMatrix:!0});f.draw(u,p.TRIANGLES,s,n[y.overscaledZ],a,xg.backCCW,wy(i,r.dem,g),T,S,i.id,w.vertexBuffer,w.indexBuffer,w.segments)}}const Yx=[new s(0,0),new s(Q,0),new s(Q,Q),new s(0,Q)];function Kx(e,t,i,r,n,s,a,o,l=!1,c=!1){const h=r[r.length-1].overscaledZ,u=e.context,d=u.gl,p=e.useProgram("raster"),f=e.transform,m=e.style.projection,_=e.colorModeForRenderPass(),g=!e.options.moving,y=i.paint.get("raster-opacity"),x=i.paint.get("raster-resampling"),v=i.paint.get("raster-fade-duration"),b=!!e.style.map.terrain;for(const w of r){const r=e.getDepthModeForSublayer(w.overscaledZ-h,1===y?vg.ReadWrite:vg.ReadOnly,d.LESS),T=t.getTile(w),S="nearest"===x?d.NEAREST:d.LINEAR;u.activeTexture.set(d.TEXTURE0),T.texture.bind(S,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(d.TEXTURE1);const{parentTile:P,parentScaleBy:I,parentTopLeft:M,fadeValues:E}=Jx(T,t,v,b);T.fadeOpacity=E.tileOpacity,P?(P.fadeOpacity=E.parentTileOpacity,P.texture.bind(S,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST)):T.texture.bind(S,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),T.texture.useMipmap&&u.extTextureFilterAnisotropic&&e.transform.pitch>20&&d.texParameterf(d.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const C=e.style.map.terrain&&e.style.map.terrain.getTerrainData(w),A=f.getProjectionData({overscaledTileID:w,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),z=Ay(M,I,E.fadeMix,i,o),D=m.getMeshFromTileID(u,w.canonical,s,a,"raster");p.draw(u,d.TRIANGLES,r,n?n[w.overscaledZ]:wg.disabled,_,l?xg.frontCCW:xg.backCCW,z,C,A,i.id,D.vertexBuffer,D.indexBuffer,D.segments)}}function Jx(e,t,i,r){const n={parentTile:null,parentScaleBy:1,parentTopLeft:[0,0],fadeValues:{tileOpacity:1,parentTileOpacity:1,fadeMix:{opacity:1,mix:0}}};if(0===i||r)return n;if(e.fadingParentID){const r=t.getLoadedTile(e.fadingParentID);if(!r)return n;const s=Math.pow(2,r.tileID.overscaledZ-e.tileID.overscaledZ),a=[e.tileID.canonical.x*s%1,e.tileID.canonical.y*s%1],o=function(e,t,i){const r=rt(),n=(r-t.timeAdded)/i,s=e.fadingDirection===vm.Incoming,a=ve((r-e.timeAdded)/i,0,1),o=ve(1-n,0,1),l=s?a:o;return{tileOpacity:l,parentTileOpacity:s?o:a,fadeMix:{opacity:1,mix:1-l}}}(e,r,i);return{parentTile:r,parentScaleBy:s,parentTopLeft:a,fadeValues:o}}if(e.selfFading){const t=function(e,t){const i=ve((rt()-e.timeAdded)/t,0,1);return{tileOpacity:i,fadeMix:{opacity:i,mix:0}}}(e,i);return{parentTile:null,parentScaleBy:1,parentTopLeft:[0,0],fadeValues:t}}return n}const Qx=new Li(1,0,0,1),ev=new Li(0,1,0,1),tv=new Li(0,0,1,1),iv=new Li(1,0,1,1),rv=new Li(0,1,1,1);function nv(e,t,i,r){av(e,0,t+i/2,e.transform.width,i,r)}function sv(e,t,i,r){av(e,t-i/2,0,i,e.transform.height,r)}function av(e,t,i,r,n,s){const a=e.context,o=a.gl;o.enable(o.SCISSOR_TEST),o.scissor(t*e.pixelRatio,i*e.pixelRatio,r*e.pixelRatio,n*e.pixelRatio),a.clear({color:s}),o.disable(o.SCISSOR_TEST)}function ov(e,t,i){const r=e.context,n=r.gl,s=e.useProgram("debug"),a=vg.disabled,o=wg.disabled,l=e.colorModeForRenderPass(),c="$debug",h=e.style.map.terrain&&e.style.map.terrain.getTerrainData(i);r.activeTexture.set(n.TEXTURE0);const u=t.getTileByID(i.key).latestRawTileData,d=Math.floor((u&&u.byteLength||0)/1024),p=t.getTile(i).tileSize,f=512/Math.min(p,512)*(i.overscaledZ/e.transform.zoom)*.5;let m=i.canonical.toString();i.overscaledZ!==i.canonical.z&&(m+=` => ${i.overscaledZ}`),function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,r=e.context.gl,n=e.debugOverlayCanvas.getContext("2d");n.clearRect(0,0,i.width,i.height),n.shadowColor="white",n.shadowBlur=2,n.lineWidth=1.5,n.strokeStyle="white",n.textBaseline="top",n.font="bold 36px Open Sans, sans-serif",n.fillText(t,5,5),n.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE)}(e,`${m} ${d}kB`);const _=e.transform.getProjectionData({overscaledTileID:i,applyGlobeMatrix:!0,applyTerrainMatrix:!0});s.draw(r,n.TRIANGLES,a,o,gg.alphaBlended,xg.disabled,_y(Li.transparent,f),null,_,c,e.debugBuffer,e.quadTriangleIndexBuffer,e.debugSegments),s.draw(r,n.LINE_STRIP,a,o,l,xg.disabled,_y(Li.red),h,_,c,e.debugBuffer,e.tileBorderIndexBuffer,e.debugSegments)}function lv(e,t,i,r){const{isRenderingGlobe:n}=r,s=e.context,a=s.gl,o=e.transform,l=e.colorModeForRenderPass(),c=e.getDepthModeFor3D(),h=e.useProgram("terrain");s.bindFramebuffer.set(null),s.viewport.set([0,0,e.width,e.height]);for(const r of i){const i=t.getTerrainMesh(r.tileID),u=e.renderToTexture.getTexture(r),d=t.getTerrainData(r.tileID);s.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,u.texture);const p=t.getMeshFrameDelta(o.zoom),f=o.calculateFogMatrix(r.tileID.toUnwrapped()),m=iy(p,f,e.style.sky,o.pitch,n),_=o.getProjectionData({overscaledTileID:r.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(s,a.TRIANGLES,c,wg.disabled,l,xg.backCCW,m,d,_,"terrain",i.vertexBuffer,i.indexBuffer,i.segments)}}function cv(e,t){if(!t.mesh){const i=new Uo;i.emplaceBack(-1,-1),i.emplaceBack(1,-1),i.emplaceBack(1,1),i.emplaceBack(-1,1);const r=new sl;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),t.mesh=new eg(e.createVertexBuffer(i,tg.members),e.createIndexBuffer(r),hl.simpleSegment(0,0,i.length,r.length))}return t.mesh}class hv{constructor(e,t){this.context=new Ix(e),this.transform=t,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:y(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=$m.maxOverzooming+$m.maxUnderzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new Y_}resize(e,t,i){if(this.width=Math.floor(e*i),this.height=Math.floor(t*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style._order)this.style._layers[e].resize()}setup(){const e=this.context,t=new Uo;t.emplaceBack(0,0),t.emplaceBack(Q,0),t.emplaceBack(0,Q),t.emplaceBack(Q,Q),this.tileExtentBuffer=e.createVertexBuffer(t,tg.members),this.tileExtentSegments=hl.simpleSegment(0,0,4,2);const i=new Uo;i.emplaceBack(0,0),i.emplaceBack(Q,0),i.emplaceBack(0,Q),i.emplaceBack(Q,Q),this.debugBuffer=e.createVertexBuffer(i,tg.members),this.debugSegments=hl.simpleSegment(0,0,4,5);const r=new Zo;r.emplaceBack(0,0,0,0),r.emplaceBack(Q,0,Q,0),r.emplaceBack(0,Q,0,Q),r.emplaceBack(Q,Q,Q,Q),this.rasterBoundsBuffer=e.createVertexBuffer(r,ey.members),this.rasterBoundsSegments=hl.simpleSegment(0,0,4,2);const n=new Uo;n.emplaceBack(0,0),n.emplaceBack(Q,0),n.emplaceBack(0,Q),n.emplaceBack(Q,Q),this.rasterBoundsBufferPosOnly=e.createVertexBuffer(n,tg.members),this.rasterBoundsSegmentsPosOnly=hl.simpleSegment(0,0,4,5);const s=new Uo;s.emplaceBack(0,0),s.emplaceBack(1,0),s.emplaceBack(0,1),s.emplaceBack(1,1),this.viewportBuffer=e.createVertexBuffer(s,tg.members),this.viewportSegments=hl.simpleSegment(0,0,4,2);const a=new ol;a.emplaceBack(0),a.emplaceBack(1),a.emplaceBack(3),a.emplaceBack(2),a.emplaceBack(0),this.tileBorderIndexBuffer=e.createIndexBuffer(a);const o=new sl;o.emplaceBack(1,0,2),o.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=e.createIndexBuffer(o);const l=this.context.gl;this.stencilClearMode=new wg({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.tileExtentMesh=new eg(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments)}clearStencil(){const e=this.context,t=e.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const i=_();M(i,0,this.width,this.height,0,0,1),w(i,i,[t.drawingBufferWidth,t.drawingBufferHeight,0]);const r={mainMatrix:i,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:i};this.useProgram("clippingMask",null,!0).draw(e,t.TRIANGLES,vg.disabled,this.stencilClearMode,gg.disabled,xg.disabled,null,null,r,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments)}_renderTileClippingMasks(e,t,i){if(this.currentStencilSource===e.source||!e.isTileClipped()||!t||!t.length)return;this.currentStencilSource=e.source,this.nextStencilID+t.length>256&&this.clearStencil();const r=this.context;r.setColorMode(gg.disabled),r.setDepthMode(vg.disabled);const n={};for(const e of t)n[e.key]=this.nextStencilID++;this._renderTileMasks(n,t,i,!0),this._renderTileMasks(n,t,i,!1),this._tileClippingMaskIDs=n}_renderTileMasks(e,t,i,r){const n=this.context,s=n.gl,a=this.style.projection,o=this.transform,l=this.useProgram("clippingMask");for(const c of t){const t=e[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=a.getMeshFromTileID(this.context,c.canonical,r,!0,"stencil"),d=o.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!i,applyTerrainMatrix:!0});l.draw(n,s.TRIANGLES,vg.disabled,new wg({func:s.ALWAYS,mask:0},t,255,s.KEEP,s.KEEP,s.REPLACE),gg.disabled,i?xg.disabled:xg.backCCW,null,h,d,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments)}}_renderTilesDepthBuffer(){const e=this.context,t=e.gl,i=this.style.projection,r=this.transform,n=this.useProgram("depth"),s=this.getDepthModeFor3D(),a=Fm(r,{tileSize:r.tileSize});for(const o of a){const a=this.style.map.terrain&&this.style.map.terrain.getTerrainData(o),l=i.getMeshFromTileID(this.context,o.canonical,!0,!0,"raster"),c=r.getProjectionData({overscaledTileID:o,applyGlobeMatrix:!0,applyTerrainMatrix:!0});n.draw(e,t.TRIANGLES,s,wg.disabled,gg.disabled,xg.backCCW,null,a,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments)}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const e=this.nextStencilID++,t=this.context.gl;return new wg({func:t.NOTEQUAL,mask:255},e,255,t.KEEP,t.KEEP,t.REPLACE)}stencilModeForClipping(e){const t=this.context.gl;return new wg({func:t.EQUAL,mask:255},this._tileClippingMaskIDs[e.key],0,t.KEEP,t.KEEP,t.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(n>1){this.currentStencilSource=void 0,this.nextStencilID+n>256&&this.clearStencil();const e={};for(let i=0;i<n;i++)e[i+r]=new wg({func:t.GEQUAL,mask:255},i+this.nextStencilID,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID+=n,[e,i]}return[{[r]:wg.disabled},i]}stencilConfigForOverlapTwoPass(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(this.clearStencil(),n>1){const e={},s={};for(let i=0;i<n;i++)e[i+r]=new wg({func:t.GREATER,mask:255},n+1+i,255,t.KEEP,t.KEEP,t.REPLACE),s[i+r]=new wg({func:t.GREATER,mask:255},1+i,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID=2*n+1,[e,s,i]}return this.nextStencilID=3,[{[r]:new wg({func:t.GREATER,mask:255},2,255,t.KEEP,t.KEEP,t.REPLACE)},{[r]:new wg({func:t.GREATER,mask:255},1,255,t.KEEP,t.KEEP,t.REPLACE)},i]}colorModeForRenderPass(){const e=this.context.gl;if(this._showOverdrawInspector){const t=1/8;return new gg([e.CONSTANT_COLOR,e.ONE],new Li(t,t,t,0),[!0,!0,!0,!0])}return"opaque"===this.renderPass?gg.unblended:gg.alphaBlended}getDepthModeForSublayer(e,t,i){if(!this.opaquePassEnabledForLayer())return vg.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+e)*this.depthEpsilon;return new vg(i||this.context.gl.LEQUAL,t,[r,r])}getDepthModeFor3D(){return new vg(this.context.gl.LEQUAL,vg.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(e,t){var i,r;this.style=e,this.options=t,this.lineAtlas=e.lineAtlas,this.imageManager=e.imageManager,this.glyphManager=e.glyphManager,this.symbolFadeChange=e.placement.symbolFadeChange(rt()),this.imageManager.beginFrame();const n=this.style._order,s=this.style.tileManagers,a={},o={},l={},c={isRenderingToTexture:!1,isRenderingGlobe:(null===(i=e.projection)||void 0===i?void 0:i.transitionState)>0};for(const e in s){const t=s[e];t.used&&t.prepare(this.context),a[e]=t.getVisibleCoordinates(!1),o[e]=a[e].slice().reverse(),l[e]=t.getVisibleCoordinates(!0).reverse()}this.opaquePassCutoff=1/0;for(let e=0;e<n.length;e++)if(this.style._layers[n[e]].is3D()){this.opaquePassCutoff=e;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const e of n){const t=this.style._layers[e];if(!t.hasOffscreenPass()||t.isHidden(this.transform.zoom))continue;const i=o[t.source];("custom"===t.type||i.length)&&this.renderLayer(this,s[t.source],t,i,c)}if(null===(r=this.style.projection)||void 0===r||r.updateGPUdependent({context:this.context,useProgram:e=>this.useProgram(e)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:t.showOverdrawInspector?Li.black:Li.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(e,t){const i=e.context,r=i.gl,n=((e,t,i)=>{const r=Math.cos(t.rollInRadians),n=Math.sin(t.rollInRadians),s=Mm(t),a=t.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return{u_sky_color:e.properties.get("sky-color"),u_horizon_color:e.properties.get("horizon-color"),u_horizon:[(t.width/2-s*n)*i,(t.height/2+s*r)*i],u_horizon_normal:[-n,r],u_sky_horizon_blend:e.properties.get("sky-horizon-blend")*t.height/2*i,u_sky_blend:a}})(t,e.style.map.transform,e.pixelRatio),s=new vg(r.LEQUAL,vg.ReadWrite,[0,1]),a=wg.disabled,o=e.colorModeForRenderPass(),l=e.useProgram("sky"),c=cv(i,t);l.draw(i,r.TRIANGLES,s,a,o,xg.disabled,n,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments)}(this,this.style.sky),this._showOverdrawInspector=t.showOverdrawInspector,this.depthRangeFor3D=[0,1-(e._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=n.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[n[this.currentLayer]],t=s[e.source],i=a[e.source];this._renderTileClippingMasks(e,i,!1),this.renderLayer(this,t,e,i,c)}this.renderPass="translucent";let h=!1;for(this.currentLayer=0;this.currentLayer<n.length;this.currentLayer++){const e=this.style._layers[n[this.currentLayer]],t=s[e.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(e,c))continue;this.opaquePassEnabledForLayer()||h||(h=!0,c.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===e.type?l:o)[e.source];this._renderTileClippingMasks(e,a[e.source],!!this.renderToTexture),this.renderLayer(this,t,e,i,c)}if(c.isRenderingGlobe&&function(e,t,i){const r=e.context,n=r.gl,s=e.useProgram("atmosphere"),a=new vg(n.LEQUAL,vg.ReadOnly,[0,1]),o=e.transform,l=function(e,t){const i=e.properties.get("position"),r=[-i.x,-i.y,-i.z],n=y(new Float64Array(16));var s,a,o,l,c,h,u;return"map"===e.properties.get("anchor")&&(P(n,n,t.rollInRadians),T(n,n,-t.pitchInRadians),P(n,n,t.bearingInRadians),T(n,n,t.center.lat*Math.PI/180),S(n,n,-t.center.lng*Math.PI/180)),(s=r)[0]=((o=n)[0]*(l=(a=r)[0])+o[4]*(c=a[1])+o[8]*(h=a[2])+o[12])/(u=(u=o[3]*l+o[7]*c+o[11]*h+o[15])||1),s[1]=(o[1]*l+o[5]*c+o[9]*h+o[13])/u,s[2]=(o[2]*l+o[6]*c+o[10]*h+o[14])/u,r}(i,e.transform),c=o.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),h=t.properties.get("atmosphere-blend")*c.projectionTransition;if(0===h)return;const u=kg(o.worldSize,o.center.lat),d=o.inverseProjectionMatrix,p=new Float64Array(4);p[3]=1,Z(p,p,o.modelViewProjectionMatrix),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1,Z(p,p,d),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1;const f=((e,t,i,r,n)=>({u_sun_pos:e,u_atmosphere_blend:t,u_globe_position:i,u_globe_radius:r,u_inv_proj_matrix:n}))(l,h,[p[0],p[1],p[2]],u,d),m=cv(r,t);s.draw(r,n.TRIANGLES,a,wg.disabled,gg.alphaBlended,xg.disabled,f,null,null,"atmosphere",m.vertexBuffer,m.indexBuffer,m.segments)}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const e=function(e,t){let i=null;const r=Object.values(e._layers).flatMap((i=>i.source&&!i.isHidden(t)?[e.tileManagers[i.source]]:[])),n=r.filter((e=>"vector"===e.getSource().type)),s=r.filter((e=>"vector"!==e.getSource().type)),a=e=>{(!i||i.getSource().maxzoom<e.getSource().maxzoom)&&(i=e)};return n.forEach((e=>a(e))),i||s.forEach((e=>a(e))),i}(this.style,this.transform.zoom);e&&function(e,t,i){for(let r=0;r<i.length;r++)ov(e,t,i[r])}(this,e,e.getVisibleCoordinates())}this.options.showPadding&&function(e){const t=e.transform.padding;nv(e,e.transform.height-(t.top||0),3,Qx),nv(e,t.bottom||0,3,ev),sv(e,t.left||0,3,tv),sv(e,e.transform.width-(t.right||0),3,iv);const i=e.transform.centerPoint;!function(e,t,i,r){av(e,t-1,i-10,2,20,r),av(e,t-10,i-1,20,2,r)}(e,i.x,e.transform.height-i.y,rv)}(this),this.context.setDefault()}maybeDrawDepthAndCoords(e){if(!this.style||!this.style.map||!this.style.map.terrain)return;const t=this.terrainFacilitator.matrix,i=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;var n,s;r||(r=e?!((n=t)[0]===(s=i)[0]&&n[1]===s[1]&&n[2]===s[2]&&n[3]===s[3]&&n[4]===s[4]&&n[5]===s[5]&&n[6]===s[6]&&n[7]===s[7]&&n[8]===s[8]&&n[9]===s[9]&&n[10]===s[10]&&n[11]===s[11]&&n[12]===s[12]&&n[13]===s[13]&&n[14]===s[14]&&n[15]===s[15]):!function(e,t){var i=e[0],r=e[1],n=e[2],s=e[3],a=e[4],o=e[5],l=e[6],c=e[7],h=e[8],u=e[9],p=e[10],f=e[11],m=e[12],_=e[13],g=e[14],y=e[15],x=t[0],v=t[1],b=t[2],w=t[3],T=t[4],S=t[5],P=t[6],I=t[7],M=t[8],E=t[9],C=t[10],A=t[11],z=t[12],D=t[13],R=t[14],k=t[15];return Math.abs(i-x)<=d*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(r-v)<=d*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=d*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(s-w)<=d*Math.max(1,Math.abs(s),Math.abs(w))&&Math.abs(a-T)<=d*Math.max(1,Math.abs(a),Math.abs(T))&&Math.abs(o-S)<=d*Math.max(1,Math.abs(o),Math.abs(S))&&Math.abs(l-P)<=d*Math.max(1,Math.abs(l),Math.abs(P))&&Math.abs(c-I)<=d*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-M)<=d*Math.max(1,Math.abs(h),Math.abs(M))&&Math.abs(u-E)<=d*Math.max(1,Math.abs(u),Math.abs(E))&&Math.abs(p-C)<=d*Math.max(1,Math.abs(p),Math.abs(C))&&Math.abs(f-A)<=d*Math.max(1,Math.abs(f),Math.abs(A))&&Math.abs(m-z)<=d*Math.max(1,Math.abs(m),Math.abs(z))&&Math.abs(_-D)<=d*Math.max(1,Math.abs(_),Math.abs(D))&&Math.abs(g-R)<=d*Math.max(1,Math.abs(g),Math.abs(R))&&Math.abs(y-k)<=d*Math.max(1,Math.abs(y),Math.abs(k))}(t,i)),r||(r=this.style.map.terrain.tileManager.anyTilesAfterTime(this.terrainFacilitator.renderTime)),r&&(function(e,t){e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]}(t,i),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(e,t){const i=e.context,r=i.gl,n=e.transform,s=gg.unblended,a=new vg(r.LEQUAL,vg.ReadWrite,[0,1]),o=t.tileManager.getRenderableTiles(),l=e.useProgram("terrainDepth");i.bindFramebuffer.set(t.getFramebuffer("depth").framebuffer),i.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),i.clear({color:Li.transparent,depth:1});for(const e of o){const o=t.getTerrainMesh(e.tileID),c=t.getTerrainData(e.tileID),h=n.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:t.getMeshFrameDelta(n.zoom)};l.draw(i,r.TRIANGLES,a,wg.disabled,s,xg.backCCW,u,c,h,"terrain",o.vertexBuffer,o.indexBuffer,o.segments)}i.bindFramebuffer.set(null),i.viewport.set([0,0,e.width,e.height])}(this,this.style.map.terrain),function(e,t){const i=e.context,r=i.gl,n=e.transform,s=gg.unblended,a=new vg(r.LEQUAL,vg.ReadWrite,[0,1]),o=t.getCoordsTexture(),l=t.tileManager.getRenderableTiles(),c=e.useProgram("terrainCoords");i.bindFramebuffer.set(t.getFramebuffer("coords").framebuffer),i.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),i.clear({color:Li.transparent,depth:1}),t.coordsIndex=[];for(const e of l){const l=t.getTerrainMesh(e.tileID),h=t.getTerrainData(e.tileID);i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,o.texture);const u={u_terrain_coords_id:(255-t.coordsIndex.length)/255,u_texture:0,u_ele_delta:t.getMeshFrameDelta(n.zoom)},d=n.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});c.draw(i,r.TRIANGLES,a,wg.disabled,s,xg.backCCW,u,h,d,"terrain",l.vertexBuffer,l.indexBuffer,l.segments),t.coordsIndex.push(e.tileID.key)}i.bindFramebuffer.set(null),i.viewport.set([0,0,e.width,e.height])}(this,this.style.map.terrain))}renderLayer(e,t,i,r,n){i.isHidden(this.transform.zoom)||("background"===i.type||"custom"===i.type||(r||[]).length)&&(this.id=i.id,(e=>"symbol"===e.type)(i)?function(e,t,i,r,n,s){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:a}=s,o=wg.disabled,l=e.colorModeForRenderPass();(i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(e,t,i,r,n,s,a,o,l){const c=t.transform,h=t.style.map.terrain,u="map"===n,d="map"===s;for(const n of e){const e=r.getTile(n),s=e.getBucket(i);if(!s||!s.text||!s.text.segments.get().length)continue;const p=Xu(s.textSizeData,c.zoom),f=ee(e,1,t.transform.zoom),m=Xm(u,t.transform,f),_="none"!==i.layout.get("icon-text-fit")&&s.hasIconData();if(p){const t=Math.pow(2,c.zoom-e.tileID.overscaledZ),i=h?(e,t)=>h.getElevation(n,e,t):null;Dx(s,u,d,l,c,m,t,p,_,ae(c,e,a,o),n.toUnwrapped(),i)}}}(r,e,i,t,i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),n),0!==i.paint.get("icon-opacity").constantOr(1)&&kx(e,t,i,r,!1,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),i.layout.get("icon-rotation-alignment"),i.layout.get("icon-pitch-alignment"),i.layout.get("icon-keep-upright"),o,l,a),0!==i.paint.get("text-opacity").constantOr(1)&&kx(e,t,i,r,!0,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.layout.get("text-keep-upright"),o,l,a),t.map.showCollisionBoxes&&(Ex(e,t,i,r,!0),Ex(e,t,i,r,!1))}(e,t,i,r,this.style.placement.variableOffsets,n):(e=>"circle"===e.type)(i)?function(e,t,i,r,n){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=n,a=i.paint.get("circle-opacity"),o=i.paint.get("circle-stroke-width"),l=i.paint.get("circle-stroke-opacity"),c=!i.layout.get("circle-sort-key").isConstant();if(0===a.constantOr(1)&&(0===o.constantOr(1)||0===l.constantOr(1)))return;const h=e.context,u=h.gl,d=e.transform,p=e.getDepthModeForSublayer(0,vg.ReadOnly),f=wg.disabled,m=e.colorModeForRenderPass(),_=[],g=d.getCircleRadiusCorrection();for(let n=0;n<r.length;n++){const a=r[n],o=t.getTile(a),l=o.getBucket(i);if(!l)continue;const h=ae(d,o,i.paint.get("circle-translate"),i.paint.get("circle-translate-anchor")),u=l.programConfigurations.get(i.id),p=e.useProgram("circle",u),f=l.layoutVertexBuffer,m=l.indexBuffer,y=e.style.map.terrain&&e.style.map.terrain.getTerrainData(a),x={programConfiguration:u,program:p,layoutVertexBuffer:f,indexBuffer:m,uniformValues:py(e,o,i,h,g),terrainData:y,projectionData:d.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!s,applyTerrainMatrix:!0})};if(c){const e=l.segments.get();for(const t of e)_.push({segments:new hl([t]),sortKey:t.sortKey,state:x})}else _.push({segments:l.segments,sortKey:0,state:x})}c&&_.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of _){const{programConfiguration:r,program:n,layoutVertexBuffer:s,indexBuffer:a,uniformValues:o,terrainData:l,projectionData:c}=t.state;n.draw(h,u.TRIANGLES,p,f,m,xg.backCCW,o,l,c,i.id,s,a,t.segments,i.paint,e.transform.zoom,r)}}(e,t,i,r,n):(e=>"heatmap"===e.type)(i)?function(e,t,i,r,n){if(0===i.paint.get("heatmap-opacity"))return;const s=e.context,{isRenderingToTexture:a,isRenderingGlobe:o}=n;if(e.style.map.terrain){for(const n of r){const r=t.getTile(n);t.hasRenderableParent(n)||("offscreen"===e.renderPass?Fx(e,r,i,n,o):"translucent"===e.renderPass&&Bx(e,i,n,a,o))}s.viewport.set([0,0,e.width,e.height])}else"offscreen"===e.renderPass?function(e,t,i,r){const n=e.context,s=n.gl,a=e.transform,o=wg.disabled,l=new gg([s.ONE,s.ONE],Li.transparent,[!0,!0,!0,!0]);(function(e,t,i){const r=e.gl;e.activeTexture.set(r.TEXTURE1),e.viewport.set([0,0,t.width/4,t.height/4]);let n=i.heatmapFbos.get(Fc);n?(r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),e.bindFramebuffer.set(n.framebuffer)):(n=Ox(e,t.width/4,t.height/4),i.heatmapFbos.set(Fc,n))})(n,e,i),n.clear({color:Li.transparent});for(let c=0;c<r.length;c++){const h=r[c];if(t.hasRenderableParent(h))continue;const u=t.getTile(h),d=u.getBucket(i);if(!d)continue;const p=d.programConfigurations.get(i.id),f=e.useProgram("heatmap",p),m=a.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),_=a.getCircleRadiusCorrection();f.draw(n,s.TRIANGLES,vg.disabled,o,l,xg.backCCW,gy(u,a.zoom,i.paint.get("heatmap-intensity"),_),null,m,i.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,i.paint,a.zoom,p)}n.viewport.set([0,0,e.width,e.height])}(e,t,i,r):"translucent"===e.renderPass&&function(e,t){const i=e.context,r=i.gl;i.setColorMode(e.colorModeForRenderPass());const n=t.heatmapFbos.get(Fc);n&&(i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),i.activeTexture.set(r.TEXTURE1),Vx(i,t).bind(r.LINEAR,r.CLAMP_TO_EDGE),e.useProgram("heatmapTexture").draw(i,r.TRIANGLES,vg.disabled,wg.disabled,e.colorModeForRenderPass(),xg.disabled,yy(e,t,0,1),null,null,t.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,t.paint,e.transform.zoom))}(e,i)}(e,t,i,r,n):(e=>"line"===e.type)(i)?function(e,t,i,r,n){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=n,a=i.paint.get("line-opacity"),o=i.paint.get("line-width");if(0===a.constantOr(1)||0===o.constantOr(1))return;const l=e.getDepthModeForSublayer(0,vg.ReadOnly),c=e.colorModeForRenderPass(),h=i.paint.get("line-dasharray"),u=h.constantOr(1),d=i.paint.get("line-pattern"),p=d.constantOr(1),f=i.paint.get("line-gradient"),m=i.getCrossfadeParameters();let _;_=p?"linePattern":u&&f?"lineGradientSDF":u?"lineSDF":f?"lineGradient":"line";const g=e.context,y=g.gl,x=e.transform;let v=!0;for(const n of r){const r=t.getTile(n);if(p&&!r.patternsLoaded())continue;const a=r.getBucket(i);if(!a)continue;const o=a.programConfigurations.get(i.id),b=e.context.program.get(),w=e.useProgram(_,o),T=v||w.program!==b,S=e.style.map.terrain&&e.style.map.terrain.getTerrainData(n),P=d.constantOr(null),I=h&&h.constantOr(null);if(P&&r.imageAtlas){const e=r.imageAtlas,t=e.patternPositions[P.to.toString()],i=e.patternPositions[P.from.toString()];t&&i&&o.setConstantPatternPositions(t,i)}else if(I){const t="round"===i.layout.get("line-cap"),r=e.lineAtlas.getDash(I.to,t),n=e.lineAtlas.getDash(I.from,t);o.setConstantDashPositions(r,n)}const M=x.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!s,applyTerrainMatrix:!0}),E=x.getPixelScale();let C;p?(C=Py(e,r,i,E,m),Nx(g,y,r,o,m)):u&&f?(C=My(e,r,i,E,m,a.lineClipsArray.length),Zx(e,t,g,y,i,a,n,o,m)):u?(C=Iy(e,r,i,E,m),Ux(e,g,y,o,T,m)):f?(C=Sy(e,r,i,E,a.lineClipsArray.length),Gx(e,t,g,y,i,a,n)):C=Ty(e,r,i,E);const A=e.stencilModeForClipping(n);w.draw(g,y.TRIANGLES,l,A,c,xg.disabled,C,S,M,i.id,a.layoutVertexBuffer,a.indexBuffer,a.segments,i.paint,e.transform.zoom,o,a.layoutVertexBuffer2),v=!1}}(e,t,i,r,n):(e=>"fill"===e.type)(i)?function(e,t,i,r,n){const s=i.paint.get("fill-color"),a=i.paint.get("fill-opacity");if(0===a.constantOr(1))return;const{isRenderingToTexture:o}=n,l=e.colorModeForRenderPass(),c=i.paint.get("fill-pattern"),h=e.opaquePassEnabledForLayer()&&!c.constantOr(1)&&1===s.constantOr(Li.transparent).a&&1===a.constantOr(0)?"opaque":"translucent";if(e.renderPass===h){const n=e.getDepthModeForSublayer(1,"opaque"===e.renderPass?vg.ReadWrite:vg.ReadOnly);qx(e,t,i,r,n,l,!1,o)}if("translucent"===e.renderPass&&i.paint.get("fill-antialias")){const n=e.getDepthModeForSublayer(i.getPaintProperty("fill-outline-color")?2:0,vg.ReadOnly);qx(e,t,i,r,n,l,!0,o)}}(e,t,i,r,n):(e=>"fill-extrusion"===e.type)(i)?function(e,t,i,r,n){const s=i.paint.get("fill-extrusion-opacity");if(0===s)return;const{isRenderingToTexture:a}=n;if("translucent"===e.renderPass){const n=new vg(e.context.gl.LEQUAL,vg.ReadWrite,e.depthRangeFor3D);if(1!==s||i.paint.get("fill-extrusion-pattern").constantOr(1))Wx(e,t,i,r,n,wg.disabled,gg.disabled,a),Wx(e,t,i,r,n,e.stencilModeFor3D(),e.colorModeForRenderPass(),a);else{const s=e.colorModeForRenderPass();Wx(e,t,i,r,n,wg.disabled,s,a)}}}(e,t,i,r,n):(e=>"hillshade"===e.type)(i)?function(e,t,i,r,n){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=n,a=e.context,o=e.style.projection.useSubdivision,l=e.getDepthModeForSublayer(0,vg.ReadOnly),c=e.colorModeForRenderPass();if("offscreen"===e.renderPass)!function(e,t,i,r,n,s,a){const o=e.context,l=o.gl;for(const c of i){const i=t.getTile(c),h=i.dem;if(!h||!h.data)continue;if(!i.needsHillshadePrepare)continue;const u=h.dim,d=h.stride,p=h.getPixels();if(o.activeTexture.set(l.TEXTURE1),o.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||e.getTileTexture(d),i.demTexture){const e=i.demTexture;e.update(p,{premultiply:!1}),e.bind(l.NEAREST,l.CLAMP_TO_EDGE)}else i.demTexture=new Gc(o,p,l.RGBA,{premultiply:!1}),i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);o.activeTexture.set(l.TEXTURE0);let f=i.fbo;if(!f){const e=new Gc(o,{width:u,height:u,data:null},l.RGBA);e.bind(l.LINEAR,l.CLAMP_TO_EDGE),f=i.fbo=o.createFramebuffer(u,u,!0,!1),f.colorAttachment.set(e.texture)}o.bindFramebuffer.set(f.framebuffer),o.viewport.set([0,0,u,u]),e.useProgram("hillshadePrepare").draw(o,l.TRIANGLES,n,s,a,xg.disabled,vy(i.tileID,h),null,null,r.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments),i.needsHillshadePrepare=!1}}(e,t,r,i,l,wg.disabled,c),a.viewport.set([0,0,e.width,e.height]);else if("translucent"===e.renderPass)if(o){const[n,a,o]=e.stencilConfigForOverlapTwoPass(r);Hx(e,t,i,o,n,l,c,!1,s),Hx(e,t,i,o,a,l,c,!0,s)}else{const[n,a]=e.getStencilConfigForOverlapAndUpdateStencilID(r);Hx(e,t,i,a,n,l,c,!1,s)}}(e,t,i,r,n):(e=>"color-relief"===e.type)(i)?function(e,t,i,r,n){if("translucent"!==e.renderPass)return;if(!r.length)return;const{isRenderingToTexture:s}=n,a=e.style.projection.useSubdivision,o=e.getDepthModeForSublayer(0,vg.ReadOnly),l=e.colorModeForRenderPass();if(a){const[n,a,c]=e.stencilConfigForOverlapTwoPass(r);Xx(e,t,i,c,n,o,l,!1,s),Xx(e,t,i,c,a,o,l,!0,s)}else{const[n,a]=e.getStencilConfigForOverlapAndUpdateStencilID(r);Xx(e,t,i,a,n,o,l,!1,s)}}(e,t,i,r,n):Ja(i)?function(e,t,i,r,n){if("translucent"!==e.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!r.length)return;const{isRenderingToTexture:s}=n,a=t.getSource(),o=e.style.projection.useSubdivision;if(a instanceof bp)Kx(e,t,i,r,null,!1,!1,a.tileCoords,a.flippedWindingOrder,s);else if(o){const[n,a,o]=e.stencilConfigForOverlapTwoPass(r);Kx(e,t,i,o,n,!1,!0,Yx,!1,s),Kx(e,t,i,o,a,!0,!0,Yx,!1,s)}else{const[n,a]=e.getStencilConfigForOverlapAndUpdateStencilID(r);Kx(e,t,i,a,n,!1,!0,Yx,!1,s)}}(e,t,i,r,n):(e=>"background"===e.type)(i)?function(e,t,i,r,n){const s=i.paint.get("background-color"),a=i.paint.get("background-opacity");if(0===a)return;const{isRenderingToTexture:o}=n,l=e.context,c=l.gl,h=e.style.projection,u=e.transform,d=u.tileSize,p=i.paint.get("background-pattern");if(e.isPatternMissing(p))return;const f=!p&&1===s.a&&1===a&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==f)return;const m=wg.disabled,_=e.getDepthModeForSublayer(0,"opaque"===f?vg.ReadWrite:vg.ReadOnly),g=e.colorModeForRenderPass(),y=e.useProgram(p?"backgroundPattern":"background"),x=r||Fm(u,{tileSize:d,terrain:e.style.map.terrain});p&&(l.activeTexture.set(c.TEXTURE0),e.imageManager.bind(e.context));const v=i.getCrossfadeParameters();for(const t of x){const r=u.getProjectionData({overscaledTileID:t,applyGlobeMatrix:!o,applyTerrainMatrix:!0}),n=p?Fy(a,e,p,{tileID:t,tileSize:d},v):Ly(a,s),f=e.style.map.terrain&&e.style.map.terrain.getTerrainData(t),x=h.getMeshFromTileID(l,t.canonical,!1,!0,"raster");y.draw(l,c.TRIANGLES,_,m,g,xg.backCCW,n,f,r,i.id,x.vertexBuffer,x.indexBuffer,x.segments)}}(e,0,i,r,n):(e=>"custom"===e.type)(i)&&function(e,t,i,r){const{isRenderingGlobe:n}=r,s=e.context,a=i.implementation,o=e.style.projection,l=e.transform,c=l.getProjectionDataForCustomLayer(n),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:o.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${o.shaderPreludeCode.vertexSource}`,define:o.shaderDefine},defaultProjectionData:c},u=a.renderingMode?a.renderingMode:"2d";if("offscreen"===e.renderPass){const t=a.prerender;t&&(e.setCustomLayerDefaults(),s.setColorMode(e.colorModeForRenderPass()),t.call(a,s.gl,h),s.setDirty(),e.setBaseState())}else if("translucent"===e.renderPass){e.setCustomLayerDefaults(),s.setColorMode(e.colorModeForRenderPass()),s.setStencilMode(wg.disabled);const t="3d"===u?e.getDepthModeFor3D():e.getDepthModeForSublayer(0,vg.ReadOnly);s.setDepthMode(t),a.render(s.gl,h),s.setDirty(),e.setBaseState(),s.bindFramebuffer.set(null)}}(e,0,i,n))}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e]}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){if(!e)return!1;if(!e.from||!e.to)return!0;const t=this.imageManager.getPattern(e.from.toString()),i=this.imageManager.getPattern(e.to.toString());return!t||!i}useProgram(e,t,i=!1,r=[]){this.cache=this.cache||{};const n=!!this.style.map.terrain,s=this.style.projection,a=i?J_.projectionMercator:s.shaderPreludeCode,o=i?ig:s.shaderDefine,l=e+(t?t.cacheKey:"")+`/${i?rg:s.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(n?"/terrain":"")+(r?`/${r.join("/")}`:"");return this.cache[l]||(this.cache[l]=new sy(this.context,J_[e],t,Oy[e],this._showOverdrawInspector,n,a,o,r)),this.cache[l]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault()}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD)}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new Gc(this.context,this.debugOverlayCanvas,this.context.gl.RGBA))}destroy(){var e,t;if(this._tileTextures){for(const e in this._tileTextures){const t=this._tileTextures[e];if(t)for(const e of t)e.destroy()}this._tileTextures={}}if(this.tileExtentBuffer&&this.tileExtentBuffer.destroy(),this.debugBuffer&&this.debugBuffer.destroy(),this.rasterBoundsBuffer&&this.rasterBoundsBuffer.destroy(),this.rasterBoundsBufferPosOnly&&this.rasterBoundsBufferPosOnly.destroy(),this.viewportBuffer&&this.viewportBuffer.destroy(),this.tileBorderIndexBuffer&&this.tileBorderIndexBuffer.destroy(),this.quadTriangleIndexBuffer&&this.quadTriangleIndexBuffer.destroy(),this.tileExtentMesh&&(null===(e=this.tileExtentMesh.vertexBuffer)||void 0===e||e.destroy()),this.tileExtentMesh&&(null===(t=this.tileExtentMesh.indexBuffer)||void 0===t||t.destroy()),this.debugOverlayTexture&&this.debugOverlayTexture.destroy(),this.cache){for(const e in this.cache){const t=this.cache[e];t&&t.program&&this.context.gl.deleteProgram(t.program)}this.cache={}}this.context&&this.context.setDefault()}overLimit(){const{drawingBufferWidth:e,drawingBufferHeight:t}=this.context.gl;return this.width!==e||this.height!==t}}function uv(e,t){let i,r=!1,n=null,s=null;const a=()=>{n=null,r&&(e.apply(s,i),n=setTimeout(a,t),r=!1)};return(...e)=>(r=!0,s=this,i=e,n||a(),n)}class dv{constructor(e){this._getCurrentHash=()=>{const e=window.location.hash.replace("#","");if(this._hashName){let t;return e.split("&").map((e=>e.split("="))).forEach((e=>{e[0]===this._hashName&&(t=e)})),(t&&t[1]||"").split("/")}return e.split("/")},this._onHashChange=()=>{const e=this._getCurrentHash();if(!this._isValidHash(e))return!1;const t=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(e[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+e[2],+e[1]],zoom:+e[0],bearing:t,pitch:+(e[4]||0)}),!0},this._updateHashUnthrottled=()=>{const e=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,e)},this._removeHash=()=>{const e=this._getCurrentHash();if(0===e.length)return;const t=e.join("/");let i=t;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${t}`);let r=window.location.hash.replace(i,"");r.startsWith("#&")?r=r.slice(0,1)+r.slice(2):"#"===r&&(r="");let n=window.location.href.replace(/(#.+)?$/,r);n=n.replace("&&","&"),window.history.replaceState(window.history.state,null,n)},this._updateHash=uv(this._updateHashUnthrottled,300),this._hashName=e&&encodeURIComponent(e)}addTo(e){return this._map=e,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(e){const t=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,r=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),n=Math.pow(10,r),s=Math.round(t.lng*n)/n,a=Math.round(t.lat*n)/n,o=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=e?`/${s}/${a}/${i}`:`${i}/${a}/${s}`,(o||l)&&(c+="/"+Math.round(10*o)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const e=this._hashName;let t=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const r=i.split("=")[0];return r===e?(t=!0,`${r}=${c}`):i})).filter((e=>e));return t||i.push(`${e}=${c}`),`#${i.join("&")}`}return`#${c}`}_isValidHash(e){if(e.length<3||e.some(isNaN))return!1;try{new qd(+e[2],+e[1])}catch(e){return!1}const t=+e[0],i=+(e[3]||0),r=+(e[4]||0);return t>=this._map.getMinZoom()&&t<=this._map.getMaxZoom()&&i>=-180&&i<=180&&r>=this._map.getMinPitch()&&r<=this._map.getMaxPitch()}}const pv={linearity:.3,easing:ye(0,0,.3,1)},fv=we({deceleration:2500,maxSpeed:1400},pv),mv=we({deceleration:20,maxSpeed:1400},pv),_v=we({deceleration:1e3,maxSpeed:360},pv),gv=we({deceleration:1e3,maxSpeed:90},pv),yv=we({deceleration:1e3,maxSpeed:360},pv);class xv{constructor(e){this._map=e,this.clear()}clear(){this._inertiaBuffer=[]}record(e){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:rt(),settings:e})}_drainInertiaBuffer(){const e=this._inertiaBuffer,t=rt();for(;e.length>0&&t-e[0].time>160;)e.shift()}_onMoveEnd(e){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const t={zoom:0,bearing:0,pitch:0,roll:0,pan:new s(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)t.zoom+=e.zoomDelta||0,t.bearing+=e.bearingDelta||0,t.pitch+=e.pitchDelta||0,t.roll+=e.rollDelta||0,e.panDelta&&t.pan._add(e.panDelta),e.around&&(t.around=e.around),e.pinchAround&&(t.pinchAround=e.pinchAround);const i=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(t.pan.mag()){const n=bv(t.pan.mag(),i,we({},fv,e||{})),s=t.pan.mult(n.amount/t.pan.mag()),a=this._map.cameraHelper.handlePanInertia(s,this._map.transform);r.center=a.easingCenter,r.offset=a.easingOffset,vv(r,n)}if(t.zoom){const e=bv(t.zoom,i,mv);r.zoom=this._map.transform.zoom+e.amount,vv(r,e)}if(t.bearing){const e=bv(t.bearing,i,_v);r.bearing=this._map.transform.bearing+ve(e.amount,-179,179),vv(r,e)}if(t.pitch){const e=bv(t.pitch,i,gv);r.pitch=this._map.transform.pitch+e.amount,vv(r,e)}if(t.roll){const e=bv(t.roll,i,yv);r.roll=this._map.transform.roll+ve(e.amount,-179,179),vv(r,e)}if(r.zoom||r.bearing){const e=void 0===t.pinchAround?t.around:t.pinchAround;r.around=e?this._map.unproject(e):this._map.getCenter()}return this.clear(),we(r,{noMoveStart:!0})}}function vv(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing)}function bv(e,t,i){const{maxSpeed:r,linearity:n,deceleration:s}=i,a=ve(e*n/(t/1e3),-r,r),o=Math.abs(a)/(s*n);return{easing:i.easing,duration:1e3*o,amount:a*(o/2)}}class wv extends Tt{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i,r={}){i=i instanceof MouseEvent?i:new MouseEvent(e,i);const n=nt.mousePos(t.getCanvas(),i);super(e,we({point:n,lngLat:t.unproject(n),originalEvent:i},r)),this._defaultPrevented=!1,this.target=t}}class Tv extends Tt{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){const r="touchend"===e?i.changedTouches:i.touches,n=nt.touchPos(t.getCanvasContainer(),r),a=n.map((e=>t.unproject(e))),o=n.reduce(((e,t,i,r)=>e.add(t.div(r.length))),new s(0,0));super(e,{points:n,point:o,lngLats:a,lngLat:t.unproject(o),originalEvent:i}),this._defaultPrevented=!1}}class Sv extends Tt{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1}}class Pv{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance}reset(){delete this._mousedownPos}wheel(e){return this._firePreventable(new Sv(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new wv(e.type,this._map,e))}mouseup(e){this._map.fire(new wv(e.type,this._map,e))}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||this._map.fire(new wv(e.type,this._map,e))}dblclick(e){return this._firePreventable(new wv(e.type,this._map,e))}mouseover(e){this._map.fire(new wv(e.type,this._map,e))}mouseout(e){this._map.fire(new wv(e.type,this._map,e))}touchstart(e){return this._firePreventable(new Tv(e.type,this._map,e))}touchmove(e){this._map.fire(new Tv(e.type,this._map,e))}touchend(e){this._map.fire(new Tv(e.type,this._map,e))}touchcancel(e){this._map.fire(new Tv(e.type,this._map,e))}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return{}}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class Iv{constructor(e){this._map=e}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent}mousemove(e){this._map.fire(new wv(e.type,this._map,e))}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new wv("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent)}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._ignoreContextMenu||this._map.fire(new wv(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault()}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class Mv{constructor(e){this._map=e}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return{lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(e){return this.transform.screenPointToLocation(s.convert(e),this._map.terrain)}}class Ev{constructor(e,t){this._map=e,this._tr=new Mv(e),this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1}isEnabled(){return!!this._enabled}isActive(){return!!this._active}enable(){this.isEnabled()||(this._enabled=!0)}disable(){this.isEnabled()&&(this._enabled=!1)}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(nt.disableDrag(),this._startPos=this._lastPos=t,this._active=!0)}mousemoveWindow(e,t){if(!this._active)return;const i=t;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const r=this._startPos;this._lastPos=i,this._box||(this._box=nt.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",e));const n=Math.min(r.x,i.x),s=Math.max(r.x,i.x),a=Math.min(r.y,i.y),o=Math.max(r.y,i.y);nt.setTransform(this._box,`translate(${n}px,${a}px)`),this._box.style.width=s-n+"px",this._box.style.height=o-a+"px"}mouseupWindow(e,t){if(!this._active)return;if(0!==e.button)return;const i=this._startPos,r=t;if(this.reset(),nt.suppressClick(),i.x!==r.x||i.y!==r.y)return this._map.fire(new Tt("boxzoomend",{originalEvent:e})),{cameraAnimation:e=>e.fitScreenCoordinates(i,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",e)}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e))}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(nt.remove(this._box),this._box=null),nt.enableDrag(),delete this._startPos,delete this._lastPos}_fireEvent(e,t){return this._map.fire(new Tt(e,{originalEvent:t}))}}function Cv(e,t){if(e.length!==t.length)throw new Error(`The number of touches and points are not equal - touches ${e.length}, points ${t.length}`);const i={};for(let r=0;r<e.length;r++)i[e[r].identifier]=t[r];return i}class Av{constructor(e){this.reset(),this.numTouches=e.numTouches}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1}touchstart(e,t,i){(this.centroid||i.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=e.timeStamp),i.length===this.numTouches&&(this.centroid=function(e){const t=new s(0,0);for(const i of e)t._add(i);return t.div(e.length)}(t),this.touches=Cv(i,t)))}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const r=Cv(i,t);for(const e in this.touches){const t=r[e];(!t||t.dist(this.touches[e])>30)&&(this.aborted=!0)}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class zv{constructor(e){this.singleTap=new Av(e),this.numTaps=e.numTaps,this.reset()}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset()}touchstart(e,t,i){this.singleTap.touchstart(e,t,i)}touchmove(e,t,i){this.singleTap.touchmove(e,t,i)}touchend(e,t,i){const r=this.singleTap.touchend(e,t,i);if(r){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(r)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=r,this.count===this.numTaps)return this.reset(),r}}}class Dv{constructor(e){this._tr=new Mv(e),this._zoomIn=new zv({numTouches:1,numTaps:2}),this._zoomOut=new zv({numTouches:2,numTaps:1}),this.reset()}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset()}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i)}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i)}touchend(e,t,i){const r=this._zoomIn.touchend(e,t,i),n=this._zoomOut.touchend(e,t,i),s=this._tr;return r?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:s.zoom+1,around:s.unproject(r)},{originalEvent:e})}):n?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:s.zoom-1,around:s.unproject(n)},{originalEvent:e})}):void 0}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Rv{constructor(e){this._enabled=!!e.enable,this._moveStateManager=e.moveStateManager,this._clickTolerance=e.clickTolerance||1,this._moveFunction=e.move,this._activateOnStart=!!e.activateOnStart,e.assignEvents(this),this.reset()}reset(e){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(e)}_move(...e){const t=this._moveFunction(...e);if(t.bearingDelta||t.pitchDelta||t.rollDelta||t.around||t.panDelta)return this._active=!0,t}dragStart(e,t){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(e)&&(this._moveStateManager.startMove(e),this._lastPoint=Array.isArray(t)?t[0]:t,this._activateOnStart&&this._lastPoint&&(this._active=!0))}dragMove(e,t){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(e.preventDefault(),!this._moveStateManager.isValidMoveEvent(e))return void this.reset(e);const r=Array.isArray(t)?t[0]:t;return!this._moved&&r.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=r,this._move(i,r))}dragEnd(e){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(e)&&(this._moved&&nt.suppressClick(),this.reset(e))}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const kv=0,Lv=2,Fv={[kv]:1,[Lv]:2};class Bv{constructor(e){this._correctEvent=e.checkCorrectEvent}startMove(e){const t=nt.mouseButton(e);this._eventButton=t}endMove(e){delete this._eventButton}isValidStartEvent(e){return this._correctEvent(e)}isValidMoveEvent(e){return!function(e,t){const i=Fv[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton)}isValidEndEvent(e){return nt.mouseButton(e)===this._eventButton}}class Ov{constructor(){this._firstTouch=void 0}_isOneFingerTouch(e){return 1===e.targetTouches.length}_isSameTouchEvent(e){return e.targetTouches[0].identifier===this._firstTouch}startMove(e){this._firstTouch=e.targetTouches[0].identifier}endMove(e){delete this._firstTouch}isValidStartEvent(e){return this._isOneFingerTouch(e)}isValidMoveEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}isValidEndEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}}class Vv{constructor(e=new Bv({checkCorrectEvent:()=>!0}),t=new Ov){this.mouseMoveStateManager=e,this.oneFingerTouchMoveStateManager=t}_executeRelevantHandler(e,t,i){return e instanceof MouseEvent?t(e):"undefined"!=typeof TouchEvent&&e instanceof TouchEvent?i(e):void 0}startMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.startMove(e)),(e=>this.oneFingerTouchMoveStateManager.startMove(e)))}endMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.endMove(e)),(e=>this.oneFingerTouchMoveStateManager.endMove(e)))}isValidStartEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidStartEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidStartEvent(e)))}isValidMoveEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidMoveEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(e)))}isValidEndEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidEndEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidEndEvent(e)))}}const jv=e=>{e.mousedown=e.dragStart,e.mousemoveWindow=e.dragMove,e.mouseup=e.dragEnd,e.contextmenu=e=>{e.preventDefault()}};class Nv{constructor(e,t){this._clickTolerance=e.clickTolerance||1,this._map=t,this.reset()}reset(){this._active=!1,this._touches={},this._sum=new s(0,0)}_shouldBePrevented(e){return e<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(e,t,i){if(this._active){if(!this._shouldBePrevented(i.length))return e.preventDefault(),this._calculateTransform(e,t,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",e)}}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&this._shouldBePrevented(i.length)&&this.reset()}touchcancel(){this.reset()}_calculateTransform(e,t,i){i.length>0&&(this._active=!0);const r=Cv(i,t),n=new s(0,0),a=new s(0,0);let o=0;for(const e in r){const t=r[e],i=this._touches[e];i&&(n._add(t),a._add(t.sub(i)),o++,r[e]=t)}if(this._touches=r,this._shouldBePrevented(o)||!a.mag())return;const l=a.div(o);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:n.div(o),panDelta:l}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Uv{constructor(){this.reset()}reset(){this._active=!1,delete this._firstTwoTouches}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]))}touchmove(e,t,i){if(!this._firstTwoTouches)return;e.preventDefault();const[r,n]=this._firstTwoTouches,s=Gv(i,t,r),a=Gv(i,t,n);if(!s||!a)return;const o=this._aroundCenter?null:s.add(a).div(2);return this._move([s,a],o,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[r,n]=this._firstTwoTouches,s=Gv(i,t,r),a=Gv(i,t,n);s&&a||(this._active&&nt.suppressClick(),this.reset())}touchcancel(){this.reset()}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around}disable(){this._enabled=!1,this.reset()}isEnabled(){return!!this._enabled}isActive(){return!!this._active}}function Gv(e,t,i){for(let r=0;r<e.length;r++)if(e[r].identifier===i)return t[r]}function Zv(e,t){return Math.log(e/t)/Math.LN2}class $v extends Uv{reset(){super.reset(),delete this._distance,delete this._startDistance}_start(e){this._startDistance=this._distance=e[0].dist(e[1])}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(Zv(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Zv(this._distance,i),pinchAround:t}}}function qv(e,t){return 180*e.angleWith(t)/Math.PI}class Wv extends Uv{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1])}_move(e,t,i){const r=this._vector;if(this._vector=e[0].sub(e[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:qv(this._vector,r),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=qv(e,this._startVector);return Math.abs(i)<t}}function Hv(e){return Math.abs(e.y)>Math.abs(e.x)}class Xv extends Uv{constructor(e){super(),this._currentTouchCount=0,this._map=e}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints}touchstart(e,t,i){super.touchstart(e,t,i),this._currentTouchCount=i.length}_start(e){this._lastPoints=e,Hv(e[0].sub(e[1]))&&(this._valid=!1)}_move(e,t,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const r=e[0].sub(this._lastPoints[0]),n=e[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(r,n,i.timeStamp),this._valid?(this._lastPoints=e,this._active=!0,{pitchDelta:(r.y+n.y)/2*-.5}):void 0}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const r=e.mag()>=2,n=t.mag()>=2;if(!r&&!n)return;if(!r||!n)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const s=e.y>0==t.y>0;return Hv(e)&&Hv(t)&&s}}const Yv={panStep:100,bearingStep:15,pitchStep:10};class Kv{constructor(e){this._tr=new Mv(e);const t=Yv;this._panStep=t.panStep,this._bearingStep=t.bearingStep,this._pitchStep=t.pitchStep,this._rotationDisabled=!1}reset(){this._active=!1}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,r=0,n=0,s=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),n=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),n=1);break;case 38:e.shiftKey?r=1:(e.preventDefault(),s=-1);break;case 40:e.shiftKey?r=-1:(e.preventDefault(),s=1);break;default:return}return this._rotationDisabled&&(i=0,r=0),{cameraAnimation:a=>{const o=this._tr;a.easeTo({duration:300,easeId:"keyboardHandler",easing:Jv,zoom:t?Math.round(o.zoom)+t*(e.shiftKey?2:1):o.zoom,bearing:o.bearing+i*this._bearingStep,pitch:o.pitch+r*this._pitchStep,offset:[-n*this._panStep,-s*this._panStep],center:o.center},{originalEvent:e})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0}enableRotation(){this._rotationDisabled=!1}}function Jv(e){return e*(2-e)}const Qv=4.000244140625,eb=1/450;class tb{constructor(e,t){this._onTimeout=e=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e)},this._map=e,this._tr=new Mv(e),this._triggerRenderFrame=t,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=eb}setZoomRate(e){this._defaultZoomRate=e}setWheelZoomRate(e){this._wheelZoomRate=e}isEnabled(){return!!this._enabled}isActive(){return!!this._active||void 0!==this._finishTimeout}isZooming(){return!!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around)}disable(){this.isEnabled()&&(this._enabled=!1)}_shouldBePrevented(e){return!!this._map.cooperativeGestures.isEnabled()&&!(e.ctrlKey||this._map.cooperativeGestures.isBypassed(e))}wheel(e){if(!this.isEnabled())return;if(this._shouldBePrevented(e))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",e);let t=e.deltaMode===WheelEvent.DOM_DELTA_LINE?40*e.deltaY:e.deltaY;const i=rt(),r=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==t&&t%Qv==0?this._type="wheel":0!==t&&Math.abs(t)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=t,this._timeout=setTimeout(this._onTimeout,40,e)):this._type||(this._type=Math.abs(r*t)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,t+=this._lastValue)),e.shiftKey&&t&&(t/=4),this._type&&(this._lastWheelEvent=e,this._delta-=t,this._active||this._start(e)),e.preventDefault()}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const t=nt.mousePos(this._map.getCanvas(),e),i=this._tr;this._aroundPoint=this._aroundCenter?i.transform.locationToScreenPoint(qd.convert(i.center)):t,this._frameId||(this._frameId=!0,this._triggerRenderFrame())}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const e=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const t=e.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=t),"number"==typeof this._targetZoom&&(this._targetZoom+=t)}if(0!==this._delta){const t="wheel"===this._type&&Math.abs(this._delta)>Qv?this._wheelZoomRate:this._defaultZoomRate;let i=2/(1+Math.exp(-Math.abs(this._delta*t)));this._delta<0&&0!==i&&(i=1/i);const r="number"!=typeof this._targetZoom?e.scale:Ie(this._targetZoom);this._targetZoom=e.applyConstrain(e.getCameraLngLat(),Me(r*i)).zoom,"wheel"===this._type&&(this._startZoom=e.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0}const t="number"!=typeof this._targetZoom?e.zoom:this._targetZoom,i=this._startZoom,r=this._easing;let n,s=!1;if("wheel"===this._type&&i&&r){const e=rt()-this._lastWheelEventTime,a=Math.min((e+5)/200,1),o=r(a);n=Tr.number(i,t,o),a<1?this._frameId||(this._frameId=!0):s=!0}else n=t,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout}),200)),this._lastExpectedZoom=n,{noInertia:!0,needsRenderFrame:!s,zoomDelta:n-e.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(e){let t=xe;if(this._prevEase){const e=this._prevEase,i=(rt()-e.start)/e.duration,r=e.easing(i+.01)-e.easing(i),n=.27/Math.sqrt(r*r+1e-4)*.01;t=ye(n,Math.sqrt(.0729-n*n),.25,1)}return this._prevEase={start:rt(),duration:e,easing:t},t}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout)}}class ib{constructor(e,t){this._clickZoom=e,this._tapZoom=t}enable(){this._clickZoom.enable(),this._tapZoom.enable()}disable(){this._clickZoom.disable(),this._tapZoom.disable()}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class rb{constructor(e){this._tr=new Mv(e),this.reset()}reset(){this._active=!1}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(e.shiftKey?-1:1),around:this._tr.unproject(t)},{originalEvent:e})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class nb{constructor(){this._tap=new zv({numTouches:1,numTaps:1}),this.reset()}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset()}touchstart(e,t,i){if(!this._swipePoint)if(this._tapTime){const r=t[0],n=e.timeStamp-this._tapTime<500,s=this._tapPoint.dist(r)<30;n&&s?i.length>0&&(this._swipePoint=r,this._swipeTouch=i[0].identifier):this.reset()}else this._tap.touchstart(e,t,i)}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const r=t[0],n=r.y-this._swipePoint.y;return this._swipePoint=r,e.preventDefault(),this._active=!0,{zoomDelta:n/128}}}else this._tap.touchmove(e,t,i)}touchend(e,t,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else{const r=this._tap.touchend(e,t,i);r&&(this._tapTime=e.timeStamp,this._tapPoint=r)}}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class sb{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan")}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan")}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class ab{constructor(e,t,i,r){this._pitchWithRotate=e.pitchWithRotate,this._rollEnabled=e.rollEnabled,this._mouseRotate=t,this._mousePitch=i,this._mouseRoll=r}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable()}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable()}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class ob{constructor(e,t,i,r){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=r,this._rotationDisabled=!1,this._enabled=!0}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate")}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate")}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable()}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable()}}class lb{constructor(e,t){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=e,this._options=t,this._enabled=!1}isActive(){return!1}reset(){}_setupUI(){if(this._container)return;const e=this._map.getCanvasContainer();e.classList.add("maplibregl-cooperative-gestures"),this._container=nt.create("div","maplibregl-cooperative-gesture-screen",e);let t=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(t=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),r=document.createElement("div");r.className="maplibregl-desktop-message",r.textContent=t,this._container.appendChild(r);const n=document.createElement("div");n.className="maplibregl-mobile-message",n.textContent=i,this._container.appendChild(n),this._container.setAttribute("aria-hidden","true")}_destroyUI(){this._container&&(nt.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container}enable(){this._setupUI(),this._enabled=!0}disable(){this._enabled=!1,this._destroyUI()}isEnabled(){return this._enabled}isBypassed(e){return e[this._bypassKey]}notifyGestureBlocked(e,t){this._enabled&&(this._map.fire(new Tt("cooperativegestureprevented",{gestureType:e,originalEvent:t})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show")}),100))}}const cb=e=>e.zoom||e.drag||e.roll||e.pitch||e.rotate;class hb extends Tt{}function ub(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta||e.rollDelta}class db{constructor(e,t){this.handleWindowEvent=e=>{this.handleEvent(e,`${e.type}Window`)},this.handleEvent=(e,t)=>{if("blur"===e.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===e.type?void 0:e,r={needsRenderFrame:!1},n={},s={};for(const{handlerName:l,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;if(this._blockedByActive(s,h,l))c.reset();else if(c[t||e.type]){if(o=e,We[t||e.type]&&(o instanceof MouseEvent||o instanceof WheelEvent)){const i=nt.mousePos(this._map.getCanvas(),e);u=c[t||e.type](e,i)}else if(He(e,t||e.type)){const i=this._getMapTouches(e.touches),r=nt.touchPos(this._map.getCanvas(),i);u=c[t||e.type](e,r,i)}else qe[a=t||e.type]||We[a]||(u=c[t||e.type](e));this.mergeHandlerResult(r,n,u,l,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()}(u||c.isActive())&&(s[l]=c)}var a,o;const l={};for(const e in this._previousActiveHandlers)s[e]||(l[e]=i);this._previousActiveHandlers=s,(Object.keys(l).length||ub(r))&&(this._changes.push([r,n,l]),this._triggerRenderFrame()),(Object.keys(s).length||ub(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:c}=r;c&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],c(this._map))},this._map=e,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new xv(e),this._bearingSnap=t.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(t);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[e,t,i]of this._listeners)nt.addEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i)}destroy(){for(const[e,t,i]of this._listeners)nt.removeEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i)}_addDefaultHandlers(e){const t=this._map,i=t.getCanvasContainer();this._add("mapEvent",new Pv(t,e));const r=t.boxZoom=new Ev(t,e);this._add("boxZoom",r),e.interactive&&e.boxZoom&&r.enable();const n=t.cooperativeGestures=new lb(t,e.cooperativeGestures);this._add("cooperativeGestures",n),e.cooperativeGestures&&n.enable();const a=new Dv(t),o=new rb(t);t.doubleClickZoom=new ib(o,a),this._add("tapZoom",a),this._add("clickZoom",o),e.interactive&&e.doubleClickZoom&&t.doubleClickZoom.enable();const l=new nb;this._add("tapDragZoom",l);const c=t.touchPitch=new Xv(t);this._add("touchPitch",c),e.interactive&&e.touchPitch&&t.touchPitch.enable(e.touchPitch);const h=()=>t.project(t.getCenter()),u=function({enable:e,clickTolerance:t,aroundCenter:i=!0,minPixelCenterThreshold:r=100,rotateDegreesPerPixelMoved:n=.8},a){const o=new Bv({checkCorrectEvent:e=>0===nt.mouseButton(e)&&e.ctrlKey||2===nt.mouseButton(e)&&!e.ctrlKey});return new Rv({clickTolerance:t,move:(e,t)=>{const o=a();if(i&&Math.abs(o.y-e.y)>r)return{bearingDelta:Ge(new s(e.x,t.y),t,o)};let l=(t.x-e.x)*n;return i&&t.y<o.y&&(l=-l),{bearingDelta:l}},moveStateManager:o,enable:e,assignEvents:jv})}(e,h),d=function({enable:e,clickTolerance:t,pitchDegreesPerPixelMoved:i=-.5}){const r=new Bv({checkCorrectEvent:e=>0===nt.mouseButton(e)&&e.ctrlKey||2===nt.mouseButton(e)});return new Rv({clickTolerance:t,move:(e,t)=>({pitchDelta:(t.y-e.y)*i}),moveStateManager:r,enable:e,assignEvents:jv})}(e),p=function({enable:e,clickTolerance:t,rollDegreesPerPixelMoved:i=.3},r){const n=new Bv({checkCorrectEvent:e=>2===nt.mouseButton(e)&&e.ctrlKey});return new Rv({clickTolerance:t,move:(e,t)=>{const n=r();let s=(t.x-e.x)*i;return t.y<n.y&&(s=-s),{rollDelta:s}},moveStateManager:n,enable:e,assignEvents:jv})}(e,h);t.dragRotate=new ab(e,u,d,p),this._add("mouseRotate",u,["mousePitch"]),this._add("mousePitch",d,["mouseRotate","mouseRoll"]),this._add("mouseRoll",p,["mousePitch"]),e.interactive&&e.dragRotate&&t.dragRotate.enable();const f=function({enable:e,clickTolerance:t}){const i=new Bv({checkCorrectEvent:e=>0===nt.mouseButton(e)&&!e.ctrlKey});return new Rv({clickTolerance:t,move:(e,t)=>({around:t,panDelta:t.sub(e)}),activateOnStart:!0,moveStateManager:i,enable:e,assignEvents:jv})}(e),m=new Nv(e,t);t.dragPan=new sb(i,f,m),this._add("mousePan",f),this._add("touchPan",m,["touchZoom","touchRotate"]),e.interactive&&e.dragPan&&t.dragPan.enable(e.dragPan);const _=new Wv,g=new $v;t.touchZoomRotate=new ob(i,g,_,l),this._add("touchRotate",_,["touchPan","touchZoom"]),this._add("touchZoom",g,["touchPan","touchRotate"]),e.interactive&&e.touchZoomRotate&&t.touchZoomRotate.enable(e.touchZoomRotate),this._add("blockableMapEvent",new Iv(t));const y=t.scrollZoom=new tb(t,(()=>this._triggerRenderFrame()));this._add("scrollZoom",y,["mousePan"]),e.interactive&&e.scrollZoom&&t.scrollZoom.enable(e.scrollZoom);const x=t.keyboard=new Kv(t);this._add("keyboard",x),e.interactive&&e.keyboard&&t.keyboard.enable()}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[]}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return!0;return!1}isZooming(){return!!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return!!this._eventsInProgress.rotate}isMoving(){return Boolean(cb(this._eventsInProgress))||this.isZooming()}_blockedByActive(e,t,i){for(const r in e)if(r!==i&&(!t||t.indexOf(r)<0))return!0;return!1}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}mergeHandlerResult(e,t,i,r,n){if(!i)return;we(e,i);const s={handlerName:r,originalEvent:i.originalEvent||n};void 0!==i.zoomDelta&&(t.zoom=s),void 0!==i.panDelta&&(t.drag=s),void 0!==i.rollDelta&&(t.roll=s),void 0!==i.pitchDelta&&(t.pitch=s),void 0!==i.bearingDelta&&(t.rotate=s)}_applyChanges(){const e={},t={},i={};for(const[r,n,a]of this._changes)r.panDelta&&(e.panDelta=(e.panDelta||new s(0,0))._add(r.panDelta)),r.zoomDelta&&(e.zoomDelta=(e.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(e.bearingDelta=(e.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(e.pitchDelta=(e.pitchDelta||0)+r.pitchDelta),r.rollDelta&&(e.rollDelta=(e.rollDelta||0)+r.rollDelta),void 0!==r.around&&(e.around=r.around),void 0!==r.pinchAround&&(e.pinchAround=r.pinchAround),r.noInertia&&(e.noInertia=r.noInertia),we(t,n),we(i,a);this._updateMapTransform(e,t,i),this._changes=[]}_updateMapTransform(e,t,i){const r=this._map,n=r._getTransformForUpdate(),s=r.terrain;if(!(ub(e)||s&&this._terrainMovement))return this._fireEvents(t,i,!0);r._stop(!0);let{panDelta:a,zoomDelta:o,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:d}=e;void 0!==d&&(u=d),u=u||r.transform.centerPoint,s&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const p={panDelta:a,zoomDelta:o,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const f=u.distSqr(n.centerPoint)<.01?n.center:n.screenPointToLocation(a?u.sub(a):u);this._handleMapControls({terrain:s,tr:n,deltasForHelper:p,preZoomAroundLoc:f,combinedEventsInProgress:t,panDelta:a}),r._applyUpdatedTransform(n),this._map._update(),e.noInertia||this._inertia.record(e),this._fireEvents(t,i,!0)}_handleMapControls({terrain:e,tr:t,deltasForHelper:i,preZoomAroundLoc:r,combinedEventsInProgress:n,panDelta:s}){const a=this._map.cameraHelper;if(a.handleMapControlsRollPitchBearingZoom(i,t),e)return a.useGlobeControls?(this._terrainMovement||!n.drag&&!n.zoom||(this._terrainMovement=!0,this._map._elevationFreeze=!0),void a.handleMapControlsPan(i,t,r)):this._terrainMovement||!n.drag&&!n.zoom?void(n.drag&&this._terrainMovement&&s?t.setCenter(t.screenPointToLocation(t.centerPoint.sub(s))):a.handleMapControlsPan(i,t,r)):(this._terrainMovement=!0,this._map._elevationFreeze=!0,void a.handleMapControlsPan(i,t,r));a.handleMapControlsPan(i,t,r)}_fireEvents(e,t,i){const r=cb(this._eventsInProgress),n=cb(e),s={};for(const t in e){const{originalEvent:i}=e[t];this._eventsInProgress[t]||(s[`${t}start`]=i),this._eventsInProgress[t]=e[t]}!r&&n&&this._fireEvent("movestart",n.originalEvent);for(const e in s)this._fireEvent(e,s[e]);n&&this._fireEvent("move",n.originalEvent);for(const t in e){const{originalEvent:i}=e[t];this._fireEvent(t,i)}const a={};let o;for(const e in this._eventsInProgress){const{handlerName:i,originalEvent:r}=this._eventsInProgress[e];this._handlersById[i].isActive()||(delete this._eventsInProgress[e],o=t[i]||r,a[`${e}end`]=o)}for(const e in a)this._fireEvent(e,a[e]);const l=cb(this._eventsInProgress),c=(r||n)&&!l;if(c&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const e=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&e.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(e)}if(i&&c){this._updatingCamera=!0;const e=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),t=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;!e||!e.essential&&tt.prefersReducedMotion?(this._map.fire(new Tt("moveend",{originalEvent:o})),t(this._map.getBearing())&&this._map.resetNorth()):(t(e.bearing||this._map.getBearing())&&(e.bearing=0),e.freezeElevation=!0,this._map.easeTo(e,{originalEvent:o})),this._updatingCamera=!1}}_fireEvent(e,t){this._map.fire(new Tt(e,t?{originalEvent:t}:{}))}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((e=>{delete this._frameId,this.handleEvent(new hb("renderFrame",{timeStamp:e})),this._applyChanges()}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame())}}class pb extends Pt{constructor(e,t,i){super(),this._renderFrameCallback=()=>{const e=Math.min((rt()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(e)),e<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop()},this._moving=!1,this._zooming=!1,this.transform=e,this._bearingSnap=i.bearingSnap,this.cameraHelper=t,this.on("moveend",(()=>{delete this._requestedCameraState}))}migrateProjection(e,t){e.apply(this.transform,!0),this.transform=e,this.cameraHelper=t}getCenter(){return new qd(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}getCenterElevation(){return this.transform.elevation}setCenterElevation(e,t){return this.jumpTo({elevation:e},t),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(e){this._centerClampedToGround=e}panBy(e,t,i){return e=s.convert(e).mult(-1),this.panTo(this.transform.center,we({offset:e},t),i)}panTo(e,t,i){return this.easeTo(we({center:e},t),i)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(e,t,i){return this.easeTo(we({zoom:e},t),i)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(e,t){return e!=this.transform.fov&&(this.transform.setFov(e),this.fire(new Tt("movestart",t)).fire(new Tt("move",t)).fire(new Tt("moveend",t))),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(e,t,i){return this.easeTo(we({bearing:e},t),i)}resetNorth(e,t){return this.rotateTo(0,we({duration:1e3},e),t),this}resetNorthPitch(e,t){return this.easeTo(we({bearing:0,pitch:0,roll:0,duration:1e3},e),t),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}getRoll(){return this.transform.roll}setRoll(e,t){return this.jumpTo({roll:e},t),this}cameraForBounds(e,t){e=Wd.convert(e).adjustAntiMeridian();const i=t&&t.bearing||0;return this._cameraForBoxAndBearing(e.getNorthWest(),e.getSouthEast(),i,t)}_cameraForBoxAndBearing(e,t,i,r){const n={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=we({padding:n,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const e=r.padding;r.padding={top:e,bottom:e,right:e,left:e}}const s=we(n,r.padding);r.padding=s;const a=this.transform,o=new Wd(e,t);return this.cameraHelper.cameraForBoxAndBearing(r,s,o,i,a)}fitBounds(e,t,i){return this._fitInternal(this.cameraForBounds(e,t),t,i)}fitScreenCoordinates(e,t,i,r,n){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(s.convert(e)),this.transform.screenPointToLocation(s.convert(t)),i,r),r,n)}_fitInternal(e,t,i){return e?(delete(t=we(e,t)).padding,t.linear?this.easeTo(t,i):this.flyTo(t,i)):this}jumpTo(e,t){this.stop();const i=this._getTransformForUpdate();let r=!1,n=!1,s=!1;const a=i.zoom;this.cameraHelper.handleJumpToCenterZoom(i,e);const o=i.zoom!==a;return"elevation"in e&&i.elevation!==+e.elevation&&i.setElevation(+e.elevation),"bearing"in e&&i.bearing!==+e.bearing&&(r=!0,i.setBearing(+e.bearing)),"pitch"in e&&i.pitch!==+e.pitch&&(n=!0,i.setPitch(+e.pitch)),"roll"in e&&i.roll!==+e.roll&&(s=!0,i.setRoll(+e.roll)),null==e.padding||i.isPaddingEqual(e.padding)||i.setPadding(e.padding),this._applyUpdatedTransform(i),this.fire(new Tt("movestart",t)).fire(new Tt("move",t)),o&&this.fire(new Tt("zoomstart",t)).fire(new Tt("zoom",t)).fire(new Tt("zoomend",t)),r&&this.fire(new Tt("rotatestart",t)).fire(new Tt("rotate",t)).fire(new Tt("rotateend",t)),n&&this.fire(new Tt("pitchstart",t)).fire(new Tt("pitch",t)).fire(new Tt("pitchend",t)),s&&this.fire(new Tt("rollstart",t)).fire(new Tt("roll",t)).fire(new Tt("rollend",t)),this.fire(new Tt("moveend",t))}calculateCameraOptionsFromTo(e,t,i,r=0){const n=ip.fromLngLat(e,t),s=ip.fromLngLat(i,r),a=s.x-n.x,o=s.y-n.y,l=s.z-n.z,c=Math.hypot(a,o,l);if(0===c)throw new Error("Can't calculate camera options with same From and To");const h=Math.hypot(a,o),u=Me(this.transform.cameraToCenterDistance/c/this.transform.tileSize),d=180*Math.atan2(a,-o)/Math.PI;let p=180*Math.acos(h/c)/Math.PI;return p=l<0?90-p:90+p,{center:s.toLngLat(),elevation:r,zoom:u,pitch:p,bearing:d}}calculateCameraOptionsFromCameraLngLatAltRotation(e,t,i,r,n){const s=this.transform.calculateCenterFromCameraLngLatAlt(e,t,i,r);return{center:s.center,elevation:s.elevation,zoom:s.zoom,bearing:i,pitch:r,roll:n}}easeTo(e,t){this._stop(!1,e.easeId),(!1===(e=we({offset:[0,0],duration:500,easing:xe},e)).animate||!e.essential&&tt.prefersReducedMotion)&&(e.duration=0);const i=this._getTransformForUpdate(),r=this.getBearing(),n=i.pitch,a=i.roll,o="bearing"in e?this._normalizeBearing(e.bearing,r):r,l="pitch"in e?+e.pitch:n,c="roll"in e?this._normalizeBearing(e.roll,a):a,h="padding"in e?e.padding:i.padding,u=s.convert(e.offset);let d,p;e.around&&(d=qd.convert(e.around),p=i.locationToScreenPoint(d));const f={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},m=this.cameraHelper.handleEaseTo(i,{bearing:o,pitch:l,roll:c,padding:h,around:d,aroundPoint:p,offsetAsPoint:u,offset:e.offset,zoom:e.zoom,center:e.center});return this._rotating=this._rotating||r!==o,this._pitching=this._pitching||l!==n,this._rolling=this._rolling||c!==a,this._padding=!i.isPaddingEqual(h),this._zooming=this._zooming||m.isZooming,this._easeId=e.easeId,this._prepareEase(t,e.noMoveStart,f),this.terrain&&this._prepareElevation(m.elevationCenter),this._ease((r=>{m.easeFunc(r),this.terrain&&!e.freezeElevation&&this._updateElevation(r),this._applyUpdatedTransform(i),this._fireMoveEvents(t)}),(i=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(t,i)}),e),this}_prepareEase(e,t,i={}){this._moving=!0,t||i.moving||this.fire(new Tt("movestart",e)),this._zooming&&!i.zooming&&this.fire(new Tt("zoomstart",e)),this._rotating&&!i.rotating&&this.fire(new Tt("rotatestart",e)),this._pitching&&!i.pitching&&this.fire(new Tt("pitchstart",e)),this._rolling&&!i.rolling&&this.fire(new Tt("rollstart",e))}_prepareElevation(e){this._elevationCenter=e,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(e,this.transform.tileZoom),this._elevationFreeze=!0}_updateElevation(e){void 0!==this._elevationStart&&void 0!==this._elevationCenter||this._prepareElevation(this.transform.center),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const t=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(e<1&&t!==this._elevationTarget){const i=this._elevationTarget-this._elevationStart;this._elevationStart+=e*(i-(t-(i*e+this._elevationStart))/(1-e)),this._elevationTarget=t}this.transform.setElevation(Tr.number(this._elevationStart,this._elevationTarget,e))}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain)}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(e){if(!this.terrain&&e.elevation>=0&&e.pitch<=90)return{};const t=e.getCameraLngLat(),i=e.getCameraAltitude(),r=this.terrain?this.terrain.getElevationForLngLatZoom(t,e.zoom):0;if(i<r){const i=this.calculateCameraOptionsFromTo(t,r,e.center,e.elevation);return{pitch:i.pitch,zoom:i.zoom}}return{}}_applyUpdatedTransform(e){const t=[];if(t.push((e=>this._elevateCameraIfInsideTerrain(e))),this.transformCameraUpdate&&t.push((e=>this.transformCameraUpdate(e))),!t.length)return;const i=e.clone();for(const e of t){const t=i.clone(),{center:r,zoom:n,roll:s,pitch:a,bearing:o,elevation:l}=e(t);r&&t.setCenter(r),void 0!==l&&t.setElevation(l),void 0!==n&&t.setZoom(n),void 0!==s&&t.setRoll(s),void 0!==a&&t.setPitch(a),void 0!==o&&t.setBearing(o),i.apply(t,!1)}this.transform.apply(i,!1)}_fireMoveEvents(e){this.fire(new Tt("move",e)),this._zooming&&this.fire(new Tt("zoom",e)),this._rotating&&this.fire(new Tt("rotate",e)),this._pitching&&this.fire(new Tt("pitch",e)),this._rolling&&this.fire(new Tt("roll",e))}_afterEase(e,t){if(this._easeId&&t&&this._easeId===t)return;delete this._easeId;const i=this._zooming,r=this._rotating,n=this._pitching,s=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,i&&this.fire(new Tt("zoomend",e)),r&&this.fire(new Tt("rotateend",e)),n&&this.fire(new Tt("pitchend",e)),s&&this.fire(new Tt("rollend",e)),this.fire(new Tt("moveend",e))}flyTo(e,t){if(!e.essential&&tt.prefersReducedMotion){const i=Te(e,["center","zoom","bearing","pitch","roll","elevation","padding"]);return this.jumpTo(i,t)}this.stop(),e=we({offset:[0,0],speed:1.2,curve:1.42,easing:xe},e);const i=this._getTransformForUpdate(),r=i.bearing,n=i.pitch,a=i.roll,o=i.padding,l="bearing"in e?this._normalizeBearing(e.bearing,r):r,c="pitch"in e?+e.pitch:n,h="roll"in e?this._normalizeBearing(e.roll,a):a,u="padding"in e?e.padding:i.padding,d=s.convert(e.offset);let p=i.centerPoint.add(d);const f=i.screenPointToLocation(p),m=this.cameraHelper.handleFlyTo(i,{bearing:l,pitch:c,roll:h,padding:u,locationAtOffset:f,offsetAsPoint:d,center:e.center,minZoom:e.minZoom,zoom:e.zoom});let _=e.curve;const g=Math.max(i.width,i.height),y=g/m.scaleOfZoom,x=m.pixelPathLength;"number"==typeof m.scaleOfMinZoom&&(_=Math.sqrt(g/m.scaleOfMinZoom/x*2));const v=_*_;function b(e){const t=(y*y-g*g+(e?-1:1)*v*v*x*x)/(2*(e?y:g)*v*x);return Math.log(Math.sqrt(t*t+1)-t)}function w(e){return(Math.exp(e)-Math.exp(-e))/2}function T(e){return(Math.exp(e)+Math.exp(-e))/2}const S=b(!1);let P=function(e){return T(S)/T(S+_*e)},I=function(e){return g*((T(S)*function(e){return w(e)/T(e)}(S+_*e)-w(S))/v)/x},M=(b(!0)-S)/_;if(Math.abs(x)<2e-6||!isFinite(M)){if(Math.abs(g-y)<1e-6)return this.easeTo(e,t);const i=y<g?-1:1;M=Math.abs(Math.log(y/g))/_,I=()=>0,P=e=>Math.exp(i*_*e)}return e.duration="duration"in e?+e.duration:1e3*M/("screenSpeed"in e?+e.screenSpeed/_:+e.speed),e.maxDuration&&e.duration>e.maxDuration&&(e.duration=0),this._zooming=!0,this._rotating=r!==l,this._pitching=c!==n,this._rolling=h!==a,this._padding=!i.isPaddingEqual(u),this._prepareEase(t,!1),this.terrain&&this._prepareElevation(m.targetCenter),this._ease((s=>{const f=s*M,_=1/P(f),g=I(f);this._rotating&&i.setBearing(Tr.number(r,l,s)),this._pitching&&i.setPitch(Tr.number(n,c,s)),this._rolling&&i.setRoll(Tr.number(a,h,s)),this._padding&&(i.interpolatePadding(o,u,s),p=i.centerPoint.add(d)),m.easeFunc(s,_,g,p),this.terrain&&!e.freezeElevation&&this._updateElevation(s),this._applyUpdatedTransform(i),this._fireMoveEvents(t)}),(()=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(t)}),e),this}isEasing(){return!!this._easeFrameId}stop(){return this._stop()}_stop(e,t){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const e=this._onEaseEnd;delete this._onEaseEnd,e.call(this,t)}return e||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(e,t,i){!1===i.animate||0===i.duration?(e(1),t()):(this._easeStart=rt(),this._easeOptions=i,this._onEaseFrame=e,this._onEaseEnd=t,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback))}_normalizeBearing(e,t){e=be(e,-180,180);const i=Math.abs(e-t);return Math.abs(e-360-t)<i&&(e-=360),Math.abs(e+360-t)<i&&(e+=360),e}queryTerrainElevation(e){return this.terrain?this.terrain.getElevationForLngLat(qd.convert(e),this.transform):null}}const fb={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class mb{constructor(e=fb){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")))},this._updateData=e=>{!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType&&"terrain"!==e.type||this._updateAttributions()},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"))},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show")},this.options=e}getDefaultPosition(){return"bottom-right"}onAdd(e){return this._map=e,this._compact=this.options.compact,this._container=nt.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=nt.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=nt.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){nt.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.title=i,e.setAttribute("aria-label",i)}_updateAttributions(){if(!this._map.style)return;let e=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=e.concat(this.options.customAttribution.map((e=>"string"!=typeof e?"":e))):"string"==typeof this.options.customAttribution&&e.push(this.options.customAttribution)),this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id}const t=this._map.style.tileManagers;for(const i in t){const r=t[i];if(r.used||r.usedForTerrain){const t=r.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution)}}e=e.filter((e=>String(e).trim())),e.sort(((e,t)=>e.length-t.length)),e=e.filter(((t,i)=>{for(let r=i+1;r<e.length;r++)if(e[r].indexOf(t)>=0)return!1;return!0}));const i=e.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,e.length?(this._innerContainer.innerHTML=nt.sanitize(i),this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null)}}class _b{constructor(e={}){this._updateCompact=()=>{const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&t.classList.add("maplibregl-compact"):t.classList.remove("maplibregl-compact")}},this.options=e}getDefaultPosition(){return"bottom-left"}onAdd(e){this._map=e,this._compact=this.options&&this.options.compact,this._container=nt.create("div","maplibregl-ctrl");const t=nt.create("a","maplibregl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://maplibre.org/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){nt.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0}}class gb{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[]}}var yb;!function(e){e.create="create",e.load="load",e.fullLoad="fullLoad"}(yb||(yb={}));let xb=null,vb=[];const bb=1e3/60,wb="loadTime",Tb="fullLoadTime",Sb={mark(e){performance.mark(e)},frame(e){const t=e;null!=xb&&vb.push(t-xb),xb=t},clearMetrics(){xb=null,vb=[],performance.clearMeasures(wb),performance.clearMeasures(Tb);for(const e in yb)performance.clearMarks(yb[e])},getPerformanceMetrics(){performance.measure(wb,yb.create,yb.load),performance.measure(Tb,yb.create,yb.fullLoad);const e=performance.getEntriesByName(wb)[0].duration,t=performance.getEntriesByName(Tb)[0].duration,i=vb.length,r=1/(vb.reduce(((e,t)=>e+t),0)/i/1e3),n=vb.filter((e=>e>bb)).reduce(((e,t)=>e+(t-bb)/bb),0);return{loadTime:e,fullLoadTime:t,fps:r,percentDroppedFrames:n/(i+n)*100,totalFrames:i}}};var Pb=ro([{name:"a_pos3d",type:"Int16",components:3}]);class Ib extends Pt{constructor(e){super(),this._lastTilesetChange=rt(),this.tileManager=e,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=e._source.tileSize*2**this.deltaZoom,e.usedForTerrain=!0,e.tileSize=this.tileSize}destruct(){this.tileManager.usedForTerrain=!1,this.tileManager.tileSize=null}getSource(){return this.tileManager._source}update(e,t){this.tileManager.update(e,t),this._renderableTilesKeys=[];const i={};for(const r of Fm(e,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:t,calculateTileZoom:this.tileManager._source.calculateTileZoom}))i[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.terrainRttPosMatrix32f=new Float64Array(16),M(r.terrainRttPosMatrix32f,0,Q,Q,0,0,1),this._tiles[r.key]=new bm(r,this.tileSize),this._lastTilesetChange=rt());for(const e in this._tiles)i[e]||delete this._tiles[e]}freeRtt(e){for(const t in this._tiles){const i=this._tiles[t];(!e||i.tileID.equals(e)||i.tileID.isChildOf(e)||e.isChildOf(i.tileID))&&(i.rtt=[])}}getRenderableTiles(){return this._renderableTilesKeys.map((e=>this.getTileByID(e)))}getTileByID(e){return this._tiles[e]}getTerrainCoords(e,t){return t?this._getTerrainCoordsForTileRanges(e,t):this._getTerrainCoordsForRegularTile(e)}_getTerrainCoordsForRegularTile(e){const t={};for(const i of this._renderableTilesKeys){const r=this._tiles[i].tileID,n=e.clone(),s=re();if(r.canonical.equals(e.canonical))M(s,0,Q,Q,0,0,1);else if(r.canonical.isChildOf(e.canonical)){const t=r.canonical.z-e.canonical.z,i=r.canonical.x-(r.canonical.x>>t<<t),n=r.canonical.y-(r.canonical.y>>t<<t),a=Q>>t;M(s,0,a,a,0,0,1),b(s,s,[-i*a,-n*a,0])}else{if(!e.canonical.isChildOf(r.canonical))continue;{const t=e.canonical.z-r.canonical.z,i=e.canonical.x-(e.canonical.x>>t<<t),n=e.canonical.y-(e.canonical.y>>t<<t),a=Q>>t;M(s,0,Q,Q,0,0,1),b(s,s,[i*a,n*a,0]),w(s,s,[1/2**t,1/2**t,0])}}n.terrainRttPosMatrix32f=new Float32Array(s),t[i]=n}return t}_getTerrainCoordsForTileRanges(e,t){const i={};for(const r of this._renderableTilesKeys){const n=this._tiles[r].tileID;if(!this._isWithinTileRanges(n,t))continue;const s=e.clone(),a=re();if(n.canonical.z===e.canonical.z){const t=e.canonical.x-n.canonical.x+e.wrap*(1<<e.canonical.z),i=e.canonical.y-n.canonical.y;M(a,0,Q,Q,0,0,1),b(a,a,[t*Q,i*Q,0])}else if(n.canonical.z>e.canonical.z){const t=n.canonical.z-e.canonical.z,i=n.canonical.x-(n.canonical.x>>t<<t)+e.wrap*(1<<n.canonical.z),r=n.canonical.y-(n.canonical.y>>t<<t),s=e.canonical.x-(n.canonical.x>>t),o=e.canonical.y-(n.canonical.y>>t),l=Q>>t;M(a,0,l,l,0,0,1),b(a,a,[-i*l+s*Q,-r*l+o*Q,0])}else{const t=e.canonical.z-n.canonical.z,i=e.canonical.x-(e.canonical.x>>t<<t)+e.wrap*(1<<e.canonical.z),r=e.canonical.y-(e.canonical.y>>t<<t),s=(e.canonical.x>>t)-n.canonical.x,o=(e.canonical.y>>t)-n.canonical.y,l=Q<<t;M(a,0,l,l,0,0,1),b(a,a,[i*Q+s*l,r*Q+o*l,0])}s.terrainRttPosMatrix32f=new Float32Array(a),i[r]=s}return i}getSourceTile(e,t){const i=this.tileManager._source;let r=e.overscaledZ-this.deltaZoom;if(r>i.maxzoom&&(r=i.maxzoom),r<i.minzoom)return;this._sourceTileCache[e.key]||(this._sourceTileCache[e.key]=e.scaledTo(r).key);let n=this.findTileInCaches(this._sourceTileCache[e.key]);if(!(null==n?void 0:n.dem)&&t)for(;r>=i.minzoom&&!(null==n?void 0:n.dem);)n=this.findTileInCaches(e.scaledTo(r--).key);return n}findTileInCaches(e){let t=this.tileManager.getTileByID(e);return t||(t=this.tileManager._outOfViewCache.getByKey(e),t)}anyTilesAfterTime(e=Date.now()){return this._lastTilesetChange>=e}_isWithinTileRanges(e,t){const i=t[e.canonical.z];return!!i&&(e.wrap>i.minWrap||e.wrap<i.maxWrap||e.canonical.x>=i.minTileXWrapped&&e.canonical.x<=i.maxTileXWrapped&&e.canonical.y>=i.minTileY&&e.canonical.y<=i.maxTileY)}}class Mb{constructor(e,t,i){this._meshCache={},this.painter=e,this.tileManager=new Ib(t),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024}getDEMElevation(e,t,i,r=8192){var n;if(!(t>=0&&t<r&&i>=0&&i<r))return 0;const s=this.getTerrainData(e),a=null===(n=s.tile)||void 0===n?void 0:n.dem;if(!a)return 0;const o=function(e,t,i){var r=t[0],n=t[1];return e[0]=i[0]*r+i[4]*n+i[12],e[1]=i[1]*r+i[5]*n+i[13],e}([],[t/r*Q,i/r*Q],s.u_terrain_matrix),l=[o[0]*a.dim,o[1]*a.dim],c=Math.floor(l[0]),h=Math.floor(l[1]),u=l[0]-c,d=l[1]-h;return a.get(c,h)*(1-u)*(1-d)+a.get(c+1,h)*u*(1-d)+a.get(c,h+1)*(1-u)*d+a.get(c+1,h+1)*u*d}getElevationForLngLatZoom(e,t){if(!op(t,e.wrap()))return 0;const{tileID:i,mercatorX:r,mercatorY:n}=this._getOverscaledTileIDFromLngLatZoom(e,t);return this.getElevation(i,r%Q,n%Q,Q)}getElevationForLngLat(e,t){const i=Fm(t,{maxzoom:this.tileManager.maxzoom,minzoom:this.tileManager.minzoom,tileSize:512,terrain:this});let r=0;for(const e of i)e.canonical.z>r&&(r=Math.min(e.canonical.z,this.tileManager.maxzoom));return this.getElevationForLngLatZoom(e,r)}getElevation(e,t,i,r=8192){return this.getDEMElevation(e,t,i,r)*this.exaggeration}getTerrainData(e){if(!this._emptyDemTexture){const e=this.painter.context,t=new kc({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new Gc(e,t,e.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new Gc(e,new kc({width:1,height:1}),e.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=y([])}const t=this.tileManager.getSourceTile(e,!0);if(t&&t.dem&&(!t.demTexture||t.needsTerrainPrepare)){const e=this.painter.context;t.demTexture=this.painter.getTileTexture(t.dem.stride),t.demTexture?t.demTexture.update(t.dem.getPixels(),{premultiply:!1}):t.demTexture=new Gc(e,t.dem.getPixels(),e.gl.RGBA,{premultiply:!1}),t.demTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),t.needsTerrainPrepare=!1}const i=t&&t.toString()+t.tileID.key+e.key;if(i&&!this._demMatrixCache[i]){const i=this.tileManager.getSource().maxzoom;let s=e.canonical.z-t.tileID.canonical.z;e.overscaledZ>e.canonical.z&&(e.canonical.z>=i?s=e.canonical.z-i:Re("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const a=e.canonical.x-(e.canonical.x>>s<<s),o=e.canonical.y-(e.canonical.y>>s<<s),l=((r=new Float64Array(16))[0]=(n=[1/(Q<<s),1/(Q<<s),0])[0],r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=n[1],r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=n[2],r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r);b(l,l,[a*Q,o*Q,0]),this._demMatrixCache[e.key]={matrix:l,coord:e}}var r,n;return{u_depth:2,u_terrain:3,u_terrain_dim:t&&t.dem&&t.dem.dim||1,u_terrain_matrix:i?this._demMatrixCache[e.key].matrix:this._emptyDemMatrix,u_terrain_unpack:t&&t.dem&&t.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(t&&t.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:t}}getFramebuffer(e){const t=this.painter,i=t.width/devicePixelRatio,r=t.height/devicePixelRatio;return!this._fbo||this._fbo.width===i&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new Gc(t.context,{width:i,height:r,data:null},t.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(t.context.gl.NEAREST,t.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new Gc(t.context,{width:i,height:r,data:null},t.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(t.context.gl.NEAREST,t.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=t.context.createFramebuffer(i,r,!0,!1),this._fbo.depthAttachment.set(t.context.createRenderbuffer(t.context.gl.DEPTH_COMPONENT16,i,r))),this._fbo.colorAttachment.set("coords"===e?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const e=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const t=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let e=0,i=0;e<this._coordsTextureSize;e++)for(let r=0;r<this._coordsTextureSize;r++,i+=4)t[i+0]=255&r,t[i+1]=255&e,t[i+2]=r>>8<<4|e>>8,t[i+3]=0;const i=new kc({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(t.buffer)),r=new Gc(e,i,e.gl.RGBA,{premultiply:!1});return r.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(e){this.painter.maybeDrawDepthAndCoords(!0);const t=new Uint8Array(4),i=this.painter.context,r=i.gl,n=Math.round(e.x*this.painter.pixelRatio/devicePixelRatio),s=Math.round(e.y*this.painter.pixelRatio/devicePixelRatio),a=Math.round(this.painter.height/devicePixelRatio);i.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(n,a-s-1,1,1,r.RGBA,r.UNSIGNED_BYTE,t),i.bindFramebuffer.set(null);const o=t[0]+(t[2]>>4<<8),l=t[1]+((15&t[2])<<8),c=this.coordsIndex[255-t[3]],h=c&&this.tileManager.getTileByID(c);if(!h)return null;const u=this._coordsTextureSize,d=(1<<h.tileID.canonical.z)*u;return new ip((h.tileID.canonical.x*u+o)/d+h.tileID.wrap,(h.tileID.canonical.y*u+l)/d,this.getElevation(h.tileID,o,l,u))}depthAtPoint(e){const t=new Uint8Array(4),i=this.painter.context,r=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),r.readPixels(e.x,this.painter.height/devicePixelRatio-e.y-1,1,1,r.RGBA,r.UNSIGNED_BYTE,t),i.bindFramebuffer.set(null),(t[0]/16777216+t[1]/65536+t[2]/256+t[3])/256}getTerrainMesh(e){var t;const i=(null===(t=this.painter.style.projection)||void 0===t?void 0:t.transitionState)>0,r=i&&0===e.canonical.y,n=i&&e.canonical.y===(1<<e.canonical.z)-1,s=`m_${r?"n":""}_${n?"s":""}`;if(this._meshCache[s])return this._meshCache[s];const a=this.painter.context,o=new Go,l=new sl,c=this.meshSize,h=Q/c,u=c*c;for(let e=0;e<=c;e++)for(let t=0;t<=c;t++)o.emplaceBack(t*h,e*h,0);for(let e=0;e<u;e+=c+1)for(let t=0;t<c;t++)l.emplaceBack(t+e,c+t+e+1,c+t+e+2),l.emplaceBack(t+e,c+t+e+2,t+e+1);const d=o.length,p=d+(c+1),f=(c+1)*c,m=r?Th:0,_=r?0:1,g=n?Sh:Q,y=n?0:1;for(let e=0;e<=c;e++)o.emplaceBack(e*h,m,_);for(let e=0;e<=c;e++)o.emplaceBack(e*h,g,y);for(let e=0;e<c;e++)l.emplaceBack(f+e,p+e,p+e+1),l.emplaceBack(f+e,p+e+1,f+e+1),l.emplaceBack(0+e,d+e+1,d+e),l.emplaceBack(0+e,0+e+1,d+e+1);const x=o.length,v=x+2*(c+1);for(const e of[0,1])for(let t=0;t<=c;t++)for(const i of[0,1])o.emplaceBack(e*Q,t*h,i);for(let e=0;e<2*c;e+=2)l.emplaceBack(x+e,x+e+1,x+e+3),l.emplaceBack(x+e,x+e+3,x+e+2),l.emplaceBack(v+e,v+e+3,v+e+1),l.emplaceBack(v+e,v+e+2,v+e+3);const b=new eg(a.createVertexBuffer(o,Pb.members),a.createIndexBuffer(l),hl.simpleSegment(0,0,o.length,l.length));return this._meshCache[s]=b,b}getMeshFrameDelta(e){return 2*Math.PI*$d/Math.pow(2,Math.max(e,0))/5}getMinTileElevationForLngLatZoom(e,t){var i;if(!op(t,e.wrap()))return 0;const{tileID:r}=this._getOverscaledTileIDFromLngLatZoom(e,t);return null!==(i=this.getMinMaxElevation(r).minElevation)&&void 0!==i?i:0}getMinMaxElevation(e){const t=this.getTerrainData(e).tile,i={minElevation:null,maxElevation:null};return t&&t.dem&&(i.minElevation=t.dem.min*this.exaggeration,i.maxElevation=t.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(e,t){const i=ip.fromLngLat(e.wrap()),r=(1<<t)*Q,n=i.x*r,s=i.y*r,a=Math.floor(n/Q),o=Math.floor(s/Q);return{tileID:new hp(t,0,t,a,o),mercatorX:n,mercatorY:s}}}class Eb{constructor(e,t,i){this._context=e,this._size=t,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0}destruct(){for(const e of this._objects)e.texture.destroy(),e.fbo.destroy()}_createObject(e){const t=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new Gc(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),t.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),t.colorAttachment.set(i.texture),{id:e,fbo:t,texture:i,stamp:-1,inUse:!1}}getObjectForId(e){return this._objects[e]}useObject(e){e.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((t=>e.id!==t)),this._recentlyUsed.push(e.id)}stampObject(e){e.stamp=++this._stamp}getOrCreateFreeObject(){for(const e of this._recentlyUsed)if(!this._objects[e].inUse)return this._objects[e];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const e=this._createObject(this._objects.length);return this._objects.push(e),e}freeObject(e){e.inUse=!1}freeAllObjects(){for(const e of this._objects)this.freeObject(e)}isFull(){return!(this._objects.length<this._size)&&!1===this._objects.some((e=>!e.inUse))}}const Cb={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0,"color-relief":!0};class Ab{constructor(e,t){this.painter=e,this.terrain=t,this.pool=new Eb(e.context,30,t.tileManager.tileSize*t.qualityFactor)}destruct(){this.pool.destruct()}getTexture(e){return this.pool.getObjectForId(e.rtt[this._stacks.length-1].id).texture}prepareForRender(e,t){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.tileManager.getRenderableTiles(),this._renderableLayerIds=e._order.filter((i=>!e._layers[i].isHidden(t))),this._coordsAscending={};for(const t in e.tileManagers){this._coordsAscending[t]={};const i=e.tileManagers[t].getVisibleCoordinates(),r=e.tileManagers[t].getSource(),n=r instanceof bp?r.terrainTileRanges:null;for(const e of i){const i=this.terrain.tileManager.getTerrainCoords(e,n);for(const e in i)this._coordsAscending[t][e]||(this._coordsAscending[t][e]=[]),this._coordsAscending[t][e].push(i[e])}}this._coordsAscendingStr={};for(const t of e._order){const i=e._layers[t],r=i.source;if(Cb[i.type]&&!this._coordsAscendingStr[r]){this._coordsAscendingStr[r]={};for(const e in this._coordsAscending[r])this._coordsAscendingStr[r][e]=this._coordsAscending[r][e].map((e=>e.key)).sort().join()}}for(const e of this._renderableTiles)for(const t in this._coordsAscendingStr){const i=this._coordsAscendingStr[t][e.tileID.key];i&&i!==e.rttCoords[t]&&(e.rtt=[])}}renderLayer(e,t){if(e.isHidden(this.painter.transform.zoom))return!1;const i=Object.assign(Object.assign({},t),{isRenderingToTexture:!0}),r=e.type,n=this.painter,s=this._renderableLayerIds[this._renderableLayerIds.length-1]===e.id;if(Cb[r]&&(this._prevType&&Cb[this._prevType]||this._stacks.push([]),this._prevType=r,this._stacks[this._stacks.length-1].push(e.id),!s))return!0;if(Cb[this._prevType]||Cb[r]&&s){this._prevType=r;const e=this._stacks.length-1,t=this._stacks[e]||[];for(const r of this._renderableTiles){if(this.pool.isFull()&&(lv(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(r),r.rtt[e]){const t=this.pool.getObjectForId(r.rtt[e].id);if(t.stamp===r.rtt[e].stamp){this.pool.useObject(t);continue}}const s=this.pool.getOrCreateFreeObject();this.pool.useObject(s),this.pool.stampObject(s),r.rtt[e]={id:s.id,stamp:s.stamp},n.context.bindFramebuffer.set(s.fbo.framebuffer),n.context.clear({color:Li.transparent,stencil:0}),n.currentStencilSource=void 0;for(let e=0;e<t.length;e++){const a=n.style._layers[t[e]],o=a.source?this._coordsAscending[a.source][r.tileID.key]:[r.tileID];n.context.viewport.set([0,0,s.fbo.width,s.fbo.height]),n._renderTileClippingMasks(a,o,!0),n.renderLayer(n,n.style.tileManagers[a.source],a,o,i),a.source&&(r.rttCoords[a.source]=this._coordsAscendingStr[a.source][r.tileID.key])}}return lv(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects(),Cb[r]}return!1}}const zb={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},Db=r,Rb={hash:!1,interactive:!0,bearingSnap:7,attributionControl:fb,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:st.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,transformConstrain:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,reduceMotion:void 0,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0,experimentalZoomLevelsToOverscale:void 0},kb={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class Lb{constructor(e,t,i=!1){this.mousedown=e=>{this.startMove(e,nt.mousePos(this.element,e)),nt.addEventListener(window,"mousemove",this.mousemove),nt.addEventListener(window,"mouseup",this.mouseup)},this.mousemove=e=>{this.move(e,nt.mousePos(this.element,e))},this.mouseup=e=>{this._rotatePitchHandler.dragEnd(e),this.offTemp()},this.touchstart=e=>{1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=nt.touchPos(this.element,e.targetTouches)[0],this.startMove(e,this._startPos),nt.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),nt.addEventListener(window,"touchend",this.touchend))},this.touchmove=e=>{1!==e.targetTouches.length?this.reset():(this._lastPos=nt.touchPos(this.element,e.targetTouches)[0],this.move(e,this._lastPos))},this.touchend=e=>{0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp()},this.reset=()=>{this._rotatePitchHandler.reset(),delete this._startPos,delete this._lastPos,this.offTemp()},this._clickTolerance=10,this.element=t;const r=new Vv;this._rotatePitchHandler=new Rv({clickTolerance:3,move:(e,r)=>{const n=t.getBoundingClientRect(),a=new s((n.bottom-n.top)/2,(n.right-n.left)/2);return{bearingDelta:Ge(new s(e.x,r.y),r,a),pitchDelta:i?-.5*(r.y-e.y):void 0}},moveStateManager:r,enable:!0,assignEvents:()=>{}}),this.map=e,nt.addEventListener(t,"mousedown",this.mousedown),nt.addEventListener(t,"touchstart",this.touchstart,{passive:!1}),nt.addEventListener(t,"touchcancel",this.reset)}startMove(e,t){this._rotatePitchHandler.dragStart(e,t),nt.disableDrag()}move(e,t){const i=this.map,{bearingDelta:r,pitchDelta:n}=this._rotatePitchHandler.dragMove(e,t)||{};r&&i.setBearing(i.getBearing()+r),n&&i.setPitch(i.getPitch()+n)}off(){const e=this.element;nt.removeEventListener(e,"mousedown",this.mousedown),nt.removeEventListener(e,"touchstart",this.touchstart,{passive:!1}),nt.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),nt.removeEventListener(window,"touchend",this.touchend),nt.removeEventListener(e,"touchcancel",this.reset),this.offTemp()}offTemp(){nt.enableDrag(),nt.removeEventListener(window,"mousemove",this.mousemove),nt.removeEventListener(window,"mouseup",this.mouseup),nt.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),nt.removeEventListener(window,"touchend",this.touchend)}}let Fb;function Bb(e,t,i,r=!1){if(r||!i.getCoveringTilesDetailsProvider().allowWorldCopies())return null==e?void 0:e.wrap();const n=new qd(e.lng,e.lat);if(e=new qd(e.lng,e.lat),t){const r=new qd(e.lng-360,e.lat),n=new qd(e.lng+360,e.lat),s=i.locationToScreenPoint(e).distSqr(t);i.locationToScreenPoint(r).distSqr(t)<s?e=r:i.locationToScreenPoint(n).distSqr(t)<s&&(e=n)}for(;Math.abs(e.lng-i.center.lng)>180;){const t=i.locationToScreenPoint(e);if(t.x>=0&&t.y>=0&&t.x<=i.width&&t.y<=i.height)break;e.lng>i.center.lng?e.lng-=360:e.lng+=360}return e.lng!==n.lng&&i.isPointOnMapSurface(i.locationToScreenPoint(e))?e:n}const Ob={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function Vb(e,t,i){const r=e.classList;for(const e in Ob)r.remove(`maplibregl-${i}-anchor-${e}`);r.add(`maplibregl-${i}-anchor-${t}`)}class jb extends Pt{constructor(e){if(super(),this._onKeyPress=e=>{const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup()},this._onMapClick=e=>{const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup()},this._update=e=>{if(!this._map)return;const t=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==e?void 0:e.type)||"render"===(null==e?void 0:e.type)&&!t)&&this._map.once("render",this._update),this._lngLat=Bb(this._lngLat,this._flatPos,this._map.transform),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let i="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?i=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(i=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let r="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?r="rotateX(0deg)":"map"===this._pitchAlignment&&(r=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||e&&"moveend"!==e.type||(this._pos=this._pos.round()),nt.setTransform(this._element,`${Ob[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${r} ${i}`),tt.frameAsync(new AbortController).then((()=>{this._updateOpacity(e&&"moveend"===e.type)})).catch((()=>{}))},this._onMove=e=>{if(!this._isDragging){const t=this._clickTolerance||this._map._clickTolerance;this._isDragging=e.point.dist(this._pointerdownPos)>=t}this._isDragging&&(this._pos=e.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new Tt("dragstart"))),this.fire(new Tt("drag")))},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new Tt("dragend")),this._state="inactive"},this._addDragHandler=e=>{this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(this._pos).add(this._offset),this._pointerdownPos=e.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp))},this._anchor=e&&e.anchor||"center",this._color=e&&e.color||"#3FB1CE",this._scale=e&&e.scale||1,this._draggable=e&&e.draggable||!1,this._clickTolerance=e&&e.clickTolerance||0,this._subpixelPositioning=e&&e.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=e&&e.rotation||0,this._rotationAlignment=e&&e.rotationAlignment||"auto",this._pitchAlignment=e&&e.pitchAlignment&&"auto"!==e.pitchAlignment?e.pitchAlignment:this._rotationAlignment,this.setOpacity(null==e?void 0:e.opacity,null==e?void 0:e.opacityWhenCovered),e&&e.element)this._element=e.element,this._offset=s.convert(e&&e.offset||[0,0]);else{this._defaultMarker=!0,this._element=nt.create("div");const t=nt.createNS("http://www.w3.org/2000/svg","svg"),i=41,r=27;t.setAttributeNS(null,"display","block"),t.setAttributeNS(null,"height",`${i}px`),t.setAttributeNS(null,"width",`${r}px`),t.setAttributeNS(null,"viewBox",`0 0 ${r} ${i}`);const n=nt.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"stroke","none"),n.setAttributeNS(null,"stroke-width","1"),n.setAttributeNS(null,"fill","none"),n.setAttributeNS(null,"fill-rule","evenodd");const a=nt.createNS("http://www.w3.org/2000/svg","g");a.setAttributeNS(null,"fill-rule","nonzero");const o=nt.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"transform","translate(3.0, 29.0)"),o.setAttributeNS(null,"fill","#000000");const l=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const e of l){const t=nt.createNS("http://www.w3.org/2000/svg","ellipse");t.setAttributeNS(null,"opacity","0.04"),t.setAttributeNS(null,"cx","10.5"),t.setAttributeNS(null,"cy","5.80029008"),t.setAttributeNS(null,"rx",e.rx),t.setAttributeNS(null,"ry",e.ry),o.appendChild(t)}const c=nt.createNS("http://www.w3.org/2000/svg","g");c.setAttributeNS(null,"fill",this._color);const h=nt.createNS("http://www.w3.org/2000/svg","path");h.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),c.appendChild(h);const u=nt.createNS("http://www.w3.org/2000/svg","g");u.setAttributeNS(null,"opacity","0.25"),u.setAttributeNS(null,"fill","#000000");const d=nt.createNS("http://www.w3.org/2000/svg","path");d.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),u.appendChild(d);const p=nt.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(6.0, 7.0)"),p.setAttributeNS(null,"fill","#FFFFFF");const f=nt.createNS("http://www.w3.org/2000/svg","g");f.setAttributeNS(null,"transform","translate(8.0, 8.0)");const m=nt.createNS("http://www.w3.org/2000/svg","circle");m.setAttributeNS(null,"fill","#000000"),m.setAttributeNS(null,"opacity","0.25"),m.setAttributeNS(null,"cx","5.5"),m.setAttributeNS(null,"cy","5.5"),m.setAttributeNS(null,"r","5.4999962");const _=nt.createNS("http://www.w3.org/2000/svg","circle");_.setAttributeNS(null,"fill","#FFFFFF"),_.setAttributeNS(null,"cx","5.5"),_.setAttributeNS(null,"cy","5.5"),_.setAttributeNS(null,"r","5.4999962"),f.appendChild(m),f.appendChild(_),a.appendChild(o),a.appendChild(c),a.appendChild(u),a.appendChild(p),a.appendChild(f),t.appendChild(a),t.setAttributeNS(null,"height",i*this._scale+"px"),t.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(t),this._offset=s.convert(e&&e.offset||[0,-14])}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(e=>{e.preventDefault()})),this._element.addEventListener("mousedown",(e=>{e.preventDefault()})),Vb(this._element,this._anchor,"marker"),e&&e.className)for(const t of e.className.split(" "))this._element.classList.add(t);this._popup=null}addTo(e){return this.remove(),this._map=e,this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label",e._getUIString("Marker.Title")),this._element.hasAttribute("role")||this._element.setAttribute("role","button"),e.getCanvasContainer().appendChild(this._element),e.on("move",this._update),e.on("moveend",this._update),e.on("terrain",this._update),e.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),nt.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=qd.convert(e),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,r=Math.abs(i)/Math.SQRT2;e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-t],"bottom-left":[r,-1*(t-i+r)],"bottom-right":[-r,-1*(t-i+r)],left:[i,-1*(t-i)],right:[-i,-1*(t-i)]}:this._offset}this._popup=e,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress)}return this}setSubpixelPositioning(e){return this._subpixelPositioning=e,this}getPopup(){return this._popup}togglePopup(){const e=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:e?(e.isOpen()?e.remove():(e.setLngLat(this._lngLat),e.addTo(this._map)),this):this}_updateOpacity(e=!1){var t,i;const r=null===(t=this._map)||void 0===t?void 0:t.terrain,n=this._map.transform.isLocationOccluded(this._lngLat);if(!r||n){const e=n?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==e&&(this._element.style.opacity=e))}if(e)this._opacityTimeout=null;else{if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null}),100)}const a=this._map,o=a.terrain.depthAtPoint(this._pos),l=a.terrain.getElevationForLngLat(this._lngLat,a.transform);if(a.transform.lngLatToCameraDepth(this._lngLat,l)-o<.006)return void(this._element.style.opacity=this._opacity);const c=-this._offset.y/a.transform.pixelsPerMeter,h=Math.sin(a.getPitch()*Math.PI/180)*c,u=a.terrain.depthAtPoint(new s(this._pos.x,this._pos.y-this._offset.y)),d=a.transform.lngLatToCameraDepth(this._lngLat,l+h)-u>.006;(null===(i=this._popup)||void 0===i?void 0:i.isOpen())&&d&&this._popup.remove(),this._element.style.opacity=d?this._opacityWhenCovered:this._opacity}getOffset(){return this._offset}setOffset(e){return this._offset=s.convert(e),this._update(),this}addClassName(e){this._element.classList.add(e)}removeClassName(e){this._element.classList.remove(e)}toggleClassName(e){return this._element.classList.toggle(e)}setDraggable(e){return this._draggable=!!e,this._map&&(e?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e&&"auto"!==e?e:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(e,t){return(void 0===this._opacity||void 0===e&&void 0===t)&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==e&&(this._opacity=e),void 0!==t&&(this._opacityWhenCovered=t),this._map&&this._updateOpacity(!0),this}}const Nb={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let Ub=0,Gb=!1;const Zb={maxWidth:100,unit:"metric"};function $b(e,t,i){const r=i&&i.maxWidth||100,n=e._container.clientHeight/2,s=e._container.clientWidth/2,a=e.unproject([s-r/2,n]),o=e.unproject([s+r/2,n]),l=Math.round(e.project(o).x-e.project(a).x),c=Math.min(r,l,e._container.clientWidth),h=a.distanceTo(o);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?qb(t,c,i/5280,e._getUIString("ScaleControl.Miles")):qb(t,c,i,e._getUIString("ScaleControl.Feet"))}else i&&"nautical"===i.unit?qb(t,c,h/1852,e._getUIString("ScaleControl.NauticalMiles")):h>=1e3?qb(t,c,h/1e3,e._getUIString("ScaleControl.Kilometers")):qb(t,c,h,e._getUIString("ScaleControl.Meters"))}function qb(e,t,i,r){const n=function(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}(i);e.style.width=t*(n/i)+"px",e.innerHTML=`${n}&nbsp;${r}`}const Wb={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1,locationOccludedOpacity:void 0,padding:void 0},Hb=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Xb(e){if(e){if("number"==typeof e){const t=Math.round(Math.abs(e)/Math.SQRT2);return{center:new s(0,0),top:new s(0,e),"top-left":new s(t,t),"top-right":new s(-t,t),bottom:new s(0,-e),"bottom-left":new s(t,-t),"bottom-right":new s(-t,-t),left:new s(e,0),right:new s(-e,0)}}if(e instanceof s||Array.isArray(e)){const t=s.convert(e);return{center:t,top:t,"top-left":t,"top-right":t,bottom:t,"bottom-left":t,"bottom-right":t,left:t,right:t}}return{center:s.convert(e.center||[0,0]),top:s.convert(e.top||[0,0]),"top-left":s.convert(e["top-left"]||[0,0]),"top-right":s.convert(e["top-right"]||[0,0]),bottom:s.convert(e.bottom||[0,0]),"bottom-left":s.convert(e["bottom-left"]||[0,0]),"bottom-right":s.convert(e["bottom-right"]||[0,0]),left:s.convert(e.left||[0,0]),right:s.convert(e.right||[0,0])}}return Xb(new s(0,0))}const Yb=r;e.AJAXError=lt,e.AttributionControl=mb,e.BoxZoomHandler=Ev,e.CanvasSource=Tp,e.CooperativeGesturesHandler=lb,e.DoubleClickZoomHandler=ib,e.DragPanHandler=sb,e.DragRotateHandler=ab,e.EdgeInsets=sg,e.Event=Tt,e.Evented=Pt,e.FullscreenControl=class extends Pt{constructor(e={}){super(),this._onFullscreenChange=()=>{var e;let t=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(e=null==t?void 0:t.shadowRoot)||void 0===e?void 0:e.fullscreenElement;)t=t.shadowRoot.fullscreenElement;t===this._container!==this._fullscreen&&this._handleFullscreenChange()},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen()},this._fullscreen=!1,e&&e.container&&(e.container instanceof HTMLElement?this._container=e.container:Re("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange")}onAdd(e){return this._map=e,this._container||(this._container=this._map.getContainer()),this._controlContainer=nt.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){nt.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange)}_setupUI(){const e=this._fullscreenButton=nt.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);nt.create("span","maplibregl-ctrl-icon",e).setAttribute("aria-hidden","true"),e.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange)}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.title=e}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new Tt("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new Tt("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable())}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen()}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen()}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize()}},e.GeoJSONSource=xp,e.GeolocateControl=class extends Pt{constructor(e){super(),this._onSuccess=e=>{if(this._map){if(this._isOutOfMapMaxBounds(e))return this._setErrorState(),this.fire(new Tt("outofmaxbounds",e)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=e,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(e),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(e),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new Tt("geolocate",e)),this._finish()}},this._updateCamera=e=>{const t=new qd(e.coords.longitude,e.coords.latitude),i=e.coords.accuracy,r=we({bearing:this._map.getBearing()},this.options.fitBoundsOptions),n=Wd.fromLngLat(t,i);this._map.fitBounds(n,r,{geolocateSource:!0})},this._updateMarker=e=>{if(e){const t=new qd(e.coords.longitude,e.coords.latitude);this._accuracyCircleMarker.setLngLat(t).addTo(this._map),this._userLocationDotMarker.setLngLat(t).addTo(this._map),this._accuracy=e.coords.accuracy,this._updateCircleRadiusIfNeeded()}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove()},this._onUpdate=()=>{this._updateCircleRadiusIfNeeded()},this._onError=e=>{if(this._map){if(1===e.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e),void 0!==this._geolocationWatchID&&this._clearWatch()}else{if(3===e.code&&Gb)return;this._setErrorState()}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new Tt("error",e)),this._finish()}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this._geolocateButton=nt.create("button","maplibregl-ctrl-geolocate",this._container),nt.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0)},this._finishSetupUI=e=>{if(this._map){if(!1===e){Re("Geolocation support is not available so the GeolocateControl will be disabled.");const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e)}else{const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e)}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=nt.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new jb({element:this._dotElement}),this._circleElement=nt.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new jb({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onUpdate),this._map.on("move",this._onUpdate),this._map.on("rotate",this._onUpdate),this._map.on("pitch",this._onUpdate)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(e=>{const t=(null==e?void 0:e[0])instanceof ResizeObserverEntry;e.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t||this._map.isZooming()||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new Tt("trackuserlocationend")),this.fire(new Tt("userlocationlostfocus")))}))}},this.options=we({},Nb,e)}onAdd(e){return this._map=e,this._container=nt.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return n(this,arguments,void 0,(function*(e=!1){if(void 0!==Fb&&!e)return Fb;if(void 0===window.navigator.permissions)return Fb=!!window.navigator.geolocation,Fb;try{const e=yield window.navigator.permissions.query({name:"geolocation"});Fb="denied"!==e.state}catch(e){Fb=!!window.navigator.geolocation}return Fb}))}().then((e=>this._finishSetupUI(e))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),nt.remove(this._container),this._map.off("zoom",this._onUpdate),this._map.off("move",this._onUpdate),this._map.off("rotate",this._onUpdate),this._map.off("pitch",this._onUpdate),this._map=void 0,Ub=0,Gb=!1}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"ACTIVE_ERROR":case"BACKGROUND_ERROR":case"OFF":case void 0:break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadiusIfNeeded(){const e=this._userLocationDotMarker.getLngLat();if(!(this.options.showUserLocation&&this.options.showAccuracyCircle&&this._accuracy&&e))return;const t=this._map.project(e),i=this._map.unproject([t.x+100,t.y]),r=e.distanceTo(i)/100,n=2*this._accuracy/r;this._circleElement.style.width=`${n.toFixed(2)}px`,this._circleElement.style.height=`${n.toFixed(2)}px`}trigger(){if(!this._setup)return Re("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new Tt("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":Ub--,Gb=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new Tt("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new Tt("trackuserlocationstart")),this.fire(new Tt("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),Ub++,Ub>1?(e={maximumAge:6e5,timeout:0},Gb=!0):(e=this.options.positionOptions,Gb=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,e)}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return!0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null)}},e.GlobeControl=class{constructor(){this._toggleProjection=()=>{var e;const t=null===(e=this._map.getProjection())||void 0===e?void 0:e.type;this._map.setProjection("mercator"!==t&&t?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon()},this._updateGlobeIcon=()=>{var e;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(e=this._map.getProjection())||void 0===e?void 0:e.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"))}}onAdd(e){return this._map=e,this._container=nt.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=nt.create("button","maplibregl-ctrl-globe",this._container),nt.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){nt.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0}},e.Hash=dv,e.ImageSource=bp,e.KeyboardHandler=Kv,e.LngLat=qd,e.LngLatBounds=Wd,e.LogoControl=_b,e.Map=class extends pb{constructor(e){var t,i;Sb.mark(yb.create);const r=Object.assign(Object.assign(Object.assign({},Rb),e),{canvasContextAttributes:Object.assign(Object.assign({},Rb.canvasContextAttributes),e.canvasContextAttributes)});if(null!=r.minZoom&&null!=r.maxZoom&&r.minZoom>r.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=r.minPitch&&null!=r.maxPitch&&r.minPitch>r.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=r.minPitch&&r.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=r.maxPitch&&r.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const n=new dg,s=new _g;if(void 0!==r.minZoom&&n.setMinZoom(r.minZoom),void 0!==r.maxZoom&&n.setMaxZoom(r.maxZoom),void 0!==r.minPitch&&n.setMinPitch(r.minPitch),void 0!==r.maxPitch&&n.setMaxPitch(r.maxPitch),void 0!==r.renderWorldCopies&&n.setRenderWorldCopies(r.renderWorldCopies),null!==r.transformConstrain&&n.setConstrainOverride(r.transformConstrain),super(n,s,{bearingSnap:r.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new gb,this._controls=[],this._mapId=Pe(),this._lostContextStyle={style:null,images:null},this._contextLost=e=>{e.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.painter.destroy();for(const e of Object.values(this.style._layers))if("custom"===e.type&&console.warn(`Custom layer with id '${e.id}' cannot be restored after WebGL context loss. You will need to re-add it manually after context restoration.`),e._listeners)for(const[t]of Object.entries(e._listeners))console.warn(`Custom layer with id '${e.id}' had event listeners for event '${t}' which cannot be restored after WebGL context loss. You will need to re-add them manually after context restoration.`);this._lostContextStyle=this._getStyleAndImages(),this.style.destroy(),this.style=null,this.fire(new Tt("webglcontextlost",{originalEvent:e}))},this._contextRestored=e=>{this._lostContextStyle.style&&this.setStyle(this._lostContextStyle.style,{diff:!1}),this._lostContextStyle.images&&(this.style.imageManager.images=this._lostContextStyle.images),this._lostContextStyle={style:null,images:null},this._setupPainter(),this.resize(),this._update(),this._resizeInternal(),this.fire(new Tt("webglcontextrestored",{originalEvent:e}))},this._onMapScroll=e=>{if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update()},this._interactive=r.interactive,this._maxTileCacheSize=r.maxTileCacheSize,this._maxTileCacheZoomLevels=r.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},r.canvasContextAttributes),this._trackResize=!0===r.trackResize,this._bearingSnap=r.bearingSnap,this._centerClampedToGround=r.centerClampedToGround,this._refreshExpiredTiles=!0===r.refreshExpiredTiles,this._fadeDuration=r.fadeDuration,this._crossSourceCollisions=!0===r.crossSourceCollisions,this._collectResourceTiming=!0===r.collectResourceTiming,this._locale=Object.assign(Object.assign({},zb),r.locale),this._clickTolerance=r.clickTolerance,this._overridePixelRatio=r.pixelRatio,this._maxCanvasSize=r.maxCanvasSize,this._zoomLevelsToOverscale=r.experimentalZoomLevelsToOverscale,this.transformCameraUpdate=r.transformCameraUpdate,this.transformConstrain=r.transformConstrain,this.cancelPendingTileRequestsWhileZooming=!0===r.cancelPendingTileRequestsWhileZooming,void 0!==r.reduceMotion&&(tt.prefersReducedMotion=r.reduceMotion),this._imageQueueHandle=xt.addThrottleControl((()=>this.isMoving())),this._requestManager=new vt(r.transformRequest),"string"==typeof r.container){if(this._container=document.getElementById(r.container),!this._container)throw new Error(`Container '${r.container}' not found.`)}else{if(!(r.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=r.container}if(r.maxBounds&&this.setMaxBounds(r.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0)})),this.once("idle",(()=>{this._idleTriggered=!0})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let e=!1;const t=uv((e=>{this._trackResize&&!this._removed&&(this.resize(e),this.redraw())}),50);this._resizeObserver=new ResizeObserver((i=>{e?t(i):e=!0})),this._resizeObserver.observe(this._container)}this.handlers=new db(this,r),this._hash=r.hash&&new dv("string"==typeof r.hash&&r.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:r.center,elevation:r.elevation,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,roll:r.roll}),r.bounds&&(this.resize(),this.fitBounds(r.bounds,we({},r.fitBoundsOptions,{duration:0}))));const a="string"==typeof r.style||!("globe"===(null===(i=null===(t=r.style)||void 0===t?void 0:t.projection)||void 0===i?void 0:i.type));this.resize(null,a),this._localIdeographFontFamily=r.localIdeographFontFamily,this._validateStyle=r.validateStyle,r.style&&this.setStyle(r.style,{localIdeographFontFamily:r.localIdeographFontFamily}),r.attributionControl&&this.addControl(new mb("boolean"==typeof r.attributionControl?void 0:r.attributionControl)),r.maplibreLogo&&this.addControl(new _b,r.logoPosition),this.on("style.load",(()=>{if(a||this._resizeTransform(),this.transform.unmodified){const e=Te(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(e)}})),this.on("data",(e=>{this._update("style"===e.dataType),this.fire(new Tt(`${e.dataType}data`,e))})),this.on("dataloading",(e=>{this.fire(new Tt(`${e.dataType}dataloading`,e))})),this.on("dataabort",(e=>{this.fire(new Tt("sourcedataabort",e))}))}_getMapId(){return this._mapId}setGlobalStateProperty(e,t){return this.style.setGlobalStateProperty(e,t),this._update(!0)}getGlobalState(){return this.style.getGlobalState()}addControl(e,t){if(void 0===t&&(t=e.getDefaultPosition?e.getDefaultPosition():"top-right"),!e||!e.onAdd)return this.fire(new St(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const i=e.onAdd(this);this._controls.push(e);const r=this._controlPositions[t];return-1!==t.indexOf("bottom")?r.insertBefore(i,r.firstChild):r.appendChild(i),this}removeControl(e){if(!e||!e.onRemove)return this.fire(new St(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const t=this._controls.indexOf(e);return t>-1&&this._controls.splice(t,1),e.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}coveringTiles(e){return Fm(this.transform,e)}calculateCameraOptionsFromTo(e,t,i,r){return null==r&&this.terrain&&(r=this.terrain.getElevationForLngLat(i,this.transform)),super.calculateCameraOptionsFromTo(e,t,i,r)}resize(e,t=!0){if(null!==this._lostContextStyle.style)return this;this._resizeInternal(t);const i=!this._moving;return i&&(this.stop(),this.fire(new Tt("movestart",e)).fire(new Tt("move",e))),this.fire(new Tt("resize",e)),i&&this.fire(new Tt("moveend",e)),this}_resizeInternal(e=!0){const[t,i]=this._containerDimensions(),r=this._getClampedPixelRatio(t,i);if(this._resizeCanvas(t,i,r),this.painter.resize(t,i,r),this.painter.overLimit()){const e=this.painter.context.gl;this._maxCanvasSize=[e.drawingBufferWidth,e.drawingBufferHeight];const r=this._getClampedPixelRatio(t,i);this._resizeCanvas(t,i,r),this.painter.resize(t,i,r)}this._resizeTransform(e)}_resizeTransform(e=!0){var t;const[i,r]=this._containerDimensions();this.transform.resize(i,r,e),null===(t=this._requestedCameraState)||void 0===t||t.resize(i,r,e)}_getClampedPixelRatio(e,t){const{0:i,1:r}=this._maxCanvasSize,n=this.getPixelRatio(),s=e*n,a=t*n;return Math.min(s>i?i/s:1,a>r?r/a:1)*n}getPixelRatio(){var e;return null!==(e=this._overridePixelRatio)&&void 0!==e?e:devicePixelRatio}setPixelRatio(e){this._overridePixelRatio=e,this.resize()}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(e){return this.transform.setMaxBounds(Wd.convert(e)),this._update()}setMinZoom(e){if((e=null==e?-2:e)>=-2&&e<=this.transform.maxZoom){const t=this._getTransformForUpdate();return t.setMinZoom(e),this._applyUpdatedTransform(t),this._update(),this}throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(e){if((e=null==e?22:e)>=this.transform.minZoom){const t=this._getTransformForUpdate();return t.setMaxZoom(e),this._applyUpdatedTransform(t),this._update(),this}throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(e){if((e=null==e?0:e)<0)throw new Error("minPitch must be greater than or equal to 0");if(e>=0&&e<=this.transform.maxPitch)return this.transform.setMinPitch(e),this._update(),this.getPitch()<e&&this.setPitch(e),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(e){if((e=null==e?60:e)>180)throw new Error("maxPitch must be less than or equal to 180");if(e>=this.transform.minPitch)return this.transform.setMaxPitch(e),this._update(),this.getPitch()>e&&this.setPitch(e),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.setRenderWorldCopies(e),this._update()}setTransformConstrain(e){return this.transform.setConstrainOverride(e),this._update()}project(e){return this.transform.locationToScreenPoint(qd.convert(e),this.style&&this.terrain)}unproject(e){return this.transform.screenPointToLocation(s.convert(e),this.terrain)}isMoving(){var e;return this._moving||(null===(e=this.handlers)||void 0===e?void 0:e.isMoving())}isZooming(){var e;return this._zooming||(null===(e=this.handlers)||void 0===e?void 0:e.isZooming())}isRotating(){var e;return this._rotating||(null===(e=this.handlers)||void 0===e?void 0:e.isRotating())}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let r=!1;const n=n=>{const s=t.filter((e=>this.getLayer(e))),a=0!==s.length?this.queryRenderedFeatures(n.point,{layers:s}):[];a.length?r||(r=!0,i.call(this,new wv(e,this,n.originalEvent,{features:a}))):r=!1};return{layers:t,listener:i,delegates:{mousemove:n,mouseout:()=>{r=!1}}}}if("mouseleave"===e||"mouseout"===e){let r=!1;const n=n=>{const s=t.filter((e=>this.getLayer(e)));(0!==s.length?this.queryRenderedFeatures(n.point,{layers:s}):[]).length?r=!0:r&&(r=!1,i.call(this,new wv(e,this,n.originalEvent)))},s=t=>{r&&(r=!1,i.call(this,new wv(e,this,t.originalEvent)))};return{layers:t,listener:i,delegates:{mousemove:n,mouseout:s}}}{const r=e=>{const r=t.filter((e=>this.getLayer(e))),n=0!==r.length?this.queryRenderedFeatures(e.point,{layers:r}):[];n.length&&(e.features=n,i.call(this,e),delete e.features)};return{layers:t,listener:i,delegates:{[e]:r}}}}_saveDelegatedListener(e,t){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(t)}_removeDelegatedListener(e,t,i){if(!this._delegatedListeners||!this._delegatedListeners[e])return;const r=this._delegatedListeners[e];for(let e=0;e<r.length;e++){const n=r[e];if(n.listener===i&&n.layers.length===t.length&&n.layers.every((e=>t.includes(e)))){for(const e in n.delegates)this.off(e,n.delegates[e]);return void r.splice(e,1)}}}on(e,t,i){if(void 0===i)return super.on(e,t);const r="string"==typeof t?[t]:t,n=this._createDelegatedListener(e,r,i);this._saveDelegatedListener(e,n);for(const e in n.delegates)this.on(e,n.delegates[e]);return{unsubscribe:()=>{this._removeDelegatedListener(e,r,i)}}}once(e,t,i){if(void 0===i)return super.once(e,t);const r="string"==typeof t?[t]:t,n=this._createDelegatedListener(e,r,i);for(const t in n.delegates){const s=n.delegates[t];n.delegates[t]=(...t)=>{this._removeDelegatedListener(e,r,i),s(...t)}}this._saveDelegatedListener(e,n);for(const e in n.delegates)this.once(e,n.delegates[e]);return this}off(e,t,i){return void 0===i?super.off(e,t):(this._removeDelegatedListener(e,"string"==typeof t?[t]:t,i),this)}queryRenderedFeatures(e,t){if(!this.style)return[];let i;const r=e instanceof s||Array.isArray(e),n=r?e:[[0,0],[this.transform.width,this.transform.height]];if(t=t||(r?{}:e)||{},n instanceof s||"number"==typeof n[0])i=[s.convert(n)];else{const e=s.convert(n[0]),t=s.convert(n[1]);i=[e,new s(t.x,e.y),t,new s(e.x,t.y),e]}return this.style.queryRenderedFeatures(i,t,this.transform)}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}setStyle(e,t){return!1!==(t=we({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},t)).diff&&t.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&e?(this._diffStyle(e,t),this):(this._localIdeographFontFamily=t.localIdeographFontFamily,this._updateStyle(e,t))}setTransformRequest(e){return this._requestManager.setTransformRequest(e),this}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){var i,r;if(t.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(e,t)));const n=this.style&&t.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!e)),e?(this.style=new Qg(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e,t,n):this.style.loadJSON(e,t,n),this):(null===(r=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===r||r.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new Qg(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty())}_diffStyle(e,t){if("string"==typeof e){const i=this._requestManager.transformRequest(e,"Style");ut(i,new AbortController).then((e=>{this._updateDiff(e.data,t)})).catch((e=>{e&&this.fire(new St(e))}))}else"object"==typeof e&&this._updateDiff(e,t)}_updateDiff(e,t){try{this.style.setState(e,t)&&this._update(!0)}catch(i){Re(`Unable to perform style diff: ${i.message||i.error||i}.  Rebuilding the style from scratch.`),this._updateStyle(e,t)}}getStyle(){if(this.style)return this.style.serialize()}_getStyleAndImages(){return this.style?{style:this.style.serialize(),images:this.style.imageManager.cloneImages()}:{style:null,images:{}}}isStyleLoaded(){return this.style?this.style.loaded():Re("There is no style added to the map.")}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(e){const t=this.style&&this.style.tileManagers[e];if(void 0!==t)return t.loaded();this.fire(new St(new Error(`There is no tile manager with ID '${e}'`)))}setTerrain(e){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),e){const t=this.style.tileManagers[e.source];if(!t)throw new Error(`cannot load terrain, because there exists no source with ID: ${e.source}`);null===this.terrain&&t.reload();for(const t in this.style._layers){const i=this.style._layers[t];"hillshade"===i.type&&i.source===e.source&&Re("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality."),"color-relief"===i.type&&i.source===e.source&&Re("You are using the same source for a color-relief layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.")}this.terrain=new Mb(this.painter,t,e),this.painter.renderToTexture=new Ab(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=t=>{var i;"style"===t.dataType?this.terrain.tileManager.freeRtt():"source"===t.dataType&&t.tile&&(t.sourceId!==e.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),"image"===(null===(i=t.source)||void 0===i?void 0:i.type)?this.terrain.tileManager.freeRtt():this.terrain.tileManager.freeRtt(t.tile.tileID))},this.style.on("data",this._terrainDataCallback)}else this.terrain&&this.terrain.tileManager.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new Tt("terrain",{terrain:e})),this}getTerrain(){var e,t;return null!==(t=null===(e=this.terrain)||void 0===e?void 0:e.options)&&void 0!==t?t:null}areTilesLoaded(){const e=this.style&&this.style.tileManagers;for(const t of Object.values(e))if(!t.areTilesLoaded())return!1;return!0}removeSource(e){return this.style.removeSource(e),this._update(!0)}getSource(e){return this.style.getSource(e)}setSourceTileLodParams(e,t,i){if(i){const r=this.getSource(i);if(!r)throw new Error(`There is no source with ID "${i}", cannot set LOD parameters`);r.calculateTileZoom=Rm(Math.max(1,e),Math.max(1,t))}else for(const i in this.style.tileManagers)this.style.tileManagers[i].getSource().calculateTileZoom=Rm(Math.max(1,e),Math.max(1,t));return this._update(!0),this}refreshTiles(e,t){const i=this.style.tileManagers[e];if(!i)throw new Error(`There is no tile manager with ID "${e}", cannot refresh tile`);void 0===t?i.reload(!0):i.refreshTiles(t.map((e=>new lp(e.z,e.x,e.y))))}addImage(e,t,i={}){const{pixelRatio:r=1,sdf:n=!1,stretchX:s,stretchY:a,content:o,textFitWidth:l,textFitHeight:c}=i;if(this._lazyInitEmptyStyle(),!(t instanceof HTMLImageElement||Be(t))){if(void 0===t.width||void 0===t.height)return this.fire(new St(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:i,height:h,data:u}=t,d=t;return this.style.addImage(e,{data:new kc({width:i,height:h},new Uint8Array(u)),pixelRatio:r,stretchX:s,stretchY:a,content:o,textFitWidth:l,textFitHeight:c,sdf:n,version:0,userImage:d}),d.onAdd&&d.onAdd(this,e),this}}{const{width:i,height:h,data:u}=tt.getImageData(t);this.style.addImage(e,{data:new kc({width:i,height:h},u),pixelRatio:r,stretchX:s,stretchY:a,content:o,textFitWidth:l,textFitHeight:c,sdf:n,version:0})}}updateImage(e,t){const i=this.style.getImage(e);if(!i)return this.fire(new St(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=t instanceof HTMLImageElement||Be(t)?tt.getImageData(t):t,{width:n,height:s,data:a}=r;if(void 0===n||void 0===s)return this.fire(new St(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(n!==i.data.width||s!==i.data.height)return this.fire(new St(new Error("The width and height of the updated image must be that same as the previous version of the image")));const o=!(t instanceof HTMLImageElement||Be(t));return i.data.replace(a,o),this.style.updateImage(e,i),this}getImage(e){return this.style.getImage(e)}hasImage(e){return e?!!this.style.getImage(e):(this.fire(new St(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e)}loadImage(e){return xt.getImage(this._requestManager.transformRequest(e,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,r={}){return this.style.setPaintProperty(e,t,i,r),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,r={}){return this.style.setLayoutProperty(e,t,i,r),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setGlyphs(e,t={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(e,t),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(e,t,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(e,t,i,(e=>{e||this._update(!0)})),this}removeSprite(e){return this._lazyInitEmptyStyle(),this.style.removeSprite(e),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSprite(e,t,(e=>{e||this._update(!0)})),this}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setSky(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSky(e,t),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let e=0,t=0;return this._container&&(e=this._container.clientWidth||400,t=this._container.clientHeight||300),[e,t]}_setupContainer(){const e=this._container;e.classList.add("maplibregl-map");const t=this._canvasContainer=nt.create("div","maplibregl-canvas-container",e);this._interactive&&t.classList.add("maplibregl-interactive"),this._canvas=nt.create("canvas","maplibregl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),r=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],r);const n=this._controlContainer=nt.create("div","maplibregl-control-container",e),s=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((e=>{s[e]=nt.create("div",`maplibregl-ctrl-${e} `,n)})),this._container.addEventListener("scroll",this._onMapScroll,!1)}_resizeCanvas(e,t,i){this._canvas.width=Math.floor(i*e),this._canvas.height=Math.floor(i*t),this._canvas.style.width=`${e}px`,this._canvas.style.height=`${t}px`}_setupPainter(){const e=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let t=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{t={requestedAttributes:e},i&&(t.statusMessage=i.statusMessage,t.type=i.type)}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,e):this._canvas.getContext("webgl2",e)||this._canvas.getContext("webgl",e),!i){const e="Failed to initialize WebGL";throw t?(t.message=e,new Error(JSON.stringify(t))):new Error(e)}this.painter=new hv(i,this.transform),pt.testSupport(i)}migrateProjection(e,t){super.migrateProjection(e,t),this.painter.transform=e,this.fire(new Tt("projectiontransition",{newProjection:this.style.projection.name}))}loaded(){return!this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e)}_render(e){var t,i,r,n,s;const a=this._idleTriggered?this._fadeDuration:0,o=(null===(t=this.style.projection)||void 0===t?void 0:t.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(e),this._removed)return;let l=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const e=this.transform.zoom,t=rt();this.style.zoomHistory.update(e,t);const i=new Da(e,{now:t,fadeDuration:a,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),r=i.crossFadingFactor();1===r&&r===this._crossFadingFactor||(l=!0,this._crossFadingFactor=r),this.style.update(i)}const c=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0!==o;null===(r=this.style.projection)||void 0===r||r.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(n=this.style.projection)||void 0===n?void 0:n.transitionState,null===(s=this.style.projection)||void 0===s?void 0:s.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||c)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.tileManager.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,a,this._crossSourceCollisions,c),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:a,showPadding:this.showPadding}),this.fire(new Tt("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,Sb.mark(yb.load),this.fire(new Tt("load"))),this.style&&(this.style.hasTransitions()||l)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const h=this._sourcesDirty||this._styleDirty||this._placementDirty;return h||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new Tt("idle")),!this._loaded||this._fullyLoaded||h||(this._fullyLoaded=!0,Sb.mark(yb.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var e;this._hash&&this._hash.remove();for(const e of this._controls)e.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),xt.removeThrottleControl(this._imageQueueHandle),null===(e=this._resizeObserver)||void 0===e||e.disconnect();const t=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==t?void 0:t.loseContext)&&t.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),nt.remove(this._canvasContainer),nt.remove(this._controlContainer),this._container.removeEventListener("scroll",this._onMapScroll,!1),this._container.classList.remove("maplibregl-map"),Sb.clearMetrics(),this._removed=!0,this.fire(new Tt("remove"))}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,tt.frame(this._frameRequest,(e=>{Sb.frame(e),this._frameRequest=null;try{this._render(e)}catch(e){if(!Ke(e)&&!function(e){return e.message===Sx}(e))throw e}}),(()=>{})))}get showTileBoundaries(){return!!this._showTileBoundaries}set showTileBoundaries(e){this._showTileBoundaries!==e&&(this._showTileBoundaries=e,this._update())}get showPadding(){return!!this._showPadding}set showPadding(e){this._showPadding!==e&&(this._showPadding=e,this._update())}get showCollisionBoxes(){return!!this._showCollisionBoxes}set showCollisionBoxes(e){this._showCollisionBoxes!==e&&(this._showCollisionBoxes=e,e?this.style._generateCollisionBoxes():this._update())}get showOverdrawInspector(){return!!this._showOverdrawInspector}set showOverdrawInspector(e){this._showOverdrawInspector!==e&&(this._showOverdrawInspector=e,this._update())}get repaint(){return!!this._repaint}set repaint(e){this._repaint!==e&&(this._repaint=e,this.triggerRepaint())}get vertices(){return!!this._vertices}set vertices(e){this._vertices=e,this._update()}get version(){return Db}getCameraTargetElevation(){return this.transform.elevation}getProjection(){return this.style.getProjection()}setProjection(e){return this._lazyInitEmptyStyle(),this.style.setProjection(e),this._update(!0)}},e.MapMouseEvent=wv,e.MapTouchEvent=Tv,e.MapWheelEvent=Sv,e.Marker=jb,e.MercatorCoordinate=ip,e.NavigationControl=class{constructor(e){this._updateZoomButtons=()=>{const e=this._map.getZoom(),t=e===this._map.getMaxZoom(),i=e===this._map.getMinZoom();this._zoomInButton.disabled=t,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",t.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString())},this._rotateCompassArrow=()=>{this._compassIcon.style.transform=this.options.visualizePitch&&this.options.visualizeRoll?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateZ(${-this._map.transform.roll}deg) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizeRoll?`rotate(${-this._map.transform.bearing-this._map.transform.roll}deg)`:`rotate(${-this._map.transform.bearing}deg)`},this._setButtonTitle=(e,t)=>{const i=this._map._getUIString(`NavigationControl.${t}`);e.title=i,e.setAttribute("aria-label",i)},this.options=we({},kb,e),this._container=nt.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(e=>this._map.zoomIn({},{originalEvent:e}))),nt.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(e=>this._map.zoomOut({},{originalEvent:e}))),nt.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(e=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:e}):this._map.resetNorth({},{originalEvent:e})})),this._compassIcon=nt.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"))}onAdd(e){return this._map=e,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.on("roll",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new Lb(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){nt.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.off("roll",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map}_createButton(e,t){const i=nt.create("button",e,this._container);return i.type="button",i.addEventListener("click",t),i}},e.Point=s,e.Popup=class extends Pt{constructor(e){super(),this._updateOpacity=()=>{void 0!==this.options.locationOccludedOpacity&&(this._container.style.opacity=this._map.transform.isLocationOccluded(this.getLngLat())?`${this.options.locationOccludedOpacity}`:"")},this.remove=()=>(this._content&&nt.remove(this._content),this._container&&(nt.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new Tt("close"))),this),this._onMouseUp=e=>{this._update(e.point)},this._onMouseMove=e=>{this._update(e.point)},this._onDrag=e=>{this._update(e.point)},this._update=e=>{if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=nt.create("div","maplibregl-popup",this._map.getContainer()),this._tip=nt.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const e of this.options.className.split(" "))this._container.classList.add(e);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer")}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=Bb(this._lngLat,this._flatPos,this._map.transform,this._trackPointer),this._trackPointer&&!e)return;const t=this._flatPos=this._pos=this._trackPointer&&e?e:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&e?e:this._map.transform.locationToScreenPoint(this._lngLat));let i=this.options.anchor;const r=Xb(this.options.offset);if(!i){const e=this._container.offsetWidth,n=this._container.offsetHeight,s=function(e){var t,i,r,n;return e?{top:null!==(t=e.top)&&void 0!==t?t:0,right:null!==(i=e.right)&&void 0!==i?i:0,bottom:null!==(r=e.bottom)&&void 0!==r?r:0,left:null!==(n=e.left)&&void 0!==n?n:0}:{top:0,right:0,bottom:0,left:0}}(this.options.padding);let a;a=t.y+r.bottom.y<n+s.top?["top"]:t.y>this._map.transform.height-n-s.bottom?["bottom"]:[],t.x<e/2+s.left?a.push("left"):t.x>this._map.transform.width-e/2-s.right&&a.push("right"),i=0===a.length?"bottom":a.join("-")}let n=t.add(r[i]);this.options.subpixelPositioning||(n=n.round()),nt.setTransform(this._container,`${Ob[i]} translate(${n.x}px,${n.y}px)`),Vb(this._container,i,"popup"),this._updateOpacity()},this._onClose=()=>{this.remove()},this.options=we(Object.create(Wb),e)}addTo(e){return this._map&&this.remove(),this._map=e,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new Tt("open")),this}isOpen(){return!!this._map}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=qd.convert(e),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(e){return this.setDOMContent(document.createTextNode(e))}setHTML(e){const t=document.createDocumentFragment(),i=document.createElement("body");let r;for(i.innerHTML=e;r=i.firstChild,r;)t.appendChild(r);return this.setDOMContent(t)}getMaxWidth(){var e;return null===(e=this._container)||void 0===e?void 0:e.style.maxWidth}setMaxWidth(e){return this.options.maxWidth=e,this._update(),this}setDOMContent(e){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=nt.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(e),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(e){return this._container&&this._container.classList.add(e),this}removeClassName(e){return this._container&&this._container.classList.remove(e),this}setOffset(e){return this.options.offset=e,this._update(),this}toggleClassName(e){if(this._container)return this._container.classList.toggle(e)}setSubpixelPositioning(e){this.options.subpixelPositioning=e}setPadding(e){this.options.padding=e,this._update()}_createCloseButton(){this.options.closeButton&&(this._closeButton=nt.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose))}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const e=this._container.querySelector(Hb);e&&e.focus()}},e.RasterDEMTileSource=pp,e.RasterTileSource=sp,e.ScaleControl=class{constructor(e){this._onMove=()=>{$b(this._map,this._container,this.options)},this.setUnit=e=>{this.options.unit=e,$b(this._map,this._container,this.options)},this.options=Object.assign(Object.assign({},Zb),e)}getDefaultPosition(){return"bottom-left"}onAdd(e){return this._map=e,this._container=nt.create("div","maplibregl-ctrl maplibregl-ctrl-scale",e.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){nt.remove(this._container),this._map.off("move",this._onMove),this._map=void 0}},e.ScrollZoomHandler=tb,e.Style=Qg,e.TerrainControl=class{constructor(e){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon()},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"))},this.options=e}onAdd(e){return this._map=e,this._container=nt.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=nt.create("button","maplibregl-ctrl-terrain",this._container),nt.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){nt.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0}},e.TwoFingersTouchPitchHandler=Xv,e.TwoFingersTouchRotateHandler=Wv,e.TwoFingersTouchZoomHandler=$v,e.TwoFingersTouchZoomRotateHandler=ob,e.VectorTileSource=np,e.VideoSource=wp,e.addProtocol=function(e,t){st.REGISTERED_PROTOCOLS[e]=t},e.addSourceType=(e,t)=>n(void 0,void 0,void 0,(function*(){if(Pp(e))throw new Error(`A source type called "${e}" already exists.`);((e,t)=>{Sp[e]=t})(e,t)})),e.clearPrewarmedResources=function(){const e=Ld;e&&(e.isPreloaded()&&1===e.numActive()?(e.release(Dd),Ld=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"))},e.config=st,e.createTileMesh=Ig,e.getMaxParallelImageRequests=function(){return st.MAX_PARALLEL_IMAGE_REQUESTS},e.getRTLTextPluginStatus=function(){return ym().getRTLTextPluginStatus()},e.getVersion=function(){return Yb},e.getWorkerCount=function(){return Rd.workerCount},e.getWorkerUrl=function(){return st.WORKER_URL},e.importScriptInWorkers=function(e){return Vd().broadcast("IS",e)},e.isTimeFrozen=function(){return it.isFrozen()},e.now=rt,e.prewarm=function(){Bd().acquire(Dd)},e.removeProtocol=function(e){delete st.REGISTERED_PROTOCOLS[e]},e.restoreNow=function(){it.restoreNow()},e.setMaxParallelImageRequests=function(e){st.MAX_PARALLEL_IMAGE_REQUESTS=e},e.setNow=function(e){it.setNow(e)},e.setRTLTextPlugin=function(e,t){return ym().setRTLTextPlugin(e,t)},e.setWorkerCount=function(e){Rd.workerCount=e},e.setWorkerUrl=function(e){st.WORKER_URL=e}}));
//# sourceMappingURL=maplibre-gl-csp.js.map
