import { XdrEncoder } from '../../xdr/XdrEncoder';
import { Nfsv3Proc } from './constants';
import type * as msg from './messages';
import type { IWriter, IWriterGrowable } from '@jsonjoy.com/buffers';
export declare class Nfsv3Encoder<W extends IWriter & IWriterGrowable = IWriter & IWriterGrowable> {
    readonly writer: W;
    protected readonly xdr: XdrEncoder;
    constructor(writer?: W);
    encodeMessage(message: msg.Nfsv3Message, proc: Nfsv3Proc, isRequest: boolean): Uint8Array;
    writeMessage(message: msg.Nfsv3Message, proc: Nfsv3Proc, isRequest: boolean): void;
    private writeRequest;
    private writeResponse;
    private writeFh;
    private writeFilename;
    private writeTime;
    private writeSpecData;
    private writeFattr;
    private writePostOpAttr;
    private writeWccAttr;
    private writePreOpAttr;
    private writeWccData;
    private writePostOpFh;
    private writeSetMode;
    private writeSetUid;
    private writeSetGid;
    private writeSetSize;
    private writeSetAtime;
    private writeSetMtime;
    private writeSattr;
    private writeSattrGuard;
    private writeDirOpArgs;
    private writeCreateHow;
    private writeMknodData;
    private writeEntry;
    private writeEntryPlus;
    private writeDirList;
    private writeDirListPlus;
    private writeGetattrRequest;
    private writeGetattrResponse;
    private writeSetattrRequest;
    private writeSetattrResponse;
    private writeLookupRequest;
    private writeLookupResponse;
    private writeAccessRequest;
    private writeAccessResponse;
    private writeReadlinkRequest;
    private writeReadlinkResponse;
    private writeReadRequest;
    private writeReadResponse;
    private writeWriteRequest;
    private writeWriteResponse;
    private writeCreateRequest;
    private writeCreateResponse;
    private writeMkdirRequest;
    private writeMkdirResponse;
    private writeSymlinkRequest;
    private writeSymlinkResponse;
    private writeMknodRequest;
    private writeMknodResponse;
    private writeRemoveRequest;
    private writeRemoveResponse;
    private writeRmdirRequest;
    private writeRmdirResponse;
    private writeRenameRequest;
    private writeRenameResponse;
    private writeLinkRequest;
    private writeLinkResponse;
    private writeReaddirRequest;
    private writeReaddirResponse;
    private writeReaddirplusRequest;
    private writeReaddirplusResponse;
    private writeFsstatRequest;
    private writeFsstatResponse;
    private writeFsinfoRequest;
    private writeFsinfoResponse;
    private writePathconfRequest;
    private writePathconfResponse;
    private writeCommitRequest;
    private writeCommitResponse;
}
