// Generated by dts-bundle-generator v8.0.1

import Point from '@mapbox/point-geometry';
import TinySDF from '@mapbox/tiny-sdf';
import { VectorTileFeature, VectorTileLayer } from '@mapbox/vector-tile';
import { Color, CompositeExpression, Feature, FeatureFilter, FeatureState, FilterSpecification, Formatted, FormattedSection, GeoJSONSourceSpecification, GlobalProperties, ICanonicalTileID, IMercatorCoordinate, ImageSourceSpecification, InterpolationType, LayerSpecification, LightSpecification, Padding, PromoteIdSpecification, PropertyValueSpecification, RasterDEMSourceSpecification, RasterSourceSpecification, ResolvedImage, SourceExpression, SourceSpecification, SpriteSpecification, StylePropertyExpression, StylePropertySpecification, StyleSpecification, TerrainSpecification, TransitionSpecification, VectorSourceSpecification, VideoSourceSpecification } from '@maplibre/maplibre-gl-style-spec';
import { mat2, mat4, vec4 } from 'gl-matrix';
import KDBush from 'kdbush';
import { PotpackBox } from 'potpack';

export type Cancelable = {
	cancel: () => void;
};
export type Callback<T> = (error?: Error | null, result?: T | null) => void;
/**
 * A `RequestParameters` object to be returned from Map.options.transformRequest callbacks.
 * @typedef {Object} RequestParameters
 * @property {string} url The URL to be requested.
 * @property {Object} headers The headers to be sent with the request.
 * @property {string} method Request method `'GET' | 'POST' | 'PUT'`.
 * @property {string} body Request body.
 * @property {string} type Response body type to be returned `'string' | 'json' | 'arrayBuffer'`.
 * @property {string} credentials `'same-origin'|'include'` Use 'include' to send cookies with cross-origin requests.
 * @property {boolean} collectResourceTiming If true, Resource Timing API information will be collected for these transformed requests and returned in a resourceTiming property of relevant data events.
 * @example
 * // use transformRequest to modify requests that begin with `http://myHost`
 * transformRequest: function(url, resourceType) {
 *  if (resourceType === 'Source' && url.indexOf('http://myHost') > -1) {
 *    return {
 *      url: url.replace('http', 'https'),
 *      headers: { 'my-custom-header': true },
 *      credentials: 'include'  // Include cookies for cross-origin requests
 *    }
 *   }
 *  }
 *
 */
export type RequestParameters = {
	url: string;
	headers?: any;
	method?: "GET" | "POST" | "PUT";
	body?: string;
	type?: "string" | "json" | "arrayBuffer" | "image";
	credentials?: "same-origin" | "include";
	collectResourceTiming?: boolean;
};
export type ResponseCallback<T> = (error?: Error | null, data?: T | null, cacheControl?: string | null, expires?: string | null) => void;
export declare class AJAXError extends Error {
	/**
	 * The response's HTTP status code.
	 */
	status: number;
	/**
	 * The response's HTTP status text.
	 */
	statusText: string;
	/**
	 * The request's URL.
	 */
	url: string;
	/**
	 * The response's body.
	 */
	body: Blob;
	constructor(status: number, statusText: string, url: string, body: Blob);
}
export type ExpiryData = {
	cacheControl?: string | null;
	expires?: Date | string | null;
};
export type GetImageCallback = (error?: Error | null, image?: HTMLImageElement | ImageBitmap | null, expiry?: ExpiryData | null) => void;
/**
 * A type of MapLibre resource.
 */
export declare const enum ResourceType {
	Glyphs = "Glyphs",
	Image = "Image",
	Source = "Source",
	SpriteImage = "SpriteImage",
	SpriteJSON = "SpriteJSON",
	Style = "Style",
	Tile = "Tile",
	Unknown = "Unknown"
}
export type RequestTransformFunction = (url: string, resourceType?: ResourceType) => RequestParameters | undefined;
export declare class RequestManager {
	_transformRequestFn: RequestTransformFunction;
	constructor(transformRequestFn?: RequestTransformFunction);
	transformRequest(url: string, type: ResourceType): RequestParameters;
	normalizeSpriteURL(url: string, format: string, extension: string): string;
	setTransformRequest(transformRequest: RequestTransformFunction): void;
}
export type Listener = (a: any) => any;
export type Listeners = {
	[_: string]: Array<Listener>;
};
export declare class Event {
	readonly type: string;
	constructor(type: string, data?: any);
}
export declare class Evented {
	_listeners: Listeners;
	_oneTimeListeners: Listeners;
	_eventedParent: Evented;
	_eventedParentData: any | (() => any);
	/**
	 * Adds a listener to a specified event type.
	 *
	 * @param {string} type The event type to add a listen for.
	 * @param {Function} listener The function to be called when the event is fired.
	 * The listener function is called with the data object passed to `fire`,
	 * extended with `target` and `type` properties.
	 * @returns {Object} `this`
	 */
	on(type: string, listener: Listener): this;
	/**
	 * Removes a previously registered event listener.
	 *
	 * @param {string} type The event type to remove listeners for.
	 * @param {Function} listener The listener function to remove.
	 * @returns {Object} `this`
	 */
	off(type: string, listener: Listener): this;
	/**
	 * Adds a listener that will be called only once to a specified event type.
	 *
	 * The listener will be called first time the event fires after the listener is registered.
	 *
	 * @param {string} type The event type to listen for.
	 * @param {Function} listener The function to be called when the event is fired the first time.
	 * @returns {Object} `this` or a promise if a listener is not provided
	 */
	once(type: string, listener?: Listener): this | Promise<any>;
	fire(event: Event | string, properties?: any): this;
	/**
	 * Returns a true if this instance of Evented or any forwardeed instances of Evented have a listener for the specified type.
	 *
	 * @param {string} type The event type
	 * @returns {boolean} `true` if there is at least one registered listener for specified event type, `false` otherwise
	 * @private
	 */
	listens(type: string): any;
	/**
	 * Bubble all events fired by this instance of Evented to this parent instance of Evented.
	 *
	 * @private
	 * @returns {Object} `this`
	 * @private
	 */
	setEventedParent(parent?: Evented | null, data?: any | (() => any)): this;
}
export declare class ZoomHistory {
	lastZoom: number;
	lastFloorZoom: number;
	lastIntegerZoom: number;
	lastIntegerZoomTime: number;
	first: boolean;
	constructor();
	update(z: number, now: number): boolean;
}
export type CrossfadeParameters = {
	fromScale: number;
	toScale: number;
	t: number;
};
export declare class EvaluationParameters {
	zoom: number;
	now: number;
	fadeDuration: number;
	zoomHistory: ZoomHistory;
	transition: TransitionSpecification;
	constructor(zoom: number, options?: any);
	isSupportedScript(str: string): boolean;
	crossFadingFactor(): number;
	getCrossfadeParameters(): CrossfadeParameters;
}
export declare class LngLat {
	lng: number;
	lat: number;
	constructor(lng: number, lat: number);
	/**
	 * Returns a new `LngLat` object whose longitude is wrapped to the range (-180, 180).
	 *
	 * @returns {LngLat} The wrapped `LngLat` object.
	 * @example
	 * var ll = new maplibregl.LngLat(286.0251, 40.7736);
	 * var wrapped = ll.wrap();
	 * wrapped.lng; // = -73.9749
	 */
	wrap(): LngLat;
	/**
	 * Returns the coordinates represented as an array of two numbers.
	 *
	 * @returns {[number,number]} The coordinates represented as an array of longitude and latitude.
	 * @example
	 * var ll = new maplibregl.LngLat(-73.9749, 40.7736);
	 * ll.toArray(); // = [-73.9749, 40.7736]
	 */
	toArray(): [
		number,
		number
	];
	/**
	 * Returns the coordinates represent as a string.
	 *
	 * @returns {string} The coordinates represented as a string of the format `'LngLat(lng, lat)'`.
	 * @example
	 * var ll = new maplibregl.LngLat(-73.9749, 40.7736);
	 * ll.toString(); // = "LngLat(-73.9749, 40.7736)"
	 */
	toString(): string;
	/**
	 * Returns the approximate distance between a pair of coordinates in meters
	 * Uses the Haversine Formula (from R.W. Sinnott, "Virtues of the Haversine", Sky and Telescope, vol. 68, no. 2, 1984, p. 159)
	 *
	 * @param {LngLat} lngLat coordinates to compute the distance to
	 * @returns {number} Distance in meters between the two coordinates.
	 * @example
	 * var new_york = new maplibregl.LngLat(-74.0060, 40.7128);
	 * var los_angeles = new maplibregl.LngLat(-118.2437, 34.0522);
	 * new_york.distanceTo(los_angeles); // = 3935751.690893987, "true distance" using a non-spherical approximation is ~3966km
	 */
	distanceTo(lngLat: LngLat): number;
	/**
	 * Converts an array of two numbers or an object with `lng` and `lat` or `lon` and `lat` properties
	 * to a `LngLat` object.
	 *
	 * If a `LngLat` object is passed in, the function returns it unchanged.
	 *
	 * @param {LngLatLike} input An array of two numbers or object to convert, or a `LngLat` object to return.
	 * @returns {LngLat} A new `LngLat` object, if a conversion occurred, or the original `LngLat` object.
	 * @example
	 * var arr = [-73.9749, 40.7736];
	 * var ll = maplibregl.LngLat.convert(arr);
	 * ll;   // = LngLat {lng: -73.9749, lat: 40.7736}
	 */
	static convert(input: LngLatLike): LngLat;
}
/**
 * A {@link LngLat} object, an array of two numbers representing longitude and latitude,
 * or an object with `lng` and `lat` or `lon` and `lat` properties.
 *
 * @typedef {LngLat | {lng: number, lat: number} | {lon: number, lat: number} | [number, number]} LngLatLike
 * @example
 * var v1 = new maplibregl.LngLat(-122.420679, 37.772537);
 * var v2 = [-122.420679, 37.772537];
 * var v3 = {lon: -122.420679, lat: 37.772537};
 */
export type LngLatLike = LngLat | {
	lng: number;
	lat: number;
} | {
	lon: number;
	lat: number;
} | [
	number,
	number
];
export declare class MercatorCoordinate implements IMercatorCoordinate {
	x: number;
	y: number;
	z: number;
	constructor(x: number, y: number, z?: number);
	/**
	 * Project a `LngLat` to a `MercatorCoordinate`.
	 *
	 * @param {LngLatLike} lngLatLike The location to project.
	 * @param {number} altitude The altitude in meters of the position.
	 * @returns {MercatorCoordinate} The projected mercator coordinate.
	 * @example
	 * var coord = maplibregl.MercatorCoordinate.fromLngLat({ lng: 0, lat: 0}, 0);
	 * coord; // MercatorCoordinate(0.5, 0.5, 0)
	 */
	static fromLngLat(lngLatLike: LngLatLike, altitude?: number): MercatorCoordinate;
	/**
	 * Returns the `LngLat` for the coordinate.
	 *
	 * @returns {LngLat} The `LngLat` object.
	 * @example
	 * var coord = new maplibregl.MercatorCoordinate(0.5, 0.5, 0);
	 * var lngLat = coord.toLngLat(); // LngLat(0, 0)
	 */
	toLngLat(): LngLat;
	/**
	 * Returns the altitude in meters of the coordinate.
	 *
	 * @returns {number} The altitude in meters.
	 * @example
	 * var coord = new maplibregl.MercatorCoordinate(0, 0, 0.02);
	 * coord.toAltitude(); // 6914.281956295339
	 */
	toAltitude(): number;
	/**
	 * Returns the distance of 1 meter in `MercatorCoordinate` units at this latitude.
	 *
	 * For coordinates in real world units using meters, this naturally provides the scale
	 * to transform into `MercatorCoordinate`s.
	 *
	 * @returns {number} Distance of 1 meter in `MercatorCoordinate` units.
	 */
	meterInMercatorCoordinateUnits(): number;
}
export declare class CanonicalTileID implements ICanonicalTileID {
	z: number;
	x: number;
	y: number;
	key: string;
	constructor(z: number, x: number, y: number);
	equals(id: ICanonicalTileID): boolean;
	url(urls: Array<string>, pixelRatio: number, scheme?: string | null): string;
	isChildOf(parent: ICanonicalTileID): boolean;
	getTilePoint(coord: IMercatorCoordinate): Point;
	toString(): string;
}
export declare class UnwrappedTileID {
	wrap: number;
	canonical: CanonicalTileID;
	key: string;
	constructor(wrap: number, canonical: CanonicalTileID);
}
export declare class OverscaledTileID {
	overscaledZ: number;
	wrap: number;
	canonical: CanonicalTileID;
	key: string;
	posMatrix: mat4;
	constructor(overscaledZ: number, wrap: number, z: number, x: number, y: number);
	clone(): OverscaledTileID;
	equals(id: OverscaledTileID): boolean;
	scaledTo(targetZ: number): OverscaledTileID;
	calculateScaledKey(targetZ: number, withWrap: boolean): string;
	isChildOf(parent: OverscaledTileID): boolean;
	children(sourceMaxZoom: number): OverscaledTileID[];
	isLessThan(rhs: OverscaledTileID): boolean;
	wrapped(): OverscaledTileID;
	unwrapTo(wrap: number): OverscaledTileID;
	overscaleFactor(): number;
	toUnwrapped(): UnwrappedTileID;
	toString(): string;
	getTilePoint(coord: MercatorCoordinate): Point;
}
export type TimePoint = number;
export type CrossFaded<T> = {
	to: T;
	from: T;
};
/**
 * Implements a number of classes that define state and behavior for paint and layout properties, most
 * importantly their respective evaluation chains:
 *
 *       Transitionable paint property value
 *     → Transitioning paint property value
 *     → Possibly evaluated paint property value
 *     → Fully evaluated paint property value
 *
 *       Layout property value
 *     → Possibly evaluated layout property value
 *     → Fully evaluated layout property value
 *
 * @module
 * @private
 */
/**
 *  Implementations of the `Property` interface:
 *
 *  * Hold metadata about a property that's independent of any specific value: stuff like the type of the value,
 *    the default value, etc. This comes from the style specification JSON.
 *  * Define behavior that needs to be polymorphic across different properties: "possibly evaluating"
 *    an input value (see below), and interpolating between two possibly-evaluted values.
 *
 *  The type `T` is the fully-evaluated value type (e.g. `number`, `string`, `Color`).
 *  The type `R` is the intermediate "possibly evaluated" value type. See below.
 *
 *  There are two main implementations of the interface -- one for properties that allow data-driven values,
 *  and one for properties that don't. There are a few "special case" implementations as well: one for properties
 *  which cross-fade between two values rather than interpolating, one for `heatmap-color` and `line-gradient`,
 *  and one for `light-position`.
 *
 * @private
 */
export interface Property<T, R> {
	specification: StylePropertySpecification;
	possiblyEvaluate(value: PropertyValue<T, R>, parameters: EvaluationParameters, canonical?: CanonicalTileID, availableImages?: Array<string>): R;
	interpolate(a: R, b: R, t: number): R;
}
export declare class PropertyValue<T, R> {
	property: Property<T, R>;
	value: PropertyValueSpecification<T> | void;
	expression: StylePropertyExpression;
	constructor(property: Property<T, R>, value: PropertyValueSpecification<T> | void);
	isDataDriven(): boolean;
	possiblyEvaluate(parameters: EvaluationParameters, canonical?: CanonicalTileID, availableImages?: Array<string>): R;
}
export type TransitionParameters = {
	now: TimePoint;
	transition: TransitionSpecification;
};
export declare class TransitionablePropertyValue<T, R> {
	property: Property<T, R>;
	value: PropertyValue<T, R>;
	transition: TransitionSpecification | void;
	constructor(property: Property<T, R>);
	transitioned(parameters: TransitionParameters, prior: TransitioningPropertyValue<T, R>): TransitioningPropertyValue<T, R>;
	untransitioned(): TransitioningPropertyValue<T, R>;
}
export declare class Transitionable<Props> {
	_properties: Properties<Props>;
	_values: {
		[K in keyof Props]: TransitionablePropertyValue<any, unknown>;
	};
	constructor(properties: Properties<Props>);
	getValue<S extends keyof Props, T>(name: S): PropertyValueSpecification<T> | void;
	setValue<S extends keyof Props, T>(name: S, value: PropertyValueSpecification<T> | void): void;
	getTransition<S extends keyof Props>(name: S): TransitionSpecification | void;
	setTransition<S extends keyof Props>(name: S, value: TransitionSpecification | void): void;
	serialize(): any;
	transitioned(parameters: TransitionParameters, prior: Transitioning<Props>): Transitioning<Props>;
	untransitioned(): Transitioning<Props>;
}
export declare class TransitioningPropertyValue<T, R> {
	property: Property<T, R>;
	value: PropertyValue<T, R>;
	prior: TransitioningPropertyValue<T, R>;
	begin: TimePoint;
	end: TimePoint;
	constructor(property: Property<T, R>, value: PropertyValue<T, R>, prior: TransitioningPropertyValue<T, R>, transition: TransitionSpecification, now: TimePoint);
	possiblyEvaluate(parameters: EvaluationParameters, canonical: CanonicalTileID, availableImages: Array<string>): R;
}
export declare class Transitioning<Props> {
	_properties: Properties<Props>;
	_values: {
		[K in keyof Props]: PossiblyEvaluatedPropertyValue<unknown>;
	};
	constructor(properties: Properties<Props>);
	possiblyEvaluate(parameters: EvaluationParameters, canonical?: CanonicalTileID, availableImages?: Array<string>): PossiblyEvaluated<Props, any>;
	hasTransition(): boolean;
}
export declare class Layout<Props> {
	_properties: Properties<Props>;
	_values: {
		[K in keyof Props]: PropertyValue<any, PossiblyEvaluatedPropertyValue<any>>;
	};
	constructor(properties: Properties<Props>);
	getValue<S extends keyof Props>(name: S): any;
	setValue<S extends keyof Props>(name: S, value: any): void;
	serialize(): any;
	possiblyEvaluate(parameters: EvaluationParameters, canonical?: CanonicalTileID, availableImages?: Array<string>): PossiblyEvaluated<Props, any>;
}
/**
 * "Possibly evaluated value" is an intermediate stage in the evaluation chain for both paint and layout property
 * values. The purpose of this stage is to optimize away unnecessary recalculations for data-driven properties. Code
 * which uses data-driven property values must assume that the value is dependent on feature data, and request that it
 * be evaluated for each feature. But when that property value is in fact a constant or camera function, the calculation
 * will not actually depend on the feature, and we can benefit from returning the prior result of having done the
 * evaluation once, ahead of time, in an intermediate step whose inputs are just the value and "global" parameters
 * such as current zoom level.
 *
 * `PossiblyEvaluatedValue` represents the three possible outcomes of this step: if the input value was a constant or
 * camera expression, then the "possibly evaluated" result is a constant value. Otherwise, the input value was either
 * a source or composite expression, and we must defer final evaluation until supplied a feature. We separate
 * the source and composite cases because they are handled differently when generating GL attributes, buffers, and
 * uniforms.
 *
 * Note that `PossiblyEvaluatedValue` (and `PossiblyEvaluatedPropertyValue`, below) are _not_ used for properties that
 * do not allow data-driven values. For such properties, we know that the "possibly evaluated" result is always a constant
 * scalar value. See below.
 *
 * @private
 */
export type PossiblyEvaluatedValue<T> = {
	kind: "constant";
	value: T;
} | SourceExpression | CompositeExpression;
export declare class PossiblyEvaluatedPropertyValue<T> {
	property: DataDrivenProperty<T>;
	value: PossiblyEvaluatedValue<T>;
	parameters: EvaluationParameters;
	constructor(property: DataDrivenProperty<T>, value: PossiblyEvaluatedValue<T>, parameters: EvaluationParameters);
	isConstant(): boolean;
	constantOr(value: T): T;
	evaluate(feature: Feature, featureState: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>): T;
}
export declare class PossiblyEvaluated<Props, PossibleEvaluatedProps> {
	_properties: Properties<Props>;
	_values: PossibleEvaluatedProps;
	constructor(properties: Properties<Props>);
	get<S extends keyof PossibleEvaluatedProps>(name: S): PossibleEvaluatedProps[S];
}
export declare class DataConstantProperty<T> implements Property<T, T> {
	specification: StylePropertySpecification;
	constructor(specification: StylePropertySpecification);
	possiblyEvaluate(value: PropertyValue<T, T>, parameters: EvaluationParameters): T;
	interpolate(a: T, b: T, t: number): T;
}
export declare class DataDrivenProperty<T> implements Property<T, PossiblyEvaluatedPropertyValue<T>> {
	specification: StylePropertySpecification;
	overrides: any;
	constructor(specification: StylePropertySpecification, overrides?: any);
	possiblyEvaluate(value: PropertyValue<T, PossiblyEvaluatedPropertyValue<T>>, parameters: EvaluationParameters, canonical?: CanonicalTileID, availableImages?: Array<string>): PossiblyEvaluatedPropertyValue<T>;
	interpolate(a: PossiblyEvaluatedPropertyValue<T>, b: PossiblyEvaluatedPropertyValue<T>, t: number): PossiblyEvaluatedPropertyValue<T>;
	evaluate(value: PossiblyEvaluatedValue<T>, parameters: EvaluationParameters, feature: Feature, featureState: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>): T;
}
export declare class CrossFadedDataDrivenProperty<T> extends DataDrivenProperty<CrossFaded<T>> {
	possiblyEvaluate(value: PropertyValue<CrossFaded<T>, PossiblyEvaluatedPropertyValue<CrossFaded<T>>>, parameters: EvaluationParameters, canonical?: CanonicalTileID, availableImages?: Array<string>): PossiblyEvaluatedPropertyValue<CrossFaded<T>>;
	evaluate(value: PossiblyEvaluatedValue<CrossFaded<T>>, globals: EvaluationParameters, feature: Feature, featureState: FeatureState, canonical?: CanonicalTileID, availableImages?: Array<string>): CrossFaded<T>;
	_calculate(min: T, mid: T, max: T, parameters: EvaluationParameters): CrossFaded<T>;
	interpolate(a: PossiblyEvaluatedPropertyValue<CrossFaded<T>>): PossiblyEvaluatedPropertyValue<CrossFaded<T>>;
}
export declare class CrossFadedProperty<T> implements Property<T, CrossFaded<T>> {
	specification: StylePropertySpecification;
	constructor(specification: StylePropertySpecification);
	possiblyEvaluate(value: PropertyValue<T, CrossFaded<T>>, parameters: EvaluationParameters, canonical?: CanonicalTileID, availableImages?: Array<string>): CrossFaded<T>;
	_calculate(min: T, mid: T, max: T, parameters: EvaluationParameters): CrossFaded<T>;
	interpolate(a?: CrossFaded<T> | null): CrossFaded<T>;
}
export declare class ColorRampProperty implements Property<Color, boolean> {
	specification: StylePropertySpecification;
	constructor(specification: StylePropertySpecification);
	possiblyEvaluate(value: PropertyValue<Color, boolean>, parameters: EvaluationParameters, canonical?: CanonicalTileID, availableImages?: Array<string>): boolean;
	interpolate(): boolean;
}
export declare class Properties<Props> {
	properties: Props;
	defaultPropertyValues: {
		[K in keyof Props]: PropertyValue<unknown, any>;
	};
	defaultTransitionablePropertyValues: {
		[K in keyof Props]: TransitionablePropertyValue<unknown, unknown>;
	};
	defaultTransitioningPropertyValues: {
		[K in keyof Props]: TransitioningPropertyValue<unknown, unknown>;
	};
	defaultPossiblyEvaluatedValues: {
		[K in keyof Props]: PossiblyEvaluatedPropertyValue<unknown>;
	};
	overridableProperties: Array<string>;
	constructor(properties: Props);
}
export type Transferable = ArrayBuffer | MessagePort | ImageBitmap;
declare const viewTypes: {
	Int8: Int8ArrayConstructor;
	Uint8: Uint8ArrayConstructor;
	Int16: Int16ArrayConstructor;
	Uint16: Uint16ArrayConstructor;
	Int32: Int32ArrayConstructor;
	Uint32: Uint32ArrayConstructor;
	Float32: Float32ArrayConstructor;
};
export type ViewType = keyof typeof viewTypes;
export declare class Struct {
	_pos1: number;
	_pos2: number;
	_pos4: number;
	_pos8: number;
	readonly _structArray: StructArray;
	size: number;
	/**
	 * @param {StructArray} structArray The StructArray the struct is stored in
	 * @param {number} index The index of the struct in the StructArray.
	 * @private
	 */
	constructor(structArray: StructArray, index: number);
}
export type StructArrayMember = {
	name: string;
	type: ViewType;
	components: number;
	offset: number;
};
export type SerializedStructArray = {
	length: number;
	arrayBuffer: ArrayBuffer;
};
declare abstract class StructArray {
	capacity: number;
	length: number;
	isTransferred: boolean;
	arrayBuffer: ArrayBuffer;
	uint8: Uint8Array;
	members: Array<StructArrayMember>;
	bytesPerElement: number;
	abstract emplaceBack(...v: number[]): any;
	abstract emplace(i: number, ...v: number[]): any;
	constructor();
	/**
	 * Serialize a StructArray instance.  Serializes both the raw data and the
	 * metadata needed to reconstruct the StructArray base class during
	 * deserialization.
	 * @private
	 */
	static serialize(array: StructArray, transferables?: Array<Transferable>): SerializedStructArray;
	static deserialize(input: SerializedStructArray): any;
	/**
	 * Resize the array to discard unused capacity.
	 */
	_trim(): void;
	/**
	 * Resets the the length of the array to 0 without de-allocating capcacity.
	 */
	clear(): void;
	/**
	 * Resize the array.
	 * If `n` is greater than the current length then additional elements with undefined values are added.
	 * If `n` is less than the current length then the array will be reduced to the first `n` elements.
	 * @param {number} n The new size of the array.
	 */
	resize(n: number): void;
	/**
	 * Indicate a planned increase in size, so that any necessary allocation may
	 * be done once, ahead of time.
	 * @param {number} n The expected size of the array.
	 */
	reserve(n: number): void;
	/**
	 * Create TypedArray views for the current ArrayBuffer.
	 */
	_refreshViews(): void;
}
export declare class StructArrayLayout2i4 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number): number;
	emplace(i: number, v0: number, v1: number): number;
}
export declare class StructArrayLayout3i6 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number): number;
	emplace(i: number, v0: number, v1: number, v2: number): number;
}
export declare class StructArrayLayout4i8 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number, v3: number): number;
	emplace(i: number, v0: number, v1: number, v2: number, v3: number): number;
}
export declare class StructArrayLayout2i4i12 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number, v3: number, v4: number, v5: number): number;
	emplace(i: number, v0: number, v1: number, v2: number, v3: number, v4: number, v5: number): number;
}
export declare class StructArrayLayout2i4ub8 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number, v3: number, v4: number, v5: number): number;
	emplace(i: number, v0: number, v1: number, v2: number, v3: number, v4: number, v5: number): number;
}
export declare class StructArrayLayout2f8 extends StructArray {
	uint8: Uint8Array;
	float32: Float32Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number): number;
	emplace(i: number, v0: number, v1: number): number;
}
export declare class StructArrayLayout4i4ui4i24 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	uint16: Uint16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number, v3: number, v4: number, v5: number, v6: number, v7: number, v8: number, v9: number, v10: number, v11: number): number;
	emplace(i: number, v0: number, v1: number, v2: number, v3: number, v4: number, v5: number, v6: number, v7: number, v8: number, v9: number, v10: number, v11: number): number;
}
export declare class StructArrayLayout3f12 extends StructArray {
	uint8: Uint8Array;
	float32: Float32Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number): number;
	emplace(i: number, v0: number, v1: number, v2: number): number;
}
export declare class StructArrayLayout1ul4 extends StructArray {
	uint8: Uint8Array;
	uint32: Uint32Array;
	_refreshViews(): void;
	emplaceBack(v0: number): number;
	emplace(i: number, v0: number): number;
}
export declare class StructArrayLayout6i1ul2ui20 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	uint32: Uint32Array;
	uint16: Uint16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number, v3: number, v4: number, v5: number, v6: number, v7: number, v8: number): number;
	emplace(i: number, v0: number, v1: number, v2: number, v3: number, v4: number, v5: number, v6: number, v7: number, v8: number): number;
}
export declare class StructArrayLayout2ub2f12 extends StructArray {
	uint8: Uint8Array;
	float32: Float32Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number, v3: number): number;
	emplace(i: number, v0: number, v1: number, v2: number, v3: number): number;
}
export declare class StructArrayLayout3ui6 extends StructArray {
	uint8: Uint8Array;
	uint16: Uint16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number): number;
	emplace(i: number, v0: number, v1: number, v2: number): number;
}
export declare class StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	uint16: Uint16Array;
	uint32: Uint32Array;
	float32: Float32Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number, v3: number, v4: number, v5: number, v6: number, v7: number, v8: number, v9: number, v10: number, v11: number, v12: number, v13: number, v14: number, v15: number, v16: number): number;
	emplace(i: number, v0: number, v1: number, v2: number, v3: number, v4: number, v5: number, v6: number, v7: number, v8: number, v9: number, v10: number, v11: number, v12: number, v13: number, v14: number, v15: number, v16: number): number;
}
export declare class StructArrayLayout8i15ui1ul4f68 extends StructArray {
	uint8: Uint8Array;
	int16: Int16Array;
	uint16: Uint16Array;
	uint32: Uint32Array;
	float32: Float32Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number, v3: number, v4: number, v5: number, v6: number, v7: number, v8: number, v9: number, v10: number, v11: number, v12: number, v13: number, v14: number, v15: number, v16: number, v17: number, v18: number, v19: number, v20: number, v21: number, v22: number, v23: number, v24: number, v25: number, v26: number, v27: number): number;
	emplace(i: number, v0: number, v1: number, v2: number, v3: number, v4: number, v5: number, v6: number, v7: number, v8: number, v9: number, v10: number, v11: number, v12: number, v13: number, v14: number, v15: number, v16: number, v17: number, v18: number, v19: number, v20: number, v21: number, v22: number, v23: number, v24: number, v25: number, v26: number, v27: number): number;
}
export declare class StructArrayLayout1f4 extends StructArray {
	uint8: Uint8Array;
	float32: Float32Array;
	_refreshViews(): void;
	emplaceBack(v0: number): number;
	emplace(i: number, v0: number): number;
}
export declare class StructArrayLayout1ul2ui8 extends StructArray {
	uint8: Uint8Array;
	uint32: Uint32Array;
	uint16: Uint16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number, v2: number): number;
	emplace(i: number, v0: number, v1: number, v2: number): number;
}
export declare class StructArrayLayout2ui4 extends StructArray {
	uint8: Uint8Array;
	uint16: Uint16Array;
	_refreshViews(): void;
	emplaceBack(v0: number, v1: number): number;
	emplace(i: number, v0: number, v1: number): number;
}
export declare class StructArrayLayout1ui2 extends StructArray {
	uint8: Uint8Array;
	uint16: Uint16Array;
	_refreshViews(): void;
	emplaceBack(v0: number): number;
	emplace(i: number, v0: number): number;
}
export declare class CollisionBoxStruct extends Struct {
	_structArray: CollisionBoxArray;
	get anchorPointX(): number;
	get anchorPointY(): number;
	get x1(): number;
	get y1(): number;
	get x2(): number;
	get y2(): number;
	get featureIndex(): number;
	get sourceLayerIndex(): number;
	get bucketIndex(): number;
	get anchorPoint(): Point;
}
export declare class CollisionBoxArray extends StructArrayLayout6i1ul2ui20 {
	/**
	 * Return the CollisionBoxStruct at the given location in the array.
	 * @param {number} index The index of the element.
	 * @private
	 */
	get(index: number): CollisionBoxStruct;
}
export declare class PlacedSymbolStruct extends Struct {
	_structArray: PlacedSymbolArray;
	get anchorX(): number;
	get anchorY(): number;
	get glyphStartIndex(): number;
	get numGlyphs(): number;
	get vertexStartIndex(): number;
	get lineStartIndex(): number;
	get lineLength(): number;
	get segment(): number;
	get lowerSize(): number;
	get upperSize(): number;
	get lineOffsetX(): number;
	get lineOffsetY(): number;
	get writingMode(): number;
	get placedOrientation(): number;
	set placedOrientation(x: number);
	get hidden(): number;
	set hidden(x: number);
	get crossTileID(): number;
	set crossTileID(x: number);
	get associatedIconIndex(): number;
}
export declare class PlacedSymbolArray extends StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48 {
	/**
	 * Return the PlacedSymbolStruct at the given location in the array.
	 * @param {number} index The index of the element.
	 * @private
	 */
	get(index: number): PlacedSymbolStruct;
}
export declare class SymbolInstanceStruct extends Struct {
	_structArray: SymbolInstanceArray;
	get anchorX(): number;
	get anchorY(): number;
	get rightJustifiedTextSymbolIndex(): number;
	get centerJustifiedTextSymbolIndex(): number;
	get leftJustifiedTextSymbolIndex(): number;
	get verticalPlacedTextSymbolIndex(): number;
	get placedIconSymbolIndex(): number;
	get verticalPlacedIconSymbolIndex(): number;
	get key(): number;
	get textBoxStartIndex(): number;
	get textBoxEndIndex(): number;
	get verticalTextBoxStartIndex(): number;
	get verticalTextBoxEndIndex(): number;
	get iconBoxStartIndex(): number;
	get iconBoxEndIndex(): number;
	get verticalIconBoxStartIndex(): number;
	get verticalIconBoxEndIndex(): number;
	get featureIndex(): number;
	get numHorizontalGlyphVertices(): number;
	get numVerticalGlyphVertices(): number;
	get numIconVertices(): number;
	get numVerticalIconVertices(): number;
	get useRuntimeCollisionCircles(): number;
	get crossTileID(): number;
	set crossTileID(x: number);
	get textBoxScale(): number;
	get textOffset0(): number;
	get textOffset1(): number;
	get collisionCircleDiameter(): number;
}
export type SymbolInstance = SymbolInstanceStruct;
export declare class SymbolInstanceArray extends StructArrayLayout8i15ui1ul4f68 {
	/**
	 * Return the SymbolInstanceStruct at the given location in the array.
	 * @param {number} index The index of the element.
	 * @private
	 */
	get(index: number): SymbolInstanceStruct;
}
export declare class GlyphOffsetArray extends StructArrayLayout1f4 {
	getoffsetX(index: number): number;
}
export declare class SymbolLineVertexArray extends StructArrayLayout3i6 {
	getx(index: number): number;
	gety(index: number): number;
	gettileUnitDistanceFromAnchor(index: number): number;
}
export declare class FeatureIndexStruct extends Struct {
	_structArray: FeatureIndexArray;
	get featureIndex(): number;
	get sourceLayerIndex(): number;
	get bucketIndex(): number;
}
export declare class FeatureIndexArray extends StructArrayLayout1ul2ui8 {
	/**
	 * Return the FeatureIndexStruct at the given location in the array.
	 * @param {number} index The index of the element.
	 * @private
	 */
	get(index: number): FeatureIndexStruct;
}
export declare class PosArray extends StructArrayLayout2i4 {
}
export declare class RasterBoundsArray extends StructArrayLayout4i8 {
}
export declare class CircleLayoutArray extends StructArrayLayout2i4 {
}
export declare class FillLayoutArray extends StructArrayLayout2i4 {
}
export declare class FillExtrusionLayoutArray extends StructArrayLayout2i4i12 {
}
export declare class LineLayoutArray extends StructArrayLayout2i4ub8 {
}
export declare class LineExtLayoutArray extends StructArrayLayout2f8 {
}
export declare class SymbolLayoutArray extends StructArrayLayout4i4ui4i24 {
}
export declare class SymbolDynamicLayoutArray extends StructArrayLayout3f12 {
}
export declare class SymbolOpacityArray extends StructArrayLayout1ul4 {
}
export declare class CollisionVertexArray extends StructArrayLayout2ub2f12 {
}
export declare class TriangleIndexArray extends StructArrayLayout3ui6 {
}
export declare class LineIndexArray extends StructArrayLayout2ui4 {
}
export declare class LineStripIndexArray extends StructArrayLayout1ui2 {
}
export type SerializedFeaturePositionMap = {
	ids: Float64Array;
	positions: Uint32Array;
};
export type FeaturePosition = {
	index: number;
	start: number;
	end: number;
};
export declare class FeaturePositionMap {
	ids: Array<number>;
	positions: Array<number>;
	indexed: boolean;
	constructor();
	add(id: unknown, index: number, start: number, end: number): void;
	getPositions(id: unknown): Array<FeaturePosition>;
	static serialize(map: FeaturePositionMap, transferables: Array<ArrayBuffer>): SerializedFeaturePositionMap;
	static deserialize(obj: SerializedFeaturePositionMap): FeaturePositionMap;
}
export declare class IndexBuffer {
	context: Context;
	buffer: WebGLBuffer;
	dynamicDraw: boolean;
	constructor(context: Context, array: TriangleIndexArray | LineIndexArray | LineStripIndexArray, dynamicDraw?: boolean);
	bind(): void;
	updateData(array: StructArray): void;
	destroy(): void;
}
export declare class VertexBuffer {
	length: number;
	attributes: ReadonlyArray<StructArrayMember>;
	itemSize: number;
	dynamicDraw: boolean;
	context: Context;
	buffer: WebGLBuffer;
	/**
	 * @param dynamicDraw Whether this buffer will be repeatedly updated.
	 * @private
	 */
	constructor(context: Context, array: StructArray, attributes: ReadonlyArray<StructArrayMember>, dynamicDraw?: boolean);
	bind(): void;
	updateData(array: StructArray): void;
	enableAttributes(gl: WebGLRenderingContext | WebGL2RenderingContext, program: Program<any>): void;
	/**
	 * Set the attribute pointers in a WebGL context
	 * @param gl The WebGL context
	 * @param program The active WebGL program
	 * @param vertexOffset Index of the starting vertex of the segment
	 */
	setVertexAttribPointers(gl: WebGLRenderingContext | WebGL2RenderingContext, program: Program<any>, vertexOffset?: number | null): void;
	/**
	 * Destroy the GL buffer bound to the given WebGL context
	 */
	destroy(): void;
}
export type BlendFuncConstant = WebGLRenderingContextBase["ZERO"] | WebGLRenderingContextBase["ONE"] | WebGLRenderingContextBase["SRC_COLOR"] | WebGLRenderingContextBase["ONE_MINUS_SRC_COLOR"] | WebGLRenderingContextBase["DST_COLOR"] | WebGLRenderingContextBase["ONE_MINUS_DST_COLOR"] | WebGLRenderingContextBase["SRC_ALPHA"] | WebGLRenderingContextBase["ONE_MINUS_SRC_ALPHA"] | WebGLRenderingContextBase["DST_ALPHA"] | WebGLRenderingContextBase["ONE_MINUS_DST_ALPHA"] | WebGLRenderingContextBase["CONSTANT_COLOR"] | WebGLRenderingContextBase["ONE_MINUS_CONSTANT_COLOR"] | WebGLRenderingContextBase["CONSTANT_ALPHA"] | WebGLRenderingContextBase["ONE_MINUS_CONSTANT_ALPHA"] | WebGLRenderingContextBase["BLEND_COLOR"];
export type BlendFuncType = [
	BlendFuncConstant,
	BlendFuncConstant
];
export type BlendEquationType = WebGLRenderingContextBase["FUNC_ADD"] | WebGLRenderingContextBase["FUNC_SUBTRACT"] | WebGLRenderingContextBase["FUNC_REVERSE_SUBTRACT"];
export type ColorMaskType = [
	boolean,
	boolean,
	boolean,
	boolean
];
export type CompareFuncType = WebGLRenderingContextBase["NEVER"] | WebGLRenderingContextBase["LESS"] | WebGLRenderingContextBase["EQUAL"] | WebGLRenderingContextBase["LEQUAL"] | WebGLRenderingContextBase["GREATER"] | WebGLRenderingContextBase["NOTEQUAL"] | WebGLRenderingContextBase["GEQUAL"] | WebGLRenderingContextBase["ALWAYS"];
export type DepthMaskType = boolean;
export type DepthRangeType = [
	number,
	number
];
export type DepthFuncType = CompareFuncType;
export type StencilFuncType = {
	func: CompareFuncType;
	ref: number;
	mask: number;
};
export type StencilOpConstant = WebGLRenderingContextBase["KEEP"] | WebGLRenderingContextBase["ZERO"] | WebGLRenderingContextBase["REPLACE"] | WebGLRenderingContextBase["INCR"] | WebGLRenderingContextBase["INCR_WRAP"] | WebGLRenderingContextBase["DECR"] | WebGLRenderingContextBase["DECR_WRAP"] | WebGLRenderingContextBase["INVERT"];
export type StencilOpType = [
	StencilOpConstant,
	StencilOpConstant,
	StencilOpConstant
];
export type TextureUnitType = number;
export type ViewportType = [
	number,
	number,
	number,
	number
];
export type StencilTestGL = {
	func: WebGLRenderingContextBase["NEVER"];
	mask: 0;
} | {
	func: WebGLRenderingContextBase["LESS"];
	mask: number;
} | {
	func: WebGLRenderingContextBase["EQUAL"];
	mask: number;
} | {
	func: WebGLRenderingContextBase["LEQUAL"];
	mask: number;
} | {
	func: WebGLRenderingContextBase["GREATER"];
	mask: number;
} | {
	func: WebGLRenderingContextBase["NOTEQUAL"];
	mask: number;
} | {
	func: WebGLRenderingContextBase["GEQUAL"];
	mask: number;
} | {
	func: WebGLRenderingContextBase["ALWAYS"];
	mask: 0;
};
export type CullFaceModeType = WebGLRenderingContextBase["FRONT"] | WebGLRenderingContextBase["BACK"] | WebGLRenderingContextBase["FRONT_AND_BACK"];
export type FrontFaceType = WebGLRenderingContextBase["CW"] | WebGLRenderingContextBase["CCW"];
export interface IValue<T> {
	current: T;
	default: T;
	dirty: boolean;
	get(): T;
	setDefault(): void;
	set(value: T): void;
}
export declare class BaseValue<T> implements IValue<T> {
	gl: WebGLRenderingContext | WebGL2RenderingContext;
	current: T;
	default: T;
	dirty: boolean;
	constructor(context: Context);
	get(): T;
	set(value: T): void;
	getDefault(): T;
	setDefault(): void;
}
export declare class ClearColor extends BaseValue<Color> {
	getDefault(): Color;
	set(v: Color): void;
}
export declare class ClearDepth extends BaseValue<number> {
	getDefault(): number;
	set(v: number): void;
}
export declare class ClearStencil extends BaseValue<number> {
	getDefault(): number;
	set(v: number): void;
}
export declare class ColorMask extends BaseValue<ColorMaskType> {
	getDefault(): ColorMaskType;
	set(v: ColorMaskType): void;
}
export declare class DepthMask extends BaseValue<DepthMaskType> {
	getDefault(): DepthMaskType;
	set(v: DepthMaskType): void;
}
export declare class StencilMask extends BaseValue<number> {
	getDefault(): number;
	set(v: number): void;
}
export declare class StencilFunc extends BaseValue<StencilFuncType> {
	getDefault(): StencilFuncType;
	set(v: StencilFuncType): void;
}
export declare class StencilOp extends BaseValue<StencilOpType> {
	getDefault(): StencilOpType;
	set(v: StencilOpType): void;
}
export declare class StencilTest extends BaseValue<boolean> {
	getDefault(): boolean;
	set(v: boolean): void;
}
export declare class DepthRange extends BaseValue<DepthRangeType> {
	getDefault(): DepthRangeType;
	set(v: DepthRangeType): void;
}
export declare class DepthTest extends BaseValue<boolean> {
	getDefault(): boolean;
	set(v: boolean): void;
}
export declare class DepthFunc extends BaseValue<DepthFuncType> {
	getDefault(): DepthFuncType;
	set(v: DepthFuncType): void;
}
export declare class Blend extends BaseValue<boolean> {
	getDefault(): boolean;
	set(v: boolean): void;
}
export declare class BlendFunc extends BaseValue<BlendFuncType> {
	getDefault(): BlendFuncType;
	set(v: BlendFuncType): void;
}
export declare class BlendColor extends BaseValue<Color> {
	getDefault(): Color;
	set(v: Color): void;
}
export declare class BlendEquation extends BaseValue<BlendEquationType> {
	getDefault(): BlendEquationType;
	set(v: BlendEquationType): void;
}
export declare class CullFace extends BaseValue<boolean> {
	getDefault(): boolean;
	set(v: boolean): void;
}
export declare class CullFaceSide extends BaseValue<CullFaceModeType> {
	getDefault(): CullFaceModeType;
	set(v: CullFaceModeType): void;
}
export declare class FrontFace extends BaseValue<FrontFaceType> {
	getDefault(): FrontFaceType;
	set(v: FrontFaceType): void;
}
export declare class ProgramValue extends BaseValue<WebGLProgram> {
	getDefault(): WebGLProgram;
	set(v?: WebGLProgram | null): void;
}
export declare class ActiveTextureUnit extends BaseValue<TextureUnitType> {
	getDefault(): TextureUnitType;
	set(v: TextureUnitType): void;
}
export declare class Viewport extends BaseValue<ViewportType> {
	getDefault(): ViewportType;
	set(v: ViewportType): void;
}
export declare class BindFramebuffer extends BaseValue<WebGLFramebuffer> {
	getDefault(): WebGLFramebuffer;
	set(v?: WebGLFramebuffer | null): void;
}
export declare class BindRenderbuffer extends BaseValue<WebGLRenderbuffer> {
	getDefault(): WebGLRenderbuffer;
	set(v?: WebGLRenderbuffer | null): void;
}
export declare class BindTexture extends BaseValue<WebGLTexture> {
	getDefault(): WebGLTexture;
	set(v?: WebGLTexture | null): void;
}
export declare class BindVertexBuffer extends BaseValue<WebGLBuffer> {
	getDefault(): WebGLBuffer;
	set(v?: WebGLBuffer | null): void;
}
export declare class BindElementBuffer extends BaseValue<WebGLBuffer> {
	getDefault(): WebGLBuffer;
	set(v?: WebGLBuffer | null): void;
}
export declare class BindVertexArray extends BaseValue<WebGLVertexArrayObject | null> {
	getDefault(): WebGLVertexArrayObject | null;
	set(v: WebGLVertexArrayObject | null): void;
}
export declare class PixelStoreUnpack extends BaseValue<number> {
	getDefault(): number;
	set(v: number): void;
}
export declare class PixelStoreUnpackPremultiplyAlpha extends BaseValue<boolean> {
	getDefault(): boolean;
	set(v: boolean): void;
}
export declare class PixelStoreUnpackFlipY extends BaseValue<boolean> {
	getDefault(): boolean;
	set(v: boolean): void;
}
export declare class FramebufferAttachment<T> extends BaseValue<T> {
	parent: WebGLFramebuffer;
	context: Context;
	constructor(context: Context, parent: WebGLFramebuffer);
	getDefault(): any;
}
export declare class ColorAttachment extends FramebufferAttachment<WebGLTexture> {
	setDirty(): void;
	set(v?: WebGLTexture | null): void;
}
export declare class DepthAttachment extends FramebufferAttachment<WebGLRenderbuffer> {
	set(v?: WebGLRenderbuffer | null): void;
}
export declare class Framebuffer {
	context: Context;
	width: number;
	height: number;
	framebuffer: WebGLFramebuffer;
	colorAttachment: ColorAttachment;
	depthAttachment: DepthAttachment;
	constructor(context: Context, width: number, height: number, hasDepth: boolean, hasStencil: boolean);
	destroy(): void;
}
export declare class DepthMode {
	func: DepthFuncType;
	mask: DepthMaskType;
	range: DepthRangeType;
	static ReadOnly: boolean;
	static ReadWrite: boolean;
	constructor(depthFunc: DepthFuncType, depthMask: DepthMaskType, depthRange: DepthRangeType);
	static disabled: Readonly<DepthMode>;
}
export declare class StencilMode {
	test: StencilTestGL;
	ref: number;
	mask: number;
	fail: StencilOpConstant;
	depthFail: StencilOpConstant;
	pass: StencilOpConstant;
	constructor(test: StencilTestGL, ref: number, mask: number, fail: StencilOpConstant, depthFail: StencilOpConstant, pass: StencilOpConstant);
	static disabled: Readonly<StencilMode>;
}
export declare class ColorMode {
	blendFunction: BlendFuncType;
	blendColor: Color;
	mask: ColorMaskType;
	constructor(blendFunction: BlendFuncType, blendColor: Color, mask: ColorMaskType);
	static Replace: BlendFuncType;
	static disabled: Readonly<ColorMode>;
	static unblended: Readonly<ColorMode>;
	static alphaBlended: Readonly<ColorMode>;
}
export declare class CullFaceMode {
	enable: boolean;
	mode: CullFaceModeType;
	frontFace: FrontFaceType;
	constructor(enable: boolean, mode: CullFaceModeType, frontFace: FrontFaceType);
	static disabled: Readonly<CullFaceMode>;
	static backCCW: Readonly<CullFaceMode>;
}
export type ClearArgs = {
	color?: Color;
	depth?: number;
	stencil?: number;
};
export declare class Context {
	gl: WebGLRenderingContext | WebGL2RenderingContext;
	currentNumAttributes: number;
	maxTextureSize: number;
	clearColor: ClearColor;
	clearDepth: ClearDepth;
	clearStencil: ClearStencil;
	colorMask: ColorMask;
	depthMask: DepthMask;
	stencilMask: StencilMask;
	stencilFunc: StencilFunc;
	stencilOp: StencilOp;
	stencilTest: StencilTest;
	depthRange: DepthRange;
	depthTest: DepthTest;
	depthFunc: DepthFunc;
	blend: Blend;
	blendFunc: BlendFunc;
	blendColor: BlendColor;
	blendEquation: BlendEquation;
	cullFace: CullFace;
	cullFaceSide: CullFaceSide;
	frontFace: FrontFace;
	program: ProgramValue;
	activeTexture: ActiveTextureUnit;
	viewport: Viewport;
	bindFramebuffer: BindFramebuffer;
	bindRenderbuffer: BindRenderbuffer;
	bindTexture: BindTexture;
	bindVertexBuffer: BindVertexBuffer;
	bindElementBuffer: BindElementBuffer;
	bindVertexArray: BindVertexArray;
	pixelStoreUnpack: PixelStoreUnpack;
	pixelStoreUnpackPremultiplyAlpha: PixelStoreUnpackPremultiplyAlpha;
	pixelStoreUnpackFlipY: PixelStoreUnpackFlipY;
	extTextureFilterAnisotropic: EXT_texture_filter_anisotropic | null;
	extTextureFilterAnisotropicMax?: GLfloat;
	HALF_FLOAT?: GLenum;
	RGBA16F?: GLenum;
	RGB16F?: GLenum;
	constructor(gl: WebGLRenderingContext | WebGL2RenderingContext);
	setDefault(): void;
	setDirty(): void;
	createIndexBuffer(array: TriangleIndexArray | LineIndexArray | LineStripIndexArray, dynamicDraw?: boolean): IndexBuffer;
	createVertexBuffer(array: StructArray, attributes: ReadonlyArray<StructArrayMember>, dynamicDraw?: boolean): VertexBuffer;
	createRenderbuffer(storageFormat: number, width: number, height: number): WebGLRenderbuffer;
	createFramebuffer(width: number, height: number, hasDepth: boolean, hasStencil: boolean): Framebuffer;
	clear({ color, depth, stencil }: ClearArgs): void;
	setCullFace(cullFaceMode: Readonly<CullFaceMode>): void;
	setDepthMode(depthMode: Readonly<DepthMode>): void;
	setStencilMode(stencilMode: Readonly<StencilMode>): void;
	setColorMode(colorMode: Readonly<ColorMode>): void;
	createVertexArray(): WebGLVertexArrayObject | undefined;
	deleteVertexArray(x: WebGLVertexArrayObject | undefined): void;
	unbindVAO(): void;
}
export type $ObjMap<T extends {}, F extends (v: any) => any> = {
	[K in keyof T]: F extends (v: T[K]) => infer R ? R : never;
};
export type UniformValues<Us extends {}> = $ObjMap<Us, <V>(u: Uniform<V>) => V>;
export type UniformLocations = {
	[_: string]: WebGLUniformLocation;
};
declare abstract class Uniform<T> {
	gl: WebGLRenderingContext | WebGL2RenderingContext;
	location: WebGLUniformLocation;
	current: T;
	constructor(context: Context, location: WebGLUniformLocation);
	abstract set(v: T): void;
}
export declare class Uniform1i extends Uniform<number> {
	constructor(context: Context, location: WebGLUniformLocation);
	set(v: number): void;
}
export declare class Uniform1f extends Uniform<number> {
	constructor(context: Context, location: WebGLUniformLocation);
	set(v: number): void;
}
export declare class Uniform4f extends Uniform<vec4> {
	constructor(context: Context, location: WebGLUniformLocation);
	set(v: vec4): void;
}
export declare class UniformMatrix4f extends Uniform<mat4> {
	constructor(context: Context, location: WebGLUniformLocation);
	set(v: mat4): void;
}
export type UniformBindings = {
	[_: string]: Uniform<any>;
};
export type Size = {
	width: number;
	height: number;
};
export type Point2D = {
	x: number;
	y: number;
};
export declare class AlphaImage {
	width: number;
	height: number;
	data: Uint8Array;
	constructor(size: Size, data?: Uint8Array | Uint8ClampedArray);
	resize(size: Size): void;
	clone(): AlphaImage;
	static copy(srcImg: AlphaImage, dstImg: AlphaImage, srcPt: Point2D, dstPt: Point2D, size: Size): void;
}
export declare class RGBAImage {
	width: number;
	height: number;
	data: Uint8Array;
	constructor(size: Size, data?: Uint8Array | Uint8ClampedArray);
	resize(size: Size): void;
	replace(data: Uint8Array | Uint8ClampedArray, copy?: boolean): void;
	clone(): RGBAImage;
	static copy(srcImg: RGBAImage | ImageData, dstImg: RGBAImage, srcPt: Point2D, dstPt: Point2D, size: Size): void;
}
export type SpriteOnDemandStyleImage = {
	width: number;
	height: number;
	x: number;
	y: number;
	context: CanvasRenderingContext2D;
};
export type StyleImageData = {
	data: RGBAImage;
	version?: number;
	hasRenderCallback?: boolean;
	userImage?: StyleImageInterface;
	spriteData?: SpriteOnDemandStyleImage;
};
export type StyleImageMetadata = {
	pixelRatio: number;
	sdf: boolean;
	stretchX?: Array<[
		number,
		number
	]>;
	stretchY?: Array<[
		number,
		number
	]>;
	content?: [
		number,
		number,
		number,
		number
	];
};
export type StyleImage = StyleImageData & StyleImageMetadata;
/**
 * Interface for dynamically generated style images. This is a specification for
 * implementers to model: it is not an exported method or class.
 *
 * Images implementing this interface can be redrawn for every frame. They can be used to animate
 * icons and patterns or make them respond to user input. Style images can implement a
 * {@link StyleImageInterface#render} method. The method is called every frame and
 * can be used to update the image.
 *
 * @interface StyleImageInterface
 * @see [Add an animated icon to the map.](https://maplibre.org/maplibre-gl-js-docs/example/add-image-animated/)
 *
 * @example
 * var flashingSquare = {
 *     width: 64,
 *     height: 64,
 *     data: new Uint8Array(64 * 64 * 4),
 *
 *     onAdd: function(map) {
 *         this.map = map;
 *     },
 *
 *     render: function() {
 *         // keep repainting while the icon is on the map
 *         this.map.triggerRepaint();
 *
 *         // alternate between black and white based on the time
 *         var value = Math.round(Date.now() / 1000) % 2 === 0  ? 255 : 0;
 *
 *         // check if image needs to be changed
 *         if (value !== this.previousValue) {
 *             this.previousValue = value;
 *
 *             var bytesPerPixel = 4;
 *             for (var x = 0; x < this.width; x++) {
 *                 for (var y = 0; y < this.height; y++) {
 *                     var offset = (y * this.width + x) * bytesPerPixel;
 *                     this.data[offset + 0] = value;
 *                     this.data[offset + 1] = value;
 *                     this.data[offset + 2] = value;
 *                     this.data[offset + 3] = 255;
 *                 }
 *             }
 *
 *             // return true to indicate that the image changed
 *             return true;
 *         }
 *     }
 *  }
 *
 *  map.addImage('flashing_square', flashingSquare);
 */
export interface StyleImageInterface {
	/**
	 * @property {number} width
	 */
	width: number;
	/**
	 * @property {number} height
	 */
	height: number;
	/**
	 * @property {Uint8Array | Uint8ClampedArray} data
	 */
	data: Uint8Array | Uint8ClampedArray;
	/**
	 * This method is called once before every frame where the icon will be used.
	 * The method can optionally update the image's `data` member with a new image.
	 *
	 * If the method updates the image it must return `true` to commit the change.
	 * If the method returns `false` or nothing the image is assumed to not have changed.
	 *
	 * If updates are infrequent it maybe easier to use {@link Map#updateImage} to update
	 * the image instead of implementing this method.
	 *
	 * @function
	 * @memberof StyleImageInterface
	 * @instance
	 * @name render
	 * @return {boolean} `true` if this method updated the image. `false` if the image was not changed.
	 */
	render?: () => boolean;
	/**
	 * Optional method called when the layer has been added to the Map with {@link Map#addImage}.
	 *
	 * @function
	 * @memberof StyleImageInterface
	 * @instance
	 * @name onAdd
	 * @param {Map} map The Map this custom layer was just added to.
	 */
	onAdd?: (map: Map, id: string) => void;
	/**
	 * Optional method called when the icon is removed from the map with {@link Map#removeImage}.
	 * This gives the image a chance to clean up resources and event listeners.
	 *
	 * @function
	 * @memberof StyleImageInterface
	 * @instance
	 * @name onRemove
	 */
	onRemove?: () => void;
}
export type TextureFormat = WebGLRenderingContextBase["RGBA"] | WebGLRenderingContextBase["ALPHA"];
export type TextureFilter = WebGLRenderingContextBase["LINEAR"] | WebGLRenderingContextBase["LINEAR_MIPMAP_NEAREST"] | WebGLRenderingContextBase["NEAREST"];
export type TextureWrap = WebGLRenderingContextBase["REPEAT"] | WebGLRenderingContextBase["CLAMP_TO_EDGE"] | WebGLRenderingContextBase["MIRRORED_REPEAT"];
export type EmptyImage = {
	width: number;
	height: number;
	data: null;
};
export type DataTextureImage = RGBAImage | AlphaImage | EmptyImage;
export type TextureImage = TexImageSource | DataTextureImage;
export declare class Texture {
	context: Context;
	size: [
		number,
		number
	];
	texture: WebGLTexture;
	format: TextureFormat;
	filter: TextureFilter;
	wrap: TextureWrap;
	useMipmap: boolean;
	constructor(context: Context, image: TextureImage, format: TextureFormat, options?: {
		premultiply?: boolean;
		useMipmap?: boolean;
	} | null);
	update(image: TextureImage, options?: {
		premultiply?: boolean;
		useMipmap?: boolean;
	} | null, position?: {
		x: number;
		y: number;
	}): void;
	bind(filter: TextureFilter, wrap: TextureWrap, minFilter?: TextureFilter | null): void;
	isSizePowerOfTwo(): boolean;
	destroy(): void;
}
export type Pattern = {
	bin: PotpackBox;
	position: ImagePosition;
};
export declare class ImageManager extends Evented {
	images: {
		[_: string]: StyleImage;
	};
	updatedImages: {
		[_: string]: boolean;
	};
	callbackDispatchedThisFrame: {
		[_: string]: boolean;
	};
	loaded: boolean;
	requestors: Array<{
		ids: Array<string>;
		callback: Callback<{
			[_: string]: StyleImage;
		}>;
	}>;
	patterns: {
		[_: string]: Pattern;
	};
	atlasImage: RGBAImage;
	atlasTexture: Texture;
	dirty: boolean;
	constructor();
	isLoaded(): boolean;
	setLoaded(loaded: boolean): void;
	getImage(id: string): StyleImage;
	addImage(id: string, image: StyleImage): void;
	_validate(id: string, image: StyleImage): boolean;
	_validateStretch(stretch: Array<[
		number,
		number
	]>, size: number): boolean;
	_validateContent(content: [
		number,
		number,
		number,
		number
	], image: StyleImage): boolean;
	updateImage(id: string, image: StyleImage, validate?: boolean): void;
	removeImage(id: string): void;
	listImages(): Array<string>;
	getImages(ids: Array<string>, callback: Callback<{
		[_: string]: StyleImage;
	}>): void;
	_notify(ids: Array<string>, callback: Callback<{
		[_: string]: StyleImage;
	}>): void;
	getPixelSize(): {
		width: number;
		height: number;
	};
	getPattern(id: string): ImagePosition;
	bind(context: Context): void;
	_updatePatternAtlas(): void;
	beginFrame(): void;
	dispatchRenderCallbacks(ids: Array<string>): void;
}
export type GlyphMetrics = {
	width: number;
	height: number;
	left: number;
	top: number;
	advance: number;
};
export type StyleGlyph = {
	id: number;
	bitmap: AlphaImage;
	metrics: GlyphMetrics;
};
export type Rect = {
	x: number;
	y: number;
	w: number;
	h: number;
};
export type GlyphPosition = {
	rect: Rect;
	metrics: GlyphMetrics;
};
export type GlyphPositions = {
	[_: string]: {
		[_: number]: GlyphPosition;
	};
};
export declare class ImagePosition {
	paddedRect: Rect;
	pixelRatio: number;
	version: number;
	stretchY: Array<[
		number,
		number
	]>;
	stretchX: Array<[
		number,
		number
	]>;
	content: [
		number,
		number,
		number,
		number
	];
	constructor(paddedRect: Rect, { pixelRatio, version, stretchX, stretchY, content }: StyleImage);
	get tl(): [
		number,
		number
	];
	get br(): [
		number,
		number
	];
	get tlbr(): Array<number>;
	get displaySize(): [
		number,
		number
	];
}
export declare class ImageAtlas {
	image: RGBAImage;
	iconPositions: {
		[_: string]: ImagePosition;
	};
	patternPositions: {
		[_: string]: ImagePosition;
	};
	haveRenderCallbacks: Array<string>;
	uploaded: boolean;
	constructor(icons: {
		[_: string]: StyleImage;
	}, patterns: {
		[_: string]: StyleImage;
	});
	addImages(images: {
		[_: string]: StyleImage;
	}, positions: {
		[_: string]: ImagePosition;
	}, bins: Array<Rect>): void;
	patchUpdatedImages(imageManager: ImageManager, texture: Texture): void;
	patchUpdatedImage(position: ImagePosition, image: StyleImage, texture: Texture): void;
}
export type SerializedGrid = {
	buffer: ArrayBuffer;
};
export declare class TransferableGridIndex {
	cells: number[][];
	arrayBuffer: ArrayBuffer;
	d: number;
	keys: number[];
	bboxes: number[];
	n: number;
	extent: number;
	padding: number;
	scale: any;
	uid: number;
	min: number;
	max: number;
	constructor(extent: number | ArrayBuffer, n?: number, padding?: number);
	insert(key: number, x1: number, y1: number, x2: number, y2: number): void;
	_insertReadonly(): void;
	_insertCell(x1: number, y1: number, x2: number, y2: number, cellIndex: number, uid: number): void;
	query(x1: number, y1: number, x2: number, y2: number, intersectionTest?: Function): number[];
	_queryCell(x1: number, y1: number, x2: number, y2: number, cellIndex: number, result: any, seenUids: any, intersectionTest: Function): void;
	_forEachCell(x1: number, y1: number, x2: number, y2: number, fn: Function, arg1: any, arg2: any, intersectionTest: any): void;
	_convertFromCellCoord(x: any): number;
	_convertToCellCoord(x: any): number;
	toArrayBuffer(): ArrayBuffer;
	static serialize(grid: TransferableGridIndex, transferables?: Array<Transferable>): SerializedGrid;
	static deserialize(serialized: SerializedGrid): TransferableGridIndex;
}
export declare class DictionaryCoder {
	_stringToNumber: {
		[_: string]: number;
	};
	_numberToString: Array<string>;
	constructor(strings: Array<string>);
	encode(string: string): number;
	decode(n: number): string;
}
export type DistributiveKeys<T> = T extends T ? keyof T : never;
export type DistributiveOmit<T, K extends DistributiveKeys<T>> = T extends unknown ? Omit<T, K> : never;
export type MapGeoJSONFeature = GeoJSONFeature & {
	layer: DistributiveOmit<LayerSpecification, "source"> & {
		source: string;
	};
	source: string;
	sourceLayer?: string;
	state: {
		[key: string]: any;
	};
};
export declare class GeoJSONFeature {
	type: "Feature";
	_geometry: GeoJSON.Geometry;
	properties: {
		[name: string]: any;
	};
	id: number | string | undefined;
	_vectorTileFeature: VectorTileFeature;
	constructor(vectorTileFeature: VectorTileFeature, z: number, x: number, y: number, id: string | number | undefined);
	get geometry(): GeoJSON.Geometry;
	set geometry(g: GeoJSON.Geometry);
	toJSON(): any;
}
export declare class LngLatBounds {
	_ne: LngLat;
	_sw: LngLat;
	/**
	 * @param {LngLatLike} [sw] The southwest corner of the bounding box.
	 * OR array of 4 numbers in the order of  west, south, east, north
	 * OR array of 2 LngLatLike: [sw,ne]
	 * @param {LngLatLike} [ne] The northeast corner of the bounding box.
	 * @example
	 * var sw = new maplibregl.LngLat(-73.9876, 40.7661);
	 * var ne = new maplibregl.LngLat(-73.9397, 40.8002);
	 * var llb = new maplibregl.LngLatBounds(sw, ne);
	 * OR
	 * var llb = new maplibregl.LngLatBounds([-73.9876, 40.7661, -73.9397, 40.8002]);
	 * OR
	 * var llb = new maplibregl.LngLatBounds([sw, ne]);
	 */
	constructor(sw?: LngLatLike | [
		number,
		number,
		number,
		number
	] | [
		LngLatLike,
		LngLatLike
	], ne?: LngLatLike);
	/**
	 * Set the northeast corner of the bounding box
	 *
	 * @param {LngLatLike} ne a {@link LngLatLike} object describing the northeast corner of the bounding box.
	 * @returns {LngLatBounds} `this`
	 */
	setNorthEast(ne: LngLatLike): this;
	/**
	 * Set the southwest corner of the bounding box
	 *
	 * @param {LngLatLike} sw a {@link LngLatLike} object describing the southwest corner of the bounding box.
	 * @returns {LngLatBounds} `this`
	 */
	setSouthWest(sw: LngLatLike): this;
	/**
	 * Extend the bounds to include a given LngLatLike or LngLatBoundsLike.
	 *
	 * @param {LngLatLike|LngLatBoundsLike} obj object to extend to
	 * @returns {LngLatBounds} `this`
	 */
	extend(obj: LngLatLike | LngLatBoundsLike): any;
	/**
	 * Returns the geographical coordinate equidistant from the bounding box's corners.
	 *
	 * @returns {LngLat} The bounding box's center.
	 * @example
	 * var llb = new maplibregl.LngLatBounds([-73.9876, 40.7661], [-73.9397, 40.8002]);
	 * llb.getCenter(); // = LngLat {lng: -73.96365, lat: 40.78315}
	 */
	getCenter(): LngLat;
	/**
	 * Returns the southwest corner of the bounding box.
	 *
	 * @returns {LngLat} The southwest corner of the bounding box.
	 */
	getSouthWest(): LngLat;
	/**
	 * Returns the northeast corner of the bounding box.
	 *
	 * @returns {LngLat} The northeast corner of the bounding box.
	 */
	getNorthEast(): LngLat;
	/**
	 * Returns the northwest corner of the bounding box.
	 *
	 * @returns {LngLat} The northwest corner of the bounding box.
	 */
	getNorthWest(): LngLat;
	/**
	 * Returns the southeast corner of the bounding box.
	 *
	 * @returns {LngLat} The southeast corner of the bounding box.
	 */
	getSouthEast(): LngLat;
	/**
	 * Returns the west edge of the bounding box.
	 *
	 * @returns {number} The west edge of the bounding box.
	 */
	getWest(): number;
	/**
	 * Returns the south edge of the bounding box.
	 *
	 * @returns {number} The south edge of the bounding box.
	 */
	getSouth(): number;
	/**
	 * Returns the east edge of the bounding box.
	 *
	 * @returns {number} The east edge of the bounding box.
	 */
	getEast(): number;
	/**
	 * Returns the north edge of the bounding box.
	 *
	 * @returns {number} The north edge of the bounding box.
	 */
	getNorth(): number;
	/**
	 * Returns the bounding box represented as an array.
	 *
	 * @returns {Array<Array<number>>} The bounding box represented as an array, consisting of the
	 * southwest and northeast coordinates of the bounding represented as arrays of numbers.
	 * @example
	 * var llb = new maplibregl.LngLatBounds([-73.9876, 40.7661], [-73.9397, 40.8002]);
	 * llb.toArray(); // = [[-73.9876, 40.7661], [-73.9397, 40.8002]]
	 */
	toArray(): [
		number,
		number
	][];
	/**
	 * Return the bounding box represented as a string.
	 *
	 * @returns {string} The bounding box represents as a string of the format
	 * `'LngLatBounds(LngLat(lng, lat), LngLat(lng, lat))'`.
	 * @example
	 * var llb = new maplibregl.LngLatBounds([-73.9876, 40.7661], [-73.9397, 40.8002]);
	 * llb.toString(); // = "LngLatBounds(LngLat(-73.9876, 40.7661), LngLat(-73.9397, 40.8002))"
	 */
	toString(): string;
	/**
	 * Check if the bounding box is an empty/`null`-type box.
	 *
	 * @returns {boolean} True if bounds have been defined, otherwise false.
	 */
	isEmpty(): boolean;
	/**
	 * Check if the point is within the bounding box.
	 *
	 * @param {LngLatLike} lnglat geographic point to check against.
	 * @returns {boolean} True if the point is within the bounding box.
	 * @example
	 * var llb = new maplibregl.LngLatBounds(
	 *   new maplibregl.LngLat(-73.9876, 40.7661),
	 *   new maplibregl.LngLat(-73.9397, 40.8002)
	 * );
	 *
	 * var ll = new maplibregl.LngLat(-73.9567, 40.7789);
	 *
	 * console.log(llb.contains(ll)); // = true
	 */
	contains(lnglat: LngLatLike): boolean;
	/**
	 * Converts an array to a `LngLatBounds` object.
	 *
	 * If a `LngLatBounds` object is passed in, the function returns it unchanged.
	 *
	 * Internally, the function calls `LngLat#convert` to convert arrays to `LngLat` values.
	 *
	 * @param {LngLatBoundsLike} input An array of two coordinates to convert, or a `LngLatBounds` object to return.
	 * @returns {LngLatBounds} A new `LngLatBounds` object, if a conversion occurred, or the original `LngLatBounds` object.
	 * @example
	 * var arr = [[-73.9876, 40.7661], [-73.9397, 40.8002]];
	 * var llb = maplibregl.LngLatBounds.convert(arr);
	 * llb;   // = LngLatBounds {_sw: LngLat {lng: -73.9876, lat: 40.7661}, _ne: LngLat {lng: -73.9397, lat: 40.8002}}
	 */
	static convert(input: LngLatBoundsLike | null): LngLatBounds;
	/**
	 * Returns a `LngLatBounds` from the coordinates extended by a given `radius`. The returned `LngLatBounds` completely contains the `radius`.
	 *
	 * @param center center coordinates of the new bounds.
	 * @param {number} [radius=0] Distance in meters from the coordinates to extend the bounds.
	 * @returns {LngLatBounds} A new `LngLatBounds` object representing the coordinates extended by the `radius`.
	 * @example
	 * var center = new maplibregl.LngLat(-73.9749, 40.7736);
	 * maplibregl.LngLatBounds.fromLngLat(100).toArray(); // = [[-73.97501862141328, 40.77351016847229], [-73.97478137858673, 40.77368983152771]]
	 */
	static fromLngLat(center: LngLat, radius?: number): LngLatBounds;
}
/**
 * A {@link LngLatBounds} object, an array of {@link LngLatLike} objects in [sw, ne] order,
 * or an array of numbers in [west, south, east, north] order.
 *
 * @typedef {LngLatBounds | [LngLatLike, LngLatLike] | [number, number, number, number]} LngLatBoundsLike
 * @example
 * var v1 = new maplibregl.LngLatBounds(
 *   new maplibregl.LngLat(-73.9876, 40.7661),
 *   new maplibregl.LngLat(-73.9397, 40.8002)
 * );
 * var v2 = new maplibregl.LngLatBounds([-73.9876, 40.7661], [-73.9397, 40.8002])
 * var v3 = [[-73.9876, 40.7661], [-73.9397, 40.8002]];
 */
export type LngLatBoundsLike = LngLatBounds | [
	LngLatLike,
	LngLatLike
] | [
	number,
	number,
	number,
	number
];
export declare class EdgeInsets {
	top: number;
	bottom: number;
	left: number;
	right: number;
	constructor(top?: number, bottom?: number, left?: number, right?: number);
	/**
	 * Interpolates the inset in-place.
	 * This maintains the current inset value for any inset not present in `target`.
	 * @param {PaddingOptions | EdgeInsets} start interpolation start
	 * @param {PaddingOptions} target interpolation target
	 * @param {number} t interpolation step/weight
	 * @returns {EdgeInsets} the insets
	 * @memberof EdgeInsets
	 */
	interpolate(start: PaddingOptions | EdgeInsets, target: PaddingOptions, t: number): EdgeInsets;
	/**
	 * Utility method that computes the new apprent center or vanishing point after applying insets.
	 * This is in pixels and with the top left being (0.0) and +y being downwards.
	 *
	 * @param {number} width the width
	 * @param {number} height the height
	 * @returns {Point} the point
	 * @memberof EdgeInsets
	 */
	getCenter(width: number, height: number): Point;
	equals(other: PaddingOptions): boolean;
	clone(): EdgeInsets;
	/**
	 * Returns the current state as json, useful when you want to have a
	 * read-only representation of the inset.
	 *
	 * @returns {PaddingOptions} state as json
	 * @memberof EdgeInsets
	 */
	toJSON(): PaddingOptions;
}
/**
 * Options for setting padding on calls to methods such as {@link Map#fitBounds}, {@link Map#fitScreenCoordinates}, and {@link Map#setPadding}. Adjust these options to set the amount of padding in pixels added to the edges of the canvas. Set a uniform padding on all edges or individual values for each edge. All properties of this object must be
 * non-negative integers.
 *
 * @example
 * var bbox = [[-79, 43], [-73, 45]];
 * map.fitBounds(bbox, {
 *   padding: {top: 10, bottom:25, left: 15, right: 5}
 * });
 *
 * @example
 * var bbox = [[-79, 43], [-73, 45]];
 * map.fitBounds(bbox, {
 *   padding: 20
 * });
 * @see [Fit to the bounds of a LineString](https://maplibre.org/maplibre-gl-js-docs/example/zoomto-linestring/)
 * @see [Fit a map to a bounding box](https://maplibre.org/maplibre-gl-js-docs/example/fitbounds/)
 */
export type PaddingOptions = {
	/**
	 * @property {number} top Padding in pixels from the top of the map canvas.
	 */
	top: number;
	/**
	 * @property {number} bottom Padding in pixels from the bottom of the map canvas.
	 */
	bottom: number;
	/**
	 * @property {number} left Padding in pixels from the left of the map canvas.
	 */
	right: number;
	/**
	 * @property {number} right Padding in pixels from the right of the map canvas.
	 */
	left: number;
};
export declare class TileCache {
	max: number;
	data: {
		[key: string]: Array<{
			value: Tile;
			timeout: ReturnType<typeof setTimeout>;
		}>;
	};
	order: Array<string>;
	onRemove: (element: Tile) => void;
	/**
	 * @param {number} max number of permitted values
	 * @param {Function} onRemove callback called with items when they expire
	 */
	constructor(max: number, onRemove: (element: Tile) => void);
	/**
	 * Clear the cache
	 *
	 * @returns {TileCache} this cache
	 * @private
	 */
	reset(): this;
	/**
	 * Add a key, value combination to the cache, trimming its size if this pushes
	 * it over max length.
	 *
	 * @param {OverscaledTileID} tileID lookup key for the item
	 * @param {*} data any value
	 *
	 * @returns {TileCache} this cache
	 * @private
	 */
	add(tileID: OverscaledTileID, data: Tile, expiryTimeout: number | void): this;
	/**
	 * Determine whether the value attached to `key` is present
	 *
	 * @param {OverscaledTileID} tileID the key to be looked-up
	 * @returns {boolean} whether the cache has this value
	 * @private
	 */
	has(tileID: OverscaledTileID): boolean;
	/**
	 * Get the value attached to a specific key and remove data from cache.
	 * If the key is not found, returns `null`
	 *
	 * @param {OverscaledTileID} tileID the key to look up
	 * @returns {*} the data, or null if it isn't found
	 * @private
	 */
	getAndRemove(tileID: OverscaledTileID): Tile;
	_getAndRemoveByKey(key: string): Tile;
	getByKey(key: string): Tile;
	/**
	 * Get the value attached to a specific key without removing data
	 * from the cache. If the key is not found, returns `null`
	 *
	 * @param {OverscaledTileID} tileID the key to look up
	 * @returns {*} the data, or null if it isn't found
	 * @private
	 */
	get(tileID: OverscaledTileID): Tile;
	/**
	 * Remove a key/value combination from the cache.
	 *
	 * @param {OverscaledTileID} tileID the key for the pair to delete
	 * @param {Tile} value If a value is provided, remove that exact version of the value.
	 * @returns {TileCache} this cache
	 * @private
	 */
	remove(tileID: OverscaledTileID, value?: {
		value: Tile;
		timeout: ReturnType<typeof setTimeout>;
	}): this;
	/**
	 * Change the max size of the cache.
	 *
	 * @param {number} max the max size of the cache
	 * @returns {TileCache} this cache
	 * @private
	 */
	setMaxSize(max: number): TileCache;
	/**
	 * Remove entries that do not pass a filter function. Used for removing
	 * stale tiles from the cache.
	 *
	 * @param {function} filterFn Determines whether the tile is filtered. If the supplied function returns false, the tile will be filtered out.
	 */
	filter(filterFn: (tile: Tile) => boolean): void;
}
export declare class ThrottledInvoker {
	_channel: MessageChannel;
	_triggered: boolean;
	_callback: Function;
	constructor(callback: Function);
	trigger(): void;
	remove(): void;
}
export declare class Actor {
	target: any;
	parent: any;
	mapId: number;
	callbacks: {
		number: any;
	};
	name: string;
	tasks: {
		number: any;
	};
	taskQueue: Array<number>;
	cancelCallbacks: {
		number: Cancelable;
	};
	invoker: ThrottledInvoker;
	globalScope: any;
	constructor(target: any, parent: any, mapId?: number | null);
	/**
	 * Sends a message from a main-thread map to a Worker or from a Worker back to
	 * a main-thread map instance.
	 *
	 * @param type The name of the target method to invoke or '[source-type].[source-name].name' for a method on a WorkerSource.
	 * @param targetMapId A particular mapId to which to send this message.
	 * @private
	 */
	send(type: string, data: unknown, callback?: Function | null, targetMapId?: string | null, mustQueue?: boolean): Cancelable;
	receive(message: any): void;
	process(): void;
	processTask(id: number, task: any): void;
	remove(): void;
}
export declare class DEMData {
	uid: string;
	data: Uint32Array;
	stride: number;
	dim: number;
	min: number;
	max: number;
	encoding: "mapbox" | "terrarium";
	constructor(uid: string, data: RGBAImage, encoding: "mapbox" | "terrarium");
	get(x: number, y: number): number;
	getUnpackVector(): number[];
	_idx(x: number, y: number): number;
	_unpackMapbox(r: number, g: number, b: number): number;
	_unpackTerrarium(r: number, g: number, b: number): number;
	getPixels(): RGBAImage;
	backfillBorder(borderTile: DEMData, dx: number, dy: number): void;
}
export type WorkerTileResult = {
	buckets: Array<Bucket>;
	imageAtlas: ImageAtlas;
	glyphAtlasImage: AlphaImage;
	featureIndex: FeatureIndex;
	collisionBoxArray: CollisionBoxArray;
	rawTileData?: ArrayBuffer;
	resourceTiming?: Array<PerformanceResourceTiming>;
	glyphMap?: {
		[_: string]: {
			[_: number]: StyleGlyph;
		};
	} | null;
	iconMap?: {
		[_: string]: StyleImage;
	} | null;
	glyphPositions?: GlyphPositions | null;
};
export type MessageListener = (a: {
	data: any;
	target: any;
}) => unknown;
export interface WorkerInterface {
	addEventListener(type: "message", listener: MessageListener): void;
	removeEventListener(type: "message", listener: MessageListener): void;
	postMessage(message: any): void;
	terminate(): void;
}
export declare class WorkerPool {
	static workerCount: number;
	active: {
		[_ in number | string]: boolean;
	};
	workers: Array<WorkerInterface>;
	constructor();
	acquire(mapId: number | string): Array<WorkerInterface>;
	release(mapId: number | string): void;
	isPreloaded(): boolean;
	numActive(): number;
}
export declare class Dispatcher {
	workerPool: WorkerPool;
	actors: Array<Actor>;
	currentActor: number;
	id: number;
	static Actor: {
		new (...args: any): Actor;
	};
	constructor(workerPool: WorkerPool, parent: any, mapId: number);
	/**
	 * Broadcast a message to all Workers.
	 * @private
	 */
	broadcast(type: string, data: unknown, cb?: (...args: any[]) => any): void;
	/**
	 * Acquires an actor to dispatch messages to. The actors are distributed in round-robin fashion.
	 * @returns An actor object backed by a web worker for processing messages.
	 */
	getActor(): Actor;
	remove(mapRemoved?: boolean): void;
}
export declare class TileBounds {
	bounds: LngLatBounds;
	minzoom: number;
	maxzoom: number;
	constructor(bounds: [
		number,
		number,
		number,
		number
	], minzoom?: number | null, maxzoom?: number | null);
	validateBounds(bounds: [
		number,
		number,
		number,
		number
	]): LngLatBoundsLike;
	contains(tileID: CanonicalTileID): boolean;
}
export declare class VectorTileSource extends Evented implements Source {
	type: "vector";
	id: string;
	minzoom: number;
	maxzoom: number;
	url: string;
	scheme: string;
	tileSize: number;
	promoteId: PromoteIdSpecification;
	_options: VectorSourceSpecification;
	_collectResourceTiming: boolean;
	dispatcher: Dispatcher;
	map: Map;
	bounds: [
		number,
		number,
		number,
		number
	];
	tiles: Array<string>;
	tileBounds: TileBounds;
	reparseOverscaled: boolean;
	isTileClipped: boolean;
	_tileJSONRequest: Cancelable;
	_loaded: boolean;
	constructor(id: string, options: VectorSourceSpecification & {
		collectResourceTiming: boolean;
	}, dispatcher: Dispatcher, eventedParent: Evented);
	load(): void;
	loaded(): boolean;
	hasTile(tileID: OverscaledTileID): boolean;
	onAdd(map: Map): void;
	setSourceProperty(callback: Function): void;
	/**
	 * Sets the source `tiles` property and re-renders the map.
	 *
	 * @param {string[]} tiles An array of one or more tile source URLs, as in the TileJSON spec.
	 * @returns {VectorTileSource} this
	 */
	setTiles(tiles: Array<string>): this;
	/**
	 * Sets the source `url` property and re-renders the map.
	 *
	 * @param {string} url A URL to a TileJSON resource. Supported protocols are `http:` and `https:`.
	 * @returns {VectorTileSource} this
	 */
	setUrl(url: string): this;
	onRemove(): void;
	serialize(): any;
	loadTile(tile: Tile, callback: Callback<void>): void;
	abortTile(tile: Tile): void;
	unloadTile(tile: Tile): void;
	hasTransition(): boolean;
}
export declare class RasterTileSource extends Evented implements Source {
	type: "raster" | "raster-dem";
	id: string;
	minzoom: number;
	maxzoom: number;
	url: string;
	scheme: string;
	tileSize: number;
	bounds: [
		number,
		number,
		number,
		number
	];
	tileBounds: TileBounds;
	roundZoom: boolean;
	dispatcher: Dispatcher;
	map: Map;
	tiles: Array<string>;
	_loaded: boolean;
	_options: RasterSourceSpecification | RasterDEMSourceSpecification;
	_tileJSONRequest: Cancelable;
	constructor(id: string, options: RasterSourceSpecification | RasterDEMSourceSpecification, dispatcher: Dispatcher, eventedParent: Evented);
	load(): void;
	loaded(): boolean;
	onAdd(map: Map): void;
	onRemove(): void;
	serialize(): any;
	hasTile(tileID: OverscaledTileID): boolean;
	loadTile(tile: Tile, callback: Callback<void>): void;
	abortTile(tile: Tile, callback: Callback<void>): void;
	unloadTile(tile: Tile, callback: Callback<void>): void;
	hasTransition(): boolean;
}
export type GeoJSONFeatureId = number | string;
export interface GeoJSONSourceDiff {
	removeAll?: boolean;
	remove?: Array<GeoJSONFeatureId>;
	add?: Array<GeoJSON.Feature>;
	update?: Array<GeoJSONFeatureDiff>;
}
export interface GeoJSONFeatureDiff {
	id: GeoJSONFeatureId;
	newGeometry?: GeoJSON.Geometry;
	removeAllProperties?: boolean;
	removeProperties?: Array<string>;
	addOrUpdateProperties?: Array<{
		key: string;
		value: any;
	}>;
}
export type GeoJSONSourceOptions = GeoJSONSourceSpecification & {
	workerOptions?: any;
	collectResourceTiming: boolean;
};
export type GeoJsonSourceOptions = {
	data?: GeoJSON.GeoJSON | string | undefined;
	cluster?: boolean;
	clusterMaxZoom?: number;
	clusterRadius?: number;
	clusterMinPoints?: number;
	generateId?: boolean;
};
export type WorkerOptions = {
	source?: string;
	cluster?: boolean;
	geojsonVtOptions?: {
		buffer?: number;
		tolerance?: number;
		extent?: number;
		maxZoom?: number;
		linemetrics?: boolean;
		generateId?: boolean;
	};
	superclusterOptions?: {
		maxZoom?: number;
		miniPoints?: number;
		extent?: number;
		radius?: number;
		log?: boolean;
		generateId?: boolean;
	};
	clusterProperties?: any;
	fliter?: any;
	promoteId?: any;
	collectResourceTiming?: boolean;
};
export type SetClusterOptions = {
	cluster?: boolean;
	clusterMaxZoom?: number;
	clusterRadius?: number;
};
export declare class GeoJSONSource extends Evented implements Source {
	type: "geojson";
	id: string;
	minzoom: number;
	maxzoom: number;
	tileSize: number;
	attribution: string;
	promoteId: PromoteIdSpecification;
	isTileClipped: boolean;
	reparseOverscaled: boolean;
	_data: GeoJSON.GeoJSON | string | undefined;
	_options: GeoJsonSourceOptions;
	workerOptions: WorkerOptions;
	map: Map;
	actor: Actor;
	_pendingLoads: number;
	_collectResourceTiming: boolean;
	_removed: boolean;
	/**
	 * @private
	 */
	constructor(id: string, options: GeoJSONSourceOptions, dispatcher: Dispatcher, eventedParent: Evented);
	load(): void;
	onAdd(map: Map): void;
	/**
	 * Sets the GeoJSON data and re-renders the map.
	 *
	 * @param {Object|string} data A GeoJSON data object or a URL to one. The latter is preferable in the case of large GeoJSON files.
	 * @returns {GeoJSONSource} this
	 */
	setData(data: GeoJSON.GeoJSON | string): this;
	/**
	 * Updates the source's GeoJSON, and re-renders the map.
	 *
	 * For sources with lots of features, this method can be used to make updates more quickly.
	 *
	 * This approach requires unique IDs for every feature in the source. The IDs can either be specified on the feature,
	 * or by using the promoteId option to specify which property should be used as the ID.
	 *
	 * It is an error to call updateData on a source that did not have unique IDs for each of its features already.
	 *
	 * Updates are applied on a best-effort basis, updating an ID that does not exist will not result in an error.
	 *
	 * @param {GeoJSONSourceDiff} diff The changes that need to be applied.
	 * @returns {GeoJSONSource} this
	 */
	updateData(diff: GeoJSONSourceDiff): this;
	/**
	 * To disable/enable clustering on the source options
	 * @param {SetClusterOptions} options The options to set
	 * @returns {GeoJSONSource} this
	 * @example
	 * map.getSource('some id').setClusterOptions({cluster: false});
	 * map.getSource('some id').setClusterOptions({cluster: false, clusterRadius: 50, clusterMaxZoom: 14});
	 *
	 */
	setClusterOptions(options: SetClusterOptions): this;
	/**
	 * For clustered sources, fetches the zoom at which the given cluster expands.
	 *
	 * @param clusterId The value of the cluster's `cluster_id` property.
	 * @param callback A callback to be called when the zoom value is retrieved (`(error, zoom) => { ... }`).
	 * @returns {GeoJSONSource} this
	 */
	getClusterExpansionZoom(clusterId: number, callback: Callback<number>): this;
	/**
	 * For clustered sources, fetches the children of the given cluster on the next zoom level (as an array of GeoJSON features).
	 *
	 * @param clusterId The value of the cluster's `cluster_id` property.
	 * @param callback A callback to be called when the features are retrieved (`(error, features) => { ... }`).
	 * @returns {GeoJSONSource} this
	 */
	getClusterChildren(clusterId: number, callback: Callback<Array<GeoJSON.Feature>>): this;
	/**
	 * For clustered sources, fetches the original points that belong to the cluster (as an array of GeoJSON features).
	 *
	 * @param clusterId The value of the cluster's `cluster_id` property.
	 * @param limit The maximum number of features to return.
	 * @param offset The number of features to skip (e.g. for pagination).
	 * @param callback A callback to be called when the features are retrieved (`(error, features) => { ... }`).
	 * @returns {GeoJSONSource} this
	 * @example
	 * // Retrieve cluster leaves on click
	 * map.on('click', 'clusters', function(e) {
	 *   var features = map.queryRenderedFeatures(e.point, {
	 *     layers: ['clusters']
	 *   });
	 *
	 *   var clusterId = features[0].properties.cluster_id;
	 *   var pointCount = features[0].properties.point_count;
	 *   var clusterSource = map.getSource('clusters');
	 *
	 *   clusterSource.getClusterLeaves(clusterId, pointCount, 0, function(error, features) {
	 *     // Print cluster leaves in the console
	 *     console.log('Cluster leaves:', error, features);
	 *   })
	 * });
	 */
	getClusterLeaves(clusterId: number, limit: number, offset: number, callback: Callback<Array<GeoJSON.Feature>>): this;
	_updateWorkerData(diff?: GeoJSONSourceDiff): void;
	loaded(): boolean;
	loadTile(tile: Tile, callback: Callback<void>): void;
	abortTile(tile: Tile): void;
	unloadTile(tile: Tile): void;
	onRemove(): void;
	serialize(): any;
	hasTransition(): boolean;
}
export type CanvasSourceSpecification = {
	"type": "canvas";
	"coordinates": [
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		]
	];
	"animate"?: boolean;
	"canvas": string | HTMLCanvasElement;
};
export declare class CanvasSource extends ImageSource {
	options: CanvasSourceSpecification;
	animate: boolean;
	canvas: HTMLCanvasElement;
	width: number;
	height: number;
	play: () => void;
	pause: () => void;
	_playing: boolean;
	/**
	 * @private
	 */
	constructor(id: string, options: CanvasSourceSpecification, dispatcher: Dispatcher, eventedParent: Evented);
	/**
	 * Enables animation. The image will be copied from the canvas to the map on each frame.
	 * @method play
	 * @instance
	 * @memberof CanvasSource
	 */
	/**
	 * Disables animation. The map will display a static copy of the canvas image.
	 * @method pause
	 * @instance
	 * @memberof CanvasSource
	 */
	load(): void;
	/**
	 * Returns the HTML `canvas` element.
	 *
	 * @returns {HTMLCanvasElement} The HTML `canvas` element.
	 */
	getCanvas(): HTMLCanvasElement;
	onAdd(map: Map): void;
	onRemove(): void;
	prepare(): void;
	serialize(): any;
	hasTransition(): boolean;
	_hasInvalidDimensions(): boolean;
}
export type Coordinates = [
	[
		number,
		number
	],
	[
		number,
		number
	],
	[
		number,
		number
	],
	[
		number,
		number
	]
];
export declare class ImageSource extends Evented implements Source {
	type: string;
	id: string;
	minzoom: number;
	maxzoom: number;
	tileSize: number;
	url: string;
	coordinates: Coordinates;
	tiles: {
		[_: string]: Tile;
	};
	options: any;
	dispatcher: Dispatcher;
	map: Map;
	texture: Texture | null;
	image: HTMLImageElement | ImageBitmap;
	tileID: CanonicalTileID;
	_boundsArray: RasterBoundsArray;
	boundsBuffer: VertexBuffer;
	boundsSegments: SegmentVector;
	_loaded: boolean;
	_request: Cancelable;
	/**
	 * @private
	 */
	constructor(id: string, options: ImageSourceSpecification | VideoSourceSpecification | CanvasSourceSpecification, dispatcher: Dispatcher, eventedParent: Evented);
	load(newCoordinates?: Coordinates, successCallback?: () => void): void;
	loaded(): boolean;
	/**
	 * Updates the image URL and, optionally, the coordinates. To avoid having the image flash after changing,
	 * set the `raster-fade-duration` paint property on the raster layer to 0.
	 *
	 * @param {Object} options Options object.
	 * @param {string} [options.url] Required image URL.
	 * @param {Array<Array<number>>} [options.coordinates] Four geographical coordinates,
	 * represented as arrays of longitude and latitude numbers, which define the corners of the image.
	 * The coordinates start at the top left corner of the image and proceed in clockwise order.
	 * They do not have to represent a rectangle.
	 * @returns {ImageSource} this
	 */
	updateImage(options: {
		url: string;
		coordinates?: Coordinates;
	}): this;
	_finishLoading(): void;
	onAdd(map: Map): void;
	onRemove(): void;
	/**
	 * Sets the image's coordinates and re-renders the map.
	 *
	 * @param {Array<Array<number>>} coordinates Four geographical coordinates,
	 * represented as arrays of longitude and latitude numbers, which define the corners of the image.
	 * The coordinates start at the top left corner of the image and proceed in clockwise order.
	 * They do not have to represent a rectangle.
	 * @returns {ImageSource} this
	 */
	setCoordinates(coordinates: Coordinates): this;
	prepare(): void;
	loadTile(tile: Tile, callback: Callback<void>): void;
	serialize(): any;
	hasTransition(): boolean;
}
/**
 * The `Source` interface must be implemented by each source type, including "core" types (`vector`, `raster`,
 * `video`, etc.) and all custom, third-party types.
 *
 * @private
 *
 * @param {string} id The id for the source. Must not be used by any existing source.
 * @param {Object} options Source options, specific to the source type (except for `options.type`, which is always
 * required).
 * @param {string} options.type The source type, matching the value of `name` used in {@link Style#addSourceType}.
 * @param {Dispatcher} dispatcher A {@link Dispatcher} instance, which can be used to send messages to the workers.
 *
 * @fires data with `{dataType: 'source', sourceDataType: 'metadata'}` to indicate that any necessary metadata
 * has been loaded so that it's okay to call `loadTile`; and with `{dataType: 'source', sourceDataType: 'content'}`
 * to indicate that the source data has changed, so that any current caches should be flushed.
 * @property {string} id The id for the source.  Must match the id passed to the constructor.
 * @property {number} minzoom
 * @property {number} maxzoom
 * @property {boolean} isTileClipped `false` if tiles can be drawn outside their boundaries, `true` if they cannot.
 * @property {boolean} reparseOverscaled `true` if tiles should be sent back to the worker for each overzoomed zoom
 * level, `false` if not.
 * @property {boolean} roundZoom `true` if zoom levels are rounded to the nearest integer in the source data, `false`
 * if they are floor-ed to the nearest integer.
 */
export interface Source {
	readonly type: string;
	id: string;
	minzoom: number;
	maxzoom: number;
	tileSize: number;
	attribution?: string;
	roundZoom?: boolean;
	isTileClipped?: boolean;
	tileID?: CanonicalTileID;
	reparseOverscaled?: boolean;
	vectorLayerIds?: Array<string>;
	hasTransition(): boolean;
	loaded(): boolean;
	fire(event: Event): unknown;
	readonly onAdd?: (map: Map) => void;
	readonly onRemove?: (map: Map) => void;
	loadTile(tile: Tile, callback: Callback<void>): void;
	readonly hasTile?: (tileID: OverscaledTileID) => boolean;
	readonly abortTile?: (tile: Tile, callback: Callback<void>) => void;
	readonly unloadTile?: (tile: Tile, callback: Callback<void>) => void;
	/**
	 * @returns A plain (stringifiable) JS object representing the current state of the source.
	 * Creating a source using the returned object as the `options` should result in a Source that is
	 * equivalent to this one.
	 * @private
	 */
	serialize(): any;
	readonly prepare?: () => void;
}
export type SourceStatics = {
	workerSourceURL?: URL;
};
export type SourceClass = {
	new (...args: any): Source;
} & SourceStatics;
declare const getSourceType: (name: string) => any;
declare const setSourceType: (name: string, type: new (...args: any) => Source) => void;
export declare class SourceCache extends Evented {
	id: string;
	dispatcher: Dispatcher;
	map: Map;
	style: Style;
	_source: Source;
	_sourceLoaded: boolean;
	_sourceErrored: boolean;
	_tiles: {
		[_: string]: Tile;
	};
	_prevLng: number;
	_cache: TileCache;
	_timers: {
		[_ in any]: ReturnType<typeof setTimeout>;
	};
	_cacheTimers: {
		[_ in any]: ReturnType<typeof setTimeout>;
	};
	_maxTileCacheSize: number;
	_maxTileCacheZoomLevels: number;
	_paused: boolean;
	_shouldReloadOnResume: boolean;
	_coveredTiles: {
		[_: string]: boolean;
	};
	transform: Transform;
	terrain: Terrain;
	used: boolean;
	usedForTerrain: boolean;
	tileSize: number;
	_state: SourceFeatureState;
	_loadedParentTiles: {
		[_: string]: Tile;
	};
	_didEmitContent: boolean;
	_updated: boolean;
	static maxUnderzooming: number;
	static maxOverzooming: number;
	constructor(id: string, options: SourceSpecification, dispatcher: Dispatcher);
	onAdd(map: Map): void;
	onRemove(map: Map): void;
	/**
	 * Return true if no tile data is pending, tiles will not change unless
	 * an additional API call is received.
	 * @private
	 */
	loaded(): boolean;
	getSource(): Source;
	pause(): void;
	resume(): void;
	_loadTile(tile: Tile, callback: Callback<void>): void;
	_unloadTile(tile: Tile): void;
	_abortTile(tile: Tile): void;
	serialize(): any;
	prepare(context: Context): void;
	/**
	 * Return all tile ids ordered with z-order, and cast to numbers
	 * @private
	 */
	getIds(): Array<string>;
	getRenderableIds(symbolLayer?: boolean): Array<string>;
	hasRenderableParent(tileID: OverscaledTileID): boolean;
	_isIdRenderable(id: string, symbolLayer?: boolean): boolean;
	reload(): void;
	_reloadTile(id: string, state: TileState): void;
	_tileLoaded(tile: Tile, id: string, previousState: TileState, err?: Error | null): void;
	/**
	* For raster terrain source, backfill DEM to eliminate visible tile boundaries
	* @private
	*/
	_backfillDEM(tile: Tile): void;
	/**
	 * Get a specific tile by TileID
	 * @private
	 */
	getTile(tileID: OverscaledTileID): Tile;
	/**
	 * Get a specific tile by id
	 * @private
	 */
	getTileByID(id: string): Tile;
	/**
	 * For a given set of tiles, retain children that are loaded and have a zoom
	 * between `zoom` (exclusive) and `maxCoveringZoom` (inclusive)
	 * @private
	 */
	_retainLoadedChildren(idealTiles: {
		[_ in any]: OverscaledTileID;
	}, zoom: number, maxCoveringZoom: number, retain: {
		[_ in any]: OverscaledTileID;
	}): void;
	/**
	 * Find a loaded parent of the given tile (up to minCoveringZoom)
	 * @private
	 */
	findLoadedParent(tileID: OverscaledTileID, minCoveringZoom: number): Tile;
	_getLoadedTile(tileID: OverscaledTileID): Tile;
	/**
	 * Resizes the tile cache based on the current viewport's size
	 * or the maxTileCacheSize option passed during map creation
	 *
	 * Larger viewports use more tiles and need larger caches. Larger viewports
	 * are more likely to be found on devices with more memory and on pages where
	 * the map is more important.
	 * @private
	 */
	updateCacheSize(transform: Transform): void;
	handleWrapJump(lng: number): void;
	/**
	 * Removes tiles that are outside the viewport and adds new tiles that
	 * are inside the viewport.
	 * @private
	 */
	update(transform: Transform, terrain?: Terrain): void;
	releaseSymbolFadeTiles(): void;
	_updateRetainedTiles(idealTileIDs: Array<OverscaledTileID>, zoom: number): {
		[_: string]: OverscaledTileID;
	};
	_updateLoadedParentTileCache(): void;
	/**
	 * Add a tile, given its coordinate, to the pyramid.
	 * @private
	 */
	_addTile(tileID: OverscaledTileID): Tile;
	_setTileReloadTimer(id: string, tile: Tile): void;
	/**
	 * Remove a tile, given its id, from the pyramid
	 * @private
	 */
	_removeTile(id: string): void;
	/**
	 * Remove all tiles from this pyramid
	 */
	clearTiles(): void;
	/**
	 * Search through our current tiles and attempt to find the tiles that
	 * cover the given bounds.
	 * @param pointQueryGeometry coordinates of the corners of bounding rectangle
	 * @returns {Array<Object>} result items have {tile, minX, maxX, minY, maxY}, where min/max bounding values are the given bounds transformed in into the coordinate space of this tile.
	 * @private
	 */
	tilesIn(pointQueryGeometry: Array<Point>, maxPitchScaleFactor: number, has3DLayer: boolean): any[];
	getVisibleCoordinates(symbolLayer?: boolean): Array<OverscaledTileID>;
	hasTransition(): boolean;
	/**
	 * Set the value of a particular state for a feature
	 * @private
	 */
	setFeatureState(sourceLayer: string, featureId: number | string, state: any): void;
	/**
	 * Resets the value of a particular state key for a feature
	 * @private
	 */
	removeFeatureState(sourceLayer?: string, featureId?: number | string, key?: string): void;
	/**
	 * Get the entire state object for a feature
	 * @private
	 */
	getFeatureState(sourceLayer: string, featureId: number | string): any;
	/**
	 * Sets the set of keys that the tile depends on. This allows tiles to
	 * be reloaded when their dependencies change.
	 * @private
	 */
	setDependencies(tileKey: string, namespace: string, dependencies: Array<string>): void;
	/**
	 * Reloads all tiles that depend on the given keys.
	 * @private
	 */
	reloadTilesForDependencies(namespaces: Array<string>, keys: Array<string>): void;
}
declare enum WritingMode {
	none = 0,
	horizontal = 1,
	vertical = 2,
	horizontalOnly = 3
}
export declare class Anchor extends Point {
	angle: any;
	segment?: number;
	constructor(x: number, y: number, angle: number, segment?: number);
	clone(): Anchor;
}
export type SymbolLayoutProps = {
	"symbol-placement": DataConstantProperty<"point" | "line" | "line-center">;
	"symbol-spacing": DataConstantProperty<number>;
	"symbol-avoid-edges": DataConstantProperty<boolean>;
	"symbol-sort-key": DataDrivenProperty<number>;
	"symbol-z-order": DataConstantProperty<"auto" | "viewport-y" | "source">;
	"icon-allow-overlap": DataConstantProperty<boolean>;
	"icon-overlap": DataConstantProperty<"never" | "always" | "cooperative">;
	"icon-ignore-placement": DataConstantProperty<boolean>;
	"icon-optional": DataConstantProperty<boolean>;
	"icon-rotation-alignment": DataConstantProperty<"map" | "viewport" | "auto">;
	"icon-size": DataDrivenProperty<number>;
	"icon-text-fit": DataConstantProperty<"none" | "width" | "height" | "both">;
	"icon-text-fit-padding": DataConstantProperty<[
		number,
		number,
		number,
		number
	]>;
	"icon-image": DataDrivenProperty<ResolvedImage>;
	"icon-rotate": DataDrivenProperty<number>;
	"icon-padding": DataDrivenProperty<Padding>;
	"icon-keep-upright": DataConstantProperty<boolean>;
	"icon-offset": DataDrivenProperty<[
		number,
		number
	]>;
	"icon-anchor": DataDrivenProperty<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
	"icon-pitch-alignment": DataConstantProperty<"map" | "viewport" | "auto">;
	"text-pitch-alignment": DataConstantProperty<"map" | "viewport" | "auto">;
	"text-rotation-alignment": DataConstantProperty<"map" | "viewport" | "viewport-glyph" | "auto">;
	"text-field": DataDrivenProperty<Formatted>;
	"text-font": DataDrivenProperty<Array<string>>;
	"text-size": DataDrivenProperty<number>;
	"text-max-width": DataDrivenProperty<number>;
	"text-line-height": DataConstantProperty<number>;
	"text-letter-spacing": DataDrivenProperty<number>;
	"text-justify": DataDrivenProperty<"auto" | "left" | "center" | "right">;
	"text-radial-offset": DataDrivenProperty<number>;
	"text-variable-anchor": DataConstantProperty<Array<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">>;
	"text-anchor": DataDrivenProperty<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
	"text-max-angle": DataConstantProperty<number>;
	"text-writing-mode": DataConstantProperty<Array<"horizontal" | "vertical">>;
	"text-rotate": DataDrivenProperty<number>;
	"text-padding": DataConstantProperty<number>;
	"text-keep-upright": DataConstantProperty<boolean>;
	"text-transform": DataDrivenProperty<"none" | "uppercase" | "lowercase">;
	"text-offset": DataDrivenProperty<[
		number,
		number
	]>;
	"text-allow-overlap": DataConstantProperty<boolean>;
	"text-overlap": DataConstantProperty<"never" | "always" | "cooperative">;
	"text-ignore-placement": DataConstantProperty<boolean>;
	"text-optional": DataConstantProperty<boolean>;
};
export type SymbolLayoutPropsPossiblyEvaluated = {
	"symbol-placement": "point" | "line" | "line-center";
	"symbol-spacing": number;
	"symbol-avoid-edges": boolean;
	"symbol-sort-key": PossiblyEvaluatedPropertyValue<number>;
	"symbol-z-order": "auto" | "viewport-y" | "source";
	"icon-allow-overlap": boolean;
	"icon-overlap": "never" | "always" | "cooperative";
	"icon-ignore-placement": boolean;
	"icon-optional": boolean;
	"icon-rotation-alignment": "map" | "viewport" | "auto";
	"icon-size": PossiblyEvaluatedPropertyValue<number>;
	"icon-text-fit": "none" | "width" | "height" | "both";
	"icon-text-fit-padding": [
		number,
		number,
		number,
		number
	];
	"icon-image": PossiblyEvaluatedPropertyValue<ResolvedImage>;
	"icon-rotate": PossiblyEvaluatedPropertyValue<number>;
	"icon-padding": PossiblyEvaluatedPropertyValue<Padding>;
	"icon-keep-upright": boolean;
	"icon-offset": PossiblyEvaluatedPropertyValue<[
		number,
		number
	]>;
	"icon-anchor": PossiblyEvaluatedPropertyValue<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
	"icon-pitch-alignment": "map" | "viewport" | "auto";
	"text-pitch-alignment": "map" | "viewport" | "auto";
	"text-rotation-alignment": "map" | "viewport" | "viewport-glyph" | "auto";
	"text-field": PossiblyEvaluatedPropertyValue<Formatted>;
	"text-font": PossiblyEvaluatedPropertyValue<Array<string>>;
	"text-size": PossiblyEvaluatedPropertyValue<number>;
	"text-max-width": PossiblyEvaluatedPropertyValue<number>;
	"text-line-height": number;
	"text-letter-spacing": PossiblyEvaluatedPropertyValue<number>;
	"text-justify": PossiblyEvaluatedPropertyValue<"auto" | "left" | "center" | "right">;
	"text-radial-offset": PossiblyEvaluatedPropertyValue<number>;
	"text-variable-anchor": Array<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
	"text-anchor": PossiblyEvaluatedPropertyValue<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
	"text-max-angle": number;
	"text-writing-mode": Array<"horizontal" | "vertical">;
	"text-rotate": PossiblyEvaluatedPropertyValue<number>;
	"text-padding": number;
	"text-keep-upright": boolean;
	"text-transform": PossiblyEvaluatedPropertyValue<"none" | "uppercase" | "lowercase">;
	"text-offset": PossiblyEvaluatedPropertyValue<[
		number,
		number
	]>;
	"text-allow-overlap": boolean;
	"text-overlap": "never" | "always" | "cooperative";
	"text-ignore-placement": boolean;
	"text-optional": boolean;
};
export type SymbolPaintProps = {
	"icon-opacity": DataDrivenProperty<number>;
	"icon-color": DataDrivenProperty<Color>;
	"icon-halo-color": DataDrivenProperty<Color>;
	"icon-halo-width": DataDrivenProperty<number>;
	"icon-halo-blur": DataDrivenProperty<number>;
	"icon-translate": DataConstantProperty<[
		number,
		number
	]>;
	"icon-translate-anchor": DataConstantProperty<"map" | "viewport">;
	"text-opacity": DataDrivenProperty<number>;
	"text-color": DataDrivenProperty<Color>;
	"text-halo-color": DataDrivenProperty<Color>;
	"text-halo-width": DataDrivenProperty<number>;
	"text-halo-blur": DataDrivenProperty<number>;
	"text-translate": DataConstantProperty<[
		number,
		number
	]>;
	"text-translate-anchor": DataConstantProperty<"map" | "viewport">;
};
export type SymbolPaintPropsPossiblyEvaluated = {
	"icon-opacity": PossiblyEvaluatedPropertyValue<number>;
	"icon-color": PossiblyEvaluatedPropertyValue<Color>;
	"icon-halo-color": PossiblyEvaluatedPropertyValue<Color>;
	"icon-halo-width": PossiblyEvaluatedPropertyValue<number>;
	"icon-halo-blur": PossiblyEvaluatedPropertyValue<number>;
	"icon-translate": [
		number,
		number
	];
	"icon-translate-anchor": "map" | "viewport";
	"text-opacity": PossiblyEvaluatedPropertyValue<number>;
	"text-color": PossiblyEvaluatedPropertyValue<Color>;
	"text-halo-color": PossiblyEvaluatedPropertyValue<Color>;
	"text-halo-width": PossiblyEvaluatedPropertyValue<number>;
	"text-halo-blur": PossiblyEvaluatedPropertyValue<number>;
	"text-translate": [
		number,
		number
	];
	"text-translate-anchor": "map" | "viewport";
};
export declare class SymbolStyleLayer extends StyleLayer {
	_unevaluatedLayout: Layout<SymbolLayoutProps>;
	layout: PossiblyEvaluated<SymbolLayoutProps, SymbolLayoutPropsPossiblyEvaluated>;
	_transitionablePaint: Transitionable<SymbolPaintProps>;
	_transitioningPaint: Transitioning<SymbolPaintProps>;
	paint: PossiblyEvaluated<SymbolPaintProps, SymbolPaintPropsPossiblyEvaluated>;
	constructor(layer: LayerSpecification);
	recalculate(parameters: EvaluationParameters, availableImages: Array<string>): void;
	getValueAndResolveTokens(name: any, feature: Feature, canonical: CanonicalTileID, availableImages: Array<string>): any;
	createBucket(parameters: BucketParameters<any>): SymbolBucket;
	queryRadius(): number;
	queryIntersectsFeature(): boolean;
	_setPaintOverrides(): void;
	_handleOverridablePaintPropertyUpdate<T, R>(name: string, oldValue: PropertyValue<T, R>, newValue: PropertyValue<T, R>): boolean;
	static hasPaintOverride(layout: PossiblyEvaluated<SymbolLayoutProps, SymbolLayoutPropsPossiblyEvaluated>, propertyName: string): boolean;
}
/**
 * A textured quad for rendering a single icon or glyph.
 *
 * The zoom range the glyph can be shown is defined by minScale and maxScale.
 *
 * @param tl The offset of the top left corner from the anchor.
 * @param tr The offset of the top right corner from the anchor.
 * @param bl The offset of the bottom left corner from the anchor.
 * @param br The offset of the bottom right corner from the anchor.
 * @param tex The texture coordinates.
 *
 * @private
 */
export type SymbolQuad = {
	tl: Point;
	tr: Point;
	bl: Point;
	br: Point;
	tex: {
		x: number;
		y: number;
		w: number;
		h: number;
	};
	pixelOffsetTL: Point;
	pixelOffsetBR: Point;
	writingMode: any | void;
	glyphOffset: [
		number,
		number
	];
	sectionIndex: number;
	isSDF: boolean;
	minFontScaleX: number;
	minFontScaleY: number;
};
export type SizeData = {
	kind: "constant";
	layoutSize: number;
} | {
	kind: "source";
} | {
	kind: "camera";
	minZoom: number;
	maxZoom: number;
	minSize: number;
	maxSize: number;
	interpolationType: InterpolationType;
} | {
	kind: "composite";
	minZoom: number;
	maxZoom: number;
	interpolationType: InterpolationType;
};
export type SingleCollisionBox = {
	x1: number;
	y1: number;
	x2: number;
	y2: number;
	anchorPointX: number;
	anchorPointY: number;
};
export type CollisionArrays = {
	textBox?: SingleCollisionBox;
	verticalTextBox?: SingleCollisionBox;
	iconBox?: SingleCollisionBox;
	verticalIconBox?: SingleCollisionBox;
	textFeatureIndex?: number;
	verticalTextFeatureIndex?: number;
	iconFeatureIndex?: number;
	verticalIconFeatureIndex?: number;
};
export type SymbolFeature = {
	sortKey: number | void;
	text: Formatted | void;
	icon: ResolvedImage;
	index: number;
	sourceLayerIndex: number;
	geometry: Array<Array<Point>>;
	properties: any;
	type: "Point" | "LineString" | "Polygon";
	id?: any;
};
export type SortKeyRange = {
	sortKey: number;
	symbolInstanceStart: number;
	symbolInstanceEnd: number;
};
declare function addDynamicAttributes(dynamicLayoutVertexArray: StructArray, p: Point, angle: number): void;
export declare class SymbolBuffers {
	layoutVertexArray: SymbolLayoutArray;
	layoutVertexBuffer: VertexBuffer;
	indexArray: TriangleIndexArray;
	indexBuffer: IndexBuffer;
	programConfigurations: ProgramConfigurationSet<SymbolStyleLayer>;
	segments: SegmentVector;
	dynamicLayoutVertexArray: SymbolDynamicLayoutArray;
	dynamicLayoutVertexBuffer: VertexBuffer;
	opacityVertexArray: SymbolOpacityArray;
	opacityVertexBuffer: VertexBuffer;
	hasVisibleVertices: boolean;
	collisionVertexArray: CollisionVertexArray;
	collisionVertexBuffer: VertexBuffer;
	placedSymbolArray: PlacedSymbolArray;
	constructor(programConfigurations: ProgramConfigurationSet<SymbolStyleLayer>);
	isEmpty(): boolean;
	upload(context: Context, dynamicIndexBuffer: boolean, upload?: boolean, update?: boolean): void;
	destroy(): void;
}
export declare class CollisionBuffers {
	layoutVertexArray: StructArray;
	layoutAttributes: Array<StructArrayMember>;
	layoutVertexBuffer: VertexBuffer;
	indexArray: TriangleIndexArray | LineIndexArray;
	indexBuffer: IndexBuffer;
	segments: SegmentVector;
	collisionVertexArray: CollisionVertexArray;
	collisionVertexBuffer: VertexBuffer;
	constructor(LayoutArray: {
		new (...args: any): StructArray;
	}, layoutAttributes: Array<StructArrayMember>, IndexArray: {
		new (...args: any): TriangleIndexArray | LineIndexArray;
	});
	upload(context: Context): void;
	destroy(): void;
}
export declare class SymbolBucket implements Bucket {
	static MAX_GLYPHS: number;
	static addDynamicAttributes: typeof addDynamicAttributes;
	collisionBoxArray: CollisionBoxArray;
	zoom: number;
	overscaling: number;
	layers: Array<SymbolStyleLayer>;
	layerIds: Array<string>;
	stateDependentLayers: Array<SymbolStyleLayer>;
	stateDependentLayerIds: Array<string>;
	index: number;
	sdfIcons: boolean;
	iconsInText: boolean;
	iconsNeedLinear: boolean;
	bucketInstanceId: number;
	justReloaded: boolean;
	hasPattern: boolean;
	textSizeData: SizeData;
	iconSizeData: SizeData;
	glyphOffsetArray: GlyphOffsetArray;
	lineVertexArray: SymbolLineVertexArray;
	features: Array<SymbolFeature>;
	symbolInstances: SymbolInstanceArray;
	collisionArrays: Array<CollisionArrays>;
	sortKeyRanges: Array<SortKeyRange>;
	pixelRatio: number;
	tilePixelRatio: number;
	compareText: {
		[_: string]: Array<Point>;
	};
	fadeStartTime: number;
	sortFeaturesByKey: boolean;
	sortFeaturesByY: boolean;
	canOverlap: boolean;
	sortedAngle: number;
	featureSortOrder: Array<number>;
	collisionCircleArray: Array<number>;
	placementInvProjMatrix: mat4;
	placementViewportMatrix: mat4;
	text: SymbolBuffers;
	icon: SymbolBuffers;
	textCollisionBox: CollisionBuffers;
	iconCollisionBox: CollisionBuffers;
	uploaded: boolean;
	sourceLayerIndex: number;
	sourceID: string;
	symbolInstanceIndexes: Array<number>;
	writingModes: WritingMode[];
	allowVerticalPlacement: boolean;
	hasRTLText: boolean;
	constructor(options: BucketParameters<SymbolStyleLayer>);
	createArrays(): void;
	calculateGlyphDependencies(text: string, stack: {
		[_: number]: boolean;
	}, textAlongLine: boolean, allowVerticalPlacement: boolean, doesAllowVerticalWritingMode: boolean): void;
	populate(features: Array<IndexedFeature>, options: PopulateParameters, canonical: CanonicalTileID): void;
	update(states: FeatureStates, vtLayer: VectorTileLayer, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	isEmpty(): boolean;
	uploadPending(): boolean;
	upload(context: Context): void;
	destroyDebugData(): void;
	destroy(): void;
	addToLineVertexArray(anchor: Anchor, line: any): {
		lineStartIndex: number;
		lineLength: number;
	};
	addSymbols(arrays: SymbolBuffers, quads: Array<SymbolQuad>, sizeVertex: any, lineOffset: [
		number,
		number
	], alongLine: boolean, feature: SymbolFeature, writingMode: WritingMode, labelAnchor: Anchor, lineStartIndex: number, lineLength: number, associatedIconIndex: number, canonical: CanonicalTileID): void;
	_addCollisionDebugVertex(layoutVertexArray: StructArray, collisionVertexArray: StructArray, point: Point, anchorX: number, anchorY: number, extrude: Point): any;
	addCollisionDebugVertices(x1: number, y1: number, x2: number, y2: number, arrays: CollisionBuffers, boxAnchorPoint: Point, symbolInstance: SymbolInstance): void;
	addDebugCollisionBoxes(startIndex: number, endIndex: number, symbolInstance: SymbolInstance, isText: boolean): void;
	generateCollisionDebugBuffers(): void;
	_deserializeCollisionBoxesForSymbol(collisionBoxArray: CollisionBoxArray, textStartIndex: number, textEndIndex: number, verticalTextStartIndex: number, verticalTextEndIndex: number, iconStartIndex: number, iconEndIndex: number, verticalIconStartIndex: number, verticalIconEndIndex: number): CollisionArrays;
	deserializeCollisionBoxes(collisionBoxArray: CollisionBoxArray): void;
	hasTextData(): boolean;
	hasIconData(): boolean;
	hasDebugData(): CollisionBuffers;
	hasTextCollisionBoxData(): boolean;
	hasIconCollisionBoxData(): boolean;
	addIndicesForPlacedSymbol(iconOrText: SymbolBuffers, placedSymbolIndex: number): void;
	getSortedSymbolIndexes(angle: number): any[];
	addToSortKeyRanges(symbolInstanceIndex: number, sortKey: number): void;
	sortFeatures(angle: number): void;
}
export interface SymbolsByKeyEntry {
	index?: KDBush;
	positions?: {
		x: number;
		y: number;
	}[];
	crossTileIDs: number[];
}
export declare class TileLayerIndex {
	tileID: OverscaledTileID;
	bucketInstanceId: number;
	_symbolsByKey: Record<number, SymbolsByKeyEntry>;
	constructor(tileID: OverscaledTileID, symbolInstances: SymbolInstanceArray, bucketInstanceId: number);
	getScaledCoordinates(symbolInstance: SymbolInstance, childTileID: OverscaledTileID): {
		x: number;
		y: number;
	};
	findMatches(symbolInstances: SymbolInstanceArray, newTileID: OverscaledTileID, zoomCrossTileIDs: {
		[crossTileID: number]: boolean;
	}): void;
	getCrossTileIDsLists(): number[][];
}
export declare class CrossTileIDs {
	maxCrossTileID: number;
	constructor();
	generate(): number;
}
export declare class CrossTileSymbolLayerIndex {
	indexes: {
		[zoom in string | number]: {
			[tileId in string | number]: TileLayerIndex;
		};
	};
	usedCrossTileIDs: {
		[zoom in string | number]: {
			[crossTileID: number]: boolean;
		};
	};
	lng: number;
	constructor();
	handleWrapJump(lng: number): void;
	addBucket(tileID: OverscaledTileID, bucket: SymbolBucket, crossTileIDs: CrossTileIDs): boolean;
	removeBucketCrossTileIDs(zoom: string | number, removedBucket: TileLayerIndex): void;
	removeStaleBuckets(currentIDs: {
		[k in string | number]: boolean;
	}): boolean;
}
export declare class CrossTileSymbolIndex {
	layerIndexes: {
		[layerId: string]: CrossTileSymbolLayerIndex;
	};
	crossTileIDs: CrossTileIDs;
	maxBucketInstanceId: number;
	bucketsInCurrentPlacement: {
		[_: number]: boolean;
	};
	constructor();
	addLayer(styleLayer: StyleLayer, tiles: Array<Tile>, lng: number): boolean;
	pruneUnusedLayers(usedLayers: Array<string>): void;
}
export declare class LineAtlas {
	width: number;
	height: number;
	nextRow: number;
	bytes: number;
	data: Uint8Array;
	dashEntry: {
		[_: string]: any;
	};
	dirty: boolean;
	texture: WebGLTexture;
	constructor(width: number, height: number);
	/**
	 * Get or create a dash line pattern.
	 *
	 * @param {Array<number>} dasharray
	 * @param {boolean} round whether to add circle caps in between dash segments
	 * @returns {Object} position of dash texture in { y, height, width }
	 * @private
	 */
	getDash(dasharray: Array<number>, round: boolean): any;
	getDashRanges(dasharray: Array<number>, lineAtlasWidth: number, stretch: number): any[];
	addRoundDash(ranges: any, stretch: number, n: number): void;
	addRegularDash(ranges: any): void;
	addDash(dasharray: Array<number>, round: boolean): {
		y: number;
		height: number;
		width: number;
	};
	bind(context: Context): void;
}
declare function loadGlyphRange(fontstack: string, range: number, urlTemplate: string, requestManager: RequestManager, callback: Callback<{
	[_: number]: StyleGlyph | null;
}>): void;
export type Entry = {
	glyphs: {
		[id: number]: StyleGlyph | null;
	};
	requests: {
		[range: number]: Array<Callback<{
			[_: number]: StyleGlyph | null;
		}>>;
	};
	ranges: {
		[range: number]: boolean | null;
	};
	tinySDF?: TinySDF;
};
export declare class GlyphManager {
	requestManager: RequestManager;
	localIdeographFontFamily: string;
	entries: {
		[_: string]: Entry;
	};
	url: string;
	static loadGlyphRange: typeof loadGlyphRange;
	static TinySDF: typeof TinySDF;
	constructor(requestManager: RequestManager, localIdeographFontFamily?: string | null);
	setURL(url?: string | null): void;
	getGlyphs(glyphs: {
		[stack: string]: Array<number>;
	}, callback: Callback<{
		[stack: string]: {
			[id: number]: StyleGlyph;
		};
	}>): void;
	_doesCharSupportLocalGlyph(id: number): boolean;
	_tinySDF(entry: Entry, stack: string, id: number): StyleGlyph;
}
export type PoolObject = {
	id: number;
	fbo: Framebuffer;
	texture: Texture;
	stamp: number;
	inUse: boolean;
};
export declare class RenderPool {
	private readonly _context;
	private readonly _size;
	private readonly _tileSize;
	private _objects;
	/**
	 * @property {Array<number>} _recentlyUsed An index array of recently used pool objects.
	 * Items that are used recently are last in the array
	 */
	private _recentlyUsed;
	private _stamp;
	constructor(_context: Context, _size: number, _tileSize: number);
	destruct(): void;
	private _createObject;
	getObjectForId(id: number): PoolObject;
	useObject(obj: PoolObject): void;
	stampObject(obj: PoolObject): void;
	getOrCreateFreeObject(): PoolObject;
	freeObject(obj: PoolObject): void;
	freeAllObjects(): void;
	isFull(): boolean;
}
export declare class RenderToTexture {
	painter: Painter;
	terrain: Terrain;
	pool: RenderPool;
	_coordsDescendingInv: {
		[_: string]: {
			[_: string]: Array<OverscaledTileID>;
		};
	};
	_coordsDescendingInvStr: {
		[_: string]: {
			[_: string]: string;
		};
	};
	_stacks: Array<Array<string>>;
	_prevType: string;
	_renderableTiles: Array<Tile>;
	_rttTiles: Array<Tile>;
	_renderableLayerIds: Array<string>;
	constructor(painter: Painter, terrain: Terrain);
	destruct(): void;
	getTexture(tile: Tile): Texture;
	prepareForRender(style: Style, zoom: number): void;
	/**
	 * due that switching textures is relatively slow, the render
	 * layer-by-layer context is not practicable. To bypass this problem
	 * this lines of code stack all layers and later render all at once.
	 * Because of the stylesheet possibility to mixing render-to-texture layers
	 * and 'live'-layers (f.e. symbols) it is necessary to create more stacks. For example
	 * a symbol-layer is in between of fill-layers.
	 * @param {StyleLayer} layer the layer to render
	 * @returns {boolean} if true layer is rendered to texture, otherwise false
	 */
	renderLayer(layer: StyleLayer): boolean;
}
export type RenderPass = "offscreen" | "opaque" | "translucent";
export type PainterOptions = {
	showOverdrawInspector: boolean;
	showTileBoundaries: boolean;
	showPadding: boolean;
	rotating: boolean;
	zooming: boolean;
	moving: boolean;
	fadeDuration: number;
};
export declare class Painter {
	context: Context;
	transform: Transform;
	renderToTexture: RenderToTexture;
	_tileTextures: {
		[_: number]: Array<Texture>;
	};
	numSublayers: number;
	depthEpsilon: number;
	emptyProgramConfiguration: ProgramConfiguration;
	width: number;
	height: number;
	pixelRatio: number;
	tileExtentBuffer: VertexBuffer;
	tileExtentSegments: SegmentVector;
	debugBuffer: VertexBuffer;
	debugSegments: SegmentVector;
	rasterBoundsBuffer: VertexBuffer;
	rasterBoundsSegments: SegmentVector;
	viewportBuffer: VertexBuffer;
	viewportSegments: SegmentVector;
	quadTriangleIndexBuffer: IndexBuffer;
	tileBorderIndexBuffer: IndexBuffer;
	_tileClippingMaskIDs: {
		[_: string]: number;
	};
	stencilClearMode: StencilMode;
	style: Style;
	options: PainterOptions;
	lineAtlas: LineAtlas;
	imageManager: ImageManager;
	glyphManager: GlyphManager;
	depthRangeFor3D: DepthRangeType;
	opaquePassCutoff: number;
	renderPass: RenderPass;
	currentLayer: number;
	currentStencilSource: string;
	nextStencilID: number;
	id: string;
	_showOverdrawInspector: boolean;
	cache: {
		[_: string]: Program<any>;
	};
	crossTileSymbolIndex: CrossTileSymbolIndex;
	symbolFadeChange: number;
	debugOverlayTexture: Texture;
	debugOverlayCanvas: HTMLCanvasElement;
	terrainFacilitator: {
		dirty: boolean;
		matrix: mat4;
		renderTime: number;
	};
	constructor(gl: WebGLRenderingContext | WebGL2RenderingContext, transform: Transform);
	resize(width: number, height: number, pixelRatio: number): void;
	setup(): void;
	clearStencil(): void;
	_renderTileClippingMasks(layer: StyleLayer, tileIDs: Array<OverscaledTileID>): void;
	stencilModeFor3D(): StencilMode;
	stencilModeForClipping(tileID: OverscaledTileID): StencilMode;
	stencilConfigForOverlap(tileIDs: Array<OverscaledTileID>): [
		{
			[_: number]: Readonly<StencilMode>;
		},
		Array<OverscaledTileID>
	];
	colorModeForRenderPass(): Readonly<ColorMode>;
	depthModeForSublayer(n: number, mask: DepthMaskType, func?: DepthFuncType | null): Readonly<DepthMode>;
	opaquePassEnabledForLayer(): boolean;
	render(style: Style, options: PainterOptions): void;
	renderLayer(painter: Painter, sourceCache: SourceCache, layer: StyleLayer, coords: Array<OverscaledTileID>): void;
	/**
	 * Transform a matrix to incorporate the *-translate and *-translate-anchor properties into it.
	 * @param inViewportPixelUnitsUnits True when the units accepted by the matrix are in viewport pixels instead of tile units.
	 * @returns {mat4} matrix
	 * @private
	 */
	translatePosMatrix(matrix: mat4, tile: Tile, translate: [
		number,
		number
	], translateAnchor: "map" | "viewport", inViewportPixelUnitsUnits?: boolean): mat4;
	saveTileTexture(texture: Texture): void;
	getTileTexture(size: number): Texture;
	/**
	 * Checks whether a pattern image is needed, and if it is, whether it is not loaded.
	 *
	 * @returns true if a needed image is missing and rendering needs to be skipped.
	 * @private
	 */
	isPatternMissing(image?: CrossFaded<ResolvedImage> | null): boolean;
	useProgram(name: string, programConfiguration?: ProgramConfiguration | null): Program<any>;
	setCustomLayerDefaults(): void;
	setBaseState(): void;
	initDebugOverlayCanvas(): void;
	destroy(): void;
}
export declare class TerrainSourceCache extends Evented {
	sourceCache: SourceCache;
	_tiles: {
		[_: string]: Tile;
	};
	_renderableTilesKeys: Array<string>;
	_sourceTileCache: {
		[_: string]: string;
	};
	minzoom: number;
	maxzoom: number;
	tileSize: number;
	deltaZoom: number;
	constructor(sourceCache: SourceCache);
	destruct(): void;
	/**
	 * Load Terrain Tiles, create internal render-to-texture tiles, free GPU memory.
	 * @param {Transform} transform - the operation to do
	 * @param {Terrain} terrain - the terrain
	 */
	update(transform: Transform, terrain: Terrain): void;
	/**
	 * Free render to texture cache
	 * @param {TileID} tileID optional, free only corresponding to tileID.
	 */
	freeRtt(tileID?: OverscaledTileID): void;
	/**
	 * get a list of tiles, which are loaded and should be rendered in the current scene
	 * @returns {Array<Tile>} the renderable tiles
	 */
	getRenderableTiles(): Array<Tile>;
	/**
	 * get terrain tile by the TileID key
	 * @param id - the tile id
	 * @returns {Tile} - the tile
	 */
	getTileByID(id: string): Tile;
	/**
	 * Searches for the corresponding current renderable terrain-tiles
	 * @param {OverscaledTileID} tileID - the tile to look for
	 * @returns {Record<string, OverscaledTileID>} - the tiles that were found
	 */
	getTerrainCoords(tileID: OverscaledTileID): Record<string, OverscaledTileID>;
	/**
	 * find the covering raster-dem tile
	 * @param {OverscaledTileID} tileID - the tile to look for
	 * @param {boolean} searchForDEM Optinal parameter to search for (parent) souretiles with loaded dem.
	 * @returns {Tile} - the tile
	 */
	getSourceTile(tileID: OverscaledTileID, searchForDEM?: boolean): Tile;
	/**
	 * get a list of tiles, loaded after a spezific time. This is used to update depth & coords framebuffers.
	 * @param {Date} time - the time
	 * @returns {Array<Tile>} - the relevant tiles
	 */
	tilesAfterTime(time?: number): Array<Tile>;
}
export type TerrainData = {
	"u_depth": number;
	"u_terrain": number;
	"u_terrain_dim": number;
	"u_terrain_matrix": mat4;
	"u_terrain_unpack": number[];
	"u_terrain_exaggeration": number;
	texture: WebGLTexture;
	depthTexture: WebGLTexture;
	tile: Tile;
};
export type TerrainMesh = {
	indexBuffer: IndexBuffer;
	vertexBuffer: VertexBuffer;
	segments: SegmentVector;
};
export declare class Terrain {
	painter: Painter;
	sourceCache: TerrainSourceCache;
	options: TerrainSpecification;
	meshSize: number;
	exaggeration: number;
	qualityFactor: number;
	_fbo: Framebuffer;
	_fboCoordsTexture: Texture;
	_fboDepthTexture: Texture;
	_emptyDepthTexture: Texture;
	_mesh: TerrainMesh;
	coordsIndex: Array<string>;
	_coordsTexture: Texture;
	_coordsTextureSize: number;
	_emptyDemUnpack: number[];
	_emptyDemTexture: Texture;
	_emptyDemMatrix: mat4;
	_demMatrixCache: {
		[_: string]: {
			matrix: mat4;
			coord: OverscaledTileID;
		};
	};
	constructor(painter: Painter, sourceCache: SourceCache, options: TerrainSpecification);
	/**
	 * get the elevation-value from original dem-data for a given tile-coordinate
	 * @param {OverscaledTileID} tileID - the tile to get elevation for
	 * @param {number} x between 0 .. EXTENT
	 * @param {number} y between 0 .. EXTENT
	 * @param {number} extent optional, default 8192
	 * @returns {number} - the elevation
	 */
	getDEMElevation(tileID: OverscaledTileID, x: number, y: number, extent?: number): number;
	/**
	 * get the Elevation for given coordinate in respect of exaggeration.
	 * @param {OverscaledTileID} tileID - the tile id
	 * @param {number} x between 0 .. EXTENT
	 * @param {number} y between 0 .. EXTENT
	 * @param {number} extent optional, default 8192
	 * @returns {number} - the elevation
	 */
	getElevation(tileID: OverscaledTileID, x: number, y: number, extent?: number): number;
	/**
	 * returns a Terrain Object for a tile. Unless the tile corresponds to data (e.g. tile is loading), return a flat dem object
	 * @param {OverscaledTileID} tileID - the tile to get the terrain for
	 * @returns {TerrainData} the terrain data to use in the program
	 */
	getTerrainData(tileID: OverscaledTileID): TerrainData;
	/**
	 * get a framebuffer as big as the map-div, which will be used to render depth & coords into a texture
	 * @param {string} texture - the texture
	 * @returns {Framebuffer} the frame buffer
	 */
	getFramebuffer(texture: string): Framebuffer;
	/**
	 * create coords texture, needed to grab coordinates from canvas
	 * encode coords coordinate into 4 bytes:
	 *   - 8 lower bits for x
	 *   - 8 lower bits for y
	 *   - 4 higher bits for x
	 *   - 4 higher bits for y
	 *   - 8 bits for coordsIndex (1 .. 255) (= number of terraintile), is later setted in draw_terrain uniform value
	 * @returns {Texture} - the texture
	 */
	getCoordsTexture(): Texture;
	/**
	 * Reads a pixel from the coords-framebuffer and translate this to mercator.
	 * @param {Point} p Screen-Coordinate
	 * @returns {MercatorCoordinate} mercator coordinate for a screen pixel
	 */
	pointCoordinate(p: Point): MercatorCoordinate;
	/**
	 * create a regular mesh which will be used by all terrain-tiles
	 * @returns {TerrainMesh} - the created regular mesh
	 */
	getTerrainMesh(): TerrainMesh;
	/**
	 * Calculates a height of the frame around the terrain-mesh to avoid stiching between
	 * tile boundaries in different zoomlevels.
	 * @param zoom current zoomlevel
	 * @returns the elevation delta in meters
	 */
	getMeshFrameDelta(zoom: number): number;
	/**
	 * Get the minimum and maximum elevation contained in a tile. This includes any
	 * exaggeration included in the terrain.
	 *
	 * @param tileID Id of the tile to be used as a source for the min/max elevation
	 * @returns {Object} Minimum and maximum elevation found in the tile, including the terrain's
	 * exaggeration
	 */
	getMinMaxElevation(tileID: OverscaledTileID): {
		minElevation: number | null;
		maxElevation: number | null;
	};
}
export declare class Transform {
	tileSize: number;
	tileZoom: number;
	lngRange: [
		number,
		number
	];
	latRange: [
		number,
		number
	];
	maxValidLatitude: number;
	scale: number;
	width: number;
	height: number;
	angle: number;
	rotationMatrix: mat2;
	pixelsToGLUnits: [
		number,
		number
	];
	cameraToCenterDistance: number;
	cameraToSeaLevelDistance: number;
	mercatorMatrix: mat4;
	projMatrix: mat4;
	invProjMatrix: mat4;
	alignedProjMatrix: mat4;
	pixelMatrix: mat4;
	pixelMatrix3D: mat4;
	pixelMatrixInverse: mat4;
	glCoordMatrix: mat4;
	labelPlaneMatrix: mat4;
	freezeElevation: boolean;
	_fov: number;
	_pitch: number;
	_zoom: number;
	_unmodified: boolean;
	_renderWorldCopies: boolean;
	_minZoom: number;
	_maxZoom: number;
	_minPitch: number;
	_maxPitch: number;
	_center: LngLat;
	_elevation: number;
	_pixelPerMeter: number;
	_edgeInsets: EdgeInsets;
	_constraining: boolean;
	_posMatrixCache: {
		[_: string]: mat4;
	};
	_alignedPosMatrixCache: {
		[_: string]: mat4;
	};
	constructor(minZoom?: number, maxZoom?: number, minPitch?: number, maxPitch?: number, renderWorldCopies?: boolean);
	clone(): Transform;
	apply(that: Transform): void;
	get minZoom(): number;
	set minZoom(zoom: number);
	get maxZoom(): number;
	set maxZoom(zoom: number);
	get minPitch(): number;
	set minPitch(pitch: number);
	get maxPitch(): number;
	set maxPitch(pitch: number);
	get renderWorldCopies(): boolean;
	set renderWorldCopies(renderWorldCopies: boolean);
	get worldSize(): number;
	get centerOffset(): Point;
	get size(): Point;
	get bearing(): number;
	set bearing(bearing: number);
	get pitch(): number;
	set pitch(pitch: number);
	get fov(): number;
	set fov(fov: number);
	get zoom(): number;
	set zoom(zoom: number);
	get center(): LngLat;
	set center(center: LngLat);
	get elevation(): number;
	set elevation(elevation: number);
	get padding(): PaddingOptions;
	set padding(padding: PaddingOptions);
	/**
	 * The center of the screen in pixels with the top-left corner being (0,0)
	 * and +y axis pointing downwards. This accounts for padding.
	 *
	 * @readonly
	 * @type {Point}
	 * @memberof Transform
	 */
	get centerPoint(): Point;
	/**
	 * Returns if the padding params match
	 *
	 * @param {PaddingOptions} padding the padding to check against
	 * @returns {boolean} true if they are equal, false otherwise
	 * @memberof Transform
	 */
	isPaddingEqual(padding: PaddingOptions): boolean;
	/**
	 * Helper method to update edge-insets in place
	 *
	 * @param {PaddingOptions} start the starting padding
	 * @param {PaddingOptions} target the target padding
	 * @param {number} t the step/weight
	 * @memberof Transform
	 */
	interpolatePadding(start: PaddingOptions, target: PaddingOptions, t: number): void;
	/**
	 * Return a zoom level that will cover all tiles the transform
	 * @param {Object} options options
	 * @param {number} options.tileSize Tile size, expressed in screen pixels.
	 * @param {boolean} options.roundZoom Target zoom level. If true, the value will be rounded to the closest integer. Otherwise the value will be floored.
	 * @returns {number} zoom level An integer zoom level at which all tiles will be visible.
	 */
	coveringZoomLevel(options: {
		roundZoom?: boolean;
		tileSize: number;
	}): number;
	/**
	 * Return any "wrapped" copies of a given tile coordinate that are visible
	 * in the current view.
	 *
	 * @private
	 */
	getVisibleUnwrappedCoordinates(tileID: CanonicalTileID): UnwrappedTileID[];
	/**
	 * Return all coordinates that could cover this transform for a covering
	 * zoom level.
	 * @param {Object} options
	 * @param {number} options.tileSize
	 * @param {number} options.minzoom
	 * @param {number} options.maxzoom
	 * @param {boolean} options.roundZoom
	 * @param {boolean} options.reparseOverscaled
	 * @param {boolean} options.renderWorldCopies
	 * @returns {Array<OverscaledTileID>} OverscaledTileIDs
	 * @private
	 */
	coveringTiles(options: {
		tileSize: number;
		minzoom?: number;
		maxzoom?: number;
		roundZoom?: boolean;
		reparseOverscaled?: boolean;
		renderWorldCopies?: boolean;
		terrain?: Terrain;
	}): Array<OverscaledTileID>;
	resize(width: number, height: number): void;
	get unmodified(): boolean;
	zoomScale(zoom: number): number;
	scaleZoom(scale: number): number;
	project(lnglat: LngLat): Point;
	unproject(point: Point): LngLat;
	get point(): Point;
	/**
	 * Updates the center-elevation value unless freezeElevation is activated.
	 * @param terrain the terrain
	 */
	updateElevation(terrain?: Terrain): void;
	/**
	 * get the elevation from terrain for the current zoomlevel.
	 * @param lnglat the location
	 * @param terrain the terrain
	 * @returns {number} elevation in meters
	 */
	getElevation(lnglat: LngLat, terrain: Terrain): number;
	/**
	 * get the camera position in LngLat and altitudes in meter
	 * @returns {Object} An object with lngLat & altitude.
	 */
	getCameraPosition(): {
		lngLat: LngLat;
		altitude: number;
	};
	/**
	 * This method works in combination with freezeElevation activated.
	 * freezeElevtion is enabled during map-panning because during this the camera should sit in constant height.
	 * After panning finished, call this method to recalculate the zoomlevel for the current camera-height in current terrain.
	 * @param {Terrain} terrain the terrain
	 */
	recalculateZoom(terrain: Terrain): void;
	setLocationAtPoint(lnglat: LngLat, point: Point): void;
	/**
	 * Given a location, return the screen point that corresponds to it
	 * @param {LngLat} lnglat location
	 * @param {Terrain} terrain optional terrain
	 * @returns {Point} screen point
	 * @private
	 */
	locationPoint(lnglat: LngLat, terrain?: Terrain): Point;
	/**
	 * Given a point on screen, return its lnglat
	 * @param {Point} p screen point
	 * @param {Terrain} terrain optional terrain
	 * @returns {LngLat} lnglat location
	 * @private
	 */
	pointLocation(p: Point, terrain?: Terrain): LngLat;
	/**
	 * Given a geographical lnglat, return an unrounded
	 * coordinate that represents it at this transform's zoom level.
	 * @param {LngLat} lnglat
	 * @returns {MercatorCoordinate}
	 * @private
	 */
	locationCoordinate(lnglat: LngLat): MercatorCoordinate;
	/**
	 * Given a Coordinate, return its geographical position.
	 * @param {Coordinate} coord
	 * @returns {LngLat} lnglat
	 * @private
	 */
	coordinateLocation(coord: MercatorCoordinate): LngLat;
	/**
	 * Given a Point, return its mercator coordinate.
	 * @param {Point} p the point
	 * @param {Terrain} terrain optional terrain
	 * @returns {LngLat} lnglat
	 * @private
	 */
	pointCoordinate(p: Point, terrain?: Terrain): MercatorCoordinate;
	/**
	 * Given a coordinate, return the screen point that corresponds to it
	 * @param {Coordinate} coord
	 * @param {number} elevation default = 0
	 * @param {mat4} pixelMatrix, default = this.pixelMatrix
	 * @returns {Point} screen point
	 * @private
	 */
	coordinatePoint(coord: MercatorCoordinate, elevation?: number, pixelMatrix?: mat4): Point;
	/**
	 * Returns the map's geographical bounds. When the bearing or pitch is non-zero, the visible region is not
	 * an axis-aligned rectangle, and the result is the smallest bounds that encompasses the visible region.
	 * @returns {LngLatBounds} Returns a {@link LngLatBounds} object describing the map's geographical bounds.
	 */
	getBounds(): LngLatBounds;
	/**
	 * Returns the maximum geographical bounds the map is constrained to, or `null` if none set.
	 * @returns {LngLatBounds} {@link LngLatBounds}
	 */
	getMaxBounds(): LngLatBounds | null;
	/**
	 * Calculate pixel height of the visible horizon in relation to map-center (e.g. height/2),
	 * multiplied by a static factor to simulate the earth-radius.
	 * The calculated value is the horizontal line from the camera-height to sea-level.
	 * @returns {number} Horizon above center in pixels.
	 */
	getHorizon(): number;
	/**
	 * Sets or clears the map's geographical constraints.
	 * @param {LngLatBounds} bounds A {@link LngLatBounds} object describing the new geographic boundaries of the map.
	 */
	setMaxBounds(bounds?: LngLatBounds | null): void;
	/**
	 * Calculate the posMatrix that, given a tile coordinate, would be used to display the tile on a map.
	 * @param {UnwrappedTileID} unwrappedTileID;
	 * @private
	 */
	calculatePosMatrix(unwrappedTileID: UnwrappedTileID, aligned?: boolean): mat4;
	customLayerMatrix(): mat4;
	_constrain(): void;
	_calcMatrices(): void;
	maxPitchScaleFactor(): number;
	getCameraPoint(): Point;
	getCameraQueryGeometry(queryGeometry: Array<Point>): Array<Point>;
}
export type QueryParameters = {
	scale: number;
	pixelPosMatrix: mat4;
	transform: Transform;
	tileSize: number;
	queryGeometry: Array<Point>;
	cameraQueryGeometry: Array<Point>;
	queryPadding: number;
	params: {
		filter: FilterSpecification;
		layers: Array<string>;
		availableImages: Array<string>;
	};
};
export declare class FeatureIndex {
	tileID: OverscaledTileID;
	x: number;
	y: number;
	z: number;
	grid: TransferableGridIndex;
	grid3D: TransferableGridIndex;
	featureIndexArray: FeatureIndexArray;
	promoteId?: PromoteIdSpecification;
	rawTileData: ArrayBuffer;
	bucketLayerIDs: Array<Array<string>>;
	vtLayers: {
		[_: string]: VectorTileLayer;
	};
	sourceLayerCoder: DictionaryCoder;
	constructor(tileID: OverscaledTileID, promoteId?: PromoteIdSpecification | null);
	insert(feature: VectorTileFeature, geometry: Array<Array<Point>>, featureIndex: number, sourceLayerIndex: number, bucketIndex: number, is3D?: boolean): void;
	loadVTLayers(): {
		[_: string]: VectorTileLayer;
	};
	query(args: QueryParameters, styleLayers: {
		[_: string]: StyleLayer;
	}, serializedLayers: {
		[_: string]: any;
	}, sourceFeatureState: SourceFeatureState): {
		[_: string]: Array<{
			featureIndex: number;
			feature: GeoJSONFeature;
		}>;
	};
	loadMatchingFeature(result: {
		[_: string]: Array<{
			featureIndex: number;
			feature: GeoJSONFeature;
			intersectionZ?: boolean | number;
		}>;
	}, bucketIndex: number, sourceLayerIndex: number, featureIndex: number, filter: FeatureFilter, filterLayerIDs: Array<string>, availableImages: Array<string>, styleLayers: {
		[_: string]: StyleLayer;
	}, serializedLayers: {
		[_: string]: any;
	}, sourceFeatureState?: SourceFeatureState, intersectionTest?: (feature: VectorTileFeature, styleLayer: StyleLayer, featureState: any, id: string | number | void) => boolean | number): void;
	lookupSymbolFeatures(symbolFeatureIndexes: Array<number>, serializedLayers: {
		[_: string]: StyleLayer;
	}, bucketIndex: number, sourceLayerIndex: number, filterSpec: FilterSpecification, filterLayerIDs: Array<string>, availableImages: Array<string>, styleLayers: {
		[_: string]: StyleLayer;
	}): {};
	hasLayer(id: string): boolean;
	getId(feature: VectorTileFeature, sourceLayerId: string): string | number;
}
export type TileState = // Tile data is in the process of loading.
"loading" | // Tile data has been loaded. Tile can be rendered.
"loaded" | // Tile data has been loaded and is being updated. Tile can be rendered.
"reloading" | // Tile data has been deleted.
"unloaded" | // Tile data was not loaded because of an error.
"errored" | "expired";
export declare class Tile {
	tileID: OverscaledTileID;
	uid: number;
	uses: number;
	tileSize: number;
	buckets: {
		[_: string]: Bucket;
	};
	latestFeatureIndex: FeatureIndex;
	latestRawTileData: ArrayBuffer;
	imageAtlas: ImageAtlas;
	imageAtlasTexture: Texture;
	glyphAtlasImage: AlphaImage;
	glyphAtlasTexture: Texture;
	expirationTime: any;
	expiredRequestCount: number;
	state: TileState;
	timeAdded: number;
	fadeEndTime: number;
	collisionBoxArray: CollisionBoxArray;
	redoWhenDone: boolean;
	showCollisionBoxes: boolean;
	placementSource: any;
	actor: Actor;
	vtLayers: {
		[_: string]: VectorTileLayer;
	};
	neighboringTiles: any;
	dem: DEMData;
	demMatrix: mat4;
	aborted: boolean;
	needsHillshadePrepare: boolean;
	needsTerrainPrepare: boolean;
	request: Cancelable;
	texture: any;
	fbo: Framebuffer;
	demTexture: Texture;
	refreshedUponExpiration: boolean;
	reloadCallback: any;
	resourceTiming: Array<PerformanceResourceTiming>;
	queryPadding: number;
	symbolFadeHoldUntil: number;
	hasSymbolBuckets: boolean;
	hasRTLText: boolean;
	dependencies: any;
	rtt: Array<{
		id: number;
		stamp: number;
	}>;
	rttCoords: {
		[_: string]: string;
	};
	/**
	 * @param {OverscaledTileID} tileID
	 * @param size
	 * @private
	 */
	constructor(tileID: OverscaledTileID, size: number);
	registerFadeDuration(duration: number): void;
	wasRequested(): boolean;
	clearTextures(painter: any): void;
	/**
	 * Given a data object with a 'buffers' property, load it into
	 * this tile's elementGroups and buffers properties and set loaded
	 * to true. If the data is null, like in the case of an empty
	 * GeoJSON tile, no-op but still set loaded to true.
	 * @param {Object} data
	 * @param painter
	 * @param justReloaded
	 * @returns {undefined}
	 * @private
	 */
	loadVectorData(data: WorkerTileResult, painter: any, justReloaded?: boolean | null): void;
	/**
	 * Release any data or WebGL resources referenced by this tile.
	 * @returns {undefined}
	 * @private
	 */
	unloadVectorData(): void;
	getBucket(layer: StyleLayer): Bucket;
	upload(context: Context): void;
	prepare(imageManager: ImageManager): void;
	queryRenderedFeatures(layers: {
		[_: string]: StyleLayer;
	}, serializedLayers: {
		[_: string]: any;
	}, sourceFeatureState: SourceFeatureState, queryGeometry: Array<Point>, cameraQueryGeometry: Array<Point>, scale: number, params: {
		filter: FilterSpecification;
		layers: Array<string>;
		availableImages: Array<string>;
	}, transform: Transform, maxPitchScaleFactor: number, pixelPosMatrix: mat4): {
		[_: string]: Array<{
			featureIndex: number;
			feature: GeoJSONFeature;
		}>;
	};
	querySourceFeatures(result: Array<GeoJSONFeature>, params?: {
		sourceLayer?: string;
		filter?: FilterSpecification;
		validate?: boolean;
	}): void;
	hasData(): boolean;
	patternsLoaded(): boolean;
	setExpiryData(data: ExpiryData): void;
	getExpiryTimeout(): number;
	setFeatureState(states: LayerFeatureStates, painter: any): void;
	holdingForFade(): boolean;
	symbolFadeFinished(): boolean;
	clearFadeHold(): void;
	setHoldDuration(duration: number): void;
	setDependencies(namespace: string, dependencies: Array<string>): void;
	hasDependency(namespaces: Array<string>, keys: Array<string>): boolean;
}
export type FeatureStates = {
	[featureId: string]: FeatureState;
};
export type LayerFeatureStates = {
	[layer: string]: FeatureStates;
};
export declare class SourceFeatureState {
	state: LayerFeatureStates;
	stateChanges: LayerFeatureStates;
	deletedStates: {};
	constructor();
	updateState(sourceLayer: string, featureId: number | string, newState: any): void;
	removeFeatureState(sourceLayer: string, featureId?: number | string, key?: string): void;
	getState(sourceLayer: string, featureId: number | string): any;
	initializeTileState(tile: Tile, painter: any): void;
	coalesceChanges(tiles: {
		[_ in any]: Tile;
	}, painter: any): void;
}
export type BinderUniform = {
	name: string;
	property: string;
	binding: Uniform<any>;
};
/**
 *  `Binder` is the interface definition for the strategies for constructing,
 *  uploading, and binding paint property data as GLSL attributes. Most style-
 *  spec properties have a 1:1 relationship to shader attribute/uniforms, but
 *  some require multiple values per feature to be passed to the GPU, and in
 *  those cases we bind multiple attributes/uniforms.
 *
 *  It has three implementations, one for each of the three strategies we use:
 *
 *  * For _constant_ properties -- those whose value is a constant, or the constant
 *    result of evaluating a camera expression at a particular camera position -- we
 *    don't need a vertex attribute buffer, and instead use a uniform.
 *  * For data expressions, we use a vertex buffer with a single attribute value,
 *    the evaluated result of the source function for the given feature.
 *  * For composite expressions, we use a vertex buffer with two attributes: min and
 *    max values covering the range of zooms at which we expect the tile to be
 *    displayed. These values are calculated by evaluating the composite expression for
 *    the given feature at strategically chosen zoom levels. In addition to this
 *    attribute data, we also use a uniform value which the shader uses to interpolate
 *    between the min and max value at the final displayed zoom level. The use of a
 *    uniform allows us to cheaply update the value on every frame.
 *
 *  Note that the shader source varies depending on whether we're using a uniform or
 *  attribute. We dynamically compile shaders at runtime to accommodate this.
 *
 * @private
 */
export interface AttributeBinder {
	populatePaintArray(length: number, feature: Feature, imagePositions: {
		[_: string]: ImagePosition;
	}, canonical?: CanonicalTileID, formattedSection?: FormattedSection): void;
	updatePaintArray(start: number, length: number, feature: Feature, featureState: FeatureState, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	upload(a: Context): void;
	destroy(): void;
}
export interface UniformBinder {
	uniformNames: Array<string>;
	setUniform(uniform: Uniform<any>, globals: GlobalProperties, currentValue: PossiblyEvaluatedPropertyValue<any>, uniformName: string): void;
	getBinding(context: Context, location: WebGLUniformLocation, name: string): Partial<Uniform<any>>;
}
export declare class ProgramConfiguration {
	binders: {
		[_: string]: AttributeBinder | UniformBinder;
	};
	cacheKey: string;
	_buffers: Array<VertexBuffer>;
	constructor(layer: TypedStyleLayer, zoom: number, filterProperties: (_: string) => boolean);
	getMaxValue(property: string): number;
	populatePaintArrays(newLength: number, feature: Feature, imagePositions: {
		[_: string]: ImagePosition;
	}, canonical?: CanonicalTileID, formattedSection?: FormattedSection): void;
	setConstantPatternPositions(posTo: ImagePosition, posFrom: ImagePosition): void;
	updatePaintArrays(featureStates: FeatureStates, featureMap: FeaturePositionMap, vtLayer: VectorTileLayer, layer: TypedStyleLayer, imagePositions: {
		[_: string]: ImagePosition;
	}): boolean;
	defines(): Array<string>;
	getBinderAttributes(): Array<string>;
	getBinderUniforms(): Array<string>;
	getPaintVertexBuffers(): Array<VertexBuffer>;
	getUniforms(context: Context, locations: UniformLocations): Array<BinderUniform>;
	setUniforms(context: Context, binderUniforms: Array<BinderUniform>, properties: any, globals: GlobalProperties): void;
	updatePaintBuffers(crossfade?: CrossfadeParameters): void;
	upload(context: Context): void;
	destroy(): void;
}
export declare class ProgramConfigurationSet<Layer extends TypedStyleLayer> {
	programConfigurations: {
		[_: string]: ProgramConfiguration;
	};
	needsUpload: boolean;
	_featureMap: FeaturePositionMap;
	_bufferOffset: number;
	constructor(layers: ReadonlyArray<Layer>, zoom: number, filterProperties?: (_: string) => boolean);
	populatePaintArrays(length: number, feature: Feature, index: number, imagePositions: {
		[_: string]: ImagePosition;
	}, canonical: CanonicalTileID, formattedSection?: FormattedSection): void;
	updatePaintArrays(featureStates: FeatureStates, vtLayer: VectorTileLayer, layers: ReadonlyArray<TypedStyleLayer>, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	get(layerId: string): ProgramConfiguration;
	upload(context: Context): void;
	destroy(): void;
}
export type TerrainPreludeUniformsType = {
	"u_depth": Uniform1i;
	"u_terrain": Uniform1i;
	"u_terrain_dim": Uniform1f;
	"u_terrain_matrix": UniformMatrix4f;
	"u_terrain_unpack": Uniform4f;
	"u_terrain_exaggeration": Uniform1f;
};
export type DrawMode = WebGLRenderingContextBase["LINES"] | WebGLRenderingContextBase["TRIANGLES"] | WebGL2RenderingContext["LINE_STRIP"];
export declare class Program<Us extends UniformBindings> {
	program: WebGLProgram;
	attributes: {
		[_: string]: number;
	};
	numAttributes: number;
	fixedUniforms: Us;
	terrainUniforms: TerrainPreludeUniformsType;
	binderUniforms: Array<BinderUniform>;
	failedToCreate: boolean;
	constructor(context: Context, name: string, source: {
		fragmentSource: string;
		vertexSource: string;
		staticAttributes: Array<string>;
		staticUniforms: Array<string>;
	}, configuration: ProgramConfiguration, fixedUniforms: (b: Context, a: UniformLocations) => Us, showOverdrawInspector: boolean, terrain: Terrain);
	draw(context: Context, drawMode: DrawMode, depthMode: Readonly<DepthMode>, stencilMode: Readonly<StencilMode>, colorMode: Readonly<ColorMode>, cullFaceMode: Readonly<CullFaceMode>, uniformValues: UniformValues<Us>, terrain: TerrainData, layerID: string, layoutVertexBuffer: VertexBuffer, indexBuffer: IndexBuffer, segments: SegmentVector, currentProperties?: any, zoom?: number | null, configuration?: ProgramConfiguration | null, dynamicLayoutBuffer?: VertexBuffer | null, dynamicLayoutBuffer2?: VertexBuffer | null, dynamicLayoutBuffer3?: VertexBuffer | null): void;
}
export declare class VertexArrayObject {
	context: Context;
	boundProgram: Program<any>;
	boundLayoutVertexBuffer: VertexBuffer;
	boundPaintVertexBuffers: Array<VertexBuffer>;
	boundIndexBuffer: IndexBuffer;
	boundVertexOffset: number;
	boundDynamicVertexBuffer: VertexBuffer;
	boundDynamicVertexBuffer2: VertexBuffer;
	boundDynamicVertexBuffer3: VertexBuffer;
	vao: any;
	constructor();
	bind(context: Context, program: Program<any>, layoutVertexBuffer: VertexBuffer, paintVertexBuffers: Array<VertexBuffer>, indexBuffer?: IndexBuffer | null, vertexOffset?: number | null, dynamicVertexBuffer?: VertexBuffer | null, dynamicVertexBuffer2?: VertexBuffer | null, dynamicVertexBuffer3?: VertexBuffer | null): void;
	freshBind(program: Program<any>, layoutVertexBuffer: VertexBuffer, paintVertexBuffers: Array<VertexBuffer>, indexBuffer?: IndexBuffer | null, vertexOffset?: number | null, dynamicVertexBuffer?: VertexBuffer | null, dynamicVertexBuffer2?: VertexBuffer | null, dynamicVertexBuffer3?: VertexBuffer | null): void;
	destroy(): void;
}
export type Segment = {
	sortKey?: number;
	vertexOffset: number;
	primitiveOffset: number;
	vertexLength: number;
	primitiveLength: number;
	vaos: {
		[_: string]: VertexArrayObject;
	};
};
export declare class SegmentVector {
	static MAX_VERTEX_ARRAY_LENGTH: number;
	segments: Array<Segment>;
	constructor(segments?: Array<Segment>);
	prepareSegment(numVertices: number, layoutVertexArray: StructArray, indexArray: StructArray, sortKey?: number): Segment;
	get(): Segment[];
	destroy(): void;
	static simpleSegment(vertexOffset: number, primitiveOffset: number, vertexLength: number, primitiveLength: number): SegmentVector;
}
export declare class HeatmapBucket extends CircleBucket<HeatmapStyleLayer> {
	layers: Array<HeatmapStyleLayer>;
}
export type HeatmapPaintProps = {
	"heatmap-radius": DataDrivenProperty<number>;
	"heatmap-weight": DataDrivenProperty<number>;
	"heatmap-intensity": DataConstantProperty<number>;
	"heatmap-color": ColorRampProperty;
	"heatmap-opacity": DataConstantProperty<number>;
};
export type HeatmapPaintPropsPossiblyEvaluated = {
	"heatmap-radius": PossiblyEvaluatedPropertyValue<number>;
	"heatmap-weight": PossiblyEvaluatedPropertyValue<number>;
	"heatmap-intensity": number;
	"heatmap-color": ColorRampProperty;
	"heatmap-opacity": number;
};
export declare class HeatmapStyleLayer extends StyleLayer {
	heatmapFbo: Framebuffer;
	colorRamp: RGBAImage;
	colorRampTexture: Texture;
	_transitionablePaint: Transitionable<HeatmapPaintProps>;
	_transitioningPaint: Transitioning<HeatmapPaintProps>;
	paint: PossiblyEvaluated<HeatmapPaintProps, HeatmapPaintPropsPossiblyEvaluated>;
	createBucket(options: any): HeatmapBucket;
	constructor(layer: LayerSpecification);
	_handleSpecialPaintPropertyUpdate(name: string): void;
	_updateColorRamp(): void;
	resize(): void;
	queryRadius(): number;
	queryIntersectsFeature(): boolean;
	hasOffscreenPass(): boolean;
}
export declare class CircleBucket<Layer extends CircleStyleLayer | HeatmapStyleLayer> implements Bucket {
	index: number;
	zoom: number;
	overscaling: number;
	layerIds: Array<string>;
	layers: Array<Layer>;
	stateDependentLayers: Array<Layer>;
	stateDependentLayerIds: Array<string>;
	layoutVertexArray: CircleLayoutArray;
	layoutVertexBuffer: VertexBuffer;
	indexArray: TriangleIndexArray;
	indexBuffer: IndexBuffer;
	hasPattern: boolean;
	programConfigurations: ProgramConfigurationSet<Layer>;
	segments: SegmentVector;
	uploaded: boolean;
	constructor(options: BucketParameters<Layer>);
	populate(features: Array<IndexedFeature>, options: PopulateParameters, canonical: CanonicalTileID): void;
	update(states: FeatureStates, vtLayer: VectorTileLayer, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	isEmpty(): boolean;
	uploadPending(): boolean;
	upload(context: Context): void;
	destroy(): void;
	addFeature(feature: BucketFeature, geometry: Array<Array<Point>>, index: number, canonical: CanonicalTileID): void;
}
export type CircleLayoutProps = {
	"circle-sort-key": DataDrivenProperty<number>;
};
export type CircleLayoutPropsPossiblyEvaluated = {
	"circle-sort-key": PossiblyEvaluatedPropertyValue<number>;
};
export type CirclePaintProps = {
	"circle-radius": DataDrivenProperty<number>;
	"circle-color": DataDrivenProperty<Color>;
	"circle-blur": DataDrivenProperty<number>;
	"circle-opacity": DataDrivenProperty<number>;
	"circle-translate": DataConstantProperty<[
		number,
		number
	]>;
	"circle-translate-anchor": DataConstantProperty<"map" | "viewport">;
	"circle-pitch-scale": DataConstantProperty<"map" | "viewport">;
	"circle-pitch-alignment": DataConstantProperty<"map" | "viewport">;
	"circle-stroke-width": DataDrivenProperty<number>;
	"circle-stroke-color": DataDrivenProperty<Color>;
	"circle-stroke-opacity": DataDrivenProperty<number>;
};
export type CirclePaintPropsPossiblyEvaluated = {
	"circle-radius": PossiblyEvaluatedPropertyValue<number>;
	"circle-color": PossiblyEvaluatedPropertyValue<Color>;
	"circle-blur": PossiblyEvaluatedPropertyValue<number>;
	"circle-opacity": PossiblyEvaluatedPropertyValue<number>;
	"circle-translate": [
		number,
		number
	];
	"circle-translate-anchor": "map" | "viewport";
	"circle-pitch-scale": "map" | "viewport";
	"circle-pitch-alignment": "map" | "viewport";
	"circle-stroke-width": PossiblyEvaluatedPropertyValue<number>;
	"circle-stroke-color": PossiblyEvaluatedPropertyValue<Color>;
	"circle-stroke-opacity": PossiblyEvaluatedPropertyValue<number>;
};
export declare class CircleStyleLayer extends StyleLayer {
	_unevaluatedLayout: Layout<CircleLayoutProps>;
	layout: PossiblyEvaluated<CircleLayoutProps, CircleLayoutPropsPossiblyEvaluated>;
	_transitionablePaint: Transitionable<CirclePaintProps>;
	_transitioningPaint: Transitioning<CirclePaintProps>;
	paint: PossiblyEvaluated<CirclePaintProps, CirclePaintPropsPossiblyEvaluated>;
	constructor(layer: LayerSpecification);
	createBucket(parameters: BucketParameters<any>): CircleBucket<any>;
	queryRadius(bucket: Bucket): number;
	queryIntersectsFeature(queryGeometry: Array<Point>, feature: VectorTileFeature, featureState: FeatureState, geometry: Array<Array<Point>>, zoom: number, transform: Transform, pixelsToTileUnits: number, pixelPosMatrix: mat4): boolean;
}
export declare class FillBucket implements Bucket {
	index: number;
	zoom: number;
	overscaling: number;
	layers: Array<FillStyleLayer>;
	layerIds: Array<string>;
	stateDependentLayers: Array<FillStyleLayer>;
	stateDependentLayerIds: Array<string>;
	patternFeatures: Array<BucketFeature>;
	layoutVertexArray: FillLayoutArray;
	layoutVertexBuffer: VertexBuffer;
	indexArray: TriangleIndexArray;
	indexBuffer: IndexBuffer;
	indexArray2: LineIndexArray;
	indexBuffer2: IndexBuffer;
	hasPattern: boolean;
	programConfigurations: ProgramConfigurationSet<FillStyleLayer>;
	segments: SegmentVector;
	segments2: SegmentVector;
	uploaded: boolean;
	constructor(options: BucketParameters<FillStyleLayer>);
	populate(features: Array<IndexedFeature>, options: PopulateParameters, canonical: CanonicalTileID): void;
	update(states: FeatureStates, vtLayer: VectorTileLayer, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	addFeatures(options: PopulateParameters, canonical: CanonicalTileID, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	isEmpty(): boolean;
	uploadPending(): boolean;
	upload(context: Context): void;
	destroy(): void;
	addFeature(feature: BucketFeature, geometry: Array<Array<Point>>, index: number, canonical: CanonicalTileID, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
}
export type FillLayoutProps = {
	"fill-sort-key": DataDrivenProperty<number>;
};
export type FillLayoutPropsPossiblyEvaluated = {
	"fill-sort-key": PossiblyEvaluatedPropertyValue<number>;
};
export type FillPaintProps = {
	"fill-antialias": DataConstantProperty<boolean>;
	"fill-opacity": DataDrivenProperty<number>;
	"fill-color": DataDrivenProperty<Color>;
	"fill-outline-color": DataDrivenProperty<Color>;
	"fill-translate": DataConstantProperty<[
		number,
		number
	]>;
	"fill-translate-anchor": DataConstantProperty<"map" | "viewport">;
	"fill-pattern": CrossFadedDataDrivenProperty<ResolvedImage>;
};
export type FillPaintPropsPossiblyEvaluated = {
	"fill-antialias": boolean;
	"fill-opacity": PossiblyEvaluatedPropertyValue<number>;
	"fill-color": PossiblyEvaluatedPropertyValue<Color>;
	"fill-outline-color": PossiblyEvaluatedPropertyValue<Color>;
	"fill-translate": [
		number,
		number
	];
	"fill-translate-anchor": "map" | "viewport";
	"fill-pattern": PossiblyEvaluatedPropertyValue<CrossFaded<ResolvedImage>>;
};
export declare class FillStyleLayer extends StyleLayer {
	_unevaluatedLayout: Layout<FillLayoutProps>;
	layout: PossiblyEvaluated<FillLayoutProps, FillLayoutPropsPossiblyEvaluated>;
	_transitionablePaint: Transitionable<FillPaintProps>;
	_transitioningPaint: Transitioning<FillPaintProps>;
	paint: PossiblyEvaluated<FillPaintProps, FillPaintPropsPossiblyEvaluated>;
	constructor(layer: LayerSpecification);
	recalculate(parameters: EvaluationParameters, availableImages: Array<string>): void;
	createBucket(parameters: BucketParameters<any>): FillBucket;
	queryRadius(): number;
	queryIntersectsFeature(queryGeometry: Array<Point>, feature: VectorTileFeature, featureState: FeatureState, geometry: Array<Array<Point>>, zoom: number, transform: Transform, pixelsToTileUnits: number): boolean;
	isTileClipped(): boolean;
}
export declare class FillExtrusionBucket implements Bucket {
	index: number;
	zoom: number;
	overscaling: number;
	layers: Array<FillExtrusionStyleLayer>;
	layerIds: Array<string>;
	stateDependentLayers: Array<FillExtrusionStyleLayer>;
	stateDependentLayerIds: Array<string>;
	layoutVertexArray: FillExtrusionLayoutArray;
	layoutVertexBuffer: VertexBuffer;
	centroidVertexArray: PosArray;
	centroidVertexBuffer: VertexBuffer;
	indexArray: TriangleIndexArray;
	indexBuffer: IndexBuffer;
	hasPattern: boolean;
	programConfigurations: ProgramConfigurationSet<FillExtrusionStyleLayer>;
	segments: SegmentVector;
	uploaded: boolean;
	features: Array<BucketFeature>;
	constructor(options: BucketParameters<FillExtrusionStyleLayer>);
	populate(features: Array<IndexedFeature>, options: PopulateParameters, canonical: CanonicalTileID): void;
	addFeatures(options: PopulateParameters, canonical: CanonicalTileID, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	update(states: FeatureStates, vtLayer: VectorTileLayer, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	isEmpty(): boolean;
	uploadPending(): boolean;
	upload(context: Context): void;
	destroy(): void;
	addFeature(feature: BucketFeature, geometry: Array<Array<Point>>, index: number, canonical: CanonicalTileID, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
}
export type FillExtrusionPaintProps = {
	"fill-extrusion-opacity": DataConstantProperty<number>;
	"fill-extrusion-color": DataDrivenProperty<Color>;
	"fill-extrusion-translate": DataConstantProperty<[
		number,
		number
	]>;
	"fill-extrusion-translate-anchor": DataConstantProperty<"map" | "viewport">;
	"fill-extrusion-pattern": CrossFadedDataDrivenProperty<ResolvedImage>;
	"fill-extrusion-height": DataDrivenProperty<number>;
	"fill-extrusion-base": DataDrivenProperty<number>;
	"fill-extrusion-vertical-gradient": DataConstantProperty<boolean>;
};
export type FillExtrusionPaintPropsPossiblyEvaluated = {
	"fill-extrusion-opacity": number;
	"fill-extrusion-color": PossiblyEvaluatedPropertyValue<Color>;
	"fill-extrusion-translate": [
		number,
		number
	];
	"fill-extrusion-translate-anchor": "map" | "viewport";
	"fill-extrusion-pattern": PossiblyEvaluatedPropertyValue<CrossFaded<ResolvedImage>>;
	"fill-extrusion-height": PossiblyEvaluatedPropertyValue<number>;
	"fill-extrusion-base": PossiblyEvaluatedPropertyValue<number>;
	"fill-extrusion-vertical-gradient": boolean;
};
export declare class FillExtrusionStyleLayer extends StyleLayer {
	_transitionablePaint: Transitionable<FillExtrusionPaintProps>;
	_transitioningPaint: Transitioning<FillExtrusionPaintProps>;
	paint: PossiblyEvaluated<FillExtrusionPaintProps, FillExtrusionPaintPropsPossiblyEvaluated>;
	constructor(layer: LayerSpecification);
	createBucket(parameters: BucketParameters<FillExtrusionStyleLayer>): FillExtrusionBucket;
	queryRadius(): number;
	is3D(): boolean;
	queryIntersectsFeature(queryGeometry: Array<Point>, feature: VectorTileFeature, featureState: FeatureState, geometry: Array<Array<Point>>, zoom: number, transform: Transform, pixelsToTileUnits: number, pixelPosMatrix: mat4): boolean | number;
}
export type HillshadePaintProps = {
	"hillshade-illumination-direction": DataConstantProperty<number>;
	"hillshade-illumination-anchor": DataConstantProperty<"map" | "viewport">;
	"hillshade-exaggeration": DataConstantProperty<number>;
	"hillshade-shadow-color": DataConstantProperty<Color>;
	"hillshade-highlight-color": DataConstantProperty<Color>;
	"hillshade-accent-color": DataConstantProperty<Color>;
};
export type HillshadePaintPropsPossiblyEvaluated = {
	"hillshade-illumination-direction": number;
	"hillshade-illumination-anchor": "map" | "viewport";
	"hillshade-exaggeration": number;
	"hillshade-shadow-color": Color;
	"hillshade-highlight-color": Color;
	"hillshade-accent-color": Color;
};
export declare class HillshadeStyleLayer extends StyleLayer {
	_transitionablePaint: Transitionable<HillshadePaintProps>;
	_transitioningPaint: Transitioning<HillshadePaintProps>;
	paint: PossiblyEvaluated<HillshadePaintProps, HillshadePaintPropsPossiblyEvaluated>;
	constructor(layer: LayerSpecification);
	hasOffscreenPass(): boolean;
}
export type LineClips = {
	start: number;
	end: number;
};
export type GradientTexture = {
	texture?: Texture;
	gradient?: RGBAImage;
	version?: number;
};
export declare class LineBucket implements Bucket {
	distance: number;
	totalDistance: number;
	maxLineLength: number;
	scaledDistance: number;
	lineClips?: LineClips;
	e1: number;
	e2: number;
	index: number;
	zoom: number;
	overscaling: number;
	layers: Array<LineStyleLayer>;
	layerIds: Array<string>;
	gradients: {
		[x: string]: GradientTexture;
	};
	stateDependentLayers: Array<any>;
	stateDependentLayerIds: Array<string>;
	patternFeatures: Array<BucketFeature>;
	lineClipsArray: Array<LineClips>;
	layoutVertexArray: LineLayoutArray;
	layoutVertexBuffer: VertexBuffer;
	layoutVertexArray2: LineExtLayoutArray;
	layoutVertexBuffer2: VertexBuffer;
	indexArray: TriangleIndexArray;
	indexBuffer: IndexBuffer;
	hasPattern: boolean;
	programConfigurations: ProgramConfigurationSet<LineStyleLayer>;
	segments: SegmentVector;
	uploaded: boolean;
	constructor(options: BucketParameters<LineStyleLayer>);
	populate(features: Array<IndexedFeature>, options: PopulateParameters, canonical: CanonicalTileID): void;
	update(states: FeatureStates, vtLayer: VectorTileLayer, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	addFeatures(options: PopulateParameters, canonical: CanonicalTileID, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	isEmpty(): boolean;
	uploadPending(): boolean;
	upload(context: Context): void;
	destroy(): void;
	lineFeatureClips(feature: BucketFeature): LineClips | undefined;
	addFeature(feature: BucketFeature, geometry: Array<Array<Point>>, index: number, canonical: CanonicalTileID, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	addLine(vertices: Array<Point>, feature: BucketFeature, join: string, cap: string, miterLimit: number, roundLimit: number): void;
	/**
	 * Add two vertices to the buffers.
	 *
	 * @param p the line vertex to add buffer vertices for
	 * @param normal vertex normal
	 * @param endLeft extrude to shift the left vertex along the line
	 * @param endRight extrude to shift the left vertex along the line
	 * @param segment the segment object to add the vertex to
	 * @param round whether this is a round cap
	 * @private
	 */
	addCurrentVertex(p: Point, normal: Point, endLeft: number, endRight: number, segment: Segment, round?: boolean): void;
	addHalfVertex({ x, y }: Point, extrudeX: number, extrudeY: number, round: boolean, up: boolean, dir: number, segment: Segment): void;
	updateScaledDistance(): void;
	updateDistance(prev: Point, next: Point): void;
}
export type LineLayoutProps = {
	"line-cap": DataConstantProperty<"butt" | "round" | "square">;
	"line-join": DataDrivenProperty<"bevel" | "round" | "miter">;
	"line-miter-limit": DataConstantProperty<number>;
	"line-round-limit": DataConstantProperty<number>;
	"line-sort-key": DataDrivenProperty<number>;
};
export type LineLayoutPropsPossiblyEvaluated = {
	"line-cap": "butt" | "round" | "square";
	"line-join": PossiblyEvaluatedPropertyValue<"bevel" | "round" | "miter">;
	"line-miter-limit": number;
	"line-round-limit": number;
	"line-sort-key": PossiblyEvaluatedPropertyValue<number>;
};
export type LinePaintProps = {
	"line-opacity": DataDrivenProperty<number>;
	"line-color": DataDrivenProperty<Color>;
	"line-translate": DataConstantProperty<[
		number,
		number
	]>;
	"line-translate-anchor": DataConstantProperty<"map" | "viewport">;
	"line-width": DataDrivenProperty<number>;
	"line-gap-width": DataDrivenProperty<number>;
	"line-offset": DataDrivenProperty<number>;
	"line-blur": DataDrivenProperty<number>;
	"line-dasharray": CrossFadedProperty<Array<number>>;
	"line-pattern": CrossFadedDataDrivenProperty<ResolvedImage>;
	"line-gradient": ColorRampProperty;
};
export type LinePaintPropsPossiblyEvaluated = {
	"line-opacity": PossiblyEvaluatedPropertyValue<number>;
	"line-color": PossiblyEvaluatedPropertyValue<Color>;
	"line-translate": [
		number,
		number
	];
	"line-translate-anchor": "map" | "viewport";
	"line-width": PossiblyEvaluatedPropertyValue<number>;
	"line-gap-width": PossiblyEvaluatedPropertyValue<number>;
	"line-offset": PossiblyEvaluatedPropertyValue<number>;
	"line-blur": PossiblyEvaluatedPropertyValue<number>;
	"line-dasharray": CrossFaded<Array<number>>;
	"line-pattern": PossiblyEvaluatedPropertyValue<CrossFaded<ResolvedImage>>;
	"line-gradient": ColorRampProperty;
};
export declare class LineStyleLayer extends StyleLayer {
	_unevaluatedLayout: Layout<LineLayoutProps>;
	layout: PossiblyEvaluated<LineLayoutProps, LineLayoutPropsPossiblyEvaluated>;
	gradientVersion: number;
	stepInterpolant: boolean;
	_transitionablePaint: Transitionable<LinePaintProps>;
	_transitioningPaint: Transitioning<LinePaintProps>;
	paint: PossiblyEvaluated<LinePaintProps, LinePaintPropsPossiblyEvaluated>;
	constructor(layer: LayerSpecification);
	_handleSpecialPaintPropertyUpdate(name: string): void;
	gradientExpression(): import("@maplibre/maplibre-gl-style-spec").StylePropertyExpression;
	recalculate(parameters: EvaluationParameters, availableImages: Array<string>): void;
	createBucket(parameters: BucketParameters<any>): LineBucket;
	queryRadius(bucket: Bucket): number;
	queryIntersectsFeature(queryGeometry: Array<Point>, feature: VectorTileFeature, featureState: FeatureState, geometry: Array<Array<Point>>, zoom: number, transform: Transform, pixelsToTileUnits: number): boolean;
	isTileClipped(): boolean;
}
export type TypedStyleLayer = CircleStyleLayer | FillStyleLayer | FillExtrusionStyleLayer | HeatmapStyleLayer | HillshadeStyleLayer | LineStyleLayer | SymbolStyleLayer;
export type BucketParameters<Layer extends TypedStyleLayer> = {
	index: number;
	layers: Array<Layer>;
	zoom: number;
	pixelRatio: number;
	overscaling: number;
	collisionBoxArray: CollisionBoxArray;
	sourceLayerIndex: number;
	sourceID: string;
};
export type PopulateParameters = {
	featureIndex: FeatureIndex;
	iconDependencies: {};
	patternDependencies: {};
	glyphDependencies: {};
	availableImages: Array<string>;
};
export type IndexedFeature = {
	feature: VectorTileFeature;
	id: number | string;
	index: number;
	sourceLayerIndex: number;
};
export type BucketFeature = {
	index: number;
	sourceLayerIndex: number;
	geometry: Array<Array<Point>>;
	properties: any;
	type: 1 | 2 | 3;
	id?: any;
	readonly patterns: {
		[_: string]: {
			"min": string;
			"mid": string;
			"max": string;
		};
	};
	sortKey?: number;
};
/**
 * The `Bucket` interface is the single point of knowledge about turning vector
 * tiles into WebGL buffers.
 *
 * `Bucket` is an abstract interface. An implementation exists for each style layer type.
 * Create a bucket via the `StyleLayer#createBucket` method.
 *
 * The concrete bucket types, using layout options from the style layer,
 * transform feature geometries into vertex and index data for use by the
 * vertex shader.  They also (via `ProgramConfiguration`) use feature
 * properties and the zoom level to populate the attributes needed for
 * data-driven styling.
 *
 * Buckets are designed to be built on a worker thread and then serialized and
 * transferred back to the main thread for rendering.  On the worker side, a
 * bucket's vertex, index, and attribute data is stored in `bucket.arrays:
 * ArrayGroup`.  When a bucket's data is serialized and sent back to the main
 * thread, is gets deserialized (using `new Bucket(serializedBucketData)`, with
 * the array data now stored in `bucket.buffers: BufferGroup`.  BufferGroups
 * hold the same data as ArrayGroups, but are tuned for consumption by WebGL.
 *
 * @private
 */
export interface Bucket {
	layerIds: Array<string>;
	hasPattern: boolean;
	readonly layers: Array<any>;
	readonly stateDependentLayers: Array<any>;
	readonly stateDependentLayerIds: Array<string>;
	populate(features: Array<IndexedFeature>, options: PopulateParameters, canonical: CanonicalTileID): void;
	update(states: FeatureStates, vtLayer: VectorTileLayer, imagePositions: {
		[_: string]: ImagePosition;
	}): void;
	isEmpty(): boolean;
	upload(context: Context): void;
	uploadPending(): boolean;
	/**
	 * Release the WebGL resources associated with the buffers. Note that because
	 * buckets are shared between layers having the same layout properties, they
	 * must be destroyed in groups (all buckets for a tile, or all symbol buckets).
	 *
	 * @private
	 */
	destroy(): void;
}
export type CustomRenderMethod = (gl: WebGLRenderingContext | WebGL2RenderingContext, matrix: mat4) => void;
/**
 * Interface for custom style layers. This is a specification for
 * implementers to model: it is not an exported method or class.
 *
 * Custom layers allow a user to render directly into the map's GL context using the map's camera.
 * These layers can be added between any regular layers using {@link Map#addLayer}.
 *
 * Custom layers must have a unique `id` and must have the `type` of `"custom"`.
 * They must implement `render` and may implement `prerender`, `onAdd` and `onRemove`.
 * They can trigger rendering using {@link Map#triggerRepaint}
 * and they should appropriately handle {@link Map.event:webglcontextlost} and
 * {@link Map.event:webglcontextrestored}.
 *
 * The `renderingMode` property controls whether the layer is treated as a `"2d"` or `"3d"` map layer. Use:
 * - `"renderingMode": "3d"` to use the depth buffer and share it with other layers
 * - `"renderingMode": "2d"` to add a layer with no depth. If you need to use the depth buffer for a `"2d"` layer you must use an offscreen
 *   framebuffer and {@link CustomLayerInterface#prerender}
 *
 * @interface CustomLayerInterface
 * @example
 * // Custom layer implemented as ES6 class
 * class NullIslandLayer {
 *     constructor() {
 *         this.id = 'null-island';
 *         this.type = 'custom';
 *         this.renderingMode = '2d';
 *     }
 *
 *     onAdd(map, gl) {
 *         const vertexSource = `
 *         uniform mat4 u_matrix;
 *         void main() {
 *             gl_Position = u_matrix * vec4(0.5, 0.5, 0.0, 1.0);
 *             gl_PointSize = 20.0;
 *         }`;
 *
 *         const fragmentSource = `
 *         void main() {
 *             fragColor = vec4(1.0, 0.0, 0.0, 1.0);
 *         }`;
 *
 *         const vertexShader = gl.createShader(gl.VERTEX_SHADER);
 *         gl.shaderSource(vertexShader, vertexSource);
 *         gl.compileShader(vertexShader);
 *         const fragmentShader = gl.createShader(gl.FRAGMENT_SHADER);
 *         gl.shaderSource(fragmentShader, fragmentSource);
 *         gl.compileShader(fragmentShader);
 *
 *         this.program = gl.createProgram();
 *         gl.attachShader(this.program, vertexShader);
 *         gl.attachShader(this.program, fragmentShader);
 *         gl.linkProgram(this.program);
 *     }
 *
 *     render(gl, matrix) {
 *         gl.useProgram(this.program);
 *         gl.uniformMatrix4fv(gl.getUniformLocation(this.program, "u_matrix"), false, matrix);
 *         gl.drawArrays(gl.POINTS, 0, 1);
 *     }
 * }
 *
 * map.on('load', function() {
 *     map.addLayer(new NullIslandLayer());
 * });
 */
export interface CustomLayerInterface {
	/**
	 * @property {string} id A unique layer id.
	 */
	id: string;
	/**
	 * @property {string} type The layer's type. Must be `"custom"`.
	 */
	type: "custom";
	/**
	 * @property {string} renderingMode Either `"2d"` or `"3d"`. Defaults to `"2d"`.
	 */
	renderingMode?: "2d" | "3d";
	/**
	 * Called during a render frame allowing the layer to draw into the GL context.
	 *
	 * The layer can assume blending and depth state is set to allow the layer to properly
	 * blend and clip other layers. The layer cannot make any other assumptions about the
	 * current GL state.
	 *
	 * If the layer needs to render to a texture, it should implement the `prerender` method
	 * to do this and only use the `render` method for drawing directly into the main framebuffer.
	 *
	 * The blend function is set to `gl.blendFunc(gl.ONE, gl.ONE_MINUS_SRC_ALPHA)`. This expects
	 * colors to be provided in premultiplied alpha form where the `r`, `g` and `b` values are already
	 * multiplied by the `a` value. If you are unable to provide colors in premultiplied form you
	 * may want to change the blend function to
	 * `gl.blendFuncSeparate(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA, gl.ONE, gl.ONE_MINUS_SRC_ALPHA)`.
	 *
	 * @function
	 * @memberof CustomLayerInterface
	 * @instance
	 * @name render
	 * @param {WebGLRenderingContext | WebGL2RenderingContext} gl The map's gl context.
	 * @param {Array<number>} matrix The map's camera matrix. It projects spherical mercator
	 * coordinates to gl coordinates. The spherical mercator coordinate `[0, 0]` represents the
	 * top left corner of the mercator world and `[1, 1]` represents the bottom right corner. When
	 * the `renderingMode` is `"3d"`, the z coordinate is conformal. A box with identical x, y, and z
	 * lengths in mercator units would be rendered as a cube. {@link MercatorCoordinate}.fromLngLat
	 * can be used to project a `LngLat` to a mercator coordinate.
	 */
	render: CustomRenderMethod;
	/**
	 * Optional method called during a render frame to allow a layer to prepare resources or render into a texture.
	 *
	 * The layer cannot make any assumptions about the current GL state and must bind a framebuffer before rendering.
	 *
	 * @function
	 * @memberof CustomLayerInterface
	 * @instance
	 * @name prerender
	 * @param {WebGL2RenderingContext} gl The map's gl context.
	 * @param {mat4} matrix The map's camera matrix. It projects spherical mercator
	 * coordinates to gl coordinates. The mercator coordinate `[0, 0]` represents the
	 * top left corner of the mercator world and `[1, 1]` represents the bottom right corner. When
	 * the `renderingMode` is `"3d"`, the z coordinate is conformal. A box with identical x, y, and z
	 * lengths in mercator units would be rendered as a cube. {@link MercatorCoordinate}.fromLngLat
	 * can be used to project a `LngLat` to a mercator coordinate.
	 */
	prerender?: CustomRenderMethod;
	/**
	 * Optional method called when the layer has been added to the Map with {@link Map#addLayer}. This
	 * gives the layer a chance to initialize gl resources and register event listeners.
	 *
	 * @function
	 * @memberof CustomLayerInterface
	 * @instance
	 * @name onAdd
	 * @param {Map} map The Map this custom layer was just added to.
	 * @param {WebGLRenderingContext | WebGL2RenderingContext} gl The gl context for the map.
	 */
	onAdd?(map: Map, gl: WebGLRenderingContext | WebGL2RenderingContext): void;
	/**
	 * Optional method called when the layer has been removed from the Map with {@link Map#removeLayer}. This
	 * gives the layer a chance to clean up gl resources and event listeners.
	 *
	 * @function
	 * @memberof CustomLayerInterface
	 * @instance
	 * @name onRemove
	 * @param {Map} map The Map this custom layer was just added to.
	 * @param {WebGLRenderingContext | WebGL2RenderingContext} gl The gl context for the map.
	 */
	onRemove?(map: Map, gl: WebGLRenderingContext | WebGL2RenderingContext): void;
}
declare abstract class StyleLayer extends Evented {
	id: string;
	metadata: unknown;
	type: LayerSpecification["type"] | CustomLayerInterface["type"];
	source: string;
	sourceLayer: string;
	minzoom: number;
	maxzoom: number;
	filter: FilterSpecification | void;
	visibility: "visible" | "none" | void;
	_crossfadeParameters: CrossfadeParameters;
	_unevaluatedLayout: Layout<any>;
	readonly layout: unknown;
	_transitionablePaint: Transitionable<any>;
	_transitioningPaint: Transitioning<any>;
	readonly paint: unknown;
	_featureFilter: FeatureFilter;
	readonly onAdd: ((map: Map) => void);
	readonly onRemove: ((map: Map) => void);
	queryRadius?(bucket: Bucket): number;
	queryIntersectsFeature?(queryGeometry: Array<Point>, feature: VectorTileFeature, featureState: FeatureState, geometry: Array<Array<Point>>, zoom: number, transform: Transform, pixelsToTileUnits: number, pixelPosMatrix: mat4): boolean | number;
	constructor(layer: LayerSpecification | CustomLayerInterface, properties: Readonly<{
		layout?: Properties<any>;
		paint?: Properties<any>;
	}>);
	getCrossfadeParameters(): CrossfadeParameters;
	getLayoutProperty(name: string): any;
	setLayoutProperty(name: string, value: any, options?: StyleSetterOptions): void;
	getPaintProperty(name: string): unknown;
	setPaintProperty(name: string, value: unknown, options?: StyleSetterOptions): boolean;
	_handleSpecialPaintPropertyUpdate(_: string): void;
	_handleOverridablePaintPropertyUpdate<T, R>(name: string, oldValue: PropertyValue<T, R>, newValue: PropertyValue<T, R>): boolean;
	isHidden(zoom: number): boolean;
	updateTransitions(parameters: TransitionParameters): void;
	hasTransition(): boolean;
	recalculate(parameters: EvaluationParameters, availableImages: Array<string>): void;
	serialize(): LayerSpecification;
	_validate(validate: Function, key: string, name: string, value: unknown, options?: StyleSetterOptions): boolean;
	is3D(): boolean;
	isTileClipped(): boolean;
	hasOffscreenPass(): boolean;
	resize(): void;
	isStateDependent(): boolean;
}
export type LightPosition = {
	x: number;
	y: number;
	z: number;
};
export declare class LightPositionProperty implements Property<[
	number,
	number,
	number
], LightPosition> {
	specification: StylePropertySpecification;
	constructor();
	possiblyEvaluate(value: PropertyValue<[
		number,
		number,
		number
	], LightPosition>, parameters: EvaluationParameters): LightPosition;
	interpolate(a: LightPosition, b: LightPosition, t: number): LightPosition;
}
export type Props = {
	"anchor": DataConstantProperty<"map" | "viewport">;
	"position": LightPositionProperty;
	"color": DataConstantProperty<Color>;
	"intensity": DataConstantProperty<number>;
};
export type PropsPossiblyEvaluated = {
	"anchor": "map" | "viewport";
	"position": LightPosition;
	"color": Color;
	"intensity": number;
};
export declare class Light extends Evented {
	_transitionable: Transitionable<Props>;
	_transitioning: Transitioning<Props>;
	properties: PossiblyEvaluated<Props, PropsPossiblyEvaluated>;
	constructor(lightOptions?: LightSpecification);
	getLight(): any;
	setLight(light?: LightSpecification, options?: StyleSetterOptions): void;
	updateTransitions(parameters: TransitionParameters): void;
	hasTransition(): boolean;
	recalculate(parameters: EvaluationParameters): void;
	_validate(validate: Function, value: unknown, options?: {
		validate?: boolean;
	}): boolean;
}
declare const status: {
	unavailable: string;
	deferred: string;
	loading: string;
	loaded: string;
	error: string;
};
export type PluginState = {
	pluginStatus: typeof status[keyof typeof status];
	pluginURL: string;
};
export type PluginStateSyncCallback = (state: PluginState) => void;
declare const registerForPluginStateChange: (callback: PluginStateSyncCallback) => PluginStateSyncCallback;
export type OverlapMode = "never" | "always" | "cooperative";
export type QueryResult<T> = {
	key: T;
	x1: number;
	y1: number;
	x2: number;
	y2: number;
};
export type GridKey = {
	overlapMode?: OverlapMode;
};
export declare class GridIndex<T extends GridKey> {
	circleKeys: Array<T>;
	boxKeys: Array<T>;
	boxCells: Array<Array<number>>;
	circleCells: Array<Array<number>>;
	bboxes: Array<number>;
	circles: Array<number>;
	xCellCount: number;
	yCellCount: number;
	width: number;
	height: number;
	xScale: number;
	yScale: number;
	boxUid: number;
	circleUid: number;
	constructor(width: number, height: number, cellSize: number);
	keysLength(): number;
	insert(key: T, x1: number, y1: number, x2: number, y2: number): void;
	insertCircle(key: T, x: number, y: number, radius: number): void;
	private _insertBoxCell;
	private _insertCircleCell;
	private _query;
	query(x1: number, y1: number, x2: number, y2: number): Array<QueryResult<T>>;
	hitTest(x1: number, y1: number, x2: number, y2: number, overlapMode: OverlapMode, predicate?: (key: T) => boolean): boolean;
	hitTestCircle(x: number, y: number, radius: number, overlapMode: OverlapMode, predicate?: (key: T) => boolean): boolean;
	private _queryCell;
	private _queryCellCircle;
	private _forEachCell;
	private _convertToXCellCoord;
	private _convertToYCellCoord;
	private _circlesCollide;
	private _circleAndRectCollide;
}
export type FeatureKey = {
	bucketInstanceId: number;
	featureIndex: number;
	collisionGroupID: number;
	overlapMode: OverlapMode;
};
export declare class CollisionIndex {
	grid: GridIndex<FeatureKey>;
	ignoredGrid: GridIndex<FeatureKey>;
	transform: Transform;
	pitchfactor: number;
	screenRightBoundary: number;
	screenBottomBoundary: number;
	gridRightBoundary: number;
	gridBottomBoundary: number;
	perspectiveRatioCutoff: number;
	constructor(transform: Transform, grid?: GridIndex<FeatureKey>, ignoredGrid?: GridIndex<FeatureKey>);
	placeCollisionBox(collisionBox: SingleCollisionBox, overlapMode: OverlapMode, textPixelRatio: number, posMatrix: mat4, collisionGroupPredicate?: (key: FeatureKey) => boolean, getElevation?: (x: number, y: number) => number): {
		box: Array<number>;
		offscreen: boolean;
	};
	placeCollisionCircles(overlapMode: OverlapMode, symbol: any, lineVertexArray: SymbolLineVertexArray, glyphOffsetArray: GlyphOffsetArray, fontSize: number, posMatrix: mat4, labelPlaneMatrix: mat4, labelToScreenMatrix: mat4, showCollisionCircles: boolean, pitchWithMap: boolean, collisionGroupPredicate: (key: FeatureKey) => boolean, circlePixelDiameter: number, textPixelPadding: number, getElevation: (x: number, y: number) => number): {
		circles: Array<number>;
		offscreen: boolean;
		collisionDetected: boolean;
	};
	/**
	 * Because the geometries in the CollisionIndex are an approximation of the shape of
	 * symbols on the map, we use the CollisionIndex to look up the symbol part of
	 * `queryRenderedFeatures`.
	 *
	 * @private
	 */
	queryRenderedSymbols(viewportQueryGeometry: Array<Point>): {};
	insertCollisionBox(collisionBox: Array<number>, overlapMode: OverlapMode, ignorePlacement: boolean, bucketInstanceId: number, featureIndex: number, collisionGroupID: number): void;
	insertCollisionCircles(collisionCircles: Array<number>, overlapMode: OverlapMode, ignorePlacement: boolean, bucketInstanceId: number, featureIndex: number, collisionGroupID: number): void;
	projectAndGetPerspectiveRatio(posMatrix: mat4, x: number, y: number, getElevation?: (x: number, y: number) => number): {
		point: Point;
		perspectiveRatio: number;
	};
	isOffscreen(x1: number, y1: number, x2: number, y2: number): boolean;
	isInsideGrid(x1: number, y1: number, x2: number, y2: number): boolean;
	getViewportMatrix(): mat4;
}
export type TextAnchor = "center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right";
export declare class OpacityState {
	opacity: number;
	placed: boolean;
	constructor(prevState: OpacityState, increment: number, placed: boolean, skipFade?: boolean | null);
	isHidden(): boolean;
}
export declare class JointOpacityState {
	text: OpacityState;
	icon: OpacityState;
	constructor(prevState: JointOpacityState, increment: number, placedText: boolean, placedIcon: boolean, skipFade?: boolean | null);
	isHidden(): boolean;
}
export declare class JointPlacement {
	text: boolean;
	icon: boolean;
	skipFade: boolean;
	constructor(text: boolean, icon: boolean, skipFade: boolean);
}
export declare class CollisionCircleArray {
	invProjMatrix: mat4;
	viewportMatrix: mat4;
	circles: Array<number>;
	constructor();
}
export declare class RetainedQueryData {
	bucketInstanceId: number;
	featureIndex: FeatureIndex;
	sourceLayerIndex: number;
	bucketIndex: number;
	tileID: OverscaledTileID;
	featureSortOrder: Array<number>;
	constructor(bucketInstanceId: number, featureIndex: FeatureIndex, sourceLayerIndex: number, bucketIndex: number, tileID: OverscaledTileID);
}
export type CollisionGroup = {
	ID: number;
	predicate?: (key: FeatureKey) => boolean;
};
export declare class CollisionGroups {
	collisionGroups: {
		[groupName: string]: CollisionGroup;
	};
	maxGroupID: number;
	crossSourceCollisions: boolean;
	constructor(crossSourceCollisions: boolean);
	get(sourceID: string): CollisionGroup;
}
export type VariableOffset = {
	textOffset: [
		number,
		number
	];
	width: number;
	height: number;
	anchor: TextAnchor;
	textBoxScale: number;
	prevAnchor?: TextAnchor;
};
export type TileLayerParameters = {
	bucket: SymbolBucket;
	layout: PossiblyEvaluated<SymbolLayoutProps, SymbolLayoutPropsPossiblyEvaluated>;
	posMatrix: mat4;
	textLabelPlaneMatrix: mat4;
	labelToScreenMatrix: mat4;
	scale: number;
	textPixelRatio: number;
	holdingForFade: boolean;
	collisionBoxArray: CollisionBoxArray;
	partiallyEvaluatedTextSize: {
		uSize: number;
		uSizeT: number;
	};
	collisionGroup: CollisionGroup;
};
export type BucketPart = {
	sortKey?: number | void;
	symbolInstanceStart: number;
	symbolInstanceEnd: number;
	parameters: TileLayerParameters;
};
export type CrossTileID = string | number;
export declare class Placement {
	transform: Transform;
	terrain: Terrain;
	collisionIndex: CollisionIndex;
	placements: {
		[_ in CrossTileID]: JointPlacement;
	};
	opacities: {
		[_ in CrossTileID]: JointOpacityState;
	};
	variableOffsets: {
		[_ in CrossTileID]: VariableOffset;
	};
	placedOrientations: {
		[_ in CrossTileID]: number;
	};
	commitTime: number;
	prevZoomAdjustment: number;
	lastPlacementChangeTime: number;
	stale: boolean;
	fadeDuration: number;
	retainedQueryData: {
		[_: number]: RetainedQueryData;
	};
	collisionGroups: CollisionGroups;
	prevPlacement: Placement;
	zoomAtLastRecencyCheck: number;
	collisionCircleArrays: {
		[k in any]: CollisionCircleArray;
	};
	constructor(transform: Transform, terrain: Terrain, fadeDuration: number, crossSourceCollisions: boolean, prevPlacement?: Placement);
	getBucketParts(results: Array<BucketPart>, styleLayer: StyleLayer, tile: Tile, sortAcrossTiles: boolean): void;
	attemptAnchorPlacement(anchor: TextAnchor, textBox: SingleCollisionBox, width: number, height: number, textBoxScale: number, rotateWithMap: boolean, pitchWithMap: boolean, textPixelRatio: number, posMatrix: mat4, collisionGroup: CollisionGroup, textOverlapMode: OverlapMode, symbolInstance: SymbolInstance, bucket: SymbolBucket, orientation: number, iconBox?: SingleCollisionBox | null, getElevation?: (x: number, y: number) => number): {
		shift: Point;
		placedGlyphBoxes: {
			box: Array<number>;
			offscreen: boolean;
		};
	};
	placeLayerBucketPart(bucketPart: BucketPart, seenCrossTileIDs: {
		[k in string | number]: boolean;
	}, showCollisionBoxes: boolean): void;
	markUsedJustification(bucket: SymbolBucket, placedAnchor: TextAnchor, symbolInstance: SymbolInstance, orientation: number): void;
	markUsedOrientation(bucket: SymbolBucket, orientation: number, symbolInstance: SymbolInstance): void;
	commit(now: number): void;
	updateLayerOpacities(styleLayer: StyleLayer, tiles: Array<Tile>): void;
	updateBucketOpacities(bucket: SymbolBucket, seenCrossTileIDs: {
		[k in string | number]: boolean;
	}, collisionBoxArray?: CollisionBoxArray | null): void;
	symbolFadeChange(now: number): number;
	zoomAdjustment(zoom: number): number;
	hasTransitions(now: number): boolean;
	stillRecent(now: number, zoom: number): boolean;
	setStale(): void;
}
export declare class LayerPlacement {
	_sortAcrossTiles: boolean;
	_currentTileIndex: number;
	_currentPartIndex: number;
	_seenCrossTileIDs: {
		[k in string | number]: boolean;
	};
	_bucketParts: Array<BucketPart>;
	constructor(styleLayer: SymbolStyleLayer);
	continuePlacement(tiles: Array<Tile>, placement: Placement, showCollisionBoxes: boolean, styleLayer: StyleLayer, shouldPausePlacement: () => boolean): boolean;
}
export declare class PauseablePlacement {
	placement: Placement;
	_done: boolean;
	_currentPlacementIndex: number;
	_forceFullPlacement: boolean;
	_showCollisionBoxes: boolean;
	_inProgressLayer: LayerPlacement;
	constructor(transform: Transform, terrain: Terrain, order: Array<string>, forceFullPlacement: boolean, showCollisionBoxes: boolean, fadeDuration: number, crossSourceCollisions: boolean, prevPlacement?: Placement);
	isDone(): boolean;
	continuePlacement(order: Array<string>, layers: {
		[_: string]: StyleLayer;
	}, layerTiles: {
		[_: string]: Array<Tile>;
	}): void;
	commit(now: number): Placement;
}
export type ValidationError = {
	message: string;
	line: number;
	identifier?: string;
};
export type Validator = (a: any) => ReadonlyArray<ValidationError>;
export type FeatureIdentifier = {
	id?: string | number | undefined;
	source: string;
	sourceLayer?: string | undefined;
};
export type StyleOptions = {
	validate?: boolean;
	localIdeographFontFamily?: string;
};
export type StyleSetterOptions = {
	validate?: boolean;
};
/**
 * Part of {@link Map#setStyle} options, transformStyle is a convenience function that allows to modify a style after it is fetched but before it is committed to the map state
 * this function exposes previous and next styles, it can be commonly used to support a range of functionalities like:
 *      when previous style carries certain 'state' that needs to be carried over to a new style gracefully
 *      when a desired style is a certain combination of previous and incoming style
 *      when an incoming style requires modification based on external state
 *
 * @typedef {Function} TransformStyleFunction
 * @param {StyleSpecification | undefined} previousStyle The current style.
 * @param {StyleSpecification} nextStyle The next style.
 * @returns {boolean} resulting style that will to be applied to the map
 *
 * @example
 * map.setStyle('https://demotiles.maplibre.org/style.json', {
 *   transformStyle: (previousStyle, nextStyle) => ({
 *       ...nextStyle,
 *       sources: {
 *           ...nextStyle.sources,
 *           // copy a source from previous style
 *           'osm': previousStyle.sources.osm
 *       },
 *       layers: [
 *           // background layer
 *           nextStyle.layers[0],
 *           // copy a layer from previous style
 *           previousStyle.layers[0],
 *           // other layers from the next style
 *           ...nextStyle.layers.slice(1).map(layer => {
 *               // hide the layers we don't need from demotiles style
 *               if (layer.id.startsWith('geolines')) {
 *                   layer.layout = {...layer.layout || {}, visibility: 'none'};
 *               // filter out US polygons
 *               } else if (layer.id.startsWith('coastline') || layer.id.startsWith('countries')) {
 *                   layer.filter = ['!=', ['get', 'ADM0_A3'], 'USA'];
 *               }
 *               return layer;
 *           })
 *       ]
 *   })
 * });
 */
export type TransformStyleFunction = (previous: StyleSpecification | undefined, next: StyleSpecification) => StyleSpecification;
export type StyleSwapOptions = {
	diff?: boolean;
	transformStyle?: TransformStyleFunction;
};
export declare class Style extends Evented {
	map: Map;
	stylesheet: StyleSpecification;
	dispatcher: Dispatcher;
	imageManager: ImageManager;
	glyphManager: GlyphManager;
	lineAtlas: LineAtlas;
	light: Light;
	_request: Cancelable;
	_spriteRequest: Cancelable;
	_layers: {
		[_: string]: StyleLayer;
	};
	_serializedLayers: {
		[_: string]: LayerSpecification;
	};
	_order: Array<string>;
	sourceCaches: {
		[_: string]: SourceCache;
	};
	zoomHistory: ZoomHistory;
	_loaded: boolean;
	_rtlTextPluginCallback: (a: any) => any;
	_changed: boolean;
	_updatedSources: {
		[_: string]: "clear" | "reload";
	};
	_updatedLayers: {
		[_: string]: true;
	};
	_removedLayers: {
		[_: string]: StyleLayer;
	};
	_changedImages: {
		[_: string]: true;
	};
	_glyphsDidChange: boolean;
	_updatedPaintProps: {
		[layer: string]: true;
	};
	_layerOrderChanged: boolean;
	_spritesImagesIds: {
		[spriteId: string]: string[];
	};
	_availableImages: Array<string>;
	crossTileSymbolIndex: CrossTileSymbolIndex;
	pauseablePlacement: PauseablePlacement;
	placement: Placement;
	z: number;
	static getSourceType: typeof getSourceType;
	static setSourceType: typeof setSourceType;
	static registerForPluginStateChange: typeof registerForPluginStateChange;
	constructor(map: Map, options?: StyleOptions);
	loadURL(url: string, options?: StyleSwapOptions & StyleSetterOptions, previousStyle?: StyleSpecification): void;
	loadJSON(json: StyleSpecification, options?: StyleSetterOptions & StyleSwapOptions, previousStyle?: StyleSpecification): void;
	loadEmpty(): void;
	_load(json: StyleSpecification, options: StyleSwapOptions & StyleSetterOptions, previousStyle?: StyleSpecification): void;
	private _createLayers;
	_loadSprite(sprite: SpriteSpecification, isUpdate?: boolean, completion?: (err: Error) => void): void;
	_unloadSprite(): void;
	_validateLayer(layer: StyleLayer): void;
	loaded(): boolean;
	/**
	 * take an array of string IDs, and based on this._layers, generate an array of LayerSpecification
	 * @param ids an array of string IDs, for which serialized layers will be generated. If omitted, all serialized layers will be returned
	 * @returns {Array<LayerSpecification>} generated result
	 */
	private _serializeByIds;
	/**
	 * Lazy initialization of this._serializedLayers dictionary and return it
	 * @returns this._serializedLayers dictionary
	 */
	private _serializedAllLayers;
	hasTransitions(): boolean;
	_checkLoaded(): void;
	/**
	 * Apply queued style updates in a batch and recalculate zoom-dependent paint properties.
	 * @private
	 */
	update(parameters: EvaluationParameters): void;
	_updateTilesForChangedImages(): void;
	_updateTilesForChangedGlyphs(): void;
	_updateWorkerLayers(updatedIds: Array<string>, removedIds: Array<string>): void;
	_resetUpdates(): void;
	/**
	 * Update this style's state to match the given style JSON, performing only
	 * the necessary mutations.
	 *
	 * May throw an Error ('Unimplemented: METHOD') if the mapbox-gl-style-spec
	 * diff algorithm produces an operation that is not supported.
	 *
	 * @returns {boolean} true if any changes were made; false otherwise
	 * @private
	 */
	setState(nextState: StyleSpecification, options?: StyleSwapOptions): boolean;
	addImage(id: string, image: StyleImage): this;
	updateImage(id: string, image: StyleImage): void;
	getImage(id: string): StyleImage;
	removeImage(id: string): this;
	_afterImageUpdated(id: string): void;
	listImages(): string[];
	addSource(id: string, source: SourceSpecification, options?: StyleSetterOptions): void;
	/**
	 * Remove a source from this stylesheet, given its id.
	 * @param {string} id id of the source to remove
	 * @throws {Error} if no source is found with the given ID
	 * @returns {Map} The {@link Map} object.
	 */
	removeSource(id: string): this;
	/**
	 * Set the data of a GeoJSON source, given its id.
	 * @param {string} id id of the source
	 * @param {GeoJSON|string} data GeoJSON source
	 */
	setGeoJSONSourceData(id: string, data: GeoJSON.GeoJSON | string): void;
	/**
	 * Get a source by id.
	 * @param {string} id id of the desired source
	 * @returns {Source | undefined} source
	 */
	getSource(id: string): Source | undefined;
	/**
	 * Add a layer to the map style. The layer will be inserted before the layer with
	 * ID `before`, or appended if `before` is omitted.
	 * @param {Object | CustomLayerInterface} layerObject The style layer to add.
	 * @param {string} [before] ID of an existing layer to insert before
	 * @param {Object} options Style setter options.
	 * @returns {Map} The {@link Map} object.
	 */
	addLayer(layerObject: LayerSpecification | CustomLayerInterface, before?: string, options?: StyleSetterOptions): void;
	/**
	 * Moves a layer to a different z-position. The layer will be inserted before the layer with
	 * ID `before`, or appended if `before` is omitted.
	 * @param {string} id ID of the layer to move
	 * @param {string} [before] ID of an existing layer to insert before
	 */
	moveLayer(id: string, before?: string): void;
	/**
	 * Remove the layer with the given id from the style.
	 *
	 * If no such layer exists, an `error` event is fired.
	 *
	 * @param {string} id id of the layer to remove
	 * @fires error
	 */
	removeLayer(id: string): void;
	/**
	 * Return the style layer object with the given `id`.
	 *
	 * @param {string} id - id of the desired layer
	 * @returns {?Object} a layer, if one with the given `id` exists
	 */
	getLayer(id: string): StyleLayer;
	/**
	 * checks if a specific layer is present within the style.
	 *
	 * @param {string} id - id of the desired layer
	 * @returns {boolean} a boolean specifying if the given layer is present
	 */
	hasLayer(id: string): boolean;
	setLayerZoomRange(layerId: string, minzoom?: number | null, maxzoom?: number | null): void;
	setFilter(layerId: string, filter?: FilterSpecification | null, options?: StyleSetterOptions): void;
	/**
	 * Get a layer's filter object
	 * @param {string} layer the layer to inspect
	 * @returns {*} the layer's filter, if any
	 */
	getFilter(layer: string): void | FilterSpecification;
	setLayoutProperty(layerId: string, name: string, value: any, options?: StyleSetterOptions): void;
	/**
	 * Get a layout property's value from a given layer
	 * @param {string} layerId the layer to inspect
	 * @param {string} name the name of the layout property
	 * @returns {*} the property value
	 */
	getLayoutProperty(layerId: string, name: string): any;
	setPaintProperty(layerId: string, name: string, value: any, options?: StyleSetterOptions): void;
	getPaintProperty(layer: string, name: string): unknown;
	setFeatureState(target: FeatureIdentifier, state: any): void;
	removeFeatureState(target: FeatureIdentifier, key?: string): void;
	getFeatureState(target: FeatureIdentifier): any;
	getTransition(): any;
	serialize(): StyleSpecification;
	_updateLayer(layer: StyleLayer): void;
	_flattenAndSortRenderedFeatures(sourceResults: Array<{
		[key: string]: Array<{
			featureIndex: number;
			feature: MapGeoJSONFeature;
		}>;
	}>): any[];
	queryRenderedFeatures(queryGeometry: any, params: any, transform: Transform): any[];
	querySourceFeatures(sourceID: string, params?: {
		sourceLayer?: string;
		filter?: FilterSpecification;
		validate?: boolean;
	}): any[];
	addSourceType(name: string, SourceType: SourceClass, callback: Callback<void>): void;
	getLight(): any;
	setLight(lightOptions: LightSpecification, options?: StyleSetterOptions): void;
	_validate(validate: Validator, key: string, value: any, props: any, options?: {
		validate?: boolean;
	}): boolean;
	_remove(mapRemoved?: boolean): void;
	_clearSource(id: string): void;
	_reloadSource(id: string): void;
	_updateSources(transform: Transform): void;
	_generateCollisionBoxes(): void;
	_updatePlacement(transform: Transform, showCollisionBoxes: boolean, fadeDuration: number, crossSourceCollisions: boolean, forceFullPlacement?: boolean): boolean;
	_releaseSymbolFadeTiles(): void;
	getImages(mapId: string, params: {
		icons: Array<string>;
		source: string;
		tileID: OverscaledTileID;
		type: string;
	}, callback: Callback<{
		[_: string]: StyleImage;
	}>): void;
	getGlyphs(mapId: string, params: {
		stacks: {
			[_: string]: Array<number>;
		};
		source: string;
		tileID: OverscaledTileID;
		type: string;
	}, callback: Callback<{
		[_: string]: {
			[_: number]: StyleGlyph;
		};
	}>): void;
	getResource(mapId: string, params: RequestParameters, callback: ResponseCallback<any>): Cancelable;
	getGlyphsUrl(): string;
	setGlyphs(glyphsUrl: string | null, options?: StyleSetterOptions): void;
	/**
	 * Add a sprite.
	 *
	 * @param {string} id id of the desired sprite
	 * @param {string} url url to load the desired sprite from
	 * @param {StyleSetterOptions} [options] style setter options
	 * @param [completion] completion handler
	 */
	addSprite(id: string, url: string, options?: StyleSetterOptions, completion?: (err: Error) => void): void;
	/**
	 * Remove a sprite by its id. When the last sprite is removed, the whole `this.stylesheet.sprite` object becomes
	 * `undefined`. This falsy `undefined` value later prevents attempts to load the sprite when it's absent.
	 *
	 * @param id the id of the sprite to remove
	 */
	removeSprite(id: string): void;
	/**
	 * Get the current sprite value.
	 *
	 * @returns {Array} empty array when no sprite is set; id-url pairs otherwise
	 */
	getSprite(): {
		id: string;
		url: string;
	}[];
	/**
	 * Set a new value for the style's sprite.
	 *
	 * @param {SpriteSpecification} sprite new sprite value
	 * @param {StyleSetterOptions} [options] style setter options
	 * @param [completion] completion handler
	 */
	setSprite(sprite: SpriteSpecification, options?: StyleSetterOptions, completion?: (err: Error) => void): void;
}
export declare class Hash {
	_map: Map;
	_updateHash: () => ReturnType<typeof setTimeout>;
	_hashName: string;
	constructor(hashName?: string | null);
	addTo(map: Map): this;
	remove(): this;
	getHashString(mapFeedback?: boolean): string;
	_getCurrentHash(): any;
	_onHashChange(): boolean;
	_updateHashUnthrottled(): void;
}
export interface DragMovementResult {
	bearingDelta?: number;
	pitchDelta?: number;
	around?: Point;
	panDelta?: Point;
}
export interface DragPanResult extends DragMovementResult {
	around: Point;
	panDelta: Point;
}
export interface DragRotateResult extends DragMovementResult {
	bearingDelta: number;
}
export interface DragPitchResult extends DragMovementResult {
	pitchDelta: number;
}
export interface DragMoveHandler<T extends DragMovementResult, E extends Event> extends Handler {
	reset: (e?: E) => void;
	dragStart: (e: E, point: Point) => void;
	dragMove: (e: E, point: Point) => T | void;
	dragEnd: (e: E) => void;
	enable: () => void;
	disable: () => void;
	isEnabled: () => boolean;
	isActive: () => boolean;
	getClickTolerance: () => number;
}
export interface MousePanHandler extends DragMoveHandler<DragPanResult, MouseEvent> {
}
export interface MouseRotateHandler extends DragMoveHandler<DragRotateResult, MouseEvent> {
}
export interface MousePitchHandler extends DragMoveHandler<DragPitchResult, MouseEvent> {
}
export declare class TouchPanHandler {
	_enabled: boolean;
	_active: boolean;
	_touches: {
		[k in string | number]: Point;
	};
	_minTouches: number;
	_clickTolerance: number;
	_sum: Point;
	_map: Map;
	_cancelCooperativeMessage: boolean;
	constructor(options: {
		clickTolerance: number;
		cooperativeGestures: boolean | GestureOptions;
	}, map: Map);
	reset(): void;
	touchstart(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): {
		around: Point;
		panDelta: Point;
	};
	touchmove(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): {
		around: Point;
		panDelta: Point;
	};
	touchend(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchcancel(): void;
	_calculateTransform(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): {
		around: Point;
		panDelta: Point;
	};
	enable(): void;
	disable(): void;
	isEnabled(): boolean;
	isActive(): boolean;
}
export type DragPanOptions = {
	linearity?: number;
	easing?: (t: number) => number;
	deceleration?: number;
	maxSpeed?: number;
};
export declare class DragPanHandler {
	_el: HTMLElement;
	_mousePan: MousePanHandler;
	_touchPan: TouchPanHandler;
	_inertiaOptions: DragPanOptions;
	/**
	 * @private
	*/
	constructor(el: HTMLElement, mousePan: MousePanHandler, touchPan: TouchPanHandler);
	/**
	 * Enables the "drag to pan" interaction.
	 *
	 * @param {Object} [options] Options object
	 * @param {number} [options.linearity=0] factor used to scale the drag velocity
	 * @param {Function} [options.easing=bezier(0, 0, 0.3, 1)] easing function applled to `map.panTo` when applying the drag.
	 * @param {number} [options.maxSpeed=1400] the maximum value of the drag velocity.
	 * @param {number} [options.deceleration=2500] the rate at which the speed reduces after the pan ends.
	 *
	 * @example
	 *   map.dragPan.enable();
	 * @example
	 *   map.dragPan.enable({
	 *      linearity: 0.3,
	 *      easing: bezier(0, 0, 0.3, 1),
	 *      maxSpeed: 1400,
	 *      deceleration: 2500,
	 *   });
	 */
	enable(options?: DragPanOptions): void;
	/**
	 * Disables the "drag to pan" interaction.
	 *
	 * @example
	 * map.dragPan.disable();
	 */
	disable(): void;
	/**
	 * Returns a Boolean indicating whether the "drag to pan" interaction is enabled.
	 *
	 * @returns {boolean} `true` if the "drag to pan" interaction is enabled.
	 */
	isEnabled(): boolean;
	/**
	 * Returns a Boolean indicating whether the "drag to pan" interaction is active, i.e. currently being used.
	 *
	 * @returns {boolean} `true` if the "drag to pan" interaction is active.
	 */
	isActive(): boolean;
}
export declare class HandlerInertia {
	_map: Map;
	_inertiaBuffer: Array<{
		time: number;
		settings: any;
	}>;
	constructor(map: Map);
	clear(): void;
	record(settings: any): void;
	_drainInertiaBuffer(): void;
	_onMoveEnd(panInertiaOptions?: DragPanOptions): any;
}
export type InputEvent = MouseEvent | TouchEvent | KeyboardEvent | WheelEvent;
export interface Handler {
	enable(): void;
	disable(): void;
	isEnabled(): boolean;
	isActive(): boolean;
	reset(): void;
	readonly touchstart?: (e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>) => HandlerResult | void;
	readonly touchmove?: (e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>) => HandlerResult | void;
	readonly touchmoveWindow?: (e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>) => HandlerResult | void;
	readonly touchend?: (e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>) => HandlerResult | void;
	readonly touchcancel?: (e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>) => HandlerResult | void;
	readonly mousedown?: (e: MouseEvent, point: Point) => HandlerResult | void;
	readonly mousemove?: (e: MouseEvent, point: Point) => HandlerResult | void;
	readonly mousemoveWindow?: (e: MouseEvent, point: Point) => HandlerResult | void;
	readonly mouseup?: (e: MouseEvent, point: Point) => HandlerResult | void;
	readonly dblclick?: (e: MouseEvent, point: Point) => HandlerResult | void;
	readonly contextmenu?: (e: MouseEvent) => HandlerResult | void;
	readonly wheel?: (e: WheelEvent, point: Point) => HandlerResult | void;
	readonly keydown?: (e: KeyboardEvent) => HandlerResult | void;
	readonly keyup?: (e: KeyboardEvent) => HandlerResult | void;
	readonly renderFrame?: () => HandlerResult | void;
}
export type HandlerResult = {
	panDelta?: Point;
	zoomDelta?: number;
	bearingDelta?: number;
	pitchDelta?: number;
	around?: Point | null;
	pinchAround?: Point | null;
	cameraAnimation?: (map: Map) => any;
	originalEvent?: Event;
	needsRenderFrame?: boolean;
	noInertia?: boolean;
};
export type EventInProgress = {
	handlerName: string;
	originalEvent: Event;
};
export type EventsInProgress = {
	zoom?: EventInProgress;
	pitch?: EventInProgress;
	rotate?: EventInProgress;
	drag?: EventInProgress;
};
export declare class HandlerManager {
	_map: Map;
	_el: HTMLElement;
	_handlers: Array<{
		handlerName: string;
		handler: Handler;
		allowed: Array<string>;
	}>;
	_eventsInProgress: EventsInProgress;
	_frameId: number;
	_inertia: HandlerInertia;
	_bearingSnap: number;
	_handlersById: {
		[x: string]: Handler;
	};
	_updatingCamera: boolean;
	_changes: Array<[
		HandlerResult,
		EventsInProgress,
		{
			[handlerName: string]: Event;
		}
	]>;
	_terrainMovement: boolean;
	_zoom: {
		handlerName: string;
	};
	_previousActiveHandlers: {
		[x: string]: Handler;
	};
	_listeners: Array<[
		Window | Document | HTMLElement,
		string,
		{
			passive?: boolean;
			capture?: boolean;
		} | undefined
	]>;
	constructor(map: Map, options: CompleteMapOptions);
	destroy(): void;
	_addDefaultHandlers(options: CompleteMapOptions): void;
	_add(handlerName: string, handler: Handler, allowed?: Array<string>): void;
	stop(allowEndAnimation: boolean): void;
	isActive(): boolean;
	isZooming(): boolean;
	isRotating(): boolean;
	isMoving(): boolean;
	_blockedByActive(activeHandlers: {
		[x: string]: Handler;
	}, allowed: Array<string>, myName: string): boolean;
	handleWindowEvent(e: InputEvent): void;
	_getMapTouches(touches: TouchList): TouchList;
	handleEvent(e: Event, eventName?: string): void;
	mergeHandlerResult(mergedHandlerResult: HandlerResult, eventsInProgress: EventsInProgress, handlerResult: HandlerResult, name: string, e?: InputEvent): void;
	_applyChanges(): void;
	_updateMapTransform(combinedResult: HandlerResult, combinedEventsInProgress: EventsInProgress, deactivatedHandlers: {
		[handlerName: string]: Event;
	}): void;
	_fireEvents(newEventsInProgress: EventsInProgress, deactivatedHandlers: {
		[handlerName: string]: Event;
	}, allowEndAnimation: boolean): void;
	_fireEvent(type: string, e?: Event): void;
	_requestFrame(): number;
	_triggerRenderFrame(): void;
}
export type TaskID = number;
export type Task = {
	callback: (timeStamp: number) => void;
	id: TaskID;
	cancelled: boolean;
};
export declare class TaskQueue {
	_queue: Array<Task>;
	_id: TaskID;
	_cleared: boolean;
	_currentlyRunning: Array<Task> | false;
	constructor();
	add(callback: (timeStamp: number) => void): TaskID;
	remove(id: TaskID): void;
	run(timeStamp?: number): void;
	clear(): void;
}
/**
 * A [Point](https://github.com/mapbox/point-geometry) or an array of two numbers representing `x` and `y` screen coordinates in pixels.
 *
 * @typedef {(Point | [number, number])} PointLike
 * @example
 * var p1 = new Point(-77, 38); // a PointLike which is a Point
 * var p2 = [-77, 38]; // a PointLike which is an array of two numbers
 */
export type PointLike = Point | [
	number,
	number
];
export type RequireAtLeastOne<T> = {
	[K in keyof T]-?: Required<Pick<T, K>> & Partial<Pick<T, Exclude<keyof T, K>>>;
}[keyof T];
/**
 * Options common to {@link Map#jumpTo}, {@link Map#easeTo}, and {@link Map#flyTo}, controlling the desired location,
 * zoom, bearing, and pitch of the camera. All properties are optional, and when a property is omitted, the current
 * camera value for that property will remain unchanged.
 *
 * @typedef {Object} CameraOptions
 * @property {LngLatLike} center The desired center.
 * @property {number} zoom The desired zoom level.
 * @property {number} bearing The desired bearing in degrees. The bearing is the compass direction that
 * is "up". For example, `bearing: 90` orients the map so that east is up.
 * @property {number} pitch The desired pitch in degrees. The pitch is the angle towards the horizon
 * measured in degrees with a range between 0 and 60 degrees. For example, pitch: 0 provides the appearance
 * of looking straight down at the map, while pitch: 60 tilts the user's perspective towards the horizon.
 * Increasing the pitch value is often used to display 3D objects.
 * @property {LngLatLike} around If `zoom` is specified, `around` determines the point around which the zoom is centered.
 * @property {PaddingOptions} padding Dimensions in pixels applied on each side of the viewport for shifting the vanishing point.
 * @example
 * // set the map's initial perspective with CameraOptions
 * var map = new maplibregl.Map({
 *   container: 'map',
 *   style: 'https://demotiles.maplibre.org/style.json',
 *   center: [-73.5804, 45.53483],
 *   pitch: 60,
 *   bearing: -60,
 *   zoom: 10
 * });
 * @see [Set pitch and bearing](https://maplibre.org/maplibre-gl-js-docs/example/set-perspective/)
 * @see [Jump to a series of locations](https://maplibre.org/maplibre-gl-js-docs/example/jump-to/)
 * @see [Fly to a location](https://maplibre.org/maplibre-gl-js-docs/example/flyto/)
 * @see [Display buildings in 3D](https://maplibre.org/maplibre-gl-js-docs/example/3d-buildings/)
 */
export type CameraOptions = CenterZoomBearing & {
	pitch?: number;
	around?: LngLatLike;
};
export type CenterZoomBearing = {
	center?: LngLatLike;
	zoom?: number;
	bearing?: number;
};
export type JumpToOptions = CameraOptions & {
	padding?: PaddingOptions;
};
export type CameraForBoundsOptions = CameraOptions & {
	padding?: number | RequireAtLeastOne<PaddingOptions>;
	offset?: PointLike;
	maxZoom?: number;
};
export type FlyToOptions = AnimationOptions & CameraOptions & {
	curve?: number;
	minZoom?: number;
	speed?: number;
	screenSpeed?: number;
	maxDuration?: number;
	padding?: number | RequireAtLeastOne<PaddingOptions>;
};
export type EaseToOptions = AnimationOptions & CameraOptions & {
	delayEndEvents?: number;
	padding?: number | RequireAtLeastOne<PaddingOptions>;
};
export type FitBoundsOptions = FlyToOptions & {
	linear?: boolean;
	offset?: PointLike;
	maxZoom?: number;
	maxDuration?: number;
	padding?: number | RequireAtLeastOne<PaddingOptions>;
};
/**
 * Options common to map movement methods that involve animation, such as {@link Map#panBy} and
 * {@link Map#easeTo}, controlling the duration and easing function of the animation. All properties
 * are optional.
 *
 * @typedef {Object} AnimationOptions
 * @property {number} duration The animation's duration, measured in milliseconds.
 * @property {Function} easing A function taking a time in the range 0..1 and returning a number where 0 is
 * the initial state and 1 is the final state.
 * @property {PointLike} offset of the target center relative to real map container center at the end of animation.
 * @property {boolean} animate If `false`, no animation will occur.
 * @property {boolean} essential If `true`, then the animation is considered essential and will not be affected by
 * [`prefers-reduced-motion`](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-reduced-motion).
 * @property {boolean} freezeElevation Default false. Needed in 3D maps to let the camera stay in a constant
 * height based on sea-level. After the animation finished the zoom-level will be recalculated in respect of
 * the distance from the camera to the center-coordinate-altitude.
 */
export type AnimationOptions = {
	duration?: number;
	easing?: (_: number) => number;
	offset?: PointLike;
	animate?: boolean;
	essential?: boolean;
	freezeElevation?: boolean;
};
export type CameraUpdateTransformFunction = (next: {
	center: LngLat;
	zoom: number;
	pitch: number;
	bearing: number;
	elevation: number;
}) => {
	center?: LngLat;
	zoom?: number;
	pitch?: number;
	bearing?: number;
	elevation?: number;
};
declare abstract class Camera extends Evented {
	transform: Transform;
	terrain: Terrain;
	_moving: boolean;
	_zooming: boolean;
	_rotating: boolean;
	_pitching: boolean;
	_padding: boolean;
	_bearingSnap: number;
	_easeStart: number;
	_easeOptions: {
		duration?: number;
		easing?: (_: number) => number;
	};
	_easeId: string | void;
	_onEaseFrame: (_: number) => void;
	_onEaseEnd: (easeId?: string) => void;
	_easeFrameId: TaskID;
	_elevationCenter: LngLat;
	_elevationTarget: number;
	_elevationStart: number;
	/** Used to track accumulated changes during continuous interaction */
	_requestedCameraState?: Transform;
	/** A callback used to defer camera updates or apply arbitrary constraints.
	 * If specified, this Camera instance can be used as a stateless component in React etc.
	 */
	transformCameraUpdate: CameraUpdateTransformFunction | null;
	abstract _requestRenderFrame(a: () => void): TaskID;
	abstract _cancelRenderFrame(_: TaskID): void;
	constructor(transform: Transform, options: {
		bearingSnap: number;
	});
	/**
	 * Returns the map's geographical centerpoint.
	 *
	 * @memberof Map#
	 * @returns The map's geographical centerpoint.
	 * @example
	 * // return a LngLat object such as {lng: 0, lat: 0}
	 * var center = map.getCenter();
	 * // access longitude and latitude values directly
	 * var {lng, lat} = map.getCenter();
	 */
	getCenter(): LngLat;
	/**
	 * Sets the map's geographical centerpoint. Equivalent to `jumpTo({center: center})`.
	 *
	 * @memberof Map#
	 * @param center The centerpoint to set.
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 * @example
	 * map.setCenter([-74, 38]);
	 */
	setCenter(center: LngLatLike, eventData?: any): this;
	/**
	 * Pans the map by the specified offset.
	 *
	 * @memberof Map#
	 * @param offset `x` and `y` coordinates by which to pan the map.
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 * @see [Navigate the map with game-like controls](https://maplibre.org/maplibre-gl-js-docs/example/game-controls/)
	 */
	panBy(offset: PointLike, options?: AnimationOptions, eventData?: any): this;
	/**
	 * Pans the map to the specified location with an animated transition.
	 *
	 * @memberof Map#
	 * @param lnglat The location to pan the map to.
	 * @param options Options describing the destination and animation of the transition.
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 * @example
	 * map.panTo([-74, 38]);
	 * @example
	 * // Specify that the panTo animation should last 5000 milliseconds.
	 * map.panTo([-74, 38], {duration: 5000});
	 * @see [Update a feature in realtime](https://maplibre.org/maplibre-gl-js-docs/example/live-update-feature/)
	 */
	panTo(lnglat: LngLatLike, options?: AnimationOptions, eventData?: any): this;
	/**
	 * Returns the map's current zoom level.
	 *
	 * @memberof Map#
	 * @returns The map's current zoom level.
	 * @example
	 * map.getZoom();
	 */
	getZoom(): number;
	/**
	 * Sets the map's zoom level. Equivalent to `jumpTo({zoom: zoom})`.
	 *
	 * @memberof Map#
	 * @param zoom The zoom level to set (0-20).
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires zoomstart
	 * @fires move
	 * @fires zoom
	 * @fires moveend
	 * @fires zoomend
	 * @returns {Map} `this`
	 * @example
	 * // Zoom to the zoom level 5 without an animated transition
	 * map.setZoom(5);
	 */
	setZoom(zoom: number, eventData?: any): this;
	/**
	 * Zooms the map to the specified zoom level, with an animated transition.
	 *
	 * @memberof Map#
	 * @param zoom The zoom level to transition to.
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires zoomstart
	 * @fires move
	 * @fires zoom
	 * @fires moveend
	 * @fires zoomend
	 * @returns {Map} `this`
	 * @example
	 * // Zoom to the zoom level 5 without an animated transition
	 * map.zoomTo(5);
	 * // Zoom to the zoom level 8 with an animated transition
	 * map.zoomTo(8, {
	 *   duration: 2000,
	 *   offset: [100, 50]
	 * });
	 */
	zoomTo(zoom: number, options?: AnimationOptions | null, eventData?: any): this;
	/**
	 * Increases the map's zoom level by 1.
	 *
	 * @memberof Map#
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires zoomstart
	 * @fires move
	 * @fires zoom
	 * @fires moveend
	 * @fires zoomend
	 * @returns {Map} `this`
	 * @example
	 * // zoom the map in one level with a custom animation duration
	 * map.zoomIn({duration: 1000});
	 */
	zoomIn(options?: AnimationOptions, eventData?: any): this;
	/**
	 * Decreases the map's zoom level by 1.
	 *
	 * @memberof Map#
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires zoomstart
	 * @fires move
	 * @fires zoom
	 * @fires moveend
	 * @fires zoomend
	 * @returns {Map} `this`
	 * @example
	 * // zoom the map out one level with a custom animation offset
	 * map.zoomOut({offset: [80, 60]});
	 */
	zoomOut(options?: AnimationOptions, eventData?: any): this;
	/**
	 * Returns the map's current bearing. The bearing is the compass direction that is "up"; for example, a bearing
	 * of 90° orients the map so that east is up.
	 *
	 * @memberof Map#
	 * @returns The map's current bearing.
	 * @see [Navigate the map with game-like controls](https://maplibre.org/maplibre-gl-js-docs/example/game-controls/)
	 */
	getBearing(): number;
	/**
	 * Sets the map's bearing (rotation). The bearing is the compass direction that is "up"; for example, a bearing
	 * of 90° orients the map so that east is up.
	 *
	 * Equivalent to `jumpTo({bearing: bearing})`.
	 *
	 * @memberof Map#
	 * @param bearing The desired bearing.
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 * @example
	 * // rotate the map to 90 degrees
	 * map.setBearing(90);
	 */
	setBearing(bearing: number, eventData?: any): this;
	/**
	 * Returns the current padding applied around the map viewport.
	 *
	 * @memberof Map#
	 * @returns The current padding around the map viewport.
	 */
	getPadding(): PaddingOptions;
	/**
	 * Sets the padding in pixels around the viewport.
	 *
	 * Equivalent to `jumpTo({padding: padding})`.
	 *
	 * @memberof Map#
	 * @param padding The desired padding. Format: { left: number, right: number, top: number, bottom: number }
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 * @example
	 * // Sets a left padding of 300px, and a top padding of 50px
	 * map.setPadding({ left: 300, top: 50 });
	 */
	setPadding(padding: PaddingOptions, eventData?: any): this;
	/**
	 * Rotates the map to the specified bearing, with an animated transition. The bearing is the compass direction
	 * that is \"up\"; for example, a bearing of 90° orients the map so that east is up.
	 *
	 * @memberof Map#
	 * @param bearing The desired bearing.
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 */
	rotateTo(bearing: number, options?: AnimationOptions, eventData?: any): this;
	/**
	 * Rotates the map so that north is up (0° bearing), with an animated transition.
	 *
	 * @memberof Map#
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 */
	resetNorth(options?: AnimationOptions, eventData?: any): this;
	/**
	 * Rotates and pitches the map so that north is up (0° bearing) and pitch is 0°, with an animated transition.
	 *
	 * @memberof Map#
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 */
	resetNorthPitch(options?: AnimationOptions, eventData?: any): this;
	/**
	 * Snaps the map so that north is up (0° bearing), if the current bearing is close enough to it (i.e. within the
	 * `bearingSnap` threshold).
	 *
	 * @memberof Map#
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 */
	snapToNorth(options?: AnimationOptions, eventData?: any): this;
	/**
	 * Returns the map's current pitch (tilt).
	 *
	 * @memberof Map#
	 * @returns The map's current pitch, measured in degrees away from the plane of the screen.
	 */
	getPitch(): number;
	/**
	 * Sets the map's pitch (tilt). Equivalent to `jumpTo({pitch: pitch})`.
	 *
	 * @memberof Map#
	 * @param pitch The pitch to set, measured in degrees away from the plane of the screen (0-60).
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires pitchstart
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 */
	setPitch(pitch: number, eventData?: any): this;
	/**
	 * @memberof Map#
	 * @param {LngLatBoundsLike} bounds Calculate the center for these bounds in the viewport and use
	 * the highest zoom level up to and including `Map#getMaxZoom()` that fits
	 * in the viewport. LngLatBounds represent a box that is always axis-aligned with bearing 0.
	 * @param options Options object
	 * @param {number | PaddingOptions} [options.padding] The amount of padding in pixels to add to the given bounds.
	 * @param {number} [options.bearing=0] Desired map bearing at end of animation, in degrees.
	 * @param {PointLike} [options.offset=[0, 0]] The center of the given bounds relative to the map's center, measured in pixels.
	 * @param {number} [options.maxZoom] The maximum zoom level to allow when the camera would transition to the specified bounds.
	 * @returns {CenterZoomBearing} If map is able to fit to provided bounds, returns `center`, `zoom`, and `bearing`.
	 * If map is unable to fit, method will warn and return undefined.
	 * @example
	 * var bbox = [[-79, 43], [-73, 45]];
	 * var newCameraTransform = map.cameraForBounds(bbox, {
	 *   padding: {top: 10, bottom:25, left: 15, right: 5}
	 * });
	 */
	cameraForBounds(bounds: LngLatBoundsLike, options?: CameraForBoundsOptions): CenterZoomBearing;
	/**
	 * Calculate the center of these two points in the viewport and use
	 * the highest zoom level up to and including `Map#getMaxZoom()` that fits
	 * the points in the viewport at the specified bearing.
	 * @memberof Map#
	 * @param {LngLatLike} p0 First point
	 * @param {LngLatLike} p1 Second point
	 * @param bearing Desired map bearing at end of animation, in degrees
	 * @param options
	 * @param {number | PaddingOptions} [options.padding] The amount of padding in pixels to add to the given bounds.
	 * @param {PointLike} [options.offset=[0, 0]] The center of the given bounds relative to the map's center, measured in pixels.
	 * @param {number} [options.maxZoom] The maximum zoom level to allow when the camera would transition to the specified bounds.
	 * @returns {CenterZoomBearing} If map is able to fit to provided bounds, returns `center`, `zoom`, and `bearing`.
	 *      If map is unable to fit, method will warn and return undefined.
	 * @private
	 * @example
	 * var p0 = [-79, 43];
	 * var p1 = [-73, 45];
	 * var bearing = 90;
	 * var newCameraTransform = map._cameraForBoxAndBearing(p0, p1, bearing, {
	 *   padding: {top: 10, bottom:25, left: 15, right: 5}
	 * });
	 */
	_cameraForBoxAndBearing(p0: LngLatLike, p1: LngLatLike, bearing: number, options?: CameraForBoundsOptions): CenterZoomBearing;
	/**
	 * Pans and zooms the map to contain its visible area within the specified geographical bounds.
	 * This function will also reset the map's bearing to 0 if bearing is nonzero.
	 *
	 * @memberof Map#
	 * @param bounds Center these bounds in the viewport and use the highest
	 * zoom level up to and including `Map#getMaxZoom()` that fits them in the viewport.
	 * @param {FitBoundsOptions} [options] Options supports all properties from {@link AnimationOptions} and {@link CameraOptions} in addition to the fields below.
	 * @param {number | PaddingOptions} [options.padding] The amount of padding in pixels to add to the given bounds.
	 * @param {boolean} [options.linear=false] If `true`, the map transitions using
	 * {@link Map#easeTo}. If `false`, the map transitions using {@link Map#flyTo}. See
	 * those functions and {@link AnimationOptions} for information about options available.
	 * @param {Function} [options.easing] An easing function for the animated transition. See {@link AnimationOptions}.
	 * @param {PointLike} [options.offset=[0, 0]] The center of the given bounds relative to the map's center, measured in pixels.
	 * @param {number} [options.maxZoom] The maximum zoom level to allow when the map view transitions to the specified bounds.
	 * @param {Object} [eventData] Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 * @example
	 * var bbox = [[-79, 43], [-73, 45]];
	 * map.fitBounds(bbox, {
	 *   padding: {top: 10, bottom:25, left: 15, right: 5}
	 * });
	 * @see [Fit a map to a bounding box](https://maplibre.org/maplibre-gl-js-docs/example/fitbounds/)
	 */
	fitBounds(bounds: LngLatBoundsLike, options?: FitBoundsOptions, eventData?: any): this;
	/**
	 * Pans, rotates and zooms the map to to fit the box made by points p0 and p1
	 * once the map is rotated to the specified bearing. To zoom without rotating,
	 * pass in the current map bearing.
	 *
	 * @memberof Map#
	 * @param p0 First point on screen, in pixel coordinates
	 * @param p1 Second point on screen, in pixel coordinates
	 * @param bearing Desired map bearing at end of animation, in degrees
	 * @param options Options object
	 * @param {number | PaddingOptions} [options.padding] The amount of padding in pixels to add to the given bounds.
	 * @param {boolean} [options.linear=false] If `true`, the map transitions using
	 * {@link Map#easeTo}. If `false`, the map transitions using {@link Map#flyTo}. See
	 * those functions and {@link AnimationOptions} for information about options available.
	 * @param {Function} [options.easing] An easing function for the animated transition. See {@link AnimationOptions}.
	 * @param {PointLike} [options.offset=[0, 0]] The center of the given bounds relative to the map's center, measured in pixels.
	 * @param {number} [options.maxZoom] The maximum zoom level to allow when the map view transitions to the specified bounds.
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires moveend
	 * @returns {Map} `this`
	 * @example
	 * var p0 = [220, 400];
	 * var p1 = [500, 900];
	 * map.fitScreenCoordinates(p0, p1, map.getBearing(), {
	 *   padding: {top: 10, bottom:25, left: 15, right: 5}
	 * });
	 * @see Used by {@link BoxZoomHandler}
	 */
	fitScreenCoordinates(p0: PointLike, p1: PointLike, bearing: number, options?: FitBoundsOptions, eventData?: any): this;
	_fitInternal(calculatedOptions?: CenterZoomBearing, options?: FitBoundsOptions, eventData?: any): this;
	/**
	 * Changes any combination of center, zoom, bearing, and pitch, without
	 * an animated transition. The map will retain its current values for any
	 * details not specified in `options`.
	 *
	 * @memberof Map#
	 * @param options Options object
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires zoomstart
	 * @fires pitchstart
	 * @fires rotate
	 * @fires move
	 * @fires zoom
	 * @fires pitch
	 * @fires moveend
	 * @fires zoomend
	 * @fires pitchend
	 * @returns {Map} `this`
	 * @example
	 * // jump to coordinates at current zoom
	 * map.jumpTo({center: [0, 0]});
	 * // jump with zoom, pitch, and bearing options
	 * map.jumpTo({
	 *   center: [0, 0],
	 *   zoom: 8,
	 *   pitch: 45,
	 *   bearing: 90
	 * });
	 * @see [Jump to a series of locations](https://maplibre.org/maplibre-gl-js-docs/example/jump-to/)
	 * @see [Update a feature in realtime](https://maplibre.org/maplibre-gl-js-docs/example/live-update-feature/)
	 */
	jumpTo(options: JumpToOptions, eventData?: any): this;
	/**
	 * Calculates pitch, zoom and bearing for looking at @param newCenter with the camera position being @param newCenter
	 * and returns them as Cameraoptions.
	 * @memberof Map#
	 * @param from The camera to look from
	 * @param altitudeFrom The altitude of the camera to look from
	 * @param to The center to look at
	 * @param altitudeTo Optional altitude of the center to look at. If none given the ground height will be used.
	 * @returns {CameraOptions} the calculated camera options
	 */
	calculateCameraOptionsFromTo(from: LngLat, altitudeFrom: number, to: LngLat, altitudeTo?: number): CameraOptions;
	/**
	 * Changes any combination of `center`, `zoom`, `bearing`, `pitch`, and `padding` with an animated transition
	 * between old and new values. The map will retain its current values for any
	 * details not specified in `options`.
	 *
	 * Note: The transition will happen instantly if the user has enabled
	 * the `reduced motion` accessibility feature enabled in their operating system,
	 * unless `options` includes `essential: true`.
	 *
	 * @memberof Map#
	 * @param options Options describing the destination and animation of the transition.
	 * Accepts {@link CameraOptions} and {@link AnimationOptions}.
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires zoomstart
	 * @fires pitchstart
	 * @fires rotate
	 * @fires move
	 * @fires zoom
	 * @fires pitch
	 * @fires moveend
	 * @fires zoomend
	 * @fires pitchend
	 * @returns {Map} `this`
	 * @see [Navigate the map with game-like controls](https://maplibre.org/maplibre-gl-js-docs/example/game-controls/)
	 */
	easeTo(options: EaseToOptions & {
		easeId?: string;
		noMoveStart?: boolean;
	}, eventData?: any): this;
	_prepareEase(eventData: any, noMoveStart: boolean, currently?: any): void;
	_prepareElevation(center: LngLat): void;
	_updateElevation(k: number): void;
	_finalizeElevation(): void;
	/**
	 * Called when the camera is about to be manipulated.
	 * If `transformCameraUpdate` is specified, a copy of the current transform is created to track the accumulated changes.
	 * This underlying transform represents the "desired state" proposed by input handlers / animations / UI controls.
	 * It may differ from the state used for rendering (`this.transform`).
	 * @returns Transform to apply changes to
	 */
	_getTransformForUpdate(): Transform;
	/**
	 * Called after the camera is done being manipulated.
	 * @param {Transform} tr - the requested camera end state
	 * Call `transformCameraUpdate` if present, and then apply the "approved" changes.
	 */
	_applyUpdatedTransform(tr: Transform): void;
	_fireMoveEvents(eventData?: any): void;
	_afterEase(eventData?: any, easeId?: string): void;
	/**
	 * Changes any combination of center, zoom, bearing, and pitch, animating the transition along a curve that
	 * evokes flight. The animation seamlessly incorporates zooming and panning to help
	 * the user maintain her bearings even after traversing a great distance.
	 *
	 * Note: The animation will be skipped, and this will behave equivalently to `jumpTo`
	 * if the user has the `reduced motion` accessibility feature enabled in their operating system,
	 * unless 'options' includes `essential: true`.
	 *
	 * @memberof Map#
	 * @param {FlyToOptions} options Options describing the destination and animation of the transition.
	 * Accepts {@link CameraOptions}, {@link AnimationOptions},
	 * and the following additional options.
	 * @param {number} [options.curve=1.42] The zooming "curve" that will occur along the
	 * flight path. A high value maximizes zooming for an exaggerated animation, while a low
	 * value minimizes zooming for an effect closer to {@link Map#easeTo}. 1.42 is the average
	 * value selected by participants in the user study discussed in
	 * [van Wijk (2003)](https://www.win.tue.nl/~vanwijk/zoompan.pdf). A value of
	 * `Math.pow(6, 0.25)` would be equivalent to the root mean squared average velocity. A
	 * value of 1 would produce a circular motion.
	 * @param {number} [options.minZoom] The zero-based zoom level at the peak of the flight path. If
	 * `options.curve` is specified, this option is ignored.
	 * @param {number} [options.speed=1.2] The average speed of the animation defined in relation to
	 * `options.curve`. A speed of 1.2 means that the map appears to move along the flight path
	 * by 1.2 times `options.curve` screenfuls every second. A _screenful_ is the map's visible span.
	 * It does not correspond to a fixed physical distance, but varies by zoom level.
	 * @param {number} [options.screenSpeed] The average speed of the animation measured in screenfuls
	 * per second, assuming a linear timing curve. If `options.speed` is specified, this option is ignored.
	 * @param {number} [options.maxDuration] The animation's maximum duration, measured in milliseconds.
	 * If duration exceeds maximum duration, it resets to 0.
	 * @param eventData Additional properties to be added to event objects of events triggered by this method.
	 * @fires movestart
	 * @fires zoomstart
	 * @fires pitchstart
	 * @fires move
	 * @fires zoom
	 * @fires rotate
	 * @fires pitch
	 * @fires moveend
	 * @fires zoomend
	 * @fires pitchend
	 * @returns {Map} `this`
	 * @example
	 * // fly with default options to null island
	 * map.flyTo({center: [0, 0], zoom: 9});
	 * // using flyTo options
	 * map.flyTo({
	 *   center: [0, 0],
	 *   zoom: 9,
	 *   speed: 0.2,
	 *   curve: 1,
	 *   easing(t) {
	 *     return t;
	 *   }
	 * });
	 * @see [Fly to a location](https://maplibre.org/maplibre-gl-js-docs/example/flyto/)
	 * @see [Slowly fly to a location](https://maplibre.org/maplibre-gl-js-docs/example/flyto-options/)
	 * @see [Fly to a location based on scroll position](https://maplibre.org/maplibre-gl-js-docs/example/scroll-fly-to/)
	 */
	flyTo(options: FlyToOptions, eventData?: any): this;
	isEasing(): boolean;
	/**
	 * Stops any animated transition underway.
	 *
	 * @memberof Map#
	 * @returns {Map} `this`
	 */
	stop(): this;
	_stop(allowGestures?: boolean, easeId?: string): this;
	_ease(frame: (_: number) => void, finish: () => void, options: {
		animate?: boolean;
		duration?: number;
		easing?: (_: number) => number;
	}): void;
	_renderFrameCallback(): void;
	_normalizeBearing(bearing: number, currentBearing: number): number;
	_normalizeCenter(center: LngLat): void;
	/**
	 * Query the current elevation of location. It return null if terrain is not enabled. the elevation is in meters relative to mean sea-level
	 * @memberof Map#
	 * @param lngLatLike [x,y] or LngLat coordinates of the location
	 * @returns {number} elevation in meters
	 */
	queryTerrainElevation(lngLatLike: LngLatLike): number | null;
}
export type MapLayerMouseEvent = MapMouseEvent & {
	features?: MapGeoJSONFeature[];
};
export type MapLayerTouchEvent = MapTouchEvent & {
	features?: MapGeoJSONFeature[];
};
export type MapSourceDataType = "content" | "metadata" | "visibility" | "idle";
export type MapLayerEventType = {
	click: MapLayerMouseEvent;
	dblclick: MapLayerMouseEvent;
	mousedown: MapLayerMouseEvent;
	mouseup: MapLayerMouseEvent;
	mousemove: MapLayerMouseEvent;
	mouseenter: MapLayerMouseEvent;
	mouseleave: MapLayerMouseEvent;
	mouseover: MapLayerMouseEvent;
	mouseout: MapLayerMouseEvent;
	contextmenu: MapLayerMouseEvent;
	touchstart: MapLayerTouchEvent;
	touchend: MapLayerTouchEvent;
	touchcancel: MapLayerTouchEvent;
};
export interface MapLibreEvent<TOrig = unknown> {
	type: string;
	target: Map;
	originalEvent: TOrig;
}
export interface MapStyleDataEvent extends MapLibreEvent {
	dataType: "style";
}
export interface MapSourceDataEvent extends MapLibreEvent {
	dataType: "source";
	isSourceLoaded: boolean;
	source: SourceSpecification;
	sourceId: string;
	sourceDataType: MapSourceDataType;
	tile: any;
}
export declare class MapMouseEvent extends Event implements MapLibreEvent<MouseEvent> {
	/**
	 * The event type (one of {@link Map.event:mousedown},
	 * {@link Map.event:mouseup},
	 * {@link Map.event:click},
	 * {@link Map.event:dblclick},
	 * {@link Map.event:mousemove},
	 * {@link Map.event:mouseover},
	 * {@link Map.event:mouseenter},
	 * {@link Map.event:mouseleave},
	 * {@link Map.event:mouseout},
	 * {@link Map.event:contextmenu}).
	 */
	type: "mousedown" | "mouseup" | "click" | "dblclick" | "mousemove" | "mouseover" | "mouseenter" | "mouseleave" | "mouseout" | "contextmenu";
	/**
	 * The `Map` object that fired the event.
	 */
	target: Map;
	/**
	 * The DOM event which caused the map event.
	 */
	originalEvent: MouseEvent;
	/**
	 * The pixel coordinates of the mouse cursor, relative to the map and measured from the top left corner.
	 */
	point: Point;
	/**
	 * The geographic location on the map of the mouse cursor.
	 */
	lngLat: LngLat;
	/**
	 * Prevents subsequent default processing of the event by the map.
	 *
	 * Calling this method will prevent the following default map behaviors:
	 *
	 *   * On `mousedown` events, the behavior of {@link DragPanHandler}
	 *   * On `mousedown` events, the behavior of {@link DragRotateHandler}
	 *   * On `mousedown` events, the behavior of {@link BoxZoomHandler}
	 *   * On `dblclick` events, the behavior of {@link DoubleClickZoomHandler}
	 *
	 */
	preventDefault(): void;
	/**
	 * `true` if `preventDefault` has been called.
	 * @private
	 */
	get defaultPrevented(): boolean;
	_defaultPrevented: boolean;
	/**
	 * @private
	 */
	constructor(type: string, map: Map, originalEvent: MouseEvent, data?: any);
}
export declare class MapTouchEvent extends Event implements MapLibreEvent<TouchEvent> {
	/**
	 * The event type.
	 */
	type: "touchstart" | "touchmove" | "touchend" | "touchcancel";
	/**
	 * The `Map` object that fired the event.
	 */
	target: Map;
	/**
	 * The DOM event which caused the map event.
	 */
	originalEvent: TouchEvent;
	/**
	 * The geographic location on the map of the center of the touch event points.
	 */
	lngLat: LngLat;
	/**
	 * The pixel coordinates of the center of the touch event points, relative to the map and measured from the top left
	 * corner.
	 */
	point: Point;
	/**
	 * The array of pixel coordinates corresponding to a
	 * [touch event's `touches`](https://developer.mozilla.org/en-US/docs/Web/API/TouchEvent/touches) property.
	 */
	points: Array<Point>;
	/**
	 * The geographical locations on the map corresponding to a
	 * [touch event's `touches`](https://developer.mozilla.org/en-US/docs/Web/API/TouchEvent/touches) property.
	 */
	lngLats: Array<LngLat>;
	/**
	 * Prevents subsequent default processing of the event by the map.
	 *
	 * Calling this method will prevent the following default map behaviors:
	 *
	 *   * On `touchstart` events, the behavior of {@link DragPanHandler}
	 *   * On `touchstart` events, the behavior of {@link TouchZoomRotateHandler}
	 *
	 */
	preventDefault(): void;
	/**
	 * `true` if `preventDefault` has been called.
	 * @private
	 */
	get defaultPrevented(): boolean;
	_defaultPrevented: boolean;
	/**
	 * @private
	 */
	constructor(type: string, map: Map, originalEvent: TouchEvent);
}
export declare class MapWheelEvent extends Event {
	/**
	 * The event type.
	 */
	type: "wheel";
	/**
	 * The `Map` object that fired the event.
	 */
	target: Map;
	/**
	 * The DOM event which caused the map event.
	 */
	originalEvent: WheelEvent;
	/**
	 * Prevents subsequent default processing of the event by the map.
	 *
	 * Calling this method will prevent the the behavior of {@link ScrollZoomHandler}.
	 */
	preventDefault(): void;
	/**
	 * `true` if `preventDefault` has been called.
	 * @private
	 */
	get defaultPrevented(): boolean;
	_defaultPrevented: boolean;
	/**
	 * @private
	 */
	constructor(type: string, map: Map, originalEvent: WheelEvent);
}
/**
 * A `MapLibreZoomEvent` is the event type for the boxzoom-related map events emitted by the {@link BoxZoomHandler}.
 *
 * @typedef {Object} MapLibreZoomEvent
 * @property {MouseEvent} originalEvent The DOM event that triggered the boxzoom event. Can be a `MouseEvent` or `KeyboardEvent`
 * @property {string} type The type of boxzoom event. One of `boxzoomstart`, `boxzoomend` or `boxzoomcancel`
 * @property {Map} target The `Map` instance that triggered the event
 */
export type MapLibreZoomEvent = {
	type: "boxzoomstart" | "boxzoomend" | "boxzoomcancel";
	target: Map;
	originalEvent: MouseEvent;
};
/**
 * A `MapDataEvent` object is emitted with the {@link Map.event:data}
 * and {@link Map.event:dataloading} events. Possible values for
 * `dataType`s are:
 *
 * - `'source'`: The non-tile data associated with any source
 * - `'style'`: The [style](https://maplibre.org/maplibre-style-spec/) used by the map
 *
 * Possible values for `sourceDataType`s are:
 *
 * - `'metadata'`: indicates that any necessary source metadata has been loaded (such as TileJSON) and it is ok to start loading tiles
 * - `'content'`: indicates the source data has changed (such as when source.setData() has been called on GeoJSONSource)
 * - `'visibility'`: send when the source becomes used when at least one of its layers becomes visible in style sense (inside the layer's zoom range and with layout.visibility set to 'visible')
 * - `'idle'`: indicates that no new source data has been fetched (but the source has done loading)
 *
 * @typedef {Object} MapDataEvent
 * @property {string} type The event type.
 * @property {string} dataType The type of data that has changed. One of `'source'`, `'style'`.
 * @property {boolean} [isSourceLoaded] True if the event has a `dataType` of `source` and the source has no outstanding network requests.
 * @property {Object} [source] The [style spec representation of the source](https://maplibre.org/maplibre-style-spec/#sources) if the event has a `dataType` of `source`.
 * @property {string} [sourceDataType] Included if the event has a `dataType` of `source` and the event signals
 * that internal data has been received or changed. Possible values are `metadata`, `content`, `visibility` and `idle`.
 * @property {Object} [tile] The tile being loaded or changed, if the event has a `dataType` of `source` and
 * the event is related to loading of a tile.
 * @property {Coordinates} [coord] The coordinate of the tile if the event has a `dataType` of `source` and
 * the event is related to loading of a tile.
 * @example
 * // The sourcedata event is an example of MapDataEvent.
 * // Set up an event listener on the map.
 * map.on('sourcedata', function(e) {
 *    if (e.isSourceLoaded) {
 *        // Do something when the source has finished loading
 *    }
 * });
 */
export type MapDataEvent = {
	type: string;
	dataType: string;
	sourceDataType: MapSourceDataType;
};
export type MapTerrainEvent = {
	type: "terrain";
};
export type MapContextEvent = {
	type: "webglcontextlost" | "webglcontextrestored";
	originalEvent: WebGLContextEvent;
};
export interface MapStyleImageMissingEvent extends MapLibreEvent {
	type: "styleimagemissing";
	id: string;
}
/**
 * MapEventType - a mapping between the event name and the event value
 */
export type MapEventType = {
	error: ErrorEvent;
	load: MapLibreEvent;
	idle: MapLibreEvent;
	remove: MapLibreEvent;
	render: MapLibreEvent;
	resize: MapLibreEvent;
	webglcontextlost: MapContextEvent;
	webglcontextrestored: MapContextEvent;
	dataloading: MapDataEvent;
	data: MapDataEvent;
	tiledataloading: MapDataEvent;
	sourcedataloading: MapSourceDataEvent;
	styledataloading: MapStyleDataEvent;
	sourcedata: MapSourceDataEvent;
	styledata: MapStyleDataEvent;
	styleimagemissing: MapStyleImageMissingEvent;
	dataabort: MapDataEvent;
	sourcedataabort: MapSourceDataEvent;
	boxzoomcancel: MapLibreZoomEvent;
	boxzoomstart: MapLibreZoomEvent;
	boxzoomend: MapLibreZoomEvent;
	touchcancel: MapTouchEvent;
	touchmove: MapTouchEvent;
	touchend: MapTouchEvent;
	touchstart: MapTouchEvent;
	click: MapMouseEvent;
	contextmenu: MapMouseEvent;
	dblclick: MapMouseEvent;
	mousemove: MapMouseEvent;
	mouseup: MapMouseEvent;
	mousedown: MapMouseEvent;
	mouseout: MapMouseEvent;
	mouseover: MapMouseEvent;
	movestart: MapLibreEvent<MouseEvent | TouchEvent | WheelEvent | undefined>;
	move: MapLibreEvent<MouseEvent | TouchEvent | WheelEvent | undefined>;
	moveend: MapLibreEvent<MouseEvent | TouchEvent | WheelEvent | undefined>;
	zoomstart: MapLibreEvent<MouseEvent | TouchEvent | WheelEvent | undefined>;
	zoom: MapLibreEvent<MouseEvent | TouchEvent | WheelEvent | undefined>;
	zoomend: MapLibreEvent<MouseEvent | TouchEvent | WheelEvent | undefined>;
	rotatestart: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	rotate: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	rotateend: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	dragstart: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	drag: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	dragend: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	pitchstart: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	pitch: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	pitchend: MapLibreEvent<MouseEvent | TouchEvent | undefined>;
	wheel: MapWheelEvent;
	terrain: MapTerrainEvent;
};
export type MapEvent = 
/**
 * Fired when a pointing device (usually a mouse) is pressed within the map.
 *
 * **Note:** This event is compatible with the optional `layerId` parameter.
 * If `layerId` is included as the second argument in {@link Map#on}, the event listener will fire only when the
 * the cursor is pressed while inside a visible portion of the specified layer.
 *
 * @event mousedown
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener
 * map.on('mousedown', function() {
 *   console.log('A mousedown event has occurred.');
 * });
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener for a specific layer
 * map.on('mousedown', 'poi-label', function() {
 *   console.log('A mousedown event has occurred on a visible portion of the poi-label layer.');
 * });
 * @see [Create a draggable point](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
 */
"mousedown"
/**
 * Fired when a pointing device (usually a mouse) is released within the map.
 *
 * **Note:** This event is compatible with the optional `layerId` parameter.
 * If `layerId` is included as the second argument in {@link Map#on}, the event listener will fire only when the
 * the cursor is released while inside a visible portion of the specified layer.
 *
 * @event mouseup
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener
 * map.on('mouseup', function() {
 *   console.log('A mouseup event has occurred.');
 * });
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener for a specific layer
 * map.on('mouseup', 'poi-label', function() {
 *   console.log('A mouseup event has occurred on a visible portion of the poi-label layer.');
 * });
 * @see [Create a draggable point](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
 */
 | "mouseup"
/**
 * Fired when a pointing device (usually a mouse) is moved within the map.
 * As you move the cursor across a web page containing a map,
 * the event will fire each time it enters the map or any child elements.
 *
 * **Note:** This event is compatible with the optional `layerId` parameter.
 * If `layerId` is included as the second argument in {@link Map#on}, the event listener will fire only when the
 * the cursor is moved inside a visible portion of the specified layer.
 *
 * @event mouseover
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener
 * map.on('mouseover', function() {
 *   console.log('A mouseover event has occurred.');
 * });
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener for a specific layer
 * map.on('mouseover', 'poi-label', function() {
 *   console.log('A mouseover event has occurred on a visible portion of the poi-label layer.');
 * });
 * @see [Get coordinates of the mouse pointer](https://maplibre.org/maplibre-gl-js-docs/example/mouse-position/)
 * @see [Highlight features under the mouse pointer](https://maplibre.org/maplibre-gl-js-docs/example/hover-styles/)
 * @see [Display a popup on hover](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-hover/)
 */
 | "mouseover"
/**
 * Fired when a pointing device (usually a mouse) is moved while the cursor is inside the map.
 * As you move the cursor across the map, the event will fire every time the cursor changes position within the map.
 *
 * **Note:** This event is compatible with the optional `layerId` parameter.
 * If `layerId` is included as the second argument in {@link Map#on}, the event listener will fire only when the
 * the cursor is inside a visible portion of the specified layer.
 *
 * @event mousemove
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener
 * map.on('mousemove', function() {
 *   console.log('A mousemove event has occurred.');
 * });
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener for a specific layer
 * map.on('mousemove', 'poi-label', function() {
 *   console.log('A mousemove event has occurred on a visible portion of the poi-label layer.');
 * });
 * @see [Get coordinates of the mouse pointer](https://maplibre.org/maplibre-gl-js-docs/example/mouse-position/)
 * @see [Highlight features under the mouse pointer](https://maplibre.org/maplibre-gl-js-docs/example/hover-styles/)
 * @see [Display a popup on over](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-hover/)
 */
 | "mousemove"
/**
 * Fired when a pointing device (usually a mouse) is pressed and released at the same point on the map.
 *
 * **Note:** This event is compatible with the optional `layerId` parameter.
 * If `layerId` is included as the second argument in {@link Map#on}, the event listener will fire only when the
 * point that is pressed and released contains a visible portion of the specified layer.
 *
 * @event click
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener
 * map.on('click', function(e) {
 *   console.log('A click event has occurred at ' + e.lngLat);
 * });
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener for a specific layer
 * map.on('click', 'poi-label', function(e) {
 *   console.log('A click event has occurred on a visible portion of the poi-label layer at ' + e.lngLat);
 * });
 * @see [Measure distances](https://maplibre.org/maplibre-gl-js-docs/example/measure/)
 * @see [Center the map on a clicked symbol](https://maplibre.org/maplibre-gl-js-docs/example/center-on-symbol/)
 */
 | "click"
/**
 * Fired when a pointing device (usually a mouse) is pressed and released twice at the same point on
 * the map in rapid succession.
 *
 * **Note:** This event is compatible with the optional `layerId` parameter.
 * If `layerId` is included as the second argument in {@link Map#on}, the event listener will fire only
 * when the point that is clicked twice contains a visible portion of the specified layer.
 *
 * **Note:** Under normal conditions, this event will be preceded by two {@link Map.event:click} events.
 *
 * @event dblclick
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener
 * map.on('dblclick', function(e) {
 *   console.log('A dblclick event has occurred at ' + e.lngLat);
 * });
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener for a specific layer
 * map.on('dblclick', 'poi-label', function(e) {
 *   console.log('A dblclick event has occurred on a visible portion of the poi-label layer at ' + e.lngLat);
 * });
 */
 | "dblclick"
/**
 * Fired when a pointing device (usually a mouse) enters a visible portion of a specified layer from
 * outside that layer or outside the map canvas.
 *
 * **Important:** This event can only be listened for when {@link Map#on} includes three arguments,
 * where the second argument specifies the desired layer.
 *
 * @event mouseenter
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener
 * map.on('mouseenter', 'water', function() {
 *   console.log('A mouseenter event occurred on a visible portion of the water layer.');
 * });
 * @see [Center the map on a clicked symbol](https://maplibre.org/maplibre-gl-js-docs/example/center-on-symbol/)
 * @see [Display a popup on click](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-click/)
 */
 | "mouseenter"
/**
 * Fired when a pointing device (usually a mouse) leaves a visible portion of a specified layer, or leaves
 * the map canvas.
 *
 * **Important:** This event can only be listened for when {@link Map#on} includes three arguments,
 * where the second argument specifies the desired layer.
 *
 * @event mouseleave
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when the pointing device leaves
 * // a visible portion of the specified layer.
 * map.on('mouseleave', 'water', function() {
 *   console.log('A mouseleave event occurred.');
 * });
 * @see [Highlight features under the mouse pointer](https://maplibre.org/maplibre-gl-js-docs/example/hover-styles/)
 * @see [Display a popup on click](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-click/)
 */
 | "mouseleave"
/**
 * Fired when a point device (usually a mouse) leaves the map's canvas.
 *
 * @event mouseout
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when the pointing device leave's
 * // the map's canvas.
 * map.on('mouseout', function() {
 *   console.log('A mouseout event occurred.');
 * });
 */
 | "mouseout"
/**
 * Fired when the right button of the mouse is clicked or the context menu key is pressed within the map.
 *
 * @event contextmenu
 * @memberof Map
 * @instance
 * @property {MapMouseEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when the right mouse button is
 * // pressed within the map.
 * map.on('contextmenu', function() {
 *   console.log('A contextmenu event occurred.');
 * });
 */
 | "contextmenu"
/**
 * Fired when a [`wheel`](https://developer.mozilla.org/en-US/docs/Web/Events/wheel) event occurs within the map.
 *
 * @event wheel
 * @memberof Map
 * @instance
 * @property {MapWheelEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a wheel event occurs within the map.
 * map.on('wheel', function() {
 *   console.log('A wheel event occurred.');
 * });
 */
 | "wheel"
/**
 * Fired when a [`touchstart`](https://developer.mozilla.org/en-US/docs/Web/Events/touchstart) event occurs within the map.
 *
 * @event touchstart
 * @memberof Map
 * @instance
 * @property {MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a touchstart event occurs within the map.
 * map.on('touchstart', function() {
 *   console.log('A touchstart event occurred.');
 * });
 * @see [Create a draggable point](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
 */
 | "touchstart"
/**
 * Fired when a [`touchend`](https://developer.mozilla.org/en-US/docs/Web/Events/touchend) event occurs within the map.
 *
 * @event touchend
 * @memberof Map
 * @instance
 * @property {MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a touchstart event occurs within the map.
 * map.on('touchstart', function() {
 *   console.log('A touchstart event occurred.');
 * });
 * @see [Create a draggable point](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
 */
 | "touchend"
/**
 * Fired when a [`touchmove`](https://developer.mozilla.org/en-US/docs/Web/Events/touchmove) event occurs within the map.
 *
 * @event touchmove
 * @memberof Map
 * @instance
 * @property {MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a touchmove event occurs within the map.
 * map.on('touchmove', function() {
 *   console.log('A touchmove event occurred.');
 * });
 * @see [Create a draggable point](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
 */
 | "touchmove"
/**
 * Fired when a [`touchcancel`](https://developer.mozilla.org/en-US/docs/Web/Events/touchcancel) event occurs within the map.
 *
 * @event touchcancel
 * @memberof Map
 * @instance
 * @property {MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a touchcancel event occurs within the map.
 * map.on('touchcancel', function() {
 *   console.log('A touchcancel event occurred.');
 * });
 */
 | "touchcancel"
/**
 * Fired just before the map begins a transition from one
 * view to another, as the result of either user interaction or methods such as {@link Map#jumpTo}.
 *
 * @event movestart
 * @memberof Map
 * @instance
 * @property {{originalEvent: DragEvent}} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just before the map begins a transition
 * // from one view to another.
 * map.on('movestart', function() {
 *   console.log('A movestart` event occurred.');
 * });
 */
 | "movestart"
/**
 * Fired repeatedly during an animated transition from one view to
 * another, as the result of either user interaction or methods such as {@link Map#flyTo}.
 *
 * @event move
 * @memberof Map
 * @instance
 * @property {MapMouseEvent | MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // repeatedly during an animated transition.
 * map.on('move', function() {
 *   console.log('A move event occurred.');
 * });
 * @see [Display HTML clusters with custom properties](https://maplibre.org/maplibre-gl-js-docs/example/cluster-html/)
 */
 | "move"
/**
 * Fired just after the map completes a transition from one
 * view to another, as the result of either user interaction or methods such as {@link Map#jumpTo}.
 *
 * @event moveend
 * @memberof Map
 * @instance
 * @property {{originalEvent: DragEvent}} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just after the map completes a transition.
 * map.on('moveend', function() {
 *   console.log('A moveend event occurred.');
 * });
 * @see [Display HTML clusters with custom properties](https://maplibre.org/maplibre-gl-js-docs/example/cluster-html/)
 */
 | "moveend"
/**
 * Fired when a "drag to pan" interaction starts. See {@link DragPanHandler}.
 *
 * @event dragstart
 * @memberof Map
 * @instance
 * @property {{originalEvent: DragEvent}} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a "drag to pan" interaction starts.
 * map.on('dragstart', function() {
 *   console.log('A dragstart event occurred.');
 * });
 */
 | "dragstart"
/**
 * Fired repeatedly during a "drag to pan" interaction. See {@link DragPanHandler}.
 *
 * @event drag
 * @memberof Map
 * @instance
 * @property {MapMouseEvent | MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // repeatedly  during a "drag to pan" interaction.
 * map.on('drag', function() {
 *   console.log('A drag event occurred.');
 * });
 */
 | "drag"
/**
 * Fired when a "drag to pan" interaction ends. See {@link DragPanHandler}.
 *
 * @event dragend
 * @memberof Map
 * @instance
 * @property {{originalEvent: DragEvent}} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a "drag to pan" interaction ends.
 * map.on('dragend', function() {
 *   console.log('A dragend event occurred.');
 * });
 * @see [Create a draggable marker](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-marker/)
 */
 | "dragend"
/**
 * Fired just before the map begins a transition from one zoom level to another,
 * as the result of either user interaction or methods such as {@link Map#flyTo}.
 *
 * @event zoomstart
 * @memberof Map
 * @instance
 * @property {MapMouseEvent | MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just before a zoom transition starts.
 * map.on('zoomstart', function() {
 *   console.log('A zoomstart event occurred.');
 * });
 */
 | "zoomstart"
/**
 * Fired repeatedly during an animated transition from one zoom level to another,
 * as the result of either user interaction or methods such as {@link Map#flyTo}.
 *
 * @event zoom
 * @memberof Map
 * @instance
 * @property {MapMouseEvent | MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // repeatedly during a zoom transition.
 * map.on('zoom', function() {
 *   console.log('A zoom event occurred.');
 * });
 */
 | "zoom"
/**
 * Fired just after the map completes a transition from one zoom level to another,
 * as the result of either user interaction or methods such as {@link Map#flyTo}.
 *
 * @event zoomend
 * @memberof Map
 * @instance
 * @property {MapMouseEvent | MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just after a zoom transition finishes.
 * map.on('zoomend', function() {
 *   console.log('A zoomend event occurred.');
 * });
 */
 | "zoomend"
/**
 * Fired when a "drag to rotate" interaction starts. See {@link DragRotateHandler}.
 *
 * @event rotatestart
 * @memberof Map
 * @instance
 * @property {MapMouseEvent | MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just before a "drag to rotate" interaction starts.
 * map.on('rotatestart', function() {
 *   console.log('A rotatestart event occurred.');
 * });
 */
 | "rotatestart"
/**
 * Fired repeatedly during a "drag to rotate" interaction. See {@link DragRotateHandler}.
 *
 * @event rotate
 * @memberof Map
 * @instance
 * @property {MapMouseEvent | MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // repeatedly during "drag to rotate" interaction.
 * map.on('rotate', function() {
 *   console.log('A rotate event occurred.');
 * });
 */
 | "rotate"
/**
 * Fired when a "drag to rotate" interaction ends. See {@link DragRotateHandler}.
 *
 * @event rotateend
 * @memberof Map
 * @instance
 * @property {MapMouseEvent | MapTouchEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just after a "drag to rotate" interaction ends.
 * map.on('rotateend', function() {
 *   console.log('A rotateend event occurred.');
 * });
 */
 | "rotateend"
/**
 * Fired whenever the map's pitch (tilt) begins a change as
 * the result of either user interaction or methods such as {@link Map#flyTo} .
 *
 * @event pitchstart
 * @memberof Map
 * @instance
 * @property {MapEventData} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just before a pitch (tilt) transition starts.
 * map.on('pitchstart', function() {
 *   console.log('A pitchstart event occurred.');
 * });
 */
 | "pitchstart"
/**
 * Fired repeatedly during the map's pitch (tilt) animation between
 * one state and another as the result of either user interaction
 * or methods such as {@link Map#flyTo}.
 *
 * @event pitch
 * @memberof Map
 * @instance
 * @property {MapEventData} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // repeatedly during a pitch (tilt) transition.
 * map.on('pitch', function() {
 *   console.log('A pitch event occurred.');
 * });
 */
 | "pitch"
/**
 * Fired immediately after the map's pitch (tilt) finishes changing as
 * the result of either user interaction or methods such as {@link Map#flyTo}.
 *
 * @event pitchend
 * @memberof Map
 * @instance
 * @property {MapEventData} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just after a pitch (tilt) transition ends.
 * map.on('pitchend', function() {
 *   console.log('A pitchend event occurred.');
 * });
 */
 | "pitchend"
/**
 * Fired when a "box zoom" interaction starts. See {@link BoxZoomHandler}.
 *
 * @event boxzoomstart
 * @memberof Map
 * @instance
 * @property {MapLibreZoomEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just before a "box zoom" interaction starts.
 * map.on('boxzoomstart', function() {
 *   console.log('A boxzoomstart event occurred.');
 * });
 */
 | "boxzoomstart"
/**
 * Fired when a "box zoom" interaction ends.  See {@link BoxZoomHandler}.
 *
 * @event boxzoomend
 * @memberof Map
 * @instance
 * @type {Object}
 * @property {MapLibreZoomEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just after a "box zoom" interaction ends.
 * map.on('boxzoomend', function() {
 *   console.log('A boxzoomend event occurred.');
 * });
 */
 | "boxzoomend"
/**
 * Fired when the user cancels a "box zoom" interaction, or when the bounding box does not meet the minimum size threshold.
 * See {@link BoxZoomHandler}.
 *
 * @event boxzoomcancel
 * @memberof Map
 * @instance
 * @property {MapLibreZoomEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // the user cancels a "box zoom" interaction.
 * map.on('boxzoomcancel', function() {
 *   console.log('A boxzoomcancel event occurred.');
 * });
 */
 | "boxzoomcancel"
/**
 * Fired immediately after the map has been resized.
 *
 * @event resize
 * @memberof Map
 * @instance
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // immediately after the map has been resized.
 * map.on('resize', function() {
 *   console.log('A resize event occurred.');
 * });
 */
 | "resize"
/**
 * Fired when the WebGL context is lost.
 *
 * @event webglcontextlost
 * @memberof Map
 * @instance
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when the WebGL context is lost.
 * map.on('webglcontextlost', function() {
 *   console.log('A webglcontextlost event occurred.');
 * });
 */
 | "webglcontextlost"
/**
 * Fired when the WebGL context is restored.
 *
 * @event webglcontextrestored
 * @memberof Map
 * @instance
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when the WebGL context is restored.
 * map.on('webglcontextrestored', function() {
 *   console.log('A webglcontextrestored event occurred.');
 * });
 */
 | "webglcontextrestored"
/**
 * Fired immediately after all necessary resources have been downloaded
 * and the first visually complete rendering of the map has occurred.
 *
 * @event load
 * @memberof Map
 * @instance
 * @type {Object}
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when the map has finished loading.
 * map.on('load', function() {
 *   console.log('A load event occurred.');
 * });
 * @see [Draw GeoJSON points](https://maplibre.org/maplibre-gl-js-docs/example/geojson-markers/)
 * @see [Add live realtime data](https://maplibre.org/maplibre-gl-js-docs/example/live-geojson/)
 * @see [Animate a point](https://maplibre.org/maplibre-gl-js-docs/example/animate-point-along-line/)
 */
 | "load"
/**
 * Fired whenever the map is drawn to the screen, as the result of
 *
 * - a change to the map's position, zoom, pitch, or bearing
 * - a change to the map's style
 * - a change to a GeoJSON source
 * - the loading of a vector tile, GeoJSON file, glyph, or sprite
 *
 * @event render
 * @memberof Map
 * @instance
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // whenever the map is drawn to the screen.
 * map.on('render', function() {
 *   console.log('A render event occurred.');
 * });
 */
 | "render"
/**
 * Fired after the last frame rendered before the map enters an
 * "idle" state:
 *
 * - No camera transitions are in progress
 * - All currently requested tiles have loaded
 * - All fade/transition animations have completed
 *
 * @event idle
 * @memberof Map
 * @instance
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just before the map enters an "idle" state.
 * map.on('idle', function() {
 *   console.log('A idle event occurred.');
 * });
 */
 | "idle"
/**
 * Fired immediately after the map has been removed with {@link Map.event:remove}.
 *
 * @event remove
 * @memberof Map
 * @instance
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // just after the map is removed.
 * map.on('remove', function() {
 *   console.log('A remove event occurred.');
 * });
 */
 | "remove"
/**
 * Fired when an error occurs. This is GL JS's primary error reporting
 * mechanism. We use an event instead of `throw` to better accommodate
 * asynchronous operations. If no listeners are bound to the `error` event, the
 * error will be printed to the console.
 *
 * @event error
 * @memberof Map
 * @instance
 * @property {{error: {message: string}}} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when an error occurs.
 * map.on('error', function() {
 *   console.log('A error event occurred.');
 * });
 */
 | "error"
/**
 * Fired when any map data loads or changes. See {@link MapDataEvent}
 * for more information.
 *
 * @event data
 * @memberof Map
 * @instance
 * @property {MapDataEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when map data loads or changes.
 * map.on('data', function() {
 *   console.log('A data event occurred.');
 * });
 * @see [Display HTML clusters with custom properties](https://maplibre.org/maplibre-gl-js-docs/example/cluster-html/)
 */
 | "data"
/**
 * Fired when the map's style loads or changes. See
 * {@link MapDataEvent} for more information.
 *
 * @event styledata
 * @memberof Map
 * @instance
 * @property {MapDataEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when the map's style loads or changes.
 * map.on('styledata', function() {
 *   console.log('A styledata event occurred.');
 * });
 */
 | "styledata"
/**
 * Fired when one of the map's sources loads or changes, including if a tile belonging
 * to a source loads or changes. See {@link MapDataEvent} for more information.
 *
 * @event sourcedata
 * @memberof Map
 * @instance
 * @property {MapDataEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when one of the map's sources loads or changes.
 * map.on('sourcedata', function() {
 *   console.log('A sourcedata event occurred.');
 * });
 */
 | "sourcedata"
/**
 * Fired when any map data (style, source, tile, etc) begins loading or
 * changing asynchronously. All `dataloading` events are followed by a `data`,
 * `dataabort` or `error` event. See {@link MapDataEvent} for more information.
 *
 * @event dataloading
 * @memberof Map
 * @instance
 * @property {MapDataEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when any map data begins loading
 * // or changing asynchronously.
 * map.on('dataloading', function() {
 *   console.log('A dataloading event occurred.');
 * });
 */
 | "dataloading"
/**
 * Fired when the map's style begins loading or changing asynchronously.
 * All `styledataloading` events are followed by a `styledata`
 * or `error` event. See {@link MapDataEvent} for more information.
 *
 * @event styledataloading
 * @memberof Map
 * @instance
 * @property {MapDataEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // map's style begins loading or
 * // changing asynchronously.
 * map.on('styledataloading', function() {
 *   console.log('A styledataloading event occurred.');
 * });
 */
 | "styledataloading"
/**
 * Fired when one of the map's sources begins loading or changing asynchronously.
 * All `sourcedataloading` events are followed by a `sourcedata`, `sourcedataabort` or `error` event.
 * See {@link MapDataEvent} for more information.
 *
 * @event sourcedataloading
 * @memberof Map
 * @instance
 * @property {MapDataEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // map's sources begin loading or
 * // changing asynchronously.
 * map.on('sourcedataloading', function() {
 *   console.log('A sourcedataloading event occurred.');
 * });
 */
 | "sourcedataloading"
/**
 * Fired when an icon or pattern needed by the style is missing. The missing image can
 * be added with {@link Map#addImage} within this event listener callback to prevent the image from
 * being skipped. This event can be used to dynamically generate icons and patterns.
 *
 * @event styleimagemissing
 * @memberof Map
 * @instance
 * @property {string} id The id of the missing image.
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires an icon or pattern is missing.
 * map.on('styleimagemissing', function(event: MapStyleImageMissingEvent) {
 *   const imageId = event.id
 *   console.log('A styleimagemissing event occurred for image id', imageId);
 * });
 * @see [Generate and add a missing icon to the map](https://maplibre.org/maplibre-gl-js-docs/example/add-image-missing-generated/)
 */
 | "styleimagemissing"
/**
 * @event style.load
 * @memberof Map
 * @instance
 * @private
 */
 | "style.load"
/**
 * @event terrain
 * @memberof Map
 * @instance
 * @private
 */
 | "terrain"
/**
 * Fired when a request for one of the map's sources' tiles is aborted.
 * Fired when a request for one of the map's sources' data is aborted.
 * See {@link MapDataEvent} for more information.
 *
 * @event dataabort
 * @memberof Map
 * @instance
 * @property {MapDataEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a request for one of the map's sources' data is aborted.
 * map.on('dataabort', function() {
 *   console.log('A dataabort event occurred.');
 * });
 */
 | "dataabort"
/**
 * Fired when a request for one of the map's sources' data is aborted.
 * See {@link MapDataEvent} for more information.
 *
 * @event sourcedataabort
 * @memberof Map
 * @instance
 * @property {MapDataEvent} data
 * @example
 * // Initialize the map
 * var map = new maplibregl.Map({ // map options });
 * // Set an event listener that fires
 * // when a request for one of the map's sources' data is aborted.
 * map.on('sourcedataabort', function() {
 *   console.log('A sourcedataabort event occurred.');
 * });
 */
 | "sourcedataabort";
export declare class TransformProvider {
	_map: Map;
	constructor(map: Map);
	get transform(): Transform;
	get center(): {
		lng: number;
		lat: number;
	};
	get zoom(): number;
	get pitch(): number;
	get bearing(): number;
	unproject(point: PointLike): LngLat;
}
/**
 * The scroll zoom handler options object
 */
export type ScrollZoomHandlerOptions = {
	/**
	 * If "center" is passed, map will zoom around the center of map
	 */
	around?: "center";
};
export declare class ScrollZoomHandler {
	_map: Map;
	_tr: TransformProvider;
	_el: HTMLElement;
	_enabled: boolean;
	_active: boolean;
	_zooming: boolean;
	_aroundCenter: boolean;
	_around: LngLat;
	_aroundPoint: Point;
	_type: "wheel" | "trackpad" | null;
	_lastValue: number;
	_timeout: ReturnType<typeof setTimeout>;
	_finishTimeout: ReturnType<typeof setTimeout>;
	_lastWheelEvent: any;
	_lastWheelEventTime: number;
	_startZoom: number;
	_targetZoom: number;
	_delta: number;
	_easing: ((a: number) => number);
	_prevEase: {
		start: number;
		duration: number;
		easing: (_: number) => number;
	};
	_frameId: boolean;
	_handler: HandlerManager;
	_defaultZoomRate: number;
	_wheelZoomRate: number;
	/**
	 * @private
	 */
	constructor(map: Map, handler: HandlerManager);
	/**
	 * Set the zoom rate of a trackpad
	 * @param {number} [zoomRate=1/100] The rate used to scale trackpad movement to a zoom value.
	 * @example
	 * // Speed up trackpad zoom
	 * map.scrollZoom.setZoomRate(1/25);
	 */
	setZoomRate(zoomRate: number): void;
	/**
	 * Set the zoom rate of a mouse wheel
	 * @param {number} [wheelZoomRate=1/450] The rate used to scale mouse wheel movement to a zoom value.
	 * @example
	 * // Slow down zoom of mouse wheel
	 * map.scrollZoom.setWheelZoomRate(1/600);
	 */
	setWheelZoomRate(wheelZoomRate: number): void;
	/**
	 * Returns a Boolean indicating whether the "scroll to zoom" interaction is enabled.
	 *
	 * @returns {boolean} `true` if the "scroll to zoom" interaction is enabled.
	 */
	isEnabled(): boolean;
	isActive(): boolean;
	isZooming(): boolean;
	/**
	 * Enables the "scroll to zoom" interaction.
	 *
	 * @param {ScrollZoomHandlerOptions} [options] Options object.
	 * @param {string} [options.around] If "center" is passed, map will zoom around the center of map
	 *
	 * @example
	 *   map.scrollZoom.enable();
	 * @example
	 *  map.scrollZoom.enable({ around: 'center' })
	 */
	enable(options?: ScrollZoomHandlerOptions): void;
	/**
	 * Disables the "scroll to zoom" interaction.
	 *
	 * @example
	 *   map.scrollZoom.disable();
	 */
	disable(): void;
	wheel(e: WheelEvent): void;
	_onTimeout(initialEvent: MouseEvent): void;
	_start(e: MouseEvent): void;
	renderFrame(): {
		noInertia: boolean;
		needsRenderFrame: boolean;
		zoomDelta: number;
		around: Point;
		originalEvent: any;
	};
	_smoothOutEasing(duration: number): (t: number) => number;
	reset(): void;
}
export declare class BoxZoomHandler {
	_map: Map;
	_tr: TransformProvider;
	_el: HTMLElement;
	_container: HTMLElement;
	_enabled: boolean;
	_active: boolean;
	_startPos: Point;
	_lastPos: Point;
	_box: HTMLElement;
	_clickTolerance: number;
	/**
	 * @private
	 */
	constructor(map: Map, options: {
		clickTolerance: number;
	});
	/**
	 * Returns a Boolean indicating whether the "box zoom" interaction is enabled.
	 *
	 * @returns {boolean} `true` if the "box zoom" interaction is enabled.
	 */
	isEnabled(): boolean;
	/**
	 * Returns a Boolean indicating whether the "box zoom" interaction is active, i.e. currently being used.
	 *
	 * @returns {boolean} `true` if the "box zoom" interaction is active.
	 */
	isActive(): boolean;
	/**
	 * Enables the "box zoom" interaction.
	 *
	 * @example
	 *   map.boxZoom.enable();
	 */
	enable(): void;
	/**
	 * Disables the "box zoom" interaction.
	 *
	 * @example
	 *   map.boxZoom.disable();
	 */
	disable(): void;
	mousedown(e: MouseEvent, point: Point): void;
	mousemoveWindow(e: MouseEvent, point: Point): void;
	mouseupWindow(e: MouseEvent, point: Point): {
		cameraAnimation: (map: any) => any;
	};
	keydown(e: KeyboardEvent): void;
	reset(): void;
	_fireEvent(type: string, e: any): Map;
}
export declare class TwoFingersTouchHandler {
	_enabled: boolean;
	_active: boolean;
	_firstTwoTouches: [
		number,
		number
	];
	_vector: Point;
	_startVector: Point;
	_aroundCenter: boolean;
	constructor();
	reset(): void;
	_start(points: [
		Point,
		Point
	]): void;
	_move(points: [
		Point,
		Point
	], pinchAround: Point, e: TouchEvent): {};
	touchstart(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchmove(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): {};
	touchend(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchcancel(): void;
	enable(options?: {
		around?: "center";
	} | null): void;
	disable(): void;
	isEnabled(): boolean;
	isActive(): boolean;
}
export declare class TwoFingersTouchZoomHandler extends TwoFingersTouchHandler {
	_distance: number;
	_startDistance: number;
	reset(): void;
	_start(points: [
		Point,
		Point
	]): void;
	_move(points: [
		Point,
		Point
	], pinchAround: Point): {
		zoomDelta: number;
		pinchAround: Point;
	};
}
export declare class TwoFingersTouchRotateHandler extends TwoFingersTouchHandler {
	_minDiameter: number;
	reset(): void;
	_start(points: [
		Point,
		Point
	]): void;
	_move(points: [
		Point,
		Point
	], pinchAround: Point): {
		bearingDelta: number;
		pinchAround: Point;
	};
	_isBelowThreshold(vector: Point): boolean;
}
export declare class TwoFingersTouchPitchHandler extends TwoFingersTouchHandler {
	_valid: boolean | void;
	_firstMove: number;
	_lastPoints: [
		Point,
		Point
	];
	_map: Map;
	_currentTouchCount: number;
	constructor(map: Map);
	reset(): void;
	touchstart(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	_start(points: [
		Point,
		Point
	]): void;
	_move(points: [
		Point,
		Point
	], center: Point, e: TouchEvent): {
		pitchDelta: number;
	};
	gestureBeginsVertically(vectorA: Point, vectorB: Point, timeStamp: number): boolean | void;
}
export declare class DragRotateHandler {
	_mouseRotate: MouseRotateHandler;
	_mousePitch: MousePitchHandler;
	_pitchWithRotate: boolean;
	/**
	 * @param {Object} [options]
	 * @param {number} [options.bearingSnap] The threshold, measured in degrees, that determines when the map's
	 *   bearing will snap to north.
	 * @param {bool} [options.pitchWithRotate=true] Control the map pitch in addition to the bearing
	 * @private
	 */
	constructor(options: {
		pitchWithRotate: boolean;
	}, mouseRotate: MouseRotateHandler, mousePitch: MousePitchHandler);
	/**
	 * Enables the "drag to rotate" interaction.
	 *
	 * @example
	 * map.dragRotate.enable();
	 */
	enable(): void;
	/**
	 * Disables the "drag to rotate" interaction.
	 *
	 * @example
	 * map.dragRotate.disable();
	 */
	disable(): void;
	/**
	 * Returns a Boolean indicating whether the "drag to rotate" interaction is enabled.
	 *
	 * @returns {boolean} `true` if the "drag to rotate" interaction is enabled.
	 */
	isEnabled(): boolean;
	/**
	 * Returns a Boolean indicating whether the "drag to rotate" interaction is active, i.e. currently being used.
	 *
	 * @returns {boolean} `true` if the "drag to rotate" interaction is active.
	 */
	isActive(): boolean;
}
export declare class KeyboardHandler {
	_tr: TransformProvider;
	_enabled: boolean;
	_active: boolean;
	_panStep: number;
	_bearingStep: number;
	_pitchStep: number;
	_rotationDisabled: boolean;
	/**
	* @private
	*/
	constructor(map: Map);
	reset(): void;
	keydown(e: KeyboardEvent): {
		cameraAnimation: (map: Map) => void;
	};
	/**
	 * Enables the "keyboard rotate and zoom" interaction.
	 *
	 * @example
	 *   map.keyboard.enable();
	 */
	enable(): void;
	/**
	 * Disables the "keyboard rotate and zoom" interaction.
	 *
	 * @example
	 *   map.keyboard.disable();
	 */
	disable(): void;
	/**
	 * Returns a Boolean indicating whether the "keyboard rotate and zoom"
	 * interaction is enabled.
	 *
	 * @returns {boolean} `true` if the "keyboard rotate and zoom"
	 * interaction is enabled.
	 */
	isEnabled(): boolean;
	/**
	 * Returns true if the handler is enabled and has detected the start of a
	 * zoom/rotate gesture.
	 *
	 * @returns {boolean} `true` if the handler is enabled and has detected the
	 * start of a zoom/rotate gesture.
	 */
	isActive(): boolean;
	/**
	 * Disables the "keyboard pan/rotate" interaction, leaving the
	 * "keyboard zoom" interaction enabled.
	 *
	 * @example
	 *   map.keyboard.disableRotation();
	 */
	disableRotation(): void;
	/**
	 * Enables the "keyboard pan/rotate" interaction.
	 *
	 * @example
	 *   map.keyboard.enable();
	 *   map.keyboard.enableRotation();
	 */
	enableRotation(): void;
}
export declare class ClickZoomHandler {
	_tr: TransformProvider;
	_enabled: boolean;
	_active: boolean;
	constructor(map: Map);
	reset(): void;
	dblclick(e: MouseEvent, point: Point): {
		cameraAnimation: (map: Map) => void;
	};
	enable(): void;
	disable(): void;
	isEnabled(): boolean;
	isActive(): boolean;
}
export declare class SingleTapRecognizer {
	numTouches: number;
	centroid: Point;
	startTime: number;
	aborted: boolean;
	touches: {
		[k in number | string]: Point;
	};
	constructor(options: {
		numTouches: number;
	});
	reset(): void;
	touchstart(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchmove(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchend(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): Point;
}
export declare class TapRecognizer {
	singleTap: SingleTapRecognizer;
	numTaps: number;
	lastTime: number;
	lastTap: Point;
	count: number;
	constructor(options: {
		numTaps: number;
		numTouches: number;
	});
	reset(): void;
	touchstart(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchmove(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchend(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): Point;
}
export declare class TapZoomHandler {
	_tr: TransformProvider;
	_enabled: boolean;
	_active: boolean;
	_zoomIn: TapRecognizer;
	_zoomOut: TapRecognizer;
	constructor(map: Map);
	reset(): void;
	touchstart(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchmove(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchend(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): {
		cameraAnimation: (map: Map) => Map;
	};
	touchcancel(): void;
	enable(): void;
	disable(): void;
	isEnabled(): boolean;
	isActive(): boolean;
}
export declare class DoubleClickZoomHandler {
	_clickZoom: ClickZoomHandler;
	_tapZoom: TapZoomHandler;
	/**
	 * @private
	*/
	constructor(clickZoom: ClickZoomHandler, TapZoom: TapZoomHandler);
	/**
	 * Enables the "double click to zoom" interaction.
	 *
	 * @example
	 * map.doubleClickZoom.enable();
	 */
	enable(): void;
	/**
	 * Disables the "double click to zoom" interaction.
	 *
	 * @example
	 * map.doubleClickZoom.disable();
	 */
	disable(): void;
	/**
	 * Returns a Boolean indicating whether the "double click to zoom" interaction is enabled.
	 *
	 * @returns {boolean} `true` if the "double click to zoom" interaction is enabled.
	 */
	isEnabled(): boolean;
	/**
	 * Returns a Boolean indicating whether the "double click to zoom" interaction is active, i.e. currently being used.
	 *
	 * @returns {boolean} `true` if the "double click to zoom" interaction is active.
	 */
	isActive(): boolean;
}
export declare class TapDragZoomHandler {
	_enabled: boolean;
	_active: boolean;
	_swipePoint: Point;
	_swipeTouch: number;
	_tapTime: number;
	_tap: TapRecognizer;
	constructor();
	reset(): void;
	touchstart(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchmove(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): {
		zoomDelta: number;
	};
	touchend(e: TouchEvent, points: Array<Point>, mapTouches: Array<Touch>): void;
	touchcancel(): void;
	enable(): void;
	disable(): void;
	isEnabled(): boolean;
	isActive(): boolean;
}
export declare class TwoFingersTouchZoomRotateHandler {
	_el: HTMLElement;
	_touchZoom: TwoFingersTouchZoomHandler;
	_touchRotate: TwoFingersTouchRotateHandler;
	_tapDragZoom: TapDragZoomHandler;
	_rotationDisabled: boolean;
	_enabled: boolean;
	/**
	 * @private
	*/
	constructor(el: HTMLElement, touchZoom: TwoFingersTouchZoomHandler, touchRotate: TwoFingersTouchRotateHandler, tapDragZoom: TapDragZoomHandler);
	/**
	 * Enables the "pinch to rotate and zoom" interaction.
	 *
	 * @param {Object} [options] Options object.
	 * @param {string} [options.around] If "center" is passed, map will zoom around the center
	 *
	 * @example
	 *   map.touchZoomRotate.enable();
	 * @example
	 *   map.touchZoomRotate.enable({ around: 'center' });
	 */
	enable(options?: {
		around?: "center";
	} | null): void;
	/**
	 * Disables the "pinch to rotate and zoom" interaction.
	 *
	 * @example
	 *   map.touchZoomRotate.disable();
	 */
	disable(): void;
	/**
	 * Returns a Boolean indicating whether the "pinch to rotate and zoom" interaction is enabled.
	 *
	 * @returns {boolean} `true` if the "pinch to rotate and zoom" interaction is enabled.
	 */
	isEnabled(): boolean;
	/**
	 * Returns true if the handler is enabled and has detected the start of a zoom/rotate gesture.
	 *
	 * @returns {boolean} //eslint-disable-line
	 */
	isActive(): boolean;
	/**
	 * Disables the "pinch to rotate" interaction, leaving the "pinch to zoom"
	 * interaction enabled.
	 *
	 * @example
	 *   map.touchZoomRotate.disableRotation();
	 */
	disableRotation(): void;
	/**
	 * Enables the "pinch to rotate" interaction.
	 *
	 * @example
	 *   map.touchZoomRotate.enable();
	 *   map.touchZoomRotate.enableRotation();
	 */
	enableRotation(): void;
}
export type ControlPosition = "top-left" | "top-right" | "bottom-left" | "bottom-right";
/**
 * Interface for interactive controls added to the map. This is a
 * specification for implementers to model: it is not
 * an exported method or class.
 *
 * Controls must implement `onAdd` and `onRemove`, and must own an
 * element, which is often a `div` element. To use MapLibre GL JS's
 * default control styling, add the `maplibregl-ctrl` class to your control's
 * node.
 *
 * @interface IControl
 * @example
 * // Control implemented as ES6 class
 * class HelloWorldControl {
 *     onAdd(map) {
 *         this._map = map;
 *         this._container = document.createElement('div');
 *         this._container.className = 'maplibregl-ctrl';
 *         this._container.textContent = 'Hello, world';
 *         return this._container;
 *     }
 *
 *     onRemove() {
 *         this._container.parentNode.removeChild(this._container);
 *         this._map = undefined;
 *     }
 * }
 *
 * // Control implemented as ES5 prototypical class
 * function HelloWorldControl() { }
 *
 * HelloWorldControl.prototype.onAdd = function(map) {
 *     this._map = map;
 *     this._container = document.createElement('div');
 *     this._container.className = 'maplibregl-ctrl';
 *     this._container.textContent = 'Hello, world';
 *     return this._container;
 * };
 *
 * HelloWorldControl.prototype.onRemove = function () {
 *      this._container.parentNode.removeChild(this._container);
 *      this._map = undefined;
 * };
 */
export interface IControl {
	/**
	 * Register a control on the map and give it a chance to register event listeners
	 * and resources. This method is called by {@link Map#addControl}
	 * internally.
	 *
	 * @function
	 * @memberof IControl
	 * @instance
	 * @name onAdd
	 * @param {Map} map the Map this control will be added to
	 * @returns {HTMLElement} The control's container element. This should
	 * be created by the control and returned by onAdd without being attached
	 * to the DOM: the map will insert the control's element into the DOM
	 * as necessary.
	 */
	onAdd(map: Map): HTMLElement;
	/**
	 * Unregister a control on the map and give it a chance to detach event listeners
	 * and resources. This method is called by {@link Map#removeControl}
	 * internally.
	 *
	 * @function
	 * @memberof IControl
	 * @instance
	 * @name onRemove
	 * @param {Map} map the Map this control will be removed from
	 * @returns {undefined} there is no required return value for this method
	 */
	onRemove(map: Map): void;
	/**
	 * Optionally provide a default position for this control. If this method
	 * is implemented and {@link Map#addControl} is called without the `position`
	 * parameter, the value returned by getDefaultPosition will be used as the
	 * control's position.
	 *
	 * @function
	 * @memberof IControl
	 * @instance
	 * @name getDefaultPosition
	 * @returns {ControlPosition} a control position, one of the values valid in addControl.
	 */
	readonly getDefaultPosition?: () => ControlPosition;
}
export type MapOptions = {
	hash?: boolean | string;
	interactive?: boolean;
	container: HTMLElement | string;
	bearingSnap?: number;
	attributionControl?: boolean;
	customAttribution?: string | Array<string>;
	maplibreLogo?: boolean;
	logoPosition?: ControlPosition;
	failIfMajorPerformanceCaveat?: boolean;
	preserveDrawingBuffer?: boolean;
	antialias?: boolean;
	refreshExpiredTiles?: boolean;
	maxBounds?: LngLatBoundsLike;
	scrollZoom?: boolean;
	minZoom?: number | null;
	maxZoom?: number | null;
	minPitch?: number | null;
	maxPitch?: number | null;
	boxZoom?: boolean;
	dragRotate?: boolean;
	dragPan?: DragPanOptions | boolean;
	keyboard?: boolean;
	doubleClickZoom?: boolean;
	touchZoomRotate?: boolean;
	touchPitch?: boolean;
	cooperativeGestures?: boolean | GestureOptions;
	trackResize?: boolean;
	center?: LngLatLike;
	zoom?: number;
	bearing?: number;
	pitch?: number;
	renderWorldCopies?: boolean;
	maxTileCacheSize?: number;
	maxTileCacheZoomLevels?: number;
	transformRequest?: RequestTransformFunction;
	transformCameraUpdate?: CameraUpdateTransformFunction;
	locale?: any;
	fadeDuration?: number;
	crossSourceCollisions?: boolean;
	collectResourceTiming?: boolean;
	clickTolerance?: number;
	bounds?: LngLatBoundsLike;
	fitBoundsOptions?: Object;
	localIdeographFontFamily?: string;
	style: StyleSpecification | string;
	pitchWithRotate?: boolean;
	pixelRatio?: number;
	validateStyle?: boolean;
};
/**
 * An options object for the gesture settings
 * @example
 * let options = {
 *   windowsHelpText: "Use Ctrl + scroll to zoom the map",
 *   macHelpText: "Use ⌘ + scroll to zoom the map",
 *   mobileHelpText: "Use two fingers to move the map",
 * }
 */
export type GestureOptions = {
	windowsHelpText?: string;
	macHelpText?: string;
	mobileHelpText?: string;
};
export type Complete<T> = {
	[P in keyof Required<T>]: Pick<T, P> extends Required<Pick<T, P>> ? T[P] : (T[P] | undefined);
};
export type CompleteMapOptions = Complete<MapOptions>;
export type QueryRenderedFeaturesOptions = {
	layers?: Array<string>;
	filter?: FilterSpecification;
	availableImages?: Array<string>;
	validate?: boolean;
};
export declare class Map extends Camera {
	style: Style;
	painter: Painter;
	handlers: HandlerManager;
	_container: HTMLElement;
	_canvasContainer: HTMLElement;
	_controlContainer: HTMLElement;
	_controlPositions: {
		[_: string]: HTMLElement;
	};
	_interactive: boolean;
	_cooperativeGestures: boolean | GestureOptions;
	_cooperativeGesturesScreen: HTMLElement;
	_metaKey: keyof MouseEvent;
	_showTileBoundaries: boolean;
	_showCollisionBoxes: boolean;
	_showPadding: boolean;
	_showOverdrawInspector: boolean;
	_repaint: boolean;
	_vertices: boolean;
	_canvas: HTMLCanvasElement;
	_maxTileCacheSize: number;
	_maxTileCacheZoomLevels: number;
	_frame: Cancelable;
	_styleDirty: boolean;
	_sourcesDirty: boolean;
	_placementDirty: boolean;
	_loaded: boolean;
	_idleTriggered: boolean;
	_fullyLoaded: boolean;
	_trackResize: boolean;
	_resizeObserver: ResizeObserver;
	_preserveDrawingBuffer: boolean;
	_failIfMajorPerformanceCaveat: boolean;
	_antialias: boolean;
	_refreshExpiredTiles: boolean;
	_hash: Hash;
	_delegatedListeners: any;
	_fadeDuration: number;
	_crossSourceCollisions: boolean;
	_crossFadingFactor: number;
	_collectResourceTiming: boolean;
	_renderTaskQueue: TaskQueue;
	_controls: Array<IControl>;
	_mapId: number;
	_localIdeographFontFamily: string;
	_validateStyle: boolean;
	_requestManager: RequestManager;
	_locale: any;
	_removed: boolean;
	_clickTolerance: number;
	_pixelRatio: number;
	_terrainDataCallback: (e: MapStyleDataEvent | MapSourceDataEvent) => void;
	/** image queue throttling handle. To be used later when clean up */
	_imageQueueHandle: number;
	/**
	 * The map's {@link ScrollZoomHandler}, which implements zooming in and out with a scroll wheel or trackpad.
	 * Find more details and examples using `scrollZoom` in the {@link ScrollZoomHandler} section.
	 */
	scrollZoom: ScrollZoomHandler;
	/**
	 * The map's {@link BoxZoomHandler}, which implements zooming using a drag gesture with the Shift key pressed.
	 * Find more details and examples using `boxZoom` in the {@link BoxZoomHandler} section.
	 */
	boxZoom: BoxZoomHandler;
	/**
	 * The map's {@link DragRotateHandler}, which implements rotating the map while dragging with the right
	 * mouse button or with the Control key pressed. Find more details and examples using `dragRotate`
	 * in the {@link DragRotateHandler} section.
	 */
	dragRotate: DragRotateHandler;
	/**
	 * The map's {@link DragPanHandler}, which implements dragging the map with a mouse or touch gesture.
	 * Find more details and examples using `dragPan` in the {@link DragPanHandler} section.
	 */
	dragPan: DragPanHandler;
	/**
	 * The map's {@link KeyboardHandler}, which allows the user to zoom, rotate, and pan the map using keyboard
	 * shortcuts. Find more details and examples using `keyboard` in the {@link KeyboardHandler} section.
	 */
	keyboard: KeyboardHandler;
	/**
	 * The map's {@link DoubleClickZoomHandler}, which allows the user to zoom by double clicking.
	 * Find more details and examples using `doubleClickZoom` in the {@link DoubleClickZoomHandler} section.
	 */
	doubleClickZoom: DoubleClickZoomHandler;
	/**
	 * The map's {@link TwoFingersTouchZoomRotateHandler}, which allows the user to zoom or rotate the map with touch gestures.
	 * Find more details and examples using `touchZoomRotate` in the {@link TwoFingersTouchZoomRotateHandler} section.
	 */
	touchZoomRotate: TwoFingersTouchZoomRotateHandler;
	/**
	 * The map's {@link TwoFingersTouchPitchHandler}, which allows the user to pitch the map with touch gestures.
	 * Find more details and examples using `touchPitch` in the {@link TwoFingersTouchPitchHandler} section.
	 */
	touchPitch: TwoFingersTouchPitchHandler;
	constructor(options: MapOptions);
	_getMapId(): number;
	/**
	 * Adds an {@link IControl} to the map, calling `control.onAdd(this)`.
	 *
	 * @param {IControl} control The {@link IControl} to add.
	 * @param {string} [position] position on the map to which the control will be added.
	 * Valid values are `'top-left'`, `'top-right'`, `'bottom-left'`, and `'bottom-right'`. Defaults to `'top-right'`.
	 * @returns {Map} `this`
	 * @example
	 * // Add zoom and rotation controls to the map.
	 * map.addControl(new maplibregl.NavigationControl());
	 * @see [Display map navigation controls](https://maplibre.org/maplibre-gl-js-docs/example/navigation/)
	 */
	addControl(control: IControl, position?: ControlPosition): this;
	/**
	 * Removes the control from the map.
	 *
	 * @param {IControl} control The {@link IControl} to remove.
	 * @returns {Map} `this`
	 * @example
	 * // Define a new navigation control.
	 * var navigation = new maplibregl.NavigationControl();
	 * // Add zoom and rotation controls to the map.
	 * map.addControl(navigation);
	 * // Remove zoom and rotation controls from the map.
	 * map.removeControl(navigation);
	 */
	removeControl(control: IControl): this;
	/**
	 * Checks if a control exists on the map.
	 *
	 * @param {IControl} control The {@link IControl} to check.
	 * @returns {boolean} True if map contains control.
	 * @example
	 * // Define a new navigation control.
	 * var navigation = new maplibregl.NavigationControl();
	 * // Add zoom and rotation controls to the map.
	 * map.addControl(navigation);
	 * // Check that the navigation control exists on the map.
	 * map.hasControl(navigation);
	 */
	hasControl(control: IControl): boolean;
	calculateCameraOptionsFromTo(from: LngLat, altitudeFrom: number, to: LngLat, altitudeTo?: number): CameraOptions;
	/**
	 * Resizes the map according to the dimensions of its
	 * `container` element.
	 *
	 * Checks if the map container size changed and updates the map if it has changed.
	 * This method must be called after the map's `container` is resized programmatically
	 * or when the map is shown after being initially hidden with CSS.
	 *
	 * @param eventData Additional properties to be passed to `movestart`, `move`, `resize`, and `moveend`
	 * events that get triggered as a result of resize. This can be useful for differentiating the
	 * source of an event (for example, user-initiated or programmatically-triggered events).
	 * @returns {Map} `this`
	 * @example
	 * // Resize the map when the map container is shown
	 * // after being initially hidden with CSS.
	 * var mapDiv = document.getElementById('map');
	 * if (mapDiv.style.visibility === true) map.resize();
	 */
	resize(eventData?: any): this;
	/**
	 * Returns the map's pixel ratio.
	 * @returns {number} The pixel ratio.
	 */
	getPixelRatio(): number;
	/**
	 * Sets the map's pixel ratio. This allows to override `devicePixelRatio`.
	 * After this call, the canvas' `width` attribute will be `container.clientWidth * pixelRatio`
	 * and its height attribute will be `container.clientHeight * pixelRatio`.
	 * @param {number} pixelRatio The pixel ratio.
	 */
	setPixelRatio(pixelRatio: number): void;
	/**
	 * Returns the map's geographical bounds. When the bearing or pitch is non-zero, the visible region is not
	 * an axis-aligned rectangle, and the result is the smallest bounds that encompasses the visible region.
	 * @returns {LngLatBounds} The geographical bounds of the map as {@link LngLatBounds}.
	 * @example
	 * var bounds = map.getBounds();
	 */
	getBounds(): LngLatBounds;
	/**
	 * Returns the maximum geographical bounds the map is constrained to, or `null` if none set.
	 * @returns The map object.
	 * @example
	 * var maxBounds = map.getMaxBounds();
	 */
	getMaxBounds(): LngLatBounds | null;
	/**
	 * Sets or clears the map's geographical bounds.
	 *
	 * Pan and zoom operations are constrained within these bounds.
	 * If a pan or zoom is performed that would
	 * display regions outside these bounds, the map will
	 * instead display a position and zoom level
	 * as close as possible to the operation's request while still
	 * remaining within the bounds.
	 *
	 * @param {LngLatBoundsLike | null | undefined} bounds The maximum bounds to set. If `null` or `undefined` is provided, the function removes the map's maximum bounds.
	 * @returns {Map} `this`
	 * @example
	 * // Define bounds that conform to the `LngLatBoundsLike` object.
	 * var bounds = [
	 *   [-74.04728, 40.68392], // [west, south]
	 *   [-73.91058, 40.87764]  // [east, north]
	 * ];
	 * // Set the map's max bounds.
	 * map.setMaxBounds(bounds);
	 */
	setMaxBounds(bounds?: LngLatBoundsLike | null): this;
	/**
	 * Sets or clears the map's minimum zoom level.
	 * If the map's current zoom level is lower than the new minimum,
	 * the map will zoom to the new minimum.
	 *
	 * It is not always possible to zoom out and reach the set `minZoom`.
	 * Other factors such as map height may restrict zooming. For example,
	 * if the map is 512px tall it will not be possible to zoom below zoom 0
	 * no matter what the `minZoom` is set to.
	 *
	 * @param {number | null | undefined} minZoom The minimum zoom level to set (-2 - 24).
	 * If `null` or `undefined` is provided, the function removes the current minimum zoom (i.e. sets it to -2).
	 * @returns {Map} `this`
	 * @example
	 * map.setMinZoom(12.25);
	 */
	setMinZoom(minZoom?: number | null): this;
	/**
	 * Returns the map's minimum allowable zoom level.
	 *
	 * @returns {number} minZoom
	 * @example
	 * var minZoom = map.getMinZoom();
	 */
	getMinZoom(): number;
	/**
	 * Sets or clears the map's maximum zoom level.
	 * If the map's current zoom level is higher than the new maximum,
	 * the map will zoom to the new maximum.
	 *
	 * @param {number | null | undefined} maxZoom The maximum zoom level to set.
	 * If `null` or `undefined` is provided, the function removes the current maximum zoom (sets it to 22).
	 * @returns {Map} `this`
	 * @example
	 * map.setMaxZoom(18.75);
	 */
	setMaxZoom(maxZoom?: number | null): this;
	/**
	 * Returns the map's maximum allowable zoom level.
	 *
	 * @returns {number} maxZoom
	 * @example
	 * var maxZoom = map.getMaxZoom();
	 */
	getMaxZoom(): number;
	/**
	 * Sets or clears the map's minimum pitch.
	 * If the map's current pitch is lower than the new minimum,
	 * the map will pitch to the new minimum.
	 *
	 * @param {number | null | undefined} minPitch The minimum pitch to set (0-85). Values greater than 60 degrees are experimental and may result in rendering issues. If you encounter any, please raise an issue with details in the MapLibre project.
	 * If `null` or `undefined` is provided, the function removes the current minimum pitch (i.e. sets it to 0).
	 * @returns {Map} `this`
	 */
	setMinPitch(minPitch?: number | null): this;
	/**
	 * Returns the map's minimum allowable pitch.
	 *
	 * @returns {number} minPitch
	 */
	getMinPitch(): number;
	/**
	 * Sets or clears the map's maximum pitch.
	 * If the map's current pitch is higher than the new maximum,
	 * the map will pitch to the new maximum.
	 *
	 * @param {number | null | undefined} maxPitch The maximum pitch to set (0-85). Values greater than 60 degrees are experimental and may result in rendering issues. If you encounter any, please raise an issue with details in the MapLibre project.
	 * If `null` or `undefined` is provided, the function removes the current maximum pitch (sets it to 60).
	 * @returns {Map} `this`
	 */
	setMaxPitch(maxPitch?: number | null): this;
	/**
	 * Returns the map's maximum allowable pitch.
	 *
	 * @returns {number} maxPitch
	 */
	getMaxPitch(): number;
	/**
	 * Returns the state of `renderWorldCopies`. If `true`, multiple copies of the world will be rendered side by side beyond -180 and 180 degrees longitude. If set to `false`:
	 * - When the map is zoomed out far enough that a single representation of the world does not fill the map's entire
	 * container, there will be blank space beyond 180 and -180 degrees longitude.
	 * - Features that cross 180 and -180 degrees longitude will be cut in two (with one portion on the right edge of the
	 * map and the other on the left edge of the map) at every zoom level.
	 * @returns {boolean} renderWorldCopies
	 * @example
	 * var worldCopiesRendered = map.getRenderWorldCopies();
	 * @see [Render world copies](https://maplibre.org/maplibre-gl-js-docs/example/render-world-copies/)
	 */
	getRenderWorldCopies(): boolean;
	/**
	 * Sets the state of `renderWorldCopies`.
	 *
	 * @param {boolean} renderWorldCopies If `true`, multiple copies of the world will be rendered side by side beyond -180 and 180 degrees longitude. If set to `false`:
	 * - When the map is zoomed out far enough that a single representation of the world does not fill the map's entire
	 * container, there will be blank space beyond 180 and -180 degrees longitude.
	 * - Features that cross 180 and -180 degrees longitude will be cut in two (with one portion on the right edge of the
	 * map and the other on the left edge of the map) at every zoom level.
	 *
	 * `undefined` is treated as `true`, `null` is treated as `false`.
	 * @returns {Map} `this`
	 * @example
	 * map.setRenderWorldCopies(true);
	 * @see [Render world copies](https://maplibre.org/maplibre-gl-js-docs/example/render-world-copies/)
	 */
	setRenderWorldCopies(renderWorldCopies?: boolean | null): this;
	/**
	 * Gets the map's cooperativeGestures option
	 *
	 * @returns {GestureOptions} gestureOptions
	 */
	getCooperativeGestures(): boolean | GestureOptions;
	/**
	 * Sets or clears the map's cooperativeGestures option
	 *
	 * @param {GestureOptions | null | undefined} gestureOptions If `true` or set to an options object, map is only accessible on desktop while holding Command/Ctrl and only accessible on mobile with two fingers. Interacting with the map using normal gestures will trigger an informational screen. With this option enabled, "drag to pitch" requires a three-finger gesture.
	 * @returns {Map} `this`
	 */
	setCooperativeGestures(gestureOptions?: GestureOptions | boolean | null): this;
	/**
	 * Returns a [Point](https://github.com/mapbox/point-geometry) representing pixel coordinates, relative to the map's `container`,
	 * that correspond to the specified geographical location.
	 *
	 * @param {LngLatLike} lnglat The geographical location to project.
	 * @returns {Point} The [Point](https://github.com/mapbox/point-geometry) corresponding to `lnglat`, relative to the map's `container`.
	 * @example
	 * var coordinate = [-122.420679, 37.772537];
	 * var point = map.project(coordinate);
	 */
	project(lnglat: LngLatLike): Point;
	/**
	 * Returns a {@link LngLat} representing geographical coordinates that correspond
	 * to the specified pixel coordinates.
	 *
	 * @param {PointLike} point The pixel coordinates to unproject.
	 * @returns {LngLat} The {@link LngLat} corresponding to `point`.
	 * @example
	 * map.on('click', function(e) {
	 *   // When the map is clicked, get the geographic coordinate.
	 *   var coordinate = map.unproject(e.point);
	 * });
	 */
	unproject(point: PointLike): LngLat;
	/**
	 * Returns true if the map is panning, zooming, rotating, or pitching due to a camera animation or user gesture.
	 * @returns {boolean} True if the map is moving.
	 * @example
	 * var isMoving = map.isMoving();
	 */
	isMoving(): boolean;
	/**
	 * Returns true if the map is zooming due to a camera animation or user gesture.
	 * @returns {boolean} True if the map is zooming.
	 * @example
	 * var isZooming = map.isZooming();
	 */
	isZooming(): boolean;
	/**
	 * Returns true if the map is rotating due to a camera animation or user gesture.
	 * @returns {boolean} True if the map is rotating.
	 * @example
	 * map.isRotating();
	 */
	isRotating(): boolean;
	_createDelegatedListener(type: MapEvent | string, layerId: string, listener: Listener): {
		layer: string;
		listener: Listener;
		delegates: {
			[type in keyof MapEventType]?: (e: any) => void;
		};
	};
	/**
	 * Adds a listener for events of a specified type, optionally limited to features in a specified style layer.
	 *
	 * @param {string} type The event type to listen for. Events compatible with the optional `layerId` parameter are triggered
	 * when the cursor enters a visible portion of the specified layer from outside that layer or outside the map canvas.
	 *
	 * | Event                                                     | Compatible with `layerId` |
	 * |-----------------------------------------------------------|---------------------------|
	 * | [`mousedown`](#map.event:mousedown)                       | yes                       |
	 * | [`mouseup`](#map.event:mouseup)                           | yes                       |
	 * | [`mouseover`](#map.event:mouseover)                       | yes                       |
	 * | [`mouseout`](#map.event:mouseout)                         | yes                       |
	 * | [`mousemove`](#map.event:mousemove)                       | yes                       |
	 * | [`mouseenter`](#map.event:mouseenter)                     | yes (required)            |
	 * | [`mouseleave`](#map.event:mouseleave)                     | yes (required)            |
	 * | [`click`](#map.event:click)                               | yes                       |
	 * | [`dblclick`](#map.event:dblclick)                         | yes                       |
	 * | [`contextmenu`](#map.event:contextmenu)                   | yes                       |
	 * | [`touchstart`](#map.event:touchstart)                     | yes                       |
	 * | [`touchend`](#map.event:touchend)                         | yes                       |
	 * | [`touchcancel`](#map.event:touchcancel)                   | yes                       |
	 * | [`wheel`](#map.event:wheel)                               |                           |
	 * | [`resize`](#map.event:resize)                             |                           |
	 * | [`remove`](#map.event:remove)                             |                           |
	 * | [`touchmove`](#map.event:touchmove)                       |                           |
	 * | [`movestart`](#map.event:movestart)                       |                           |
	 * | [`move`](#map.event:move)                                 |                           |
	 * | [`moveend`](#map.event:moveend)                           |                           |
	 * | [`dragstart`](#map.event:dragstart)                       |                           |
	 * | [`drag`](#map.event:drag)                                 |                           |
	 * | [`dragend`](#map.event:dragend)                           |                           |
	 * | [`zoomstart`](#map.event:zoomstart)                       |                           |
	 * | [`zoom`](#map.event:zoom)                                 |                           |
	 * | [`zoomend`](#map.event:zoomend)                           |                           |
	 * | [`rotatestart`](#map.event:rotatestart)                   |                           |
	 * | [`rotate`](#map.event:rotate)                             |                           |
	 * | [`rotateend`](#map.event:rotateend)                       |                           |
	 * | [`pitchstart`](#map.event:pitchstart)                     |                           |
	 * | [`pitch`](#map.event:pitch)                               |                           |
	 * | [`pitchend`](#map.event:pitchend)                         |                           |
	 * | [`boxzoomstart`](#map.event:boxzoomstart)                 |                           |
	 * | [`boxzoomend`](#map.event:boxzoomend)                     |                           |
	 * | [`boxzoomcancel`](#map.event:boxzoomcancel)               |                           |
	 * | [`webglcontextlost`](#map.event:webglcontextlost)         |                           |
	 * | [`webglcontextrestored`](#map.event:webglcontextrestored) |                           |
	 * | [`load`](#map.event:load)                                 |                           |
	 * | [`render`](#map.event:render)                             |                           |
	 * | [`idle`](#map.event:idle)                                 |                           |
	 * | [`error`](#map.event:error)                               |                           |
	 * | [`data`](#map.event:data)                                 |                           |
	 * | [`styledata`](#map.event:styledata)                       |                           |
	 * | [`sourcedata`](#map.event:sourcedata)                     |                           |
	 * | [`dataloading`](#map.event:dataloading)                   |                           |
	 * | [`styledataloading`](#map.event:styledataloading)         |                           |
	 * | [`sourcedataloading`](#map.event:sourcedataloading)       |                           |
	 * | [`styleimagemissing`](#map.event:styleimagemissing)       |                           |
	 * | [`dataabort`](#map.event:dataabort)                       |                           |
	 * | [`sourcedataabort`](#map.event:sourcedataabort)           |                           |
	 *
	 * @param {string | Listener} layer The ID of a style layer or a listener if no ID is provided. Event will only be triggered if its location
	 * is within a visible feature in this layer. The event will have a `features` property containing
	 * an array of the matching features. If `layerIdOrListener` is not supplied, the event will not have a `features` property.
	 * Please note that many event types are not compatible with the optional `layerIdOrListener` parameter.
	 * @param {Function} listener The function to be called when the event is fired.
	 * @returns {Map} `this`
	 * @example
	 * // Set an event listener that will fire
	 * // when the map has finished loading
	 * map.on('load', function() {
	 *   // Once the map has finished loading,
	 *   // add a new layer
	 *   map.addLayer({
	 *     id: 'points-of-interest',
	 *     source: {
	 *       type: 'vector',
	 *       url: 'https://maplibre.org/maplibre-style-spec/'
	 *     },
	 *     'source-layer': 'poi_label',
	 *     type: 'circle',
	 *     paint: {
	 *       // MapLibre Style Specification paint properties
	 *     },
	 *     layout: {
	 *       // MapLibre Style Specification layout properties
	 *     }
	 *   });
	 * });
	 * @example
	 * // Set an event listener that will fire
	 * // when a feature on the countries layer of the map is clicked
	 * map.on('click', 'countries', function(e) {
	 *   new maplibregl.Popup()
	 *     .setLngLat(e.lngLat)
	 *     .setHTML(`Country name: ${e.features[0].properties.name}`)
	 *     .addTo(map);
	 * });
	 * @see [Display popup on click](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-click/)
	 * @see [Center the map on a clicked symbol](https://maplibre.org/maplibre-gl-js-docs/example/center-on-symbol/)
	 * @see [Create a hover effect](https://maplibre.org/maplibre-gl-js-docs/example/hover-styles/)
	 * @see [Create a draggable marker](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
	 */
	on<T extends keyof MapLayerEventType>(type: T, layer: string, listener: (ev: MapLayerEventType[T] & Object) => void): this;
	on<T extends keyof MapEventType>(type: T, listener: (ev: MapEventType[T] & Object) => void): this;
	on(type: MapEvent | string, listener: Listener): this;
	/**
	 * Adds a listener that will be called only once to a specified event type.
	 *
	 * @method
	 * @name once
	 * @memberof Map
	 * @instance
	 * @param {string} type The event type to add a listener for.
	 * @param {Function} listener The function to be called when the event is fired.
	 * The listener function is called with the data object passed to `fire`,
	 * extended with `target` and `type` properties.
	 * @returns {Map} `this`
	 */
	/**
	 * Adds a listener that will be called only once to a specified event type occurring on features in a specified style layer.
	 *
	 * @param {string} type The event type to listen for; one of `'mousedown'`, `'mouseup'`, `'click'`, `'dblclick'`,
	 * `'mousemove'`, `'mouseenter'`, `'mouseleave'`, `'mouseover'`, `'mouseout'`, `'contextmenu'`, `'touchstart'`,
	 * `'touchend'`, or `'touchcancel'`. `mouseenter` and `mouseover` events are triggered when the cursor enters
	 * a visible portion of the specified layer from outside that layer or outside the map canvas. `mouseleave`
	 * and `mouseout` events are triggered when the cursor leaves a visible portion of the specified layer, or leaves
	 * the map canvas.
	 * @param {string} layer The ID of a style layer or a listener if no ID is provided. Only events whose location is within a visible
	 * feature in this layer will trigger the listener. The event will have a `features` property containing
	 * an array of the matching features.
	 * @param {Function} listener The function to be called when the event is fired.
	 * @returns {Map | Promise} `this` if listener is provided, promise otherwise to allow easier usage of async/await
	 */
	once<T extends keyof MapLayerEventType>(type: T, layer: string, listener?: (ev: MapLayerEventType[T] & Object) => void): this | Promise<MapLayerEventType[T] & Object>;
	once<T extends keyof MapEventType>(type: T, listener?: (ev: MapEventType[T] & Object) => void): this | Promise<any>;
	once(type: MapEvent | string, listener?: Listener): this | Promise<any>;
	/**
	 * Removes an event listener previously added with `Map#on`.
	 *
	 * @method
	 * @name off
	 * @memberof Map
	 * @instance
	 * @param {string} type The event type previously used to install the listener.
	 * @param {Function} listener The function previously installed as a listener.
	 * @returns {Map} `this`
	 */
	/**
	 * Removes an event listener for layer-specific events previously added with `Map#on`.
	 *
	 * @param {string} type The event type previously used to install the listener.
	 * @param {string} layer The layer ID or listener previously used to install the listener.
	 * @param {Function} listener The function previously installed as a listener.
	 * @returns {Map} `this`
	 */
	off<T extends keyof MapLayerEventType>(type: T, layer: string, listener: (ev: MapLayerEventType[T] & Object) => void): this;
	off<T extends keyof MapEventType>(type: T, listener: (ev: MapEventType[T] & Object) => void): this;
	off(type: MapEvent | string, listener: Listener): this;
	/**
	 * Returns an array of MapGeoJSONFeature objects
	 * representing visible features that satisfy the query parameters.
	 *
	 * @param {PointLike|Array<PointLike>|QueryRenderedFeaturesOptions} [geometryOrOptions] (optional) The geometry of the query region:
	 * either a single point or southwest and northeast points describing a bounding box.
	 * Omitting this parameter (i.e. calling {@link Map#queryRenderedFeatures} with zero arguments,
	 * or with only a `options` argument) is equivalent to passing a bounding box encompassing the entire
	 * map viewport.
	 * The geometryOrOptions can receive a QueryRenderedFeaturesOptions only to support a situation where the function receives only one parameter which is the options parameter.
	 * @param {QueryRenderedFeaturesOptions} [options] (optional) Options object.
	 * @param {Array<string>} [options.layers] (optional) An array of [style layer IDs](https://maplibre.org/maplibre-style-spec/#layer-id) for the query to inspect.
	 * Only features within these layers will be returned. If this parameter is undefined, all layers will be checked.
	 * @param {FilterSpecification} [options.filter] (optional) A [filter](https://maplibre.org/maplibre-style-spec/layers/#filter)
	 * to limit query results.
	 * @param {Array<string>} [options.availableImages] (optional) An array of string representing the available images
	 * @param {boolean} [options.validate=true] (optional) Whether to check if the [options.filter] conforms to the MapLibre Style Specification. Disabling validation is a performance optimization that should only be used if you have previously validated the values you will be passing to this function.
	 *
	 * @returns {Array<MapGeoJSONFeature>} An array of MapGeoJSONFeature objects.
	 *
	 * The `properties` value of each returned feature object contains the properties of its source feature. For GeoJSON sources, only
	 * string and numeric property values are supported (i.e. `null`, `Array`, and `Object` values are not supported).
	 *
	 * Each feature includes top-level `layer`, `source`, and `sourceLayer` properties. The `layer` property is an object
	 * representing the style layer to  which the feature belongs. Layout and paint properties in this object contain values
	 * which are fully evaluated for the given zoom level and feature.
	 *
	 * Only features that are currently rendered are included. Some features will **not** be included, like:
	 *
	 * - Features from layers whose `visibility` property is `"none"`.
	 * - Features from layers whose zoom range excludes the current zoom level.
	 * - Symbol features that have been hidden due to text or icon collision.
	 *
	 * Features from all other layers are included, including features that may have no visible
	 * contribution to the rendered result; for example, because the layer's opacity or color alpha component is set to
	 * 0.
	 *
	 * The topmost rendered feature appears first in the returned array, and subsequent features are sorted by
	 * descending z-order. Features that are rendered multiple times (due to wrapping across the antemeridian at low
	 * zoom levels) are returned only once (though subject to the following caveat).
	 *
	 * Because features come from tiled vector data or GeoJSON data that is converted to tiles internally, feature
	 * geometries may be split or duplicated across tile boundaries and, as a result, features may appear multiple
	 * times in query results. For example, suppose there is a highway running through the bounding rectangle of a query.
	 * The results of the query will be those parts of the highway that lie within the map tiles covering the bounding
	 * rectangle, even if the highway extends into other tiles, and the portion of the highway within each map tile
	 * will be returned as a separate feature. Similarly, a point feature near a tile boundary may appear in multiple
	 * tiles due to tile buffering.
	 *
	 * @example
	 * // Find all features at a point
	 * var features = map.queryRenderedFeatures(
	 *   [20, 35],
	 *   { layers: ['my-layer-name'] }
	 * );
	 *
	 * @example
	 * // Find all features within a static bounding box
	 * var features = map.queryRenderedFeatures(
	 *   [[10, 20], [30, 50]],
	 *   { layers: ['my-layer-name'] }
	 * );
	 *
	 * @example
	 * // Find all features within a bounding box around a point
	 * var width = 10;
	 * var height = 20;
	 * var features = map.queryRenderedFeatures([
	 *   [point.x - width / 2, point.y - height / 2],
	 *   [point.x + width / 2, point.y + height / 2]
	 * ], { layers: ['my-layer-name'] });
	 *
	 * @example
	 * // Query all rendered features from a single layer
	 * var features = map.queryRenderedFeatures({ layers: ['my-layer-name'] });
	 * @see [Get features under the mouse pointer](https://maplibre.org/maplibre-gl-js-docs/example/queryrenderedfeatures/)
	 */
	queryRenderedFeatures(geometryOrOptions?: PointLike | [
		PointLike,
		PointLike
	] | QueryRenderedFeaturesOptions, options?: QueryRenderedFeaturesOptions): MapGeoJSONFeature[];
	/**
	 * Returns an array of MapGeoJSONFeature objects
	 * representing features within the specified vector tile or GeoJSON source that satisfy the query parameters.
	 *
	 * @param {string} sourceId The ID of the vector tile or GeoJSON source to query.
	 * @param {Object} [parameters] Options object.
	 * @param {string} [parameters.sourceLayer] The name of the source layer
	 * to query. *For vector tile sources, this parameter is required.* For GeoJSON sources, it is ignored.
	 * @param {Array} [parameters.filter] A [filter](https://maplibre.org/maplibre-style-spec/layers/#filter)
	 * to limit query results.
	 * @param {boolean} [parameters.validate=true] Whether to check if the [parameters.filter] conforms to the MapLibre Style Specification. Disabling validation is a performance optimization that should only be used if you have previously validated the values you will be passing to this function.
	 *
	 * @returns {Array<MapGeoJSONFeature>} An array of MapGeoJSONFeature objects.
	 *
	 * In contrast to {@link Map#queryRenderedFeatures}, this function returns all features matching the query parameters,
	 * whether or not they are rendered by the current style (i.e. visible). The domain of the query includes all currently-loaded
	 * vector tiles and GeoJSON source tiles: this function does not check tiles outside the currently
	 * visible viewport.
	 *
	 * Because features come from tiled vector data or GeoJSON data that is converted to tiles internally, feature
	 * geometries may be split or duplicated across tile boundaries and, as a result, features may appear multiple
	 * times in query results. For example, suppose there is a highway running through the bounding rectangle of a query.
	 * The results of the query will be those parts of the highway that lie within the map tiles covering the bounding
	 * rectangle, even if the highway extends into other tiles, and the portion of the highway within each map tile
	 * will be returned as a separate feature. Similarly, a point feature near a tile boundary may appear in multiple
	 * tiles due to tile buffering.
	 *
	 * @example
	 * // Find all features in one source layer in a vector source
	 * var features = map.querySourceFeatures('your-source-id', {
	 *   sourceLayer: 'your-source-layer'
	 * });
	 *
	 */
	querySourceFeatures(sourceId: string, parameters?: {
		sourceLayer?: string;
		filter?: FilterSpecification;
		validate?: boolean;
	} | null): MapGeoJSONFeature[];
	/**
	 * Updates the map's MapLibre style object with a new value.
	 *
	 * If a style is already set when this is used and options.diff is set to true, the map renderer will attempt to compare the given style
	 * against the map's current state and perform only the changes necessary to make the map style match the desired state. Changes in sprites
	 * (images used for icons and patterns) and glyphs (fonts for label text) **cannot** be diffed. If the sprites or fonts used in the current
	 * style and the given style are different in any way, the map renderer will force a full update, removing the current style and building
	 * the given one from scratch.
	 *
	 *
	 * @param style A JSON object conforming to the schema described in the
	 * [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/), or a URL to such JSON.
	 * @param {Object} [options] Options object.
	 * @param {boolean} [options.diff=true] If false, force a 'full' update, removing the current style
	 * and building the given one instead of attempting a diff-based update.
	 * @param {boolean} [options.validate=true] If false, style validation will be skipped. Useful in production environment.
	 * @param {string} [options.localIdeographFontFamily='sans-serif'] Defines a CSS
	 * font-family for locally overriding generation of glyphs in the 'CJK Unified Ideographs', 'Hiragana', 'Katakana' and 'Hangul Syllables' ranges.
	 * In these ranges, font settings from the map's style will be ignored, except for font-weight keywords (light/regular/medium/bold).
	 * Set to `false`, to enable font settings from the map's style for these glyph ranges.
	 * Forces a full update.
	 * @param {TransformStyleFunction} [options.transformStyle=undefined] transformStyle is a convenience function
	 * that allows to modify a style after it is fetched but before it is committed to the map state. Refer to {@link TransformStyleFunction}.
	 * @returns {Map} `this`
	 *
	 * @example
	 * map.setStyle("https://demotiles.maplibre.org/style.json");
	 *
	 * map.setStyle('https://demotiles.maplibre.org/style.json', {
	 *   transformStyle: (previousStyle, nextStyle) => ({
	 *       ...nextStyle,
	 *       sources: {
	 *           ...nextStyle.sources,
	 *           // copy a source from previous style
	 *           'osm': previousStyle.sources.osm
	 *       },
	 *       layers: [
	 *           // background layer
	 *           nextStyle.layers[0],
	 *           // copy a layer from previous style
	 *           previousStyle.layers[0],
	 *           // other layers from the next style
	 *           ...nextStyle.layers.slice(1).map(layer => {
	 *               // hide the layers we don't need from demotiles style
	 *               if (layer.id.startsWith('geolines')) {
	 *                   layer.layout = {...layer.layout || {}, visibility: 'none'};
	 *               // filter out US polygons
	 *               } else if (layer.id.startsWith('coastline') || layer.id.startsWith('countries')) {
	 *                   layer.filter = ['!=', ['get', 'ADM0_A3'], 'USA'];
	 *               }
	 *               return layer;
	 *           })
	 *       ]
	 *   })
	 * });
	 */
	setStyle(style: StyleSpecification | string | null, options?: StyleSwapOptions & StyleOptions): this;
	/**
	 *  Updates the requestManager's transform request with a new function
	 *
	 * @param transformRequest A callback run before the Map makes a request for an external URL. The callback can be used to modify the url, set headers, or set the credentials property for cross-origin requests.
	 * Expected to return an object with a `url` property and optionally `headers` and `credentials` properties
	 *
	 * @returns {Map} `this`
	 *
	 *  @example
	 *  map.setTransformRequest((url: string, resourceType: string) => {});
	 */
	setTransformRequest(transformRequest: RequestTransformFunction): this;
	_getUIString(key: string): any;
	_updateStyle(style: StyleSpecification | string | null, options?: StyleSwapOptions & StyleOptions): this;
	_lazyInitEmptyStyle(): void;
	_diffStyle(style: StyleSpecification | string, options?: StyleSwapOptions & StyleOptions): void;
	_updateDiff(style: StyleSpecification, options?: StyleSwapOptions & StyleOptions): void;
	/**
	 * Returns the map's MapLibre style object, a JSON object which can be used to recreate the map's style.
	 *
	 * @returns {Object} The map's style JSON object.
	 *
	 * @example
	 * var styleJson = map.getStyle();
	 *
	 */
	getStyle(): StyleSpecification;
	/**
	 * Returns a Boolean indicating whether the map's style is fully loaded.
	 *
	 * @returns {boolean} A Boolean indicating whether the style is fully loaded.
	 *
	 * @example
	 * var styleLoadStatus = map.isStyleLoaded();
	 */
	isStyleLoaded(): boolean | void;
	/**
	 * Adds a source to the map's style.
	 *
	 * @param {string} id The ID of the source to add. Must not conflict with existing sources.
	 * @param {Object} source The source object, conforming to the
	 * MapLibre Style Specification's [source definition](https://maplibre.org/maplibre-style-spec/#sources) or
	 * {@link CanvasSourceOptions}.
	 * @fires source.add
	 * @returns {Map} `this`
	 * @example
	 * map.addSource('my-data', {
	 *   type: 'vector',
	 *   url: 'https://demotiles.maplibre.org/tiles/tiles.json'
	 * });
	 * @example
	 * map.addSource('my-data', {
	 *   "type": "geojson",
	 *   "data": {
	 *     "type": "Feature",
	 *     "geometry": {
	 *       "type": "Point",
	 *       "coordinates": [-77.0323, 38.9131]
	 *     },
	 *     "properties": {
	 *       "title": "Mapbox DC",
	 *       "marker-symbol": "monument"
	 *     }
	 *   }
	 * });
	 * @see GeoJSON source: [Add live realtime data](https://maplibre.org/maplibre-gl-js-docs/example/live-geojson/)
	 */
	addSource(id: string, source: SourceSpecification): this;
	/**
	 * Returns a Boolean indicating whether the source is loaded. Returns `true` if the source with
	 * the given ID in the map's style has no outstanding network requests, otherwise `false`.
	 *
	 * @param {string} id The ID of the source to be checked.
	 * @returns {boolean} A Boolean indicating whether the source is loaded.
	 * @example
	 * var sourceLoaded = map.isSourceLoaded('bathymetry-data');
	 */
	isSourceLoaded(id: string): boolean;
	/**
	 * Loads a 3D terrain mesh, based on a "raster-dem" source.
	 * @param {TerrainSpecification} [options] Options object.
	 * @returns {Map} `this`
	 * @example
	 * map.setTerrain({ source: 'terrain' });
	 */
	setTerrain(options: TerrainSpecification): Map;
	/**
	 * Get the terrain-options if terrain is loaded
	 * @returns {TerrainSpecification} the TerrainSpecification passed to setTerrain
	 * @example
	 * map.getTerrain(); // { source: 'terrain' };
	 */
	getTerrain(): TerrainSpecification;
	/**
	 * Returns a Boolean indicating whether all tiles in the viewport from all sources on
	 * the style are loaded.
	 *
	 * @returns {boolean} A Boolean indicating whether all tiles are loaded.
	 * @example
	 * var tilesLoaded = map.areTilesLoaded();
	 */
	areTilesLoaded(): boolean;
	/**
	 * Adds a [custom source type](#Custom Sources), making it available for use with
	 * {@link Map#addSource}.
	 * @private
	 * @param {string} name The name of the source type; source definition objects use this name in the `{type: ...}` field.
	 * @param {Function} SourceType A {@link Source} constructor.
	 * @param {Callback<void>} callback Called when the source type is ready or with an error argument if there is an error.
	 */
	addSourceType(name: string, SourceType: any, callback: Callback<void>): void;
	/**
	 * Removes a source from the map's style.
	 *
	 * @param {string} id The ID of the source to remove.
	 * @returns {Map} `this`
	 * @example
	 * map.removeSource('bathymetry-data');
	 */
	removeSource(id: string): Map;
	/**
	 * Returns the source with the specified ID in the map's style.
	 *
	 * This method is often used to update a source using the instance members for the relevant
	 * source type as defined in [Sources](#sources).
	 * For example, setting the `data` for a GeoJSON source or updating the `url` and `coordinates`
	 * of an image source.
	 *
	 * @param {string} id The ID of the source to get.
	 * @returns {Source | undefined} The style source with the specified ID or `undefined` if the ID
	 * corresponds to no existing sources.
	 * The shape of the object varies by source type.
	 * A list of options for each source type is available on the MapLibre Style Specification's
	 * [Sources](https://maplibre.org/maplibre-style-spec/sources/) page.
	 * @example
	 * var sourceObject = map.getSource('points');
	 * @see [Create a draggable point](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
	 * @see [Animate a point](https://maplibre.org/maplibre-gl-js-docs/example/animate-point-along-line/)
	 * @see [Add live realtime data](https://maplibre.org/maplibre-gl-js-docs/example/live-geojson/)
	 */
	getSource(id: string): Source | undefined;
	/**
	 * Add an image to the style. This image can be displayed on the map like any other icon in the style's
	 * sprite using the image's ID with
	 * [`icon-image`](https://maplibre.org/maplibre-style-spec/#layout-symbol-icon-image),
	 * [`background-pattern`](https://maplibre.org/maplibre-style-spec/#paint-background-background-pattern),
	 * [`fill-pattern`](https://maplibre.org/maplibre-style-spec/#paint-fill-fill-pattern),
	 * or [`line-pattern`](https://maplibre.org/maplibre-style-spec/#paint-line-line-pattern).
	 * A {@link Map.event:error} event will be fired if there is not enough space in the sprite to add this image.
	 *
	 * @param id The ID of the image.
	 * @param image The image as an `HTMLImageElement`, `ImageData`, `ImageBitmap` or object with `width`, `height`, and `data`
	 * properties with the same format as `ImageData`.
	 * @param options Options object.
	 * @param options.pixelRatio The ratio of pixels in the image to physical pixels on the screen
	 * @param options.sdf Whether the image should be interpreted as an SDF image
	 * @param options.content `[x1, y1, x2, y2]`  If `icon-text-fit` is used in a layer with this image, this option defines the part of the image that can be covered by the content in `text-field`.
	 * @param options.stretchX `[[x1, x2], ...]` If `icon-text-fit` is used in a layer with this image, this option defines the part(s) of the image that can be stretched horizontally.
	 * @param options.stretchY `[[y1, y2], ...]` If `icon-text-fit` is used in a layer with this image, this option defines the part(s) of the image that can be stretched vertically.
	 *
	 * @example
	 * // If the style's sprite does not already contain an image with ID 'cat',
	 * // add the image 'cat-icon.png' to the style's sprite with the ID 'cat'.
	 * map.loadImage('https://upload.wikimedia.org/wikipedia/commons/thumb/6/60/Cat_silhouette.svg/400px-Cat_silhouette.svg.png', function(error, image) {
	 *    if (error) throw error;
	 *    if (!map.hasImage('cat')) map.addImage('cat', image);
	 * });
	 *
	 *
	 * // Add a stretchable image that can be used with `icon-text-fit`
	 * // In this example, the image is 600px wide by 400px high.
	 * map.loadImage('https://upload.wikimedia.org/wikipedia/commons/8/89/Black_and_White_Boxed_%28bordered%29.png', function(error, image) {
	 *    if (error) throw error;
	 *    if (!map.hasImage('border-image')) {
	 *      map.addImage('border-image', image, {
	 *          content: [16, 16, 300, 384], // place text over left half of image, avoiding the 16px border
	 *          stretchX: [[16, 584]], // stretch everything horizontally except the 16px border
	 *          stretchY: [[16, 384]], // stretch everything vertically except the 16px border
	 *      });
	 *    }
	 * });
	 *
	 *
	 * @see Use `HTMLImageElement`: [Add an icon to the map](https://maplibre.org/maplibre-gl-js-docs/example/add-image/)
	 * @see Use `ImageData`: [Add a generated icon to the map](https://maplibre.org/maplibre-gl-js-docs/example/add-image-generated/)
	 */
	addImage(id: string, image: HTMLImageElement | ImageBitmap | ImageData | {
		width: number;
		height: number;
		data: Uint8Array | Uint8ClampedArray;
	} | StyleImageInterface, { pixelRatio, sdf, stretchX, stretchY, content }?: Partial<StyleImageMetadata>): this;
	/**
	 * Update an existing image in a style. This image can be displayed on the map like any other icon in the style's
	 * sprite using the image's ID with
	 * [`icon-image`](https://maplibre.org/maplibre-style-spec/#layout-symbol-icon-image),
	 * [`background-pattern`](https://maplibre.org/maplibre-style-spec/#paint-background-background-pattern),
	 * [`fill-pattern`](https://maplibre.org/maplibre-style-spec/#paint-fill-fill-pattern),
	 * or [`line-pattern`](https://maplibre.org/maplibre-style-spec/#paint-line-line-pattern).
	 *
	 * @param id The ID of the image.
	 * @param image The image as an `HTMLImageElement`, `ImageData`, `ImageBitmap` or object with `width`, `height`, and `data`
	 * properties with the same format as `ImageData`.
	 *
	 * @example
	 * // If an image with the ID 'cat' already exists in the style's sprite,
	 * // replace that image with a new image, 'other-cat-icon.png'.
	 * if (map.hasImage('cat')) map.updateImage('cat', './other-cat-icon.png');
	 */
	updateImage(id: string, image: HTMLImageElement | ImageBitmap | ImageData | {
		width: number;
		height: number;
		data: Uint8Array | Uint8ClampedArray;
	} | StyleImageInterface): this;
	/**
	 * Returns an image, specified by ID, currently available in the map.
	 * This includes both images from the style's original sprite
	 * and any images that have been added at runtime using {@link Map#addImage}.
	 *
	 * @param id The ID of the image.
	 * @returns {StyleImage} An image in the map with the specified ID.
	 *
	 * @example
	 * var coffeeShopIcon = map.getImage("coffee_cup");
	 *
	 */
	getImage(id: string): StyleImage;
	/**
	 * Check whether or not an image with a specific ID exists in the style. This checks both images
	 * in the style's original sprite and any images
	 * that have been added at runtime using {@link Map#addImage}.
	 *
	 * @param id The ID of the image.
	 *
	 * @returns {boolean} A Boolean indicating whether the image exists.
	 * @example
	 * // Check if an image with the ID 'cat' exists in
	 * // the style's sprite.
	 * var catIconExists = map.hasImage('cat');
	 */
	hasImage(id: string): boolean;
	/**
	 * Remove an image from a style. This can be an image from the style's original
	 * sprite or any images
	 * that have been added at runtime using {@link Map#addImage}.
	 *
	 * @param id The ID of the image.
	 *
	 * @example
	 * // If an image with the ID 'cat' exists in
	 * // the style's sprite, remove it.
	 * if (map.hasImage('cat')) map.removeImage('cat');
	 */
	removeImage(id: string): void;
	/**
	 * Load an image from an external URL to be used with {@link Map#addImage}. External
	 * domains must support [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS).
	 *
	 * @param {string} url The URL of the image file. Image file must be in png, webp, or jpg format.
	 * @param {Callback<HTMLImageElement | ImageBitmap>} callback Expecting `callback(error, data)`. Called when the image has loaded or with an error argument if there is an error.
	 *
	 * @example
	 * // Load an image from an external URL.
	 * map.loadImage('http://placekitten.com/50/50', function(error, image) {
	 *   if (error) throw error;
	 *   // Add the loaded image to the style's sprite with the ID 'kitten'.
	 *   map.addImage('kitten', image);
	 * });
	 *
	 * @see [Add an icon to the map](https://maplibre.org/maplibre-gl-js-docs/example/add-image/)
	 */
	loadImage(url: string, callback: GetImageCallback): void;
	/**
	 * Returns an Array of strings containing the IDs of all images currently available in the map.
	 * This includes both images from the style's original sprite
	 * and any images that have been added at runtime using {@link Map#addImage}.
	 *
	 * @returns {Array<string>} An Array of strings containing the names of all sprites/images currently available in the map.
	 *
	 * @example
	 * var allImages = map.listImages();
	 *
	 */
	listImages(): string[];
	/**
	 * Adds a [MapLibre style layer](https://maplibre.org/maplibre-style-spec/#layers)
	 * to the map's style.
	 *
	 * A layer defines how data from a specified source will be styled. Read more about layer types
	 * and available paint and layout properties in the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/#layers).
	 *
	 * TODO: JSDoc can't pass @param {(LayerSpecification & {source?: string | SourceSpecification}) | CustomLayerInterface} layer The layer to add,
	 * @param {Object} layer
	 * conforming to either the MapLibre Style Specification's [layer definition](https://maplibre.org/maplibre-style-spec/#layers) or,
	 * less commonly, the {@link CustomLayerInterface} specification.
	 * The MapLibre Style Specification's layer definition is appropriate for most layers.
	 *
	 * @param {string} layer.id A unique identifier that you define.
	 * @param {string} layer.type The type of layer (for example `fill` or `symbol`).
	 * A list of layer types is available in the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/layers/#type).
	 *
	 * (This can also be `custom`. For more information, see {@link CustomLayerInterface}.)
	 * @param {string | SourceSpecification} [layer.source] The data source for the layer.
	 * Reference a source that has _already been defined_ using the source's unique id.
	 * Reference a _new source_ using a source object (as defined in the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/sources/)) directly.
	 * This is **required** for all `layer.type` options _except_ for `custom` and `background`.
	 * @param {string} [layer.sourceLayer] (optional) The name of the source layer within the specified `layer.source` to use for this style layer.
	 * This is only applicable for vector tile sources and is **required** when `layer.source` is of the type `vector`.
	 * @param {array} [layer.filter] (optional) An expression specifying conditions on source features.
	 * Only features that match the filter are displayed.
	 * The MapLibre Style Specification includes more information on the limitations of the [`filter`](https://maplibre.org/maplibre-style-spec/layers/#filter) parameter
	 * and a complete list of available [expressions](https://maplibre.org/maplibre-style-spec/expressions/).
	 * If no filter is provided, all features in the source (or source layer for vector tilesets) will be displayed.
	 * @param {Object} [layer.paint] (optional) Paint properties for the layer.
	 * Available paint properties vary by `layer.type`.
	 * A full list of paint properties for each layer type is available in the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/layers/).
	 * If no paint properties are specified, default values will be used.
	 * @param {Object} [layer.layout] (optional) Layout properties for the layer.
	 * Available layout properties vary by `layer.type`.
	 * A full list of layout properties for each layer type is available in the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/layers/).
	 * If no layout properties are specified, default values will be used.
	 * @param {number} [layer.maxzoom] (optional) The maximum zoom level for the layer.
	 * At zoom levels equal to or greater than the maxzoom, the layer will be hidden.
	 * The value can be any number between `0` and `24` (inclusive).
	 * If no maxzoom is provided, the layer will be visible at all zoom levels for which there are tiles available.
	 * @param {number} [layer.minzoom] (optional) The minimum zoom level for the layer.
	 * At zoom levels less than the minzoom, the layer will be hidden.
	 * The value can be any number between `0` and `24` (inclusive).
	 * If no minzoom is provided, the layer will be visible at all zoom levels for which there are tiles available.
	 * @param {Object} [layer.metadata] (optional) Arbitrary properties useful to track with the layer, but do not influence rendering.
	 * @param {string} [layer.renderingMode] This is only applicable for layers with the type `custom`.
	 * See {@link CustomLayerInterface} for more information.
	 * @param {string} [beforeId] The ID of an existing layer to insert the new layer before,
	 * resulting in the new layer appearing visually beneath the existing layer.
	 * If this argument is not specified, the layer will be appended to the end of the layers array
	 * and appear visually above all other layers.
	 *
	 * @returns {Map} `this`
	 *
	 * @example
	 * // Add a circle layer with a vector source
	 * map.addLayer({
	 *   id: 'points-of-interest',
	 *   source: {
	 *     type: 'vector',
	 *     url: 'https://demotiles.maplibre.org/tiles/tiles.json'
	 *   },
	 *   'source-layer': 'poi_label',
	 *   type: 'circle',
	 *   paint: {
	 *     // MapLibre Style Specification paint properties
	 *   },
	 *   layout: {
	 *     // MapLibre Style Specification layout properties
	 *   }
	 * });
	 *
	 * @example
	 * // Define a source before using it to create a new layer
	 * map.addSource('state-data', {
	 *   type: 'geojson',
	 *   data: 'path/to/data.geojson'
	 * });
	 *
	 * map.addLayer({
	 *   id: 'states',
	 *   // References the GeoJSON source defined above
	 *   // and does not require a `source-layer`
	 *   source: 'state-data',
	 *   type: 'symbol',
	 *   layout: {
	 *     // Set the label content to the
	 *     // feature's `name` property
	 *     text-field: ['get', 'name']
	 *   }
	 * });
	 *
	 * @example
	 * // Add a new symbol layer before an existing layer
	 * map.addLayer({
	 *   id: 'states',
	 *   // References a source that's already been defined
	 *   source: 'state-data',
	 *   type: 'symbol',
	 *   layout: {
	 *     // Set the label content to the
	 *     // feature's `name` property
	 *     text-field: ['get', 'name']
	 *   }
	 * // Add the layer before the existing `cities` layer
	 * }, 'cities');
	 *
	 * @see [Create and style clusters](https://maplibre.org/maplibre-gl-js-docs/example/cluster/)
	 * @see [Add a vector tile source](https://maplibre.org/maplibre-gl-js-docs/example/vector-source/)
	 * @see [Add a WMS source](https://maplibre.org/maplibre-gl-js-docs/example/wms/)
	 */
	addLayer(layer: (LayerSpecification & {
		source?: string | SourceSpecification;
	}) | CustomLayerInterface, beforeId?: string): this;
	/**
	 * Moves a layer to a different z-position.
	 *
	 * @param {string} id The ID of the layer to move.
	 * @param {string} [beforeId] The ID of an existing layer to insert the new layer before. When viewing the map, the `id` layer will appear beneath the `beforeId` layer. If `beforeId` is omitted, the layer will be appended to the end of the layers array and appear above all other layers on the map.
	 * @returns {Map} `this`
	 *
	 * @example
	 * // Move a layer with ID 'polygon' before the layer with ID 'country-label'. The `polygon` layer will appear beneath the `country-label` layer on the map.
	 * map.moveLayer('polygon', 'country-label');
	 */
	moveLayer(id: string, beforeId?: string): this;
	/**
	 * Removes the layer with the given ID from the map's style.
	 *
	 * If no such layer exists, an `error` event is fired.
	 *
	 * @param {string} id id of the layer to remove
	 * @fires error
	 *
	 * @example
	 * // If a layer with ID 'state-data' exists, remove it.
	 * if (map.getLayer('state-data')) map.removeLayer('state-data');
	 */
	removeLayer(id: string): this;
	/**
	 * Returns the layer with the specified ID in the map's style.
	 *
	 * @param {string} id The ID of the layer to get.
	 * @returns {StyleLayer} The layer with the specified ID, or `undefined`
	 * if the ID corresponds to no existing layers.
	 *
	 * @example
	 * var stateDataLayer = map.getLayer('state-data');
	 *
	 * @see [Filter symbols by toggling a list](https://maplibre.org/maplibre-gl-js-docs/example/filter-markers/)
	 * @see [Filter symbols by text input](https://maplibre.org/maplibre-gl-js-docs/example/filter-markers-by-input/)
	 */
	getLayer(id: string): StyleLayer;
	/**
	 * Sets the zoom extent for the specified style layer. The zoom extent includes the
	 * [minimum zoom level](https://maplibre.org/maplibre-style-spec/#layer-minzoom)
	 * and [maximum zoom level](https://maplibre.org/maplibre-style-spec/#layer-maxzoom))
	 * at which the layer will be rendered.
	 *
	 * Note: For style layers using vector sources, style layers cannot be rendered at zoom levels lower than the
	 * minimum zoom level of the _source layer_ because the data does not exist at those zoom levels. If the minimum
	 * zoom level of the source layer is higher than the minimum zoom level defined in the style layer, the style
	 * layer will not be rendered at all zoom levels in the zoom range.
	 *
	 * @param {string} layerId The ID of the layer to which the zoom extent will be applied.
	 * @param {number} minzoom The minimum zoom to set (0-24).
	 * @param {number} maxzoom The maximum zoom to set (0-24).
	 * @returns {Map} `this`
	 *
	 * @example
	 * map.setLayerZoomRange('my-layer', 2, 5);
	 *
	 */
	setLayerZoomRange(layerId: string, minzoom: number, maxzoom: number): this;
	/**
	 * Sets the filter for the specified style layer.
	 *
	 * Filters control which features a style layer renders from its source.
	 * Any feature for which the filter expression evaluates to `true` will be
	 * rendered on the map. Those that are false will be hidden.
	 *
	 * Use `setFilter` to show a subset of your source data.
	 *
	 * To clear the filter, pass `null` or `undefined` as the second parameter.
	 *
	 * @param {string} layerId The ID of the layer to which the filter will be applied.
	 * @param {Array | null | undefined} filter The filter, conforming to the MapLibre Style Specification's
	 * [filter definition](https://maplibre.org/maplibre-style-spec/layers/#filter).  If `null` or `undefined` is provided, the function removes any existing filter from the layer.
	 * @param {Object} [options] Options object.
	 * @param {boolean} [options.validate=true] Whether to check if the filter conforms to the MapLibre Style Specification. Disabling validation is a performance optimization that should only be used if you have previously validated the values you will be passing to this function.
	 * @returns {Map} `this`
	 *
	 * @example
	 * // display only features with the 'name' property 'USA'
	 * map.setFilter('my-layer', ['==', ['get', 'name'], 'USA']);
	 * @example
	 * // display only features with five or more 'available-spots'
	 * map.setFilter('bike-docks', ['>=', ['get', 'available-spots'], 5]);
	 * @example
	 * // remove the filter for the 'bike-docks' style layer
	 * map.setFilter('bike-docks', null);
	 *
	 * @see [Create a timeline animation](https://maplibre.org/maplibre-gl-js-docs/example/timeline-animation/)
	 */
	setFilter(layerId: string, filter?: FilterSpecification | null, options?: StyleSetterOptions): this;
	/**
	 * Returns the filter applied to the specified style layer.
	 *
	 * @param {string} layerId The ID of the style layer whose filter to get.
	 * @returns {Array} The layer's filter.
	 */
	getFilter(layerId: string): void | FilterSpecification;
	/**
	 * Sets the value of a paint property in the specified style layer.
	 *
	 * @param {string} layerId The ID of the layer to set the paint property in.
	 * @param {string} name The name of the paint property to set.
	 * @param {*} value The value of the paint property to set.
	 * Must be of a type appropriate for the property, as defined in the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/).
	 * @param {Object} [options] Options object.
	 * @param {boolean} [options.validate=true] Whether to check if `value` conforms to the MapLibre Style Specification. Disabling validation is a performance optimization that should only be used if you have previously validated the values you will be passing to this function.
	 * @returns {Map} `this`
	 * @example
	 * map.setPaintProperty('my-layer', 'fill-color', '#faafee');
	 * @see [Change a layer's color with buttons](https://maplibre.org/maplibre-gl-js-docs/example/color-switcher/)
	 * @see [Create a draggable point](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
	 */
	setPaintProperty(layerId: string, name: string, value: any, options?: StyleSetterOptions): this;
	/**
	 * Returns the value of a paint property in the specified style layer.
	 *
	 * @param {string} layerId The ID of the layer to get the paint property from.
	 * @param {string} name The name of a paint property to get.
	 * @returns {*} The value of the specified paint property.
	 */
	getPaintProperty(layerId: string, name: string): unknown;
	/**
	 * Sets the value of a layout property in the specified style layer.
	 *
	 * @param {string} layerId The ID of the layer to set the layout property in.
	 * @param {string} name The name of the layout property to set.
	 * @param {*} value The value of the layout property. Must be of a type appropriate for the property, as defined in the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/).
	 * @param {Object} [options] Options object.
	 * @param {boolean} [options.validate=true] Whether to check if `value` conforms to the MapLibre Style Specification. Disabling validation is a performance optimization that should only be used if you have previously validated the values you will be passing to this function.
	 * @returns {Map} `this`
	 * @example
	 * map.setLayoutProperty('my-layer', 'visibility', 'none');
	 */
	setLayoutProperty(layerId: string, name: string, value: any, options?: StyleSetterOptions): this;
	/**
	 * Returns the value of a layout property in the specified style layer.
	 *
	 * @param {string} layerId The ID of the layer to get the layout property from.
	 * @param {string} name The name of the layout property to get.
	 * @returns {*} The value of the specified layout property.
	 */
	getLayoutProperty(layerId: string, name: string): any;
	/**
	 * Sets the value of the style's glyphs property.
	 *
	 * @param glyphsUrl Glyph URL to set. Must conform to the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/glyphs/).
	 * @param {StyleSetterOptions} [options] Options object.
	 * @param {boolean} [options.validate=true] Whether to check if the filter conforms to the MapLibre Style Specification. Disabling validation is a performance optimization that should only be used if you have previously validated the values you will be passing to this function.
	 * @returns {Map} `this`
	 * @example
	 * map.setGlyphs('https://demotiles.maplibre.org/font/{fontstack}/{range}.pbf');
	 */
	setGlyphs(glyphsUrl: string | null, options?: StyleSetterOptions): this;
	/**
	 * Returns the value of the style's glyphs URL
	 *
	 * @returns {string | null} glyphs Style's glyphs url
	 */
	getGlyphs(): string;
	/**
	 * Adds a sprite to the map's style.
	 *
	 * @param {string} id The ID of the sprite to add. Must not conflict with existing sprites.
	 * @param {string} url The URL to load the sprite from
	 * @param {StyleSetterOptions} [options] Options object.
	 * @fires style
	 * @returns {Map} `this`
	 * @example
	 * map.addSprite('sprite-two', 'http://example.com/sprite-two');
	 */
	addSprite(id: string, url: string, options?: StyleSetterOptions): this;
	/**
	 * Removes the sprite from the map's style.
	 *
	 * @param {string} id The ID of the sprite to remove. If the sprite is declared as a single URL, the ID must be "default".
	 * @fires style
	 * @returns {Map} `this`
	 * @example
	 * map.removeSprite('sprite-two');
	 * @example
	 * map.removeSprite('default');
	 */
	removeSprite(id: string): this;
	/**
	 * Returns the as-is value of the style's sprite.
	 *
	 * @returns {SpriteSpecification | undefined} style's sprite url or a list of id-url pairs
	 */
	getSprite(): {
		id: string;
		url: string;
	}[];
	/**
	 * Sets the value of the style's sprite property.
	 *
	 * @param spriteUrl Sprite URL to set.
	 * @param {StyleSetterOptions} [options] Options object.
	 * @param {boolean} [options.validate=true] Whether to check if the filter conforms to the MapLibre Style Specification. Disabling validation is a performance optimization that should only be used if you have previously validated the values you will be passing to this function.
	 * @returns {Map} `this`
	 * @example
	 * map.setSprite('YOUR_SPRITE_URL');
	 */
	setSprite(spriteUrl: string | null, options?: StyleSetterOptions): this;
	/**
	 * Sets the any combination of light values.
	 *
	 * @param light Light properties to set. Must conform to the [MapLibre Style Specification](https://maplibre.org/maplibre-style-spec/#light).
	 * @param {Object} [options] Options object.
	 * @param {boolean} [options.validate=true] Whether to check if the filter conforms to the MapLibre Style Specification. Disabling validation is a performance optimization that should only be used if you have previously validated the values you will be passing to this function.
	 * @returns {Map} `this`
	 * @example
	 * var layerVisibility = map.getLayoutProperty('my-layer', 'visibility');
	 */
	setLight(light: LightSpecification, options?: StyleSetterOptions): this;
	/**
	 * Returns the value of the light object.
	 *
	 * @returns {Object} light Light properties of the style.
	 */
	getLight(): any;
	/**
	 * Sets the `state` of a feature.
	 * A feature's `state` is a set of user-defined key-value pairs that are assigned to a feature at runtime.
	 * When using this method, the `state` object is merged with any existing key-value pairs in the feature's state.
	 * Features are identified by their `feature.id` attribute, which can be any number or string.
	 *
	 * This method can only be used with sources that have a `feature.id` attribute. The `feature.id` attribute can be defined in three ways:
	 * - For vector or GeoJSON sources, including an `id` attribute in the original data file.
	 * - For vector or GeoJSON sources, using the [`promoteId`](https://maplibre.org/maplibre-style-spec/sources/#vector-promoteId) option at the time the source is defined.
	 * - For GeoJSON sources, using the [`generateId`](https://maplibre.org/maplibre-style-spec/sources/#geojson-generateId) option to auto-assign an `id` based on the feature's index in the source data. If you change feature data using `map.getSource('some id').setData(..)`, you may need to re-apply state taking into account updated `id` values.
	 *
	 * _Note: You can use the [`feature-state` expression](https://maplibre.org/maplibre-style-spec/expressions/#feature-state) to access the values in a feature's state object for the purposes of styling._
	 *
	 * @param {Object} feature Feature identifier. Feature objects returned from
	 * {@link Map#queryRenderedFeatures} or event handlers can be used as feature identifiers.
	 * @param {string | number} feature.id Unique id of the feature.
	 * @param {string} feature.source The id of the vector or GeoJSON source for the feature.
	 * @param {string} [feature.sourceLayer] (optional) *For vector tile sources, `sourceLayer` is required.*
	 * @param {Object} state A set of key-value pairs. The values should be valid JSON types.
	 *
	 * @example
	 * // When the mouse moves over the `my-layer` layer, update
	 * // the feature state for the feature under the mouse
	 * map.on('mousemove', 'my-layer', function(e) {
	 *   if (e.features.length > 0) {
	 *     map.setFeatureState({
	 *       source: 'my-source',
	 *       sourceLayer: 'my-source-layer',
	 *       id: e.features[0].id,
	 *     }, {
	 *       hover: true
	 *     });
	 *   }
	 * });
	 *
	 * @see [Create a hover effect](https://maplibre.org/maplibre-gl-js-docs/example/hover-styles/)
	 */
	setFeatureState(feature: FeatureIdentifier, state: any): this;
	/**
	 * Removes the `state` of a feature, setting it back to the default behavior.
	 * If only a `target.source` is specified, it will remove the state for all features from that source.
	 * If `target.id` is also specified, it will remove all keys for that feature's state.
	 * If `key` is also specified, it removes only that key from that feature's state.
	 * Features are identified by their `feature.id` attribute, which can be any number or string.
	 *
	 * @param {Object} target Identifier of where to remove state. It can be a source, a feature, or a specific key of feature.
	 * Feature objects returned from {@link Map#queryRenderedFeatures} or event handlers can be used as feature identifiers.
	 * @param {string | number} target.id (optional) Unique id of the feature. Optional if key is not specified.
	 * @param {string} target.source The id of the vector or GeoJSON source for the feature.
	 * @param {string} [target.sourceLayer] (optional) *For vector tile sources, `sourceLayer` is required.*
	 * @param {string} key (optional) The key in the feature state to reset.
	 *
	 * @example
	 * // Reset the entire state object for all features
	 * // in the `my-source` source
	 * map.removeFeatureState({
	 *   source: 'my-source'
	 * });
	 *
	 * @example
	 * // When the mouse leaves the `my-layer` layer,
	 * // reset the entire state object for the
	 * // feature under the mouse
	 * map.on('mouseleave', 'my-layer', function(e) {
	 *   map.removeFeatureState({
	 *     source: 'my-source',
	 *     sourceLayer: 'my-source-layer',
	 *     id: e.features[0].id
	 *   });
	 * });
	 *
	 * @example
	 * // When the mouse leaves the `my-layer` layer,
	 * // reset only the `hover` key-value pair in the
	 * // state for the feature under the mouse
	 * map.on('mouseleave', 'my-layer', function(e) {
	 *   map.removeFeatureState({
	 *     source: 'my-source',
	 *     sourceLayer: 'my-source-layer',
	 *     id: e.features[0].id
	 *   }, 'hover');
	 * });
	 *
	 */
	removeFeatureState(target: FeatureIdentifier, key?: string): this;
	/**
	 * Gets the `state` of a feature.
	 * A feature's `state` is a set of user-defined key-value pairs that are assigned to a feature at runtime.
	 * Features are identified by their `feature.id` attribute, which can be any number or string.
	 *
	 * _Note: To access the values in a feature's state object for the purposes of styling the feature, use the [`feature-state` expression](https://maplibre.org/maplibre-style-spec/expressions/#feature-state)._
	 *
	 * @param {Object} feature Feature identifier. Feature objects returned from
	 * {@link Map#queryRenderedFeatures} or event handlers can be used as feature identifiers.
	 * @param {string | number} feature.id Unique id of the feature.
	 * @param {string} feature.source The id of the vector or GeoJSON source for the feature.
	 * @param {string} [feature.sourceLayer] (optional) *For vector tile sources, `sourceLayer` is required.*
	 *
	 * @returns {Object} The state of the feature: a set of key-value pairs that was assigned to the feature at runtime.
	 *
	 * @example
	 * // When the mouse moves over the `my-layer` layer,
	 * // get the feature state for the feature under the mouse
	 * map.on('mousemove', 'my-layer', function(e) {
	 *   if (e.features.length > 0) {
	 *     map.getFeatureState({
	 *       source: 'my-source',
	 *       sourceLayer: 'my-source-layer',
	 *       id: e.features[0].id
	 *     });
	 *   }
	 * });
	 *
	 */
	getFeatureState(feature: FeatureIdentifier): any;
	/**
	 * Returns the map's containing HTML element.
	 *
	 * @returns {HTMLElement} The map's container.
	 */
	getContainer(): HTMLElement;
	/**
	 * Returns the HTML element containing the map's `<canvas>` element.
	 *
	 * If you want to add non-GL overlays to the map, you should append them to this element.
	 *
	 * This is the element to which event bindings for map interactivity (such as panning and zooming) are
	 * attached. It will receive bubbled events from child elements such as the `<canvas>`, but not from
	 * map controls.
	 *
	 * @returns {HTMLElement} The container of the map's `<canvas>`.
	 * @see [Create a draggable point](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-point/)
	 */
	getCanvasContainer(): HTMLElement;
	/**
	 * Returns the map's `<canvas>` element.
	 *
	 * @returns {HTMLCanvasElement} The map's `<canvas>` element.
	 * @see [Measure distances](https://maplibre.org/maplibre-gl-js-docs/example/measure/)
	 * @see [Display a popup on hover](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-hover/)
	 * @see [Center the map on a clicked symbol](https://maplibre.org/maplibre-gl-js-docs/example/center-on-symbol/)
	 */
	getCanvas(): HTMLCanvasElement;
	_containerDimensions(): number[];
	_setupContainer(): void;
	_cooperativeGesturesOnWheel(event: WheelEvent): void;
	_setupCooperativeGestures(): void;
	_destroyCooperativeGestures(): void;
	_resizeCanvas(width: number, height: number, pixelRatio: number): void;
	_setupPainter(): void;
	_contextLost(event: any): void;
	_contextRestored(event: any): void;
	_onMapScroll(event: any): boolean;
	_onCooperativeGesture(event: any, metaPress: any, touches: any): boolean;
	/**
	 * Returns a Boolean indicating whether the map is fully loaded.
	 *
	 * Returns `false` if the style is not yet fully loaded,
	 * or if there has been a change to the sources or style that
	 * has not yet fully loaded.
	 *
	 * @returns {boolean} A Boolean indicating whether the map is fully loaded.
	 */
	loaded(): boolean;
	/**
	 * Update this map's style and sources, and re-render the map.
	 *
	 * @param {boolean} updateStyle mark the map's style for reprocessing as
	 * well as its sources
	 * @returns {Map} this
	 * @private
	 */
	_update(updateStyle?: boolean): this;
	/**
	 * Request that the given callback be executed during the next render
	 * frame.  Schedule a render frame if one is not already scheduled.
	 * @returns An id that can be used to cancel the callback
	 * @private
	 */
	_requestRenderFrame(callback: () => void): TaskID;
	_cancelRenderFrame(id: TaskID): void;
	/**
	 * Call when a (re-)render of the map is required:
	 * - The style has changed (`setPaintProperty()`, etc.)
	 * - Source data has changed (e.g. tiles have finished loading)
	 * - The map has is moving (or just finished moving)
	 * - A transition is in progress
	 *
	 * @param {number} paintStartTimeStamp  The time when the animation frame began executing.
	 *
	 * @returns {Map} this
	 * @private
	 */
	_render(paintStartTimeStamp: number): this;
	/**
	 * Force a synchronous redraw of the map.
	 * @example
	 * map.redraw();
	 * @returns {Map} `this`
	 */
	redraw(): Map;
	/**
	 * Clean up and release all internal resources associated with this map.
	 *
	 * This includes DOM elements, event bindings, web workers, and WebGL resources.
	 *
	 * Use this method when you are done using the map and wish to ensure that it no
	 * longer consumes browser resources. Afterwards, you must not call any other
	 * methods on the map.
	 */
	remove(): void;
	/**
	 * Trigger the rendering of a single frame. Use this method with custom layers to
	 * repaint the map when the layer changes. Calling this multiple times before the
	 * next frame is rendered will still result in only a single frame being rendered.
	 * @example
	 * map.triggerRepaint();
	 * @see [Add a 3D model](https://maplibre.org/maplibre-gl-js-docs/example/add-3d-model/)
	 * @see [Add an animated icon to the map](https://maplibre.org/maplibre-gl-js-docs/example/add-image-animated/)
	 */
	triggerRepaint(): void;
	_onWindowOnline(): void;
	/**
	 * Gets and sets a Boolean indicating whether the map will render an outline
	 * around each tile and the tile ID. These tile boundaries are useful for
	 * debugging.
	 *
	 * The uncompressed file size of the first vector source is drawn in the top left
	 * corner of each tile, next to the tile ID.
	 *
	 * @name showTileBoundaries
	 * @type {boolean}
	 * @instance
	 * @memberof Map
	 * @example
	 * map.showTileBoundaries = true;
	 */
	get showTileBoundaries(): boolean;
	set showTileBoundaries(value: boolean);
	/**
	 * Gets and sets a Boolean indicating whether the map will visualize
	 * the padding offsets.
	 *
	 * @name showPadding
	 * @type {boolean}
	 * @instance
	 * @memberof Map
	 */
	get showPadding(): boolean;
	set showPadding(value: boolean);
	/**
	 * Gets and sets a Boolean indicating whether the map will render boxes
	 * around all symbols in the data source, revealing which symbols
	 * were rendered or which were hidden due to collisions.
	 * This information is useful for debugging.
	 *
	 * @name showCollisionBoxes
	 * @type {boolean}
	 * @instance
	 * @memberof Map
	 */
	get showCollisionBoxes(): boolean;
	set showCollisionBoxes(value: boolean);
	get showOverdrawInspector(): boolean;
	set showOverdrawInspector(value: boolean);
	/**
	 * Gets and sets a Boolean indicating whether the map will
	 * continuously repaint. This information is useful for analyzing performance.
	 *
	 * @name repaint
	 * @type {boolean}
	 * @instance
	 * @memberof Map
	 */
	get repaint(): boolean;
	set repaint(value: boolean);
	get vertices(): boolean;
	set vertices(value: boolean);
	/**
	 * Returns the package version of the library
	 * @returns {string} Package version of the library
	 */
	get version(): string;
	/**
	 * Returns the elevation for the point where the camera is looking.
	 * This value corresponds to:
	 * "meters above sea level" * "exaggeration"
	 * @returns {number} * The elevation.
	 */
	getCameraTargetElevation(): number;
}
export interface OneFingerTouchRotateHandler extends DragMoveHandler<DragRotateResult, TouchEvent> {
}
export interface OneFingerTouchPitchHandler extends DragMoveHandler<DragPitchResult, TouchEvent> {
}
export type NavigationOptions = {
	showCompass?: boolean;
	showZoom?: boolean;
	visualizePitch?: boolean;
};
export declare class NavigationControl implements IControl {
	_map: Map;
	options: NavigationOptions;
	_container: HTMLElement;
	_zoomInButton: HTMLButtonElement;
	_zoomOutButton: HTMLButtonElement;
	_compass: HTMLButtonElement;
	_compassIcon: HTMLElement;
	_handler: MouseRotateWrapper;
	constructor(options?: NavigationOptions);
	_updateZoomButtons(): void;
	_rotateCompassArrow(): void;
	onAdd(map: Map): HTMLElement;
	onRemove(): void;
	_createButton(className: string, fn: (e?: any) => unknown): HTMLButtonElement;
	_setButtonTitle(button: HTMLButtonElement, title: string): void;
}
export declare class MouseRotateWrapper {
	map: Map;
	_clickTolerance: number;
	element: HTMLElement;
	mouseRotate: MouseRotateHandler;
	touchRotate: OneFingerTouchRotateHandler;
	mousePitch: MousePitchHandler;
	touchPitch: OneFingerTouchPitchHandler;
	_startPos: Point;
	_lastPos: Point;
	constructor(map: Map, element: HTMLElement, pitch?: boolean);
	startMouse(e: MouseEvent, point: Point): void;
	startTouch(e: TouchEvent, point: Point): void;
	moveMouse(e: MouseEvent, point: Point): void;
	moveTouch(e: TouchEvent, point: Point): void;
	off(): void;
	offTemp(): void;
	mousedown(e: MouseEvent): void;
	mousemove(e: MouseEvent): void;
	mouseup(e: MouseEvent): void;
	touchstart(e: TouchEvent): void;
	touchmove(e: TouchEvent): void;
	touchend(e: TouchEvent): void;
	reset(): void;
}
export type PositionAnchor = "center" | "top" | "bottom" | "left" | "right" | "top-left" | "top-right" | "bottom-left" | "bottom-right";
export type Offset = number | PointLike | {
	[_ in PositionAnchor]: PointLike;
};
export type PopupOptions = {
	closeButton?: boolean;
	closeOnClick?: boolean;
	closeOnMove?: boolean;
	focusAfterOpen?: boolean;
	anchor?: PositionAnchor;
	offset?: Offset;
	className?: string;
	maxWidth?: string;
};
export declare class Popup extends Evented {
	_map: Map;
	options: PopupOptions;
	_content: HTMLElement;
	_container: HTMLElement;
	_closeButton: HTMLButtonElement;
	_tip: HTMLElement;
	_lngLat: LngLat;
	_trackPointer: boolean;
	_pos: Point;
	constructor(options?: PopupOptions);
	/**
	 * Adds the popup to a map.
	 *
	 * @param {Map} map The MapLibre GL JS map to add the popup to.
	 * @returns {Popup} `this`
	 * @example
	 * new maplibregl.Popup()
	 *   .setLngLat([0, 0])
	 *   .setHTML("<h1>Null Island</h1>")
	 *   .addTo(map);
	 * @see [Display a popup](https://maplibre.org/maplibre-gl-js-docs/example/popup/)
	 * @see [Display a popup on hover](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-hover/)
	 * @see [Display a popup on click](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-click/)
	 * @see [Show polygon information on click](https://maplibre.org/maplibre-gl-js-docs/example/polygon-popup-on-click/)
	 */
	addTo(map: Map): this;
	/**
	 * @returns {boolean} `true` if the popup is open, `false` if it is closed.
	 */
	isOpen(): boolean;
	/**
	 * Removes the popup from the map it has been added to.
	 *
	 * @example
	 * var popup = new maplibregl.Popup().addTo(map);
	 * popup.remove();
	 * @returns {Popup} `this`
	 */
	remove(): this;
	/**
	 * Returns the geographical location of the popup's anchor.
	 *
	 * The longitude of the result may differ by a multiple of 360 degrees from the longitude previously
	 * set by `setLngLat` because `Popup` wraps the anchor longitude across copies of the world to keep
	 * the popup on screen.
	 *
	 * @returns {LngLat} The geographical location of the popup's anchor.
	 */
	getLngLat(): LngLat;
	/**
	 * Sets the geographical location of the popup's anchor, and moves the popup to it. Replaces trackPointer() behavior.
	 *
	 * @param lnglat The geographical location to set as the popup's anchor.
	 * @returns {Popup} `this`
	 */
	setLngLat(lnglat: LngLatLike): this;
	/**
	 * Tracks the popup anchor to the cursor position on screens with a pointer device (it will be hidden on touchscreens). Replaces the `setLngLat` behavior.
	 * For most use cases, set `closeOnClick` and `closeButton` to `false`.
	 * @example
	 * var popup = new maplibregl.Popup({ closeOnClick: false, closeButton: false })
	 *   .setHTML("<h1>Hello World!</h1>")
	 *   .trackPointer()
	 *   .addTo(map);
	 * @returns {Popup} `this`
	 */
	trackPointer(): this;
	/**
	 * Returns the `Popup`'s HTML element.
	 * @example
	 * // Change the `Popup` element's font size
	 * var popup = new maplibregl.Popup()
	 *   .setLngLat([-96, 37.8])
	 *   .setHTML("<p>Hello World!</p>")
	 *   .addTo(map);
	 * var popupElem = popup.getElement();
	 * popupElem.style.fontSize = "25px";
	 * @returns {HTMLElement} element
	 */
	getElement(): HTMLElement;
	/**
	 * Sets the popup's content to a string of text.
	 *
	 * This function creates a [Text](https://developer.mozilla.org/en-US/docs/Web/API/Text) node in the DOM,
	 * so it cannot insert raw HTML. Use this method for security against XSS
	 * if the popup content is user-provided.
	 *
	 * @param text Textual content for the popup.
	 * @returns {Popup} `this`
	 * @example
	 * var popup = new maplibregl.Popup()
	 *   .setLngLat(e.lngLat)
	 *   .setText('Hello, world!')
	 *   .addTo(map);
	 */
	setText(text: string): this;
	/**
	 * Sets the popup's content to the HTML provided as a string.
	 *
	 * This method does not perform HTML filtering or sanitization, and must be
	 * used only with trusted content. Consider {@link Popup#setText} if
	 * the content is an untrusted text string.
	 *
	 * @param html A string representing HTML content for the popup.
	 * @returns {Popup} `this`
	 * @example
	 * var popup = new maplibregl.Popup()
	 *   .setLngLat(e.lngLat)
	 *   .setHTML("<h1>Hello World!</h1>")
	 *   .addTo(map);
	 * @see [Display a popup](https://maplibre.org/maplibre-gl-js-docs/example/popup/)
	 * @see [Display a popup on hover](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-hover/)
	 * @see [Display a popup on click](https://maplibre.org/maplibre-gl-js-docs/example/popup-on-click/)
	 * @see [Attach a popup to a marker instance](https://maplibre.org/maplibre-gl-js-docs/example/set-popup/)
	 */
	setHTML(html: string): this;
	/**
	 * Returns the popup's maximum width.
	 *
	 * @returns {string} The maximum width of the popup.
	 */
	getMaxWidth(): string;
	/**
	 * Sets the popup's maximum width. This is setting the CSS property `max-width`.
	 * Available values can be found here: https://developer.mozilla.org/en-US/docs/Web/CSS/max-width
	 *
	 * @param maxWidth A string representing the value for the maximum width.
	 * @returns {Popup} `this`
	 */
	setMaxWidth(maxWidth: string): this;
	/**
	 * Sets the popup's content to the element provided as a DOM node.
	 *
	 * @param htmlNode A DOM node to be used as content for the popup.
	 * @returns {Popup} `this`
	 * @example
	 * // create an element with the popup content
	 * var div = document.createElement('div');
	 * div.innerHTML = 'Hello, world!';
	 * var popup = new maplibregl.Popup()
	 *   .setLngLat(e.lngLat)
	 *   .setDOMContent(div)
	 *   .addTo(map);
	 */
	setDOMContent(htmlNode: Node): this;
	/**
	 * Adds a CSS class to the popup container element.
	 *
	 * @param {string} className Non-empty string with CSS class name to add to popup container
	 *
	 * @example
	 * let popup = new maplibregl.Popup()
	 * popup.addClassName('some-class')
	 */
	addClassName(className: string): void;
	/**
	 * Removes a CSS class from the popup container element.
	 *
	 * @param {string} className Non-empty string with CSS class name to remove from popup container
	 *
	 * @example
	 * let popup = new maplibregl.Popup()
	 * popup.removeClassName('some-class')
	 */
	removeClassName(className: string): void;
	/**
	 * Sets the popup's offset.
	 *
	 * @param offset Sets the popup's offset.
	 * @returns {Popup} `this`
	 */
	setOffset(offset?: Offset): this;
	/**
	 * Add or remove the given CSS class on the popup container, depending on whether the container currently has that class.
	 *
	 * @param {string} className Non-empty string with CSS class name to add/remove
	 *
	 * @returns {boolean} if the class was removed return false, if class was added, then return true
	 *
	 * @example
	 * let popup = new maplibregl.Popup()
	 * popup.toggleClassName('toggleClass')
	 */
	toggleClassName(className: string): boolean;
	_createCloseButton(): void;
	_onMouseUp(event: MapMouseEvent): void;
	_onMouseMove(event: MapMouseEvent): void;
	_onDrag(event: MapMouseEvent): void;
	_update(cursor?: Point): void;
	_focusFirstElement(): void;
	_onClose(): void;
}
export type MarkerOptions = {
	element?: HTMLElement;
	offset?: PointLike;
	anchor?: PositionAnchor;
	color?: string;
	scale?: number;
	draggable?: boolean;
	clickTolerance?: number;
	rotation?: number;
	rotationAlignment?: string;
	pitchAlignment?: string;
};
export declare class Marker extends Evented {
	_map: Map;
	_anchor: PositionAnchor;
	_offset: Point;
	_element: HTMLElement;
	_popup: Popup;
	_lngLat: LngLat;
	_pos: Point;
	_color: string;
	_scale: number;
	_defaultMarker: boolean;
	_draggable: boolean;
	_clickTolerance: number;
	_isDragging: boolean;
	_state: "inactive" | "pending" | "active";
	_positionDelta: Point;
	_pointerdownPos: Point;
	_rotation: number;
	_pitchAlignment: string;
	_rotationAlignment: string;
	_originalTabIndex: string;
	_opacityTimeout: ReturnType<typeof setTimeout>;
	constructor(options?: MarkerOptions, legacyOptions?: MarkerOptions);
	/**
	 * Attaches the `Marker` to a `Map` object.
	 * @param {Map} map The MapLibre GL JS map to add the marker to.
	 * @returns {Marker} `this`
	 * @example
	 * var marker = new maplibregl.Marker()
	 *   .setLngLat([30.5, 50.5])
	 *   .addTo(map); // add the marker to the map
	 */
	addTo(map: Map): this;
	/**
	 * Removes the marker from a map
	 * @example
	 * var marker = new maplibregl.Marker().addTo(map);
	 * marker.remove();
	 * @returns {Marker} `this`
	 */
	remove(): this;
	/**
	 * Get the marker's geographical location.
	 *
	 * The longitude of the result may differ by a multiple of 360 degrees from the longitude previously
	 * set by `setLngLat` because `Marker` wraps the anchor longitude across copies of the world to keep
	 * the marker on screen.
	 *
	 * @returns {LngLat} A {@link LngLat} describing the marker's location.
	 * @example
	 * // Store the marker's longitude and latitude coordinates in a variable
	 * var lngLat = marker.getLngLat();
	 * // Print the marker's longitude and latitude values in the console
	 * console.log('Longitude: ' + lngLat.lng + ', Latitude: ' + lngLat.lat )
	 * @see [Create a draggable Marker](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-marker/)
	 */
	getLngLat(): LngLat;
	/**
	 * Set the marker's geographical position and move it.
	 * @param {LngLat} lnglat A {@link LngLat} describing where the marker should be located.
	 * @returns {Marker} `this`
	 * @example
	 * // Create a new marker, set the longitude and latitude, and add it to the map
	 * new maplibregl.Marker()
	 *   .setLngLat([-65.017, -16.457])
	 *   .addTo(map);
	 * @see [Add custom icons with Markers](https://maplibre.org/maplibre-gl-js-docs/example/custom-marker-icons/)
	 * @see [Create a draggable Marker](https://maplibre.org/maplibre-gl-js-docs/example/drag-a-marker/)
	 */
	setLngLat(lnglat: LngLatLike): this;
	/**
	 * Returns the `Marker`'s HTML element.
	 * @returns {HTMLElement} element
	 */
	getElement(): HTMLElement;
	/**
	 * Binds a {@link Popup} to the {@link Marker}.
	 * @param popup An instance of the {@link Popup} class. If undefined or null, any popup
	 * set on this {@link Marker} instance is unset.
	 * @returns {Marker} `this`
	 * @example
	 * var marker = new maplibregl.Marker()
	 *  .setLngLat([0, 0])
	 *  .setPopup(new maplibregl.Popup().setHTML("<h1>Hello World!</h1>")) // add popup
	 *  .addTo(map);
	 * @see [Attach a popup to a marker instance](https://maplibre.org/maplibre-gl-js-docs/example/set-popup/)
	 */
	setPopup(popup?: Popup | null): this;
	_onKeyPress(e: KeyboardEvent): void;
	_onMapClick(e: MapMouseEvent): void;
	/**
	 * Returns the {@link Popup} instance that is bound to the {@link Marker}.
	 * @returns {Popup} popup
	 * @example
	 * var marker = new maplibregl.Marker()
	 *  .setLngLat([0, 0])
	 *  .setPopup(new maplibregl.Popup().setHTML("<h1>Hello World!</h1>"))
	 *  .addTo(map);
	 *
	 * console.log(marker.getPopup()); // return the popup instance
	 */
	getPopup(): Popup;
	/**
	 * Opens or closes the {@link Popup} instance that is bound to the {@link Marker}, depending on the current state of the {@link Popup}.
	 * @returns {Marker} `this`
	 * @example
	 * var marker = new maplibregl.Marker()
	 *  .setLngLat([0, 0])
	 *  .setPopup(new maplibregl.Popup().setHTML("<h1>Hello World!</h1>"))
	 *  .addTo(map);
	 *
	 * marker.togglePopup(); // toggle popup open or closed
	 */
	togglePopup(): this;
	_update(e?: {
		type: "move" | "moveend";
	}): void;
	/**
	 * Get the marker's offset.
	 * @returns {Point} The marker's screen coordinates in pixels.
	 */
	getOffset(): Point;
	/**
	 * Sets the offset of the marker
	 * @param {PointLike} offset The offset in pixels as a {@link PointLike} object to apply relative to the element's center. Negatives indicate left and up.
	 * @returns {Marker} `this`
	 */
	setOffset(offset: PointLike): this;
	_onMove(e: MapMouseEvent | MapTouchEvent): void;
	_onUp(): void;
	_addDragHandler(e: MapMouseEvent | MapTouchEvent): void;
	/**
	 * Sets the `draggable` property and functionality of the marker
	 * @param {boolean} [shouldBeDraggable=false] Turns drag functionality on/off
	 * @returns {Marker} `this`
	 */
	setDraggable(shouldBeDraggable: boolean): this;
	/**
	 * Returns true if the marker can be dragged
	 * @returns {boolean} True if the marker is draggable.
	 */
	isDraggable(): boolean;
	/**
	 * Sets the `rotation` property of the marker.
	 * @param {number} [rotation=0] The rotation angle of the marker (clockwise, in degrees), relative to its respective {@link Marker#setRotationAlignment} setting.
	 * @returns {Marker} `this`
	 */
	setRotation(rotation: number): this;
	/**
	 * Returns the current rotation angle of the marker (in degrees).
	 * @returns {number} The current rotation angle of the marker.
	 */
	getRotation(): number;
	/**
	 * Sets the `rotationAlignment` property of the marker.
	 * @param {string} [alignment='auto'] Sets the `rotationAlignment` property of the marker.
	 * @returns {Marker} `this`
	 */
	setRotationAlignment(alignment: string): this;
	/**
	 * Returns the current `rotationAlignment` property of the marker.
	 * @returns {string} The current rotational alignment of the marker.
	 */
	getRotationAlignment(): string;
	/**
	 * Sets the `pitchAlignment` property of the marker.
	 * @param {string} [alignment] Sets the `pitchAlignment` property of the marker. If alignment is 'auto', it will automatically match `rotationAlignment`.
	 * @returns {Marker} `this`
	 */
	setPitchAlignment(alignment: string): this;
	/**
	 * Returns the current `pitchAlignment` property of the marker.
	 * @returns {string} The current pitch alignment of the marker in degrees.
	 */
	getPitchAlignment(): string;
}
export type GeolocateOptions = {
	positionOptions?: PositionOptions;
	fitBoundsOptions?: FitBoundsOptions;
	trackUserLocation?: boolean;
	showAccuracyCircle?: boolean;
	showUserLocation?: boolean;
};
export declare class GeolocateControl extends Evented implements IControl {
	_map: Map;
	options: GeolocateOptions;
	_container: HTMLElement;
	_dotElement: HTMLElement;
	_circleElement: HTMLElement;
	_geolocateButton: HTMLButtonElement;
	_geolocationWatchID: number;
	_timeoutId: ReturnType<typeof setTimeout>;
	_watchState: "OFF" | "ACTIVE_LOCK" | "WAITING_ACTIVE" | "ACTIVE_ERROR" | "BACKGROUND" | "BACKGROUND_ERROR";
	_lastKnownPosition: any;
	_userLocationDotMarker: Marker;
	_accuracyCircleMarker: Marker;
	_accuracy: number;
	_setup: boolean;
	constructor(options: GeolocateOptions);
	onAdd(map: Map): HTMLElement;
	onRemove(): void;
	/**
	 * Check if the Geolocation API Position is outside the map's maxbounds.
	 *
	 * @param {Position} position the Geolocation API Position
	 * @returns {boolean} Returns `true` if position is outside the map's maxbounds, otherwise returns `false`.
	 * @private
	 */
	_isOutOfMapMaxBounds(position: GeolocationPosition): boolean;
	_setErrorState(): void;
	/**
	 * When the Geolocation API returns a new location, update the GeolocateControl.
	 *
	 * @param {Position} position the Geolocation API Position
	 * @private
	 */
	_onSuccess(position: GeolocationPosition): void;
	/**
	 * Update the camera location to center on the current position
	 *
	 * @param {Position} position the Geolocation API Position
	 * @private
	 */
	_updateCamera(position: GeolocationPosition): void;
	/**
	 * Update the user location dot Marker to the current position
	 *
	 * @param {Position} [position] the Geolocation API Position
	 * @private
	 */
	_updateMarker(position?: GeolocationPosition | null): void;
	_updateCircleRadius(): void;
	_onZoom(): void;
	_onError(error: GeolocationPositionError): void;
	_finish(): void;
	_setupUI(supported: boolean): void;
	/**
	 * Programmatically request and move the map to the user's location.
	 *
	 * @returns {boolean} Returns `false` if called before control was added to a map, otherwise returns `true`.
	 * @example
	 * // Initialize the geolocate control.
	 * var geolocate = new maplibregl.GeolocateControl({
	 *  positionOptions: {
	 *    enableHighAccuracy: true
	 *  },
	 *  trackUserLocation: true
	 * });
	 * // Add the control to the map.
	 * map.addControl(geolocate);
	 * map.on('load', function() {
	 *   geolocate.trigger();
	 * });
	 */
	trigger(): boolean;
	_clearWatch(): void;
}
export type AttributionOptions = {
	compact?: boolean;
	customAttribution?: string | Array<string>;
};
export declare class AttributionControl implements IControl {
	options: AttributionOptions;
	_map: Map;
	_compact: boolean;
	_container: HTMLElement;
	_innerContainer: HTMLElement;
	_compactButton: HTMLElement;
	_editLink: HTMLAnchorElement;
	_attribHTML: string;
	styleId: string;
	styleOwner: string;
	constructor(options?: AttributionOptions);
	getDefaultPosition(): ControlPosition;
	onAdd(map: Map): HTMLElement;
	onRemove(): void;
	_setElementTitle(element: HTMLElement, title: string): void;
	_toggleAttribution(): void;
	_updateData(e: any): void;
	_updateAttributions(): void;
	_updateCompact(): void;
	_updateCompactMinimize(): void;
}
export type LogoOptions = {
	compact?: boolean;
};
export declare class LogoControl implements IControl {
	options: LogoOptions;
	_map: Map;
	_compact: boolean;
	_container: HTMLElement;
	constructor(options?: LogoOptions);
	getDefaultPosition(): ControlPosition;
	onAdd(map: Map): HTMLElement;
	onRemove(): void;
	_updateCompact(): void;
}
export type Unit = "imperial" | "metric" | "nautical";
export type ScaleOptions = {
	maxWidth?: number;
	unit?: Unit;
};
export declare class ScaleControl implements IControl {
	_map: Map;
	_container: HTMLElement;
	options: ScaleOptions;
	constructor(options: ScaleOptions);
	getDefaultPosition(): ControlPosition;
	_onMove(): void;
	onAdd(map: Map): HTMLElement;
	onRemove(): void;
	/**
	 * Set the scale's unit of the distance
	 *
	 * @param unit Unit of the distance (`'imperial'`, `'metric'` or `'nautical'`).
	 */
	setUnit(unit: Unit): void;
}
export type FullscreenOptions = {
	container?: HTMLElement;
};
export declare class FullscreenControl extends Evented implements IControl {
	_map: Map;
	_controlContainer: HTMLElement;
	_fullscreen: boolean;
	_fullscreenchange: string;
	_fullscreenButton: HTMLButtonElement;
	_container: HTMLElement;
	_prevCooperativeGestures: boolean | GestureOptions;
	constructor(options?: FullscreenOptions);
	onAdd(map: Map): HTMLElement;
	onRemove(): void;
	_setupUI(): void;
	_updateTitle(): void;
	_getTitle(): any;
	_isFullscreen(): boolean;
	_onFullscreenChange: () => void;
	_handleFullscreenChange(): void;
	_onClickFullscreen: () => void;
	_exitFullscreen(): void;
	_requestFullscreen(): void;
	_togglePseudoFullScreen(): void;
}
export declare class TerrainControl implements IControl {
	options: TerrainSpecification;
	_map: Map;
	_container: HTMLElement;
	_terrainButton: HTMLButtonElement;
	constructor(options: TerrainSpecification);
	onAdd(map: Map): HTMLElement;
	onRemove(): void;
	_toggleTerrain(): void;
	_updateTerrainIcon(): void;
}
declare function prewarm(): void;
declare function clearPrewarmedResources(): void;
export declare class RasterDEMTileSource extends RasterTileSource implements Source {
	encoding: "mapbox" | "terrarium";
	constructor(id: string, options: RasterDEMSourceSpecification, dispatcher: Dispatcher, eventedParent: Evented);
	serialize(): {
		type: string;
		url: string;
		tileSize: number;
		tiles: string[];
		bounds: [
			number,
			number,
			number,
			number
		];
		encoding: "terrarium" | "mapbox";
	};
	loadTile(tile: Tile, callback: Callback<void>): void;
	_getNeighboringTiles(tileID: OverscaledTileID): {};
	unloadTile(tile: Tile): void;
}
export declare class VideoSource extends ImageSource {
	options: VideoSourceSpecification;
	urls: Array<string>;
	video: HTMLVideoElement;
	roundZoom: boolean;
	/**
	 * @private
	 */
	constructor(id: string, options: VideoSourceSpecification, dispatcher: Dispatcher, eventedParent: Evented);
	load(): void;
	/**
	 * Pauses the video.
	 */
	pause(): void;
	/**
	 * Plays the video.
	 */
	play(): void;
	/**
	 * Sets playback to a timestamp, in seconds.
	 * @private
	 */
	seek(seconds: number): void;
	/**
	 * Returns the HTML `video` element.
	 *
	 * @returns {HTMLVideoElement} The HTML `video` element.
	 */
	getVideo(): HTMLVideoElement;
	onAdd(map: Map): void;
	/**
	 * Sets the video's coordinates and re-renders the map.
	 *
	 * @method setCoordinates
	 * @instance
	 * @memberof VideoSource
	 * @returns {VideoSource} this
	 */
	prepare(): void;
	serialize(): {
		type: string;
		urls: string[];
		coordinates: Coordinates;
	};
	hasTransition(): boolean;
}
declare const exported: {
	setRTLTextPlugin: (url: string, callback: (error?: Error) => void, deferred?: boolean) => void;
	getRTLTextPluginStatus: () => string;
	Map: typeof Map;
	NavigationControl: typeof NavigationControl;
	GeolocateControl: typeof GeolocateControl;
	AttributionControl: typeof AttributionControl;
	LogoControl: typeof LogoControl;
	ScaleControl: typeof ScaleControl;
	FullscreenControl: typeof FullscreenControl;
	TerrainControl: typeof TerrainControl;
	Popup: typeof Popup;
	Marker: typeof Marker;
	Style: typeof Style;
	LngLat: typeof LngLat;
	LngLatBounds: typeof LngLatBounds;
	Point: typeof Point;
	MercatorCoordinate: typeof MercatorCoordinate;
	Evented: typeof Evented;
	AJAXError: typeof AJAXError;
	config: {
		MAX_PARALLEL_IMAGE_REQUESTS: number;
		MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME: number;
		MAX_TILE_CACHE_ZOOM_LEVELS: number;
		REGISTERED_PROTOCOLS: {
			[x: string]: (requestParameters: RequestParameters, callback: ResponseCallback<any>) => Cancelable;
		};
		WORKER_URL: string;
	};
	CanvasSource: typeof CanvasSource;
	GeoJSONSource: typeof GeoJSONSource;
	ImageSource: typeof ImageSource;
	RasterDEMTileSource: typeof RasterDEMTileSource;
	RasterTileSource: typeof RasterTileSource;
	VectorTileSource: typeof VectorTileSource;
	VideoSource: typeof VideoSource;
	/**
	 * Initializes resources like WebWorkers that can be shared across maps to lower load
	 * times in some situations. `maplibregl.workerUrl` and `maplibregl.workerCount`, if being
	 * used, must be set before `prewarm()` is called to have an effect.
	 *
	 * By default, the lifecycle of these resources is managed automatically, and they are
	 * lazily initialized when a Map is first created. By invoking `prewarm()`, these
	 * resources will be created ahead of time, and will not be cleared when the last Map
	 * is removed from the page. This allows them to be re-used by new Map instances that
	 * are created later. They can be manually cleared by calling
	 * `maplibregl.clearPrewarmedResources()`. This is only necessary if your web page remains
	 * active but stops using maps altogether.
	 *
	 * This is primarily useful when using GL-JS maps in a single page app, wherein a user
	 * would navigate between various views that can cause Map instances to constantly be
	 * created and destroyed.
	 *
	 * @function prewarm
	 * @example
	 * maplibregl.prewarm()
	 */
	prewarm: typeof prewarm;
	/**
	 * Clears up resources that have previously been created by `maplibregl.prewarm()`.
	 * Note that this is typically not necessary. You should only call this function
	 * if you expect the user of your app to not return to a Map view at any point
	 * in your application.
	 *
	 * @function clearPrewarmedResources
	 * @example
	 * maplibregl.clearPrewarmedResources()
	 */
	clearPrewarmedResources: typeof clearPrewarmedResources;
	/**
	 * Returns the package version of the library
	 * @returns {string} Package version of the library
	 */
	readonly version: string;
	/**
	 * Gets and sets the number of web workers instantiated on a page with GL JS maps.
	 * By default, workerCount is 1 except for Safari browser where it is set to half the number of CPU cores (capped at 3).
	 * Make sure to set this property before creating any map instances for it to have effect.
	 *
	 * @var {string} workerCount
	 * @returns {number} Number of workers currently configured.
	 * @example
	 * maplibregl.workerCount = 2;
	 */
	workerCount: number;
	/**
	 * Gets and sets the maximum number of images (raster tiles, sprites, icons) to load in parallel,
	 * which affects performance in raster-heavy maps. 16 by default.
	 *
	 * @var {string} maxParallelImageRequests
	 * @returns {number} Number of parallel requests currently configured.
	 * @example
	 * maplibregl.maxParallelImageRequests = 10;
	 */
	maxParallelImageRequests: number;
	workerUrl: string;
	/**
	 * Sets a custom load tile function that will be called when using a source that starts with a custom url schema.
	 * The example below will be triggered for custom:// urls defined in the sources list in the style definitions.
	 * The function passed will receive the request parameters and should call the callback with the resulting request,
	 * for example a pbf vector tile, non-compressed, represented as ArrayBuffer.
	 *
	 * @function addProtocol
	 * @param {string} customProtocol - the protocol to hook, for example 'custom'
	 * @param {Function} loadFn - the function to use when trying to fetch a tile specified by the customProtocol
	 * @example
	 * // this will fetch a file using the fetch API (this is obviously a non interesting example...)
	 * maplibregl.addProtocol('custom', (params, callback) => {
			fetch(`https://${params.url.split("://")[1]}`)
				.then(t => {
					if (t.status == 200) {
						t.arrayBuffer().then(arr => {
							callback(null, arr, null, null);
						});
					} else {
						callback(new Error(`Tile fetch error: ${t.statusText}`));
					}
				})
				.catch(e => {
					callback(new Error(e));
				});
			return { cancel: () => { } };
		});
	 * // the following is an example of a way to return an error when trying to load a tile
	 * maplibregl.addProtocol('custom2', (params, callback) => {
	 *      callback(new Error('someErrorMessage'));
	 *      return { cancel: () => { } };
	 * });
	 */
	addProtocol(customProtocol: string, loadFn: (requestParameters: RequestParameters, callback: ResponseCallback<any>) => Cancelable): void;
	/**
	 * Removes a previously added protocol
	 *
	 * @function removeProtocol
	 * @param {string} customProtocol - the custom protocol to remove registration for
	 * @example
	 * maplibregl.removeProtocol('custom');
	 */
	removeProtocol(customProtocol: string): void;
};
export type * from "@maplibre/maplibre-gl-style-spec";

export {
	exported as default,
};

export as namespace maplibregl;

export {};
