# MapLibre GL style specification & utilities

This repository contains code and reference files that define the MapLibre GL style specification and provides some utilities for working with MapLibre styles.

The style specification is used in MapLibre GL JS and in MapLibre GL Native. Our long-term goal is to have feature parity between the web and the native libraries.

## Contributing

If you want to contribute to the style specification, please open an issue with a design proposal. Once your design proposal has been accepted, you can open a pull request and implement your changes.

We aim to avoid breaking changes in the MapLibre style specification, because it makes life easier for our users.


## NPM Package

[![NPM Version](https://badge.fury.io/js/@maplibre%2Fmaplibre-gl-style-spec.svg)](https://npmjs.org/package/@maplibre/maplibre-gl-style-spec)

The MapLibre GL style specification and utilities are published as a seperate npm
package so that they can be installed without the bulk of GL JS.

    npm install @maplibre/maplibre-gl-style-spec

## CLI Tools

If you install this package globally, you will have access to several CLI tools.

    npm install @maplibre/maplibre-gl-style-spec --global

### `gl-style-migrate`

This repo contains scripts for migrating GL styles of any version to the latest version
(currently v8). Migrate a style like this:

```bash
$ gl-style-migrate bright-v7.json > bright-v8.json
```

To migrate a file in place, you can use the `sponge` utility from the `moreutils` package:

```bash
$ brew install moreutils
$ gl-style-migrate bright.json | sponge bright.json
```

### `gl-style-format`

```bash
$ gl-style-format style.json
```

Will format the given style JSON to use standard indentation and sorted object keys.

### `gl-style-validate`

```bash
$ gl-style-validate style.json
```

Will validate the given style JSON and print errors to stdout. Provide a
`--json` flag to get JSON output.
