/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.wifiservice;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.util.Log;
import com.whereabout.common.WifiDataStore;
import com.whereabout.common.WifiScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WifiLocalizer {
    private static final String TAG = "WifiLocalizer";
    protected static final int MAX_MATCHES = 20;
    protected static final int VOTING_SCAN_FREQ = 4;
    protected static final int MAX_VOTING_SAMPLES = 10;
    protected Context context = null;
    protected WifiScanner wifiScanner = null;
    protected WifiDataStore dataStore = null;
    protected SensorManager sensorManager = null;
    protected HashMap<String, Double> wifiStrengthTable = null;
    protected HashMap<String, Integer> wifiCountTable = null;
    protected int numScans = 0;
    protected String[] allMatchingLocations;
    protected double[] allMatchingProximities;
    protected int[] allXCoords;
    protected int[] allYCoords;
    protected double[] allLatitudes;
    protected double[] allLongitudes;
    protected int finalX;
    protected int finalY;
    protected double finalLat;
    protected double finalLon;
    protected boolean useVoting = false;
    protected boolean isVoting = false;
    protected int numSamplesForVoting = 0;
    protected ArrayList<String> matchingLocations = null;
    protected ArrayList<Double> matchingLocScores = null;
    protected ArrayList<Point> matchingLocCoords = null;
    protected ArrayList<Location> matchingLatlonCoords = null;
    protected ArrayList<String> finalMatchingLocations = null;
    protected ArrayList<Double> finalMatchingLocScores = null;
    protected ArrayList<Point> finalMatchingLocCoords = null;
    protected ArrayList<Location> finalMatchingLatlonCoords = null;
    protected ArrayList<HashMap<String, LocationInfo>> votingSamples = null;
    private Thread votingThread = null;
    private Thread continuousPositioningThread = null;
    private String expectedLocation;
    private boolean runPositioningLoop = false;
    private boolean locationUpdated = false;
    private boolean isDeviceMoving = false;
    private MotionSensorEventListener sensorEventListener = new MotionSensorEventListener();
    private Runnable continuousPositioningLoop = new Runnable(){

        public void run() {
            try {
                while (WifiLocalizer.this.runPositioningLoop) {
                    if (!WifiLocalizer.this.useVoting) {
                        if (WifiLocalizer.this.wifiScanner.isScanningWifi()) {
                            WifiLocalizer.this.stopScanningForLocation("");
                            if (!WifiLocalizer.this.isDeviceMoving) {
                                WifiLocalizer.this.addResultToVotingSamples();
                                WifiLocalizer.this.doVoting();
                            } else {
                                WifiLocalizer.this.votingSamples.clear();
                            }
                            WifiLocalizer.this.interpolateXY();
                            WifiLocalizer.this.interpolateLatLon();
                            WifiLocalizer.this.copyResultsToFinal();
                            WifiLocalizer.this.locationUpdated = true;
                        }
                        WifiLocalizer.this.startScan(4, false, 0);
                    }
                    Thread.sleep(1000L);
                }
                WifiLocalizer.this.stopScan();
            }
            catch (InterruptedException e) {
                Log.e((String)WifiLocalizer.TAG, (String)("Wifi localization interrupted: " + e.getMessage()));
            }
        }
    };
    private Runnable votingWifiLocalizer = new Runnable(){
        private ArrayList<HashMap<String, Double>> wifiStrengthTableHistory = new ArrayList();
        private ArrayList<HashMap<String, Integer>> wifiCountTableHistory = new ArrayList();
        private ArrayList<Integer> wifiNumScansHistory = new ArrayList();

        public void run() {
            int sampleCount = 0;
            WifiLocalizer.this.isVoting = true;
            this.wifiStrengthTableHistory.clear();
            this.wifiCountTableHistory.clear();
            this.wifiNumScansHistory.clear();
            WifiLocalizer.this.wifiScanner.waitWhileFlushing();
            while (WifiLocalizer.this.isVoting && (WifiLocalizer.this.numSamplesForVoting == 0 || sampleCount < WifiLocalizer.this.numSamplesForVoting)) {
                try {
                    WifiLocalizer.this.wifiScanner.startScan(4);
                    Thread.sleep(500L);
                    WifiLocalizer.this.stopScan();
                    this.wifiStrengthTableHistory.add(WifiLocalizer.this.wifiStrengthTable);
                    this.wifiCountTableHistory.add(WifiLocalizer.this.wifiCountTable);
                    this.wifiNumScansHistory.add(WifiLocalizer.this.numScans);
                }
                catch (InterruptedException ie) {
                    break;
                }
                ++sampleCount;
            }
            this.computeLocationForHistory();
            WifiLocalizer.this.isVoting = false;
            WifiLocalizer.this.doVoting();
            WifiLocalizer.this.interpolateXY();
            WifiLocalizer.this.interpolateLatLon();
            WifiLocalizer.this.copyResultsToFinal();
            WifiLocalizer.this.useVoting = false;
        }

        private void computeLocationForHistory() {
            int len = this.wifiStrengthTableHistory.size();
            int i = 0;
            while (i < len) {
                WifiLocalizer.this.wifiStrengthTable = this.wifiStrengthTableHistory.get(i);
                WifiLocalizer.this.wifiCountTable = this.wifiCountTableHistory.get(i);
                WifiLocalizer.this.numScans = this.wifiNumScansHistory.get(i);
                WifiLocalizer.this.computeLocation(WifiLocalizer.this.expectedLocation);
                WifiLocalizer.this.addResultToVotingSamples();
                ++i;
            }
        }
    };

    public WifiLocalizer(Context ct, WifiScanner scanner) {
        this.context = ct;
        this.wifiScanner = scanner;
        this.wifiStrengthTable = new HashMap();
        this.wifiCountTable = new HashMap();
        this.matchingLocations = new ArrayList();
        this.matchingLocScores = new ArrayList();
        this.matchingLocCoords = new ArrayList();
        this.matchingLatlonCoords = new ArrayList();
        this.finalMatchingLocations = new ArrayList();
        this.finalMatchingLocScores = new ArrayList();
        this.finalMatchingLocCoords = new ArrayList();
        this.finalMatchingLatlonCoords = new ArrayList();
        this.allMatchingLocations = new String[20];
        this.allMatchingProximities = new double[20];
        this.allXCoords = new int[20];
        this.allYCoords = new int[20];
        this.allLatitudes = new double[20];
        this.allLongitudes = new double[20];
        this.votingSamples = new ArrayList();
    }

    public void startScan(int freq, boolean voting, int samples) {
        if (this.useVoting) {
            return;
        }
        this.useVoting = voting;
        this.numSamplesForVoting = samples;
        if (this.useVoting) {
            this.votingSamples.clear();
            this.votingThread = new Thread(this.votingWifiLocalizer);
            this.votingThread.start();
        } else {
            this.wifiScanner.startScan(freq);
        }
    }

    public void stopScanningForLocation(String expectedLocation) {
        this.expectedLocation = expectedLocation;
        if (this.useVoting) {
            this.isVoting = false;
            this.useVoting = false;
            try {
                this.votingThread.join();
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        } else {
            this.stopScan();
            this.computeLocation(expectedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScan() {
        this.wifiScanner.stopScan();
        WifiScanner wifiScanner = this.wifiScanner;
        synchronized (wifiScanner) {
            this.wifiStrengthTable = this.wifiScanner.getWifiStrengthTable();
            this.wifiCountTable = this.wifiScanner.getWifiCountTable();
            this.numScans = this.wifiScanner.getNumScans();
        }
        Log.d((String)TAG, (String)"Stopped scanning for location");
    }

    public void computeLocation(String expectedLocation) {
        this.computeMatch(expectedLocation);
    }

    public String[] getLocations() {
        int i = 0;
        while (i < 20 && i < this.finalMatchingLocations.size()) {
            this.allMatchingLocations[i] = this.finalMatchingLocations.get(i);
            ++i;
        }
        return this.allMatchingLocations;
    }

    public double[] getProximities() {
        int i = 0;
        while (i < 20 && i < this.finalMatchingLocScores.size()) {
            this.allMatchingProximities[i] = this.finalMatchingLocScores.get(i);
            ++i;
        }
        return this.allMatchingProximities;
    }

    public int[] getXCoordinates() {
        int i = 0;
        while (i < 20 && i < this.finalMatchingLocCoords.size()) {
            this.allXCoords[i] = this.finalMatchingLocCoords.get((int)i).x;
            ++i;
        }
        return this.allXCoords;
    }

    public int[] getYCoordinates() {
        int i = 0;
        while (i < 20 && i < this.finalMatchingLocCoords.size()) {
            this.allYCoords[i] = this.finalMatchingLocCoords.get((int)i).y;
            ++i;
        }
        return this.allYCoords;
    }

    public double[] getLatitudes() {
        int i = 0;
        while (i < 20 && i < this.finalMatchingLatlonCoords.size()) {
            this.allLatitudes[i] = this.finalMatchingLatlonCoords.get(i).getLatitude();
            ++i;
        }
        return this.allLatitudes;
    }

    public double[] getLongitudes() {
        int i = 0;
        while (i < 20 && i < this.finalMatchingLocCoords.size()) {
            this.allLongitudes[i] = this.finalMatchingLatlonCoords.get(i).getLongitude();
            ++i;
        }
        return this.allLongitudes;
    }

    public int getX() {
        return this.finalX;
    }

    public int getY() {
        return this.finalY;
    }

    public double getLatitude() {
        return this.finalLat;
    }

    public double getLongitude() {
        return this.finalLon;
    }

    public void startContinuousPositioning(int wifiScanFrequency, long wifiScanInterval) {
        this.locationUpdated = false;
        this.runPositioningLoop = true;
        this.sensorManager = (SensorManager)this.context.getSystemService("sensor");
        this.sensorEventListener.reset();
        this.sensorManager.registerListener((SensorEventListener)this.sensorEventListener, this.sensorManager.getDefaultSensor(1), 3);
        if (this.continuousPositioningThread == null) {
            this.continuousPositioningThread = new Thread(this.continuousPositioningLoop);
            this.continuousPositioningThread.start();
        }
    }

    public void stopContinuousPositioning() {
        this.locationUpdated = false;
        this.runPositioningLoop = false;
        this.sensorManager.unregisterListener((SensorEventListener)this.sensorEventListener);
        this.continuousPositioningThread.interrupt();
        try {
            this.continuousPositioningThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isLocationUpdated() {
        boolean ret = this.locationUpdated;
        this.locationUpdated = false;
        return ret;
    }

    protected void insertMatchingLocation(double score, String location, String area, Point p, Location latlon) {
        int len = this.matchingLocations.size();
        int i = 0;
        if (this.isVoting) {
            i = len;
        } else {
            i = 0;
            while (i < len) {
                double sc = this.matchingLocScores.get(i);
                if (sc > score) break;
                ++i;
            }
        }
        this.matchingLocations.add(i, String.valueOf(area) + "_" + location);
        this.matchingLocScores.add(i, score);
        this.matchingLocCoords.add(i, p);
        this.matchingLatlonCoords.add(i, latlon);
    }

    protected void copyResultsToFinal() {
        this.finalMatchingLocations.clear();
        this.finalMatchingLocScores.clear();
        this.finalMatchingLocCoords.clear();
        this.finalMatchingLatlonCoords.clear();
        int len = this.matchingLocations.size();
        int i = 0;
        while (i < len) {
            this.finalMatchingLocations.add(this.matchingLocations.get(i));
            this.finalMatchingLocScores.add(this.matchingLocScores.get(i));
            this.finalMatchingLocCoords.add(this.matchingLocCoords.get(i));
            this.finalMatchingLatlonCoords.add(this.matchingLatlonCoords.get(i));
            ++i;
        }
    }

    protected abstract void computeMatch(String var1);

    protected abstract double compareScans(HashMap<String, Double> var1, HashMap<String, Double> var2);

    private void addResultToVotingSamples() {
        HashMap<String, LocationInfo> result = new HashMap<String, LocationInfo>();
        int i = 0;
        for (String location : this.matchingLocations) {
            LocationInfo info = new LocationInfo(location, this.matchingLocScores.get(i), this.matchingLocCoords.get(i), this.matchingLatlonCoords.get(i));
            result.put(location, info);
            ++i;
        }
        if (this.votingSamples.size() == 30) {
            this.votingSamples.remove(0);
        }
        this.votingSamples.add(result);
    }

    private void doVoting() {
        HashMap<String, Integer> locationSightings = new HashMap<String, Integer>();
        HashMap<String, Double> locationScores = new HashMap<String, Double>();
        HashMap<String, Point> locationXY = new HashMap<String, Point>();
        HashMap<String, Location> locationLatLon = new HashMap<String, Location>();
        int i = 0;
        for (HashMap<String, LocationInfo> sampleResult : this.votingSamples) {
            Set<String> locations = sampleResult.keySet();
            for (String loc : locations) {
                LocationInfo info = sampleResult.get(loc);
                if (!locationScores.containsKey(loc)) {
                    locationScores.put(loc, info.matchScore);
                    locationXY.put(loc, info.xy);
                    locationLatLon.put(loc, info.latlon);
                    locationSightings.put(loc, 1);
                } else {
                    locationScores.put(loc, (Double)locationScores.get(loc) + info.matchScore);
                    locationSightings.put(loc, (Integer)locationSightings.get(loc) + 1);
                }
                ++i;
            }
        }
        this.matchingLocations.clear();
        this.matchingLocScores.clear();
        this.matchingLocCoords.clear();
        this.matchingLatlonCoords.clear();
        Set locations = locationScores.keySet();
        i = 0;
        for (String loc : locations) {
            int index = loc.lastIndexOf(95);
            this.insertMatchingLocation((Double)locationScores.get(loc) / (double)((Integer)locationSightings.get(loc)).intValue(), loc.substring(index + 1), loc.substring(0, index), (Point)locationXY.get(loc), (Location)locationLatLon.get(loc));
            ++i;
        }
    }

    protected void interpolateXY() {
        if (this.matchingLocations.size() < 2) {
            return;
        }
        if (this.matchingLocCoords.get((int)0).x == -1 && this.matchingLocCoords.get((int)0).y == -1 || this.matchingLocCoords.get((int)1).x == -1 && this.matchingLocCoords.get((int)1).y == -1) {
            this.finalX = this.matchingLocCoords.get((int)0).x;
            this.finalY = this.matchingLocCoords.get((int)0).y;
            return;
        }
        double score0 = this.matchingLocScores.get(0);
        int x = this.matchingLocCoords.get((int)0).x;
        int y = this.matchingLocCoords.get((int)0).y;
        double mindist = 1000000.0;
        int minloc = 0;
        int i = 1;
        while (i < this.matchingLocations.size()) {
            int yi = this.matchingLocCoords.get((int)i).y;
            int xi = this.matchingLocCoords.get((int)i).x;
            double dist = Math.sqrt((y - yi) * (y - yi) + (x - xi) * (x - xi));
            if (dist < mindist) {
                mindist = dist;
                minloc = i;
            }
            ++i;
        }
        double score1 = this.matchingLocScores.get(minloc);
        double aff0 = score0 / (score0 + score1);
        double xdiff = this.matchingLocCoords.get((int)0).x - this.matchingLocCoords.get((int)minloc).x;
        double ydiff = this.matchingLocCoords.get((int)0).y - this.matchingLocCoords.get((int)minloc).y;
        this.finalX = (int)((double)this.matchingLocCoords.get((int)0).x - xdiff * aff0);
        this.finalY = (int)((double)this.matchingLocCoords.get((int)0).y - ydiff * aff0);
    }

    protected void interpolateLatLon() {
        if (this.matchingLocations.size() < 2) {
            return;
        }
        double lt0 = this.matchingLatlonCoords.get(0).getLatitude();
        double ln0 = this.matchingLatlonCoords.get(0).getLongitude();
        double mindist = 1000000.0;
        int minloc = 0;
        int i = 1;
        while (i < this.matchingLocations.size()) {
            double lti = this.matchingLatlonCoords.get(i).getLatitude();
            double lni = this.matchingLatlonCoords.get(i).getLongitude();
            double dist = Math.sqrt((lni - ln0) * (lni - ln0) + (lti - lt0) * (lti - lt0));
            if (dist < mindist) {
                mindist = dist;
                minloc = i;
            }
            ++i;
        }
        double lt = this.matchingLatlonCoords.get(minloc).getLatitude();
        double ln = this.matchingLatlonCoords.get(minloc).getLongitude();
        if (lt0 == 0.0 && ln0 == 0.0 || lt == 0.0 && ln == 0.0) {
            this.finalLat = lt0;
            this.finalLon = ln0;
            return;
        }
        double score0 = Math.max(15.0, this.matchingLocScores.get(0));
        double score1 = Math.max(15.0, this.matchingLocScores.get(1));
        double aff0 = score0 / (score0 + score1);
        double ltdiff = lt0 - lt;
        double lndiff = ln0 - ln;
        this.finalLat = lt0 - ltdiff * aff0;
        this.finalLon = ln0 - lndiff * aff0;
    }

    public void destroy() {
        this.runPositioningLoop = false;
        this.wifiScanner.stopScan();
        try {
            if (this.continuousPositioningThread != null) {
                this.continuousPositioningThread.interrupt();
                this.continuousPositioningThread.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.wifiStrengthTable = null;
        this.wifiCountTable = null;
        this.matchingLocations = null;
        this.matchingLocScores = null;
        this.matchingLocCoords = null;
        this.matchingLatlonCoords = null;
        this.finalMatchingLocations = null;
        this.finalMatchingLocScores = null;
        this.finalMatchingLocCoords = null;
        this.finalMatchingLatlonCoords = null;
        this.allMatchingLocations = null;
        this.allMatchingProximities = null;
        this.allXCoords = null;
        this.allYCoords = null;
        this.allLatitudes = null;
        this.allLongitudes = null;
        this.votingSamples = null;
    }

    public String testAccuracy(String testDir, String fileName) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        double numTP = 0.0;
        double numTN = 0.0;
        double numFP = 0.0;
        double numFN = 0.0;
        File opFile = new File(String.valueOf(testDir) + "/result.txt");
        File dir = new File(testDir);
        if (!dir.exists()) {
            return "";
        }
        double totalError = 0.0;
        int errorSamples = 0;
        double maxError = 0.0;
        File[] files = dir.listFiles();
        try {
            FileWriter writer = new FileWriter(opFile);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().startsWith(fileName) && !f.getName().equals("result.txt") && !f.isDirectory()) {
                    String expectedLocation = this.readWifiScanFromFile(f);
                    String[] toks = expectedLocation.split("_");
                    double expLat = Double.parseDouble(toks[toks.length - 1].split("~")[0]);
                    double expLon = Double.parseDouble(toks[toks.length - 1].split("~")[1]);
                    int expX = Integer.parseInt(toks[toks.length - 2].split("~")[0]);
                    int expY = Integer.parseInt(toks[toks.length - 2].split("~")[1]);
                    this.computeLocation(expectedLocation);
                    String[] res = new String[this.matchingLocations.size() * 2 + 1];
                    res[0] = expectedLocation;
                    int i = 0;
                    int j = 1;
                    Iterator<String> iterator = this.matchingLocations.iterator();
                    while (iterator.hasNext()) {
                        String l;
                        res[j] = l = iterator.next();
                        res[j + 1] = "" + this.matchingLocScores.get(i);
                        ++i;
                        j += 2;
                    }
                    result.add(res);
                    String str = "";
                    i = 0;
                    while (i < res.length) {
                        str = String.valueOf(str) + res[i] + (i == res.length - 1 ? "\n" : " ");
                        ++i;
                    }
                    writer.write(str);
                    if (res.length >= 2) {
                        Point p = this.matchingLocCoords.get(0);
                        Location loc = this.matchingLatlonCoords.get(0);
                        double err = Math.sqrt((expY - p.y) * (expY - p.y) + (expX - p.x) * (expX - p.x));
                        if (err > maxError) {
                            maxError = err;
                        }
                        totalError += err;
                        ++errorSamples;
                        if (expX == p.x && expY == p.y || expLat == loc.getLatitude() && expLon == loc.getLongitude()) {
                            numTP += 1.0;
                            numTN += (double)((res.length - 1) / 2 - 1);
                        } else {
                            numFP += 1.0;
                            numFN += 1.0;
                        }
                    }
                }
                ++n2;
            }
            double avgDistError = totalError / (double)errorSamples;
            double spe = numTN / (numTN + numFP);
            double sen = numTP / (numTP + numFN);
            writer.write("Specificity: " + spe + "\n");
            writer.write("Sensitivity: " + sen + "\n");
            writer.write("Avergae distance error: " + avgDistError + "\n");
            writer.write("Maximum distance error: " + maxError + "\n");
            writer.close();
            return String.valueOf(spe) + ":" + sen + ":" + avgDistError + ":" + maxError;
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)("Failed accuracy test: " + ioe.getMessage()));
            return "";
        }
    }

    private String readWifiScanFromFile(File file) {
        try {
            String line = "";
            int x = -1;
            int y = -1;
            double lat = 0.0;
            double lon = 0.0;
            double minFreq = 1.0;
            String locName = "unknown";
            String areaName = "unknown";
            String buildingName = "unknown";
            String floorName = "unknown";
            Document doc = null;
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                doc = db.parse(new FileInputStream(file));
                locName = doc.getElementsByTagName("loc").item(0).getFirstChild().getNodeValue();
                areaName = doc.getElementsByTagName("area").item(0).getFirstChild().getNodeValue();
                buildingName = doc.getElementsByTagName("building").item(0).getFirstChild().getNodeValue();
                floorName = doc.getElementsByTagName("floor").item(0).getFirstChild().getNodeValue();
                Node nodeXY = doc.getElementsByTagName("xy").item(0);
                x = Integer.parseInt(nodeXY.getChildNodes().item(0).getFirstChild().getNodeValue());
                y = Integer.parseInt(nodeXY.getChildNodes().item(1).getFirstChild().getNodeValue());
                Node nodeLatLon = doc.getElementsByTagName("latlon").item(0);
                lat = Double.parseDouble(nodeLatLon.getChildNodes().item(0).getFirstChild().getNodeValue());
                lon = Double.parseDouble(nodeLatLon.getChildNodes().item(1).getFirstChild().getNodeValue());
                NodeList scanNodes = doc.getElementsByTagName("ap");
                int i = 0;
                while (i < scanNodes.getLength()) {
                    String strengthStr = "";
                    String macStr = "";
                    NodeList children = scanNodes.item(i).getChildNodes();
                    int j = 0;
                    while (j < children.getLength()) {
                        Node node = children.item(j);
                        if (node.getNodeName().equals("mac")) {
                            macStr = node.getFirstChild().getNodeValue();
                        } else if (node.getNodeName().equals("strength")) {
                            strengthStr = node.getFirstChild().getNodeValue();
                        }
                        ++j;
                    }
                    this.wifiStrengthTable.put(macStr, Double.parseDouble(strengthStr));
                    this.wifiCountTable.put(macStr, 1);
                    ++i;
                }
                return String.valueOf(areaName) + "_" + buildingName + "_" + floorName + "_" + locName + "_" + x + "~" + y + "_" + lat + "~" + lon;
            }
            catch (IOException ioe) {
                Log.e((String)TAG, (String)("Failed parsing file: " + file.getName()));
                return null;
            }
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)("Failed to load file: " + file.getName()));
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            Log.d((String)TAG, (String)("Failed to load file: " + file.getName()));
            e.printStackTrace();
        }
        catch (NoSuchElementException e) {
            Log.d((String)TAG, (String)("Failed to load file: " + file.getName()));
            e.printStackTrace();
        }
        catch (SAXException e) {
            Log.d((String)TAG, (String)("Failed to load file: " + file.getName()));
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            Log.d((String)TAG, (String)("Failed to load file: " + file.getName()));
            e.printStackTrace();
        }
        return null;
    }

    private static class LocationInfo {
        public String locationName;
        public double matchScore;
        public Point xy;
        public Location latlon;

        public LocationInfo(String locationName, double matchScore, Point xy, Location latlon) {
            this.locationName = locationName;
            this.matchScore = matchScore;
            this.xy = xy;
            this.latlon = latlon;
        }
    }

    private class MotionSensorEventListener
    implements SensorEventListener {
        private static final int BUFFER_LEN = 20;
        private float[][] buffer = new float[3][20];
        private float[] var = new float[3];
        private int st = 0;
        private int en = 0;
        private long startMovingTime = 0L;
        private boolean startedMoving = false;

        private MotionSensorEventListener() {
        }

        private boolean checkMovement() {
            int cnt = 0;
            int i = 0;
            while (i < 3) {
                this.var[i] = 0.0f;
                ++i;
            }
            i = (this.st + 1) % 20;
            while (i != this.en) {
                int p = i - 1 < 0 ? 19 : i - 1;
                int k = 0;
                while (k < 3) {
                    int n = k;
                    this.var[n] = this.var[n] + Math.abs(this.buffer[k][i] - this.buffer[k][p]);
                    ++k;
                }
                i = (i + 1) % 20;
                ++cnt;
            }
            if (this.var[0] > 4.0f || this.var[1] > 4.0f || this.var[2] > 4.0f) {
                if (!this.startedMoving) {
                    this.startedMoving = true;
                    this.startMovingTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.startMovingTime > 1500L) {
                    return true;
                }
            } else {
                this.startedMoving = false;
            }
            return false;
        }

        public void reset() {
            this.st = 0;
            this.en = 0;
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                int i = 0;
                while (i < 3) {
                    this.buffer[i][this.en] = event.values[i];
                    ++i;
                }
                this.en = (this.en + 1) % 20;
                if (this.en == this.st) {
                    this.st = (this.st + 1) % 20;
                }
                WifiLocalizer.this.isDeviceMoving = this.checkMovement();
            }
        }
    }
}

