/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.wifiservice;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Environment;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import com.whereabout.common.LocalWifiDataStore;
import com.whereabout.common.WifiDataStore;
import com.whereabout.common.WifiScanner;
import com.whereabout.wifiservice.IWifiLocationService;
import com.whereabout.wifiservice.LocalWifiLocalizer;
import com.whereabout.wifiservice.WifiLocalizer;
import java.util.ArrayList;

public class WifiLocalizationService
extends Service {
    private static final String TAG = "WifiLocalizationService";
    private static final String ACTION = "android.intent.action.USE_WIFI_SERVICE";
    private static final String CATEGORY = "android.intent.category.WIFI_SERVICE";
    private static final String ROOT_DIR = Environment.getExternalStorageDirectory() + "/wifiscans";
    private static final String PREFS_WIFI_STORE = "com.google.android.wifiservice.PREFS_WIFI";
    private static final boolean FORCE_REFRESH = false;
    private WifiScanner wifiScanner = null;
    private WifiLocalizer wifiLocalizer = null;
    private WifiDataStore dataStore = null;
    private String rootDirectoryPath = null;
    private boolean isRefreshing = false;
    private String refreshUrl;
    private String[] refreshMaps;
    private Thread loadDataThread = null;
    private int serviceRefCount = 0;
    private Runnable refreshData = new Runnable(){

        public void run() {
            WifiLocalizationService.this.isRefreshing = true;
            String mapRegex = "[";
            String[] reloadMaps = new String[]{};
            ArrayList<String> reloadMapsList = new ArrayList<String>();
            ArrayList<Integer> reloadMapsVersion = new ArrayList<Integer>();
            int newVersion = 0;
            String versionCheckUrl = String.valueOf(WifiLocalizationService.this.refreshUrl.substring(0, WifiLocalizationService.this.refreshUrl.lastIndexOf(47) + 1)) + "getMapVersion";
            int i = 0;
            boolean count = false;
            while (i < WifiLocalizationService.this.refreshMaps.length) {
                newVersion = WifiLocalizationService.this.doRefresh(versionCheckUrl, WifiLocalizationService.this.refreshMaps[i]);
                if (newVersion > 0) {
                    reloadMapsList.add(WifiLocalizationService.this.refreshMaps[i]);
                    reloadMapsVersion.add(newVersion);
                }
                mapRegex = String.valueOf(mapRegex) + WifiLocalizationService.this.refreshMaps[i] + "|";
                ++i;
            }
            mapRegex = String.valueOf(mapRegex.substring(0, mapRegex.length() - 1)) + "].*";
            boolean[] success = new boolean[]{};
            Log.d((String)WifiLocalizationService.TAG, (String)("about to reload maps: " + reloadMapsList.toString()));
            if (reloadMapsList.size() > 0) {
                reloadMaps = new String[reloadMapsList.size()];
                reloadMapsList.toArray(reloadMaps);
                success = WifiLocalizationService.this.dataStore.refreshData(WifiLocalizationService.this.rootDirectoryPath, WifiLocalizationService.this.refreshUrl, reloadMaps);
            }
            WifiLocalizationService.this.dataStore.reload(WifiLocalizationService.this.rootDirectoryPath, mapRegex, null);
            boolean ret = true;
            int i2 = 0;
            while (i2 < reloadMaps.length) {
                if (success[i2]) {
                    SharedPreferences settings = WifiLocalizationService.this.getSharedPreferences(WifiLocalizationService.PREFS_WIFI_STORE, 0);
                    SharedPreferences.Editor editor = settings.edit();
                    editor.putInt(String.valueOf(versionCheckUrl) + ":" + reloadMaps[i2], ((Integer)reloadMapsVersion.get(i2)).intValue());
                    editor.commit();
                } else {
                    ret = false;
                }
                ++i2;
            }
            WifiLocalizationService.this.isRefreshing = false;
        }
    };
    private final IWifiLocationService.Stub mBinder = new IWifiLocationService.Stub(){

        public boolean setRoot(String root, final String map) {
            WifiLocalizationService.this.rootDirectoryPath = root;
            WifiLocalizationService.this.loadDataThread = new Thread(new Runnable(){

                public void run() {
                    this.flushWifiScans();
                    while (WifiLocalizationService.this.wifiScanner.isFlushing()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    WifiLocalizationService.this.wifiScanner.setScanTime(1000L);
                    WifiLocalizationService.this.wifiScanner.startScan(4);
                    while (WifiLocalizationService.this.wifiScanner.isScanningWifi()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    WifiLocalizationService.this.dataStore.reload(WifiLocalizationService.this.rootDirectoryPath, map, WifiLocalizationService.this.wifiScanner.getCopyOfWifiStrengthTable());
                    WifiLocalizationService.this.dataStore.reload(WifiLocalizationService.this.rootDirectoryPath, map, null);
                }
            });
            WifiLocalizationService.this.loadDataThread.start();
            return true;
        }

        public boolean isRefreshingData() {
            return WifiLocalizationService.this.isRefreshing;
        }

        public boolean refreshData(String url, String[] maps, String root, boolean async) {
            WifiLocalizationService.this.refreshUrl = url;
            WifiLocalizationService.this.refreshMaps = maps;
            WifiLocalizationService.this.rootDirectoryPath = root;
            if (async) {
                new Thread(WifiLocalizationService.this.refreshData).start();
            } else {
                Looper looper = Looper.myLooper();
                if (looper != null && looper.equals(WifiLocalizationService.this.getMainLooper())) {
                    Log.w((String)WifiLocalizationService.TAG, (String)"REFRESHING DATA FROM MAIN THREAD!!");
                }
                WifiLocalizationService.this.refreshData.run();
            }
            return true;
        }

        public boolean isReady() {
            return WifiLocalizationService.this.dataStore.doneReloading();
        }

        public boolean isScanningWifi() {
            return WifiLocalizationService.this.wifiScanner.isScanningWifi();
        }

        public void startScanningForLocation(int freq, boolean voting, int samples) {
            WifiLocalizationService.this.wifiLocalizer.startScan(freq, voting, samples);
        }

        public void stopScanningForLocation(String expectedLocation) {
            WifiLocalizationService.this.wifiLocalizer.stopScanningForLocation(expectedLocation);
        }

        public void startContinuousPositioning(int wifiScanFrequency, long wifiScanInterval) {
            WifiLocalizationService wifiLocalizationService = WifiLocalizationService.this;
            wifiLocalizationService.serviceRefCount = wifiLocalizationService.serviceRefCount + 1;
            WifiLocalizationService.this.wifiLocalizer.startContinuousPositioning(wifiScanFrequency, wifiScanInterval);
        }

        public void stopContinuousPositioning() {
            WifiLocalizationService wifiLocalizationService = WifiLocalizationService.this;
            int n = wifiLocalizationService.serviceRefCount - 1;
            wifiLocalizationService.serviceRefCount = n;
            if (n == 0) {
                WifiLocalizationService.this.wifiLocalizer.stopContinuousPositioning();
            }
        }

        public String[] getAllLocationsByPrefix(String map, String prefix) {
            return WifiLocalizationService.this.dataStore.getAllLocationsByPrefix(map, prefix);
        }

        public String getXYForLocation(String map, String loc) {
            return WifiLocalizationService.this.dataStore.getXYForLocation(map, loc);
        }

        public String getLatLonForLocation(String map, String loc) {
            return WifiLocalizationService.this.dataStore.getLatLonForLocation(map, loc);
        }

        public String[] getLocations() {
            return WifiLocalizationService.this.wifiLocalizer.getLocations();
        }

        public double[] getProximities() {
            return WifiLocalizationService.this.wifiLocalizer.getProximities();
        }

        public int[] getXCoordinates() {
            return WifiLocalizationService.this.wifiLocalizer.getXCoordinates();
        }

        public int[] getYCoordinates() {
            return WifiLocalizationService.this.wifiLocalizer.getYCoordinates();
        }

        public double[] getLatitudes() {
            return WifiLocalizationService.this.wifiLocalizer.getLatitudes();
        }

        public double[] getLongitudes() {
            return WifiLocalizationService.this.wifiLocalizer.getLongitudes();
        }

        public int getX() {
            return WifiLocalizationService.this.wifiLocalizer.getX();
        }

        public int getY() {
            return WifiLocalizationService.this.wifiLocalizer.getY();
        }

        public double getLatitude() {
            return WifiLocalizationService.this.wifiLocalizer.getLatitude();
        }

        public double getLongitude() {
            return WifiLocalizationService.this.wifiLocalizer.getLongitude();
        }

        public void flushWifiScans() {
            WifiLocalizationService.this.wifiScanner.flushWifiScans();
        }

        public boolean isFlushing() {
            return WifiLocalizationService.this.wifiScanner.isFlushing();
        }

        public boolean isLocationUpdated() {
            return true;
        }

        public String testAccuracy(String testDir, String file) {
            return WifiLocalizationService.this.wifiLocalizer.testAccuracy(testDir, file);
        }
    };

    private int doRefresh(String url, String map) {
        SharedPreferences settings = this.getSharedPreferences(PREFS_WIFI_STORE, 0);
        int newVersion = 0;
        try {
            newVersion = Integer.parseInt(this.dataStore.getWifiDataVersion(url, map));
        }
        catch (NumberFormatException nfe) {
            Log.w((String)TAG, (String)("Invalid Version number for map: " + map));
            return 0;
        }
        int version = settings.getInt(String.valueOf(url) + ":" + map, 0);
        Log.d((String)TAG, (String)("for " + map + ": local version=" + version + ", remote=" + newVersion));
        return newVersion > version ? newVersion : 0;
    }

    public void onCreate() {
        super.onCreate();
        this.serviceRefCount = 0;
        this.dataStore = new LocalWifiDataStore(ROOT_DIR);
        this.wifiScanner = new WifiScanner((Context)this, this.dataStore);
        this.wifiLocalizer = new LocalWifiLocalizer((Context)this, this.wifiScanner);
    }

    public void onDestroy() {
        this.dataStore.stopReload();
        try {
            this.loadDataThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.dataStore.destroy();
        this.wifiScanner.destroy();
        this.wifiLocalizer.destroy();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        if (ACTION.equals(intent.getAction())) {
            for (String category : intent.getCategories()) {
                if (!category.equals(CATEGORY)) continue;
                return this.mBinder;
            }
        }
        return null;
    }
}

