/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.wifiservice;

import android.content.Context;
import android.util.Log;
import com.whereabout.common.WifiScanner;
import com.whereabout.wifiservice.WifiLocalizer;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWifiLocalizer
extends WifiLocalizer {
    public RemoteWifiLocalizer(Context ct, WifiScanner scanner) {
        super(ct, scanner);
    }

    @Override
    protected void computeMatch(String expectedLocation) {
        try {
            String matchLocationName = this.getMatchFromServer();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private String getMatchFromServer() throws Exception {
        Log.e((String)"DEBUG SERVER MATCH", (String)"NOW SERVER MATCH");
        String urlString = "http://whereaboutserver.appspot.com/searchLocation";
        String wifi = this.getWifiStringFromTables();
        Log.e((String)"DEBUG SERVER MATCH", (String)("wifi = " + wifi));
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            Log.e((String)"my debug", (String)"got client");
            HttpPost httppost = new HttpPost(urlString);
            Log.e((String)"DEBUG SERVER MATCH", (String)"got httppost");
            NameValuePair[] params = new NameValuePair[1];
            Log.e((String)"DEBUG SERVER MATCH", (String)"created params");
            params[0] = new BasicNameValuePair("wifi", wifi);
            Log.e((String)"DEBUG SERVER MATCH", (String)"set wifi");
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(params)));
            Log.e((String)"DEBUG SERVER MATCH", (String)"set params as entity");
            HttpResponse response = client.execute((HttpUriRequest)httppost);
            Log.e((String)"POST RESPONSE ============>", (String)"");
            String respStr = this.extractResponse(response);
            String respSub = respStr.substring(respStr.indexOf("Best Match Location"));
            Log.e((String)"RESPONSE SUBSTRING = ", (String)respSub);
            String serverMatchLocation = respSub.substring(respSub.indexOf(":"), respSub.indexOf("<BR>"));
            Log.e((String)"SERVER MATCH LOCATION = ", (String)serverMatchLocation);
            return serverMatchLocation;
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private String getWifiStringFromTables() {
        Set keys = this.wifiStrengthTable.keySet();
        String result = "";
        for (String key : keys) {
            String line = String.valueOf(key) + " " + this.wifiStrengthTable.get(key) + " " + this.wifiCountTable.get(key) + "\n";
            result = String.valueOf(result) + line;
        }
        return result;
    }

    private String extractResponse(HttpResponse response) throws IOException {
        String responseStr = null;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream instream = entity.getContent();
            byte[] tmp = new byte[20480];
            int bytesRead = instream.read(tmp);
            Log.e((String)"DEBUG SERVER MATCH Bytes read = ", (String)String.valueOf(bytesRead));
            responseStr = new String(tmp);
            Log.e((String)"DEBUG SERVER MATCH Response = ", (String)responseStr);
        }
        return responseStr;
    }

    @Override
    protected double compareScans(HashMap<String, Double> expected, HashMap<String, Double> actual) {
        return 0.0;
    }
}

