/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.wifiservice;

import android.content.Context;
import com.whereabout.common.WifiDataStore;
import com.whereabout.common.WifiScanner;
import com.whereabout.wifiservice.WifiLocalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWifiLocalizer
extends WifiLocalizer {
    protected String locationCurrentlyMatchingWith = "";

    public LocalWifiLocalizer(Context ct, WifiScanner scanner) {
        super(ct, scanner);
        this.dataStore = scanner.getDataStore();
    }

    @Override
    protected double compareScans(HashMap<String, Double> expected, HashMap<String, Double> actual) {
        double matchScore = 0.0;
        int totalCount = 0;
        int numMatchingKeys = 0;
        for (String key : actual.keySet()) {
            double v1 = actual.get(key);
            if (!expected.containsKey(key)) continue;
            if (expected.get(key) > -100.0) {
                double v2 = expected.get(key);
                matchScore += (v1 - v2) * (v1 - v2);
                ++totalCount;
            }
            if (!(expected.get(key) > -85.0)) continue;
            ++numMatchingKeys;
        }
        if (matchScore > 0.0) {
            int strongExpectedPoints = 0;
            int strongUnexpectedPoints = 0;
            for (String key : expected.keySet()) {
                if (!actual.containsKey(key) && expected.get(key) > -75.0) {
                    matchScore += (expected.get(key) + 100.0) * (expected.get(key) + 100.0);
                    ++totalCount;
                }
                if (!(expected.get(key) > -85.0)) continue;
                ++strongExpectedPoints;
            }
            for (String key : actual.keySet()) {
                if (expected.containsKey(key) || !(actual.get(key) > -75.0) || !this.dataStore.allMacAddresses.contains(key)) continue;
                ++strongUnexpectedPoints;
            }
            if ((double)numMatchingKeys / (double)(strongExpectedPoints + strongUnexpectedPoints) < 0.25) {
                matchScore = 100000.0;
            } else {
                for (String key : actual.keySet()) {
                    double v1 = actual.get(key);
                    if (expected.containsKey(key) || !(v1 > -75.0) || !this.dataStore.allMacAddresses.contains(key)) continue;
                    matchScore += (v1 + 100.0) * (v1 + 100.0);
                    ++totalCount;
                }
                matchScore = Math.sqrt(matchScore) * ((double)(strongExpectedPoints + strongUnexpectedPoints) / (double)numMatchingKeys);
            }
        } else {
            matchScore = 100000.0;
        }
        if (matchScore != 100000.0) {
            matchScore /= (double)totalCount;
        }
        return matchScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void computeMatch(String expectedLocation) {
        WifiDataStore wifiDataStore = this.dataStore;
        synchronized (wifiDataStore) {
            WifiScanner wifiScanner = this.wifiScanner;
            synchronized (wifiScanner) {
                HashSet<String> validLocations = new HashSet<String>();
                int bestMatchMap = -1;
                this.matchingLocations.clear();
                this.matchingLocScores.clear();
                this.matchingLocCoords.clear();
                this.matchingLatlonCoords.clear();
                for (String addr : this.wifiStrengthTable.keySet()) {
                    Set<String> addrs;
                    double strength = (Double)this.wifiStrengthTable.get(addr) / (double)((Integer)this.wifiCountTable.get(addr)).intValue();
                    if (strength > -75.0 && (addrs = this.dataStore.wifiMacAddrToLocationMap.get(addr)) != null) {
                        validLocations.addAll(addrs);
                    }
                    this.wifiStrengthTable.put(addr, strength);
                    this.wifiCountTable.put(addr, 1);
                }
                int i = 0;
                while (i < this.dataStore.wifiStrengthMaps.size()) {
                    if (validLocations.contains(String.valueOf(this.dataStore.areaNames.get(i)) + "_" + this.dataStore.locationNames.get(i))) {
                        this.locationCurrentlyMatchingWith = this.dataStore.locationNames.get(i);
                        HashMap<String, Double> mapTable = this.dataStore.wifiStrengthMaps.get(i);
                        double matchScore = this.compareScans(mapTable, this.wifiStrengthTable);
                        if (matchScore < 100000.0) {
                            this.insertMatchingLocation(matchScore, this.dataStore.locationNames.get(i), this.dataStore.areaNames.get(i), this.dataStore.locationCoords.get(i), this.dataStore.latlonCoords.get(i));
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

