/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.wifiservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiLocationService
extends IInterface {
    public boolean setRoot(String var1, String var2) throws RemoteException;

    public boolean isRefreshingData() throws RemoteException;

    public boolean refreshData(String var1, String[] var2, String var3, boolean var4) throws RemoteException;

    public boolean isReady() throws RemoteException;

    public boolean isScanningWifi() throws RemoteException;

    public void startScanningForLocation(int var1, boolean var2, int var3) throws RemoteException;

    public void stopScanningForLocation(String var1) throws RemoteException;

    public void startContinuousPositioning(int var1, long var2) throws RemoteException;

    public void stopContinuousPositioning() throws RemoteException;

    public String[] getAllLocationsByPrefix(String var1, String var2) throws RemoteException;

    public String getXYForLocation(String var1, String var2) throws RemoteException;

    public String getLatLonForLocation(String var1, String var2) throws RemoteException;

    public String[] getLocations() throws RemoteException;

    public double[] getProximities() throws RemoteException;

    public int[] getXCoordinates() throws RemoteException;

    public int[] getYCoordinates() throws RemoteException;

    public double[] getLatitudes() throws RemoteException;

    public double[] getLongitudes() throws RemoteException;

    public int getX() throws RemoteException;

    public int getY() throws RemoteException;

    public double getLatitude() throws RemoteException;

    public double getLongitude() throws RemoteException;

    public void flushWifiScans() throws RemoteException;

    public boolean isFlushing() throws RemoteException;

    public boolean isLocationUpdated() throws RemoteException;

    public String testAccuracy(String var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiLocationService {
        private static final String DESCRIPTOR = "com.whereabout.wifiservice.IWifiLocationService";
        static final int TRANSACTION_setRoot = 1;
        static final int TRANSACTION_isRefreshingData = 2;
        static final int TRANSACTION_refreshData = 3;
        static final int TRANSACTION_isReady = 4;
        static final int TRANSACTION_isScanningWifi = 5;
        static final int TRANSACTION_startScanningForLocation = 6;
        static final int TRANSACTION_stopScanningForLocation = 7;
        static final int TRANSACTION_startContinuousPositioning = 8;
        static final int TRANSACTION_stopContinuousPositioning = 9;
        static final int TRANSACTION_getAllLocationsByPrefix = 10;
        static final int TRANSACTION_getXYForLocation = 11;
        static final int TRANSACTION_getLatLonForLocation = 12;
        static final int TRANSACTION_getLocations = 13;
        static final int TRANSACTION_getProximities = 14;
        static final int TRANSACTION_getXCoordinates = 15;
        static final int TRANSACTION_getYCoordinates = 16;
        static final int TRANSACTION_getLatitudes = 17;
        static final int TRANSACTION_getLongitudes = 18;
        static final int TRANSACTION_getX = 19;
        static final int TRANSACTION_getY = 20;
        static final int TRANSACTION_getLatitude = 21;
        static final int TRANSACTION_getLongitude = 22;
        static final int TRANSACTION_flushWifiScans = 23;
        static final int TRANSACTION_isFlushing = 24;
        static final int TRANSACTION_isLocationUpdated = 25;
        static final int TRANSACTION_testAccuracy = 26;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiLocationService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiLocationService) {
                return (IWifiLocationService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.setRoot(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isRefreshingData();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String[] _arg1 = data.createStringArray();
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readInt() != 0;
                    boolean _result = this.refreshData(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isReady();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isScanningWifi();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readInt() != 0;
                    int _arg2 = data.readInt();
                    this.startScanningForLocation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.stopScanningForLocation(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    this.startContinuousPositioning(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopContinuousPositioning();
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String[] _result = this.getAllLocationsByPrefix(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _result = this.getXYForLocation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _result = this.getLatLonForLocation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    String[] _result = this.getLocations();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    double[] _result = this.getProximities();
                    reply.writeNoException();
                    reply.writeDoubleArray(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    int[] _result = this.getXCoordinates();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    int[] _result = this.getYCoordinates();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    double[] _result = this.getLatitudes();
                    reply.writeNoException();
                    reply.writeDoubleArray(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    double[] _result = this.getLongitudes();
                    reply.writeNoException();
                    reply.writeDoubleArray(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getX();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getY();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    double _result = this.getLatitude();
                    reply.writeNoException();
                    reply.writeDouble(_result);
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    double _result = this.getLongitude();
                    reply.writeNoException();
                    reply.writeDouble(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    this.flushWifiScans();
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isFlushing();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isLocationUpdated();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _result = this.testAccuracy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IWifiLocationService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            public boolean setRoot(String root, String area) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(root);
                    _data.writeString(area);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public boolean isRefreshingData() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public boolean refreshData(String url, String[] maps, String root, boolean async) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(url);
                    _data.writeStringArray(maps);
                    _data.writeString(root);
                    _data.writeInt(async ? 1 : 0);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public boolean isReady() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public boolean isScanningWifi() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public void startScanningForLocation(int freq, boolean voting, int samples) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(freq);
                    _data.writeInt(voting ? 1 : 0);
                    _data.writeInt(samples);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            public void stopScanningForLocation(String expectedLocation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(expectedLocation);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            public void startContinuousPositioning(int wifiScanFrequency, long wifiScanInterval) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(wifiScanFrequency);
                    _data.writeLong(wifiScanInterval);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            public void stopContinuousPositioning() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            public String[] getAllLocationsByPrefix(String area, String prefix) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(area);
                    _data.writeString(prefix);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public String getXYForLocation(String area, String loc) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(area);
                    _data.writeString(loc);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public String getLatLonForLocation(String area, String loc) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(area);
                    _data.writeString(loc);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public String[] getLocations() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public double[] getProximities() throws RemoteException {
                double[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createDoubleArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public int[] getXCoordinates() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public int[] getYCoordinates() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public double[] getLatitudes() throws RemoteException {
                double[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createDoubleArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public double[] getLongitudes() throws RemoteException {
                double[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createDoubleArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public int getX() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public int getY() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public double getLatitude() throws RemoteException {
                double _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readDouble();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public double getLongitude() throws RemoteException {
                double _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readDouble();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public void flushWifiScans() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            public boolean isFlushing() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public boolean isLocationUpdated() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt() != 0;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            public String testAccuracy(String testDir, String file) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(testDir);
                    _data.writeString(file);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

