/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.common;

import android.graphics.Point;
import android.location.Location;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import com.whereabout.common.MapInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PriorityQueue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final int BUFFER_SIZE = 1024;

    public static ArrayList<String> getMapNames(String dir) {
        ArrayList<String> maps = new ArrayList<String>();
        File f = new File(dir);
        if (f.exists() && f.isDirectory()) {
            File[] files = f.listFiles();
            boolean i = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                if (file.isFile() && fileName.endsWith(".map")) {
                    maps.add(fileName);
                }
                ++n2;
            }
        }
        return maps;
    }

    public static ArrayList<String> getLocationsForMap(String dir, String map) {
        ArrayList<String> locations = new ArrayList<String>();
        File f = new File(dir);
        if (f.exists() && f.isDirectory()) {
            File[] files = f.listFiles();
            boolean i = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                if (file.isFile() && !fileName.equals("temp.scan") && !fileName.endsWith(".index") && fileName.startsWith(map)) {
                    locations.add(fileName.substring(fileName.lastIndexOf(95) + 1));
                }
                ++n2;
            }
        }
        return locations;
    }

    public static ArrayList<String> getMapImageNames(String dir) {
        ArrayList<String> images = new ArrayList<String>();
        File f = new File(dir);
        if (f.exists() && f.isDirectory()) {
            File[] files = f.listFiles();
            boolean i = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                if (file.isFile() && (fileName.endsWith(".jpg") || fileName.endsWith(".JPG") || fileName.endsWith(".png") || fileName.endsWith(".PNG"))) {
                    images.add(fileName);
                }
                ++n2;
            }
        }
        return images;
    }

    public static ArrayList<String> getFutureLocationNames(String filePath) throws IOException {
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        ArrayList<String> locationNames = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(f), 1024);
        String line = "";
        while ((line = reader.readLine()) != null) {
            locationNames.add(line);
        }
        return locationNames;
    }

    public static MapInfo getMapInfo(String path) throws IOException {
        MapInfo info = new MapInfo();
        String imageFile = "";
        double latTop = 0.0;
        double lonLeft = 0.0;
        double latBottom = 0.0;
        double lonRight = 0.0;
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new FileInputStream(new File(path)));
            Node imageNode = doc.getElementsByTagName("image").item(0);
            imageFile = imageNode.getFirstChild().getNodeValue();
            latTop = Double.parseDouble(doc.getElementsByTagName("lat-top").item(0).getFirstChild().getNodeValue());
            lonLeft = Double.parseDouble(doc.getElementsByTagName("lon-left").item(0).getFirstChild().getNodeValue());
            latBottom = Double.parseDouble(doc.getElementsByTagName("lat-bottom").item(0).getFirstChild().getNodeValue());
            lonRight = Double.parseDouble(doc.getElementsByTagName("lon-right").item(0).getFirstChild().getNodeValue());
            info.setParams(imageFile, latTop, lonLeft, latBottom, lonRight);
            NodeList pointNodes = doc.getElementsByTagName("point");
            int i = 0;
            while (i < pointNodes.getLength()) {
                Node ptNode = pointNodes.item(i);
                NodeList children = ptNode.getChildNodes();
                String id2 = "";
                String name = "";
                int x = 0;
                int y = 0;
                double lat = 0.0;
                double lon = 0.0;
                int k = 0;
                while (k < children.getLength()) {
                    Node nd = children.item(k);
                    if (nd.getFirstChild() != null) {
                        String val = nd.getFirstChild().getNodeValue();
                        if (nd.getNodeName().equals("id")) {
                            id2 = val;
                        } else if (nd.getNodeName().equals("x")) {
                            x = Integer.parseInt(val);
                        } else if (nd.getNodeName().equals("y")) {
                            y = Integer.parseInt(val);
                        } else if (nd.getNodeName().equals("lat")) {
                            lat = Double.parseDouble(val);
                        } else if (nd.getNodeName().equals("lon")) {
                            lon = Double.parseDouble(val);
                        } else if (nd.getNodeName().equals("name")) {
                            name = val;
                        }
                    }
                    ++k;
                }
                Location loc = new Location("");
                loc.setLatitude(lat);
                loc.setLongitude(lon);
                Point p = new Point(x, y);
                info.allIds.add(id2);
                info.allPoints.add(p);
                info.allLatLon.add(loc);
                info.pointIdMap.put(id2, p);
                if (!name.equals("")) {
                    info.locNameIdMap.put(id2, name);
                }
                ++i;
            }
            NodeList connNodes = doc.getElementsByTagName("conn");
            int i2 = 0;
            while (i2 < connNodes.getLength()) {
                Node conn = connNodes.item(i2);
                String[] idStrs = conn.getFirstChild().getNodeValue().split(" ");
                int k = 1;
                while (k < idStrs.length) {
                    info.addConnection(idStrs[0], idStrs[k]);
                    ++k;
                }
                ++i2;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return info;
    }

    public static void populateSpinner(Spinner spinner, ArrayAdapter<String> adapter, String[] options) {
        adapter.clear();
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            adapter.add((Object)str);
            ++n2;
        }
        spinner.setAdapter(adapter);
    }

    public static Point getXYForWifiLocation(String dir, String area, String locName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(new File(String.valueOf(dir) + "/" + area + "_" + locName)), 1024);
        String line = "";
        Point p = null;
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split(" ");
            if (tokens == null || tokens.length != 3 || !tokens[0].equals("Pos:")) continue;
            p = new Point(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
            break;
        }
        reader.close();
        return p;
    }

    public static ArrayList<String> computePath(MapInfo mapInfo, int sx, int sy, int dx, int dy) {
        String source = Utils.getClosestPointId(mapInfo, sx, sy);
        String destination = Utils.getClosestPointId(mapInfo, dx, dy);
        ArrayList<Object> revpath = new ArrayList();
        ArrayList<String> path = new ArrayList<String>();
        HashSet done = new HashSet();
        revpath = Utils.dijkstras(mapInfo, source, destination);
        if (revpath != null && !revpath.isEmpty()) {
            revpath.add(source);
            int len = revpath.size();
            int i = len - 1;
            while (i >= 0) {
                path.add((String)revpath.get(i));
                --i;
            }
        }
        return path;
    }

    private static ArrayList<String> dijkstras(MapInfo mapInfo, String src, String dest) {
        double INF = 100000.0;
        String UNDEF = "UNDEF";
        final HashMap<String, Double> dist = new HashMap<String, Double>();
        HashMap<String, String> prev = new HashMap<String, String>();
        ArrayList<String> path = new ArrayList<String>();
        PriorityQueue<String> Q = new PriorityQueue<String>(mapInfo.connectivity.size(), new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                if ((Double)dist.get(str1) < (Double)dist.get(str2)) {
                    return 1;
                }
                if (dist.get(str1) == dist.get(str2)) {
                    return 0;
                }
                return -1;
            }
        });
        for (String vt : mapInfo.connectivity.keySet()) {
            dist.put(vt, 100000.0);
            prev.put(vt, "UNDEF");
        }
        dist.put(src, 0.0);
        for (String vt : mapInfo.connectivity.keySet()) {
            Q.add(vt);
        }
        while (!Q.isEmpty()) {
            String U = Utils.removeMin(Q, dist);
            if (dist.get(U) == 100000.0) break;
            Point p1 = mapInfo.pointIdMap.get(U);
            for (String V : mapInfo.connectivity.get(U)) {
                Point p2 = mapInfo.pointIdMap.get(V);
                double d = Math.sqrt((p2.y - p1.y) * (p2.y - p1.y) + (p2.x - p1.x) * (p2.x - p1.x));
                double alt = dist.get(U) + d;
                if (!(alt < dist.get(V))) continue;
                dist.put(V, alt);
                prev.put(V, U);
            }
        }
        String curr = dest;
        path.add(dest);
        while (true) {
            if (curr == null || dist.get(curr) == null) {
                return null;
            }
            if (curr.equals("UNDEF") || dist.get(curr) == 0.0) break;
            String pre = (String)prev.get(curr);
            path.add(pre);
            curr = pre;
        }
        return path;
    }

    private static String removeMin(PriorityQueue<String> Q, HashMap<String, Double> dist) {
        double minDist = 100000.0;
        String minKey = "";
        for (String key : Q) {
            if (!(dist.get(key) < minDist)) continue;
            minKey = key;
            minDist = dist.get(key);
        }
        Q.remove(minKey);
        return minKey;
    }

    private static String getClosestPointId(MapInfo mapInfo, int x, int y) {
        double minDist = 100000.0;
        int closest = 0;
        int i = 0;
        while (i < mapInfo.allPoints.size()) {
            Point p = mapInfo.allPoints.get(i);
            double dist = Math.sqrt((p.y - y) * (p.y - y) + (p.x - x) * (p.x - x));
            if (dist < 10.0) {
                closest = i;
                break;
            }
            if (dist < minDist) {
                minDist = dist;
                closest = i;
            }
            ++i;
        }
        return mapInfo.allIds.get(closest);
    }
}

