/*
 * Decompiled with CFR 0.152.
 */
package com.whereabout.common;

import android.graphics.Point;
import android.location.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class MapInfo {
    public String imageFile;
    public double latTop;
    public double lonLeft;
    public double latBottom;
    public double lonRight;
    public ArrayList<String> allIds = new ArrayList();
    public ArrayList<Point> allPoints = new ArrayList();
    public ArrayList<Location> allLatLon = new ArrayList();
    public HashMap<String, Point> pointIdMap = new HashMap();
    public HashMap<String, String> locNameIdMap = new HashMap();
    public HashMap<String, HashSet<String>> connectivity = new HashMap();

    public MapInfo() {
    }

    public MapInfo(String imageFile, double latTop, double lonLeft, double latBottom, double lonRight) {
        this.setParams(imageFile, latTop, lonLeft, latBottom, lonRight);
    }

    public void setParams(String imageFile, double latTop, double lonLeft, double latBottom, double lonRight) {
        this.imageFile = imageFile;
        this.latTop = latTop;
        this.lonLeft = lonLeft;
        this.latBottom = latBottom;
        this.lonRight = lonRight;
    }

    public void clear() {
        this.allPoints.clear();
        this.allIds.clear();
        this.allLatLon.clear();
        this.pointIdMap.clear();
        this.locNameIdMap.clear();
        this.connectivity.clear();
    }

    public void addPoint(String id2, Point point, Location location) {
        this.allIds.add(id2);
        this.allPoints.add(point);
        this.allLatLon.add(location);
        this.pointIdMap.put(id2, point);
    }

    public void removePoint(int index) {
        this.pointIdMap.remove(this.allIds.get(index));
        this.allIds.remove(index);
        this.allPoints.remove(index);
        this.allLatLon.remove(index);
    }

    public void createPoint(Point point, Location latlon) {
        String id2 = "0";
        if (this.allIds.size() > 0) {
            id2 = String.valueOf(Integer.parseInt(this.allIds.get(this.allIds.size() - 1)) + 1);
        }
        this.allIds.add(id2);
        this.allPoints.add(point);
        this.allLatLon.add(latlon);
        this.pointIdMap.put(id2, point);
    }

    public void addConnection(String pt1, String pt2) {
        if (this.pointIdMap.containsKey(pt1) && this.pointIdMap.containsKey(pt2)) {
            if (!this.connectivity.containsKey(pt1)) {
                this.connectivity.put(pt1, new HashSet());
            }
            this.connectivity.get(pt1).add(pt2);
            if (!this.connectivity.containsKey(pt2)) {
                this.connectivity.put(pt2, new HashSet());
            }
            this.connectivity.get(pt2).add(pt1);
        }
    }

    public void removeConnections(String pt1) {
        if (this.pointIdMap.containsKey(pt1) && this.connectivity.containsKey(pt1)) {
            HashSet<String> toIds = this.connectivity.get(pt1);
            for (String toId : toIds) {
                this.connectivity.get(toId).remove(pt1);
            }
            this.connectivity.remove(pt1);
        }
    }
}

