/*
 * Decompiled with CFR 0.152.
 */
package com.android.ocr.client;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;

public class VersionAlert {
    private static final String MARKET_URI = "market://search?q=pname:com.android.ocr";
    private static final String INSTALL = "This application requires the Mobile OCR library for text recognition.";
    private static final String INSTALL_TITLE = "Install OCR Library";
    private static final String INSTALL_POSITIVE = "Install";
    private static final String INSTALL_NEGATIVE = "Do not install";
    private static final String UPDATE = "This application requires a newer version of the Mobile OCR library.";
    private static final String UPDATE_TITLE = "Update OCR Library";
    private static final String UPDATE_POSITIVE = "Update";
    private static final String UPDATE_NEGATIVE = "Do not update";
    private static final String LANGUAGES = "Please install at least one Mobile OCR language pack.";
    private static final String LANGUAGES_TITLE = "Install OCR Languages";
    private static final String LANGUAGES_POSITIVE = "Select language";
    private static final String LANGUAGES_NEGATIVE = "Do not install";

    private VersionAlert() {
    }

    public static AlertDialog createInstallAlert(final Context context, DialogInterface.OnClickListener onNegative) {
        DialogInterface.OnClickListener onPositive = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Uri marketUri = Uri.parse((String)VersionAlert.MARKET_URI);
                Intent marketIntent = new Intent("android.intent.action.VIEW", marketUri);
                context.startActivity(marketIntent);
            }
        };
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage((CharSequence)INSTALL);
        builder.setTitle((CharSequence)INSTALL_TITLE);
        builder.setPositiveButton((CharSequence)INSTALL_POSITIVE, onPositive);
        builder.setNegativeButton((CharSequence)"Do not install", onNegative);
        return builder.create();
    }

    public static AlertDialog createUpdateAlert(final Context context, DialogInterface.OnClickListener onNegative) {
        DialogInterface.OnClickListener onPositive = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Uri marketUri = Uri.parse((String)VersionAlert.MARKET_URI);
                Intent marketIntent = new Intent("android.intent.action.VIEW", marketUri);
                context.startActivity(marketIntent);
            }
        };
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage((CharSequence)UPDATE);
        builder.setTitle((CharSequence)UPDATE_TITLE);
        builder.setPositiveButton((CharSequence)UPDATE_POSITIVE, onPositive);
        builder.setNegativeButton((CharSequence)UPDATE_NEGATIVE, onNegative);
        return builder.create();
    }

    public static AlertDialog createLanguagesAlert(final Activity context, final DialogInterface.OnClickListener onPositive, DialogInterface.OnClickListener onNegative, final int requestCode) {
        DialogInterface.OnClickListener onRealPositive = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent languagesIntent = new Intent("com.android.ocr.intent.LANGUAGES");
                if (requestCode > 0) {
                    context.startActivityForResult(languagesIntent, requestCode);
                } else {
                    context.startActivity(languagesIntent);
                }
                onPositive.onClick(dialog, which);
            }
        };
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        builder.setMessage((CharSequence)LANGUAGES);
        builder.setTitle((CharSequence)LANGUAGES_TITLE);
        builder.setPositiveButton((CharSequence)LANGUAGES_POSITIVE, onRealPositive);
        builder.setNegativeButton((CharSequence)"Do not install", onNegative);
        return builder.create();
    }
}

