/*
 * Decompiled with CFR 0.152.
 */
package com.android.ocr.client;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.ocr.client.Ocr;

public class StatusMonitor
extends Thread {
    private static final String TAG = "StatusMonitor";
    private static final int PROGRESS_MAX = 100;
    private Ocr mOcr;
    private Handler mHandler;
    private int mAction;
    private long mInterval;
    private boolean mAlive;

    public StatusMonitor(Ocr ocr, Handler handler, int action, long interval) {
        this.mOcr = ocr;
        this.mHandler = handler;
        this.mAction = action;
        this.mInterval = interval;
        this.mAlive = true;
    }

    @Override
    public void run() {
        Log.i((String)TAG, (String)"Running StatusMonitor...");
        int progress = 0;
        int previous = 0;
        while (this.mAlive) {
            Message msg;
            try {
                progress = this.mOcr.getProgress();
                if (progress < 0) {
                    this.mAlive = false;
                } else if (progress < 100 && progress != previous) {
                    previous = progress;
                    msg = this.mHandler.obtainMessage(this.mAction, progress, 100);
                    msg.sendToTarget();
                }
                Thread.sleep(this.mInterval);
            }
            catch (NullPointerException e) {
                this.mAlive = false;
                Log.e((String)TAG, (String)e.toString());
            }
            catch (InterruptedException e) {
                this.mAlive = false;
                Log.e((String)TAG, (String)e.toString());
            }
            if (this.mAlive || this.mHandler == null) continue;
            msg = this.mHandler.obtainMessage(this.mAction, -1, 0);
            msg.sendToTarget();
        }
    }

    public void release() {
        this.mAlive = false;
        this.mHandler = null;
    }
}

