/*
 * Decompiled with CFR 0.152.
 */
package com.android.ocr.client;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Config
implements Parcelable {
    private static final String TAG = "Config";
    public static final int STATE_BUSY = 0;
    public static final int STATE_COMPLETE = 1;
    public static final int STATUS_LOADING = 0;
    public static final int STATUS_PROCESSING = 1;
    public static final int STATUS_RECOGNIZING = 2;
    public static final int STATUS_COMPLETED = 3;
    public static final String VAR_CHAR_WHITELIST = "tessedit_char_whitelist";
    public static final String VAR_CHAR_BLACKLIST = "tessedit_char_blacklist";
    public static final String VAR_ACCURACYVSPEED = "tessedit_accuracyvspeed";
    public static final int AVS_FASTEST = 0;
    public static final int AVS_MOST_ACCURATE = 100;
    public static final int OPT_NORMALIZE_BG = 1;
    public static final int OPT_DETECT_TEXT = 2;
    public static final int OPT_ALIGN_TEXT = 4;
    public static final int OPT_DETECT_TEXT_ONLY = 8;
    public static final int PSM_AUTO = 0;
    public static final int PSM_SINGLE_COLUMN = 1;
    public static final int PSM_SINGLE_BLOCK = 2;
    public static final int PSM_SINGLE_LINE = 3;
    public static final int PSM_SINGLE_WORD = 4;
    public static final int PSM_SINGLE_CHAR = 5;
    public static final int PSM_NUM = 6;
    public static final int FORMAT_RAW = 0;
    public static final int FORMAT_JPEG = 1;
    public static final int FORMAT_PNG = 2;
    public static final int FORMAT_BMP = 3;
    public byte[] image;
    public int width;
    public int height;
    public int bpp;
    public int format;
    public long options;
    public ArrayList<Rect> bounds;
    public HashMap<String, String> variables;
    public String language;
    public int pageSegMode;
    public boolean debug;
    private static final String SD_CARD = "/sdcard/";
    private static final String OCR_PREFIX = "ocr_";
    private static final String OCR_SUFFIX = ".tmp";
    private static final int DISK_THRESHOLD = 1000000;
    public static final Parcelable.Creator<Config> CREATOR = new Parcelable.Creator<Config>(){

        public Config createFromParcel(Parcel in) {
            return new Config(in, null);
        }

        public Config[] newArray(int size) {
            return new Config[size];
        }
    };

    public Config() {
        this.image = new byte[0];
        this.bounds = new ArrayList();
        this.variables = new HashMap();
        this.language = null;
        this.pageSegMode = 0;
        this.debug = false;
    }

    private String writeToDisk() {
        Log.i((String)TAG, (String)"Image too big, writing to disk...");
        File sdcard = new File(SD_CARD);
        if (!sdcard.isDirectory()) {
            Log.e((String)TAG, (String)"Could not access SD card!");
            return null;
        }
        try {
            File temp = File.createTempFile(OCR_PREFIX, OCR_SUFFIX, sdcard);
            FileOutputStream stream = new FileOutputStream(temp);
            stream.write(this.image);
            stream.close();
            String file = temp.getAbsolutePath();
            Log.i((String)TAG, (String)("Wrote to disk: " + file));
            return file;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private boolean readFromDisk(String file) {
        Log.i((String)TAG, (String)("Image too big, reading from disk: " + file));
        if (file == null) {
            return false;
        }
        try {
            File temp = new File(file);
            FileInputStream stream = new FileInputStream(temp);
            this.image = new byte[(int)temp.length()];
            stream.read(this.image);
            stream.close();
            temp.delete();
            Log.i((String)TAG, (String)"Read from disk.");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private Config(Parcel src) {
        this.readFromParcel(src);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.image.length);
        if (this.image.length > 1000000) {
            String file = this.writeToDisk();
            dest.writeString(file);
        } else {
            dest.writeByteArray(this.image);
        }
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.bpp);
        dest.writeInt(this.format);
        dest.writeLong(this.options);
        dest.writeTypedList(this.bounds);
        dest.writeMap(this.variables);
        dest.writeString(this.language);
        dest.writeInt(this.pageSegMode);
        dest.writeByte((byte)(this.debug ? 1 : 0));
    }

    private void readFromParcel(Parcel src) {
        int length = src.readInt();
        if (length > 1000000) {
            String file = src.readString();
            this.readFromDisk(file);
        } else {
            this.image = src.createByteArray();
        }
        this.width = src.readInt();
        this.height = src.readInt();
        this.bpp = src.readInt();
        this.format = src.readInt();
        this.options = src.readLong();
        this.bounds = new ArrayList();
        src.readTypedList(this.bounds, Rect.CREATOR);
        this.variables = new HashMap();
        src.readMap(this.variables, HashMap.class.getClassLoader());
        this.language = src.readString();
        this.pageSegMode = src.readInt();
        this.debug = src.readByte() == 1;
    }

    /* synthetic */ Config(Parcel parcel, Config config) {
        this(parcel);
    }
}

