/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.serializer.xml;

import com.google.wireless.gdata2.client.GDataParserFactory;
import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.parser.ParseException;
import com.google.wireless.gdata2.parser.xml.XmlNametable;
import com.google.wireless.gdata2.parser.xml.XmlParserFactory;
import com.google.wireless.gdata2.serializer.GDataSerializer;
import com.google.wireless.gdata2.serializer.xml.XmlEntryGDataSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlBatchGDataSerializer
implements GDataSerializer {
    private final GDataParserFactory gdataFactory;
    private final XmlParserFactory xmlFactory;
    private final Enumeration batch;

    public XmlBatchGDataSerializer(GDataParserFactory gdataFactory, XmlParserFactory xmlFactory, Enumeration batch) {
        this.gdataFactory = gdataFactory;
        this.xmlFactory = xmlFactory;
        this.batch = batch;
    }

    public String getContentType() {
        return "application/atom+xml";
    }

    public boolean getSupportsPartial() {
        return false;
    }

    public void serialize(OutputStream out, int format) throws IOException, ParseException {
        XmlSerializer serializer;
        try {
            serializer = this.xmlFactory.createSerializer();
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Unable to create XmlSerializer.", e);
        }
        serializer.setOutput(out, XmlNametable.UTF8);
        serializer.startDocument(XmlNametable.UTF8, Boolean.FALSE);
        XmlBatchGDataSerializer.declareNamespaces(serializer);
        boolean first = true;
        while (this.batch.hasMoreElements()) {
            Entry entry = (Entry)this.batch.nextElement();
            XmlEntryGDataSerializer entrySerializer = (XmlEntryGDataSerializer)this.gdataFactory.createSerializer(entry);
            if (first) {
                first = false;
                serializer.startTag("http://www.w3.org/2005/Atom", XmlNametable.FEED);
                entrySerializer.declareExtraEntryNamespaces(serializer);
            }
            entrySerializer.serialize(out, 3);
        }
        if (first) {
            serializer.startTag("http://www.w3.org/2005/Atom", XmlNametable.FEED);
        }
        serializer.endTag("http://www.w3.org/2005/Atom", XmlNametable.FEED);
        serializer.endDocument();
        serializer.flush();
    }

    private static void declareNamespaces(XmlSerializer serializer) throws IOException {
        serializer.setPrefix("", "http://www.w3.org/2005/Atom");
        serializer.setPrefix("gd", "http://schemas.google.com/g/2005");
        serializer.setPrefix("batch", "http://schemas.google.com/gdata/batch");
    }
}

