/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.data;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static String extractChildText(XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType = parser.next();
        if (eventType != 4) {
            return null;
        }
        return parser.getText();
    }

    public static String extractFirstChildTextIgnoreRest(XmlPullParser parser) throws XmlPullParserException, IOException {
        int parentDepth = parser.getDepth();
        int eventType = parser.next();
        String child = null;
        while (eventType != 1) {
            int depth = parser.getDepth();
            if (eventType == 4) {
                if (child == null) {
                    child = parser.getText();
                }
            } else if (eventType == 3 && depth == parentDepth) {
                return child;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("End of document reached; never saw expected end tag at depth " + parentDepth);
    }

    public static String nextDirectChildTag(XmlPullParser parser, int parentDepth) throws XmlPullParserException, IOException {
        int targetDepth = parentDepth + 1;
        int eventType = parser.next();
        while (eventType != 1) {
            int depth = parser.getDepth();
            if (eventType == 2 && depth == targetDepth) {
                return parser.getName();
            }
            if (eventType == 3 && depth == parentDepth) {
                return null;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("End of document reached; never saw expected end tag at depth " + parentDepth);
    }

    public static boolean matchNameSpaceUri(XmlPullParser parser, String uri) {
        String elementNamespaceUri = parser.getNamespace();
        if (null == elementNamespaceUri) {
            return null == uri;
        }
        return elementNamespaceUri.equals(uri);
    }
}

