/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.contacts.data;

import com.google.wireless.gdata2.contacts.data.CalendarLink;
import com.google.wireless.gdata2.contacts.data.EmailAddress;
import com.google.wireless.gdata2.contacts.data.Event;
import com.google.wireless.gdata2.contacts.data.ExternalId;
import com.google.wireless.gdata2.contacts.data.GroupMembershipInfo;
import com.google.wireless.gdata2.contacts.data.ImAddress;
import com.google.wireless.gdata2.contacts.data.Jot;
import com.google.wireless.gdata2.contacts.data.Language;
import com.google.wireless.gdata2.contacts.data.Name;
import com.google.wireless.gdata2.contacts.data.Organization;
import com.google.wireless.gdata2.contacts.data.PhoneNumber;
import com.google.wireless.gdata2.contacts.data.Relation;
import com.google.wireless.gdata2.contacts.data.StructuredPostalAddress;
import com.google.wireless.gdata2.contacts.data.UserDefinedField;
import com.google.wireless.gdata2.contacts.data.WebSite;
import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.data.ExtendedProperty;
import com.google.wireless.gdata2.data.StringUtils;
import com.google.wireless.gdata2.parser.ParseException;
import java.util.Enumeration;
import java.util.Vector;

public class ContactEntry
extends Entry {
    private String linkPhotoHref;
    private String linkPhotoType;
    private String linkPhotoEtag;
    private final Vector emailAddresses = new Vector();
    private final Vector imAddresses = new Vector();
    private final Vector phoneNumbers = new Vector();
    private final Vector postalAddresses = new Vector();
    private final Vector organizations = new Vector();
    private final Vector extendedProperties = new Vector();
    private final Vector groups = new Vector();
    private final Vector calendarLinks = new Vector();
    private final Vector events = new Vector();
    private final Vector externalIds = new Vector();
    private final Vector hobbies = new Vector();
    private final Vector jots = new Vector();
    private final Vector languages = new Vector();
    private final Vector relations = new Vector();
    private final Vector userDefinedFields = new Vector();
    private final Vector webSites = new Vector();
    private String directoryServer;
    private String gender;
    private String initials;
    private String maidenName;
    private String mileage;
    private String nickname;
    private String occupation;
    private String shortName;
    private String subject;
    private String birthday;
    private String billingInformation;
    public static final String GENDER_MALE = "male";
    public static final String GENDER_FEMALE = "female";
    public static final byte TYPE_PRIORITY_HIGH = 1;
    public static final byte TYPE_PRIORITY_NORMAL = 2;
    public static final byte TYPE_PRIORITY_LOW = 3;
    private byte priority = (byte)-1;
    public static final byte TYPE_SENSITIVITY_CONFIDENTIAL = 1;
    public static final byte TYPE_SENSITIVITY_NORMAL = 2;
    public static final byte TYPE_SENSITIVITY_PERSONAL = 3;
    public static final byte TYPE_SENSITIVITY_PRIVATE = 4;
    private byte sensitivity = (byte)-1;
    private Name name;

    public void setLinkPhoto(String href, String type, String photoEtag) {
        this.linkPhotoHref = href;
        this.linkPhotoType = type;
        this.linkPhotoEtag = photoEtag;
    }

    public String getLinkPhotoETag() {
        return this.linkPhotoEtag;
    }

    public String getLinkPhotoHref() {
        return this.linkPhotoHref;
    }

    public String getLinkPhotoType() {
        return this.linkPhotoType;
    }

    public void addEmailAddress(EmailAddress emailAddress) {
        this.emailAddresses.addElement(emailAddress);
    }

    public Vector getEmailAddresses() {
        return this.emailAddresses;
    }

    public void addImAddress(ImAddress imAddress) {
        this.imAddresses.addElement(imAddress);
    }

    public Vector getImAddresses() {
        return this.imAddresses;
    }

    public void addPostalAddress(StructuredPostalAddress postalAddress) {
        this.postalAddresses.addElement(postalAddress);
    }

    public Vector getPostalAddresses() {
        return this.postalAddresses;
    }

    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumbers.addElement(phoneNumber);
    }

    public Vector getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void addOrganization(Organization organization) {
        this.organizations.addElement(organization);
    }

    public Vector getExtendedProperties() {
        return this.extendedProperties;
    }

    public void addExtendedProperty(ExtendedProperty extendedProperty) {
        this.extendedProperties.addElement(extendedProperty);
    }

    public Vector getGroups() {
        return this.groups;
    }

    public void addGroup(GroupMembershipInfo group) {
        this.groups.addElement(group);
    }

    public Vector getOrganizations() {
        return this.organizations;
    }

    public Vector getCalendarLinks() {
        return this.calendarLinks;
    }

    public void addCalendarLink(CalendarLink calendarLink) {
        this.calendarLinks.addElement(calendarLink);
    }

    public Vector getEvents() {
        return this.events;
    }

    public void addEvent(Event event) {
        this.events.addElement(event);
    }

    public Vector getExternalIds() {
        return this.externalIds;
    }

    public void addExternalId(ExternalId externalId) {
        this.externalIds.addElement(externalId);
    }

    public Vector getHobbies() {
        return this.hobbies;
    }

    public void addHobby(String hobby) {
        this.hobbies.addElement(hobby);
    }

    public Vector getJots() {
        return this.jots;
    }

    public void addJot(Jot jot) {
        this.jots.addElement(jot);
    }

    public Vector getLanguages() {
        return this.languages;
    }

    public void addLanguage(Language language) {
        this.languages.addElement(language);
    }

    public Vector getRelations() {
        return this.relations;
    }

    public void addRelation(Relation relation) {
        this.relations.addElement(relation);
    }

    public Vector getUserDefinedFields() {
        return this.userDefinedFields;
    }

    public void addUserDefinedField(UserDefinedField userDefinedField) {
        this.userDefinedFields.addElement(userDefinedField);
    }

    public Vector getWebSites() {
        return this.webSites;
    }

    public void addWebSite(WebSite webSite) {
        this.webSites.addElement(webSite);
    }

    public String getDirectoryServer() {
        return this.directoryServer;
    }

    public void setDirectoryServer(String directoryServer) {
        this.directoryServer = directoryServer;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    public String getMaidenName() {
        return this.maidenName;
    }

    public void setMaidenName(String maidenName) {
        this.maidenName = maidenName;
    }

    public String getMileage() {
        return this.mileage;
    }

    public void setMileage(String mileage) {
        this.mileage = mileage;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public void setOccupation(String occupation) {
        this.occupation = occupation;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public byte getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(byte sensitiviy) {
        this.sensitivity = sensitiviy;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getBillingInformation() {
        return this.billingInformation;
    }

    public void setBillingInformation(String billingInformation) {
        this.billingInformation = billingInformation;
    }

    public void clear() {
        super.clear();
        this.linkPhotoHref = null;
        this.linkPhotoType = null;
        this.linkPhotoEtag = null;
        this.directoryServer = null;
        this.gender = null;
        this.initials = null;
        this.maidenName = null;
        this.mileage = null;
        this.nickname = null;
        this.occupation = null;
        this.priority = (byte)-1;
        this.sensitivity = (byte)-1;
        this.shortName = null;
        this.subject = null;
        this.birthday = null;
        this.billingInformation = null;
        this.name = null;
        this.emailAddresses.removeAllElements();
        this.imAddresses.removeAllElements();
        this.phoneNumbers.removeAllElements();
        this.postalAddresses.removeAllElements();
        this.organizations.removeAllElements();
        this.extendedProperties.removeAllElements();
        this.groups.removeAllElements();
        this.calendarLinks.removeAllElements();
        this.events.removeAllElements();
        this.externalIds.removeAllElements();
        this.hobbies.removeAllElements();
        this.jots.removeAllElements();
        this.languages.removeAllElements();
        this.relations.removeAllElements();
        this.userDefinedFields.removeAllElements();
        this.webSites.removeAllElements();
    }

    protected void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append("\n");
        sb.append("ContactEntry:");
        if (!StringUtils.isEmpty(this.linkPhotoHref)) {
            sb.append(" linkPhotoHref:").append(this.linkPhotoHref);
        }
        if (!StringUtils.isEmpty(this.linkPhotoType)) {
            sb.append(" linkPhotoType:").append(this.linkPhotoType);
        }
        if (!StringUtils.isEmpty(this.linkPhotoEtag)) {
            sb.append(" linkPhotoEtag:").append(this.linkPhotoEtag);
        }
        if (!StringUtils.isEmpty(this.directoryServer)) {
            sb.append(" directoryServer:").append(this.directoryServer);
        }
        if (!StringUtils.isEmpty(this.gender)) {
            sb.append(" gender:").append(this.gender);
        }
        if (!StringUtils.isEmpty(this.initials)) {
            sb.append(" initials:").append(this.initials);
        }
        if (!StringUtils.isEmpty(this.maidenName)) {
            sb.append(" maidenName:").append(this.maidenName);
        }
        if (!StringUtils.isEmpty(this.mileage)) {
            sb.append(" mileage:").append(this.mileage);
        }
        if (!StringUtils.isEmpty(this.nickname)) {
            sb.append(" nickname:").append(this.nickname);
        }
        if (!StringUtils.isEmpty(this.occupation)) {
            sb.append(" occupaton:").append(this.occupation);
        }
        sb.append(" priority:").append(this.priority);
        sb.append(" sensitivity:").append(this.sensitivity);
        if (!StringUtils.isEmpty(this.shortName)) {
            sb.append(" shortName:").append(this.shortName);
        }
        if (!StringUtils.isEmpty(this.subject)) {
            sb.append(" subject:").append(this.subject);
        }
        if (!StringUtils.isEmpty(this.birthday)) {
            sb.append(" birthday:").append(this.birthday);
        }
        if (!StringUtils.isEmpty(this.billingInformation)) {
            sb.append(" billingInformation:").append(this.billingInformation);
        }
        sb.append("\n");
        if (this.name != null) {
            this.name.toString(sb);
            sb.append("\n");
        }
        Enumeration iter = this.emailAddresses.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((EmailAddress)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.imAddresses.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((ImAddress)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.postalAddresses.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((StructuredPostalAddress)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.phoneNumbers.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((PhoneNumber)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.organizations.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((Organization)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.extendedProperties.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((ExtendedProperty)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.groups.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((GroupMembershipInfo)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.calendarLinks.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((CalendarLink)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.events.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((Event)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.externalIds.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((ExternalId)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.hobbies.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            sb.append((String)iter.nextElement());
            sb.append("\n");
        }
        iter = this.jots.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            sb.append((Jot)iter.nextElement());
            sb.append("\n");
        }
        iter = this.languages.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((Language)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.relations.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((Relation)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.userDefinedFields.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((UserDefinedField)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
        iter = this.webSites.elements();
        while (iter.hasMoreElements()) {
            sb.append("  ");
            ((WebSite)iter.nextElement()).toString(sb);
            sb.append("\n");
        }
    }

    public void validate() throws ParseException {
        super.validate();
        if (this.gender != null && !GENDER_FEMALE.equals(this.gender) && !GENDER_MALE.equals(this.gender)) {
            throw new ParseException(String.format("invalid gender \"%s\", must be one of \"%s\" or \"%s\"", this.gender, GENDER_FEMALE, GENDER_MALE));
        }
        Enumeration iter = this.emailAddresses.elements();
        while (iter.hasMoreElements()) {
            ((EmailAddress)iter.nextElement()).validate();
        }
        iter = this.imAddresses.elements();
        while (iter.hasMoreElements()) {
            ((ImAddress)iter.nextElement()).validate();
        }
        iter = this.postalAddresses.elements();
        while (iter.hasMoreElements()) {
            ((StructuredPostalAddress)iter.nextElement()).validate();
        }
        iter = this.phoneNumbers.elements();
        while (iter.hasMoreElements()) {
            ((PhoneNumber)iter.nextElement()).validate();
        }
        iter = this.organizations.elements();
        while (iter.hasMoreElements()) {
            ((Organization)iter.nextElement()).validate();
        }
        iter = this.extendedProperties.elements();
        while (iter.hasMoreElements()) {
            ((ExtendedProperty)iter.nextElement()).validate();
        }
        iter = this.groups.elements();
        while (iter.hasMoreElements()) {
            ((GroupMembershipInfo)iter.nextElement()).validate();
        }
        iter = this.calendarLinks.elements();
        while (iter.hasMoreElements()) {
            ((CalendarLink)iter.nextElement()).validate();
        }
        iter = this.events.elements();
        while (iter.hasMoreElements()) {
            ((Event)iter.nextElement()).validate();
        }
        iter = this.externalIds.elements();
        while (iter.hasMoreElements()) {
            ((ExternalId)iter.nextElement()).validate();
        }
        iter = this.languages.elements();
        while (iter.hasMoreElements()) {
            ((Language)iter.nextElement()).validate();
        }
        iter = this.relations.elements();
        while (iter.hasMoreElements()) {
            ((Relation)iter.nextElement()).validate();
        }
        iter = this.userDefinedFields.elements();
        while (iter.hasMoreElements()) {
            ((UserDefinedField)iter.nextElement()).validate();
        }
        iter = this.webSites.elements();
        while (iter.hasMoreElements()) {
            ((WebSite)iter.nextElement()).validate();
        }
    }
}

