/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata2.calendar.parser.xml;

import com.google.wireless.gdata2.calendar.data.CalendarEntry;
import com.google.wireless.gdata2.calendar.data.EventEntry;
import com.google.wireless.gdata2.calendar.parser.xml.XmlCalendarsGDataParser;
import com.google.wireless.gdata2.calendar.parser.xml.XmlEventsGDataParser;
import com.google.wireless.gdata2.calendar.serializer.xml.XmlEventEntryGDataSerializer;
import com.google.wireless.gdata2.client.GDataParserFactory;
import com.google.wireless.gdata2.data.Entry;
import com.google.wireless.gdata2.parser.GDataParser;
import com.google.wireless.gdata2.parser.ParseException;
import com.google.wireless.gdata2.parser.xml.XmlParserFactory;
import com.google.wireless.gdata2.serializer.GDataSerializer;
import com.google.wireless.gdata2.serializer.xml.XmlBatchGDataSerializer;
import java.io.InputStream;
import java.util.Enumeration;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlCalendarGDataParserFactory
implements GDataParserFactory {
    private final XmlParserFactory xmlFactory;

    public XmlCalendarGDataParserFactory(XmlParserFactory xmlFactory) {
        this.xmlFactory = xmlFactory;
    }

    public GDataParser createCalendarsFeedParser(InputStream is) throws ParseException {
        XmlPullParser xmlParser;
        try {
            xmlParser = this.xmlFactory.createParser();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not create XmlPullParser", xppe);
        }
        return new XmlCalendarsGDataParser(is, xmlParser);
    }

    public GDataParser createParser(InputStream is) throws ParseException {
        XmlPullParser xmlParser;
        try {
            xmlParser = this.xmlFactory.createParser();
        }
        catch (XmlPullParserException xppe) {
            throw new ParseException("Could not create XmlPullParser", xppe);
        }
        return new XmlEventsGDataParser(is, xmlParser);
    }

    public GDataParser createParser(Class entryClass, InputStream is) throws ParseException {
        if (entryClass == CalendarEntry.class) {
            return this.createCalendarsFeedParser(is);
        }
        if (entryClass == EventEntry.class) {
            return this.createParser(is);
        }
        throw new IllegalArgumentException("Unknown entry class '" + entryClass.getName() + "' specified.");
    }

    public GDataSerializer createSerializer(Entry entry) {
        if (!(entry instanceof EventEntry)) {
            throw new IllegalArgumentException("Expected EventEntry!");
        }
        EventEntry eventEntry = (EventEntry)entry;
        return new XmlEventEntryGDataSerializer(this.xmlFactory, eventEntry);
    }

    public GDataSerializer createSerializer(Enumeration batch) {
        return new XmlBatchGDataSerializer(this, this.xmlFactory, batch);
    }
}

