/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.parser.xml;

import android.util.Log;
import android.util.Xml;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SimplePullParser {
    public static final String TEXT_TAG = "![CDATA[";
    private String mLogTag = null;
    private final XmlPullParser mParser;
    private Closeable source;
    private String mCurrentStartTag;

    public SimplePullParser(InputStream stream, String encoding) throws ParseException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, encoding);
            SimplePullParser.moveToStartDocument(parser);
            this.mParser = parser;
            this.mCurrentStartTag = null;
            this.source = stream;
        }
        catch (XmlPullParserException e) {
            throw new ParseException(e);
        }
    }

    public SimplePullParser(XmlPullParser parser) {
        this.mParser = parser;
        this.mCurrentStartTag = null;
        this.source = null;
    }

    public SimplePullParser(String xml) throws IOException, ParseException {
        this(new StringReader(xml));
    }

    public SimplePullParser(Reader reader) throws IOException, ParseException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(reader);
            SimplePullParser.moveToStartDocument(parser);
            this.mParser = parser;
            this.mCurrentStartTag = null;
            this.source = reader;
        }
        catch (XmlPullParserException e) {
            throw new ParseException(e);
        }
    }

    private static void moveToStartDocument(XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        if (eventType != 0) {
            throw new XmlPullParserException("Not at start of response");
        }
    }

    public void setLogTag(String logTag) {
        this.mLogTag = logTag;
    }

    public String nextTagOrText(int parentDepth, StringBuilder textBuilder) throws IOException, ParseException {
        int depth;
        int eventType;
        do {
            eventType = 0;
            try {
                eventType = this.mParser.next();
            }
            catch (XmlPullParserException e) {
                throw new ParseException(e);
            }
            depth = this.mParser.getDepth();
            this.mCurrentStartTag = null;
            if (eventType == 2 && depth == parentDepth + 1) {
                this.mCurrentStartTag = this.mParser.getName();
                if (this.mLogTag != null && Log.isLoggable((String)this.mLogTag, (int)3)) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < depth; ++i) {
                        sb.append("  ");
                    }
                    sb.append("<").append(this.mParser.getName());
                    int count = this.mParser.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        sb.append(" ");
                        sb.append(this.mParser.getAttributeName(i));
                        sb.append("=\"");
                        sb.append(this.mParser.getAttributeValue(i));
                        sb.append("\"");
                    }
                    sb.append(">");
                    Log.d((String)this.mLogTag, (String)sb.toString());
                }
                return this.mParser.getName();
            }
            if (eventType == 3 && depth == parentDepth) {
                if (this.mLogTag != null && Log.isLoggable((String)this.mLogTag, (int)3)) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < depth; ++i) {
                        sb.append("  ");
                    }
                    sb.append("</>");
                    Log.d((String)this.mLogTag, (String)sb.toString());
                }
                return null;
            }
            if (eventType != 1 || parentDepth != 0) continue;
            if (this.source != null) {
                this.source.close();
                this.source = null;
            }
            return null;
        } while (eventType != 4 || depth != parentDepth || textBuilder == null);
        String text = this.mParser.getText();
        textBuilder.append(text);
        return TEXT_TAG;
    }

    public String nextTag(int parentDepth) throws IOException, ParseException {
        return this.nextTagOrText(parentDepth, null);
    }

    public int getDepth() {
        return this.mParser.getDepth();
    }

    public void readRemainingText(int parentDepth, StringBuilder textBuilder) throws IOException, ParseException {
        while (this.nextTagOrText(parentDepth, textBuilder) != null) {
        }
    }

    public int numAttributes() {
        return this.mParser.getAttributeCount();
    }

    public String getAttributeName(int i) {
        return this.mParser.getAttributeName(i);
    }

    public String getAttributeNamespace(int i) {
        return this.mParser.getAttributeNamespace(i);
    }

    public String getStringAttribute(String namespace, String name, String defaultValue) {
        String value = this.mParser.getAttributeValue(namespace, name);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public String getStringAttribute(String namespace, String name) throws ParseException {
        String value = this.mParser.getAttributeValue(namespace, name);
        if (null == value) {
            throw new ParseException("missing '" + name + "' attribute on '" + this.mCurrentStartTag + "' element");
        }
        return value;
    }

    public int getIntAttribute(String namespace, String name, int defaultValue) throws ParseException {
        String value = this.mParser.getAttributeValue(namespace, name);
        if (null == value) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse '" + value + "' as an integer");
        }
    }

    public int getIntAttribute(String namespace, String name) throws ParseException {
        String value = this.getStringAttribute(namespace, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse '" + value + "' as an integer");
        }
    }

    public long getLongAttribute(String namespace, String name, long defaultValue) throws ParseException {
        String value = this.mParser.getAttributeValue(namespace, name);
        if (null == value) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse '" + value + "' as a long");
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long getLongAttribute(String namespace, String name) throws ParseException {
        String value = this.getStringAttribute(namespace, name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse '" + value + "' as a long");
        }
    }

    public static final class ParseException
    extends Exception {
        public ParseException(String message) {
            super(message);
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public ParseException(Throwable cause) {
            super(cause);
        }
    }
}

