/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gsf;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.provider.BaseColumns;

public class SubscribedFeeds {
    private SubscribedFeeds() {
    }

    public static Uri addFeed(ContentResolver resolver, String feed, Account account, String authority, String service) {
        ContentValues values = new ContentValues();
        values.put("feed", feed);
        values.put("_sync_account", account.name);
        values.put("_sync_account_type", account.type);
        values.put("authority", authority);
        values.put("service", service);
        return resolver.insert(Feeds.CONTENT_URI, values);
    }

    public static int deleteFeed(ContentResolver resolver, String feed, Account account, String authority) {
        StringBuilder where = new StringBuilder();
        where.append("_sync_account=?");
        where.append(" AND _sync_account_type=?");
        where.append(" AND feed=?");
        where.append(" AND authority=?");
        return resolver.delete(Feeds.CONTENT_URI, where.toString(), new String[]{account.name, account.type, feed, authority});
    }

    public static int deleteFeeds(ContentResolver resolver, Account account, String authority) {
        StringBuilder where = new StringBuilder();
        where.append("_sync_account=?");
        where.append(" AND _sync_account_type=?");
        where.append(" AND authority=?");
        return resolver.delete(Feeds.CONTENT_URI, where.toString(), new String[]{account.name, account.type, authority});
    }

    public static final class Accounts
    implements BaseColumns,
    AccountColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://subscribedfeeds/accounts");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/subscribedfeedaccounts";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/subscribedfeedaccount";
        public static final String DEFAULT_SORT_ORDER = "_SYNC_ACCOUNT_TYPE, _SYNC_ACCOUNT ASC";

        private Accounts() {
        }

        public static Cursor query(ContentResolver cr, String[] projection) {
            return cr.query(CONTENT_URI, projection, null, null, DEFAULT_SORT_ORDER);
        }

        public static Cursor query(ContentResolver cr, String[] projection, String where, String orderBy) {
            return cr.query(CONTENT_URI, projection, where, null, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
        }
    }

    public static interface AccountColumns {
        public static final String _SYNC_ACCOUNT = "_sync_account";
        public static final String _SYNC_ACCOUNT_TYPE = "_sync_account_type";
    }

    public static final class Feeds
    implements BaseColumns,
    FeedColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://subscribedfeeds/feeds");
        public static final Uri DELETED_CONTENT_URI = Uri.parse((String)"content://subscribedfeeds/deleted_feeds");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/subscribedfeeds";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/subscribedfeed";
        public static final String DEFAULT_SORT_ORDER = "_SYNC_ACCOUNT_TYPE, _SYNC_ACCOUNT ASC";

        private Feeds() {
        }

        public static Cursor query(ContentResolver cr, String[] projection) {
            return cr.query(CONTENT_URI, projection, null, null, DEFAULT_SORT_ORDER);
        }

        public static Cursor query(ContentResolver cr, String[] projection, String where, String[] whereArgs, String orderBy) {
            return cr.query(CONTENT_URI, projection, where, whereArgs, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
        }
    }

    public static interface FeedColumns {
        public static final String FEED = "feed";
        public static final String AUTHORITY = "authority";
        public static final String SERVICE = "service";
        public static final String _SYNC_ACCOUNT = "_sync_account";
        public static final String _SYNC_ACCOUNT_TYPE = "_sync_account_type";
        public static final String _SYNC_ID = "_sync_id";
        public static final String _SYNC_TIME = "_sync_time";
        public static final String _SYNC_VERSION = "_sync_version";
        public static final String _SYNC_LOCAL_ID = "_sync_local_id";
        public static final String _SYNC_MARK = "_sync_mark";
        public static final String _SYNC_DIRTY = "_sync_dirty";
    }
}

