/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gsf;

import android.webkit.CookieManager;

public class SAMLUtils {
    private static final String DEFAULT_HOSTED_BASE_PATH = "https://www.google.com";
    private static final String TEST_GAIA_HOSTED_BASE_PATH = "http://dasher-qa.corp.google.com";
    private static final String HOSTED_PREFIX = "/a/";

    private SAMLUtils() {
    }

    private static final String getHostedBaseUrl(boolean useTestGaia) {
        return (useTestGaia ? TEST_GAIA_HOSTED_BASE_PATH : DEFAULT_HOSTED_BASE_PATH) + HOSTED_PREFIX;
    }

    private static String makeHostedGaiaBasePath(boolean useTestGaia, String domainName) {
        return SAMLUtils.getHostedBaseUrl(useTestGaia) + domainName + "/";
    }

    public static String makeWebLoginStartUrl(boolean useTestGaia, String domainName) {
        return SAMLUtils.makeHostedGaiaBasePath(useTestGaia, domainName) + "ServiceLogin";
    }

    private static String makeHIDCookieExtractionPath(boolean useTestGaia, String domainName) {
        return SAMLUtils.makeHostedGaiaBasePath(useTestGaia, domainName);
    }

    private static String makeLSIDCookieExtractionPath(boolean useTestGaia, String domainName) {
        String url = useTestGaia ? TEST_GAIA_HOSTED_BASE_PATH : DEFAULT_HOSTED_BASE_PATH;
        return url + "/accounts/";
    }

    public static String extractHID(CookieManager cookieManager, String domainName) {
        String HIDExtractionPath = SAMLUtils.makeHIDCookieExtractionPath(false, domainName);
        String HID = SAMLUtils.extractCookie(cookieManager.getCookie(HIDExtractionPath), "HID");
        if (HID.length() == 0) {
            String LSIDExtractionPath = SAMLUtils.makeLSIDCookieExtractionPath(false, domainName);
            HID = SAMLUtils.extractCookie(cookieManager.getCookie(LSIDExtractionPath), "LSID");
        }
        return HID;
    }

    private static String extractCookie(String cookieString, String name) {
        String[] cookieFragments;
        if (cookieString == null) {
            return "";
        }
        for (String cookieFragment : cookieFragments = cookieString.split("; ")) {
            String[] nameValue = cookieFragment.split("=");
            if (nameValue.length != 2 || !nameValue[0].equalsIgnoreCase(name)) continue;
            return nameValue[1];
        }
        return "";
    }
}

