/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gsf;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gservices {
    public static final String TAG = "Gservices";
    public static final String OVERRIDE_ACTION = "com.google.gservices.intent.action.GSERVICES_OVERRIDE";
    public static final String CHANGED_ACTION = "com.google.gservices.intent.action.GSERVICES_CHANGED";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.gsf.gservices");
    public static final Uri CONTENT_PREFIX_URI = Uri.parse((String)"content://com.google.android.gsf.gservices/prefix");
    private static ContentResolver sResolver;
    private static HashMap<String, String> sCache;
    private static Object sVersionToken;
    private static final Pattern TRUE_PATTERN;
    private static final Pattern FALSE_PATTERN;

    private static void ensureCacheInitializedLocked(final ContentResolver cr) {
        if (sCache == null) {
            sCache = new HashMap();
            sVersionToken = new Object();
            sResolver = cr;
            new Thread(){

                public void run() {
                    Looper.prepare();
                    cr.registerContentObserver(CONTENT_URI, true, new ContentObserver(new Handler(Looper.myLooper())){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onChange(boolean selfChange) {
                            Class<Gservices> clazz = Gservices.class;
                            synchronized (Gservices.class) {
                                sCache.clear();
                                sVersionToken = new Object();
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                    Looper.loop();
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(ContentResolver cr, String key, String defValue) {
        Class<Gservices> clazz = Gservices.class;
        synchronized (Gservices.class) {
            Gservices.ensureCacheInitializedLocked(cr);
            Object version = sVersionToken;
            if (sCache.containsKey(key)) {
                String value = sCache.get(key);
                String string = value != null ? value : defValue;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return string;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Cursor cursor = sResolver.query(CONTENT_URI, null, null, new String[]{key}, null);
            if (cursor == null) {
                return defValue;
            }
            try {
                cursor.moveToFirst();
                String value = cursor.getString(1);
                Object object = Gservices.class;
                synchronized (Gservices.class) {
                    if (version == sVersionToken) {
                        sCache.put(key, value);
                    }
                    // ** MonitorExit[var6_8] (shouldn't be in output)
                    object = value != null ? value : defValue;
                    return object;
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    public static String getString(ContentResolver cr, String key) {
        return Gservices.getString(cr, key, null);
    }

    public static int getInt(ContentResolver cr, String key, int defValue) {
        int value;
        String valString = Gservices.getString(cr, key);
        try {
            value = valString != null ? Integer.parseInt(valString) : defValue;
        }
        catch (NumberFormatException e) {
            value = defValue;
        }
        return value;
    }

    public static long getLong(ContentResolver cr, String key, long defValue) {
        long value;
        String valString = Gservices.getString(cr, key);
        try {
            value = valString != null ? Long.parseLong(valString) : defValue;
        }
        catch (NumberFormatException e) {
            value = defValue;
        }
        return value;
    }

    public static boolean getBoolean(ContentResolver cr, String key, boolean defValue) {
        String valString = Gservices.getString(cr, key);
        if (valString == null || valString.equals("")) {
            return defValue;
        }
        if (TRUE_PATTERN.matcher(valString).matches()) {
            return true;
        }
        if (FALSE_PATTERN.matcher(valString).matches()) {
            return false;
        }
        Log.w((String)TAG, (String)("attempt to read gservices key " + key + " (value \"" + valString + "\") as boolean"));
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getStringsByPrefix(ContentResolver cr, String ... prefixes) {
        Cursor c = cr.query(CONTENT_PREFIX_URI, null, null, prefixes, null);
        TreeMap<String, String> out = new TreeMap<String, String>();
        if (c == null) {
            return out;
        }
        try {
            while (c.moveToNext()) {
                out.put(c.getString(0), c.getString(1));
            }
        }
        finally {
            c.close();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getVersionToken(ContentResolver cr) {
        Class<Gservices> clazz = Gservices.class;
        synchronized (Gservices.class) {
            Gservices.ensureCacheInitializedLocked(cr);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sVersionToken;
        }
    }

    static {
        TRUE_PATTERN = Pattern.compile("^(1|true|t|on|yes|y)$", 2);
        FALSE_PATTERN = Pattern.compile("^(0|false|f|off|no|n)$", 2);
    }
}

