/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common;

import android.content.ContentResolver;
import android.content.Context;
import android.net.http.SslError;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.google.android.gsf.Gservices;
import java.util.Locale;

public class GoogleWebContentHelper {
    private Context mContext;
    private String mSecureUrl;
    private String mPrettyUrl;
    private String mUnsuccessfulMessage;
    private String mLoadingMessage = null;
    private FrameLayout mLayout;
    private WebView mWebView;
    private View mProgressBar;
    private TextView mTextView;
    private final float mDipScale;
    private boolean mReceivedResponse;

    public GoogleWebContentHelper(Context context) {
        this.mContext = context;
        this.mDipScale = this.mContext.getResources().getDisplayMetrics().density;
    }

    public GoogleWebContentHelper setUrlsFromGservices(String secureSetting, String prettySetting) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        this.mSecureUrl = GoogleWebContentHelper.fillUrl(Gservices.getString(contentResolver, secureSetting), this.mContext);
        this.mPrettyUrl = GoogleWebContentHelper.fillUrl(Gservices.getString(contentResolver, prettySetting), this.mContext);
        return this;
    }

    public GoogleWebContentHelper setUrls(String secureUrl, String prettyUrl) {
        this.mSecureUrl = GoogleWebContentHelper.fillUrl(secureUrl, this.mContext);
        this.mPrettyUrl = GoogleWebContentHelper.fillUrl(prettyUrl, this.mContext);
        return this;
    }

    public GoogleWebContentHelper setUnsuccessfulMessage(String message) {
        Locale locale = this.mContext.getResources().getConfiguration().locale;
        this.mUnsuccessfulMessage = String.format(locale, message, this.mPrettyUrl);
        return this;
    }

    public GoogleWebContentHelper setLoadingMessage(String message) {
        this.mLoadingMessage = message;
        return this;
    }

    public GoogleWebContentHelper loadUrl() {
        this.ensureViews();
        this.mWebView.loadUrl(this.mSecureUrl);
        return this;
    }

    public GoogleWebContentHelper loadDataWithFailUrl(String base, String data, String mimeType, String encoding, String failUrl) {
        this.ensureViews();
        this.mWebView.loadDataWithBaseURL(base, data, mimeType, encoding, failUrl);
        return this;
    }

    public boolean handleKey(KeyEvent event) {
        if (event.getKeyCode() == 4 && event.getAction() == 0 && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return false;
    }

    public ViewGroup getLayout() {
        this.ensureViews();
        return this.mLayout;
    }

    private synchronized void ensureViews() {
        if (this.mLayout == null) {
            this.initializeViews();
        }
    }

    private static String fillUrl(String url, Context context) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        Locale locale = Locale.getDefault();
        String tmp = locale.getLanguage() + "_" + locale.getCountry().toLowerCase();
        return String.format(url, tmp);
    }

    private void initializeViews() {
        FrameLayout.LayoutParams fl_lp;
        this.mLayout = new FrameLayout(this.mContext);
        this.mLayout.setForegroundGravity(17);
        int eightDips = (int)(8.0f * this.mDipScale + 0.5f);
        int tenDips = (int)(10.0f * this.mDipScale + 0.5f);
        int twelveDips = (int)(12.0f * this.mDipScale + 0.5f);
        if (this.mLoadingMessage != null) {
            fl_lp = new FrameLayout.LayoutParams(-2, -2);
            fl_lp.gravity = 17;
            LinearLayout ll = new LinearLayout(this.mContext);
            ll.setBaselineAligned(false);
            ll.setPadding(eightDips, tenDips, eightDips, tenDips);
            this.mLayout.addView((View)ll, (ViewGroup.LayoutParams)fl_lp);
            LinearLayout.LayoutParams ll_lp = new LinearLayout.LayoutParams(-2, -2);
            ll_lp.rightMargin = twelveDips;
            ProgressBar pb = new ProgressBar(this.mContext);
            pb.setIndeterminate(true);
            ll.addView((View)pb, (ViewGroup.LayoutParams)ll_lp);
            ll_lp = new LinearLayout.LayoutParams(-2, -2);
            ll_lp.gravity = 16;
            TextView tv = new TextView(this.mContext);
            tv.setText((CharSequence)this.mLoadingMessage);
            ll.addView((View)tv, (ViewGroup.LayoutParams)ll_lp);
            this.mProgressBar = ll;
        } else {
            fl_lp = new FrameLayout.LayoutParams(-2, -2);
            fl_lp.gravity = 17;
            ProgressBar pb = new ProgressBar(this.mContext);
            pb.setIndeterminate(true);
            this.mLayout.addView((View)pb, (ViewGroup.LayoutParams)fl_lp);
            this.mProgressBar = pb;
        }
        fl_lp = new FrameLayout.LayoutParams(-1, -1);
        this.mWebView = new WebView(this.mContext);
        this.mWebView.setVisibility(4);
        this.mWebView.getSettings().setCacheMode(2);
        this.mWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
        this.mLayout.addView((View)this.mWebView, (ViewGroup.LayoutParams)fl_lp);
        fl_lp = new FrameLayout.LayoutParams(-2, -2);
        fl_lp.gravity = 17;
        this.mTextView = new TextView(this.mContext);
        this.mTextView.setVisibility(8);
        this.mTextView.setPadding(tenDips, tenDips, tenDips, tenDips);
        this.mTextView.setText((CharSequence)this.mUnsuccessfulMessage);
        this.mLayout.addView((View)this.mTextView, (ViewGroup.LayoutParams)fl_lp);
    }

    private synchronized void handleWebViewCompletion(boolean success) {
        if (this.mReceivedResponse) {
            return;
        }
        this.mReceivedResponse = true;
        ((ViewGroup)this.mProgressBar.getParent()).removeView(this.mProgressBar);
        TextView goneView = success ? this.mTextView : this.mWebView;
        ((ViewGroup)goneView.getParent()).removeView((View)goneView);
        WebView visibleView = success ? this.mWebView : this.mTextView;
        visibleView.setVisibility(0);
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            GoogleWebContentHelper.this.handleWebViewCompletion(true);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            GoogleWebContentHelper.this.handleWebViewCompletion(false);
        }

        public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
            GoogleWebContentHelper.this.handleWebViewCompletion(false);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            GoogleWebContentHelper.this.handleWebViewCompletion(false);
        }

        public void onTooManyRedirects(WebView view, Message cancelMsg, Message continueMsg) {
            GoogleWebContentHelper.this.handleWebViewCompletion(false);
        }
    }
}

