/*
 * Decompiled with CFR 0.152.
 */
package com.android.common;

import android.util.EventLog;

public class GoogleLogTags {
    public static final int SYSTEM_UPDATE = 201001;
    public static final int SYSTEM_UPDATE_USER = 201002;
    public static final int VENDING_RECONSTRUCT = 202001;
    public static final int SYNC_DETAILS = 203001;
    public static final int GOOGLE_HTTP_REQUEST = 203002;
    public static final int GTALKSERVICE = 204001;
    public static final int GTALK_CONNECTION = 204002;
    public static final int GTALK_CONN_CLOSE = 204003;
    public static final int GTALK_HEARTBEAT_RESET = 204004;
    public static final int PUSH_MESSAGING = 204005;
    public static final int SETUP_SERVER_TIMEOUT = 205001;
    public static final int SETUP_REQUIRED_CAPTCHA = 205002;
    public static final int SETUP_IO_ERROR = 205003;
    public static final int SETUP_SERVER_ERROR = 205004;
    public static final int SETUP_RETRIES_EXHAUSTED = 205005;
    public static final int SETUP_NO_DATA_NETWORK = 205006;
    public static final int SETUP_COMPLETED = 205007;
    public static final int GLS_ACCOUNT_TRIED = 205008;
    public static final int GLS_ACCOUNT_SAVED = 205009;
    public static final int GLS_AUTHENTICATE = 205010;
    public static final int GOOGLE_MAIL_SWITCH = 205011;

    private GoogleLogTags() {
    }

    public static void writeSystemUpdate(int status, int downloadResult, long bytes, String url) {
        EventLog.writeEvent((int)201001, (Object[])new Object[]{status, downloadResult, bytes, url});
    }

    public static void writeSystemUpdateUser(String action) {
        EventLog.writeEvent((int)201002, (String)action);
    }

    public static void writeVendingReconstruct(int changes) {
        EventLog.writeEvent((int)202001, (int)changes);
    }

    public static void writeSyncDetails(String authority, int send, int recv, String details) {
        EventLog.writeEvent((int)203001, (Object[])new Object[]{authority, send, recv, details});
    }

    public static void writeGoogleHttpRequest(long elapsed, int status, String appname, int reused) {
        EventLog.writeEvent((int)203002, (Object[])new Object[]{elapsed, status, appname, reused});
    }

    public static void writeGtalkservice(int eventtype) {
        EventLog.writeEvent((int)204001, (int)eventtype);
    }

    public static void writeGtalkConnection(int status) {
        EventLog.writeEvent((int)204002, (int)status);
    }

    public static void writeGtalkConnClose(int status, int duration) {
        EventLog.writeEvent((int)204003, (Object[])new Object[]{status, duration});
    }

    public static void writeGtalkHeartbeatReset(int intervalAndNt, String ip) {
        EventLog.writeEvent((int)204004, (Object[])new Object[]{intervalAndNt, ip});
    }

    public static void writePushMessaging(int packetType, String persistentId, int streamId, int lastStreamId) {
        EventLog.writeEvent((int)204005, (Object[])new Object[]{packetType, persistentId, streamId, lastStreamId});
    }

    public static void writeSetupServerTimeout() {
        EventLog.writeEvent((int)205001, (Object[])new Object[0]);
    }

    public static void writeSetupRequiredCaptcha(String action) {
        EventLog.writeEvent((int)205002, (String)action);
    }

    public static void writeSetupIoError(String status) {
        EventLog.writeEvent((int)205003, (String)status);
    }

    public static void writeSetupServerError() {
        EventLog.writeEvent((int)205004, (Object[])new Object[0]);
    }

    public static void writeSetupRetriesExhausted() {
        EventLog.writeEvent((int)205005, (Object[])new Object[0]);
    }

    public static void writeSetupNoDataNetwork() {
        EventLog.writeEvent((int)205006, (Object[])new Object[0]);
    }

    public static void writeSetupCompleted() {
        EventLog.writeEvent((int)205007, (Object[])new Object[0]);
    }

    public static void writeGlsAccountTried(int status) {
        EventLog.writeEvent((int)205008, (int)status);
    }

    public static void writeGlsAccountSaved(int status) {
        EventLog.writeEvent((int)205009, (int)status);
    }

    public static void writeGlsAuthenticate(int status, String service) {
        EventLog.writeEvent((int)205010, (Object[])new Object[]{status, service});
    }

    public static void writeGoogleMailSwitch(int direction) {
        EventLog.writeEvent((int)205011, (int)direction);
    }
}

