/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json.rpc2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.Json;
import com.google.api.client.json.JsonHttpContent;
import com.google.api.client.json.rpc2.JsonRpcRequest;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonRpcHttpTransport {
    public GenericUrl rpcServerUrl;
    public HttpTransport transport = new HttpTransport();
    public String contentType;
    public String accept = this.contentType = "application/json-rpc";

    public HttpRequest buildPostRequest(JsonRpcRequest request) {
        return this.internalExecute(request);
    }

    public HttpRequest buildPostRequest(List<JsonRpcRequest> requests) {
        return this.internalExecute(requests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest buildGetRequest(JsonRpcRequest request) throws IOException {
        HttpTransport transport = this.transport;
        HttpRequest httpRequest = transport.buildGetRequest();
        GenericUrl url = httpRequest.url = this.rpcServerUrl.clone();
        url.set("method", request.method);
        url.set("id", request.id);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        JsonGenerator generator = Json.JSON_FACTORY.createJsonGenerator((OutputStream)byteStream, JsonEncoding.UTF8);
        try {
            Json.serialize(generator, request.params);
        }
        finally {
            generator.close();
        }
        url.set("params", Strings.fromBytesUtf8(Base64.encode(byteStream.toByteArray())));
        return httpRequest;
    }

    private HttpRequest internalExecute(Object data) {
        HttpTransport transport = this.transport;
        HttpRequest httpRequest = transport.buildPostRequest();
        httpRequest.url = this.rpcServerUrl;
        JsonHttpContent content = new JsonHttpContent();
        content.contentType = this.contentType;
        httpRequest.headers.accept = this.accept;
        content.data = data;
        httpRequest.content = content;
        return httpRequest;
    }
}

