/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.Json;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonHttpParser
implements HttpParser {
    public String contentType = "application/json";

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        return Json.parseAndClose(JsonHttpParser.parserForResponse(response), dataClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonParser parserForResponse(HttpResponse response) throws IOException {
        InputStream content = response.getContent();
        try {
            JsonParser parser = Json.JSON_FACTORY.createJsonParser(content);
            parser.nextToken();
            content = null;
            JsonParser jsonParser = parser;
            return jsonParser;
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }
}

