/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.Json;
import com.google.api.client.json.JsonHttpParser;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonCParser
extends JsonHttpParser {
    @Override
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        return Json.parseAndClose(JsonCParser.parserForResponse(response), dataClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonParser parserForResponse(HttpResponse response) throws IOException {
        String contentType = response.contentType;
        if (contentType == null || !contentType.startsWith("application/json")) {
            throw new IllegalArgumentException("Wrong content type: expected <application/json> but got <" + contentType + ">");
        }
        boolean failed = true;
        JsonParser parser = JsonHttpParser.parserForResponse(response);
        try {
            Json.skipToKey(parser, response.isSuccessStatusCode ? "data" : "error");
            if (parser.getCurrentToken() == JsonToken.END_OBJECT) {
                throw new IllegalArgumentException("data key not found");
            }
            failed = false;
            JsonParser jsonParser = parser;
            return jsonParser;
        }
        finally {
            if (failed) {
                parser.close();
            }
        }
    }
}

