/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.accounts;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.google.android.accounts.Account;
import com.google.android.accounts.AccountManager;
import com.google.android.accounts.AccountManagerCallback;
import com.google.android.accounts.AccountManagerFuture;
import com.google.android.accounts.AuthenticatorException;
import com.google.android.accounts.OperationCanceledException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StandardAccountManager
extends AccountManager {
    private final android.accounts.AccountManager mManager;

    private static Account convertAccount(android.accounts.Account account) {
        return new Account(account.name, account.type);
    }

    private static Account[] convertAccountArray(android.accounts.Account[] accounts) {
        Account[] array = new Account[accounts.length];
        for (int i = 0; i < accounts.length; ++i) {
            array[i] = StandardAccountManager.convertAccount(accounts[i]);
        }
        return array;
    }

    private static android.accounts.Account convertAccount(Account account) {
        return new android.accounts.Account(account.name, account.type);
    }

    private static <V> AccountManagerFuture<V> convertFuture(final android.accounts.AccountManagerFuture<V> future) {
        return new AccountManagerFuture<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public V getResult(long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
                try {
                    return future.getResult(timeout, unit);
                }
                catch (android.accounts.AuthenticatorException e) {
                    throw new AuthenticatorException(e);
                }
                catch (android.accounts.OperationCanceledException e) {
                    throw new OperationCanceledException(e);
                }
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public V getResult() throws OperationCanceledException, IOException, AuthenticatorException {
                try {
                    return future.getResult();
                }
                catch (android.accounts.AuthenticatorException e) {
                    throw new AuthenticatorException(e);
                }
                catch (android.accounts.OperationCanceledException e) {
                    throw new OperationCanceledException(e);
                }
            }
        };
    }

    private static AccountManagerFuture<Account[]> convertAccountArrayFuture(final android.accounts.AccountManagerFuture<android.accounts.Account[]> future) {
        return new AccountManagerFuture<Account[]>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public Account[] getResult(long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
                try {
                    return StandardAccountManager.convertAccountArray((android.accounts.Account[])future.getResult(timeout, unit));
                }
                catch (android.accounts.AuthenticatorException e) {
                    throw new AuthenticatorException(e);
                }
                catch (android.accounts.OperationCanceledException e) {
                    throw new OperationCanceledException(e);
                }
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public Account[] getResult() throws OperationCanceledException, IOException, AuthenticatorException {
                try {
                    return StandardAccountManager.convertAccountArray((android.accounts.Account[])future.getResult());
                }
                catch (android.accounts.AuthenticatorException e) {
                    throw new AuthenticatorException(e);
                }
                catch (android.accounts.OperationCanceledException e) {
                    throw new OperationCanceledException(e);
                }
            }
        };
    }

    private static <V> android.accounts.AccountManagerCallback<V> convertCallback(final AccountManagerCallback<V> callback) {
        if (callback != null) {
            return new android.accounts.AccountManagerCallback<V>(){

                public void run(android.accounts.AccountManagerFuture<V> future) {
                    callback.run(StandardAccountManager.convertFuture(future));
                }
            };
        }
        return null;
    }

    private static android.accounts.AccountManagerCallback<android.accounts.Account[]> convertAccountArrayCallback(final AccountManagerCallback<Account[]> callback) {
        if (callback != null) {
            return new android.accounts.AccountManagerCallback<android.accounts.Account[]>(){

                public void run(android.accounts.AccountManagerFuture<android.accounts.Account[]> future) {
                    callback.run(StandardAccountManager.convertAccountArrayFuture((android.accounts.AccountManagerFuture<android.accounts.Account[]>)future));
                }
            };
        }
        return null;
    }

    public StandardAccountManager(Context context) {
        super(context);
        this.mManager = android.accounts.AccountManager.get((Context)context);
    }

    @Override
    public Account[] getAccountsByType(String type) {
        return StandardAccountManager.convertAccountArray(this.mManager.getAccountsByType(type));
    }

    @Override
    public AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(final String type, String[] features, AccountManagerCallback<Account[]> callback, Handler handler) {
        if (features == null || features.length == 0) {
            return new AccountManager.Future2Task<Account[]>(new Callable<Account[]>(){

                @Override
                public Account[] call() {
                    return StandardAccountManager.this.getAccountsByType(type);
                }
            }, handler, callback).start();
        }
        return StandardAccountManager.convertAccountArrayFuture((android.accounts.AccountManagerFuture<android.accounts.Account[]>)this.mManager.getAccountsByTypeAndFeatures(type, features, StandardAccountManager.convertAccountArrayCallback(callback), handler));
    }

    @Override
    public AccountManagerFuture<Bundle> getAuthToken(Account account, String authTokenType, boolean notifyAuthFailure, AccountManagerCallback<Bundle> callback, Handler handler) {
        return StandardAccountManager.convertFuture(this.mManager.getAuthToken(StandardAccountManager.convertAccount(account), authTokenType, notifyAuthFailure, StandardAccountManager.convertCallback(callback), handler));
    }

    @Override
    public AccountManagerFuture<Bundle> addAccount(String accountType, String authTokenType, String[] requiredFeatures, Bundle addAccountOptions, Void activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (activity != null) {
            throw new RuntimeException("Activity parameter is not supported");
        }
        return StandardAccountManager.convertFuture(this.mManager.addAccount(accountType, authTokenType, requiredFeatures, addAccountOptions, null, StandardAccountManager.convertCallback(callback), handler));
    }

    @Override
    public boolean addAccountExplicitly(Account account, String password, Bundle extras) {
        return this.mManager.addAccountExplicitly(StandardAccountManager.convertAccount(account), password, extras);
    }

    @Override
    public AccountManagerFuture<Boolean> removeAccount(Account account, AccountManagerCallback<Boolean> callback, Handler handler) {
        return StandardAccountManager.convertFuture(this.mManager.removeAccount(StandardAccountManager.convertAccount(account), StandardAccountManager.convertCallback(callback), handler));
    }

    @Override
    public void invalidateAuthToken(String accountType, String authToken) {
        this.mManager.invalidateAuthToken(accountType, authToken);
    }
}

