/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.accounts;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;

abstract class IntentService
extends Service {
    private volatile Looper mServiceLooper;
    private volatile ServiceHandler mServiceHandler;
    private final String mName;
    private final int mPriority;

    public IntentService(String name) {
        this.mName = name;
        this.mPriority = 0;
    }

    public IntentService(String name, int priority) {
        this.mName = name;
        this.mPriority = priority;
    }

    public void onCreate() {
        super.onCreate();
        HandlerThread thread = new HandlerThread("IntentService[" + this.mName + "]", this.mPriority);
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
        Message msg = this.mServiceHandler.obtainMessage();
        msg.arg1 = startId;
        msg.obj = intent;
        this.mServiceHandler.sendMessage(msg);
    }

    public void onDestroy() {
        this.mServiceLooper.quit();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected abstract void onHandleIntent(Intent var1);

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            IntentService.this.onHandleIntent((Intent)msg.obj);
            IntentService.this.stopSelf(msg.arg1);
        }
    }
}

