/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.accounts;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.util.Log;
import com.google.android.accounts.Account;
import com.google.android.accounts.ContentSyncer;
import com.google.android.accounts.DatabaseAccountManager;
import com.google.android.accounts.DatabaseAuthenticator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseContentSyncer
extends ContentSyncer {
    private static final String LOG_TAG = "DatabaseContentSyncer";
    private static final String NAMESPACE = "http://schemas.android.com/apk/res/android";
    private Context mContext;
    private Map<String, DatabaseAuthenticator> mAuthenticators;

    private static final void beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    public DatabaseContentSyncer(Context context) {
        this.mContext = context;
        this.mAuthenticators = DatabaseAccountManager.createDatabaseAuthenticators(context);
    }

    private DatabaseAuthenticator getAuthenticator(String type) {
        return this.mAuthenticators.get(type);
    }

    @Override
    public void setIsSyncable(Account account, String authority, int syncable) {
        if (account == null || account.name == null || account.type == null || authority == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public int getIsSyncable(Account account, String authority) {
        if (account == null || account.name == null || account.type == null || authority == null) {
            throw new NullPointerException();
        }
        return 1;
    }

    @Override
    public void setSyncAutomatically(Account account, String authority, boolean sync) {
        if (account == null || account.name == null || account.type == null || authority == null) {
            throw new NullPointerException();
        }
        DatabaseAuthenticator authenticator = this.getAuthenticator(account.type);
        if (authenticator != null) {
            authenticator.setSyncAutomatically(account, authority, sync);
        }
    }

    @Override
    public boolean getSyncAutomatically(Account account, String authority) {
        if (account == null || account.name == null || account.type == null || authority == null) {
            throw new NullPointerException();
        }
        DatabaseAuthenticator authenticator = this.getAuthenticator(account.type);
        if (authenticator != null) {
            return authenticator.getSyncAutomatically(account, authority);
        }
        return false;
    }

    private List<ResolveInfo> querySyncAdapterServices() {
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.content.SyncAdapter");
        int flags = 128;
        return pm.queryIntentServices(intent, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSync(Account account, String authority, Bundle extras) {
        if (account == null || account.name == null || account.type == null || authority == null) {
            throw new NullPointerException();
        }
        for (ResolveInfo service : this.querySyncAdapterServices()) {
            try {
                ServiceInfo info = service.serviceInfo;
                PackageManager pm = this.mContext.getPackageManager();
                Resources resources = pm.getResourcesForApplication(info.packageName);
                Bundle metaData = info.metaData;
                int resId = metaData.getInt("android.content.SyncAdapter");
                XmlResourceParser xml = resources.getXml(resId);
                try {
                    DatabaseContentSyncer.beginDocument((XmlPullParser)xml, "sync-adapter");
                    String contentAuthority = xml.getAttributeValue(NAMESPACE, "contentAuthority");
                    String accountType = xml.getAttributeValue(NAMESPACE, "accountType");
                    String supportsUploadingValue = xml.getAttributeValue(NAMESPACE, "supportsUploading");
                    boolean supportsUploading = "true".equals(supportsUploadingValue);
                    if (!contentAuthority.equals(authority) || !accountType.equals(account.type)) continue;
                    Intent serviceIntent = new Intent("android.content.SyncAdapter");
                    serviceIntent.setClassName(info.packageName, info.name);
                    serviceIntent.putExtra("com.google.android.webcursors.accounts.intent.extra.ACCOUNT_NAME", account.name);
                    serviceIntent.putExtra("com.google.android.webcursors.accounts.intent.extra.ACCOUNT_TYPE", account.type);
                    serviceIntent.putExtra("com.google.android.webcursors.accounts.intent.extra.AUTHORITY", authority);
                    serviceIntent.putExtra("com.google.android.webcursors.accounts.intent.extra.BUNDLE", extras);
                    serviceIntent.putExtra("com.google.android.webcursors.accounts.intent.extra.SUPPORTS_UPLOADING", supportsUploading);
                    this.mContext.startService(serviceIntent);
                }
                finally {
                    xml.close();
                }
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"Could not read SyncAdapter meta-data", (Throwable)e);
            }
        }
    }
}

